/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesis.clientlibrary.types;

import com.amazonaws.services.kinesis.clientlibrary.lib.checkpoint.SentinelCheckpoint;
import java.math.BigInteger;

public class ExtendedSequenceNumber
implements Comparable<ExtendedSequenceNumber> {
    private final String sequenceNumber;
    private final long subSequenceNumber;
    private static final BigInteger TRIM_HORIZON_BIG_INTEGER_VALUE = BigInteger.valueOf(-2L);
    private static final BigInteger LATEST_BIG_INTEGER_VALUE = BigInteger.valueOf(-1L);
    private static final BigInteger AT_TIMESTAMP_BIG_INTEGER_VALUE = BigInteger.valueOf(-3L);
    public static final ExtendedSequenceNumber LATEST = new ExtendedSequenceNumber(SentinelCheckpoint.LATEST.toString());
    public static final ExtendedSequenceNumber SHARD_END = new ExtendedSequenceNumber(SentinelCheckpoint.SHARD_END.toString());
    public static final ExtendedSequenceNumber TRIM_HORIZON = new ExtendedSequenceNumber(SentinelCheckpoint.TRIM_HORIZON.toString());
    public static final ExtendedSequenceNumber AT_TIMESTAMP = new ExtendedSequenceNumber(SentinelCheckpoint.AT_TIMESTAMP.toString());

    public ExtendedSequenceNumber(String sequenceNumber) {
        this(sequenceNumber, 0L);
    }

    public ExtendedSequenceNumber(String sequenceNumber, Long subSequenceNumber) {
        this.sequenceNumber = sequenceNumber;
        this.subSequenceNumber = subSequenceNumber == null ? 0L : subSequenceNumber;
    }

    @Override
    public int compareTo(ExtendedSequenceNumber extendedSequenceNumber) {
        String secondSequenceNumber = extendedSequenceNumber.getSequenceNumber();
        if (!ExtendedSequenceNumber.isDigitsOrSentinelValue(this.sequenceNumber) || !ExtendedSequenceNumber.isDigitsOrSentinelValue(secondSequenceNumber)) {
            throw new IllegalArgumentException("Expected a sequence number or a sentinel checkpoint value but received: first=" + this.sequenceNumber + " and second=" + secondSequenceNumber);
        }
        if (SentinelCheckpoint.SHARD_END.toString().equals(this.sequenceNumber) && SentinelCheckpoint.SHARD_END.toString().equals(secondSequenceNumber)) {
            return 0;
        }
        if (SentinelCheckpoint.SHARD_END.toString().equals(secondSequenceNumber)) {
            return -1;
        }
        if (SentinelCheckpoint.SHARD_END.toString().equals(this.sequenceNumber)) {
            return 1;
        }
        int result = ExtendedSequenceNumber.bigIntegerValue(this.sequenceNumber).compareTo(ExtendedSequenceNumber.bigIntegerValue(secondSequenceNumber));
        return result == 0 ? Long.compare(this.subSequenceNumber, extendedSequenceNumber.subSequenceNumber) : result;
    }

    public String getSequenceNumber() {
        return this.sequenceNumber;
    }

    public long getSubSequenceNumber() {
        return this.subSequenceNumber;
    }

    public boolean isShardEnd() {
        return this.sequenceNumber.equals(SentinelCheckpoint.SHARD_END.toString());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getSequenceNumber() != null) {
            sb.append("SequenceNumber: " + this.getSequenceNumber() + ",");
        }
        if (this.subSequenceNumber >= 0L) {
            sb.append("SubsequenceNumber: " + this.getSubSequenceNumber());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int shift = 32;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.sequenceNumber == null ? 0 : this.sequenceNumber.hashCode());
        hashCode = 31 * hashCode + (this.subSequenceNumber < 0L ? 0 : (int)(this.subSequenceNumber ^ this.subSequenceNumber >>> 32));
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExtendedSequenceNumber)) {
            return false;
        }
        ExtendedSequenceNumber other = (ExtendedSequenceNumber)obj;
        if (!this.sequenceNumber.equals(other.getSequenceNumber())) {
            return false;
        }
        return this.subSequenceNumber == other.getSubSequenceNumber();
    }

    private static BigInteger bigIntegerValue(String sequenceNumber) {
        if (ExtendedSequenceNumber.isDigits(sequenceNumber)) {
            return new BigInteger(sequenceNumber);
        }
        if (SentinelCheckpoint.LATEST.toString().equals(sequenceNumber)) {
            return LATEST_BIG_INTEGER_VALUE;
        }
        if (SentinelCheckpoint.TRIM_HORIZON.toString().equals(sequenceNumber)) {
            return TRIM_HORIZON_BIG_INTEGER_VALUE;
        }
        if (SentinelCheckpoint.AT_TIMESTAMP.toString().equals(sequenceNumber)) {
            return AT_TIMESTAMP_BIG_INTEGER_VALUE;
        }
        throw new IllegalArgumentException("Expected a string of digits, TRIM_HORIZON, LATEST or AT_TIMESTAMP but received " + sequenceNumber);
    }

    private static boolean isDigitsOrSentinelValue(String string) {
        return ExtendedSequenceNumber.isDigits(string) || ExtendedSequenceNumber.isSentinelValue(string);
    }

    private static boolean isSentinelValue(String string) {
        try {
            SentinelCheckpoint.valueOf(string);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static boolean isDigits(String string) {
        if (string == null || string.length() == 0) {
            return false;
        }
        for (int i = 0; i < string.length(); ++i) {
            if (Character.isDigit(string.charAt(i))) continue;
            return false;
        }
        return true;
    }
}

