/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.io.checkpointing;

import java.time.Duration;
import java.util.concurrent.Callable;
import java.util.concurrent.ScheduledFuture;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.operators.MailboxExecutor;
import org.apache.flink.runtime.io.network.api.CheckpointBarrier;
import org.apache.flink.streaming.runtime.tasks.TimerService;
import org.apache.flink.util.clock.Clock;

@Internal
public class BarrierAlignmentUtil {
    public static long getTimerDelay(Clock clock, CheckpointBarrier announcedBarrier) {
        long alignedCheckpointTimeout = announcedBarrier.getCheckpointOptions().getAlignedCheckpointTimeout();
        long timePassedSinceCheckpointStart = clock.absoluteTimeMillis() - announcedBarrier.getTimestamp();
        return Math.max(alignedCheckpointTimeout - timePassedSinceCheckpointStart, 0L);
    }

    public static DelayableTimer createRegisterTimerCallback(MailboxExecutor mailboxExecutor, TimerService timerService) {
        return (callable, delay) -> {
            ScheduledFuture scheduledFuture = timerService.registerTimer(timerService.getCurrentProcessingTime() + delay.toMillis(), timestamp -> mailboxExecutor.execute(() -> callable.call(), "Execute checkpoint barrier handler delayed action"));
            return () -> scheduledFuture.cancel(false);
        };
    }

    public static interface Cancellable {
        public void cancel();
    }

    public static interface DelayableTimer {
        public Cancellable registerTask(Callable<?> var1, Duration var2);
    }
}

