/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.execution.caching;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Date;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.vfs2.AllFileSelector;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSelectInfo;
import org.apache.commons.vfs2.FileSelector;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopFileException;
import org.apache.hop.core.gui.plugin.GuiElementType;
import org.apache.hop.core.gui.plugin.GuiPlugin;
import org.apache.hop.core.gui.plugin.GuiWidgetElement;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.execution.IExecutionInfoLocation;
import org.apache.hop.execution.caching.BaseCachingExecutionInfoLocation;
import org.apache.hop.execution.caching.CacheEntry;
import org.apache.hop.execution.caching.DatedId;
import org.apache.hop.execution.plugin.ExecutionInfoLocationPlugin;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IHopMetadataProvider;

@GuiPlugin(description="Caching File execution information location GUI elements")
@ExecutionInfoLocationPlugin(id="caching-file-location", name="Caching File location", description="Aggregates and caches execution information before storing in files")
public class CachingFileExecutionInfoLocation
extends BaseCachingExecutionInfoLocation
implements IExecutionInfoLocation {
    @GuiWidgetElement(id="rootFolder", order="010", parentId="ExecutionInfoLocation-PluginSpecific-Options", type=GuiElementType.FOLDER, toolTip="i18n::CachingFileExecutionInfoLocation.RootFolder.Tooltip", label="i18n::CachingFileExecutionInfoLocation.RootFolder.Label")
    @HopMetadataProperty
    protected String rootFolder;
    protected String actualRootFolder;

    public CachingFileExecutionInfoLocation() {
        this.actualRootFolder = null;
    }

    public CachingFileExecutionInfoLocation(CachingFileExecutionInfoLocation location) {
        super(location);
        this.rootFolder = location.rootFolder;
        this.actualRootFolder = location.actualRootFolder;
    }

    @Override
    public CachingFileExecutionInfoLocation clone() {
        return new CachingFileExecutionInfoLocation(this);
    }

    @Override
    public void initialize(IVariables variables, IHopMetadataProvider metadataProvider) throws HopException {
        this.actualRootFolder = variables.resolve(this.rootFolder);
        super.initialize(variables, metadataProvider);
    }

    @Override
    protected void persistCacheEntry(CacheEntry cacheEntry) throws HopException {
        try {
            cacheEntry.calculateSummary();
            cacheEntry.writeToDisk(this.actualRootFolder);
            cacheEntry.setLastWritten(new Date());
        }
        catch (Exception e) {
            throw new HopException("Error writing caching file entry to disk in folder " + this.actualRootFolder, (Throwable)e);
        }
    }

    @Override
    public void deleteCacheEntry(CacheEntry cacheEntry) throws HopException {
        try {
            cacheEntry.deleteFromDisk(this.actualRootFolder);
        }
        catch (Exception e) {
            throw new HopException("Error deleting caching file entry from folder " + this.actualRootFolder, (Throwable)e);
        }
    }

    @Override
    protected synchronized CacheEntry loadCacheEntry(String executionId) throws HopException {
        try {
            CacheEntry entry = new CacheEntry();
            entry.setId(executionId);
            String filename = entry.calculateFilename(this.rootFolder);
            if (!HopVfs.fileExists((String)filename)) {
                return null;
            }
            ObjectMapper objectMapper = new ObjectMapper();
            return (CacheEntry)objectMapper.readValue(HopVfs.getInputStream((String)filename), CacheEntry.class);
        }
        catch (Exception e) {
            throw new HopException("Error loading execution information location file for executionId '" + executionId + "'", (Throwable)e);
        }
    }

    @Override
    protected void retrieveIds(boolean includeChildren, Set<DatedId> ids, int limit) throws HopException {
        try {
            FileObject[] files;
            for (FileObject file : files = this.getAllFileObjects(this.actualRootFolder)) {
                CacheEntry entry;
                String id = this.getIdFromFileName(file);
                if (ids.contains(new DatedId(id, null))) continue;
                ids.add(new DatedId(id, new Date(file.getContent().getLastModifiedTime())));
                if (!includeChildren || (entry = this.loadCacheEntry(id)) == null) continue;
                CachingFileExecutionInfoLocation.addChildIds(entry, ids);
            }
        }
        catch (Exception e) {
            throw new HopException("Error finding execution ids in folder '" + this.actualRootFolder + "'", (Throwable)e);
        }
    }

    private String getIdFromFileName(FileObject file) {
        String baseName = file.getName().getBaseName();
        int index = baseName.lastIndexOf(".json");
        String id = index > 0 ? baseName.substring(0, index) : baseName;
        return id;
    }

    private FileObject[] getAllFileObjects(String actualRootFolder) throws FileSystemException, HopFileException {
        FileObject folder = HopVfs.getFileObject((String)actualRootFolder);
        return folder.findFiles((FileSelector)new AllFileSelector(){

            public boolean includeFile(FileSelectInfo fileInfo) {
                return fileInfo.getFile().getName().getExtension().equalsIgnoreCase("json");
            }
        });
    }

    @Override
    public String getPluginId() {
        return "caching-file-location";
    }

    @Override
    public void setPluginId(String pluginId) {
    }

    @Override
    public String getPluginName() {
        return "Caching File location";
    }

    @Override
    public void setPluginName(String pluginName) {
    }

    @Generated
    public String getRootFolder() {
        return this.rootFolder;
    }

    @Generated
    public String getActualRootFolder() {
        return this.actualRootFolder;
    }

    @Generated
    public void setRootFolder(String rootFolder) {
        this.rootFolder = rootFolder;
    }

    @Generated
    public void setActualRootFolder(String actualRootFolder) {
        this.actualRootFolder = actualRootFolder;
    }
}

