/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.data;

import com.clickhouse.data.ClickHouseByteUtils;
import com.clickhouse.data.ClickHouseChecker;
import com.clickhouse.data.ClickHouseColumn;
import com.clickhouse.data.ClickHouseDataConfig;
import com.clickhouse.data.ClickHouseDeserializer;
import com.clickhouse.data.ClickHouseInputStream;
import com.clickhouse.data.ClickHouseOutputStream;
import com.clickhouse.data.ClickHouseRecord;
import com.clickhouse.data.ClickHouseRecordMapper;
import com.clickhouse.data.ClickHouseSerializer;
import com.clickhouse.data.ClickHouseSimpleRecord;
import com.clickhouse.data.ClickHouseUtils;
import com.clickhouse.data.ClickHouseValue;
import com.clickhouse.data.ClickHouseValues;
import java.io.EOFException;
import java.io.IOException;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

@Deprecated
public abstract class ClickHouseDataProcessor {
    public static final List<ClickHouseColumn> DEFAULT_COLUMNS = Collections.singletonList(ClickHouseColumn.of("results", "Nullable(String)"));
    protected static final String ERROR_FAILED_TO_READ = "Failed to read column #%d of %d: %s";
    protected static final String ERROR_FAILED_TO_WRITE = "Failed to write column #%d of %d: %s";
    protected static final String ERROR_REACHED_END_OF_STREAM = "Reached end of the stream when reading column #%d of %d: %s";
    protected static final String ERROR_UNKNOWN_DATA_TYPE = "Unsupported data type: ";
    protected final ClickHouseDataConfig config;
    protected final ClickHouseInputStream input;
    protected final ClickHouseOutputStream output;
    protected final Map<String, Serializable> extraProps;
    protected DefaultSerDe serde;
    protected int readPosition;
    protected int writePosition;
    private final List<ClickHouseColumn> initialColumns;
    private final Map<String, Serializable> initialSettings;

    protected boolean hasMoreToRead() throws UncheckedIOException {
        try {
            if (this.input.available() < 1) {
                this.input.close();
                return false;
            }
            return true;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private ClickHouseRecord nextRecord() throws NoSuchElementException, UncheckedIOException {
        DefaultSerDe s = this.getInitializedSerDe();
        ClickHouseRecord r = this.config.isReuseValueWrapper() ? s.currentRecord : s.currentRecord.copy();
        try {
            this.readAndFill(r);
        }
        catch (StreamCorruptedException e) {
            byte[] search = "ode: ".getBytes(StandardCharsets.US_ASCII);
            byte[] bytes = this.input.getBuffer().array();
            int index = ClickHouseByteUtils.indexOf(bytes, search);
            if (index > 0 && bytes[--index] == 67) {
                throw new UncheckedIOException(new String(bytes, index, bytes.length - index, StandardCharsets.UTF_8), e);
            }
            throw new UncheckedIOException(ClickHouseUtils.format(ERROR_FAILED_TO_READ, this.readPosition + 1, s.columns.length, s.columns[this.readPosition]), e);
        }
        catch (EOFException e) {
            if (this.readPosition == 0) {
                throw new NoSuchElementException("No more record");
            }
            throw new UncheckedIOException(ClickHouseUtils.format(ERROR_REACHED_END_OF_STREAM, this.readPosition + 1, s.columns.length, s.columns[this.readPosition]), e);
        }
        catch (IOException e) {
            throw new UncheckedIOException(ClickHouseUtils.format(ERROR_FAILED_TO_READ, this.readPosition + 1, s.columns.length, s.columns[this.readPosition]), e);
        }
        return r;
    }

    private ClickHouseValue nextValue() throws NoSuchElementException, UncheckedIOException {
        DefaultSerDe s = this.getInitializedSerDe();
        ClickHouseValue value = this.config.isReuseValueWrapper() ? s.templates[this.readPosition] : s.templates[this.readPosition].copy();
        try {
            this.readAndFill(value);
        }
        catch (EOFException e) {
            if (this.readPosition == 0) {
                throw new NoSuchElementException("No more value");
            }
            throw new UncheckedIOException(ClickHouseUtils.format(ERROR_REACHED_END_OF_STREAM, this.readPosition + 1, s.columns.length, s.columns[this.readPosition]), e);
        }
        catch (IOException e) {
            throw new UncheckedIOException(ClickHouseUtils.format(ERROR_FAILED_TO_READ, this.readPosition + 1, s.columns.length, s.columns[this.readPosition]), e);
        }
        return value;
    }

    protected ClickHouseDeserializer[] buildDeserializeSteps(ClickHouseColumn column) {
        return new ClickHouseDeserializer[0];
    }

    protected ClickHouseSerializer[] buildSerializeSteps(ClickHouseColumn column) {
        return new ClickHouseSerializer[0];
    }

    protected final DefaultSerDe getInitializedSerDe() throws UncheckedIOException {
        if (this.serde == null) {
            try {
                this.serde = new DefaultSerDe(this);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        return this.serde;
    }

    protected Iterator<ClickHouseRecord> initRecords() {
        if (this.readPosition != 0) {
            throw new IllegalStateException("initRecords() is supposed to be called once during instantiation");
        }
        return new RecordsIterator(this);
    }

    protected Iterator<ClickHouseValue> initValues() {
        if (this.readPosition != 0) {
            throw new IllegalStateException("initValues() is supposed to be called once during instantiation");
        }
        return new ValuesIterator(this);
    }

    protected void readAndFill(ClickHouseRecord r) throws IOException {
        int i = this.readPosition;
        int len = this.serde.columns.length;
        while (i < len) {
            this.readAndFill(r.getValue(i));
            this.readPosition = i++;
        }
        this.readPosition = 0;
    }

    protected void readAndFill(ClickHouseValue value) throws IOException {
        int pos = this.readPosition;
        DefaultSerDe s = this.serde;
        ClickHouseValue v = s.deserializers[pos].deserialize(value, this.input);
        if (v != value) {
            s.templates[pos] = v;
        }
        this.readPosition = ++pos >= s.columns.length ? 0 : pos;
    }

    protected abstract List<ClickHouseColumn> readColumns() throws IOException;

    protected ClickHouseDataProcessor(ClickHouseDataConfig config, ClickHouseInputStream input, ClickHouseOutputStream output, List<ClickHouseColumn> columns, Map<String, Serializable> settings) throws IOException {
        this.config = ClickHouseChecker.nonNull(config, "DataConfig");
        if (input == null && output == null) {
            throw new IllegalArgumentException("One of input and output stream must not be null");
        }
        this.input = input;
        this.output = output;
        this.extraProps = new HashMap<String, Serializable>();
        this.initialColumns = columns;
        this.initialSettings = settings;
        this.serde = null;
        this.readPosition = 0;
        this.writePosition = 0;
    }

    public boolean hasExtraProperties() {
        return this.extraProps.isEmpty();
    }

    public <T extends Serializable> T getExtraProperty(String key, Class<T> valueClass) {
        return (T)((Serializable)valueClass.cast(this.extraProps.get(key)));
    }

    public abstract ClickHouseDeserializer getDeserializer(ClickHouseDataConfig var1, ClickHouseColumn var2);

    public final ClickHouseDeserializer[] getDeserializers(ClickHouseDataConfig config, List<ClickHouseColumn> columns) {
        ArrayList<ClickHouseDeserializer> list = new ArrayList<ClickHouseDeserializer>(columns.size());
        for (ClickHouseColumn column : columns) {
            list.add(this.getDeserializer(config, column));
        }
        return list.toArray(new ClickHouseDeserializer[0]);
    }

    public abstract ClickHouseSerializer getSerializer(ClickHouseDataConfig var1, ClickHouseColumn var2);

    public final ClickHouseSerializer[] getSerializers(ClickHouseDataConfig config, List<ClickHouseColumn> columns) {
        ArrayList<ClickHouseSerializer> list = new ArrayList<ClickHouseSerializer>(columns.size());
        for (ClickHouseColumn column : columns) {
            list.add(this.getSerializer(config, column));
        }
        return list.toArray(new ClickHouseSerializer[0]);
    }

    public final List<ClickHouseColumn> getColumns() {
        return this.getInitializedSerDe().columnList;
    }

    public final ClickHouseInputStream getInputStream() {
        return this.input;
    }

    public final ClickHouseOutputStream getOutputStream() {
        return this.output;
    }

    public final Iterable<ClickHouseRecord> records() {
        return () -> this.getInitializedSerDe().records;
    }

    public final <T> Iterable<T> records(Class<T> objClass) {
        return this.records(objClass, null);
    }

    public <T> Iterable<T> records(Class<T> objClass, T template) {
        if (objClass == null || objClass == ClickHouseRecord.class) {
            return this.records();
        }
        return () -> ClickHouseRecordMapper.wrap(this.config, this.getColumns(), this.getInitializedSerDe().records, objClass, template);
    }

    public final Iterable<ClickHouseValue> values() {
        DefaultSerDe s = this.getInitializedSerDe();
        if (s.columns.length == 0) {
            return Collections.emptyList();
        }
        return () -> s.values;
    }

    public ClickHouseValue read(ClickHouseValue value) throws IOException {
        if (this.input == null) {
            throw new IllegalStateException("No input stream available to read");
        }
        DefaultSerDe s = this.getInitializedSerDe();
        int len = s.columns.length;
        int pos = this.readPosition;
        if (len == 0 || pos >= len) {
            throw new IllegalStateException(ClickHouseUtils.format("No column to read(total=%d, readPosition=%d)", len, pos));
        }
        if (value == null) {
            value = this.config.isReuseValueWrapper() ? s.templates[pos] : s.templates[pos].copy();
        }
        this.readAndFill(value);
        return value;
    }

    public void write(ClickHouseValue value) throws IOException {
        if (this.output == null) {
            throw new IllegalStateException("No output stream available to write");
        }
        DefaultSerDe s = this.getInitializedSerDe();
        int len = s.columns.length;
        int pos = this.writePosition;
        if (len == 0 || pos >= len) {
            throw new IllegalStateException(ClickHouseUtils.format("No column to write(total=%d, writePosition=%d)", len, pos));
        }
        if (value == null) {
            value = this.config.isReuseValueWrapper() ? s.templates[pos] : s.templates[pos].copy();
        }
        s.serializers[pos++].serialize(value, this.output);
        this.writePosition = pos >= len ? 0 : pos;
    }

    protected static final class DefaultSerDe {
        public final ClickHouseColumn[] columns;
        public final ClickHouseValue[] templates;
        public final ClickHouseDeserializer[] deserializers;
        public final ClickHouseSerializer[] serializers;
        private final List<ClickHouseColumn> columnList;
        private final Map<String, Serializable> settings;
        private final ClickHouseRecord currentRecord;
        private final Iterator<ClickHouseRecord> records;
        private final Iterator<ClickHouseValue> values;
        private final Map<String, Integer> columnsIndex;

        DefaultSerDe(ClickHouseDataProcessor processor) throws IOException {
            int i2;
            this.settings = processor.initialSettings == null || processor.initialSettings.isEmpty() ? Collections.emptyMap() : Collections.unmodifiableMap(new HashMap(processor.initialSettings));
            List<ClickHouseColumn> list = processor.initialColumns;
            if (list == null && processor.input != null) {
                list = processor.readColumns();
            }
            int colCount = 0;
            if (list == null || list.isEmpty()) {
                this.columns = ClickHouseColumn.EMPTY_ARRAY;
                this.templates = ClickHouseValues.EMPTY_VALUES;
            } else {
                colCount = list.size();
                int idx = 0;
                this.columns = new ClickHouseColumn[colCount];
                this.templates = new ClickHouseValue[colCount];
                for (ClickHouseColumn column : list) {
                    column.setColumnIndex(idx, colCount);
                    this.columns[idx] = column;
                    this.templates[idx] = column.newValue(processor.config);
                    ++idx;
                }
            }
            this.columnList = Collections.unmodifiableList(Arrays.asList(this.columns));
            this.columnsIndex = IntStream.range(0, this.columnList.size()).boxed().collect(Collectors.toMap(i -> this.columnList.get((int)i).getColumnName(), i -> i));
            if (processor.input == null) {
                this.currentRecord = ClickHouseRecord.EMPTY;
                this.records = Collections.emptyIterator();
                this.values = Collections.emptyIterator();
                this.deserializers = new ClickHouseDeserializer[0];
                this.serializers = new ClickHouseSerializer[colCount];
                for (i2 = 0; i2 < colCount; ++i2) {
                    this.serializers[i2] = processor.getSerializer(processor.config, this.columns[i2]);
                }
            } else {
                this.currentRecord = new ClickHouseSimpleRecord(this.columnsIndex, this.templates);
                this.records = ClickHouseChecker.nonNull(processor.initRecords(), "Records");
                this.values = ClickHouseChecker.nonNull(processor.initValues(), "Values");
                this.deserializers = new ClickHouseDeserializer[colCount];
                this.serializers = new ClickHouseSerializer[0];
                for (i2 = 0; i2 < colCount; ++i2) {
                    this.deserializers[i2] = processor.getDeserializer(processor.config, this.columns[i2]);
                }
            }
        }

        public Serializable getSetting(String setting) {
            return this.settings.get(setting);
        }
    }

    static final class RecordsIterator
    implements Iterator<ClickHouseRecord> {
        private final ClickHouseDataProcessor processor;

        RecordsIterator(ClickHouseDataProcessor processor) {
            this.processor = processor;
        }

        @Override
        public boolean hasNext() {
            return this.processor.hasMoreToRead();
        }

        @Override
        public ClickHouseRecord next() {
            return this.processor.nextRecord();
        }
    }

    static final class ValuesIterator
    implements Iterator<ClickHouseValue> {
        private final ClickHouseDataProcessor processor;

        ValuesIterator(ClickHouseDataProcessor processor) {
            this.processor = processor;
        }

        @Override
        public boolean hasNext() {
            return this.processor.hasMoreToRead();
        }

        @Override
        public ClickHouseValue next() {
            return this.processor.nextValue();
        }
    }

    protected static final class UseObjectConfig
    extends ClickHouseDataConfig.Wrapped {
        public UseObjectConfig(ClickHouseDataConfig config) {
            super(config);
        }

        @Override
        public boolean isUseObjectsInArray() {
            return true;
        }
    }
}

