/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.flink.translation.functions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.PaneInfo;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.WindowingStrategy;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Iterables;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Iterators;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.PeekingIterator;
import org.apache.flink.api.common.functions.GroupReduceFunction;
import org.apache.flink.util.Collector;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Instant;

public class FlinkNonMergingReduceFunction<@UnknownKeyFor K, @UnknownKeyFor InputT>
implements GroupReduceFunction<WindowedValue<KV<K, InputT>>, WindowedValue<KV<K, Iterable<InputT>>>> {
    private final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized WindowingStrategy<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> windowingStrategy;
    private final @UnknownKeyFor @NonNull @Initialized boolean reIterableResult;

    public FlinkNonMergingReduceFunction(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized WindowingStrategy<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> windowingStrategy, @UnknownKeyFor @NonNull @Initialized boolean reIterableResult) {
        this.windowingStrategy = windowingStrategy;
        this.reIterableResult = reIterableResult;
    }

    public void reduce(@UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @NonNull @Initialized KV<K, InputT>>> input, @UnknownKeyFor @NonNull @Initialized Collector<@UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @NonNull @Initialized KV<K, @UnknownKeyFor @NonNull @Initialized Iterable<InputT>>>> coll) {
        Iterable<Object> values;
        PeekingIterator iterator = Iterators.peekingIterator(input.iterator());
        WindowedValue first = (WindowedValue)iterator.peek();
        BoundedWindow window = (BoundedWindow)Iterables.getOnlyElement((Iterable)first.getWindows());
        Instant outputTimestamp = first.getTimestamp();
        Instant combinedTimestamp = this.windowingStrategy.getTimestampCombiner().assign(window, outputTimestamp);
        if (this.reIterableResult) {
            ArrayList lst = new ArrayList();
            iterator.forEachRemaining(wv -> lst.add(((KV)wv.getValue()).getValue()));
            values = lst;
        } else {
            values = new OnceIterable(Iterators.transform((Iterator)iterator, wv -> ((KV)Objects.requireNonNull(wv).getValue()).getValue()));
        }
        coll.collect((Object)WindowedValue.of((Object)KV.of((Object)((KV)first.getValue()).getKey(), values), (Instant)combinedTimestamp, (Collection)first.getWindows(), (PaneInfo)PaneInfo.ON_TIME_AND_ONLY_FIRING));
    }

    private static class OnceIterable<@UnknownKeyFor T>
    implements Iterable<T> {
        private final @UnknownKeyFor @NonNull @Initialized Iterator<T> iterator;
        private final @UnknownKeyFor @NonNull @Initialized AtomicBoolean used = new AtomicBoolean(false);

        OnceIterable(@UnknownKeyFor @NonNull @Initialized Iterator<T> iterator) {
            this.iterator = iterator;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Iterator<T> iterator() {
            if (this.used.compareAndSet(false, true)) {
                return this.iterator;
            }
            throw new IllegalStateException("GBK result is not re-iterable. You can enable re-iterations by setting '--reIterableGroupByKeyResult'.");
        }
    }
}

