/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.filesystem;

import java.io.IOException;
import java.net.URI;
import java.util.Optional;
import java.util.regex.Pattern;
import org.apache.flink.core.fs.FSDataInputStream;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.state.PhysicalStateHandleID;
import org.apache.flink.runtime.state.StateObject;
import org.apache.flink.runtime.state.StreamStateHandle;
import org.apache.flink.util.Preconditions;

public class FileStateHandle
implements StreamStateHandle {
    private static final long serialVersionUID = 350284443258002355L;
    private static final Pattern NOT_LOCAL_FILER = Pattern.compile("(?!file\\b)\\w+?://.*");
    private final Path filePath;
    private final long stateSize;

    public FileStateHandle(Path filePath, long stateSize) {
        Preconditions.checkArgument((stateSize >= -1L ? 1 : 0) != 0);
        this.filePath = (Path)Preconditions.checkNotNull((Object)filePath);
        this.stateSize = stateSize;
    }

    public Path getFilePath() {
        return this.filePath;
    }

    @Override
    public FSDataInputStream openInputStream() throws IOException {
        return this.getFileSystem().open(this.filePath);
    }

    @Override
    public Optional<byte[]> asBytesIfInMemory() {
        return Optional.empty();
    }

    @Override
    public PhysicalStateHandleID getStreamStateHandleID() {
        return new PhysicalStateHandleID(this.filePath.toUri().toString());
    }

    @Override
    public void discardState() throws Exception {
        FileSystem fs = this.getFileSystem();
        IOException actualException = null;
        boolean success = true;
        try {
            success = fs.delete(this.filePath, false);
        }
        catch (IOException e) {
            actualException = e;
        }
        if ((!success || actualException != null) && fs.exists(this.filePath)) {
            throw Optional.ofNullable(actualException).orElse(new IOException("Unknown error caused the file '" + this.filePath + "' to not be deleted."));
        }
    }

    @Override
    public long getStateSize() {
        return this.stateSize;
    }

    @Override
    public void collectSizeStats(StateObject.StateObjectSizeStatsCollector collector) {
        StateObject.StateObjectLocation location = NOT_LOCAL_FILER.matcher(this.filePath.toUri().toString()).matches() ? StateObject.StateObjectLocation.REMOTE : StateObject.StateObjectLocation.LOCAL_DISK;
        collector.add(location, this.getStateSize());
    }

    private FileSystem getFileSystem() throws IOException {
        return FileSystem.get((URI)this.filePath.toUri());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FileStateHandle)) {
            return false;
        }
        FileStateHandle that = (FileStateHandle)o;
        return this.filePath.equals((Object)that.filePath);
    }

    public int hashCode() {
        return this.filePath.hashCode();
    }

    public String toString() {
        return String.format("File State: %s [%d bytes]", this.filePath, this.stateSize);
    }
}

