/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph;

import java.util.HashMap;
import java.util.Map;
import org.apache.flink.runtime.executiongraph.JobVertexInputInfo;
import org.apache.flink.runtime.jobgraph.IntermediateDataSetID;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.util.Preconditions;

public class VertexInputInfoStore {
    private final Map<JobVertexID, Map<IntermediateDataSetID, JobVertexInputInfo>> jobVertexInputInfos = new HashMap<JobVertexID, Map<IntermediateDataSetID, JobVertexInputInfo>>();

    public void put(JobVertexID jobVertexId, IntermediateDataSetID resultId, JobVertexInputInfo info) {
        Preconditions.checkNotNull((Object)jobVertexId);
        Preconditions.checkNotNull((Object)resultId);
        Preconditions.checkNotNull((Object)info);
        this.jobVertexInputInfos.compute(jobVertexId, (ignored, inputInfos) -> {
            if (inputInfos == null) {
                inputInfos = new HashMap<IntermediateDataSetID, JobVertexInputInfo>();
            }
            inputInfos.putIfAbsent(resultId, info);
            return inputInfos;
        });
    }

    public JobVertexInputInfo get(JobVertexID jobVertexId, IntermediateDataSetID resultId) {
        Preconditions.checkNotNull((Object)jobVertexId);
        Preconditions.checkNotNull((Object)resultId);
        return (JobVertexInputInfo)Preconditions.checkNotNull((Object)this.jobVertexInputInfos.get(jobVertexId).get(resultId));
    }
}

