/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.hopgui.file.pipeline;

import java.io.OutputStream;
import java.lang.invoke.CallSite;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import lombok.Generated;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.apache.hop.base.AbstractMeta;
import org.apache.hop.core.Const;
import org.apache.hop.core.IAddUndoPosition;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.IEngineMeta;
import org.apache.hop.core.IProgressMonitor;
import org.apache.hop.core.NotePadMeta;
import org.apache.hop.core.SwtUniversalImage;
import org.apache.hop.core.action.GuiContextAction;
import org.apache.hop.core.action.GuiContextActionFilter;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopMissingPluginsException;
import org.apache.hop.core.exception.HopPluginException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.exception.HopValueException;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.extension.ExtensionPointHandler;
import org.apache.hop.core.extension.HopExtensionPoint;
import org.apache.hop.core.gui.AreaOwner;
import org.apache.hop.core.gui.BasePainter;
import org.apache.hop.core.gui.IGc;
import org.apache.hop.core.gui.IGuiPosition;
import org.apache.hop.core.gui.IRedrawable;
import org.apache.hop.core.gui.IUndo;
import org.apache.hop.core.gui.Point;
import org.apache.hop.core.gui.Rectangle;
import org.apache.hop.core.gui.SnapAllignDistribute;
import org.apache.hop.core.gui.plugin.GuiPlugin;
import org.apache.hop.core.gui.plugin.IGuiActionLambda;
import org.apache.hop.core.gui.plugin.IGuiRefresher;
import org.apache.hop.core.gui.plugin.action.GuiAction;
import org.apache.hop.core.gui.plugin.action.GuiActionType;
import org.apache.hop.core.gui.plugin.key.GuiKeyboardShortcut;
import org.apache.hop.core.gui.plugin.key.GuiOsxKeyboardShortcut;
import org.apache.hop.core.gui.plugin.toolbar.GuiToolbarElement;
import org.apache.hop.core.gui.plugin.toolbar.GuiToolbarElementType;
import org.apache.hop.core.logging.DefaultLogLevel;
import org.apache.hop.core.logging.HopLogStore;
import org.apache.hop.core.logging.IHasLogChannel;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.logging.ILogParentProvided;
import org.apache.hop.core.logging.ILoggingObject;
import org.apache.hop.core.logging.LogChannel;
import org.apache.hop.core.logging.LogLevel;
import org.apache.hop.core.logging.LoggingObjectType;
import org.apache.hop.core.logging.LoggingRegistry;
import org.apache.hop.core.logging.SimpleLoggingObject;
import org.apache.hop.core.parameters.INamedParameterDefinitions;
import org.apache.hop.core.plugins.IPlugin;
import org.apache.hop.core.plugins.PluginRegistry;
import org.apache.hop.core.plugins.TransformPluginType;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.RowBuffer;
import org.apache.hop.core.svg.SvgFile;
import org.apache.hop.core.util.ExecutorUtil;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.execution.Execution;
import org.apache.hop.execution.ExecutionInfoLocation;
import org.apache.hop.execution.ExecutionState;
import org.apache.hop.execution.ExecutionType;
import org.apache.hop.execution.IExecutionInfoLocation;
import org.apache.hop.history.AuditManager;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.laf.BasePropertyHandler;
import org.apache.hop.lineage.PipelineDataLineage;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.metadata.api.IHopMetadataSerializer;
import org.apache.hop.metadata.serializer.multi.MultiMetadataProvider;
import org.apache.hop.pipeline.DatabaseImpact;
import org.apache.hop.pipeline.PipelineExecutionConfiguration;
import org.apache.hop.pipeline.PipelineHopMeta;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.PipelinePainter;
import org.apache.hop.pipeline.config.IPipelineEngineRunConfiguration;
import org.apache.hop.pipeline.config.PipelineRunConfiguration;
import org.apache.hop.pipeline.debug.PipelineDebugMeta;
import org.apache.hop.pipeline.debug.TransformDebugMeta;
import org.apache.hop.pipeline.engine.IEngineComponent;
import org.apache.hop.pipeline.engine.IPipelineEngine;
import org.apache.hop.pipeline.engine.PipelineEngineFactory;
import org.apache.hop.pipeline.engines.local.LocalPipelineEngine;
import org.apache.hop.pipeline.engines.local.LocalPipelineRunConfiguration;
import org.apache.hop.pipeline.transform.IRowDistribution;
import org.apache.hop.pipeline.transform.IRowListener;
import org.apache.hop.pipeline.transform.ITransformIOMeta;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.RowAdapter;
import org.apache.hop.pipeline.transform.RowDistributionPluginType;
import org.apache.hop.pipeline.transform.TransformErrorMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transform.stream.IStream;
import org.apache.hop.pipeline.transform.stream.Stream;
import org.apache.hop.pipeline.transform.stream.StreamIcon;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.ContextDialog;
import org.apache.hop.ui.core.dialog.EnterSelectionDialog;
import org.apache.hop.ui.core.dialog.EnterStringDialog;
import org.apache.hop.ui.core.dialog.EnterTextDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.dialog.MessageBox;
import org.apache.hop.ui.core.dialog.MessageDialogWithToggle;
import org.apache.hop.ui.core.dialog.PreviewRowsDialog;
import org.apache.hop.ui.core.dialog.ProgressMonitorDialog;
import org.apache.hop.ui.core.dialog.TransformFieldsDialog;
import org.apache.hop.ui.core.gui.GuiResource;
import org.apache.hop.ui.core.gui.GuiToolbarWidgets;
import org.apache.hop.ui.core.gui.HopNamespace;
import org.apache.hop.ui.core.widget.OsHelper;
import org.apache.hop.ui.hopgui.CanvasFacade;
import org.apache.hop.ui.hopgui.CanvasListener;
import org.apache.hop.ui.hopgui.HopGui;
import org.apache.hop.ui.hopgui.HopGuiExtensionPoint;
import org.apache.hop.ui.hopgui.ServerPushSessionFacade;
import org.apache.hop.ui.hopgui.context.BaseGuiContextHandler;
import org.apache.hop.ui.hopgui.context.GuiContextUtil;
import org.apache.hop.ui.hopgui.context.IGuiContextHandler;
import org.apache.hop.ui.hopgui.delegates.HopGuiServerDelegate;
import org.apache.hop.ui.hopgui.dialog.EnterPreviewRowsDialog;
import org.apache.hop.ui.hopgui.dialog.NotePadDialog;
import org.apache.hop.ui.hopgui.dialog.SearchFieldsProgressDialog;
import org.apache.hop.ui.hopgui.file.IHopFileTypeHandler;
import org.apache.hop.ui.hopgui.file.delegates.HopGuiNotePadDelegate;
import org.apache.hop.ui.hopgui.file.pipeline.HopPipelineFileType;
import org.apache.hop.ui.hopgui.file.pipeline.ISelectedTransformListener;
import org.apache.hop.ui.hopgui.file.pipeline.ITransformSelectionListener;
import org.apache.hop.ui.hopgui.file.pipeline.context.HopGuiPipelineContext;
import org.apache.hop.ui.hopgui.file.pipeline.context.HopGuiPipelineHopContext;
import org.apache.hop.ui.hopgui.file.pipeline.context.HopGuiPipelineNoteContext;
import org.apache.hop.ui.hopgui.file.pipeline.context.HopGuiPipelineTransformContext;
import org.apache.hop.ui.hopgui.file.pipeline.delegates.HopGuiPipelineCheckDelegate;
import org.apache.hop.ui.hopgui.file.pipeline.delegates.HopGuiPipelineClipboardDelegate;
import org.apache.hop.ui.hopgui.file.pipeline.delegates.HopGuiPipelineGridDelegate;
import org.apache.hop.ui.hopgui.file.pipeline.delegates.HopGuiPipelineHopDelegate;
import org.apache.hop.ui.hopgui.file.pipeline.delegates.HopGuiPipelineLogDelegate;
import org.apache.hop.ui.hopgui.file.pipeline.delegates.HopGuiPipelineRunDelegate;
import org.apache.hop.ui.hopgui.file.pipeline.delegates.HopGuiPipelineTransformDelegate;
import org.apache.hop.ui.hopgui.file.pipeline.delegates.HopGuiPipelineUndoDelegate;
import org.apache.hop.ui.hopgui.file.pipeline.extension.HopGuiPipelineFinishedExtension;
import org.apache.hop.ui.hopgui.file.pipeline.extension.HopGuiPipelineGraphExtension;
import org.apache.hop.ui.hopgui.file.shared.HopGuiTooltipExtension;
import org.apache.hop.ui.hopgui.perspective.dataorch.HopDataOrchestrationPerspective;
import org.apache.hop.ui.hopgui.perspective.dataorch.HopGuiAbstractGraph;
import org.apache.hop.ui.hopgui.perspective.execution.ExecutionPerspective;
import org.apache.hop.ui.hopgui.perspective.execution.IExecutionViewer;
import org.apache.hop.ui.hopgui.shared.SwtGc;
import org.apache.hop.ui.pipeline.dialog.PipelineDialog;
import org.apache.hop.ui.util.EnvironmentUtils;
import org.apache.hop.ui.util.HelpUtils;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.ToolTip;
import org.eclipse.swt.widgets.Widget;

@GuiPlugin(description="The pipeline graph GUI plugin")
public class HopGuiPipelineGraph
extends HopGuiAbstractGraph
implements IRedrawable,
MouseListener,
MouseMoveListener,
MouseTrackListener,
IHasLogChannel,
ILogParentProvided,
IHopFileTypeHandler,
IGuiRefresher {
    private static final Class<?> PKG = HopGui.class;
    public static final String GUI_PLUGIN_TOOLBAR_PARENT_ID = "HopGuiPipelineGraph-Toolbar";
    public static final String TOOLBAR_ITEM_START = "HopGuiPipelineGraph-ToolBar-10010-Run";
    public static final String TOOLBAR_ITEM_STOP = "HopGuiPipelineGraph-ToolBar-10030-Stop";
    public static final String TOOLBAR_ITEM_PAUSE = "HopGuiPipelineGraph-ToolBar-10020-Pause";
    public static final String TOOLBAR_ITEM_CHECK = "HopGuiPipelineGraph-ToolBar-10040-Check";
    public static final String TOOLBAR_ITEM_PREVIEW = "HopGuiPipelineGraph-ToolBar-10050-Preview";
    public static final String TOOLBAR_ITEM_DEBUG = "HopGuiPipelineGraph-ToolBar-10060-Debug";
    public static final String TOOLBAR_ITEM_UNDO_ID = "HopGuiPipelineGraph-ToolBar-10100-Undo";
    public static final String TOOLBAR_ITEM_REDO_ID = "HopGuiPipelineGraph-ToolBar-10110-Redo";
    public static final String TOOLBAR_ITEM_SHOW_EXECUTION_RESULTS = "HopGuiPipelineGraph-ToolBar-10400-Execution-Results";
    public static final String TOOLBAR_ITEM_ZOOM_LEVEL = "HopGuiPipelineGraph-ToolBar-10500-Zoom-Level";
    public static final String TOOLBAR_ITEM_ZOOM_OUT = "HopGuiPipelineGraph-ToolBar-10510-Zoom-Out";
    public static final String TOOLBAR_ITEM_ZOOM_IN = "HopGuiPipelineGraph-ToolBar-10520-Zoom-In";
    public static final String TOOLBAR_ITEM_ZOOM_100PCT = "HopGuiPipelineGraph-ToolBar-10530-Zoom-100Pct";
    public static final String TOOLBAR_ITEM_ZOOM_TO_FIT = "HopGuiPipelineGraph-ToolBar-10540-Zoom-To-Fit";
    public static final String TOOLBAR_ITEM_EDIT_PIPELINE = "HopGuiPipelineGraph-ToolBar-10450-EditPipeline";
    public static final String TOOLBAR_ITEM_TO_EXECUTION_INFO = "HopGuiPipelineGraph-ToolBar-10475-ToExecutionInfo";
    public static final String ACTION_ID_PIPELINE_GRAPH_HOP_ENABLE = "pipeline-graph-hop-10010-hop-enable";
    public static final String ACTION_ID_PIPELINE_GRAPH_HOP_DISABLE = "pipeline-graph-hop-10015-hop-disable";
    public static final String ACTION_ID_PIPELINE_GRAPH_TRANSFORM_ROWS_COPY = "pipeline-graph-transform-10650-rows-copy";
    public static final String ACTION_ID_PIPELINE_GRAPH_TRANSFORM_ROWS_DISTRIBUTE = "pipeline-graph-transform-10600-rows-distribute";
    public static final String ACTION_ID_PIPELINE_GRAPH_TRANSFORM_SPECIFY_COPIES = "pipeline-graph-transform-10100-copies";
    public static final String ACTION_ID_PIPELINE_GRAPH_TRANSFORM_ERROR_HANDLING = "pipeline-graph-transform-10800-error-handling";
    public static final String ACTION_ID_PIPELINE_GRAPH_TRANSFORM_VIEW_EXECUTION_INFO = "pipeline-graph-transform-11000-view-execution-info";
    public static final String CONST_ERROR = "Error";
    public static final String CONST_ERROR_PREVIEWING_PIPELINE = "Error previewing pipeline";
    private final ILogChannel log;
    private static final int HOP_SEL_MARGIN = 9;
    private static final int TOOLTIP_HIDE_DELAY_FLASH = 2000;
    private static final int TOOLTIP_HIDE_DELAY_SHORT = 5000;
    private static final int TOOLTIP_HIDE_DELAY_LONG = 10000;
    private PipelineMeta pipelineMeta;
    public IPipelineEngine<PipelineMeta> pipeline;
    private final HopDataOrchestrationPerspective perspective;
    private ToolBar toolBar;
    private GuiToolbarWidgets toolBarWidgets;
    private int iconSize;
    private Point lastClick;
    private Point lastMove;
    private Point[] previousTransformLocations;
    private Point[] previousNoteLocations;
    private List<TransformMeta> selectedTransforms;
    private TransformMeta selectedTransform;
    private List<NotePadMeta> selectedNotes;
    private NotePadMeta selectedNote;
    private PipelineHopMeta candidate;
    private boolean splitHop;
    private int lastButton;
    private boolean openedContextDialog = false;
    private PipelineHopMeta lastHopSplit;
    private Rectangle selectionRegion;
    private List<ICheckResult> remarks;
    private List<DatabaseImpact> impact;
    private boolean impactFinished;
    private PipelineDebugMeta lastPipelineDebugMeta;
    protected int currentMouseX = 0;
    protected int currentMouseY = 0;
    protected NotePadMeta currentNotePad = null;
    protected TransformMeta currentTransform;
    private final List<AreaOwner> areaOwners;
    private final SashForm sashForm;
    public CTabFolder extraViewTabFolder;
    private boolean initialized;
    private boolean halted;
    private boolean halting;
    private boolean safeStopping;
    private boolean debug;
    public HopGuiPipelineLogDelegate pipelineLogDelegate;
    public HopGuiPipelineGridDelegate pipelineGridDelegate;
    public HopGuiPipelineCheckDelegate pipelineCheckDelegate;
    public HopGuiPipelineRunDelegate pipelineRunDelegate;
    public HopGuiPipelineTransformDelegate pipelineTransformDelegate;
    public HopGuiPipelineClipboardDelegate pipelineClipboardDelegate;
    public HopGuiPipelineHopDelegate pipelineHopDelegate;
    public HopGuiPipelineUndoDelegate pipelineUndoDelegate;
    public HopGuiServerDelegate serverDelegate;
    public HopGuiNotePadDelegate notePadDelegate;
    public List<ISelectedTransformListener> transformListeners;
    public List<ITransformSelectionListener> currentTransformListeners = new ArrayList<ITransformSelectionListener>();
    private Map<String, String> transformLogMap;
    private TransformMeta startHopTransform;
    private Point endHopLocation;
    private boolean startErrorHopTransform;
    private TransformMeta noInputTransform;
    private TransformMeta endHopTransform;
    private IStream.StreamType candidateHopType;
    Timer redrawTimer;
    private HopPipelineFileType<PipelineMeta> fileType;
    private boolean singleClick;
    private boolean doubleClick;
    private boolean mouseMovedSinceClick;
    private PipelineHopMeta clickedPipelineHop;
    protected Map<String, RowBuffer> outputRowsMap;
    private boolean avoidContextDialog;
    private ToolItem minMaxItem;
    private ToolItem rotateItem;
    private TransformMeta lastChained = null;

    public void setCurrentNote(NotePadMeta ni) {
        this.currentNotePad = ni;
    }

    public NotePadMeta getCurrentNote() {
        return this.currentNotePad;
    }

    public void addSelectedTransformListener(ISelectedTransformListener selectedTransformListener) {
        this.transformListeners.add(selectedTransformListener);
    }

    public void addCurrentTransformListener(ITransformSelectionListener transformSelectionListener) {
        this.currentTransformListeners.add(transformSelectionListener);
    }

    public HopGuiPipelineGraph(Composite parent, HopGui hopGui, CTabItem parentTabItem, HopDataOrchestrationPerspective perspective, PipelineMeta pipelineMeta, HopPipelineFileType<PipelineMeta> fileType) {
        super(hopGui, parent, 262144, parentTabItem);
        this.hopGui = hopGui;
        this.parentTabItem = parentTabItem;
        this.perspective = perspective;
        this.pipelineMeta = pipelineMeta;
        this.fileType = fileType;
        this.areaOwners = new ArrayList<AreaOwner>();
        this.log = hopGui.getLog();
        pipelineMeta.setInternalHopVariables(this.variables);
        this.pipelineLogDelegate = new HopGuiPipelineLogDelegate(hopGui, this);
        this.pipelineGridDelegate = new HopGuiPipelineGridDelegate(hopGui, this);
        this.pipelineCheckDelegate = new HopGuiPipelineCheckDelegate(hopGui, this);
        this.pipelineClipboardDelegate = new HopGuiPipelineClipboardDelegate(hopGui, this);
        this.pipelineTransformDelegate = new HopGuiPipelineTransformDelegate(hopGui, this);
        this.pipelineHopDelegate = new HopGuiPipelineHopDelegate(hopGui, this);
        this.pipelineUndoDelegate = new HopGuiPipelineUndoDelegate(hopGui, this);
        this.pipelineRunDelegate = new HopGuiPipelineRunDelegate(hopGui, this);
        this.serverDelegate = new HopGuiServerDelegate(hopGui, this);
        this.notePadDelegate = new HopGuiNotePadDelegate(hopGui, this);
        this.transformListeners = new ArrayList<ISelectedTransformListener>();
        FormData formData = new FormData();
        formData.left = new FormAttachment(0, 0);
        formData.top = new FormAttachment(0, 0);
        formData.right = new FormAttachment(100, 0);
        formData.bottom = new FormAttachment(100, 0);
        this.setLayoutData(formData);
        this.setLayout((Layout)new FormLayout());
        this.addToolBar();
        Composite mainComposite = new Composite((Composite)this, 0);
        mainComposite.setLayout((Layout)new FormLayout());
        FormData fdMainComposite = new FormData();
        fdMainComposite.left = new FormAttachment(0, 0);
        fdMainComposite.top = new FormAttachment(0, this.toolBar.getBounds().height);
        fdMainComposite.right = new FormAttachment(100, 0);
        fdMainComposite.bottom = new FormAttachment(100, 0);
        mainComposite.setLayoutData((Object)fdMainComposite);
        this.sashForm = new SashForm(mainComposite, PropsUi.getInstance().isGraphExtraViewVerticalOrientation() ? 512 : 256);
        FormData fdSashForm = new FormData();
        fdSashForm.left = new FormAttachment(0, 0);
        fdSashForm.top = new FormAttachment(0, 0);
        fdSashForm.right = new FormAttachment(100, 0);
        fdSashForm.bottom = new FormAttachment(100, 0);
        this.sashForm.setLayoutData((Object)fdSashForm);
        this.canvas = new Canvas((Composite)this.sashForm, 264192);
        Listener listener = CanvasListener.getInstance();
        this.canvas.addListener(3, listener);
        this.canvas.addListener(5, listener);
        this.canvas.addListener(4, listener);
        this.canvas.addListener(9, listener);
        FormData fdCanvas = new FormData();
        fdCanvas.left = new FormAttachment(0, 0);
        fdCanvas.top = new FormAttachment(0, 0);
        fdCanvas.right = new FormAttachment(100, 0);
        fdCanvas.bottom = new FormAttachment(100, 0);
        this.canvas.setLayoutData((Object)fdCanvas);
        this.sashForm.setWeights(new int[]{100});
        this.toolTip = new ToolTip(this.getShell(), 4096);
        this.toolTip.setAutoHide(true);
        this.iconSize = hopGui.getProps().getIconSize();
        this.clearSettings();
        this.remarks = new ArrayList<ICheckResult>();
        this.impact = new ArrayList<DatabaseImpact>();
        this.impactFinished = false;
        this.setVisible(true);
        this.newProps();
        this.canvas.setBackground(GuiResource.getInstance().getColorBlueCustomGrid());
        this.canvas.addPaintListener(this::paintControl);
        this.selectedTransforms = null;
        this.lastClick = null;
        this.canvas.addMouseListener((MouseListener)this);
        if (!EnvironmentUtils.getInstance().isWeb()) {
            this.canvas.addMouseMoveListener((MouseMoveListener)this);
            this.canvas.addMouseTrackListener((MouseTrackListener)this);
            this.canvas.addMouseWheelListener(x$0 -> this.mouseScrolled(x$0));
        }
        this.setBackground(GuiResource.getInstance().getColorBackground());
        hopGui.replaceKeyboardShortcutListeners(this);
        this.canvas.pack();
        this.updateGui();
    }

    public static HopGuiPipelineGraph getInstance() {
        return HopGui.getActivePipelineGraph();
    }

    @Override
    public void dispose() {
        this.disposeExtraView();
        super.dispose();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void mouseDoubleClick(MouseEvent e) {
        Object object;
        if (!PropsUi.getInstance().useDoubleClick()) {
            return;
        }
        this.doubleClick = true;
        this.clearSettings();
        Point real = this.screen2real(e.x, e.y);
        this.hideToolTips();
        AreaOwner areaOwner = this.getVisibleAreaOwner(real.x, real.y);
        try {
            HopGuiPipelineGraphExtension ext = new HopGuiPipelineGraphExtension(this, e, real, areaOwner);
            ExtensionPointHandler.callExtensionPoint((ILogChannel)LogChannel.GENERAL, (IVariables)this.variables, (String)HopExtensionPoint.PipelineGraphMouseDoubleClick.id, (Object)ext);
            if (ext.isPreventingDefault()) {
                return;
            }
        }
        catch (Exception ex) {
            LogChannel.GENERAL.logError("Error calling PipelineGraphMouseDoubleClick extension point", (Throwable)ex);
        }
        TransformMeta transformMeta = this.pipelineMeta.getTransform(real.x, real.y, this.iconSize);
        if (transformMeta != null) {
            if (e.button == 1) {
                this.editTransform(transformMeta);
                return;
            }
            this.editDescription(transformMeta);
            return;
        }
        PipelineHopMeta online = this.findPipelineHop(real.x, real.y);
        if (online != null) {
            this.editHop(online);
            return;
        }
        NotePadMeta ni = this.pipelineMeta.getNote(real.x, real.y);
        if (ni != null) {
            this.selectedNote = null;
            this.editNote(ni);
            return;
        }
        if (areaOwner != null && (object = areaOwner.getParent()) instanceof TransformMeta) {
            TransformMeta transform = (TransformMeta)object;
            if (areaOwner.getOwner().equals("PartitioningCurrentTransform")) {
                this.pipelineTransformDelegate.editTransformPartitioning(this.pipelineMeta, transform);
                return;
            }
        }
        this.editPipelineProperties(new HopGuiPipelineContext(this.pipelineMeta, this, real));
    }

    public void mouseDown(MouseEvent e) {
        if (EnvironmentUtils.getInstance().isWeb()) {
            this.mouseHover(e);
        }
        this.doubleClick = false;
        this.mouseMovedSinceClick = false;
        boolean alt = (e.stateMask & 0x10000) != 0;
        boolean control = (e.stateMask & SWT.MOD1) != 0;
        boolean shift = (e.stateMask & 0x20000) != 0;
        this.lastButton = e.button;
        Point real = this.screen2real(e.x, e.y);
        this.lastClick = new Point(real.x, real.y);
        this.hideToolTips();
        AreaOwner areaOwner = this.getVisibleAreaOwner(real.x, real.y);
        try {
            HopGuiPipelineGraphExtension ext = new HopGuiPipelineGraphExtension(this, e, real, areaOwner);
            ExtensionPointHandler.callExtensionPoint((ILogChannel)LogChannel.GENERAL, (IVariables)this.variables, (String)HopExtensionPoint.PipelineGraphMouseDown.id, (Object)ext);
            if (ext.isPreventingDefault()) {
                return;
            }
        }
        catch (Exception ex) {
            LogChannel.GENERAL.logError("Error calling PipelineGraphMouseDown extension point", (Throwable)ex);
        }
        if (areaOwner != null && areaOwner.getAreaType() != null) {
            switch (areaOwner.getAreaType()) {
                case TRANSFORM_INFO_ICON: {
                    this.editDescription((TransformMeta)areaOwner.getOwner());
                    break;
                }
                case HOP_INFO_ICON: {
                    this.pipelineTransformDelegate.editTransform(this.pipelineMeta, (TransformMeta)areaOwner.getOwner());
                    break;
                }
                case TRANSFORM_TARGET_HOP_ICON: {
                    this.pipelineTransformDelegate.editTransform(this.pipelineMeta, (TransformMeta)areaOwner.getParent());
                    break;
                }
                case HOP_COPY_ICON: {
                    break;
                }
                case HOP_ERROR_ICON: {
                    this.pipelineTransformDelegate.editTransformErrorHandling(this.pipelineMeta, (TransformMeta)areaOwner.getParent());
                    break;
                }
                case TRANSFORM_ICON: {
                    TransformMeta transformMeta;
                    if (shift && control) {
                        this.openReferencedObject();
                        return;
                    }
                    if (this.candidate != null && !OsHelper.isMac()) {
                        this.addCandidateAsHop(e.x, e.y);
                    }
                    this.currentTransform = transformMeta = (TransformMeta)areaOwner.getOwner();
                    for (ITransformSelectionListener listener : this.currentTransformListeners) {
                        listener.onUpdateSelection(this.currentTransform);
                    }
                    if (e.button == 1 && alt && transformMeta.supportsErrorHandling()) {
                        this.pipelineTransformDelegate.editTransformErrorHandling(this.pipelineMeta, transformMeta);
                        return;
                    }
                    if (e.button == 1 && this.startHopTransform != null && this.endHopTransform == null) {
                        this.candidate = new PipelineHopMeta(this.startHopTransform, this.currentTransform);
                        this.addCandidateAsHop(e.x, e.y);
                    } else if (e.button == 2 || e.button == 1 && shift) {
                        this.canvas.setData("mode", (Object)"hop");
                        this.startHopTransform = transformMeta;
                    } else {
                        this.canvas.setData("mode", (Object)"drag");
                        this.selectedTransforms = this.pipelineMeta.getSelectedTransforms();
                        this.selectedTransform = transformMeta;
                        this.previousTransformLocations = this.pipelineMeta.getSelectedTransformLocations();
                        Point p = transformMeta.getLocation();
                        this.iconOffset = new Point(real.x - p.x, real.y - p.y);
                    }
                    this.redraw();
                    break;
                }
                case NOTE: {
                    this.currentNotePad = (NotePadMeta)areaOwner.getOwner();
                    this.selectedNotes = this.pipelineMeta.getSelectedNotes();
                    this.selectedNote = this.currentNotePad;
                    Point loc = this.currentNotePad.getLocation();
                    this.previousNoteLocations = this.pipelineMeta.getSelectedNoteLocations();
                    this.noteOffset = new Point(real.x - loc.x, real.y - loc.y);
                    this.redraw();
                    break;
                }
                case TRANSFORM_COPIES_TEXT: {
                    this.copies((TransformMeta)areaOwner.getOwner());
                    break;
                }
                case TRANSFORM_DATA_SERVICE: {
                    this.editProperties(this.pipelineMeta, this.hopGui, PipelineDialog.Tabs.EXTRA_TAB);
                    break;
                }
            }
        } else {
            PipelineHopMeta hop = this.findPipelineHop(real.x, real.y);
            if (hop != null) {
                if (e.button == 1 && shift && control) {
                    this.pipelineHopDelegate.delHop(this.pipelineMeta, hop);
                    this.updateGui();
                } else if (e.button == 2 || e.button == 1 && control) {
                    hop.setEnabled(!hop.isEnabled());
                    this.updateGui();
                } else {
                    this.clickedPipelineHop = hop;
                }
            } else {
                if (this.startHopTransform != null) {
                    this.startHopTransform = null;
                    this.candidate = null;
                    this.lastClick = null;
                    this.avoidContextDialog = true;
                    this.redraw();
                    return;
                }
                if (this.setupDragView(e.button, control, new Point(e.x, e.y))) {
                    return;
                }
                this.canvas.setData("mode", (Object)"select");
                if (!control && e.button == 1) {
                    this.selectionRegion = new Rectangle(real.x, real.y, 0, 0);
                }
                this.updateGui();
            }
        }
        if (EnvironmentUtils.getInstance().isWeb()) {
            this.mouseMove(e);
        }
    }

    public void mouseUp(MouseEvent e) {
        this.canvas.setData("mode", (Object)"null");
        if (EnvironmentUtils.getInstance().isWeb()) {
            this.mouseMove(e);
        }
        this.setCursor(null);
        if (this.viewPortNavigation || this.viewDrag) {
            this.viewDrag = false;
            this.viewPortNavigation = false;
            this.viewPortStart = null;
            this.setCursor(null);
            return;
        }
        boolean control = (e.stateMask & SWT.MOD1) != 0;
        PipelineHopMeta selectedHop = this.findPipelineHop(e.x, e.y);
        this.updateErrorMetaForHop(selectedHop);
        boolean singleClick = false;
        this.mouseOverName = null;
        this.viewDrag = false;
        this.viewDragStart = null;
        SingleClickType singleClickType = null;
        TransformMeta singleClickTransform = null;
        NotePadMeta singleClickNote = null;
        PipelineHopMeta singleClickHop = null;
        if (this.iconOffset == null) {
            this.iconOffset = new Point(0, 0);
        }
        Point real = this.screen2real(e.x, e.y);
        Point icon = new Point(real.x - this.iconOffset.x, real.y - this.iconOffset.y);
        AreaOwner areaOwner = this.getVisibleAreaOwner(real.x, real.y);
        try {
            HopGuiPipelineGraphExtension ext = new HopGuiPipelineGraphExtension(this, e, real, areaOwner);
            ExtensionPointHandler.callExtensionPoint((ILogChannel)LogChannel.GENERAL, (IVariables)this.variables, (String)HopExtensionPoint.PipelineGraphMouseUp.id, (Object)ext);
            if (ext.isPreventingDefault()) {
                this.redraw();
                this.clearSettings();
                return;
            }
        }
        catch (Exception ex) {
            LogChannel.GENERAL.logError("Error calling PipelineGraphMouseUp extension point", (Throwable)ex);
        }
        if (this.selectionRegion != null) {
            this.selectionRegion.width = real.x - this.selectionRegion.x;
            this.selectionRegion.height = real.y - this.selectionRegion.y;
            if (this.selectionRegion.isEmpty()) {
                singleClick = true;
                singleClickType = SingleClickType.Pipeline;
            } else {
                this.pipelineMeta.unselectAll();
                this.selectInRect(this.pipelineMeta, this.selectionRegion);
                this.selectionRegion = null;
                this.updateGui();
                return;
            }
        }
        if (areaOwner != null && areaOwner.getAreaType() != null) {
            switch (areaOwner.getAreaType()) {
                case TRANSFORM_OUTPUT_DATA: {
                    if (this.mouseMovedSinceClick && !EnvironmentUtils.getInstance().isWeb() || !this.showTransformOutputData(areaOwner)) break;
                    return;
                }
                case TRANSFORM_ICON: {
                    if (this.startHopTransform == null) break;
                    this.currentTransform = (TransformMeta)areaOwner.getOwner();
                    this.candidate = new PipelineHopMeta(this.startHopTransform, this.currentTransform);
                    this.addCandidateAsHop(e.x, e.y);
                    this.redraw();
                    return;
                }
                case TRANSFORM_NAME: {
                    if (this.startHopTransform == null && this.selectionRegion == null && this.selectedTransforms == null && this.selectedNotes == null) {
                        this.startHopTransform = null;
                        this.selectionRegion = null;
                        TransformMeta transformMeta = (TransformMeta)areaOwner.getParent();
                        this.editTransform(transformMeta);
                    }
                    return;
                }
            }
        }
        if (this.selectedTransform != null && this.startHopTransform == null) {
            if (e.button == 1) {
                Point realClick = this.screen2real(e.x, e.y);
                if (this.lastClick.x == realClick.x && this.lastClick.y == realClick.y) {
                    if (control) {
                        this.selectedTransform.flipSelected();
                    } else {
                        singleClick = true;
                        singleClickType = SingleClickType.Transform;
                        singleClickTransform = this.selectedTransform;
                        if (!this.selectedTransform.isSelected()) {
                            this.pipelineMeta.unselectAll();
                            this.selectedTransform.setSelected(true);
                        }
                    }
                } else {
                    int[] indexes;
                    this.selectedTransforms = this.pipelineMeta.getSelectedTransforms();
                    this.selectedNotes = this.pipelineMeta.getSelectedNotes();
                    boolean also = false;
                    if (this.selectedNotes != null && !this.selectedNotes.isEmpty() && this.previousNoteLocations != null) {
                        indexes = this.pipelineMeta.getNoteIndexes(this.selectedNotes);
                        also = this.selectedTransforms != null && !this.selectedTransforms.isEmpty();
                        this.hopGui.undoDelegate.addUndoPosition((IUndo)this.pipelineMeta, this.selectedNotes.toArray(new NotePadMeta[this.selectedNotes.size()]), indexes, this.previousNoteLocations, this.pipelineMeta.getSelectedNoteLocations(), also);
                    }
                    if (this.selectedTransforms != null && this.previousTransformLocations != null) {
                        indexes = this.pipelineMeta.getTransformIndexes(this.selectedTransforms);
                        this.hopGui.undoDelegate.addUndoPosition((IUndo)this.pipelineMeta, this.selectedTransforms.toArray(new TransformMeta[this.selectedTransforms.size()]), indexes, this.previousTransformLocations, this.pipelineMeta.getSelectedTransformLocations(), also);
                    }
                }
            }
            if (this.splitHop) {
                PipelineHopMeta hi = this.findPipelineHop(icon.x + this.iconSize / 2, icon.y + this.iconSize / 2, this.selectedTransform);
                if (hi != null) {
                    this.splitHop(hi);
                }
                this.splitHop = false;
            }
            this.selectedTransforms = null;
            this.selectedNotes = null;
            this.selectedTransform = null;
            this.selectedNote = null;
            this.startHopTransform = null;
            this.endHopLocation = null;
            this.updateGui();
        } else if (this.selectedNote != null) {
            if (e.button == 1) {
                if (this.lastClick.x == real.x && this.lastClick.y == real.y) {
                    if (control) {
                        this.selectedNote.flipSelected();
                    } else {
                        singleClick = true;
                        singleClickType = SingleClickType.Note;
                        singleClickNote = this.selectedNote;
                    }
                } else {
                    int[] indexes;
                    this.selectedTransforms = this.pipelineMeta.getSelectedTransforms();
                    this.selectedNotes = this.pipelineMeta.getSelectedNotes();
                    boolean also = false;
                    if (this.selectedNotes != null && !this.selectedNotes.isEmpty() && this.previousNoteLocations != null) {
                        indexes = this.pipelineMeta.getNoteIndexes(this.selectedNotes);
                        this.hopGui.undoDelegate.addUndoPosition((IUndo)this.pipelineMeta, this.selectedNotes.toArray(new NotePadMeta[this.selectedNotes.size()]), indexes, this.previousNoteLocations, this.pipelineMeta.getSelectedNoteLocations(), also);
                        boolean bl = also = this.selectedTransforms != null && !this.selectedTransforms.isEmpty();
                    }
                    if (this.selectedTransforms != null && !this.selectedTransforms.isEmpty() && this.previousTransformLocations != null) {
                        indexes = this.pipelineMeta.getTransformIndexes(this.selectedTransforms);
                        this.hopGui.undoDelegate.addUndoPosition((IUndo)this.pipelineMeta, this.selectedTransforms.toArray(new TransformMeta[this.selectedTransforms.size()]), indexes, this.previousTransformLocations, this.pipelineMeta.getSelectedTransformLocations(), also);
                    }
                }
            }
            this.selectedNotes = null;
            this.selectedTransforms = null;
            this.selectedTransform = null;
            this.selectedNote = null;
            this.startHopTransform = null;
            this.endHopLocation = null;
            this.updateGui();
        }
        if (this.avoidContextDialog) {
            this.avoidContextDialog = false;
            this.selectionRegion = null;
            return;
        }
        if (this.clickedPipelineHop != null) {
            singleClick = true;
            singleClickType = SingleClickType.Hop;
            singleClickHop = this.clickedPipelineHop;
        }
        this.clickedPipelineHop = null;
        boolean fSingleClick = singleClick;
        SingleClickType fSingleClickType = singleClickType;
        TransformMeta fSingleClickTransform = singleClickTransform;
        NotePadMeta fSingleClickNote = singleClickNote;
        PipelineHopMeta fSingleClickHop = singleClickHop;
        if (PropsUi.getInstance().useDoubleClick()) {
            this.hopGui.getDisplay().timerExec(this.hopGui.getDisplay().getDoubleClickTime(), () -> this.showActionDialog(e, real, fSingleClick, fSingleClickType, fSingleClickTransform, fSingleClickNote, fSingleClickHop));
        } else {
            this.showActionDialog(e, real, fSingleClick, fSingleClickType, fSingleClickTransform, fSingleClickNote, fSingleClickHop);
        }
        this.lastButton = 0;
    }

    @GuiContextAction(id="pipeline-graph-transform-1000-view-output", parentId="HopGuiPipelineTransformContext", type=GuiActionType.Info, name="i18n::HopGuiPipelineGraph.ViewOutput.GuiAction.Name", tooltip="i18n::HopGuiPipelineGraph.ViewOutput.GuiAction.Tooltip", image="ui/images/data.svg", category="Preview", categoryOrder="3")
    public void showTransformOutputData(HopGuiPipelineTransformContext context) {
        RowBuffer rowBuffer;
        TransformMeta dataTransformMeta = context.getTransformMeta();
        if (this.outputRowsMap != null && (rowBuffer = this.outputRowsMap.get(dataTransformMeta.getName())) != null) {
            this.showTransformOutputData(dataTransformMeta, rowBuffer);
        }
    }

    public boolean showTransformOutputData(AreaOwner areaOwner) {
        TransformMeta dataTransform = (TransformMeta)areaOwner.getParent();
        RowBuffer rowBuffer = (RowBuffer)areaOwner.getOwner();
        return this.showTransformOutputData(dataTransform, rowBuffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean showTransformOutputData(TransformMeta dataTransformMeta, RowBuffer rowBuffer) {
        if (rowBuffer != null) {
            List list = rowBuffer.getBuffer();
            synchronized (list) {
                if (!rowBuffer.isEmpty()) {
                    try {
                        LocalPipelineRunConfiguration localPipelineRunConfiguration;
                        String sampleTypeInGui;
                        PipelineRunConfiguration pipelineRunConfiguration;
                        IPipelineEngineRunConfiguration iPipelineEngineRunConfiguration;
                        String title = BaseMessages.getString(PKG, (String)"PipelineGraph.ViewOutput.OutputDialog.Header", (String[])new String[]{dataTransformMeta.getName()});
                        String message = BaseMessages.getString(PKG, (String)"PipelineGraph.ViewOutput.OutputDialog.OutputRows.Text", (String[])new String[]{dataTransformMeta.getName()});
                        Object prefix = "";
                        if (this.pipeline != null && this.pipeline.getPipelineRunConfiguration() != null && (iPipelineEngineRunConfiguration = (pipelineRunConfiguration = this.pipeline.getPipelineRunConfiguration()).getEngineRunConfiguration()) instanceof LocalPipelineRunConfiguration && StringUtils.isNotEmpty((String)(sampleTypeInGui = (localPipelineRunConfiguration = (LocalPipelineRunConfiguration)iPipelineEngineRunConfiguration).getSampleTypeInGui()))) {
                            try {
                                LocalPipelineRunConfiguration.SampleType sampleType = LocalPipelineRunConfiguration.SampleType.valueOf((String)sampleTypeInGui);
                                switch (sampleType) {
                                    case None: {
                                        break;
                                    }
                                    case First: {
                                        prefix = BaseMessages.getString(PKG, (String)"PipelineGraph.ViewOutput.OutputDialog.First.Text", (String[])new String[0]);
                                        break;
                                    }
                                    case Last: {
                                        prefix = BaseMessages.getString(PKG, (String)"PipelineGraph.ViewOutput.OutputDialog.Last.Text", (String[])new String[0]);
                                        break;
                                    }
                                    case Random: {
                                        prefix = (String)prefix + BaseMessages.getString(PKG, (String)"PipelineGraph.ViewOutput.OutputDialog.Random.Text", (String[])new String[0]);
                                        break;
                                    }
                                }
                            }
                            catch (Exception ex) {
                                LogChannel.UI.logError("Unknown sample type: " + sampleTypeInGui);
                            }
                        }
                        PreviewRowsDialog previewRowsDialog = new PreviewRowsDialog(this.hopGui.getActiveShell(), this.variables, 0, dataTransformMeta.getName(), rowBuffer.getRowMeta(), rowBuffer.getBuffer());
                        previewRowsDialog.setTitleMessage(title, (String)prefix + message);
                        previewRowsDialog.open();
                    }
                    catch (Exception ex) {
                        new ErrorDialog(this.hopGui.getActiveShell(), CONST_ERROR, "Error showing preview dialog", ex);
                    }
                }
            }
            return true;
        }
        return false;
    }

    private void showActionDialog(MouseEvent e, Point real, boolean fSingleClick, SingleClickType fSingleClickType, TransformMeta fSingleClickTransform, NotePadMeta fSingleClickNote, PipelineHopMeta fSingleClickHop) {
        this.selectionRegion = null;
        if (!(fSingleClickType != SingleClickType.Pipeline || this.pipelineMeta.getSelectedTransforms().isEmpty() && this.pipelineMeta.getSelectedNotes().isEmpty())) {
            this.pipelineMeta.unselectAll();
            this.selectionRegion = null;
            this.updateGui();
            this.toolTip.setVisible(false);
            this.toolTip.setAutoHide(true);
            this.toolTip.setText(Const.CR + "  Selection cleared " + Const.CR);
            this.showToolTip(new org.eclipse.swt.graphics.Point(e.x, e.y));
            return;
        }
        if (!this.doubleClick && fSingleClick && fSingleClickType != null) {
            BaseGuiContextHandler contextHandler = null;
            String message = null;
            switch (fSingleClickType) {
                case Pipeline: {
                    message = BaseMessages.getString(PKG, (String)"PipelineGraph.ContextualActionDialog.Pipeline.Header", (String[])new String[0]);
                    contextHandler = new HopGuiPipelineContext(this.pipelineMeta, this, real);
                    break;
                }
                case Transform: {
                    message = BaseMessages.getString(PKG, (String)"PipelineGraph.ContextualActionDialog.Transform.Header", (String[])new String[]{fSingleClickTransform.getName()});
                    contextHandler = new HopGuiPipelineTransformContext(this.pipelineMeta, fSingleClickTransform, this, real);
                    break;
                }
                case Note: {
                    message = BaseMessages.getString(PKG, (String)"PipelineGraph.ContextualActionDialog.Note.Header", (String[])new String[0]);
                    contextHandler = new HopGuiPipelineNoteContext(this.pipelineMeta, fSingleClickNote, this, real);
                    break;
                }
                case Hop: {
                    message = BaseMessages.getString(PKG, (String)"PipelineGraph.ContextualActionDialog.Hop.Header", (String[])new String[0]);
                    contextHandler = new HopGuiPipelineHopContext(this.pipelineMeta, fSingleClickHop, this, real);
                    break;
                }
            }
            if (contextHandler != null) {
                Shell parent = this.hopShell();
                org.eclipse.swt.graphics.Point p = parent.getDisplay().map((Control)this.canvas, null, e.x, e.y);
                this.openedContextDialog = true;
                this.hideToolTips();
                this.avoidContextDialog = GuiContextUtil.getInstance().handleActionSelection(parent, message, new Point(p.x, p.y), (IGuiContextHandler)((Object)contextHandler));
                this.openedContextDialog = false;
            }
        }
    }

    private void splitHop(PipelineHopMeta hop) {
        int id = 0;
        if (!this.hopGui.getProps().getAutoSplit()) {
            MessageDialogWithToggle md = new MessageDialogWithToggle(this.hopShell(), BaseMessages.getString(PKG, (String)"PipelineGraph.Dialog.SplitHop.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"PipelineGraph.Dialog.SplitHop.Message", (String[])new String[0]) + Const.CR + hop.toString(), 4, new String[]{BaseMessages.getString(PKG, (String)"System.Button.Yes", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.Button.No", (String[])new String[0])}, BaseMessages.getString(PKG, (String)"PipelineGraph.Dialog.Option.SplitHop.DoNotAskAgain", (String[])new String[0]), this.hopGui.getProps().getAutoSplit());
            id = md.open();
            this.hopGui.getProps().setAutoSplit(md.getToggleState());
        }
        if ((id & 0xFF) == 0) {
            this.pipelineTransformDelegate.insertTransform(this.pipelineMeta, hop, this.currentTransform);
            this.redraw();
        }
        this.splitHop = false;
    }

    public void mouseMove(MouseEvent event) {
        int dy;
        boolean shift = (event.stateMask & 0x20000) != 0;
        this.noInputTransform = null;
        this.mouseMovedSinceClick = true;
        boolean doRedraw = false;
        PipelineHopMeta hop = null;
        this.toolTip.setVisible(false);
        if (this.viewPortNavigation) {
            this.dragViewPort(new Point(event.x, event.y));
            return;
        }
        Point real = this.screen2real(event.x, event.y);
        this.currentMouseX = real.x;
        this.currentMouseY = real.y;
        this.lastMove = real;
        if (this.iconOffset == null) {
            this.iconOffset = new Point(0, 0);
        }
        Point icon = new Point(real.x - this.iconOffset.x, real.y - this.iconOffset.y);
        if (this.noteOffset == null) {
            this.noteOffset = new Point(0, 0);
        }
        Point note = new Point(real.x - this.noteOffset.x, real.y - this.noteOffset.y);
        AreaOwner areaOwner = this.getVisibleAreaOwner(real.x, real.y);
        if (areaOwner == null) {
            hop = this.findPipelineHop(real.x, real.y);
        }
        try {
            HopGuiPipelineGraphExtension ext = new HopGuiPipelineGraphExtension(this, event, real, areaOwner);
            ExtensionPointHandler.callExtensionPoint((ILogChannel)LogChannel.GENERAL, (IVariables)this.variables, (String)HopExtensionPoint.PipelineGraphMouseMoved.id, (Object)ext);
            if (ext.isPreventingDefault()) {
                return;
            }
        }
        catch (Exception ex) {
            LogChannel.GENERAL.logError("Error calling PipelineGraphMouseMoved extension point", (Throwable)ex);
        }
        if (!PropsUi.getInstance().useDoubleClick()) {
            if (areaOwner != null && areaOwner.getAreaType() == AreaOwner.AreaType.TRANSFORM_NAME) {
                if (this.mouseOverName == null) {
                    doRedraw = true;
                }
                this.mouseOverName = (String)areaOwner.getOwner();
            } else {
                if (this.mouseOverName != null) {
                    doRedraw = true;
                }
                this.mouseOverName = null;
            }
        }
        if (this.selectedTransform != null && !this.selectedTransform.isSelected()) {
            this.pipelineMeta.unselectAll();
            this.selectedTransform.setSelected(true);
            this.selectedTransforms = new ArrayList<TransformMeta>();
            this.selectedTransforms.add(this.selectedTransform);
            this.previousTransformLocations = new Point[]{this.selectedTransform.getLocation()};
            doRedraw = true;
        } else if (this.selectedNote != null && !this.selectedNote.isSelected()) {
            this.pipelineMeta.unselectAll();
            this.selectedNote.setSelected(true);
            this.selectedNotes = new ArrayList<NotePadMeta>();
            this.selectedNotes.add(this.selectedNote);
            this.previousNoteLocations = new Point[]{this.selectedNote.getLocation()};
            doRedraw = true;
        } else if (this.selectionRegion != null && this.startHopTransform == null) {
            this.selectionRegion.width = real.x - this.selectionRegion.x;
            this.selectionRegion.height = real.y - this.selectionRegion.y;
            doRedraw = true;
        } else if (this.selectedTransform != null && this.lastButton == 1 && !shift && this.startHopTransform == null) {
            int dx = icon.x - this.selectedTransform.getLocation().x;
            dy = icon.y - this.selectedTransform.getLocation().y;
            PipelineHopMeta hi = this.findPipelineHop(icon.x + this.iconSize / 2, icon.y + this.iconSize / 2, this.selectedTransform);
            if (hi != null) {
                if (this.pipelineMeta.findPipelineHop(this.selectedTransform, hi.getFromTransform()) == null && this.pipelineMeta.findPipelineHop(this.selectedTransform, hi.getToTransform()) == null && this.pipelineMeta.findPipelineHop(hi.getToTransform(), this.selectedTransform) == null && this.pipelineMeta.findPipelineHop(hi.getFromTransform(), this.selectedTransform) == null) {
                    this.splitHop = true;
                    this.lastHopSplit = hi;
                    hi.split = true;
                }
            } else if (this.lastHopSplit != null) {
                this.lastHopSplit.split = false;
                this.lastHopSplit = null;
                this.splitHop = false;
            }
            this.moveSelected(dx, dy);
            doRedraw = true;
        } else if (this.startHopTransform != null && this.endHopTransform == null || this.endHopTransform != null && this.startHopTransform == null) {
            TransformMeta transformMeta = this.pipelineMeta.getTransform(real.x, real.y, this.iconSize);
            this.endHopLocation = new Point(real.x, real.y);
            if (transformMeta != null && (this.startHopTransform != null && !this.startHopTransform.equals((Object)transformMeta) || this.endHopTransform != null && !this.endHopTransform.equals((Object)transformMeta))) {
                ITransformIOMeta ioMeta = transformMeta.getTransform().getTransformIOMeta();
                if (this.candidate == null) {
                    if (this.startHopTransform != null) {
                        if (ioMeta.isInputAcceptor()) {
                            this.candidate = new PipelineHopMeta(this.startHopTransform, transformMeta);
                            this.endHopLocation = null;
                        } else {
                            this.noInputTransform = transformMeta;
                            this.toolTip.setText("This transform does not accept any input from other transforms");
                            this.showToolTip(new org.eclipse.swt.graphics.Point(real.x, real.y));
                        }
                    } else if (this.endHopTransform != null) {
                        if (ioMeta.isOutputProducer()) {
                            this.candidate = new PipelineHopMeta(transformMeta, this.endHopTransform);
                            this.endHopLocation = null;
                        } else {
                            this.noInputTransform = transformMeta;
                            this.toolTip.setText("This transform doesn't pass any output to other transforms. (except perhaps for targetted output)");
                            this.showToolTip(new org.eclipse.swt.graphics.Point(real.x, real.y));
                        }
                    }
                }
            } else if (this.candidate != null) {
                this.candidate = null;
                doRedraw = true;
            }
            doRedraw = true;
        } else if (this.viewDrag && this.lastClick != null) {
            this.dragView(this.viewDragStart, new Point(event.x, event.y));
        }
        if (this.selectedNote != null && this.lastButton == 1 && !shift) {
            int dx = note.x - this.selectedNote.getLocation().x;
            dy = note.y - this.selectedNote.getLocation().y;
            this.moveSelected(dx, dy);
            doRedraw = true;
        }
        Cursor cursor = null;
        if (this.viewDrag || this.viewPortNavigation) {
            cursor = this.getDisplay().getSystemCursor(5);
        } else if (this.selectionRegion != null) {
            cursor = this.getDisplay().getSystemCursor(2);
        } else if (hop != null || areaOwner != null && areaOwner.getAreaType() != null && areaOwner.getAreaType().isSupportHover()) {
            cursor = this.getDisplay().getSystemCursor(21);
        }
        this.setCursor(cursor);
        if (doRedraw) {
            this.redraw();
        }
    }

    public void mouseHover(MouseEvent event) {
        boolean tip = true;
        this.toolTip.setVisible(false);
        Point real = this.screen2real(event.x, event.y);
        if (tip) {
            this.setToolTip(real.x, real.y, event.x, event.y);
        }
    }

    protected void moveSelected(int dx, int dy) {
        Point location;
        this.selectedNotes = this.pipelineMeta.getSelectedNotes();
        this.selectedTransforms = this.pipelineMeta.getSelectedTransforms();
        if (this.selectedTransforms != null) {
            for (TransformMeta transformMeta : this.selectedTransforms) {
                location = transformMeta.getLocation();
                if (location.x + dx < 0) {
                    dx = -location.x;
                }
                if (location.y + dy >= 0) continue;
                dy = -location.y;
            }
        }
        if (this.selectedNotes != null) {
            for (NotePadMeta notePad : this.selectedNotes) {
                location = notePad.getLocation();
                if (location.x + dx < 0) {
                    dx = -location.x;
                }
                if (location.y + dy >= 0) continue;
                dy = -location.y;
            }
        }
        if (this.selectedTransforms != null) {
            for (TransformMeta transformMeta : this.selectedTransforms) {
                PropsUi.setLocation((IGuiPosition)transformMeta, transformMeta.getLocation().x + dx, transformMeta.getLocation().y + dy);
            }
        }
        if (this.selectedNotes != null) {
            for (NotePadMeta notePadMeta : this.selectedNotes) {
                PropsUi.setLocation((IGuiPosition)notePadMeta, notePadMeta.getLocation().x + dx, notePadMeta.getLocation().y + dy);
            }
        }
    }

    private void addCandidateAsHop(int mouseX, int mouseY) {
        TransformMeta toTransform;
        boolean forward = this.startHopTransform != null;
        TransformMeta fromTransform = this.candidate.getFromTransform();
        if (fromTransform.equals((Object)(toTransform = this.candidate.getToTransform()))) {
            return;
        }
        ArrayList<Stream> streams = new ArrayList<Stream>();
        ITransformIOMeta fromIoMeta = fromTransform.getTransform().getTransformIOMeta();
        List targetStreams = fromIoMeta.getTargetStreams();
        if (forward) {
            streams.addAll(targetStreams);
        }
        ITransformIOMeta toIoMeta = toTransform.getTransform().getTransformIOMeta();
        List infoStreams = toIoMeta.getInfoStreams();
        if (!forward) {
            streams.addAll(infoStreams);
        }
        if (forward) {
            if (fromIoMeta.isOutputProducer() && toTransform.equals((Object)this.currentTransform)) {
                streams.add(new Stream(IStream.StreamType.OUTPUT, fromTransform, BaseMessages.getString(PKG, (String)"HopGui.Hop.MainOutputOfTransform", (String[])new String[0]), StreamIcon.OUTPUT, null));
            }
            if (fromTransform.supportsErrorHandling() && toTransform.equals((Object)this.currentTransform)) {
                streams.add(new Stream(IStream.StreamType.ERROR, fromTransform, BaseMessages.getString(PKG, (String)"HopGui.Hop.ErrorHandlingOfTransform", (String[])new String[0]), StreamIcon.ERROR, null));
            }
        } else {
            if (toIoMeta.isInputAcceptor() && fromTransform.equals((Object)this.currentTransform)) {
                streams.add(new Stream(IStream.StreamType.INPUT, toTransform, BaseMessages.getString(PKG, (String)"HopGui.Hop.MainInputOfTransform", (String[])new String[0]), StreamIcon.INPUT, null));
            }
            if (fromTransform.supportsErrorHandling() && fromTransform.equals((Object)this.currentTransform)) {
                streams.add(new Stream(IStream.StreamType.ERROR, fromTransform, BaseMessages.getString(PKG, (String)"HopGui.Hop.ErrorHandlingOfTransform", (String[])new String[0]), StreamIcon.ERROR, null));
            }
        }
        if (forward) {
            streams.addAll(fromTransform.getTransform().getOptionalStreams());
        } else {
            streams.addAll(toTransform.getTransform().getOptionalStreams());
        }
        if (streams.size() > 1) {
            Menu menu = new Menu((Control)this.canvas);
            for (final IStream iStream : streams) {
                MenuItem item = new MenuItem(menu, 0);
                item.setText(Const.NVL((String)iStream.getDescription(), (String)""));
                item.setImage(this.getImageFor(iStream));
                item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        HopGuiPipelineGraph.this.addHop(iStream);
                    }
                });
            }
            menu.setLocation(this.canvas.toDisplay(mouseX, mouseY));
            menu.setVisible(true);
            return;
        }
        if (streams.size() != 1) {
            return;
        }
        this.addHop((IStream)streams.get(0));
        this.candidate = null;
        this.selectedTransforms = null;
        this.startHopTransform = null;
        this.endHopLocation = null;
        this.startErrorHopTransform = false;
    }

    private Image getImageFor(IStream stream) {
        Display disp = this.hopDisplay();
        SwtUniversalImage swtImage = SwtGc.getNativeImage(BasePainter.getStreamIconImage((StreamIcon)stream.getStreamIcon(), (boolean)true));
        return swtImage.getAsBitmapForSize((Device)disp, 16, 16);
    }

    protected void addHop(IStream stream) {
        if (this.candidate == null) {
            return;
        }
        switch (stream.getStreamType()) {
            case ERROR: {
                this.addErrorHop();
                this.candidate.setErrorHop(true);
                this.pipelineHopDelegate.newHop(this.pipelineMeta, this.candidate);
                break;
            }
            case INPUT: {
                this.pipelineHopDelegate.newHop(this.pipelineMeta, this.candidate);
                break;
            }
            case OUTPUT: {
                TransformErrorMeta transformErrorMeta = this.candidate.getFromTransform().getTransformErrorMeta();
                if (transformErrorMeta != null && transformErrorMeta.getTargetTransform() != null && transformErrorMeta.getTargetTransform().equals((Object)this.candidate.getToTransform())) {
                    this.candidate.getFromTransform().setTransformErrorMeta(null);
                }
                this.pipelineHopDelegate.newHop(this.pipelineMeta, this.candidate);
                break;
            }
            case INFO: {
                stream.setTransformMeta(this.candidate.getFromTransform());
                this.candidate.getToTransform().getTransform().handleStreamSelection(stream);
                this.pipelineHopDelegate.newHop(this.pipelineMeta, this.candidate);
                break;
            }
            case TARGET: {
                stream.setTransformMeta(this.candidate.getToTransform());
                this.candidate.getFromTransform().getTransform().handleStreamSelection(stream);
                this.pipelineHopDelegate.newHop(this.pipelineMeta, this.candidate);
                break;
            }
        }
        this.clearSettings();
    }

    private void addErrorHop() {
        if (this.candidate == null || this.candidate.getFromTransform() == null) {
            return;
        }
        TransformErrorMeta errorMeta = this.candidate.getFromTransform().getTransformErrorMeta();
        if (errorMeta == null) {
            errorMeta = new TransformErrorMeta(this.candidate.getFromTransform());
        }
        errorMeta.setEnabled(true);
        errorMeta.setTargetTransform(this.candidate.getToTransform());
        this.candidate.getFromTransform().setTransformErrorMeta(errorMeta);
    }

    public void mouseEnter(MouseEvent arg0) {
    }

    public void mouseExit(MouseEvent arg0) {
    }

    protected void asyncRedraw() {
        this.hopDisplay().asyncExec(() -> {
            if (!this.isDisposed()) {
                this.redraw();
            }
        });
    }

    @GuiToolbarElement(root="HopGuiPipelineGraph-Toolbar", id="HopGuiPipelineGraph-ToolBar-10500-Zoom-Level", label="i18n:org.apache.hop.ui.hopgui:HopGui.Toolbar.Zoom", toolTip="i18n::HopGuiPipelineGraph.GuiAction.ZoomInOut.Tooltip", type=GuiToolbarElementType.COMBO, alignRight=true, comboValuesMethod="getZoomLevels")
    public void zoomLevel() {
        this.readMagnification();
        this.redraw();
    }

    @Override
    @GuiToolbarElement(root="HopGuiPipelineGraph-Toolbar", id="HopGuiPipelineGraph-ToolBar-10520-Zoom-In", toolTip="i18n::HopGuiPipelineGraph.GuiAction.ZoomIn.Tooltip", type=GuiToolbarElementType.BUTTON, image="ui/images/zoom-in.svg")
    public void zoomIn() {
        super.zoomIn();
    }

    @Override
    @GuiToolbarElement(root="HopGuiPipelineGraph-Toolbar", id="HopGuiPipelineGraph-ToolBar-10510-Zoom-Out", toolTip="i18n::HopGuiPipelineGraph.GuiAction.ZoomOut.Tooltip", type=GuiToolbarElementType.BUTTON, image="ui/images/zoom-out.svg")
    public void zoomOut() {
        super.zoomOut();
    }

    @Override
    @GuiToolbarElement(root="HopGuiPipelineGraph-Toolbar", id="HopGuiPipelineGraph-ToolBar-10540-Zoom-To-Fit", toolTip="i18n::HopGuiPipelineGraph.GuiAction.ZoomFitToScreen.Tooltip", type=GuiToolbarElementType.BUTTON, image="ui/images/zoom-fit.svg")
    public void zoomFitToScreen() {
        super.zoomFitToScreen();
    }

    @Override
    @GuiToolbarElement(root="HopGuiPipelineGraph-Toolbar", id="HopGuiPipelineGraph-ToolBar-10530-Zoom-100Pct", toolTip="i18n::HopGuiPipelineGraph.GuiAction.Zoom100.Tooltip", type=GuiToolbarElementType.BUTTON, image="ui/images/zoom-100.svg")
    public void zoom100Percent() {
        super.zoom100Percent();
    }

    public List<String> getZoomLevels() {
        return Arrays.asList(PipelinePainter.magnificationDescriptions);
    }

    private void addToolBar() {
        try {
            this.toolBar = new ToolBar((Composite)this, 16704);
            this.toolBarWidgets = new GuiToolbarWidgets();
            this.toolBarWidgets.registerGuiPluginObject(this);
            this.toolBarWidgets.createToolbarWidgets((Composite)this.toolBar, GUI_PLUGIN_TOOLBAR_PARENT_ID);
            FormData layoutData = new FormData();
            layoutData.left = new FormAttachment(0, 0);
            layoutData.top = new FormAttachment(0, 0);
            layoutData.right = new FormAttachment(100, 0);
            this.toolBar.setLayoutData((Object)layoutData);
            this.toolBar.pack();
            PropsUi.setLook((Widget)this.toolBar, 5);
            this.updateGui();
        }
        catch (Throwable t) {
            this.log.logError("Error setting up the navigation toolbar for HopUI", t);
            new ErrorDialog(this.hopShell(), CONST_ERROR, "Error setting up the navigation toolbar for HopGUI", new Exception(t));
        }
    }

    @Override
    public void setZoomLabel() {
        String oldString;
        Combo combo = (Combo)this.toolBarWidgets.getWidgetsMap().get(TOOLBAR_ITEM_ZOOM_LEVEL);
        if (combo == null || combo.isDisposed()) {
            return;
        }
        String newString = Math.round(this.magnification * 100.0f) + "%";
        if (!newString.equals(oldString = combo.getText())) {
            combo.setText(Math.round(this.magnification * 100.0f) + "%");
        }
    }

    private void readMagnification() {
        Combo zoomLabel = (Combo)this.toolBarWidgets.getWidgetsMap().get(TOOLBAR_ITEM_ZOOM_LEVEL);
        if (zoomLabel == null) {
            return;
        }
        String possibleText = zoomLabel.getText().replace("%", "");
        try {
            float possibleFloatMagnification;
            this.magnification = possibleFloatMagnification = Float.parseFloat(possibleText) / 100.0f;
            if (zoomLabel.getText().indexOf(37) < 0) {
                zoomLabel.setText(zoomLabel.getText().concat("%"));
            }
        }
        catch (Exception e) {
            this.modalMessageDialog(BaseMessages.getString(PKG, (String)"PipelineGraph.Dialog.InvalidZoomMeasurement.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"PipelineGraph.Dialog.InvalidZoomMeasurement.Message", (String[])new String[]{zoomLabel.getText()}), 65);
        }
        this.canvas.setFocus();
        this.redraw();
    }

    protected void hideToolTips() {
        this.toolTip.setVisible(false);
    }

    public void selectInRect(PipelineMeta pipelineMeta, Rectangle rect) {
        if (rect.height < 0) {
            rect.y += rect.height;
            rect.height = -rect.height;
        }
        if (rect.width < 0) {
            rect.x += rect.width;
            rect.width = -rect.width;
        }
        for (TransformMeta transform : pipelineMeta.getTransforms()) {
            if (!rect.contains(transform.getLocation())) continue;
            transform.setSelected(true);
        }
        for (NotePadMeta note : pipelineMeta.getNotes()) {
            Point a = note.getLocation();
            Point b = new Point(a.x + note.width, a.y + note.height);
            if (!rect.contains(a) || !rect.contains(b)) continue;
            note.setSelected(true);
        }
    }

    public boolean setFocus() {
        return this.canvas != null && !this.canvas.isDisposed() ? this.canvas.setFocus() : false;
    }

    public void renameTransform(TransformMeta transformMeta, String transformName) {
        Object newname = transformName;
        TransformMeta smeta = this.pipelineMeta.findTransform((String)newname, transformMeta);
        int nr = 2;
        while (smeta != null) {
            newname = (String)transformName + " " + nr;
            smeta = this.pipelineMeta.findTransform((String)newname);
            ++nr;
        }
        if (nr > 2) {
            transformName = newname;
            this.modalMessageDialog(BaseMessages.getString(PKG, (String)"HopGui.Dialog.TransformnameExists.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"HopGui.Dialog.TransformnameExists.Message", (String[])new String[]{transformName}), 34);
        }
        transformMeta.setName((String)transformName);
        transformMeta.setChanged();
        this.redraw();
    }

    public void clearSettings() {
        this.selectedTransform = null;
        this.noInputTransform = null;
        this.selectedNote = null;
        this.selectedTransforms = null;
        this.selectionRegion = null;
        this.candidate = null;
        this.lastHopSplit = null;
        this.lastButton = 0;
        this.iconOffset = null;
        this.startHopTransform = null;
        this.endHopTransform = null;
        this.endHopLocation = null;
        this.pipelineMeta.unselectAll();
        for (int i = 0; i < this.pipelineMeta.nrPipelineHops(); ++i) {
            this.pipelineMeta.getPipelineHop(i).setSplit(false);
        }
    }

    protected PipelineHopMeta findPipelineHop(int x, int y) {
        return this.findPipelineHop(x, y, null);
    }

    private PipelineHopMeta findPipelineHop(int x, int y, TransformMeta exclude) {
        PipelineHopMeta online = null;
        for (int i = 0; i < this.pipelineMeta.nrPipelineHops(); ++i) {
            int[] line;
            PipelineHopMeta hi = this.pipelineMeta.getPipelineHop(i);
            TransformMeta fs = hi.getFromTransform();
            TransformMeta ts = hi.getToTransform();
            if (fs == null || ts == null) {
                return null;
            }
            if (exclude != null && (exclude.equals((Object)fs) || exclude.equals((Object)ts)) || !this.pointOnLine(x, y, line = this.getLine(fs, ts))) continue;
            online = hi;
        }
        return online;
    }

    private int[] getLine(TransformMeta fs, TransformMeta ts) {
        Point from = fs.getLocation();
        Point to = ts.getLocation();
        int x1 = from.x + this.iconSize / 2;
        int y1 = from.y + this.iconSize / 2;
        int x2 = to.x + this.iconSize / 2;
        int y2 = to.y + this.iconSize / 2;
        return new int[]{x1, y1, x2, y2};
    }

    @GuiContextAction(id="pipeline-graph-transform-90000-transform-help", parentId="HopGuiPipelineTransformContext", type=GuiActionType.Info, name="i18n::System.Button.Help", tooltip="i18n::System.Tooltip.Help", image="ui/images/help.svg", category="Basic", categoryOrder="1")
    public void openTransformHelp(HopGuiPipelineTransformContext context) {
        IPlugin plugin = PluginRegistry.getInstance().getPlugin(TransformPluginType.class, context.getTransformMeta().getPluginId());
        HelpUtils.openHelp(this.getShell(), plugin);
    }

    @GuiContextAction(id="pipeline-graph-transform-10100-transform-detach", parentId="HopGuiPipelineTransformContext", type=GuiActionType.Modify, name="i18n::HopGuiPipelineGraph.TransformAction.DetachTransform.Name", tooltip="i18n::HopGuiPipelineGraph.TransformAction.DetachTransform.Tooltip", image="ui/images/hop-delete.svg", category="Basic", categoryOrder="1")
    public void detachTransform(HopGuiPipelineTransformContext context) {
        TransformMeta transformMeta = context.getTransformMeta();
        PipelineHopMeta fromHop = this.pipelineMeta.findPipelineHopTo(transformMeta);
        PipelineHopMeta toHop = this.pipelineMeta.findPipelineHopFrom(transformMeta);
        for (int i = this.pipelineMeta.nrPipelineHops() - 1; i >= 0; --i) {
            PipelineHopMeta hop = this.pipelineMeta.getPipelineHop(i);
            if (!transformMeta.equals((Object)hop.getFromTransform()) && !transformMeta.equals((Object)hop.getToTransform())) continue;
            this.hopGui.undoDelegate.addUndoNew((IUndo)this.pipelineMeta, new PipelineHopMeta[]{hop}, new int[]{i});
            this.pipelineMeta.removePipelineHop(i);
        }
        if (fromHop != null && toHop != null) {
            this.pipelineHopDelegate.newHop(this.pipelineMeta, new PipelineHopMeta(fromHop.getFromTransform(), toHop.getToTransform()));
        }
        this.updateGui();
    }

    @GuiContextAction(id="pipeline-graph-transform-10700-partitioning", parentId="HopGuiPipelineTransformContext", type=GuiActionType.Modify, name="i18n::HopGuiPipelineGraph.TransformAction.Partitioning.Name", tooltip="i18n::HopGuiPipelineGraph.TransformAction.Partitioning.Tooltip", image="ui/images/partition_schema.svg", category="Data routing", categoryOrder="2")
    public void partitioning(HopGuiPipelineTransformContext context) {
        this.pipelineTransformDelegate.editTransformPartitioning(this.pipelineMeta, context.getTransformMeta());
    }

    @GuiContextAction(id="pipeline-graph-transform-10800-error-handling", parentId="HopGuiPipelineTransformContext", type=GuiActionType.Modify, name="i18n::HopGuiPipelineGraph.TransformAction.ErrorHandling.Name", tooltip="i18n::HopGuiPipelineGraph.TransformAction.ErrorHandling.Tooltip", image="ui/images/error.svg", category="Data routing", categoryOrder="2")
    public void errorHandling(HopGuiPipelineTransformContext context) {
        this.pipelineTransformDelegate.editTransformErrorHandling(this.pipelineMeta, context.getTransformMeta());
    }

    public void newHopChoice() {
        this.selectedTransforms = null;
        this.newHop();
    }

    @GuiContextAction(id="pipeline-graph-transform-10000-edit", parentId="HopGuiPipelineTransformContext", type=GuiActionType.Modify, name="i18n::HopGuiPipelineGraph.TransformAction.EditTransform.Name", tooltip="i18n::HopGuiPipelineGraph.TransformAction.EditTransform.Tooltip", image="ui/images/edit.svg", category="Basic", categoryOrder="1")
    public void editTransform(HopGuiPipelineTransformContext context) {
        this.editTransform(context.getTransformMeta());
    }

    public void editTransform() {
        this.selectedTransforms = null;
        this.editTransform(this.getCurrentTransform());
    }

    @GuiContextAction(id="pipeline-graph-transform-10800-edit-description", parentId="HopGuiPipelineTransformContext", type=GuiActionType.Modify, name="i18n::HopGuiPipelineGraph.TransformAction.EditDescription.Name", tooltip="i18n::HopGuiPipelineGraph.TransformAction.EditDescription.Tooltip", image="ui/images/edit_description.svg", category="Basic", categoryOrder="1")
    public void editDescription(HopGuiPipelineTransformContext context) {
        this.editDescription(context.getTransformMeta());
    }

    @GuiContextAction(id="pipeline-graph-transform-10600-rows-distribute", parentId="HopGuiPipelineTransformContext", type=GuiActionType.Modify, name="i18n::HopGuiPipelineGraph.TransformAction.DistributeRows.Name", tooltip="i18n::HopGuiPipelineGraph.TransformAction.DistributeRows.Tooltip", image="ui/images/distribute.svg", category="Data routing", categoryOrder="2")
    public void setDistributes(HopGuiPipelineTransformContext context) {
        context.getTransformMeta().setDistributes(true);
        context.getTransformMeta().setRowDistribution(null);
        this.redraw();
    }

    @GuiContextAction(id="pipeline-graph-transform-10650-rows-copy", parentId="HopGuiPipelineTransformContext", type=GuiActionType.Modify, name="i18n::HopGuiPipelineGraph.TransformAction.CopyRows.Name", tooltip="i18n::HopGuiPipelineGraph.TransformAction.CopyRows.Tooltip", image="ui/images/copy-rows.svg", category="Data routing", categoryOrder="2")
    public void setCopies(HopGuiPipelineTransformContext context) {
        context.getTransformMeta().setDistributes(false);
        context.getTransformMeta().setRowDistribution(null);
        this.redraw();
    }

    public IRowDistribution askUserForCustomDistributionMethod() {
        List plugins = PluginRegistry.getInstance().getPlugins(RowDistributionPluginType.class);
        if (Utils.isEmpty((List)plugins)) {
            return null;
        }
        ArrayList<CallSite> choices = new ArrayList<CallSite>();
        for (IPlugin plugin : plugins) {
            choices.add((CallSite)((Object)(plugin.getName() + " : " + plugin.getDescription())));
        }
        EnterSelectionDialog dialog = new EnterSelectionDialog(this.hopShell(), choices.toArray(new String[choices.size()]), BaseMessages.getString(PKG, (String)"HopGuiPipelineGraph.DistributionMethodDialog.Header", (String[])new String[0]), BaseMessages.getString(PKG, (String)"HopGuiPipelineGraph.DistributionMethodDialog.Text", (String[])new String[0]));
        if (dialog.open() != null) {
            IPlugin plugin;
            plugin = (IPlugin)plugins.get(dialog.getSelectionNr());
            try {
                return (IRowDistribution)PluginRegistry.getInstance().loadClass(plugin);
            }
            catch (Exception e) {
                new ErrorDialog(this.hopShell(), CONST_ERROR, "Error loading row distribution plugin class", e);
                return null;
            }
        }
        return null;
    }

    @GuiContextAction(id="pipeline-graph-transform-10100-copies", parentId="HopGuiPipelineTransformContext", type=GuiActionType.Modify, name="i18n::HopGuiPipelineGraph.TransformAction.SpecifyCopies.Name", tooltip="i18n::HopGuiPipelineGraph.TransformAction.SpecifyCopies.Tooltip", image="ui/images/exponent.svg", category="Data routing", categoryOrder="2")
    public void copies(HopGuiPipelineTransformContext context) {
        TransformMeta transformMeta = context.getTransformMeta();
        this.copies(transformMeta);
    }

    public void copies(TransformMeta transformMeta) {
        boolean multipleOK = this.checkNumberOfCopies(this.pipelineMeta, transformMeta);
        this.selectedTransforms = null;
        String tt = BaseMessages.getString(PKG, (String)"PipelineGraph.Dialog.NrOfCopiesOfTransform.Title", (String[])new String[0]);
        String mt = BaseMessages.getString(PKG, (String)"PipelineGraph.Dialog.NrOfCopiesOfTransform.Message", (String[])new String[0]);
        EnterStringDialog nd = new EnterStringDialog(this.hopShell(), transformMeta.getCopiesString(), tt, mt, true, this.variables);
        String cop = nd.open();
        if (!Utils.isEmpty((CharSequence)cop)) {
            String cps;
            int copies = Const.toInt((String)this.hopGui.getVariables().resolve(cop), (int)-1);
            if (copies > 1 && !multipleOK) {
                cop = "1";
                this.modalMessageDialog(BaseMessages.getString(PKG, (String)"PipelineGraph.Dialog.MultipleCopiesAreNotAllowedHere.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"PipelineGraph.Dialog.MultipleCopiesAreNotAllowedHere.Message", (String[])new String[0]), 72);
            }
            if ((cps = transformMeta.getCopiesString()) != null && !cps.equals(cop) || cps == null && cop != null) {
                transformMeta.setChanged();
            }
            transformMeta.setCopiesString(cop);
            this.redraw();
        }
    }

    @GuiContextAction(id="pipeline-graph-transform-10900-delete", parentId="HopGuiPipelineTransformContext", type=GuiActionType.Delete, name="i18n::HopGuiPipelineGraph.TransformAction.DeleteTransform.Name", tooltip="i18n::HopGuiPipelineGraph.TransformAction.DeleteTransform.Tooltip", image="ui/images/delete.svg", category="Basic", categoryOrder="1")
    public void delTransform(HopGuiPipelineTransformContext context) {
        this.delSelected(context.getTransformMeta());
    }

    @GuiContextAction(id="pipeline-graph-transform-10200-fields-before", parentId="HopGuiPipelineTransformContext", type=GuiActionType.Info, name="i18n::HopGuiPipelineGraph.TransformAction.Transform.ShowInputFields.Name", tooltip="i18n::HopGuiPipelineGraph.TransformAction.Transform.ShowInputFields.Tooltip", image="ui/images/input.svg", category="Basic", categoryOrder="1")
    public void fieldsBefore(HopGuiPipelineTransformContext context) {
        this.selectedTransforms = null;
        this.inputOutputFields(context.getTransformMeta(), true);
    }

    @GuiContextAction(id="pipeline-graph-transform-10300-fields-after", parentId="HopGuiPipelineTransformContext", type=GuiActionType.Info, name="i18n::HopGuiPipelineGraph.TransformAction.Transform.ShowOutputFields.Name", tooltip="i18n::HopGuiPipelineGraph.TransformAction.Transform.ShowOutputFields.Tooltip", image="ui/images/output.svg", category="Basic", categoryOrder="1")
    public void fieldsAfter(HopGuiPipelineTransformContext context) {
        this.selectedTransforms = null;
        this.inputOutputFields(context.getTransformMeta(), false);
    }

    public void fieldsLineage() {
        PipelineDataLineage tdl = new PipelineDataLineage(this.pipelineMeta);
        try {
            tdl.calculateLineage(this.variables);
        }
        catch (Exception e) {
            new ErrorDialog(this.hopShell(), "Lineage error", "Unexpected lineage calculation error", e);
        }
    }

    @GuiContextAction(id="pipeline-graph-hop-10010-hop-enable", parentId="HopGuiPipelineHopContext", type=GuiActionType.Modify, name="i18n::HopGuiPipelineGraph.HopAction.EnableHop.Name", tooltip="i18n::HopGuiPipelineGraph.HopAction.EnableHop.Tooltip", image="ui/images/hop.svg", category="Basic", categoryOrder="1")
    public void enableHop(HopGuiPipelineHopContext context) {
        PipelineHopMeta hop = context.getHopMeta();
        if (!hop.isEnabled()) {
            PipelineHopMeta before = hop.clone();
            this.setHopEnabled(hop, true);
            if (this.pipelineMeta.hasLoop(hop.getToTransform())) {
                this.setHopEnabled(hop, false);
                this.modalMessageDialog(BaseMessages.getString(PKG, (String)"PipelineGraph.Dialog.LoopAfterHopEnabled.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"PipelineGraph.Dialog.LoopAfterHopEnabled.Message", (String[])new String[0]), 33);
            } else {
                PipelineHopMeta after = hop.clone();
                this.hopGui.undoDelegate.addUndoChange((IUndo)this.pipelineMeta, new PipelineHopMeta[]{before}, new PipelineHopMeta[]{after}, new int[]{this.pipelineMeta.indexOfPipelineHop(hop)});
                this.redraw();
            }
        }
        this.updateErrorMetaForHop(hop);
    }

    @GuiContextActionFilter(parentId="HopGuiPipelineHopContext")
    public boolean filterHopActions(String contextActionId, HopGuiPipelineHopContext context) {
        if (contextActionId.equals(ACTION_ID_PIPELINE_GRAPH_HOP_ENABLE)) {
            return !context.getHopMeta().isEnabled();
        }
        if (contextActionId.equals(ACTION_ID_PIPELINE_GRAPH_HOP_DISABLE)) {
            return context.getHopMeta().isEnabled();
        }
        return true;
    }

    @GuiContextActionFilter(parentId="HopGuiPipelineTransformContext")
    public boolean filterTransformActions(String contextActionId, HopGuiPipelineTransformContext context) {
        if (contextActionId.equals(ACTION_ID_PIPELINE_GRAPH_TRANSFORM_ROWS_DISTRIBUTE)) {
            return !context.getTransformMeta().isDistributes();
        }
        if (contextActionId.equals(ACTION_ID_PIPELINE_GRAPH_TRANSFORM_ROWS_COPY)) {
            return context.getTransformMeta().isDistributes();
        }
        if (contextActionId.equals(ACTION_ID_PIPELINE_GRAPH_TRANSFORM_SPECIFY_COPIES)) {
            return context.getTransformMeta().supportsMultiCopyExecution();
        }
        if (contextActionId.equals(ACTION_ID_PIPELINE_GRAPH_TRANSFORM_ERROR_HANDLING)) {
            return context.getTransformMeta().supportsErrorHandling();
        }
        if (contextActionId.equals(ACTION_ID_PIPELINE_GRAPH_TRANSFORM_VIEW_EXECUTION_INFO)) {
            if (this.pipeline == null) {
                return false;
            }
            PipelineRunConfiguration runConfiguration = this.pipeline.getPipelineRunConfiguration();
            String runConfigName = this.variables.resolve(runConfiguration.getExecutionInfoLocationName());
            if (StringUtils.isEmpty((String)runConfigName)) {
                return false;
            }
            TransformMeta transformMeta = context.getTransformMeta();
            List componentCopies = this.pipeline.getComponentCopies(transformMeta.getName());
            return componentCopies != null && !componentCopies.isEmpty();
        }
        return true;
    }

    @GuiContextAction(id="pipeline-graph-hop-10015-hop-disable", parentId="HopGuiPipelineHopContext", type=GuiActionType.Modify, name="i18n::HopGuiPipelineGraph.HopAction.DisableHop.Name", tooltip="i18n::HopGuiPipelineGraph.HopAction.DisableHop.Tooltip", image="ui/images/hop-disable.svg", category="Basic", categoryOrder="1")
    public void disableHop(HopGuiPipelineHopContext context) {
        PipelineHopMeta hopMeta = context.getHopMeta();
        if (hopMeta.isEnabled()) {
            PipelineHopMeta before = hopMeta.clone();
            this.setHopEnabled(hopMeta, false);
            PipelineHopMeta after = hopMeta.clone();
            this.hopGui.undoDelegate.addUndoChange((IUndo)this.pipelineMeta, new PipelineHopMeta[]{before}, new PipelineHopMeta[]{after}, new int[]{this.pipelineMeta.indexOfPipelineHop(hopMeta)});
            this.redraw();
        }
        this.updateErrorMetaForHop(hopMeta);
    }

    @GuiContextAction(id="pipeline-graph-hop-10020-hop-delete", parentId="HopGuiPipelineHopContext", type=GuiActionType.Delete, name="i18n::HopGuiPipelineGraph.HopAction.DeleteHop.Name", tooltip="i18n::HopGuiPipelineGraph.HopAction.DeleteHop.Tooltip", image="ui/images/hop-delete.svg", category="Basic", categoryOrder="1")
    public void deleteHop(HopGuiPipelineHopContext context) {
        this.pipelineHopDelegate.delHop(this.pipelineMeta, context.getHopMeta());
    }

    private void updateErrorMetaForHop(PipelineHopMeta hop) {
        TransformErrorMeta errorMeta;
        if (hop != null && hop.isErrorHop() && (errorMeta = hop.getFromTransform().getTransformErrorMeta()) != null) {
            errorMeta.setEnabled(hop.isEnabled());
        }
    }

    @GuiContextAction(id="pipeline-graph-hop-10065-hop-enable-between-selected-transforms", parentId="HopGuiPipelineHopContext", type=GuiActionType.Modify, name="i18n::HopGuiPipelineGraph.HopAction.EnableBetweenSelectedTransforms.Name", tooltip="i18n::HopGuiPipelineGraph.HopAction.EnableBetweenSelectedTransforms.Tooltip", image="ui/images/hop-enable-between-selected.svg", category="Bulk", categoryOrder="2")
    public void enableHopsBetweenSelectedTransforms(HopGuiPipelineHopContext context) {
        this.enableHopsBetweenSelectedTransforms(true);
    }

    @GuiContextAction(id="pipeline-graph-hop-10075-hop-disable-between-selected-transforms", parentId="HopGuiPipelineHopContext", type=GuiActionType.Modify, name="i18n::HopGuiPipelineGraph.HopAction.DisableBetweenSelectedTransforms.Name", tooltip="i18n::HopGuiPipelineGraph.HopAction.DisableBetweenSelectedTransforms.Tooltip", image="ui/images/hop-disable-between-selected.svg", category="Bulk", categoryOrder="2")
    public void disableHopsBetweenSelectedTransforms(HopGuiPipelineHopContext context) {
        this.enableHopsBetweenSelectedTransforms(false);
    }

    public void enableHopsBetweenSelectedTransforms(boolean enabled) {
        List list = this.pipelineMeta.getSelectedTransforms();
        boolean hasLoop = false;
        for (int i = 0; i < this.pipelineMeta.nrPipelineHops(); ++i) {
            PipelineHopMeta hop = this.pipelineMeta.getPipelineHop(i);
            if (!list.contains(hop.getFromTransform()) || !list.contains(hop.getToTransform())) continue;
            PipelineHopMeta before = hop.clone();
            this.setHopEnabled(hop, enabled);
            PipelineHopMeta after = hop.clone();
            this.hopGui.undoDelegate.addUndoChange((IUndo)this.pipelineMeta, new PipelineHopMeta[]{before}, new PipelineHopMeta[]{after}, new int[]{this.pipelineMeta.indexOfPipelineHop(hop)});
            if (!this.pipelineMeta.hasLoop(hop.getToTransform())) continue;
            hasLoop = true;
            this.setHopEnabled(hop, false);
        }
        if (enabled && hasLoop) {
            this.modalMessageDialog(BaseMessages.getString(PKG, (String)"PipelineGraph.Dialog.HopCausesLoop.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"PipelineGraph.Dialog.HopCausesLoop.Message", (String[])new String[0]), 33);
        }
        this.updateGui();
    }

    @GuiContextAction(id="pipeline-graph-hop-10060-hop-enable-downstream", parentId="HopGuiPipelineHopContext", type=GuiActionType.Modify, name="i18n::HopGuiPipelineGraph.HopAction.EnableDownstreamHop.Name", tooltip="i18n::HopGuiPipelineGraph.HopAction.EnableDownstreamHop.Tooltip", image="ui/images/hop-enable-downstream.svg", category="Bulk", categoryOrder="2")
    public void enableHopsDownstream(HopGuiPipelineHopContext context) {
        this.enableDisableHopsDownstream(context.getHopMeta(), true);
    }

    @GuiContextAction(id="pipeline-graph-hop-10070-hop-disable-downstream", parentId="HopGuiPipelineHopContext", type=GuiActionType.Modify, name="i18n::HopGuiPipelineGraph.HopAction.DisableDownstreamHop.Name", tooltip="i18n::HopGuiPipelineGraph.HopAction.DisableDownstreamHop.Tooltip", image="ui/images/hop-disable-downstream.svg", category="Bulk", categoryOrder="2")
    public void disableHopsDownstream(HopGuiPipelineHopContext context) {
        this.enableDisableHopsDownstream(context.getHopMeta(), false);
    }

    public void enableDisableHopsDownstream(PipelineHopMeta hop, boolean enabled) {
        PipelineHopMeta before = hop.clone();
        this.setHopEnabled(hop, enabled);
        PipelineHopMeta after = hop.clone();
        this.hopGui.undoDelegate.addUndoChange((IUndo)this.pipelineMeta, new PipelineHopMeta[]{before}, new PipelineHopMeta[]{after}, new int[]{this.pipelineMeta.indexOfPipelineHop(hop)});
        Set<TransformMeta> checkedTransforms = this.enableDisableNextHops(hop.getToTransform(), enabled, new HashSet<TransformMeta>());
        if (checkedTransforms.stream().anyMatch(entry -> this.pipelineMeta.hasLoop(entry))) {
            this.modalMessageDialog(BaseMessages.getString(PKG, (String)"PipelineGraph.Dialog.HopCausesLoop.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"PipelineGraph.Dialog.HopCausesLoop.Message", (String[])new String[0]), 33);
        }
        this.updateGui();
    }

    private Set<TransformMeta> enableDisableNextHops(TransformMeta from, boolean enabled, Set<TransformMeta> checkedEntries) {
        checkedEntries.add(from);
        this.pipelineMeta.getPipelineHops().stream().filter(hop -> from.equals((Object)hop.getFromTransform())).forEach(hop -> {
            if (hop.isEnabled() != enabled) {
                PipelineHopMeta before = hop.clone();
                this.setHopEnabled((PipelineHopMeta)hop, enabled);
                PipelineHopMeta after = hop.clone();
                this.hopGui.undoDelegate.addUndoChange((IUndo)this.pipelineMeta, new PipelineHopMeta[]{before}, new PipelineHopMeta[]{after}, new int[]{this.pipelineMeta.indexOfPipelineHop(hop)});
            }
            if (!checkedEntries.contains(hop.getToTransform())) {
                this.enableDisableNextHops(hop.getToTransform(), enabled, checkedEntries);
            }
        });
        return checkedEntries;
    }

    @GuiContextAction(id="pipeline-graph-hop-10080-hop-insert-transform", parentId="HopGuiPipelineHopContext", type=GuiActionType.Modify, name="i18n::HopGuiPipelineGraph.HopAction.InsetTransform.Text", tooltip="i18n::HopGuiPipelineGraph.HopAction.InsetTransform.Tooltip", image="ui/images/add-item.svg", category="Basic", categoryOrder="13")
    public void insertTransform(HopGuiPipelineHopContext context) {
        ArrayList<GuiAction> guiActions = new ArrayList<GuiAction>();
        PluginRegistry registry = PluginRegistry.getInstance();
        for (IPlugin plugin : registry.getPlugins(TransformPluginType.class)) {
            GuiAction guiAction = new GuiAction("pipeline-graph-insert-transform-" + plugin.getIds()[0], GuiActionType.Create, plugin.getName(), plugin.getDescription(), plugin.getImageFile(), (shiftClicked, controlClicked, t) -> this.pipelineTransformDelegate.insertTransform(this.pipelineMeta, context.getHopMeta(), plugin.getIds()[0], plugin.getName(), context.getClick()));
            guiAction.getKeywords().addAll(Arrays.asList(plugin.getKeywords()));
            guiAction.getKeywords().add(plugin.getCategory());
            guiAction.setCategory(plugin.getCategory());
            guiAction.setCategoryOrder(plugin.getCategory());
            try {
                guiAction.setClassLoader(registry.getClassLoader(plugin));
            }
            catch (HopPluginException e) {
                LogChannel.UI.logError("Unable to get classloader for transform plugin " + plugin.getIds()[0], (Throwable)e);
            }
            guiActions.add(guiAction);
        }
        String message = BaseMessages.getString(PKG, (String)"HopGuiPipelineGraph.ContextualActionDialog.InsertTransform.Header", (String[])new String[0]);
        ContextDialog contextDialog = new ContextDialog(this.hopShell(), message, context.getClick(), guiActions, "HopGuiPipelineContext");
        GuiAction selectedAction = contextDialog.open();
        if (selectedAction != null) {
            IGuiActionLambda actionLambda = selectedAction.getActionLambda();
            actionLambda.executeAction(contextDialog.isShiftClicked(), contextDialog.isCtrlClicked(), new Object[0]);
        }
    }

    @GuiContextAction(id="pipeline-graph-10-edit-note", parentId="HopGuiPipelineNoteContext", type=GuiActionType.Modify, name="i18n::HopGuiPipelineGraph.NoteAction.EditNote.Name", tooltip="i18n::HopGuiPipelineGraph.NoteAction.EditNote.Tooltip", image="ui/images/edit.svg", category="Basic", categoryOrder="1")
    public void editNote(HopGuiPipelineNoteContext context) {
        this.selectionRegion = null;
        this.editNote(context.getNotePadMeta());
    }

    @GuiContextAction(id="pipeline-graph-20-delete-note", parentId="HopGuiPipelineNoteContext", type=GuiActionType.Delete, name="i18n::HopGuiPipelineGraph.NoteAction.DeleteNote.Name", tooltip="i18n::HopGuiPipelineGraph.NoteAction.DeleteNote.Tooltip", image="ui/images/delete.svg", category="Basic", categoryOrder="1")
    public void deleteNote(HopGuiPipelineNoteContext context) {
        this.selectionRegion = null;
        int idx = this.pipelineMeta.indexOfNote(context.getNotePadMeta());
        if (idx >= 0) {
            this.pipelineMeta.removeNote(idx);
            this.hopGui.undoDelegate.addUndoDelete((IUndo)this.pipelineMeta, new NotePadMeta[]{context.getNotePadMeta().clone()}, new int[]{idx});
            this.updateGui();
        }
    }

    @GuiContextAction(id="pipeline-graph-transform-10100-create-note", parentId="HopGuiPipelineContext", type=GuiActionType.Create, name="i18n::HopGuiPipelineGraph.NoteAction.CreateNote.Name", tooltip="i18n::HopGuiPipelineGraph.NoteAction.CreateNote.Tooltip", image="ui/images/note-add.svg", category="Basic", categoryOrder="1")
    public void newNote(HopGuiPipelineContext context) {
        this.selectionRegion = null;
        String title = BaseMessages.getString(PKG, (String)"PipelineGraph.Dialog.NoteEditor.Title", (String[])new String[0]);
        NotePadDialog dd = new NotePadDialog(this.variables, this.hopShell(), title);
        NotePadMeta n = dd.open();
        if (n != null) {
            NotePadMeta npi = new NotePadMeta(n.getNote(), context.getClick().x, context.getClick().y, 20, 20, n.getFontName(), n.getFontSize(), n.isFontBold(), n.isFontItalic(), n.getFontColorRed(), n.getFontColorGreen(), n.getFontColorBlue(), n.getBackGroundColorRed(), n.getBackGroundColorGreen(), n.getBackGroundColorBlue(), n.getBorderColorRed(), n.getBorderColorGreen(), n.getBorderColorBlue());
            this.pipelineMeta.addNote(npi);
            this.hopGui.undoDelegate.addUndoNew((IUndo)this.pipelineMeta, new NotePadMeta[]{npi}, new int[]{this.pipelineMeta.indexOfNote(npi)});
            this.updateGui();
        }
    }

    @GuiContextAction(id="pipeline-graph-transform-10110-copy-notepad-to-clipboard", parentId="HopGuiPipelineNoteContext", type=GuiActionType.Custom, name="i18n::HopGuiPipelineGraph.PipelineAction.CopyToClipboard.Name", tooltip="i18n::HopGuiPipelineGraph.PipelineAction.CopyToClipboard.Tooltip", image="ui/images/copy.svg", category="Basic", categoryOrder="1")
    public void copyNotePadToClipboard(HopGuiPipelineNoteContext context) {
        this.pipelineClipboardDelegate.copySelected(this.pipelineMeta, Collections.emptyList(), Arrays.asList(context.getNotePadMeta()));
    }

    @GuiContextAction(id="pipeline-graph-edit-pipeline", parentId="HopGuiPipelineContext", type=GuiActionType.Modify, name="i18n::HopGuiPipelineGraph.PipelineAction.EditPipeline.Name", tooltip="i18n::HopGuiPipelineGraph.PipelineAction.EditPipeline.Tooltip", image="ui/images/pipeline.svg", category="Basic", categoryOrder="1")
    public void editPipelineProperties(HopGuiPipelineContext context) {
        this.editProperties(this.pipelineMeta, this.hopGui, true);
    }

    @GuiToolbarElement(root="HopGuiPipelineGraph-Toolbar", id="HopGuiPipelineGraph-ToolBar-10450-EditPipeline", toolTip="i18n:org.apache.hop.ui.hopgui:HopGui.Toolbar.EditProperties.Tooltip", image="ui/images/pipeline.svg", separator=true)
    @GuiKeyboardShortcut(control=true, key=116)
    @GuiOsxKeyboardShortcut(command=true, key=116)
    public void editPipelineProperties() {
        this.editProperties(this.pipelineMeta, this.hopGui, true);
    }

    public void newTransform(String description) {
        TransformMeta transformMeta = this.pipelineTransformDelegate.newTransform(this.pipelineMeta, null, description, description, false, true, new Point(this.currentMouseX, this.currentMouseY));
        PropsUi.setLocation((IGuiPosition)transformMeta, this.currentMouseX, this.currentMouseY);
        this.updateGui();
    }

    private boolean checkNumberOfCopies(PipelineMeta pipelineMeta, TransformMeta transformMeta) {
        boolean enabled = true;
        List prevTransforms = pipelineMeta.findPreviousTransforms(transformMeta);
        for (TransformMeta prevTransform : prevTransforms) {
            String[] targetTransforms = prevTransform.getTransform().getTransformIOMeta().getTargetTransformNames();
            if (targetTransforms == null) continue;
            for (int t = 0; t < targetTransforms.length && enabled; ++t) {
                if (Utils.isEmpty((CharSequence)targetTransforms[t]) || !targetTransforms[t].equalsIgnoreCase(transformMeta.getName())) continue;
                enabled = false;
            }
        }
        return enabled;
    }

    private AreaOwner setToolTip(int x, int y, int screenX, int screenY) {
        AreaOwner subject = null;
        if (!this.hopGui.getProps().showToolTips() || this.openedContextDialog) {
            return subject;
        }
        this.canvas.setToolTipText(null);
        Object newTip = null;
        Image tipImage = null;
        PipelineHopMeta hi = this.findPipelineHop(x, y);
        StringBuilder tip = new StringBuilder();
        AreaOwner areaOwner = this.getVisibleAreaOwner(x, y);
        if (areaOwner != null && areaOwner.getAreaType() != null) {
            AreaOwner.AreaType areaType = areaOwner.getAreaType();
            switch (areaType) {
                case TRANSFORM_PARTITIONING: {
                    TransformMeta transform = (TransformMeta)areaOwner.getParent();
                    tip.append("Transform partitioning:").append(Const.CR).append("-----------------------").append(Const.CR);
                    tip.append(transform.getTransformPartitioningMeta().toString()).append(Const.CR);
                    if (transform.getTargetTransformPartitioningMeta() == null) break;
                    tip.append(Const.CR).append(Const.CR).append("TARGET: " + transform.getTargetTransformPartitioningMeta().toString()).append(Const.CR);
                    break;
                }
                case TRANSFORM_FAILURE_ICON: {
                    String log = (String)areaOwner.getParent();
                    tip.append(log);
                    tipImage = GuiResource.getInstance().getImageFailure();
                    break;
                }
                case HOP_COPY_ICON: {
                    TransformMeta transform = (TransformMeta)areaOwner.getParent();
                    tip.append(BaseMessages.getString(PKG, (String)"PipelineGraph.Hop.Tooltip.HopTypeCopy", (String[])new String[]{transform.getName(), Const.CR}));
                    tipImage = GuiResource.getInstance().getImageCopyHop();
                    break;
                }
                case ROW_DISTRIBUTION_ICON: {
                    TransformMeta transform = (TransformMeta)areaOwner.getParent();
                    tip.append(BaseMessages.getString(PKG, (String)"PipelineGraph.Hop.Tooltip.RowDistribution", (String[])new String[]{transform.getName(), transform.getRowDistribution() == null ? "" : transform.getRowDistribution().getDescription()}));
                    tip.append(Const.CR);
                    tipImage = GuiResource.getInstance().getImageBalance();
                    break;
                }
                case HOP_INFO_ICON: {
                    TransformMeta from = (TransformMeta)areaOwner.getParent();
                    TransformMeta to = (TransformMeta)areaOwner.getOwner();
                    tip.append(BaseMessages.getString(PKG, (String)"PipelineGraph.Hop.Tooltip.HopTypeInfo", (String[])new String[]{to.getName(), from.getName(), Const.CR}));
                    tipImage = GuiResource.getInstance().getImageInfo();
                    break;
                }
                case HOP_ERROR_ICON: {
                    TransformMeta from = (TransformMeta)areaOwner.getParent();
                    TransformMeta to = (TransformMeta)areaOwner.getOwner();
                    areaOwner.getOwner();
                    tip.append(BaseMessages.getString(PKG, (String)"PipelineGraph.Hop.Tooltip.HopTypeError", (String[])new String[]{from.getName(), to.getName(), Const.CR}));
                    tipImage = GuiResource.getInstance().getImageError();
                    break;
                }
                case HOP_INFO_TRANSFORM_COPIES_ERROR: {
                    TransformMeta from = (TransformMeta)areaOwner.getParent();
                    TransformMeta to = (TransformMeta)areaOwner.getOwner();
                    tip.append(BaseMessages.getString(PKG, (String)"PipelineGraph.Hop.Tooltip.InfoTransformCopies", (String[])new String[]{from.getName(), to.getName(), Const.CR}));
                    tipImage = GuiResource.getInstance().getImageError();
                    break;
                }
                case HOP_INFO_TRANSFORMS_PARTITIONED: {
                    TransformMeta from = (TransformMeta)areaOwner.getParent();
                    TransformMeta to = (TransformMeta)areaOwner.getOwner();
                    tip.append(BaseMessages.getString(PKG, (String)"PipelineGraph.Hop.Tooltip.InfoTransformsPartitioned", (String[])new String[]{from.getName(), to.getName(), Const.CR}));
                    tipImage = GuiResource.getInstance().getImageError();
                    break;
                }
                case TRANSFORM_TARGET_HOP_ICON: {
                    IStream stream = (IStream)areaOwner.getOwner();
                    tip.append(stream.getDescription());
                    if (stream.getStreamIcon() == StreamIcon.TRUE) {
                        tipImage = GuiResource.getInstance().getImageTrue();
                        break;
                    }
                    if (stream.getStreamIcon() == StreamIcon.FALSE) {
                        tipImage = GuiResource.getInstance().getImageFalse();
                        break;
                    }
                    tipImage = GuiResource.getInstance().getImageTarget();
                    break;
                }
                case TRANSFORM_INFO_ICON: 
                case TRANSFORM_ICON: {
                    TransformMeta iconTransformMeta = (TransformMeta)areaOwner.getOwner();
                    if (iconTransformMeta.isDeprecated()) {
                        tip.append(BaseMessages.getString(PKG, (String)"PipelineGraph.DeprecatedTransform.Tooltip.Title", (String[])new String[0])).append(Const.CR);
                        String tipNext = BaseMessages.getString(PKG, (String)"PipelineGraph.DeprecatedTransform.Tooltip.Message1", (String[])new String[]{iconTransformMeta.getName()});
                        int length = tipNext.length() + 5;
                        for (int i = 0; i < length; ++i) {
                            tip.append("-");
                        }
                        tip.append(Const.CR).append(tipNext).append(Const.CR);
                        tip.append(BaseMessages.getString(PKG, (String)"PipelineGraph.DeprecatedTransform.Tooltip.Message2", (String[])new String[0]));
                        if (!(Utils.isEmpty((CharSequence)iconTransformMeta.getSuggestion()) || iconTransformMeta.getSuggestion().startsWith("!") && iconTransformMeta.getSuggestion().endsWith("!"))) {
                            tip.append(" ");
                            tip.append(BaseMessages.getString(PKG, (String)"PipelineGraph.DeprecatedTransform.Tooltip.Message3", (String[])new String[]{iconTransformMeta.getSuggestion()}));
                        }
                        tipImage = GuiResource.getInstance().getImageDeprecated();
                        break;
                    }
                    if (Utils.isEmpty((CharSequence)iconTransformMeta.getDescription())) break;
                    tip.append(iconTransformMeta.getDescription());
                    break;
                }
                case TRANSFORM_OUTPUT_DATA: {
                    RowBuffer rowBuffer = (RowBuffer)areaOwner.getOwner();
                    if (rowBuffer == null || rowBuffer.isEmpty()) break;
                    tip.append("Available output rows: " + rowBuffer.size());
                    tipImage = GuiResource.getInstance().getImageData();
                    break;
                }
                default: {
                    try {
                        HopGuiTooltipExtension tooltipExt = new HopGuiTooltipExtension(x, y, screenX, screenY, areaOwner, tip);
                        ExtensionPointHandler.callExtensionPoint((ILogChannel)this.hopGui.getLog(), (IVariables)this.variables, (String)HopExtensionPoint.HopGuiPipelineGraphAreaHover.name(), (Object)tooltipExt);
                        tipImage = tooltipExt.tooltipImage;
                        break;
                    }
                    catch (Exception ex) {
                        this.hopGui.getLog().logError("Error calling extension point " + HopExtensionPoint.HopGuiPipelineGraphAreaHover.name(), (Throwable)ex);
                    }
                }
            }
        }
        if (hi != null && tip.length() == 0) {
            newTip = hi.toString();
            tip.append(Const.CR).append(BaseMessages.getString(PKG, (String)"PipelineGraph.Dialog.HopInfo", (String[])new String[0])).append((String)newTip).append(Const.CR);
        }
        if ((newTip = tip.length() == 0 ? null : tip.toString()) == null) {
            this.toolTip.setVisible(false);
            if (hi != null) {
                newTip = BaseMessages.getString(PKG, (String)"PipelineGraph.Dialog.HopInfo", (String[])new String[0]) + Const.CR + BaseMessages.getString(PKG, (String)"PipelineGraph.Dialog.HopInfo.SourceTransform", (String[])new String[0]) + " " + hi.getFromTransform().getName() + Const.CR + BaseMessages.getString(PKG, (String)"PipelineGraph.Dialog.HopInfo.TargetTransform", (String[])new String[0]) + " " + hi.getToTransform().getName() + Const.CR + BaseMessages.getString(PKG, (String)"PipelineGraph.Dialog.HopInfo.Status", (String[])new String[0]) + " " + (hi.isEnabled() ? BaseMessages.getString(PKG, (String)"PipelineGraph.Dialog.HopInfo.Enable", (String[])new String[0]) : BaseMessages.getString(PKG, (String)"PipelineGraph.Dialog.HopInfo.Disable", (String[])new String[0]));
                this.toolTip.setText((String)newTip);
                this.showToolTip(new org.eclipse.swt.graphics.Point(screenX, screenY));
            }
        } else if (!((String)newTip).equalsIgnoreCase(this.getToolTipText())) {
            Image tooltipImage = null;
            tooltipImage = tipImage != null ? tipImage : GuiResource.getInstance().getImageHopUi();
            this.showTooltip((String)newTip, tooltipImage, screenX, screenY);
        }
        return subject;
    }

    public void showTooltip(String label, Image image, int screenX, int screenY) {
        this.toolTip.setText(label);
        this.toolTip.setVisible(false);
        this.showToolTip(new org.eclipse.swt.graphics.Point(screenX, screenY));
    }

    public synchronized AreaOwner getVisibleAreaOwner(int x, int y) {
        for (int i = this.areaOwners.size() - 1; i >= 0; --i) {
            AreaOwner areaOwner = this.areaOwners.get(i);
            if (!areaOwner.contains(x, y)) continue;
            return areaOwner;
        }
        return null;
    }

    public void delSelected(TransformMeta transformMeta) {
        List selection = this.pipelineMeta.getSelectedTransforms();
        if (this.currentTransform == null && transformMeta == null && selection.isEmpty() && this.pipelineMeta.getSelectedNotes().isEmpty()) {
            return;
        }
        if (transformMeta != null && selection.isEmpty()) {
            this.pipelineTransformDelegate.delTransform(this.pipelineMeta, transformMeta);
            return;
        }
        if (this.currentTransform != null && selection.contains(this.currentTransform)) {
            this.currentTransform = null;
            for (ITransformSelectionListener listener : this.currentTransformListeners) {
                listener.onUpdateSelection(this.currentTransform);
            }
        }
        if (!selection.isEmpty()) {
            this.pipelineTransformDelegate.delTransforms(this.pipelineMeta, selection);
        }
        if (!this.pipelineMeta.getSelectedNotes().isEmpty()) {
            this.notePadDelegate.deleteNotes((AbstractMeta)this.pipelineMeta, this.pipelineMeta.getSelectedNotes());
        }
    }

    public void editDescription(TransformMeta transformMeta) {
        String title = BaseMessages.getString(PKG, (String)"PipelineGraph.Dialog.TransformDescription.Title", (String[])new String[0]);
        String message = BaseMessages.getString(PKG, (String)"PipelineGraph.Dialog.TransformDescription.Message", (String[])new String[0]);
        EnterTextDialog dialog = new EnterTextDialog(this.hopShell(), title, message, transformMeta.getDescription());
        String description = dialog.open();
        if (description != null) {
            transformMeta.setDescription(description);
            transformMeta.setChanged();
            this.updateGui();
        }
    }

    private void inputOutputFields(TransformMeta transformMeta, boolean before) {
        this.redraw();
        SearchFieldsProgressDialog op = new SearchFieldsProgressDialog(this.variables, this.pipelineMeta, transformMeta, before);
        boolean alreadyThrownError = false;
        try {
            ProgressMonitorDialog pmd = new ProgressMonitorDialog(this.hopShell());
            Runnable run = () -> {
                IProgressMonitor monitor = pmd.getProgressMonitor();
                while (pmd.getShell() == null || !pmd.getShell().isDisposed() && !monitor.isCanceled()) {
                    try {
                        Thread.sleep(250L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                if (monitor.isCanceled()) {
                    try {
                        this.pipelineMeta.cancelQueries();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            };
            new Thread(run).start();
            pmd.run(true, op);
        }
        catch (InterruptedException | InvocationTargetException e) {
            new ErrorDialog(this.hopShell(), BaseMessages.getString(PKG, (String)"PipelineGraph.Dialog.GettingFields.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"PipelineGraph.Dialog.GettingFields.Message", (String[])new String[0]), e);
            alreadyThrownError = true;
        }
        IRowMeta fields = op.getFields();
        if (fields != null && fields.size() > 0) {
            TransformMeta esi;
            TransformFieldsDialog sfd = new TransformFieldsDialog(this.hopShell(), this.variables, 0, transformMeta.getName(), fields);
            String sn = (String)sfd.open();
            if (sn != null && (esi = this.pipelineMeta.findTransform(sn)) != null) {
                this.editTransform(esi);
            }
        } else if (!alreadyThrownError) {
            this.modalMessageDialog(BaseMessages.getString(PKG, (String)"PipelineGraph.Dialog.CouldntFindFields.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"PipelineGraph.Dialog.CouldntFindFields.Message", (String[])new String[0]), 34);
        }
    }

    public void paintControl(PaintEvent e) {
        Point area = this.getArea();
        if (area.x == 0 || area.y == 0) {
            return;
        }
        boolean needsDoubleBuffering = Const.isWindows() && "GUI".equalsIgnoreCase(Const.getHopPlatformRuntime());
        Image image = null;
        GC swtGc = e.gc;
        if (needsDoubleBuffering) {
            image = new Image((Device)this.hopDisplay(), area.x, area.y);
            swtGc = new GC((Drawable)image);
        }
        this.drawPipelineImage(swtGc, area.x, area.y);
        if (needsDoubleBuffering) {
            e.gc.drawImage(image, 0, 0);
            swtGc.dispose();
            image.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawPipelineImage(GC swtGc, int width, int height) {
        if (EnvironmentUtils.getInstance().isWeb()) {
            // empty if block
        }
        SwtGc gc = new SwtGc(swtGc, width, height, this.iconSize);
        try {
            PropsUi propsUi = PropsUi.getInstance();
            this.maximum = this.pipelineMeta.getMaximum();
            int gridSize = propsUi.isShowCanvasGridEnabled() ? propsUi.getCanvasGridSize() : 1;
            PipelinePainter pipelinePainter = new PipelinePainter((IGc)gc, this.variables, this.pipelineMeta, new Point(width, height), this.offset, this.candidate, this.selectionRegion, this.areaOwners, propsUi.getIconSize(), propsUi.getLineWidth(), gridSize, propsUi.getNoteFont().getName(), propsUi.getNoteFont().getHeight(), this.pipeline, propsUi.isIndicateSlowPipelineTransformsEnabled(), propsUi.getZoomFactor(), this.outputRowsMap, propsUi.isBorderDrawnAroundCanvasNames(), this.mouseOverName, this.stateMap);
            pipelinePainter.setMagnification((float)((double)this.magnification * PropsUi.getNativeZoomFactor()));
            pipelinePainter.setTransformLogMap(this.transformLogMap);
            pipelinePainter.setStartHopTransform(this.startHopTransform);
            pipelinePainter.setEndHopLocation(this.endHopLocation);
            pipelinePainter.setNoInputTransform(this.noInputTransform);
            pipelinePainter.setEndHopTransform(this.endHopTransform);
            pipelinePainter.setCandidateHopType(this.candidateHopType);
            pipelinePainter.setStartErrorHopTransform(this.startErrorHopTransform);
            pipelinePainter.setMaximum(this.maximum);
            pipelinePainter.setShowingNavigationView(true);
            pipelinePainter.setScreenMagnification(this.magnification);
            pipelinePainter.setShowingNavigationView(!PropsUi.getInstance().isHideViewportEnabled());
            try {
                pipelinePainter.drawPipelineImage();
                this.viewPort = pipelinePainter.getViewPort();
                this.graphPort = pipelinePainter.getGraphPort();
                if (this.pipelineMeta.isEmpty()) {
                    SvgFile svgFile = new SvgFile(BasePropertyHandler.getProperty((String)"PipelineCanvas_image"), this.getClass().getClassLoader());
                    gc.setTransform(0.0f, 0.0f, (float)((double)this.magnification * PropsUi.getNativeZoomFactor()));
                    gc.drawImage(svgFile, 150, 150, 32, 40, gc.getMagnification(), 0.0);
                    gc.drawText(BaseMessages.getString(PKG, (String)"PipelineGraph.NewPipelineBackgroundMessage", (String[])new String[0]), 155, 125, true);
                }
            }
            catch (Exception e) {
                new ErrorDialog(this.hopGui.getActiveShell(), CONST_ERROR, "Error drawing pipeline image", e);
            }
        }
        finally {
            gc.dispose();
        }
        CanvasFacade.setData(this.canvas, this.magnification, this.offset, this.pipelineMeta);
    }

    private void editTransform(TransformMeta transformMeta) {
        this.pipelineMeta.unselectAll();
        this.updateGui();
        this.pipelineTransformDelegate.editTransform(this.pipelineMeta, transformMeta);
    }

    private void editNote(NotePadMeta ni) {
        NotePadMeta before = ni.clone();
        String title = BaseMessages.getString(PKG, (String)"PipelineGraph.Dialog.EditNote.Title", (String[])new String[0]);
        NotePadDialog dd = new NotePadDialog(this.variables, this.hopShell(), title, ni);
        NotePadMeta n = dd.open();
        if (n != null) {
            ni.setChanged();
            ni.setNote(n.getNote());
            ni.setFontName(n.getFontName());
            ni.setFontSize(n.getFontSize());
            ni.setFontBold(n.isFontBold());
            ni.setFontItalic(n.isFontItalic());
            ni.setFontColorRed(n.getFontColorRed());
            ni.setFontColorGreen(n.getFontColorGreen());
            ni.setFontColorBlue(n.getFontColorBlue());
            ni.setBackGroundColorRed(n.getBackGroundColorRed());
            ni.setBackGroundColorGreen(n.getBackGroundColorGreen());
            ni.setBackGroundColorBlue(n.getBackGroundColorBlue());
            ni.setBorderColorRed(n.getBorderColorRed());
            ni.setBorderColorGreen(n.getBorderColorGreen());
            ni.setBorderColorBlue(n.getBorderColorBlue());
            ni.width = 20;
            ni.height = 20;
            NotePadMeta after = ni.clone();
            this.hopGui.undoDelegate.addUndoChange((IUndo)this.pipelineMeta, new NotePadMeta[]{before}, new NotePadMeta[]{after}, new int[]{this.pipelineMeta.indexOfNote(ni)});
            this.updateGui();
        }
    }

    private void editHop(PipelineHopMeta pipelineHopMeta) {
        String name = pipelineHopMeta.toString();
        if (this.log.isDebug()) {
            this.log.logDebug(BaseMessages.getString(PKG, (String)"PipelineGraph.Logging.EditingHop", (String[])new String[0]) + name);
        }
        this.pipelineHopDelegate.editHop(this.pipelineMeta, pipelineHopMeta);
    }

    private void newHop() {
        List selection = this.pipelineMeta.getSelectedTransforms();
        if (selection.size() == 2) {
            TransformMeta fr = (TransformMeta)selection.get(0);
            TransformMeta to = (TransformMeta)selection.get(1);
            this.pipelineHopDelegate.newHop(this.pipelineMeta, fr, to);
        }
    }

    @GuiContextAction(id="pipeline-graph-transform-10050-create-hop", parentId="HopGuiPipelineTransformContext", type=GuiActionType.Create, name="i18n::HopGuiPipelineGraph.HopAction.CreateHop.Name", tooltip="i18n::HopGuiPipelineGraph.HopAction.CreateHop.Tooltip", image="ui/images/hop.svg", category="Basic", categoryOrder="1")
    public void newHopCandidate(HopGuiPipelineTransformContext context) {
        this.startHopTransform = context.getTransformMeta();
        this.endHopTransform = null;
        this.redraw();
    }

    private boolean pointOnLine(int x, int y, int[] line) {
        int pm = 4;
        boolean retval = false;
        for (int dx = -pm; dx <= pm && !retval; ++dx) {
            for (int dy = -pm; dy <= pm && !retval; ++dy) {
                retval = this.pointOnThinLine(x + dx, y + dy, line);
            }
        }
        return retval;
    }

    private boolean pointOnThinLine(int x, int y, int[] line) {
        int x1 = line[0];
        int y1 = line[1];
        int x2 = line[2];
        int y2 = line[3];
        if (!((x >= x1 && x <= x2 || x >= x2 && x <= x1) && (y >= y1 && y <= y2 || y >= y2 && y <= y1))) {
            return false;
        }
        double angleLine = Math.atan2(y2 - y1, x2 - x1) + Math.PI;
        double anglePoint = Math.atan2(y - y1, x - x1) + Math.PI;
        return anglePoint >= angleLine - 0.01 && anglePoint <= angleLine + 0.01;
    }

    @Override
    public SnapAllignDistribute createSnapAlignDistribute() {
        List selection = this.pipelineMeta.getSelectedTransforms();
        int[] indices = this.pipelineMeta.getTransformIndexes(selection);
        return new SnapAllignDistribute((IUndo)this.pipelineMeta, selection, indices, (IAddUndoPosition)this.hopGui.undoDelegate, (IRedrawable)this);
    }

    @Override
    @GuiToolbarElement(root="HopGuiPipelineGraph-Toolbar", id="HopGuiPipelineGraph-ToolBar-10050-Preview", toolTip="i18n::PipelineGraph.Toolbar.Preview.Tooltip", image="ui/images/preview.svg")
    public void preview() {
        try {
            this.pipelineRunDelegate.executePipeline(this.hopGui.getLog(), this.pipelineMeta, true, false, this.pipelineRunDelegate.getPipelinePreviewExecutionConfiguration().getLogLevel());
        }
        catch (Exception e) {
            new ErrorDialog(this.hopShell(), CONST_ERROR, CONST_ERROR_PREVIEWING_PIPELINE, e);
        }
    }

    @GuiContextAction(id="pipeline-graph-transform-10100-preview-output", parentId="HopGuiPipelineTransformContext", type=GuiActionType.Info, name="i18n::HopGuiPipelineGraph.PipelineAction.Preview.Name", tooltip="i18n::HopGuiPipelineGraph.PipelineAction.Preview.Tooltip", image="ui/images/preview.svg", category="Preview", categoryOrder="3")
    public void preview(HopGuiPipelineTransformContext context) {
        try {
            context.getPipelineMeta().unselectAll();
            context.getTransformMeta().setSelected(true);
            this.pipelineRunDelegate.executePipeline(this.hopGui.getLog(), this.pipelineMeta, true, false, this.pipelineRunDelegate.getPipelinePreviewExecutionConfiguration().getLogLevel());
        }
        catch (Exception e) {
            new ErrorDialog(this.hopShell(), CONST_ERROR, CONST_ERROR_PREVIEWING_PIPELINE, e);
        }
    }

    @Override
    @GuiToolbarElement(root="HopGuiPipelineGraph-Toolbar", id="HopGuiPipelineGraph-ToolBar-10060-Debug", toolTip="i18n::PipelineGraph.Toolbar.Debug.Tooltip", image="ui/images/debug.svg")
    public void debug() {
        try {
            this.pipelineRunDelegate.executePipeline(this.hopGui.getLog(), this.pipelineMeta, false, true, this.pipelineRunDelegate.getPipelineDebugExecutionConfiguration().getLogLevel());
        }
        catch (Exception e) {
            new ErrorDialog(this.hopShell(), CONST_ERROR, "Error debugging pipeline", e);
        }
    }

    @GuiContextAction(id="pipeline-graph-transform-10150-debug-output", parentId="HopGuiPipelineTransformContext", type=GuiActionType.Info, name="i18n::HopGuiPipelineGraph.PipelineAction.DebugOutput.Name", tooltip="i18n::HopGuiPipelineGraph.PipelineAction.DebugOutput.Tooltip", image="ui/images/debug.svg", category="Preview", categoryOrder="3")
    public void debug(HopGuiPipelineTransformContext context) {
        try {
            context.getPipelineMeta().unselectAll();
            context.getTransformMeta().setSelected(true);
            this.pipelineRunDelegate.executePipeline(this.hopGui.getLog(), this.pipelineMeta, false, this.debug, this.pipelineRunDelegate.getPipelinePreviewExecutionConfiguration().getLogLevel());
        }
        catch (Exception e) {
            new ErrorDialog(this.hopShell(), CONST_ERROR, CONST_ERROR_PREVIEWING_PIPELINE, e);
        }
    }

    public void newProps() {
        this.iconSize = this.hopGui.getProps().getIconSize();
    }

    public IEngineMeta getMeta() {
        return this.pipelineMeta;
    }

    public void setPipelineMeta(PipelineMeta pipelineMeta) {
        this.pipelineMeta = pipelineMeta;
        if (pipelineMeta != null) {
            pipelineMeta.setInternalHopVariables(this.variables);
        }
    }

    @Override
    public String getName() {
        return this.pipelineMeta.getName();
    }

    @Override
    public void setName(String name) {
        this.pipelineMeta.setName(name);
    }

    @Override
    public void setFilename(String filename) {
        this.pipelineMeta.setFilename(filename);
    }

    @Override
    public String getFilename() {
        return this.pipelineMeta.getFilename();
    }

    public boolean canBeClosed() {
        return !this.pipelineMeta.hasChanged();
    }

    public PipelineMeta getManagedObject() {
        return this.pipelineMeta;
    }

    @Deprecated(since="2.10")
    public boolean hasContentChanged() {
        return this.pipelineMeta.hasChanged();
    }

    public boolean editProperties(PipelineMeta pipelineMeta, HopGui hopGui, boolean allowDirectoryChange) {
        return this.editProperties(pipelineMeta, hopGui, null);
    }

    public boolean editProperties(PipelineMeta pipelineMeta, HopGui hopGui, PipelineDialog.Tabs currentTab) {
        PipelineDialog tid;
        if (pipelineMeta == null) {
            return false;
        }
        Shell shell = hopGui.getActiveShell();
        if (shell == null) {
            shell = hopGui.getShell();
        }
        if ((tid = new PipelineDialog(shell, 0, this.variables, pipelineMeta, currentTab)).open() != null) {
            hopGui.setParametersAsVariablesInUI((INamedParameterDefinitions)pipelineMeta, this.variables);
            this.updateGui();
            this.perspective.updateTabs();
            return true;
        }
        return false;
    }

    @Override
    public boolean hasChanged() {
        return this.pipelineMeta.hasChanged();
    }

    @Override
    public void setChanged() {
        this.pipelineMeta.setChanged();
    }

    @Override
    public synchronized void save() throws HopException {
        try {
            ExtensionPointHandler.callExtensionPoint((ILogChannel)this.log, (IVariables)this.variables, (String)HopExtensionPoint.PipelineBeforeSave.id, (Object)this.pipelineMeta);
            if (StringUtils.isEmpty((String)this.pipelineMeta.getFilename())) {
                throw new HopException("No filename: please specify a filename for this pipeline");
            }
            AuditManager.registerEvent((String)HopNamespace.getNamespace(), (String)"file", (String)this.pipelineMeta.getFilename(), (String)"save");
            String xml = this.pipelineMeta.getXml(this.variables);
            OutputStream out = HopVfs.getOutputStream((String)this.pipelineMeta.getFilename(), (boolean)false);
            try {
                out.write(XmlHandler.getXmlHeader((String)"UTF-8").getBytes(StandardCharsets.UTF_8));
                out.write(xml.getBytes(StandardCharsets.UTF_8));
                this.pipelineMeta.clearChanged();
                this.updateGui();
                HopGui.getDataOrchestrationPerspective().updateTabs();
            }
            finally {
                out.flush();
                out.close();
                ExtensionPointHandler.callExtensionPoint((ILogChannel)this.log, (IVariables)this.variables, (String)HopExtensionPoint.PipelineAfterSave.id, (Object)this.pipelineMeta);
            }
        }
        catch (Exception e) {
            throw new HopException("Error saving pipeline to file '" + this.pipelineMeta.getFilename() + "'", (Throwable)e);
        }
    }

    @Override
    public void saveAs(String filename) throws HopException {
        try {
            FileObject fileObject;
            if (!((String)filename).toLowerCase().endsWith(((HopPipelineFileType)this.getFileType()).getDefaultFileExtension())) {
                filename = (String)filename + ((HopPipelineFileType)this.getFileType()).getDefaultFileExtension();
            }
            if ((fileObject = HopVfs.getFileObject((String)filename)).exists()) {
                MessageBox box = new MessageBox(this.hopGui.getShell(), 196);
                box.setText("Overwrite?");
                box.setMessage("Are you sure you want to overwrite file '" + (String)filename + "'?");
                int answer = box.open();
                if ((answer & 0x40) == 0) {
                    return;
                }
            }
            this.pipelineMeta.setFilename((String)filename);
            this.save();
            this.hopGui.fileRefreshDelegate.register(fileObject.getPublicURIString(), this);
        }
        catch (Exception e) {
            throw new HopException("Error validating file existence for '" + (String)filename + "'", (Throwable)e);
        }
    }

    @Override
    public void close() {
        this.perspective.remove(this);
    }

    @Override
    public boolean isCloseable() {
        try {
            int answer;
            MessageBox messageDialog;
            if (this.pipeline != null && (this.pipeline.isRunning() || this.pipeline.isPaused())) {
                messageDialog = new MessageBox(this.hopShell(), 452);
                messageDialog.setText(BaseMessages.getString(PKG, (String)"PipelineGraph.RunningFile.Dialog.Header", (String[])new String[0]));
                messageDialog.setMessage(BaseMessages.getString(PKG, (String)"PipelineGraph.RunningFile.Dialog.Message", (String[])new String[]{this.buildTabName()}));
                answer = messageDialog.open();
                if ((answer & 0x40) != 0) {
                    this.pipeline.stopAll();
                } else if ((answer & 0x100) != 0) {
                    return false;
                }
            }
            if (this.pipelineMeta.hasChanged()) {
                messageDialog = new MessageBox(this.hopShell(), 452);
                messageDialog.setText(BaseMessages.getString(PKG, (String)"PipelineGraph.SaveFile.Dialog.Header", (String[])new String[0]));
                messageDialog.setMessage(BaseMessages.getString(PKG, (String)"PipelineGraph.SaveFile.Dialog.Message", (String[])new String[]{this.buildTabName()}));
                answer = messageDialog.open();
                if ((answer & 0x40) != 0) {
                    if (StringUtils.isEmpty((String)this.getFilename())) {
                        String filename = BaseDialog.presentFileDialog(true, this.hopGui.getActiveShell(), this.fileType.getFilterExtensions(), this.fileType.getFilterNames(), true);
                        if (filename == null) {
                            return false;
                        }
                        filename = this.hopGui.getVariables().resolve(filename);
                        this.saveAs(filename);
                    } else {
                        this.save();
                    }
                    return true;
                }
                return (answer & 0x80) != 0;
            }
            return true;
        }
        catch (Exception e) {
            new ErrorDialog(this.hopShell(), CONST_ERROR, "Error preparing file close", e);
            return false;
        }
    }

    @Override
    @GuiToolbarElement(root="HopGuiPipelineGraph-Toolbar", id="HopGuiPipelineGraph-ToolBar-10010-Run", toolTip="i18n::PipelineGraph.Toolbar.Start.Tooltip", image="ui/images/run.svg")
    public void start() {
        try {
            this.pipelineMeta.setShowDialog(this.pipelineMeta.isAlwaysShowRunOptions());
            ServerPushSessionFacade.start();
            Thread thread = new Thread(() -> this.getDisplay().asyncExec(() -> {
                try {
                    if (this.isRunning() && this.pipeline.isPaused()) {
                        this.pauseResume();
                    } else {
                        this.pipelineRunDelegate.executePipeline(this.hopGui.getLog(), this.pipelineMeta, false, false, LogLevel.BASIC);
                        ServerPushSessionFacade.stop();
                    }
                }
                catch (Throwable e) {
                    new ErrorDialog(this.getShell(), "Execute pipeline", "There was an error during pipeline execution", e);
                }
            }));
            thread.start();
        }
        catch (Throwable e) {
            this.log.logError("Severe error in pipeline execution detected", e);
        }
    }

    @Override
    @GuiToolbarElement(root="HopGuiPipelineGraph-Toolbar", id="HopGuiPipelineGraph-ToolBar-10020-Pause", toolTip="i18n::PipelineGraph.Toolbar.Pause.Tooltip", image="ui/images/pause.svg")
    public void pause() {
        this.pauseResume();
    }

    @Override
    public void resume() {
        this.pauseResume();
    }

    @GuiToolbarElement(root="HopGuiPipelineGraph-Toolbar", id="HopGuiPipelineGraph-ToolBar-10040-Check", toolTip="i18n:org.apache.hop.ui.hopgui:HopGui.Tooltip.VerifyPipeline", image="ui/images/check.svg", separator=true)
    @GuiKeyboardShortcut(key=0x1000010)
    public void checkPipeline() {
        this.addAllTabs();
        this.pipelineCheckDelegate.checkPipeline();
    }

    public boolean isExecutionResultsPaneVisible() {
        return this.extraViewTabFolder != null && !this.extraViewTabFolder.isDisposed();
    }

    @GuiToolbarElement(root="HopGuiPipelineGraph-Toolbar", id="HopGuiPipelineGraph-ToolBar-10400-Execution-Results", toolTip="i18n:org.apache.hop.ui.hopgui:HopGui.Tooltip.ShowExecutionResults", image="ui/images/show-results.svg", separator=true)
    public void showExecutionResults() {
        ToolItem item = this.toolBarWidgets.findToolItem(TOOLBAR_ITEM_SHOW_EXECUTION_RESULTS);
        if (this.isExecutionResultsPaneVisible()) {
            this.disposeExtraView();
        } else {
            this.addAllTabs();
        }
    }

    public void checkEmptyExtraView() {
        if (this.extraViewTabFolder.getItemCount() == 0) {
            this.disposeExtraView();
        }
    }

    private void disposeExtraView() {
        if (this.extraViewTabFolder == null) {
            return;
        }
        this.extraViewTabFolder.dispose();
        this.sashForm.layout();
        this.sashForm.setWeights(new int[]{100});
        ToolItem item = this.toolBarWidgets.findToolItem(TOOLBAR_ITEM_SHOW_EXECUTION_RESULTS);
        item.setToolTipText(BaseMessages.getString(PKG, (String)"HopGui.Tooltip.ShowExecutionResults", (String[])new String[0]));
        item.setImage(GuiResource.getInstance().getImageShowResults());
    }

    private void minMaxExtraView() {
        boolean maximized;
        boolean bl = maximized = this.sashForm.getMaximizedControl() != null;
        if (maximized) {
            this.sashForm.setMaximizedControl(null);
            this.minMaxItem.setImage(GuiResource.getInstance().getImageMaximizePanel());
            this.minMaxItem.setToolTipText(BaseMessages.getString(PKG, (String)"PipelineGraph.ExecutionResultsPanel.MaxButton.Tooltip", (String[])new String[0]));
        } else {
            this.sashForm.setMaximizedControl((Control)this.extraViewTabFolder);
            this.minMaxItem.setImage(GuiResource.getInstance().getImageMinimizePanel());
            this.minMaxItem.setToolTipText(BaseMessages.getString(PKG, (String)"PipelineGraph.ExecutionResultsPanel.MinButton.Tooltip", (String[])new String[0]));
        }
    }

    private void rotateExtraView() {
        boolean orientation = !PropsUi.getInstance().isGraphExtraViewVerticalOrientation();
        PropsUi.getInstance().setGraphExtraViewVerticalOrientation(orientation);
        if (orientation) {
            this.sashForm.setOrientation(512);
            this.rotateItem.setImage(GuiResource.getInstance().getImageRotateRight());
        } else {
            this.sashForm.setOrientation(256);
            this.rotateItem.setImage(GuiResource.getInstance().getImageRotateLeft());
        }
    }

    public void addExtraView() {
        this.extraViewTabFolder = new CTabFolder((Composite)this.sashForm, 2);
        PropsUi.setLook((Widget)this.extraViewTabFolder, 4);
        this.extraViewTabFolder.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent arg0) {
                if (HopGuiPipelineGraph.this.sashForm.getMaximizedControl() == null) {
                    HopGuiPipelineGraph.this.sashForm.setMaximizedControl((Control)HopGuiPipelineGraph.this.extraViewTabFolder);
                } else {
                    HopGuiPipelineGraph.this.sashForm.setMaximizedControl(null);
                }
            }
        });
        FormData fdTabFolder = new FormData();
        fdTabFolder.left = new FormAttachment(0, 0);
        fdTabFolder.right = new FormAttachment(100, 0);
        fdTabFolder.top = new FormAttachment(0, 0);
        fdTabFolder.bottom = new FormAttachment(100, 0);
        this.extraViewTabFolder.setLayoutData((Object)fdTabFolder);
        ToolBar extraViewToolBar = new ToolBar((Composite)this.extraViewTabFolder, 0x800000);
        this.extraViewTabFolder.setTopRight((Control)extraViewToolBar, 131072);
        PropsUi.setLook((Widget)extraViewToolBar);
        this.minMaxItem = new ToolItem(extraViewToolBar, 8);
        this.minMaxItem.setImage(GuiResource.getInstance().getImageMaximizePanel());
        this.minMaxItem.setToolTipText(BaseMessages.getString(PKG, (String)"PipelineGraph.ExecutionResultsPanel.MaxButton.Tooltip", (String[])new String[0]));
        this.minMaxItem.addListener(13, e -> this.minMaxExtraView());
        this.rotateItem = new ToolItem(extraViewToolBar, 8);
        this.rotateItem.setImage(PropsUi.getInstance().isGraphExtraViewVerticalOrientation() ? GuiResource.getInstance().getImageRotateRight() : GuiResource.getInstance().getImageRotateLeft());
        this.rotateItem.setToolTipText(BaseMessages.getString(PKG, (String)"PipelineGraph.ExecutionResultsPanel.RotateButton.Tooltip", (String[])new String[0]));
        this.rotateItem.addListener(13, e -> this.rotateExtraView());
        ToolItem closeItem = new ToolItem(extraViewToolBar, 8);
        closeItem.setImage(GuiResource.getInstance().getImageClosePanel());
        closeItem.setToolTipText(BaseMessages.getString(PKG, (String)"PipelineGraph.ExecutionResultsPanel.CloseButton.Tooltip", (String[])new String[0]));
        closeItem.addListener(13, e -> this.disposeExtraView());
        int height = extraViewToolBar.computeSize((int)-1, (int)-1).y;
        this.extraViewTabFolder.setTabHeight(Math.max(height, this.extraViewTabFolder.getTabHeight()));
        this.sashForm.setWeights(new int[]{60, 40});
    }

    public synchronized void start(PipelineExecutionConfiguration executionConfiguration) throws HopException {
        if (this.handlePipelineMetaChanges(this.pipelineMeta)) {
            if (!this.isRunning()) {
                try {
                    DefaultLogLevel.setLogLevel((LogLevel)executionConfiguration.getLogLevel());
                    if (executionConfiguration.isClearingLog()) {
                        this.pipelineLogDelegate.clearLog();
                    }
                    if (this.pipeline != null) {
                        HopLogStore.discardLines((String)this.pipeline.getLogChannelId(), (boolean)true);
                    }
                    String pipelineRunConfigurationName = executionConfiguration.getRunConfiguration();
                    this.pipeline = PipelineEngineFactory.createPipelineEngine((IVariables)this.variables, (String)this.variables.resolve(pipelineRunConfigurationName), (IHopMetadataProvider)this.hopGui.getMetadataProvider(), (PipelineMeta)this.pipelineMeta);
                    Map variablesMap = executionConfiguration.getVariablesMap();
                    Set variableKeys = variablesMap.keySet();
                    for (String key : variableKeys) {
                        String value = (String)variablesMap.get(key);
                        if (!StringUtils.isNotEmpty((String)value)) continue;
                        this.pipeline.setVariable(key, value);
                    }
                    Map parametersMap = executionConfiguration.getParametersMap();
                    Set parametersKeys = parametersMap.keySet();
                    for (String key : parametersKeys) {
                        this.pipeline.setParameterValue(key, Const.NVL((String)((String)parametersMap.get(key)), (String)""));
                    }
                    this.pipeline.activateParameters(this.pipeline);
                    String guiLogObjectId = UUID.randomUUID().toString();
                    SimpleLoggingObject guiLoggingObject = new SimpleLoggingObject("HOP GUI", LoggingObjectType.HOP_GUI, null);
                    guiLoggingObject.setContainerObjectId(guiLogObjectId);
                    guiLoggingObject.setLogLevel(executionConfiguration.getLogLevel());
                    this.pipeline.setParent((ILoggingObject)guiLoggingObject);
                    this.pipeline.setLogLevel(executionConfiguration.getLogLevel());
                    this.log.logBasic(BaseMessages.getString(PKG, (String)"PipelineLog.Log.PipelineOpened", (String[])new String[0]));
                    try {
                        ExtensionPointHandler.callExtensionPoint((ILogChannel)this.log, (IVariables)this.variables, (String)HopExtensionPoint.HopGuiPipelineBeforeStart.id, this.pipeline);
                    }
                    catch (HopException e2) {
                        this.log.logError(e2.getMessage(), new Object[]{this.pipelineMeta.getFilename()});
                    }
                }
                catch (HopException e3) {
                    this.pipeline = null;
                    new ErrorDialog(this.hopShell(), BaseMessages.getString(PKG, (String)"PipelineLog.Dialog.ErrorOpeningPipeline.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"PipelineLog.Dialog.ErrorOpeningPipeline.Message", (String[])new String[0]), (Exception)((Object)e3));
                }
                if (this.pipeline != null) {
                    this.log.logBasic(BaseMessages.getString(PKG, (String)"PipelineLog.Log.LaunchingPipeline", (String[])new String[0]) + this.pipeline.getPipelineMeta().getName() + "]...");
                    Thread parentThread = Thread.currentThread();
                    this.getDisplay().asyncExec(() -> {
                        this.addAllTabs();
                        this.preparePipeline(parentThread);
                    });
                    this.log.logBasic(BaseMessages.getString(PKG, (String)"PipelineLog.Log.StartedExecutionOfPipeline", (String[])new String[0]));
                    this.updateGui();
                    this.pipeline.addExecutionFinishedListener(e -> this.pipelineFinished());
                }
            } else {
                this.modalMessageDialog(BaseMessages.getString(PKG, (String)"PipelineLog.Dialog.DoNoStartPipelineTwice.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"PipelineLog.Dialog.DoNoStartPipelineTwice.Message", (String[])new String[0]), 40);
            }
        } else {
            this.showSaveFileMessage();
        }
    }

    private void pipelineFinished() {
        try {
            HopGuiPipelineFinishedExtension ext = new HopGuiPipelineFinishedExtension(this, this.pipeline);
            ExtensionPointHandler.callExtensionPoint((ILogChannel)this.log, (IVariables)this.variables, (String)HopGuiExtensionPoint.HopGuiPipelineFinished.id, (Object)ext);
        }
        catch (HopException e) {
            new ErrorDialog(this.getShell(), CONST_ERROR, "Hop GUI encountered an error with an extension point at the end of a pipeline", (Exception)((Object)e));
        }
        this.updateGui();
    }

    private void addRowsSamplerToPipeline(IPipelineEngine<PipelineMeta> pipeline) {
        if (!(pipeline.getPipelineRunConfiguration().getEngineRunConfiguration() instanceof LocalPipelineRunConfiguration)) {
            return;
        }
        LocalPipelineRunConfiguration lprConfig = (LocalPipelineRunConfiguration)pipeline.getPipelineRunConfiguration().getEngineRunConfiguration();
        if (StringUtils.isEmpty((String)lprConfig.getSampleTypeInGui())) {
            return;
        }
        try {
            final LocalPipelineRunConfiguration.SampleType sampleType = LocalPipelineRunConfiguration.SampleType.valueOf((String)lprConfig.getSampleTypeInGui());
            if (sampleType == LocalPipelineRunConfiguration.SampleType.None) {
                return;
            }
            final int sampleSize = Const.toInt((String)pipeline.resolve(lprConfig.getSampleSize()), (int)100);
            if (sampleSize <= 0) {
                return;
            }
            this.outputRowsMap = new HashMap<String, RowBuffer>();
            final Random random = new Random();
            for (final String transformName : this.pipelineMeta.getTransformNames()) {
                IEngineComponent component = pipeline.findComponent(transformName, 0);
                if (component == null) continue;
                component.addRowListener((IRowListener)new RowAdapter(){
                    int nrRows = 0;

                    public void rowWrittenEvent(IRowMeta rowMeta, Object[] row) throws HopTransformException {
                        RowBuffer rowBuffer = HopGuiPipelineGraph.this.outputRowsMap.get(transformName);
                        if (rowBuffer == null) {
                            rowBuffer = new RowBuffer(rowMeta);
                            HopGuiPipelineGraph.this.outputRowsMap.put(transformName, rowBuffer);
                            if (sampleType == LocalPipelineRunConfiguration.SampleType.Last) {
                                rowBuffer.setBuffer(Collections.synchronizedList(new LinkedList()));
                            } else {
                                rowBuffer.setBuffer(Collections.synchronizedList(new ArrayList()));
                            }
                        }
                        if (sampleType != LocalPipelineRunConfiguration.SampleType.None) {
                            try {
                                row = rowMeta.cloneRow(row);
                            }
                            catch (HopValueException e) {
                                throw new HopTransformException("Error copying row for preview purposes", (Throwable)e);
                            }
                        }
                        switch (sampleType) {
                            case First: {
                                if (rowBuffer.size() >= sampleSize) break;
                                rowBuffer.addRow(row);
                                break;
                            }
                            case Last: {
                                rowBuffer.addRow(0, row);
                                if (rowBuffer.size() <= sampleSize) break;
                                rowBuffer.removeRow(rowBuffer.size() - 1);
                                break;
                            }
                            case Random: {
                                ++this.nrRows;
                                if (rowBuffer.size() < sampleSize) {
                                    rowBuffer.addRow(row);
                                    break;
                                }
                                int randomIndex = random.nextInt(this.nrRows);
                                if (randomIndex >= sampleSize) break;
                                rowBuffer.setRow(randomIndex, row);
                            }
                        }
                    }
                });
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void showSaveFileMessage() {
        this.modalMessageDialog(BaseMessages.getString(PKG, (String)"PipelineLog.Dialog.SavePipelineBeforeRunning.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"PipelineLog.Dialog.SavePipelineBeforeRunning.Message", (String[])new String[0]), 40);
    }

    public void addAllTabs() {
        this.pipelineLogDelegate.addPipelineLog();
        this.pipelineGridDelegate.addPipelineGrid();
        this.pipelineCheckDelegate.addPipelineCheck();
        if (this.extraViewTabFolder.getSelectionIndex() == -1) {
            this.extraViewTabFolder.setSelection(0);
        }
        if (!EnvironmentUtils.getInstance().isWeb()) {
            ToolItem item = this.toolBarWidgets.findToolItem(TOOLBAR_ITEM_SHOW_EXECUTION_RESULTS);
            item.setImage(GuiResource.getInstance().getImageHideResults());
            item.setToolTipText(BaseMessages.getString(PKG, (String)"HopGui.Tooltip.HideExecutionResults", (String[])new String[0]));
        }
    }

    public synchronized void debug(PipelineExecutionConfiguration executionConfiguration, PipelineDebugMeta pipelineDebugMeta) {
        if (!this.isRunning()) {
            try {
                this.lastPipelineDebugMeta = pipelineDebugMeta;
                this.log.setLogLevel(executionConfiguration.getLogLevel());
                if (this.log.isDetailed()) {
                    this.log.logDetailed(BaseMessages.getString(PKG, (String)"PipelineLog.Log.DoPreview", (String[])new String[0]));
                }
                if (executionConfiguration.isClearingLog()) {
                    this.pipelineLogDelegate.clearLog();
                }
                if (this.pipeline != null) {
                    HopLogStore.discardLines((String)this.pipeline.getLogChannelId(), (boolean)false);
                    LoggingRegistry.getInstance().removeIncludingChildren(this.pipeline.getLogChannelId());
                }
                this.pipeline = new LocalPipelineEngine(this.pipelineMeta, this.variables, this.hopGui.getLoggingObject());
                this.pipeline.setPreview(true);
                this.pipeline.setVariable("PIPELINE_IN_PREVIEW_MODE", "Y");
                this.pipeline.setMetadataProvider((IHopMetadataProvider)this.hopGui.getMetadataProvider());
                Map variablesMap = executionConfiguration.getVariablesMap();
                Set variableKeys = variablesMap.keySet();
                for (String key : variableKeys) {
                    String value = (String)variablesMap.get(key);
                    if (!StringUtils.isNotEmpty((String)value)) continue;
                    this.pipeline.setVariable(key, value);
                }
                this.pipeline.copyParametersFromDefinitions((INamedParameterDefinitions)this.pipelineMeta);
                Map parametersMap = executionConfiguration.getParametersMap();
                Set parametersKeys = parametersMap.keySet();
                for (String key : parametersKeys) {
                    String value = Const.NVL((String)((String)parametersMap.get(key)), (String)"");
                    this.pipeline.setParameterValue(key, value);
                    this.pipeline.setVariable(key, value);
                }
                try {
                    ExtensionPointHandler.callExtensionPoint((ILogChannel)this.log, (IVariables)this.variables, (String)HopExtensionPoint.HopGuiPipelineBeforeStart.id, this.pipeline);
                }
                catch (HopException e) {
                    this.log.logError(e.getMessage(), new Object[]{this.pipelineMeta.getFilename()});
                }
                this.pipeline.prepareExecution();
                pipelineDebugMeta.addRowListenersToPipeline(this.pipeline);
                pipelineDebugMeta.addBreakPointListers(this::showPreview);
                this.startThreads();
                this.debug = true;
                this.hopDisplay().asyncExec(this::addAllTabs);
            }
            catch (Exception e) {
                new ErrorDialog(this.hopShell(), BaseMessages.getString(PKG, (String)"PipelineLog.Dialog.UnexpectedErrorDuringPreview.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"PipelineLog.Dialog.UnexpectedErrorDuringPreview.Message", (String[])new String[0]), e);
            }
        } else {
            this.modalMessageDialog(BaseMessages.getString(PKG, (String)"PipelineLog.Dialog.DoNoPreviewWhileRunning.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"PipelineLog.Dialog.DoNoPreviewWhileRunning.Message", (String[])new String[0]), 40);
        }
        this.checkErrorVisuals();
    }

    public synchronized void showPreview(PipelineDebugMeta pipelineDebugMeta, TransformDebugMeta transformDebugMeta, IRowMeta rowBufferMeta, List<Object[]> rowBuffer) {
        this.hopDisplay().asyncExec(() -> {
            if (this.isDisposed()) {
                return;
            }
            this.updateGui();
            this.checkErrorVisuals();
            PreviewRowsDialog previewRowsDialog = new PreviewRowsDialog(this.hopShell(), this.variables, 268504176, transformDebugMeta.getTransformMeta().getName(), rowBufferMeta, rowBuffer);
            previewRowsDialog.setProposingToGetMoreRows(true);
            previewRowsDialog.setProposingToStop(true);
            previewRowsDialog.open();
            if (previewRowsDialog.isAskingForMoreRows()) {
                rowBuffer.clear();
                this.pauseResume();
            }
            if (previewRowsDialog.isAskingToStop()) {
                this.stop();
            }
        });
    }

    private String[] convertArguments(Map<String, String> arguments) {
        Object[] argumentNames = arguments.keySet().toArray(new String[arguments.size()]);
        Arrays.sort(argumentNames);
        String[] args = new String[argumentNames.length];
        for (int i = 0; i < args.length; ++i) {
            Object argumentName = argumentNames[i];
            args[i] = arguments.get(argumentName);
        }
        return args;
    }

    @Override
    @GuiToolbarElement(root="HopGuiPipelineGraph-Toolbar", id="HopGuiPipelineGraph-ToolBar-10030-Stop", toolTip="i18n::PipelineGraph.Toolbar.Stop.Tooltip", image="ui/images/stop.svg")
    public void stop() {
        if (this.safeStopping) {
            this.modalMessageDialog(BaseMessages.getString(PKG, (String)"PipelineLog.Log.SafeStopAlreadyStarted.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"PipelineLog.Log.SafeStopAlreadyStarted", (String[])new String[0]), 33);
            return;
        }
        if (this.isRunning() && !this.halting) {
            this.halting = true;
            this.pipeline.stopAll();
            this.log.logBasic(BaseMessages.getString(PKG, (String)"PipelineLog.Log.ProcessingOfPipelineStopped", (String[])new String[0]));
            this.halted = false;
            this.halting = false;
        }
        this.updateGui();
    }

    public synchronized void pauseResume() {
        if (this.isRunning()) {
            if (!this.pipeline.isPaused()) {
                this.pipeline.pauseExecution();
                this.updateGui();
            } else {
                this.pipeline.resumeExecution();
                this.updateGui();
            }
        }
    }

    private synchronized void preparePipeline(Thread parentThread) {
        Runnable runnable = () -> {
            try {
                this.pipeline.prepareExecution();
                this.updateGui();
                this.addRowsSamplerToPipeline(this.pipeline);
                this.initialized = true;
            }
            catch (HopException e) {
                this.log.logError(this.pipeline.getPipelineMeta().getName() + ": preparing pipeline execution failed", (Throwable)e);
                this.checkErrorVisuals();
            }
            this.halted = this.pipeline.hasHaltedComponents();
            if (this.pipeline.isReadyToStart()) {
                this.checkStartThreads();
            } else {
                this.initialized = false;
                this.checkErrorVisuals();
            }
        };
        Thread thread = new Thread(runnable);
        thread.start();
    }

    private void checkStartThreads() {
        if (this.initialized && !this.isRunning() && this.pipeline != null) {
            this.startThreads();
        }
    }

    private synchronized void startThreads() {
        try {
            this.pipeline.addExecutionFinishedListener(pipeline -> {
                this.checkPipelineEnded();
                this.checkErrorVisuals();
                this.stopRedrawTimer();
            });
            this.hopGui.getDisplay().asyncExec(() -> new Thread(() -> {
                try {
                    this.pipeline.startThreads();
                    this.pipeline.waitUntilFinished();
                }
                catch (Exception e) {
                    this.log.logError("Error starting transform threads", (Throwable)e);
                    this.checkErrorVisuals();
                    this.stopRedrawTimer();
                }
            }).start());
            this.startRedrawTimer();
            this.updateGui();
        }
        catch (Exception e) {
            this.log.logError("Error starting transform threads", (Throwable)e);
            this.checkErrorVisuals();
            this.stopRedrawTimer();
        }
    }

    private void startRedrawTimer() {
        this.redrawTimer = new Timer("HopGuiPipelineGraph: redraw timer");
        TimerTask timtask = new TimerTask(){

            @Override
            public void run() {
                if (!HopGuiPipelineGraph.this.hopDisplay().isDisposed()) {
                    HopGuiPipelineGraph.this.hopDisplay().asyncExec(() -> {
                        if (!HopGuiPipelineGraph.this.canvas.isDisposed() && HopGuiPipelineGraph.this.perspective.isActive() && HopGuiPipelineGraph.this.isVisible()) {
                            HopGuiPipelineGraph.this.canvas.redraw();
                            HopGuiPipelineGraph.this.updateGui();
                        }
                    });
                }
            }
        };
        this.redrawTimer.schedule(timtask, 0L, 1000L);
    }

    protected void stopRedrawTimer() {
        ExecutorUtil.cleanup((Timer)this.redrawTimer);
        this.pipelineGridDelegate.stopRefreshMetricsTimer();
        this.redrawTimer = null;
    }

    private void checkPipelineEnded() {
        if (this.pipeline != null && this.pipeline.isFinished() && (this.isRunning() || this.halted)) {
            this.log.logBasic(BaseMessages.getString(PKG, (String)"PipelineLog.Log.PipelineHasFinished", (String[])new String[0]));
            this.initialized = false;
            this.halted = false;
            this.halting = false;
            this.safeStopping = false;
            this.updateGui();
            if (this.debug && this.lastPipelineDebugMeta != null && this.lastPipelineDebugMeta.getTotalNumberOfHits() == 0) {
                this.debug = false;
                this.showLastPreviewResults();
            }
            this.debug = false;
            this.checkErrorVisuals();
            this.hopDisplay().asyncExec(this::updateGui);
        }
    }

    private void checkErrorVisuals() {
        if (this.pipeline.getErrors() > 0) {
            this.transformLogMap = new HashMap<String, String>();
            for (IEngineComponent component : this.pipeline.getComponents()) {
                if (component.getErrors() <= 0L) continue;
                String logText = component.getLogText();
                this.transformLogMap.put(component.getName(), logText);
            }
        } else {
            this.transformLogMap = null;
        }
        this.hopDisplay().asyncExec(() -> this.redraw());
    }

    public synchronized void showLastPreviewResults() {
        if (this.lastPipelineDebugMeta == null || this.lastPipelineDebugMeta.getTransformDebugMetaMap().isEmpty()) {
            return;
        }
        ArrayList<String> transformnames = new ArrayList<String>();
        ArrayList<IRowMeta> rowMetas = new ArrayList<IRowMeta>();
        ArrayList<List> rowBuffers = new ArrayList<List>();
        for (TransformMeta transformMeta : this.lastPipelineDebugMeta.getTransformDebugMetaMap().keySet()) {
            TransformDebugMeta transformDebugMeta = (TransformDebugMeta)this.lastPipelineDebugMeta.getTransformDebugMetaMap().get(transformMeta);
            transformnames.add(transformMeta.getName());
            rowMetas.add(transformDebugMeta.getRowBufferMeta());
            rowBuffers.add(transformDebugMeta.getRowBuffer());
        }
        this.hopDisplay().asyncExec(() -> {
            EnterPreviewRowsDialog dialog = new EnterPreviewRowsDialog(this.hopShell(), 0, transformnames, rowMetas, rowBuffers);
            dialog.open();
        });
    }

    public boolean isRunning() {
        if (this.pipeline == null) {
            return false;
        }
        if (this.pipeline.isStopped()) {
            return false;
        }
        if (this.pipeline.isPreparing()) {
            return true;
        }
        return this.pipeline.isRunning();
    }

    public IHasLogChannel getLogChannelProvider() {
        return () -> this.getPipeline() != null ? this.getPipeline().getLogChannel() : LogChannel.GENERAL;
    }

    @GuiContextAction(id="pipeline-graph-transform-12000-sniff-output", parentId="HopGuiPipelineTransformContext", type=GuiActionType.Info, name="i18n::HopGuiPipelineGraph.PipelineAction.SniffOutput.Name", tooltip="i18n::HopGuiPipelineGraph.PipelineAction.SniffOutput.Tooltip", image="ui/images/preview.svg", category="Preview", categoryOrder="3")
    public void sniff(HopGuiPipelineTransformContext context) {
        TransformMeta transformMeta = context.getTransformMeta();
        if (this.pipeline == null) {
            MessageBox messageBox = new MessageBox(this.hopShell(), 34);
            messageBox.setText(BaseMessages.getString(PKG, (String)"PipelineGraph.SniffTestingAvailableWhenRunning.Title", (String[])new String[0]));
            messageBox.setMessage(BaseMessages.getString(PKG, (String)"PipelineGraph.SniffTestingAvailableWhenRunning.Message", (String[])new String[0]));
            messageBox.open();
            return;
        }
        if (!this.pipeline.isFinished()) {
            try {
                this.pipeline.retrieveComponentOutput(this.hopGui.getVariables(), transformMeta.getName(), 0, 50, (pipelineEngine, rowBuffer) -> this.hopDisplay().asyncExec(() -> {
                    PreviewRowsDialog dialog = new PreviewRowsDialog(this.hopShell(), this.hopGui.getVariables(), 0, transformMeta.getName(), rowBuffer.getRowMeta(), rowBuffer.getBuffer());
                    dialog.open();
                }));
            }
            catch (HopException e) {
                new ErrorDialog(this.hopShell(), CONST_ERROR, "Error sniffing rows", (Exception)((Object)e));
            }
        }
    }

    public ILogChannel getLogChannel() {
        return this.log;
    }

    public void editTransform(PipelineMeta pipelineMeta, TransformMeta transformMeta) {
        this.pipelineTransformDelegate.editTransform(pipelineMeta, transformMeta);
    }

    public String buildTabName() throws HopException {
        String tabName = null;
        String realFilename = this.variables.resolve(this.pipelineMeta.getFilename());
        if (StringUtils.isEmpty((String)realFilename)) {
            tabName = this.pipelineMeta.getName();
        } else {
            try {
                FileObject fileObject = HopVfs.getFileObject((String)this.pipelineMeta.getFilename());
                FileName fileName = fileObject.getName();
                tabName = fileName.getBaseName();
            }
            catch (Exception e) {
                throw new HopException("Unable to get information from file name '" + this.pipelineMeta.getFilename() + "'", (Throwable)e);
            }
        }
        return tabName;
    }

    public boolean handlePipelineMetaChanges(PipelineMeta pipelineMeta) throws HopException {
        if (pipelineMeta.hasChanged()) {
            if (StringUtils.isNotEmpty((String)pipelineMeta.getFilename()) && this.hopGui.getProps().getAutoSave()) {
                this.save();
            } else {
                MessageDialogWithToggle md = new MessageDialogWithToggle(this.hopShell(), BaseMessages.getString(PKG, (String)"PipelineLog.Dialog.FileHasChanged.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"PipelineLog.Dialog.FileHasChanged1.Message", (String[])new String[0]) + Const.CR + BaseMessages.getString(PKG, (String)"PipelineLog.Dialog.FileHasChanged2.Message", (String[])new String[0]) + Const.CR, 4, new String[]{BaseMessages.getString(PKG, (String)"System.Button.Yes", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.Button.No", (String[])new String[0])}, BaseMessages.getString(PKG, (String)"PipelineLog.Dialog.Option.AutoSavePipeline", (String[])new String[0]), this.hopGui.getProps().getAutoSave());
                int answer = md.open();
                if (answer == 0) {
                    String filename = pipelineMeta.getFilename();
                    if (StringUtils.isEmpty((String)filename)) {
                        filename = BaseDialog.presentFileDialog(true, this.hopGui.getShell(), this.fileType.getFilterExtensions(), this.fileType.getFilterNames(), true);
                        if (filename != null) {
                            filename = this.hopGui.getVariables().resolve(filename);
                            this.saveAs(filename);
                        }
                    } else {
                        this.save();
                    }
                }
                this.hopGui.getProps().setAutoSave(md.getToggleState());
            }
        }
        return StringUtils.isNotEmpty((String)pipelineMeta.getFilename()) && !pipelineMeta.hasChanged();
    }

    public void addTransformToChain(IPlugin transformPlugin, boolean shift) {
        List sel;
        if (this.lastChained != null && this.pipelineMeta.findTransform(this.lastChained.getName()) == null) {
            this.lastChained = null;
        }
        if ((sel = this.pipelineMeta.getSelectedTransforms()).size() == 1) {
            this.lastChained = (TransformMeta)sel.get(0);
        }
        Point p = null;
        if (this.lastChained == null) {
            p = this.pipelineMeta.getMaximum();
            p.x -= 100;
        } else {
            p = new Point(this.lastChained.getLocation().x, this.lastChained.getLocation().y);
        }
        p.x += 200;
        TransformMeta newTransform = this.pipelineTransformDelegate.newTransform(this.pipelineMeta, transformPlugin.getIds()[0], transformPlugin.getName(), transformPlugin.getName(), false, true, p);
        if (newTransform == null) {
            return;
        }
        PropsUi.setLocation((IGuiPosition)newTransform, p.x, p.y);
        if (this.lastChained != null) {
            PipelineHopMeta hop = new PipelineHopMeta(this.lastChained, newTransform);
            this.pipelineHopDelegate.newHop(this.pipelineMeta, hop);
        }
        this.lastChained = newTransform;
        if (shift) {
            this.editTransform(newTransform);
        }
        this.pipelineMeta.unselectAll();
        newTransform.setSelected(true);
        this.updateGui();
    }

    public HopGui getHopGui() {
        return this.hopGui;
    }

    public void setHopGui(HopGui hopGui) {
        this.hopGui = hopGui;
    }

    @Override
    public Object getSubject() {
        return this.pipelineMeta;
    }

    private void setHopEnabled(PipelineHopMeta hop, boolean enabled) {
        hop.setEnabled(enabled);
        this.pipelineMeta.clearCaches();
    }

    private void modalMessageDialog(String title, String message, int swtFlags) {
        MessageBox messageBox = new MessageBox(this.hopShell(), swtFlags);
        messageBox.setMessage(message);
        messageBox.setText(title);
        messageBox.open();
    }

    @Override
    public HopPipelineFileType<PipelineMeta> getFileType() {
        return this.fileType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HopGuiPipelineGraph that = (HopGuiPipelineGraph)o;
        return Objects.equals(this.pipelineMeta, that.pipelineMeta) && Objects.equals(this.id, that.id);
    }

    public int hashCode() {
        return Objects.hash(this.pipelineMeta, this.id);
    }

    @Override
    @GuiToolbarElement(root="HopGuiPipelineGraph-Toolbar", id="HopGuiPipelineGraph-ToolBar-10100-Undo", toolTip="i18n:org.apache.hop.ui.hopgui:HopGui.Toolbar.Undo.Tooltip", image="ui/images/undo.svg", separator=true)
    @GuiKeyboardShortcut(control=true, key=122)
    @GuiOsxKeyboardShortcut(command=true, key=122)
    public void undo() {
        this.pipelineUndoDelegate.undoPipelineAction(this, this.pipelineMeta);
        this.forceFocus();
    }

    @Override
    @GuiToolbarElement(root="HopGuiPipelineGraph-Toolbar", id="HopGuiPipelineGraph-ToolBar-10110-Redo", toolTip="i18n:org.apache.hop.ui.hopgui:HopGui.Toolbar.Redo.Tooltip", image="ui/images/redo.svg")
    @GuiKeyboardShortcut(control=true, shift=true, key=122)
    @GuiOsxKeyboardShortcut(command=true, shift=true, key=122)
    public void redo() {
        this.pipelineUndoDelegate.redoPipelineAction(this, this.pipelineMeta);
        this.forceFocus();
    }

    @Override
    public void updateGui() {
        if (this.hopGui == null || this.toolBarWidgets == null || this.toolBar == null || this.toolBar.isDisposed()) {
            return;
        }
        this.hopDisplay().asyncExec(() -> {
            this.setZoomLabel();
            this.toolBarWidgets.enableToolbarItem(TOOLBAR_ITEM_UNDO_ID, this.pipelineMeta.viewThisUndo() != null);
            this.toolBarWidgets.enableToolbarItem(TOOLBAR_ITEM_REDO_ID, this.pipelineMeta.viewNextUndo() != null);
            boolean running = this.isRunning();
            boolean paused = running && this.pipeline.isPaused();
            this.toolBarWidgets.enableToolbarItem(TOOLBAR_ITEM_START, !running || paused);
            this.toolBarWidgets.enableToolbarItem(TOOLBAR_ITEM_STOP, running);
            this.toolBarWidgets.enableToolbarItem(TOOLBAR_ITEM_PAUSE, running && !paused);
            this.hopGui.setUndoMenu((IUndo)this.pipelineMeta);
            this.hopGui.handleFileCapabilities(this.fileType, this.pipelineMeta.hasChanged(), running, paused);
            super.enableSnapAlignDistributeMenuItems(this.fileType, !this.pipelineMeta.getSelectedTransforms().isEmpty());
            try {
                ExtensionPointHandler.callExtensionPoint((ILogChannel)LogChannel.UI, (IVariables)this.variables, (String)HopGuiExtensionPoint.HopGuiPipelineGraphUpdateGui.id, (Object)this);
            }
            catch (Exception xe) {
                LogChannel.UI.logError("Error handling extension point 'HopGuiFileOpenDialog'", (Throwable)xe);
            }
            HopGuiPipelineGraph.super.redraw();
        });
    }

    @Override
    public boolean forceFocus() {
        return this.canvas.forceFocus();
    }

    @Override
    @GuiKeyboardShortcut(control=true, key=97)
    @GuiOsxKeyboardShortcut(command=true, key=97)
    public void selectAll() {
        this.pipelineMeta.selectAll();
        this.updateGui();
    }

    @Override
    @GuiKeyboardShortcut(key=27)
    public void unselectAll() {
        this.clearSettings();
        this.updateGui();
    }

    @Override
    @GuiKeyboardShortcut(control=true, key=99)
    @GuiOsxKeyboardShortcut(command=true, key=99)
    public void copySelectedToClipboard() {
        if (this.pipelineLogDelegate.hasSelectedText()) {
            this.pipelineLogDelegate.copySelected();
        } else {
            this.pipelineClipboardDelegate.copySelected(this.pipelineMeta, this.pipelineMeta.getSelectedTransforms(), this.pipelineMeta.getSelectedNotes());
        }
    }

    @Override
    @GuiKeyboardShortcut(control=true, key=120)
    @GuiOsxKeyboardShortcut(command=true, key=120)
    public void cutSelectedToClipboard() {
        this.pipelineClipboardDelegate.copySelected(this.pipelineMeta, this.pipelineMeta.getSelectedTransforms(), this.pipelineMeta.getSelectedNotes());
        this.pipelineTransformDelegate.delTransforms(this.pipelineMeta, this.pipelineMeta.getSelectedTransforms());
        this.notePadDelegate.deleteNotes((AbstractMeta)this.pipelineMeta, this.pipelineMeta.getSelectedNotes());
    }

    @Override
    @GuiKeyboardShortcut(key=127)
    public void deleteSelected() {
        this.delSelected(null);
        this.updateGui();
    }

    @Override
    @GuiKeyboardShortcut(control=true, key=118)
    @GuiOsxKeyboardShortcut(command=true, key=118)
    public void pasteFromClipboard() {
        this.pasteFromClipboard(new Point(this.currentMouseX, this.currentMouseY));
    }

    public void pasteFromClipboard(Point location) {
        String clipboard = this.pipelineClipboardDelegate.fromClipboard();
        this.pipelineClipboardDelegate.pasteXml(this.pipelineMeta, clipboard, location);
    }

    @GuiContextAction(id="pipeline-graph-transform-10200-past-from-clipboard", parentId="HopGuiPipelineContext", type=GuiActionType.Modify, name="i18n::HopGuiPipelineGraph.PipelineAction.PasteFromClipboard.Name", tooltip="i18n::HopGuiPipelineGraph.PipelineAction.PasteFromClipboard.Tooltip", image="ui/images/paste.svg", category="Basic", categoryOrder="1")
    public void pasteFromClipboard(HopGuiPipelineContext context) {
        this.pasteFromClipboard(context.getClick());
    }

    @GuiContextAction(id="pipeline-graph-transform-10010-copy-transform-to-clipboard", parentId="HopGuiPipelineTransformContext", type=GuiActionType.Custom, name="i18n::HopGuiPipelineGraph.PipelineAction.CopyToClipboard.Name", tooltip="i18n::HopGuiPipelineGraph.PipelineAction.CopyToClipboard.Tooltip", image="ui/images/copy.svg", category="Basic", categoryOrder="1")
    public void copyTransformToClipboard(HopGuiPipelineTransformContext context) {
        this.pipelineClipboardDelegate.copySelected(this.pipelineMeta, Arrays.asList(context.getTransformMeta()), Collections.emptyList());
    }

    @GuiKeyboardShortcut(key=32)
    @GuiOsxKeyboardShortcut(key=32)
    public void showOutputFields() {
        if (this.lastMove != null) {
            this.hideToolTips();
            TransformMeta transformMeta = this.pipelineMeta.getTransform(this.lastMove.x, this.lastMove.y, this.iconSize);
            if (transformMeta != null) {
                this.inputOutputFields(transformMeta, false);
            }
        }
    }

    @GuiKeyboardShortcut(key=122)
    @GuiOsxKeyboardShortcut(key=122)
    public void openReferencedObject() {
        if (this.lastMove != null) {
            this.hideToolTips();
            TransformMeta transformMeta = this.pipelineMeta.getTransform(this.lastMove.x, this.lastMove.y, this.iconSize);
            if (transformMeta != null) {
                ITransformMeta iTransformMeta = transformMeta.getTransform();
                String[] objectDescriptions = iTransformMeta.getReferencedObjectDescriptions();
                if (objectDescriptions == null || objectDescriptions.length == 0) {
                    return;
                }
                if (objectDescriptions.length == 1) {
                    HopGuiPipelineTransformContext.openReferencedObject(this.pipelineMeta, this.variables, iTransformMeta, objectDescriptions[0], 0);
                } else {
                    EnterSelectionDialog dialog = new EnterSelectionDialog(this.getShell(), objectDescriptions, BaseMessages.getString(PKG, (String)"HopGuiPipelineGraph.OpenReferencedObject.Selection.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"HopGuiPipelineGraph.OpenReferencedObject.Selection.Message", (String[])new String[0]));
                    String answer = dialog.open(0);
                    if (answer != null) {
                        int index = dialog.getSelectionNr();
                        HopGuiPipelineTransformContext.openReferencedObject(this.pipelineMeta, this.variables, iTransformMeta, answer, index);
                    }
                }
            }
        }
    }

    @Override
    public List<IGuiContextHandler> getContextHandlers() {
        return new ArrayList<IGuiContextHandler>();
    }

    @GuiContextAction(id="pipeline-graph-navigate-to-execution-info", parentId="HopGuiPipelineContext", type=GuiActionType.Info, name="i18n::HopGuiPipelineGraph.ContextualAction.NavigateToExecutionInfo.Text", tooltip="i18n::HopGuiPipelineGraph.ContextualAction.NavigateToExecutionInfo.Tooltip", image="ui/images/execution.svg", category="Basic", categoryOrder="1")
    public void navigateToExecutionInfo(HopGuiPipelineContext context) {
        this.navigateToExecutionInfo();
    }

    @GuiToolbarElement(root="HopGuiPipelineGraph-Toolbar", id="HopGuiPipelineGraph-ToolBar-10475-ToExecutionInfo", toolTip="i18n:org.apache.hop.ui.hopgui:HopGui.Toolbar.ToExecutionInfo", type=GuiToolbarElementType.BUTTON, image="ui/images/execution.svg")
    public void navigateToExecutionInfo() {
        try {
            ExecutionInfoLocation location;
            MultiMetadataProvider metadataProvider;
            IHopMetadataSerializer serializer;
            List locationNames;
            ExecutionPerspective ep = HopGui.getExecutionPerspective();
            if (this.pipeline != null) {
                ExecutionInfoLocation location2;
                IExecutionInfoLocation iLocation;
                Execution execution;
                IExecutionViewer viewer = ep.findViewer(this.pipeline.getLogChannelId(), this.pipelineMeta.getName());
                if (viewer != null) {
                    ep.setActiveViewer(viewer);
                    ep.activate();
                    return;
                }
                ep.refresh();
                String locationName = this.variables.resolve(this.pipeline.getPipelineRunConfiguration().getExecutionInfoLocationName());
                if (StringUtils.isNotEmpty((String)locationName) && (execution = (iLocation = (location2 = ep.getLocationMap().get(locationName)).getExecutionInfoLocation()).getExecution(this.pipeline.getLogChannelId())) != null) {
                    ExecutionState executionState = location2.getExecutionInfoLocation().getExecutionState(execution.getId());
                    ep.createExecutionViewer(locationName, execution, executionState);
                    ep.activate();
                    return;
                }
            }
            if ((locationNames = (serializer = (metadataProvider = this.hopGui.getMetadataProvider()).getSerializer(ExecutionInfoLocation.class)).listObjectNames()).isEmpty()) {
                return;
            }
            if (locationNames.size() == 1) {
                location = (ExecutionInfoLocation)serializer.load((String)locationNames.get(0));
            } else {
                EnterSelectionDialog dialog = new EnterSelectionDialog(this.getShell(), locationNames.toArray(new String[0]), "Select location", "Select the execution information location to query");
                String locationName = dialog.open();
                if (locationName != null) {
                    location = (ExecutionInfoLocation)serializer.load(locationName);
                } else {
                    return;
                }
            }
            ep.createLastExecutionView(location.getName(), ExecutionType.Pipeline, this.pipelineMeta.getName());
            ep.activate();
        }
        catch (Exception e) {
            new ErrorDialog(this.getShell(), CONST_ERROR, "Error navigating to the latest execution information for this pipeline", e);
        }
    }

    @Override
    public void reload() {
        try {
            this.pipelineMeta.loadXml(this.getFilename(), (IHopMetadataProvider)this.hopGui.getMetadataProvider(), this.hopGui.getVariables());
        }
        catch (HopMissingPluginsException | HopXmlException e) {
            LogChannel.GENERAL.logError("Error reloading pipeline xml file", e);
        }
        this.redraw();
        this.updateGui();
    }

    @GuiContextAction(id="pipeline-graph-transform-11000-view-execution-info", parentId="HopGuiPipelineTransformContext", type=GuiActionType.Info, name="i18n::HopGuiPipelineGraph.TransformAction.ViewExecutionInfo.Name", tooltip="i18n::HopGuiPipelineGraph.TransformAction.ViewExecutionInfo.Tooltip", image="ui/images/execution.svg", category="Basic", categoryOrder="1")
    public void viewTransformExecutionInfo(HopGuiPipelineTransformContext context) {
        try {
            if (this.pipeline == null) {
                return;
            }
            PipelineRunConfiguration runConfiguration = this.pipeline.getPipelineRunConfiguration();
            String locationName = this.variables.resolve(runConfiguration.getExecutionInfoLocationName());
            if (StringUtils.isEmpty((String)locationName)) {
                return;
            }
            ExecutionPerspective executionPerspective = HopGui.getExecutionPerspective();
            executionPerspective.refresh();
            ExecutionInfoLocation location = executionPerspective.getLocationMap().get(locationName);
            if (location == null) {
                throw new HopException("Unable to find execution information location '" + locationName + "' in the execution information perspective");
            }
            IExecutionInfoLocation iLocation = location.getExecutionInfoLocation();
            TransformMeta transformMeta = context.getTransformMeta();
            List components = this.pipeline.getComponentCopies(transformMeta.getName());
            if (components.isEmpty()) {
                throw new HopException("Hop couldn't find any running copies of this transform.");
            }
            IEngineComponent component = (IEngineComponent)components.get(0);
            String transformId = component.getLogChannelId();
            List executions = iLocation.findExecutions(transformId);
            if (!executions.isEmpty()) {
                Execution execution = (Execution)executions.get(0);
                ExecutionState executionState = iLocation.getExecutionState(execution.getId());
                executionPerspective.createExecutionViewer(locationName, execution, executionState);
                executionPerspective.activate();
            }
        }
        catch (Exception e) {
            new ErrorDialog(this.getShell(), CONST_ERROR, "Error looking up execution information", e);
        }
    }

    @Generated
    public PipelineMeta getPipelineMeta() {
        return this.pipelineMeta;
    }

    @Generated
    public IPipelineEngine<PipelineMeta> getPipeline() {
        return this.pipeline;
    }

    @Generated
    public HopDataOrchestrationPerspective getPerspective() {
        return this.perspective;
    }

    @Generated
    public ToolBar getToolBar() {
        return this.toolBar;
    }

    @Generated
    public void setToolBar(ToolBar toolBar) {
        this.toolBar = toolBar;
    }

    @Generated
    public GuiToolbarWidgets getToolBarWidgets() {
        return this.toolBarWidgets;
    }

    @Generated
    public Point getLastMove() {
        return this.lastMove;
    }

    @Generated
    public List<ICheckResult> getRemarks() {
        return this.remarks;
    }

    @Generated
    public void setRemarks(List<ICheckResult> remarks) {
        this.remarks = remarks;
    }

    @Generated
    public List<DatabaseImpact> getImpact() {
        return this.impact;
    }

    @Generated
    public void setImpact(List<DatabaseImpact> impact) {
        this.impact = impact;
    }

    @Generated
    public boolean isImpactFinished() {
        return this.impactFinished;
    }

    @Generated
    public void setImpactFinished(boolean impactFinished) {
        this.impactFinished = impactFinished;
    }

    @Generated
    public PipelineDebugMeta getLastPipelineDebugMeta() {
        return this.lastPipelineDebugMeta;
    }

    @Generated
    public void setCurrentTransform(TransformMeta currentTransform) {
        this.currentTransform = currentTransform;
    }

    @Generated
    public TransformMeta getCurrentTransform() {
        return this.currentTransform;
    }

    @Generated
    public boolean isHalting() {
        return this.halting;
    }

    @Generated
    public void setHalting(boolean halting) {
        this.halting = halting;
    }

    @Generated
    public Map<String, String> getTransformLogMap() {
        return this.transformLogMap;
    }

    @Generated
    public void setTransformLogMap(Map<String, String> transformLogMap) {
        this.transformLogMap = transformLogMap;
    }

    @Generated
    public void setFileType(HopPipelineFileType<PipelineMeta> fileType) {
        this.fileType = fileType;
    }

    @Generated
    public Map<String, RowBuffer> getOutputRowsMap() {
        return this.outputRowsMap;
    }

    @Generated
    public void setOutputRowsMap(Map<String, RowBuffer> outputRowsMap) {
        this.outputRowsMap = outputRowsMap;
    }

    private static enum SingleClickType {
        Pipeline,
        Transform,
        Note,
        Hop;

    }
}

