/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.mail.workflow.actions.mail;

import jakarta.activation.DataHandler;
import jakarta.activation.DataSource;
import jakarta.activation.FileDataSource;
import jakarta.activation.URLDataSource;
import jakarta.mail.Address;
import jakarta.mail.BodyPart;
import jakarta.mail.Message;
import jakarta.mail.MessagingException;
import jakarta.mail.Multipart;
import jakarta.mail.SendFailedException;
import jakarta.mail.Session;
import jakarta.mail.Transport;
import jakarta.mail.internet.InternetAddress;
import jakarta.mail.internet.MimeBodyPart;
import jakarta.mail.internet.MimeMessage;
import jakarta.mail.internet.MimeMultipart;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import lombok.Generated;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileType;
import org.apache.hop.core.Const;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.Result;
import org.apache.hop.core.ResultFile;
import org.apache.hop.core.annotations.Action;
import org.apache.hop.core.encryption.Encr;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.gui.WorkflowTracker;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.mail.metadata.MailServerConnection;
import org.apache.hop.mail.workflow.actions.mail.MailEmbeddedImageField;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.resource.IResourceHolder;
import org.apache.hop.resource.ResourceEntry;
import org.apache.hop.resource.ResourceReference;
import org.apache.hop.workflow.ActionResult;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.action.ActionBase;
import org.apache.hop.workflow.action.IAction;
import org.apache.hop.workflow.action.validator.ActionValidatorUtils;
import org.apache.hop.workflow.action.validator.AndValidator;
import org.apache.hop.workflow.action.validator.IActionValidator;

@Action(id="MAIL", name="i18n::ActionMail.Name", description="i18n::ActionMail.Description", image="mail.svg", categoryDescription="i18n:org.apache.hop.workflow:ActionCategory.Category.Mail", keywords={"i18n::ActionMail.keyword"}, documentationUrl="/workflow/actions/mail.html")
public class ActionMail
extends ActionBase
implements Cloneable,
IAction {
    private static final Class<?> PKG = ActionMail.class;
    public static final String CONST_FILETYPE = "filetype";
    public static final String CONST_MAIL = "mail.";
    public static final String CONST_SPACES = "      ";
    public static final String CONST_SPACES_LONG = "         ";
    public static final String CONST_SERVER = "server";
    public static final String CONST_DESTINATION = "destination";
    private MailServerConnection connection;
    private Session session;
    @HopMetadataProperty
    private String server;
    @HopMetadataProperty
    private String destination;
    @HopMetadataProperty
    private String destinationCc;
    @HopMetadataProperty
    private String destinationBCc;
    @HopMetadataProperty(key="replyto")
    private String replyAddress;
    @HopMetadataProperty(key="replytoname")
    private String replyName;
    @HopMetadataProperty
    private String subject;
    @HopMetadataProperty(key="include_date")
    private boolean includeDate;
    @HopMetadataProperty(key="contact_persion")
    private String contactPerson;
    @HopMetadataProperty(key="contact_phone")
    private String contactPhone;
    @HopMetadataProperty
    private String comment;
    @HopMetadataProperty(key="include_files")
    private boolean includingFiles;
    @HopMetadataProperty(groupKey="fileTypes", key="fileType")
    private List<String> fileTypes;
    @HopMetadataProperty(key="zip_files")
    private boolean zipFiles;
    @HopMetadataProperty(key="zip_name")
    private String zipFilename;
    @HopMetadataProperty(key="use_auth")
    private boolean usingAuthentication;
    @HopMetadataProperty
    private boolean usexoauth2;
    @HopMetadataProperty(key="auth_user")
    private String authenticationUser;
    @HopMetadataProperty(key="auth_password")
    private String authenticationPassword;
    @HopMetadataProperty(key="only_comment")
    private boolean onlySendComment;
    @HopMetadataProperty(key="use_HTML")
    private boolean useHTML;
    @HopMetadataProperty(key="use_secure_auth")
    private boolean usingSecureAuthentication;
    @HopMetadataProperty(key="use_Priority")
    private boolean usePriority;
    @HopMetadataProperty(key="trusted_hosts")
    private String trustedHosts;
    @HopMetadataProperty(key="check_server_identity")
    private boolean checkServerIdentity;
    @HopMetadataProperty
    private String port;
    @HopMetadataProperty
    private String priority;
    @HopMetadataProperty
    private String importance;
    @HopMetadataProperty
    private String sensitivity;
    @HopMetadataProperty(key="secureconnectiontype")
    private String secureConnectionType;
    @HopMetadataProperty
    private String encoding;
    @HopMetadataProperty
    private String replyToAddresses;
    @HopMetadataProperty(key="embeddedimage", groupKey="embeddedimages")
    public List<MailEmbeddedImageField> embeddedimages;
    @HopMetadataProperty
    private String connectionName;

    public ActionMail(String n) {
        super(n, "");
    }

    public ActionMail() {
        this("");
    }

    public Object clone() {
        ActionMail je = (ActionMail)super.clone();
        this.fileTypes = je.fileTypes;
        this.embeddedimages = je.embeddedimages;
        return je;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result execute(Result result, int nr) {
        File masterZipfile = null;
        this.session = null;
        String protocol = "smtp";
        if (!StringUtils.isEmpty((String)this.connectionName)) {
            try {
                this.connection = (MailServerConnection)this.getMetadataProvider().getSerializer(MailServerConnection.class).load(this.connectionName);
                this.session = this.connection.getSession(this.getVariables());
            }
            catch (HopException e) {
                throw new RuntimeException("Mail server connection '" + this.connectionName + "' could not be found", e);
            }
        } else {
            Properties props = new Properties();
            if (Utils.isEmpty((CharSequence)this.server)) {
                this.logError(BaseMessages.getString(PKG, (String)"ActionMail.Error.HostNotSpecified", (String[])new String[0]));
                result.setNrErrors(1L);
                result.setResult(false);
                return result;
            }
            if (this.usingSecureAuthentication) {
                if (this.usexoauth2) {
                    props.put("mail.smtp.auth.mechanisms", "XOAUTH2");
                }
                if (this.secureConnectionType.equals("TLS")) {
                    props.put("mail.smtp.starttls.enable", "true");
                } else if (this.secureConnectionType.equals("TLS 1.2")) {
                    props.put("mail.smtp.starttls.enable", "true");
                    props.put("mail.smtp.ssl.protocols", "TLSv1.2");
                } else {
                    protocol = "smtps";
                    props.put("mail.smtps.quitwait", "false");
                }
                props.put("mail.smtp.ssl.checkServerIdentity", (Object)this.isCheckServerIdentity());
                if (!Utils.isEmpty((CharSequence)this.trustedHosts)) {
                    props.put("mail.smtp.ssl.trust", this.resolve(this.trustedHosts));
                }
            }
            props.put(CONST_MAIL + protocol + ".host", this.resolve(this.server));
            if (!Utils.isEmpty((CharSequence)this.port)) {
                props.put(CONST_MAIL + protocol + ".port", this.resolve(this.port));
            }
            if (this.isDebug()) {
                props.put("mail.debug", "true");
            }
            if (this.usingAuthentication) {
                props.put(CONST_MAIL + protocol + ".auth", "true");
            }
            this.session = Session.getInstance((Properties)props);
        }
        this.session.setDebug(this.isDebug());
        try {
            List resultFiles;
            WorkflowTracker workflowTracker;
            String realSubject;
            String realBCc;
            int i;
            InternetAddress[] address;
            Object senderAddress;
            MimeMessage msg = new MimeMessage(this.session);
            if (this.usePriority) {
                String priorityInt = "1";
                if (this.priority.equals("low")) {
                    priorityInt = "3";
                }
                if (this.priority.equals("normal")) {
                    priorityInt = "2";
                }
                msg.setHeader("X-Priority", priorityInt);
                msg.setHeader("Importance", this.importance);
                msg.setHeader("Sensitivity", this.sensitivity);
            }
            if (!Utils.isEmpty((CharSequence)(senderAddress = this.resolve(this.replyAddress)))) {
                String senderName = this.resolve(this.replyName);
                if (!Utils.isEmpty((CharSequence)senderName)) {
                    senderAddress = senderName + "<" + (String)senderAddress + ">";
                }
            } else {
                throw new MessagingException(BaseMessages.getString(PKG, (String)"ActionMail.Error.ReplyEmailNotFilled", (String[])new String[0]));
            }
            msg.setFrom((Address)new InternetAddress((String)senderAddress));
            String replyToAddress = this.resolve(this.replyToAddresses);
            if (!Utils.isEmpty((CharSequence)replyToAddress)) {
                String[] replyAddressList = this.resolve(replyToAddress).split(" ");
                address = new InternetAddress[replyAddressList.length];
                for (i = 0; i < replyAddressList.length; ++i) {
                    address[i] = new InternetAddress(replyAddressList[i]);
                }
                msg.setReplyTo((Address[])address);
            }
            String[] destinations = this.resolve(this.destination).split(" ");
            address = new InternetAddress[destinations.length];
            for (i = 0; i < destinations.length; ++i) {
                address[i] = new InternetAddress(destinations[i]);
            }
            msg.setRecipients(Message.RecipientType.TO, (Address[])address);
            String realCC = this.resolve(this.getDestinationCc());
            if (!Utils.isEmpty((CharSequence)realCC)) {
                String[] destinationsCc = realCC.split(" ");
                InternetAddress[] addressCc = new InternetAddress[destinationsCc.length];
                for (int i2 = 0; i2 < destinationsCc.length; ++i2) {
                    addressCc[i2] = new InternetAddress(destinationsCc[i2]);
                }
                msg.setRecipients(Message.RecipientType.CC, (Address[])addressCc);
            }
            if (!Utils.isEmpty((CharSequence)(realBCc = this.resolve(this.getDestinationBCc())))) {
                String[] destinationsBCc = realBCc.split(" ");
                InternetAddress[] addressBCc = new InternetAddress[destinationsBCc.length];
                for (int i3 = 0; i3 < destinationsBCc.length; ++i3) {
                    addressBCc[i3] = new InternetAddress(destinationsBCc[i3]);
                }
                msg.setRecipients(Message.RecipientType.BCC, (Address[])addressBCc);
            }
            if (!Utils.isEmpty((CharSequence)(realSubject = this.resolve(this.subject)))) {
                msg.setSubject(realSubject);
            }
            msg.setSentDate(new Date());
            StringBuilder messageText = new StringBuilder();
            String endRow = this.isUseHTML() ? "<br>" : Const.CR;
            String realComment = this.resolve(this.comment);
            if (!Utils.isEmpty((CharSequence)realComment)) {
                messageText.append(realComment).append(Const.CR).append(Const.CR);
            }
            if (!this.onlySendComment) {
                messageText.append(BaseMessages.getString(PKG, (String)"ActionMail.Log.Comment.Workflow", (String[])new String[0])).append(endRow);
                messageText.append("-----").append(endRow);
                messageText.append(BaseMessages.getString(PKG, (String)"ActionMail.Log.Comment.JobName", (String[])new String[0]) + "    : ").append(this.parentWorkflow.getWorkflowMeta().getName()).append(endRow);
                messageText.append(BaseMessages.getString(PKG, (String)"ActionMail.Log.Comment.Action", (String[])new String[0]) + "   : ").append(this.getName()).append(endRow);
                messageText.append(Const.CR);
            }
            if (this.includeDate) {
                messageText.append(endRow).append(BaseMessages.getString(PKG, (String)"ActionMail.Log.Comment.MsgDate", (String[])new String[0]) + ": ").append(XmlHandler.date2string((Date)new Date())).append(endRow).append(endRow);
            }
            if (!this.onlySendComment && result != null) {
                messageText.append(BaseMessages.getString(PKG, (String)"ActionMail.Log.Comment.PreviousResult", (String[])new String[0]) + ":").append(endRow);
                messageText.append("-----------------").append(endRow);
                messageText.append(BaseMessages.getString(PKG, (String)"ActionMail.Log.Comment.ActionNr", (String[])new String[0]) + "         : ").append(result.getEntryNr()).append(endRow);
                messageText.append(BaseMessages.getString(PKG, (String)"ActionMail.Log.Comment.Errors", (String[])new String[0]) + "               : ").append(result.getNrErrors()).append(endRow);
                messageText.append(BaseMessages.getString(PKG, (String)"ActionMail.Log.Comment.LinesRead", (String[])new String[0]) + "           : ").append(result.getNrLinesRead()).append(endRow);
                messageText.append(BaseMessages.getString(PKG, (String)"ActionMail.Log.Comment.LinesWritten", (String[])new String[0]) + "        : ").append(result.getNrLinesWritten()).append(endRow);
                messageText.append(BaseMessages.getString(PKG, (String)"ActionMail.Log.Comment.LinesInput", (String[])new String[0]) + "          : ").append(result.getNrLinesInput()).append(endRow);
                messageText.append(BaseMessages.getString(PKG, (String)"ActionMail.Log.Comment.LinesOutput", (String[])new String[0]) + "         : ").append(result.getNrLinesOutput()).append(endRow);
                messageText.append(BaseMessages.getString(PKG, (String)"ActionMail.Log.Comment.LinesUpdated", (String[])new String[0]) + "        : ").append(result.getNrLinesUpdated()).append(endRow);
                messageText.append(BaseMessages.getString(PKG, (String)"ActionMail.Log.Comment.LinesRejected", (String[])new String[0]) + "       : ").append(result.getNrLinesRejected()).append(endRow);
                messageText.append(BaseMessages.getString(PKG, (String)"ActionMail.Log.Comment.Status", (String[])new String[0]) + "  : ").append(result.getExitStatus()).append(endRow);
                messageText.append(BaseMessages.getString(PKG, (String)"ActionMail.Log.Comment.Result", (String[])new String[0]) + "               : ").append(result.getResult()).append(endRow);
                messageText.append(endRow);
            }
            if (!(this.onlySendComment || Utils.isEmpty((CharSequence)this.resolve(this.contactPerson)) && Utils.isEmpty((CharSequence)this.resolve(this.contactPhone)))) {
                messageText.append(BaseMessages.getString(PKG, (String)"ActionMail.Log.Comment.ContactInfo", (String[])new String[0]) + " :").append(endRow);
                messageText.append("---------------------").append(endRow);
                messageText.append(BaseMessages.getString(PKG, (String)"ActionMail.Log.Comment.PersonToContact", (String[])new String[0]) + " : ").append(this.resolve(this.contactPerson)).append(endRow);
                messageText.append(BaseMessages.getString(PKG, (String)"ActionMail.Log.Comment.Tel", (String[])new String[0]) + "  : ").append(this.resolve(this.contactPhone)).append(endRow);
                messageText.append(endRow);
            }
            if (!this.onlySendComment && (workflowTracker = this.parentWorkflow.getWorkflowTracker()) != null) {
                messageText.append(BaseMessages.getString(PKG, (String)"ActionMail.Log.Comment.PathToJobentry", (String[])new String[0]) + ":").append(endRow);
                messageText.append("------------------------").append(endRow);
                this.addBacktracking(workflowTracker, messageText);
                if (this.isUseHTML()) {
                    messageText.replace(0, messageText.length(), messageText.toString().replace(Const.CR, endRow));
                }
            }
            MimeMultipart parts = new MimeMultipart();
            MimeBodyPart part1 = new MimeBodyPart();
            int nrattachedFiles = 0;
            if (this.useHTML) {
                if (!Utils.isEmpty((CharSequence)this.getEncoding())) {
                    part1.setContent((Object)messageText.toString(), "text/html; charset=" + this.getEncoding());
                } else {
                    part1.setContent((Object)messageText.toString(), "text/html; charset=ISO-8859-1");
                }
            } else {
                part1.setText(messageText.toString());
            }
            parts.addBodyPart((BodyPart)part1);
            if (this.includingFiles && result != null && (resultFiles = result.getResultFilesList()) != null && !resultFiles.isEmpty()) {
                if (!this.zipFiles) {
                    for (Object resultFile : resultFiles) {
                        FileObject file = resultFile.getFile();
                        if (file == null || !file.exists()) continue;
                        found = false;
                        for (String fileTypeField : this.fileTypes) {
                            if (!fileTypeField.equals(resultFile.getTypeDesc())) continue;
                            found = true;
                        }
                        if (!found) continue;
                        MimeBodyPart files = new MimeBodyPart();
                        URLDataSource fds = new URLDataSource(file.getURL());
                        files.setDataHandler(new DataHandler((DataSource)fds));
                        files.setFileName(file.getName().getBaseName());
                        files.addHeader("Content-Transfer-Encoding", "base64");
                        parts.addBodyPart((BodyPart)files);
                        ++nrattachedFiles;
                        this.logBasic("Added file '" + fds.getName() + "' to the mail message.");
                    }
                } else {
                    masterZipfile = new File(System.getProperty("java.io.tmpdir") + Const.FILE_SEPARATOR + this.resolve(this.zipFilename));
                    ZipOutputStream zipOutputStream = null;
                    try {
                        zipOutputStream = new ZipOutputStream(new FileOutputStream(masterZipfile));
                        for (ResultFile resultFile : resultFiles) {
                            found = false;
                            for (int i4 = 0; i4 < this.fileTypes.size(); ++i4) {
                                if (!this.fileTypes.get(i4).equals(resultFile.getTypeDesc())) continue;
                                found = true;
                            }
                            if (!found) continue;
                            FileObject file = resultFile.getFile();
                            ZipEntry zipEntry = new ZipEntry(file.getName().getBaseName());
                            zipOutputStream.putNextEntry(zipEntry);
                            try (BufferedInputStream inputStream = new BufferedInputStream(HopVfs.getInputStream((FileObject)file));){
                                int c;
                                while ((c = inputStream.read()) >= 0) {
                                    zipOutputStream.write(c);
                                }
                            }
                            zipOutputStream.closeEntry();
                            ++nrattachedFiles;
                            this.logBasic("Added file '" + file.getName().getURI() + "' to the mail message in a zip archive.");
                        }
                    }
                    catch (Exception e) {
                        this.logError("Error zipping attachement files into file [" + masterZipfile.getPath() + "] : " + e.toString());
                        this.logError(Const.getStackTracker((Throwable)e));
                        result.setNrErrors(1L);
                    }
                    finally {
                        if (zipOutputStream != null) {
                            try {
                                zipOutputStream.finish();
                                zipOutputStream.close();
                            }
                            catch (IOException e) {
                                this.logError("Unable to close attachement zip file archive : " + e.toString());
                                this.logError(Const.getStackTracker((Throwable)e));
                                result.setNrErrors(1L);
                            }
                        }
                    }
                    if (result.getNrErrors() == 0L) {
                        MimeBodyPart files = new MimeBodyPart();
                        FileDataSource fds = new FileDataSource(masterZipfile);
                        files.setDataHandler(new DataHandler((DataSource)fds));
                        files.setFileName(fds.getName());
                        parts.addBodyPart((BodyPart)files);
                    }
                }
            }
            int nrEmbeddedImages = 0;
            if (this.embeddedimages != null && this.embeddedimages.size() > 0) {
                FileObject imageFile = null;
                for (int i5 = 0; i5 < this.embeddedimages.size(); ++i5) {
                    String realImageFile = this.resolve(this.embeddedimages.get(i5).getEmbeddedimage());
                    String realcontenID = this.resolve(this.embeddedimages.get(i5).getContentId());
                    if (messageText.indexOf("cid:" + realcontenID) < 0) {
                        if (!this.isDebug()) continue;
                        this.logDebug("Image [" + realImageFile + "] is not used in message body!");
                        continue;
                    }
                    try {
                        boolean found = false;
                        imageFile = HopVfs.getFileObject((String)realImageFile);
                        if (imageFile.exists() && imageFile.getType() == FileType.FILE) {
                            found = true;
                        } else {
                            this.logError("We can not find [" + realImageFile + "] or it is not a file");
                        }
                        if (!found) continue;
                        MimeBodyPart messageBodyPart = new MimeBodyPart();
                        URLDataSource fds = new URLDataSource(imageFile.getURL());
                        messageBodyPart.setDataHandler(new DataHandler((DataSource)fds));
                        messageBodyPart.setHeader("Content-ID", "<" + realcontenID + ">");
                        parts.addBodyPart((BodyPart)messageBodyPart);
                        ++nrEmbeddedImages;
                        this.logBasic("Image '" + fds.getName() + "' was embedded in message.");
                        continue;
                    }
                    catch (Exception e) {
                        this.logError("Error embedding image [" + realImageFile + "] in message : " + e.toString());
                        this.logError(Const.getStackTracker((Throwable)e));
                        result.setNrErrors(1L);
                        continue;
                    }
                    finally {
                        if (imageFile != null) {
                            try {
                                imageFile.close();
                            }
                            catch (Exception exception) {}
                        }
                    }
                }
            }
            if (nrEmbeddedImages > 0 && nrattachedFiles == 0) {
                parts.setSubType("related");
            }
            msg.setContent((Multipart)parts);
            try (Transport transport = null;){
                if (!StringUtils.isEmpty((String)this.connectionName)) {
                    transport = this.connection.getTransport();
                } else {
                    transport = this.session.getTransport(protocol);
                    String authPass = this.getPassword(this.authenticationPassword);
                    if (this.usingAuthentication) {
                        if (!Utils.isEmpty((CharSequence)this.port)) {
                            transport.connect(this.resolve(Const.NVL((String)this.server, (String)"")), Integer.parseInt(this.resolve(Const.NVL((String)this.port, (String)""))), this.resolve(Const.NVL((String)this.authenticationUser, (String)"")), authPass);
                        } else {
                            transport.connect(this.resolve(Const.NVL((String)this.server, (String)"")), this.resolve(Const.NVL((String)this.authenticationUser, (String)"")), authPass);
                        }
                    } else {
                        transport.connect();
                    }
                }
                transport.sendMessage((Message)msg, msg.getAllRecipients());
            }
        }
        catch (IOException e) {
            this.logError("Problem while sending message: " + e.toString());
            result.setNrErrors(1L);
        }
        catch (MessagingException mex) {
            this.logError("Problem while sending message: " + mex.toString());
            result.setNrErrors(1L);
            Throwable ex = mex;
            do {
                if (ex instanceof SendFailedException) {
                    Address[] validSent;
                    Address[] validUnsent;
                    SendFailedException sfex = (SendFailedException)ex;
                    Address[] invalid = sfex.getInvalidAddresses();
                    if (invalid != null) {
                        this.logError("    ** Invalid Addresses");
                        for (int i = 0; i < invalid.length; ++i) {
                            this.logError(CONST_SPACES_LONG + String.valueOf(invalid[i]));
                            result.setNrErrors(1L);
                        }
                    }
                    if ((validUnsent = sfex.getValidUnsentAddresses()) != null) {
                        this.logError("    ** ValidUnsent Addresses");
                        for (int i = 0; i < validUnsent.length; ++i) {
                            this.logError(CONST_SPACES_LONG + String.valueOf(validUnsent[i]));
                            result.setNrErrors(1L);
                        }
                    }
                    if ((validSent = sfex.getValidSentAddresses()) != null) {
                        for (int i = 0; i < validSent.length; ++i) {
                            this.logError(CONST_SPACES_LONG + String.valueOf(validSent[i]));
                            result.setNrErrors(1L);
                        }
                    }
                }
                if (ex instanceof MessagingException) {
                    MessagingException messagingException = ex;
                    ex = messagingException.getNextException();
                    continue;
                }
                ex = null;
            } while (ex != null);
        }
        finally {
            if (masterZipfile != null && masterZipfile.exists()) {
                masterZipfile.delete();
            }
        }
        if (result.getNrErrors() > 0L) {
            result.setResult(false);
        } else {
            result.setResult(true);
        }
        return result;
    }

    private void addBacktracking(WorkflowTracker workflowTracker, StringBuilder messageText) {
        this.addBacktracking(workflowTracker, messageText, 0);
    }

    private void addBacktracking(WorkflowTracker workflowTracker, StringBuilder messageText, int level) {
        int nr = workflowTracker.nrWorkflowTrackers();
        messageText.append(Const.rightPad((String)" ", (int)(level * 2)));
        messageText.append(Const.NVL((String)workflowTracker.getWorkflowName(), (String)"-"));
        ActionResult jer = workflowTracker.getActionResult();
        if (jer != null) {
            messageText.append(" : ");
            if (jer.getActionName() != null) {
                messageText.append(" : ");
                messageText.append(jer.getActionName());
            }
            if (jer.getResult() != null) {
                messageText.append(" : ");
                messageText.append("[" + jer.getResult().toString() + "]");
            }
            if (jer.getReason() != null) {
                messageText.append(" : ");
                messageText.append(jer.getReason());
            }
            if (jer.getComment() != null) {
                messageText.append(" : ");
                messageText.append(jer.getComment());
            }
            if (jer.getLogDate() != null) {
                messageText.append(" (");
                messageText.append(XmlHandler.date2string((Date)jer.getLogDate()));
                messageText.append(')');
            }
        }
        messageText.append(Const.CR);
        for (int i = 0; i < nr; ++i) {
            WorkflowTracker jt = workflowTracker.getWorkflowTracker(i);
            this.addBacktracking(jt, messageText, level + 1);
        }
    }

    public boolean isEvaluation() {
        return true;
    }

    public boolean isUnconditional() {
        return true;
    }

    public List<ResourceReference> getResourceDependencies(IVariables variables, WorkflowMeta workflowMeta) {
        List references = super.getResourceDependencies(variables, workflowMeta);
        String realServername = this.resolve(this.server);
        ResourceReference reference = new ResourceReference((IResourceHolder)this);
        reference.getEntries().add(new ResourceEntry(realServername, ResourceEntry.ResourceType.SERVER));
        references.add(reference);
        return references;
    }

    public void check(List<ICheckResult> remarks, WorkflowMeta workflowMeta, IVariables variables, IHopMetadataProvider metadataProvider) {
        ActionValidatorUtils.andValidator().validate((ICheckResultSource)this, CONST_SERVER, remarks, AndValidator.putValidators((IActionValidator[])new IActionValidator[]{ActionValidatorUtils.notBlankValidator()}));
        ActionValidatorUtils.andValidator().validate((ICheckResultSource)this, "replyAddress", remarks, AndValidator.putValidators((IActionValidator[])new IActionValidator[]{ActionValidatorUtils.notBlankValidator(), ActionValidatorUtils.emailValidator()}));
        ActionValidatorUtils.andValidator().validate((ICheckResultSource)this, CONST_DESTINATION, remarks, AndValidator.putValidators((IActionValidator[])new IActionValidator[]{ActionValidatorUtils.notBlankValidator()}));
        if (this.usingAuthentication) {
            ActionValidatorUtils.andValidator().validate((ICheckResultSource)this, "authenticationUser", remarks, AndValidator.putValidators((IActionValidator[])new IActionValidator[]{ActionValidatorUtils.notBlankValidator()}));
            ActionValidatorUtils.andValidator().validate((ICheckResultSource)this, "authenticationPassword", remarks, AndValidator.putValidators((IActionValidator[])new IActionValidator[]{ActionValidatorUtils.notNullValidator()}));
        }
        ActionValidatorUtils.andValidator().validate((ICheckResultSource)this, "port", remarks, AndValidator.putValidators((IActionValidator[])new IActionValidator[]{ActionValidatorUtils.integerValidator()}));
    }

    public String getPassword(String authPassword) {
        return Encr.decryptPasswordOptionallyEncrypted((String)this.resolve(Const.NVL((String)authPassword, (String)"")));
    }

    @Generated
    public MailServerConnection getConnection() {
        return this.connection;
    }

    @Generated
    public Session getSession() {
        return this.session;
    }

    @Generated
    public String getServer() {
        return this.server;
    }

    @Generated
    public String getDestination() {
        return this.destination;
    }

    @Generated
    public String getDestinationCc() {
        return this.destinationCc;
    }

    @Generated
    public String getDestinationBCc() {
        return this.destinationBCc;
    }

    @Generated
    public String getReplyAddress() {
        return this.replyAddress;
    }

    @Generated
    public String getReplyName() {
        return this.replyName;
    }

    @Generated
    public String getSubject() {
        return this.subject;
    }

    @Generated
    public boolean isIncludeDate() {
        return this.includeDate;
    }

    @Generated
    public String getContactPerson() {
        return this.contactPerson;
    }

    @Generated
    public String getContactPhone() {
        return this.contactPhone;
    }

    @Generated
    public String getComment() {
        return this.comment;
    }

    @Generated
    public boolean isIncludingFiles() {
        return this.includingFiles;
    }

    @Generated
    public List<String> getFileTypes() {
        return this.fileTypes;
    }

    @Generated
    public boolean isZipFiles() {
        return this.zipFiles;
    }

    @Generated
    public String getZipFilename() {
        return this.zipFilename;
    }

    @Generated
    public boolean isUsingAuthentication() {
        return this.usingAuthentication;
    }

    @Generated
    public boolean isUsexoauth2() {
        return this.usexoauth2;
    }

    @Generated
    public String getAuthenticationUser() {
        return this.authenticationUser;
    }

    @Generated
    public String getAuthenticationPassword() {
        return this.authenticationPassword;
    }

    @Generated
    public boolean isOnlySendComment() {
        return this.onlySendComment;
    }

    @Generated
    public boolean isUseHTML() {
        return this.useHTML;
    }

    @Generated
    public boolean isUsingSecureAuthentication() {
        return this.usingSecureAuthentication;
    }

    @Generated
    public boolean isUsePriority() {
        return this.usePriority;
    }

    @Generated
    public String getTrustedHosts() {
        return this.trustedHosts;
    }

    @Generated
    public boolean isCheckServerIdentity() {
        return this.checkServerIdentity;
    }

    @Generated
    public String getPort() {
        return this.port;
    }

    @Generated
    public String getPriority() {
        return this.priority;
    }

    @Generated
    public String getImportance() {
        return this.importance;
    }

    @Generated
    public String getSensitivity() {
        return this.sensitivity;
    }

    @Generated
    public String getSecureConnectionType() {
        return this.secureConnectionType;
    }

    @Generated
    public String getEncoding() {
        return this.encoding;
    }

    @Generated
    public String getReplyToAddresses() {
        return this.replyToAddresses;
    }

    @Generated
    public List<MailEmbeddedImageField> getEmbeddedimages() {
        return this.embeddedimages;
    }

    @Generated
    public String getConnectionName() {
        return this.connectionName;
    }

    @Generated
    public void setConnection(MailServerConnection connection) {
        this.connection = connection;
    }

    @Generated
    public void setSession(Session session) {
        this.session = session;
    }

    @Generated
    public void setServer(String server) {
        this.server = server;
    }

    @Generated
    public void setDestination(String destination) {
        this.destination = destination;
    }

    @Generated
    public void setDestinationCc(String destinationCc) {
        this.destinationCc = destinationCc;
    }

    @Generated
    public void setDestinationBCc(String destinationBCc) {
        this.destinationBCc = destinationBCc;
    }

    @Generated
    public void setReplyAddress(String replyAddress) {
        this.replyAddress = replyAddress;
    }

    @Generated
    public void setReplyName(String replyName) {
        this.replyName = replyName;
    }

    @Generated
    public void setSubject(String subject) {
        this.subject = subject;
    }

    @Generated
    public void setIncludeDate(boolean includeDate) {
        this.includeDate = includeDate;
    }

    @Generated
    public void setContactPerson(String contactPerson) {
        this.contactPerson = contactPerson;
    }

    @Generated
    public void setContactPhone(String contactPhone) {
        this.contactPhone = contactPhone;
    }

    @Generated
    public void setComment(String comment) {
        this.comment = comment;
    }

    @Generated
    public void setIncludingFiles(boolean includingFiles) {
        this.includingFiles = includingFiles;
    }

    @Generated
    public void setFileTypes(List<String> fileTypes) {
        this.fileTypes = fileTypes;
    }

    @Generated
    public void setZipFiles(boolean zipFiles) {
        this.zipFiles = zipFiles;
    }

    @Generated
    public void setZipFilename(String zipFilename) {
        this.zipFilename = zipFilename;
    }

    @Generated
    public void setUsingAuthentication(boolean usingAuthentication) {
        this.usingAuthentication = usingAuthentication;
    }

    @Generated
    public void setUsexoauth2(boolean usexoauth2) {
        this.usexoauth2 = usexoauth2;
    }

    @Generated
    public void setAuthenticationUser(String authenticationUser) {
        this.authenticationUser = authenticationUser;
    }

    @Generated
    public void setAuthenticationPassword(String authenticationPassword) {
        this.authenticationPassword = authenticationPassword;
    }

    @Generated
    public void setOnlySendComment(boolean onlySendComment) {
        this.onlySendComment = onlySendComment;
    }

    @Generated
    public void setUseHTML(boolean useHTML) {
        this.useHTML = useHTML;
    }

    @Generated
    public void setUsingSecureAuthentication(boolean usingSecureAuthentication) {
        this.usingSecureAuthentication = usingSecureAuthentication;
    }

    @Generated
    public void setUsePriority(boolean usePriority) {
        this.usePriority = usePriority;
    }

    @Generated
    public void setTrustedHosts(String trustedHosts) {
        this.trustedHosts = trustedHosts;
    }

    @Generated
    public void setCheckServerIdentity(boolean checkServerIdentity) {
        this.checkServerIdentity = checkServerIdentity;
    }

    @Generated
    public void setPort(String port) {
        this.port = port;
    }

    @Generated
    public void setPriority(String priority) {
        this.priority = priority;
    }

    @Generated
    public void setImportance(String importance) {
        this.importance = importance;
    }

    @Generated
    public void setSensitivity(String sensitivity) {
        this.sensitivity = sensitivity;
    }

    @Generated
    public void setSecureConnectionType(String secureConnectionType) {
        this.secureConnectionType = secureConnectionType;
    }

    @Generated
    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    @Generated
    public void setReplyToAddresses(String replyToAddresses) {
        this.replyToAddresses = replyToAddresses;
    }

    @Generated
    public void setEmbeddedimages(List<MailEmbeddedImageField> embeddedimages) {
        this.embeddedimages = embeddedimages;
    }

    @Generated
    public void setConnectionName(String connectionName) {
        this.connectionName = connectionName;
    }
}

