/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.EncryptionObject;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.FileDataObject;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.JCIDObject;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.ObjectGroupDataElementData;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.ObjectGroupObjectBLOBDataDeclaration;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.ObjectGroupObjectData;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.ObjectGroupObjectDataBLOBReference;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.ObjectGroupObjectDeclare;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.PropertySetObject;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.RevisionStoreObject;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.basic.ExGuid;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.util.ByteUtil;

public class RevisionStoreObjectGroup {
    public ExGuid objectGroupID;
    public List<RevisionStoreObject> objects = new ArrayList<RevisionStoreObject>();
    public List<EncryptionObject> encryptionObjects = new ArrayList<EncryptionObject>();

    public RevisionStoreObjectGroup(ExGuid objectGroupId) {
        this.objectGroupID = objectGroupId;
    }

    public static RevisionStoreObjectGroup createInstance(ExGuid objectGroupId, ObjectGroupDataElementData dataObject, boolean isEncryption) throws IOException {
        RevisionStoreObjectGroup objectGroup = new RevisionStoreObjectGroup(objectGroupId);
        HashMap<ExGuid, RevisionStoreObject> objectDict = new HashMap<ExGuid, RevisionStoreObject>();
        if (!isEncryption) {
            int i;
            RevisionStoreObject revisionObject = null;
            for (i = 0; i < dataObject.objectGroupDeclarations.objectDeclarationList.size(); ++i) {
                ObjectGroupObjectDeclare objectDeclaration = dataObject.objectGroupDeclarations.objectDeclarationList.get(i);
                ObjectGroupObjectData objectData = dataObject.objectGroupData.objectGroupObjectDataList.get(i);
                if (!objectDict.containsKey(objectDeclaration.objectExtendedGUID)) {
                    revisionObject = new RevisionStoreObject();
                    revisionObject.objectGroupID = objectGroupId;
                    revisionObject.objectID = objectDeclaration.objectExtendedGUID;
                    objectDict.put(objectDeclaration.objectExtendedGUID, revisionObject);
                } else {
                    revisionObject = (RevisionStoreObject)objectDict.get(objectDeclaration.objectExtendedGUID);
                }
                if (objectDeclaration.objectPartitionID.getDecodedValue() == 4L) {
                    revisionObject.jcid = new JCIDObject(objectDeclaration, objectData);
                    continue;
                }
                if (objectDeclaration.objectPartitionID.getDecodedValue() != 1L) continue;
                revisionObject.propertySet = new PropertySetObject(objectDeclaration, objectData);
                if (revisionObject.jcid.jcid.isFileData == 0) continue;
                revisionObject.referencedObjectID = objectData.objectExGUIDArray;
                revisionObject.referencedObjectSpacesID = objectData.cellIDArray;
            }
            for (i = 0; i < dataObject.objectGroupDeclarations.objectGroupObjectBLOBDataDeclarationList.size(); ++i) {
                ObjectGroupObjectBLOBDataDeclaration objectGroupObjectBLOBDataDeclaration = dataObject.objectGroupDeclarations.objectGroupObjectBLOBDataDeclarationList.get(i);
                ObjectGroupObjectDataBLOBReference objectGroupObjectDataBLOBReference = dataObject.objectGroupData.objectGroupObjectDataBLOBReferenceList.get(i);
                if (!objectDict.containsKey(objectGroupObjectBLOBDataDeclaration.objectExGUID)) {
                    revisionObject = new RevisionStoreObject();
                    objectDict.put(objectGroupObjectBLOBDataDeclaration.objectExGUID, revisionObject);
                } else {
                    revisionObject = (RevisionStoreObject)objectDict.get(objectGroupObjectBLOBDataDeclaration.objectExGUID);
                }
                if (objectGroupObjectBLOBDataDeclaration.objectPartitionID.getDecodedValue() != 2L) continue;
                revisionObject.fileDataObject = new FileDataObject();
                revisionObject.fileDataObject.objectDataBLOBDeclaration = objectGroupObjectBLOBDataDeclaration;
                revisionObject.fileDataObject.objectDataBLOBReference = objectGroupObjectDataBLOBReference;
            }
            objectGroup.objects.addAll(objectDict.values());
        } else {
            for (int i = 0; i < dataObject.objectGroupDeclarations.objectDeclarationList.size(); ++i) {
                ObjectGroupObjectDeclare objectDeclaration = dataObject.objectGroupDeclarations.objectDeclarationList.get(i);
                ObjectGroupObjectData objectData = dataObject.objectGroupData.objectGroupObjectDataList.get(i);
                if (objectDeclaration.objectPartitionID.getDecodedValue() != 1L) continue;
                EncryptionObject encrypObject = new EncryptionObject();
                encrypObject.objectDeclaration = objectDeclaration;
                encrypObject.objectData = ByteUtil.toByteArray(objectData.data.content);
                objectGroup.encryptionObjects.add(encrypObject);
            }
        }
        return objectGroup;
    }
}

