/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.Converter;
import com.ibm.as400.access.ErrorCodeParameter;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.IntegerHashtable;
import com.ibm.as400.access.Job;
import com.ibm.as400.access.JobEnumeration;
import com.ibm.as400.access.ListUtilities;
import com.ibm.as400.access.ObjectDoesNotExistException;
import com.ibm.as400.access.ProgramCall;
import com.ibm.as400.access.ProgramParameter;
import com.ibm.as400.access.QSYSObjectPathName;
import com.ibm.as400.access.Trace;
import com.ibm.as400.access.Tracker;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;

public class JobList
implements Serializable {
    static final long serialVersionUID = 5L;
    public static final String ALL = "*ALL";
    public static final int SELECTION_JOB_NAME = 1;
    public static final String SELECTION_JOB_NAME_ALL = "*ALL";
    public static final String SELECTION_JOB_NAME_CURRENT = "*CURRENT";
    public static final String SELECTION_JOB_NAME_ONLY = "*";
    public static final int SELECTION_USER_NAME = 2;
    public static final String SELECTION_USER_NAME_ALL = "*ALL";
    public static final String SELECTION_USER_NAME_CURRENT = "*CURRENT";
    public static final int SELECTION_JOB_NUMBER = 3;
    public static final String SELECTION_JOB_NUMBER_ALL = "*ALL";
    public static final int SELECTION_JOB_TYPE = 4;
    public static final String SELECTION_JOB_TYPE_ALL = "*";
    public static final int SELECTION_PRIMARY_JOB_STATUS_ACTIVE = 5;
    public static final int SELECTION_PRIMARY_JOB_STATUS_JOBQ = 6;
    public static final int SELECTION_PRIMARY_JOB_STATUS_OUTQ = 7;
    public static final int SELECTION_ACTIVE_JOB_STATUS = 8;
    public static final int SELECTION_JOB_QUEUE_STATUS_SCHEDULE = 9;
    public static final int SELECTION_JOB_QUEUE_STATUS_HELD = 10;
    public static final int SELECTION_JOB_QUEUE_STATUS_READY = 11;
    public static final int SELECTION_JOB_QUEUE = 12;
    public static final int SELECTION_INITIAL_USER = 13;
    public static final int SELECTION_SERVER_TYPE = 14;
    public static final String SELECTION_SERVER_TYPE_ALL = "*ALL";
    public static final String SELECTION_SERVER_TYPE_BLANK = "*BLANK";
    public static final int SELECTION_JOB_TYPE_ENHANCED = 17;
    public static final Integer SELECTION_JOB_TYPE_ENHANCED_ALL_BATCH = 200;
    public static final Integer SELECTION_JOB_TYPE_ENHANCED_ALL_INTERACTIVE = 900;
    public static final Integer SELECTION_JOB_TYPE_ENHANCED_ALL_PRESTART = 1600;
    static final IntegerHashtable sortableKeys_ = new IntegerHashtable();
    private AS400 system_;
    private transient PropertyChangeSupport propertyChangeListeners_ = null;
    private transient VetoableChangeSupport vetoableChangeListeners_ = null;
    private String selectionJobName_ = "*ALL";
    private String selectionUserName_ = "*ALL";
    private String selectionJobNumber_ = "*ALL";
    private String selectionJobType_ = "*";
    private boolean selectActiveJobs_ = true;
    private boolean selectJobQueueJobs_ = true;
    private boolean selectOutQueueJobs_ = true;
    private String[] activeStatuses_ = new String[1];
    private int currentActiveStatus_ = 0;
    private boolean selectHeldJobs_ = true;
    private boolean selectScheduledJobs_ = true;
    private boolean selectReadyJobs_ = true;
    private String[] jobQueues_ = new String[1];
    private int currentJobQueue_ = 0;
    private String[] initialUsers_ = new String[1];
    private int currentInitialUser_ = 0;
    private String[] serverTypes_ = new String[1];
    private int currentServerType_ = 0;
    private int[] enhancedJobTypes_ = new int[1];
    private int currentEnhancedJobType_ = 0;
    private int length_;
    private int recordLength_;
    private byte[] handle_;
    private boolean closeHandle_ = false;
    private int numKeysReturned_;
    private int[] keyFieldsReturned_;
    private char[] keyTypesReturned_;
    private int[] keyLengthsReturned_;
    private int[] keyOffsetsReturned_;
    private int currentKey_ = 0;
    private int[] keys_ = new int[1];
    private int currentSortKey_ = 0;
    private int[] sortKeys_ = new int[1];
    private boolean[] sortOrders_ = new boolean[1];
    private Vector<Tracker> trackers_;

    public JobList() {
        if (Trace.traceOn_) {
            Trace.log(1, "Constructing JobList object.");
        }
    }

    public JobList(AS400 system) {
        if (Trace.traceOn_) {
            Trace.log(1, "Constructing JobList object, system: " + system);
        }
        if (system == null) {
            Trace.log(2, "Parameter 'system' is null.");
            throw new NullPointerException("system");
        }
        this.system_ = system;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addJobAttributeToRetrieve(int attribute) {
        if (attribute < 101) {
            Trace.log(2, "Value of parameter 'attribute' is not valid: " + attribute);
            throw new ExtendedIllegalArgumentException("attribute", 2);
        }
        switch (attribute) {
            case 11000: 
            case 11001: 
            case 11002: 
            case 11003: 
            case 11004: 
            case 11005: 
            case 11006: 
            case 11007: {
                return;
            }
            case 314: 
            case 315: 
            case 316: 
            case 317: 
            case 414: 
            case 416: 
            case 417: 
            case 904: 
            case 905: 
            case 1609: 
            case 10000: 
            case 10001: 
            case 10002: 
            case 10003: 
            case 10004: 
            case 10005: 
            case 10006: 
            case 10007: 
            case 10008: {
                Trace.log(2, "Value of parameter 'attribute' is not valid: " + attribute);
                throw new ExtendedIllegalArgumentException("attribute", 2);
            }
            case 1920: 
            case 1921: {
                attribute = 403;
                break;
            }
            case 21011: 
            case 21012: 
            case 21013: 
            case 21014: {
                attribute = 2101;
                break;
            }
        }
        if (this.currentKey_ >= this.keys_.length) {
            int[] temp = this.keys_;
            this.keys_ = new int[temp.length * 2];
            System.arraycopy(temp, 0, this.keys_, 0, temp.length);
        }
        this.keys_[this.currentKey_++] = attribute;
        JobList jobList = this;
        synchronized (jobList) {
            if (this.handle_ != null) {
                this.closeHandle_ = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addJobAttributeToSortOn(int attribute, boolean sortOrder) {
        if (attribute < 101) {
            Trace.log(2, "Value of parameter 'attribute' is not valid: " + attribute);
            throw new ExtendedIllegalArgumentException("attribute", 2);
        }
        switch (attribute) {
            case 314: 
            case 315: 
            case 316: 
            case 317: 
            case 414: 
            case 416: 
            case 417: 
            case 904: 
            case 905: 
            case 1609: 
            case 10000: 
            case 10001: 
            case 10002: 
            case 10003: 
            case 10004: 
            case 10005: 
            case 10006: 
            case 10007: 
            case 10008: {
                Trace.log(2, "Value of parameter 'attribute' is not valid: " + attribute);
                throw new ExtendedIllegalArgumentException("attribute", 2);
            }
        }
        if (this.currentSortKey_ >= this.sortKeys_.length) {
            int[] temp = this.sortKeys_;
            this.sortKeys_ = new int[temp.length * 2];
            System.arraycopy(temp, 0, this.sortKeys_, 0, temp.length);
            boolean[] tempSort = this.sortOrders_;
            this.sortOrders_ = new boolean[tempSort.length * 2];
            System.arraycopy(tempSort, 0, this.sortOrders_, 0, tempSort.length);
        }
        this.sortKeys_[this.currentSortKey_] = attribute;
        this.sortOrders_[this.currentSortKey_++] = sortOrder;
        JobList jobList = this;
        synchronized (jobList) {
            if (this.handle_ != null) {
                this.closeHandle_ = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addJobSelectionCriteria(int selectionType, Object selectionValue) throws PropertyVetoException {
        if (selectionValue == null) {
            Trace.log(2, "Parameter 'selectionValue' is null.");
            throw new NullPointerException("selectionValue");
        }
        switch (selectionType) {
            case 1: {
                this.setName((String)selectionValue);
                break;
            }
            case 2: {
                this.setUser((String)selectionValue);
                break;
            }
            case 3: {
                this.setNumber((String)selectionValue);
                break;
            }
            case 4: {
                this.selectionJobType_ = ((String)selectionValue).toUpperCase();
                break;
            }
            case 5: {
                this.selectActiveJobs_ = (Boolean)selectionValue;
                break;
            }
            case 6: {
                this.selectJobQueueJobs_ = (Boolean)selectionValue;
                break;
            }
            case 7: {
                this.selectOutQueueJobs_ = (Boolean)selectionValue;
                break;
            }
            case 8: {
                String status = ((String)selectionValue).toUpperCase();
                if (this.currentActiveStatus_ >= this.activeStatuses_.length) {
                    String[] temp = this.activeStatuses_;
                    this.activeStatuses_ = new String[temp.length * 2];
                    System.arraycopy(temp, 0, this.activeStatuses_, 0, temp.length);
                }
                this.activeStatuses_[this.currentActiveStatus_++] = status;
                break;
            }
            case 9: {
                this.selectScheduledJobs_ = (Boolean)selectionValue;
                break;
            }
            case 10: {
                this.selectHeldJobs_ = (Boolean)selectionValue;
                break;
            }
            case 11: {
                this.selectReadyJobs_ = (Boolean)selectionValue;
                break;
            }
            case 12: {
                String queue = (String)selectionValue;
                QSYSObjectPathName path = new QSYSObjectPathName(queue);
                StringBuffer buf = new StringBuffer();
                String name = path.getObjectName();
                buf.append(name);
                for (int i = name.length(); i < 10; ++i) {
                    buf.append(' ');
                }
                String lib = path.getLibraryName();
                buf.append(lib);
                if (this.currentJobQueue_ >= this.jobQueues_.length) {
                    String[] temp = this.jobQueues_;
                    this.jobQueues_ = new String[temp.length * 2];
                    System.arraycopy(temp, 0, this.jobQueues_, 0, temp.length);
                }
                this.jobQueues_[this.currentJobQueue_++] = buf.toString();
                break;
            }
            case 13: {
                String profile = ((String)selectionValue).toUpperCase();
                if (this.currentInitialUser_ >= this.initialUsers_.length) {
                    String[] temp = this.initialUsers_;
                    this.initialUsers_ = new String[temp.length * 2];
                    System.arraycopy(temp, 0, this.initialUsers_, 0, temp.length);
                }
                this.initialUsers_[this.currentInitialUser_++] = profile;
                break;
            }
            case 14: {
                String type = ((String)selectionValue).toUpperCase();
                if (this.currentServerType_ >= this.serverTypes_.length) {
                    String[] temp = this.serverTypes_;
                    this.serverTypes_ = new String[temp.length * 2];
                    System.arraycopy(temp, 0, this.serverTypes_, 0, temp.length);
                }
                this.serverTypes_[this.currentServerType_++] = type;
                break;
            }
            case 17: {
                int val = (Integer)selectionValue;
                if (this.currentEnhancedJobType_ >= this.enhancedJobTypes_.length) {
                    int[] temp = this.enhancedJobTypes_;
                    this.enhancedJobTypes_ = new int[temp.length * 2];
                    System.arraycopy(temp, 0, this.enhancedJobTypes_, 0, temp.length);
                }
                this.enhancedJobTypes_[this.currentEnhancedJobType_++] = val;
                break;
            }
            default: {
                Trace.log(2, "Value of parameter 'selectionType' is not valid: " + selectionType);
                throw new ExtendedIllegalArgumentException("selectionType", 2);
            }
        }
        JobList jobList = this;
        synchronized (jobList) {
            if (this.handle_ != null) {
                this.closeHandle_ = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearJobAttributesToRetrieve() {
        this.currentKey_ = 0;
        this.keys_ = new int[1];
        JobList jobList = this;
        synchronized (jobList) {
            if (this.handle_ != null) {
                this.closeHandle_ = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearJobAttributesToSortOn() {
        this.currentSortKey_ = 0;
        this.sortKeys_ = new int[1];
        this.sortOrders_ = new boolean[1];
        JobList jobList = this;
        synchronized (jobList) {
            if (this.handle_ != null) {
                this.closeHandle_ = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearJobSelectionCriteria() throws PropertyVetoException {
        this.setName("*ALL");
        this.setUser("*ALL");
        this.setNumber("*ALL");
        this.selectionJobType_ = "*";
        this.selectActiveJobs_ = true;
        this.selectJobQueueJobs_ = true;
        this.selectOutQueueJobs_ = true;
        this.activeStatuses_ = new String[1];
        this.currentActiveStatus_ = 0;
        this.selectHeldJobs_ = true;
        this.selectScheduledJobs_ = true;
        this.selectReadyJobs_ = true;
        this.jobQueues_ = new String[1];
        this.currentJobQueue_ = 0;
        this.initialUsers_ = new String[1];
        this.currentInitialUser_ = 0;
        this.serverTypes_ = new String[1];
        this.currentServerType_ = 0;
        this.enhancedJobTypes_ = new int[1];
        this.currentEnhancedJobType_ = 0;
        JobList jobList = this;
        synchronized (jobList) {
            if (this.handle_ != null) {
                this.closeHandle_ = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (Trace.traceOn_) {
            Trace.log(1, "Adding property change listener.");
        }
        if (listener == null) {
            Trace.log(2, "Parameter 'listener' is null.");
            throw new NullPointerException("listener");
        }
        JobList jobList = this;
        synchronized (jobList) {
            if (this.propertyChangeListeners_ == null) {
                this.propertyChangeListeners_ = new PropertyChangeSupport(this);
            }
            this.propertyChangeListeners_.addPropertyChangeListener(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addVetoableChangeListener(VetoableChangeListener listener) {
        if (Trace.traceOn_) {
            Trace.log(1, "Adding vetoable change listener.");
        }
        if (listener == null) {
            Trace.log(2, "Parameter 'listener' is null.");
            throw new NullPointerException("listener");
        }
        JobList jobList = this;
        synchronized (jobList) {
            if (this.vetoableChangeListeners_ == null) {
                this.vetoableChangeListeners_ = new VetoableChangeSupport(this);
            }
            this.vetoableChangeListeners_.addVetoableChangeListener(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (Trace.traceOn_) {
            Trace.log(1, "Closing job list, handle: ", this.handle_);
        }
        if (this.handle_ == null) {
            return;
        }
        if (Trace.traceOn_ && this.trackers_ != null) {
            try {
                int inUse = 0;
                for (int i = 0; i < this.trackers_.size(); ++i) {
                    Tracker tracker = this.trackers_.elementAt(i);
                    if (tracker.isSet()) {
                        ++inUse;
                    }
                    tracker.set(false);
                }
                if (inUse > 0) {
                    Trace.log(4, "The job list on the server is possibly in use by " + inUse + " or more enumerations as a result of a call to JobList.getJobs().");
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        try {
            ListUtilities.closeList(this.system_, this.handle_);
        }
        finally {
            this.handle_ = null;
            this.closeHandle_ = false;
        }
    }

    protected void finalize() throws Throwable {
        if (Trace.traceOn_) {
            Trace.log(1, "Finalize method for job list invoked.");
        }
        if (this.handle_ != null) {
            try {
                this.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        super.finalize();
    }

    public synchronized Enumeration<Job> getJobs() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (Trace.traceOn_) {
            Trace.log(1, "Retrieving job list.");
        }
        if (this.handle_ == null || this.closeHandle_) {
            this.load();
        }
        Tracker tracker = new Tracker();
        if (this.trackers_ == null) {
            this.trackers_ = new Vector();
        }
        this.trackers_.addElement(tracker);
        for (int i = this.trackers_.size() - 1; i >= 0; --i) {
            Tracker t = this.trackers_.elementAt(i);
            if (t.isSet()) continue;
            this.trackers_.removeElementAt(i);
        }
        return new JobEnumeration(this, this.length_, tracker);
    }

    public synchronized List<Job> getJobsList() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        return Collections.list(this.getJobs());
    }

    public Job[] getJobs(int listOffset, int number) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (Trace.traceOn_) {
            Trace.log(1, "Retrieving job list, list offset: " + listOffset + ", number:", number);
        }
        if (listOffset < -1) {
            throw new ExtendedIllegalArgumentException("listOffset (" + listOffset + ")", 4);
        }
        if (number < 0 && listOffset != -1) {
            throw new ExtendedIllegalArgumentException("number (" + number + ")", 4);
        }
        if (this.handle_ == null || this.closeHandle_) {
            this.load();
        }
        if (this.length_ == 0 || number == 0 && listOffset != -1) {
            return new Job[0];
        }
        if (listOffset == -1) {
            number = this.length_;
            listOffset = 0;
        } else {
            if (listOffset >= this.length_) {
                if (Trace.traceOn_) {
                    Trace.log(4, "Value of parameter 'listOffset' is beyond end of list:", listOffset + " (list length: " + this.length_ + ")");
                }
                return new Job[0];
            }
            if (listOffset + number > this.length_) {
                number = this.length_ - listOffset;
            }
        }
        int lengthOfReceiverVariable = this.recordLength_ * number;
        byte[] data = ListUtilities.retrieveListEntries(this.system_, this.handle_, lengthOfReceiverVariable, number, listOffset, null);
        Converter conv = new Converter(this.system_.getCcsid(), this.system_);
        Job[] jobs = new Job[number];
        int i = 0;
        int offset = 0;
        while (i < jobs.length) {
            String jobName = conv.byteArrayToString(data, offset, 10);
            String userName = conv.byteArrayToString(data, offset + 10, 10);
            String jobNumber = conv.byteArrayToString(data, offset + 20, 6);
            String status = conv.byteArrayToString(data, offset + 42, 10);
            String jobType = conv.byteArrayToString(data, offset + 52, 1);
            String jobSubtype = conv.byteArrayToString(data, offset + 53, 1);
            jobs[i] = new Job(this.system_, jobName.trim(), userName.trim(), jobNumber.trim(), status, jobType, jobSubtype);
            for (int j = 0; j < this.numKeysReturned_; ++j) {
                int keyOffset = this.keyOffsetsReturned_[j];
                if (this.keyTypesReturned_[j] == 'C') {
                    String value = conv.byteArrayToString(data, offset + keyOffset, this.keyLengthsReturned_[j]);
                    jobs[i].setValueInternal(this.keyFieldsReturned_[j], value);
                    continue;
                }
                if (this.keyLengthsReturned_[j] > 4) {
                    jobs[i].setAsLong(this.keyFieldsReturned_[j], BinaryConverter.byteArrayToLong(data, offset + keyOffset));
                    continue;
                }
                if (this.keyFieldsReturned_[j] == 2009 || this.keyFieldsReturned_[j] == 1305) {
                    jobs[i].setAsLong(this.keyFieldsReturned_[j], BinaryConverter.byteArrayToLong(data, offset + keyOffset));
                    continue;
                }
                jobs[i].setAsInt(this.keyFieldsReturned_[j], BinaryConverter.byteArrayToInt(data, offset + keyOffset));
            }
            ++i;
            offset += this.recordLength_;
        }
        return jobs;
    }

    public int getLength() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting job list length.");
        }
        try {
            if (this.handle_ == null || this.closeHandle_) {
                this.load();
            }
        }
        catch (Exception e) {
            Trace.log(2, "Exception caught getting length of job list:", (Throwable)e);
        }
        if (Trace.traceOn_) {
            Trace.log(1, "Length:", this.length_);
        }
        return this.length_;
    }

    public String getName() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting name: " + this.selectionJobName_);
        }
        return this.selectionJobName_;
    }

    public String getNumber() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting number: " + this.selectionJobNumber_);
        }
        return this.selectionJobNumber_;
    }

    public AS400 getSystem() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting system: " + this.system_);
        }
        return this.system_;
    }

    public String getUser() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting user: " + this.selectionUserName_);
        }
        return this.selectionUserName_;
    }

    public synchronized void load() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        int ii;
        int i;
        boolean foundKey;
        if (Trace.traceOn_) {
            Trace.log(1, "Loading job list.");
        }
        if (this.system_ == null) {
            Trace.log(2, "Cannot connect to server before setting system.");
            throw new ExtendedIllegalStateException("system", 4);
        }
        if (this.closeHandle_) {
            this.close();
        }
        byte[] sortInformation = new byte[4 + this.currentSortKey_ * 12];
        BinaryConverter.intToByteArray(this.currentSortKey_, sortInformation, 0);
        int offset = 4;
        for (int i2 = 0; i2 < this.currentSortKey_; ++i2) {
            int fieldLength = sortableKeys_.get(this.sortKeys_[i2]);
            short dataType = 4;
            switch (this.sortKeys_[i2]) {
                case 302: 
                case 304: 
                case 409: 
                case 501: 
                case 1008: 
                case 1014: 
                case 1016: 
                case 1204: 
                case 1302: 
                case 1303: 
                case 1401: 
                case 1402: 
                case 1605: 
                case 1606: 
                case 1801: 
                case 1802: 
                case 1907: 
                case 2002: 
                case 2004: 
                case 2102: {
                    dataType = 0;
                    fieldLength = 4;
                    break;
                }
                case 1305: 
                case 2009: {
                    dataType = 9;
                    fieldLength = 4;
                    break;
                }
                case 312: 
                case 313: 
                case 1406: {
                    dataType = 9;
                    fieldLength = 8;
                    break;
                }
            }
            int fieldStartingPosition = 0;
            switch (this.sortKeys_[i2]) {
                case 11001: {
                    fieldStartingPosition = 1;
                    fieldLength = 10;
                    break;
                }
                case 11006: {
                    fieldStartingPosition = 11;
                    fieldLength = 10;
                    break;
                }
                case 11002: {
                    fieldStartingPosition = 21;
                    fieldLength = 6;
                    break;
                }
                case 11000: 
                case 11007: {
                    fieldStartingPosition = 27;
                    fieldLength = 16;
                    break;
                }
                case 11003: {
                    fieldStartingPosition = 43;
                    fieldLength = 10;
                    break;
                }
                case 11005: {
                    fieldStartingPosition = 53;
                    fieldLength = 1;
                    break;
                }
                case 11004: {
                    fieldStartingPosition = 54;
                    fieldLength = 1;
                    break;
                }
                default: {
                    fieldStartingPosition = 61;
                    int j = 0;
                    while (this.keys_[j] != this.sortKeys_[i2]) {
                        fieldStartingPosition += sortableKeys_.get(this.keys_[j]);
                        ++j;
                    }
                    break block5;
                }
            }
            BinaryConverter.intToByteArray(fieldStartingPosition, sortInformation, 4 + i2 * 12);
            BinaryConverter.intToByteArray(fieldLength, sortInformation, 8 + i2 * 12);
            BinaryConverter.shortToByteArray(dataType, sortInformation, 12 + i2 * 12);
            sortInformation[14 + i2 * 12] = this.sortOrders_[i2] ? -15 : -14;
        }
        int numberOfPrimaryJobStatusEntries = (this.selectActiveJobs_ ? 1 : 0) + (this.selectJobQueueJobs_ ? 1 : 0) + (this.selectOutQueueJobs_ ? 1 : 0);
        int numberOfJobsOnJobQueueStatusEntries = this.selectJobQueueJobs_ ? (this.selectHeldJobs_ ? 1 : 0) + (this.selectScheduledJobs_ ? 1 : 0) + (this.selectReadyJobs_ ? 1 : 0) : 0;
        byte[] jobSelectionInformation = new byte[108 + numberOfPrimaryJobStatusEntries * 10 + this.currentActiveStatus_ * 4 + numberOfJobsOnJobQueueStatusEntries * 10 + this.currentJobQueue_ * 20 + this.currentInitialUser_ * 10 + this.currentServerType_ * 30 + this.currentEnhancedJobType_ * 4];
        Converter conv = new Converter(this.system_.getCcsid(), this.system_);
        for (int i3 = 0; i3 < 26; ++i3) {
            jobSelectionInformation[i3] = 64;
        }
        conv.stringToByteArray(this.selectionJobName_.toUpperCase(), jobSelectionInformation, 0);
        conv.stringToByteArray(this.selectionUserName_.toUpperCase(), jobSelectionInformation, 10);
        conv.stringToByteArray(this.selectionJobNumber_, jobSelectionInformation, 20);
        conv.stringToByteArray(this.selectionJobType_, jobSelectionInformation, 26);
        int offset2 = 108;
        if (numberOfPrimaryJobStatusEntries > 0) {
            BinaryConverter.intToByteArray(offset2, jobSelectionInformation, 28);
            BinaryConverter.intToByteArray(numberOfPrimaryJobStatusEntries, jobSelectionInformation, 32);
            if (this.selectActiveJobs_) {
                System.arraycopy(new byte[]{92, -63, -61, -29, -55, -27, -59, 64, 64, 64}, 0, jobSelectionInformation, offset2, 10);
                offset2 += 10;
            }
            if (this.selectJobQueueJobs_) {
                System.arraycopy(new byte[]{92, -47, -42, -62, -40, 64, 64, 64, 64, 64}, 0, jobSelectionInformation, offset2, 10);
                offset2 += 10;
            }
            if (this.selectOutQueueJobs_) {
                System.arraycopy(new byte[]{92, -42, -28, -29, -40, 64, 64, 64, 64, 64}, 0, jobSelectionInformation, offset2, 10);
                offset2 += 10;
            }
        }
        if (this.currentActiveStatus_ > 0) {
            foundKey = false;
            for (i = 0; i < this.currentKey_ && !foundKey; ++i) {
                if (this.keys_[i] != 101) continue;
                foundKey = true;
            }
            if (!foundKey) {
                this.addJobAttributeToRetrieve(101);
            }
            BinaryConverter.intToByteArray(offset2, jobSelectionInformation, 36);
            BinaryConverter.intToByteArray(this.currentActiveStatus_, jobSelectionInformation, 40);
            for (i = 0; i < this.currentActiveStatus_; ++i) {
                conv.stringToByteArray(this.activeStatuses_[i], jobSelectionInformation, offset2, 4);
                offset2 += 4;
            }
        }
        if (numberOfJobsOnJobQueueStatusEntries > 0) {
            foundKey = false;
            for (i = 0; i < this.currentKey_ && !foundKey; ++i) {
                if (this.keys_[i] != 1903) continue;
                foundKey = true;
            }
            if (!foundKey) {
                this.addJobAttributeToRetrieve(1903);
            }
            BinaryConverter.intToByteArray(offset2, jobSelectionInformation, 44);
            BinaryConverter.intToByteArray(numberOfJobsOnJobQueueStatusEntries, jobSelectionInformation, 48);
            if (this.selectHeldJobs_) {
                System.arraycopy(new byte[]{-56, -45, -60, 64, 64, 64, 64, 64, 64, 64}, 0, jobSelectionInformation, offset2, 10);
                offset2 += 10;
            }
            if (this.selectScheduledJobs_) {
                System.arraycopy(new byte[]{-30, -61, -60, 64, 64, 64, 64, 64, 64, 64}, 0, jobSelectionInformation, offset2, 10);
                offset2 += 10;
            }
            if (this.selectReadyJobs_) {
                System.arraycopy(new byte[]{-39, -45, -30, 64, 64, 64, 64, 64, 64, 64}, 0, jobSelectionInformation, offset2, 10);
                offset2 += 10;
            }
        }
        if (this.currentJobQueue_ > 0) {
            foundKey = false;
            for (i = 0; i < this.currentKey_ && !foundKey; ++i) {
                if (this.keys_[i] != 1004) continue;
                foundKey = true;
            }
            if (!foundKey) {
                this.addJobAttributeToRetrieve(1004);
            }
            BinaryConverter.intToByteArray(offset2, jobSelectionInformation, 52);
            BinaryConverter.intToByteArray(this.currentJobQueue_, jobSelectionInformation, 56);
            for (i = 0; i < this.currentJobQueue_; ++i) {
                for (ii = 0; ii < 20; ++ii) {
                    jobSelectionInformation[ii + offset2] = 64;
                }
                conv.stringToByteArray(this.jobQueues_[i], jobSelectionInformation, offset2, 20);
                offset2 += 20;
            }
        }
        if (this.currentInitialUser_ > 0) {
            foundKey = false;
            for (i = 0; i < this.currentKey_ && !foundKey; ++i) {
                if (this.keys_[i] != 305) continue;
                foundKey = true;
            }
            if (!foundKey) {
                this.addJobAttributeToRetrieve(305);
            }
            BinaryConverter.intToByteArray(offset2, jobSelectionInformation, 60);
            BinaryConverter.intToByteArray(this.currentInitialUser_, jobSelectionInformation, 64);
            for (i = 0; i < this.currentInitialUser_; ++i) {
                for (ii = 0; ii < 10; ++ii) {
                    jobSelectionInformation[ii + offset2] = 64;
                }
                conv.stringToByteArray(this.initialUsers_[i], jobSelectionInformation, offset2, 10);
                offset2 += 10;
            }
        }
        if (this.currentServerType_ > 0) {
            foundKey = false;
            for (i = 0; i < this.currentKey_ && !foundKey; ++i) {
                if (this.keys_[i] != 1911) continue;
                foundKey = true;
            }
            if (!foundKey) {
                this.addJobAttributeToRetrieve(1911);
            }
            BinaryConverter.intToByteArray(offset2, jobSelectionInformation, 68);
            BinaryConverter.intToByteArray(this.currentServerType_, jobSelectionInformation, 72);
            for (i = 0; i < this.currentServerType_; ++i) {
                for (ii = 0; ii < 30; ++ii) {
                    jobSelectionInformation[ii + offset2] = 64;
                }
                conv.stringToByteArray(this.serverTypes_[i], jobSelectionInformation, offset2, 30);
                offset2 += 30;
            }
        }
        if (this.currentEnhancedJobType_ > 0) {
            foundKey = false;
            for (i = 0; i < this.currentKey_ && !foundKey; ++i) {
                if (this.keys_[i] != 1016) continue;
                foundKey = true;
            }
            if (!foundKey) {
                this.addJobAttributeToRetrieve(1016);
            }
            BinaryConverter.intToByteArray(offset2, jobSelectionInformation, 92);
            BinaryConverter.intToByteArray(this.currentEnhancedJobType_, jobSelectionInformation, 96);
            for (i = 0; i < this.currentEnhancedJobType_; ++i) {
                BinaryConverter.intToByteArray(this.enhancedJobTypes_[i], jobSelectionInformation, offset2);
                offset2 += 4;
            }
        }
        int lengthOfReceiverVariableDefinitionInformation = 4 + 20 * this.currentKey_;
        byte[] keyOfFieldsToBeReturned = new byte[4 * this.currentKey_];
        for (int i4 = 0; i4 < this.currentKey_; ++i4) {
            BinaryConverter.intToByteArray(this.keys_[i4], keyOfFieldsToBeReturned, i4 * 4);
        }
        ProgramParameter[] parameters = new ProgramParameter[]{new ProgramParameter(0), new ProgramParameter(new byte[]{0, 0, 0, 0}), new ProgramParameter(new byte[]{-42, -45, -47, -62, -16, -14, -16, -16}), new ProgramParameter(lengthOfReceiverVariableDefinitionInformation), new ProgramParameter(BinaryConverter.intToByteArray(lengthOfReceiverVariableDefinitionInformation)), new ProgramParameter(80), new ProgramParameter(new byte[]{-1, -1, -1, -1}), new ProgramParameter(sortInformation), new ProgramParameter(jobSelectionInformation), new ProgramParameter(BinaryConverter.intToByteArray(jobSelectionInformation.length)), new ProgramParameter(BinaryConverter.intToByteArray(this.currentKey_)), new ProgramParameter(keyOfFieldsToBeReturned), new ErrorCodeParameter(), new ProgramParameter(new byte[]{-42, -45, -47, -30, -16, -14, -16, -16})};
        ProgramCall pc = new ProgramCall(this.system_, "/QSYS.LIB/QGYOLJOB.PGM", parameters);
        if (!pc.run()) {
            throw new AS400Exception(pc.getMessageList());
        }
        byte[] listInformation = parameters[5].getOutputData();
        this.handle_ = new byte[4];
        System.arraycopy(listInformation, 8, this.handle_, 0, 4);
        listInformation = ListUtilities.waitForListToComplete(this.system_, this.handle_, listInformation);
        this.length_ = BinaryConverter.byteArrayToInt(listInformation, 0);
        this.recordLength_ = BinaryConverter.byteArrayToInt(listInformation, 12);
        byte[] defInfo = parameters[3].getOutputData();
        this.numKeysReturned_ = BinaryConverter.byteArrayToInt(defInfo, 0);
        this.keyFieldsReturned_ = new int[this.numKeysReturned_];
        this.keyTypesReturned_ = new char[this.numKeysReturned_];
        this.keyLengthsReturned_ = new int[this.numKeysReturned_];
        this.keyOffsetsReturned_ = new int[this.numKeysReturned_];
        offset2 = 4;
        for (int i5 = 0; i5 < this.numKeysReturned_; ++i5) {
            this.keyFieldsReturned_[i5] = BinaryConverter.byteArrayToInt(defInfo, offset2 + 4);
            this.keyTypesReturned_[i5] = conv.byteArrayToString(defInfo, offset2 + 8, 1).charAt(0);
            this.keyLengthsReturned_[i5] = BinaryConverter.byteArrayToInt(defInfo, offset2 + 12);
            this.keyOffsetsReturned_[i5] = BinaryConverter.byteArrayToInt(defInfo, offset2 + 16);
            offset2 += 20;
        }
        if (Trace.traceOn_) {
            Trace.log(1, "Loaded job list, length: " + this.length_ + ", record length: " + this.recordLength_ + ", handle:", this.handle_);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (Trace.traceOn_) {
            Trace.log(1, "Removing property change listener.");
        }
        if (listener == null) {
            Trace.log(2, "Parameter 'listener' is null.");
            throw new NullPointerException("listener");
        }
        if (this.propertyChangeListeners_ != null) {
            this.propertyChangeListeners_.removePropertyChangeListener(listener);
        }
    }

    public void removeVetoableChangeListener(VetoableChangeListener listener) {
        if (Trace.traceOn_) {
            Trace.log(1, "Removing vetoable change listener.");
        }
        if (listener == null) {
            Trace.log(2, "Parameter 'listener' is null.");
            throw new NullPointerException("listener");
        }
        if (this.vetoableChangeListeners_ != null) {
            this.vetoableChangeListeners_.removeVetoableChangeListener(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setName(String name) throws PropertyVetoException {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting name: " + name);
        }
        if (name == null) {
            Trace.log(2, "Parameter 'name' is null.");
            throw new NullPointerException("name");
        }
        if (this.propertyChangeListeners_ == null && this.vetoableChangeListeners_ == null) {
            JobList jobList = this;
            synchronized (jobList) {
                this.selectionJobName_ = name;
                if (this.handle_ != null) {
                    this.closeHandle_ = true;
                }
            }
        }
        String oldValue = this.selectionJobName_;
        String newValue = name;
        if (this.vetoableChangeListeners_ != null) {
            this.vetoableChangeListeners_.fireVetoableChange("name", oldValue, newValue);
        }
        JobList jobList = this;
        synchronized (jobList) {
            this.selectionJobName_ = name;
            if (this.handle_ != null) {
                this.closeHandle_ = true;
            }
        }
        if (this.propertyChangeListeners_ != null) {
            this.propertyChangeListeners_.firePropertyChange("name", oldValue, newValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNumber(String number) throws PropertyVetoException {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting number: " + number);
        }
        if (number == null) {
            Trace.log(2, "Parameter 'number' is null.");
            throw new NullPointerException("number");
        }
        if (this.propertyChangeListeners_ == null && this.vetoableChangeListeners_ == null) {
            JobList jobList = this;
            synchronized (jobList) {
                this.selectionJobNumber_ = number;
                if (this.handle_ != null) {
                    this.closeHandle_ = true;
                }
            }
        }
        String oldValue = this.selectionJobNumber_;
        String newValue = number;
        if (this.vetoableChangeListeners_ != null) {
            this.vetoableChangeListeners_.fireVetoableChange("number", oldValue, newValue);
        }
        JobList jobList = this;
        synchronized (jobList) {
            this.selectionJobNumber_ = number;
            if (this.handle_ != null) {
                this.closeHandle_ = true;
            }
        }
        if (this.propertyChangeListeners_ != null) {
            this.propertyChangeListeners_.firePropertyChange("number", oldValue, newValue);
        }
    }

    public void setSystem(AS400 system) throws PropertyVetoException {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting system: " + system);
        }
        if (system == null) {
            Trace.log(2, "Parameter 'system' is null.");
            throw new NullPointerException("system");
        }
        if (this.handle_ != null) {
            Trace.log(2, "Cannot set property 'system' after connect.");
            throw new ExtendedIllegalStateException("system", 5);
        }
        if (this.propertyChangeListeners_ == null && this.vetoableChangeListeners_ == null) {
            this.system_ = system;
        } else {
            AS400 oldValue = this.system_;
            AS400 newValue = system;
            if (this.vetoableChangeListeners_ != null) {
                this.vetoableChangeListeners_.fireVetoableChange("system", oldValue, newValue);
            }
            this.system_ = system;
            if (this.propertyChangeListeners_ != null) {
                this.propertyChangeListeners_.firePropertyChange("system", oldValue, newValue);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUser(String user) throws PropertyVetoException {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting user: " + user);
        }
        if (user == null) {
            Trace.log(2, "Parameter 'user' is null.");
            throw new NullPointerException("user");
        }
        if (this.propertyChangeListeners_ == null && this.vetoableChangeListeners_ == null) {
            JobList jobList = this;
            synchronized (jobList) {
                this.selectionUserName_ = user;
                if (this.handle_ != null) {
                    this.closeHandle_ = true;
                }
            }
        }
        String oldValue = this.selectionUserName_;
        String newValue = user;
        if (this.vetoableChangeListeners_ != null) {
            this.vetoableChangeListeners_.fireVetoableChange("user", oldValue, newValue);
        }
        JobList jobList = this;
        synchronized (jobList) {
            this.selectionUserName_ = user;
            if (this.handle_ != null) {
                this.closeHandle_ = true;
            }
        }
        if (this.propertyChangeListeners_ != null) {
            this.propertyChangeListeners_.firePropertyChange("user", oldValue, newValue);
        }
    }

    static {
        sortableKeys_.put(101, 4);
        sortableKeys_.put(102, 1);
        sortableKeys_.put(103, 4);
        sortableKeys_.put(201, 10);
        sortableKeys_.put(302, 4);
        sortableKeys_.put(303, 2);
        sortableKeys_.put(304, 4);
        sortableKeys_.put(305, 10);
        sortableKeys_.put(306, 1);
        sortableKeys_.put(307, 4);
        sortableKeys_.put(311, 10);
        sortableKeys_.put(312, 8);
        sortableKeys_.put(313, 8);
        sortableKeys_.put(401, 13);
        sortableKeys_.put(402, 13);
        sortableKeys_.put(403, 8);
        sortableKeys_.put(404, 8);
        sortableKeys_.put(405, 4);
        sortableKeys_.put(406, 1);
        sortableKeys_.put(407, 1);
        sortableKeys_.put(408, 10);
        sortableKeys_.put(409, 4);
        sortableKeys_.put(410, 13);
        sortableKeys_.put(412, 4);
        sortableKeys_.put(413, 1);
        sortableKeys_.put(418, 13);
        sortableKeys_.put(501, 4);
        sortableKeys_.put(502, 1);
        sortableKeys_.put(601, 10);
        sortableKeys_.put(602, 1);
        sortableKeys_.put(701, 1);
        sortableKeys_.put(901, 10);
        sortableKeys_.put(1001, 15);
        sortableKeys_.put(1002, 7);
        sortableKeys_.put(1003, 20);
        sortableKeys_.put(1004, 20);
        sortableKeys_.put(1005, 2);
        sortableKeys_.put(1006, 8);
        sortableKeys_.put(1007, 10);
        sortableKeys_.put(1008, 4);
        sortableKeys_.put(1012, 10);
        sortableKeys_.put(1013, 1);
        sortableKeys_.put(1014, 4);
        sortableKeys_.put(1015, 1);
        sortableKeys_.put(1016, 4);
        sortableKeys_.put(1018, 10);
        sortableKeys_.put(1201, 3);
        sortableKeys_.put(1202, 1);
        sortableKeys_.put(1203, 10);
        sortableKeys_.put(1204, 4);
        sortableKeys_.put(1205, 10);
        sortableKeys_.put(1301, 8);
        sortableKeys_.put(1302, 4);
        sortableKeys_.put(1303, 4);
        sortableKeys_.put(1304, 4);
        sortableKeys_.put(1305, 4);
        sortableKeys_.put(1306, 10);
        sortableKeys_.put(1307, 1);
        sortableKeys_.put(1401, 4);
        sortableKeys_.put(1402, 4);
        sortableKeys_.put(1406, 8);
        sortableKeys_.put(1501, 20);
        sortableKeys_.put(1502, 2);
        sortableKeys_.put(1601, 10);
        sortableKeys_.put(1602, 30);
        sortableKeys_.put(1603, 10);
        sortableKeys_.put(1604, 10);
        sortableKeys_.put(1605, 4);
        sortableKeys_.put(1606, 4);
        sortableKeys_.put(1801, 4);
        sortableKeys_.put(1802, 4);
        sortableKeys_.put(1803, 80);
        sortableKeys_.put(1901, 20);
        sortableKeys_.put(1902, 10);
        sortableKeys_.put(1903, 10);
        sortableKeys_.put(1904, 26);
        sortableKeys_.put(1906, 20);
        sortableKeys_.put(1907, 4);
        sortableKeys_.put(1908, 10);
        sortableKeys_.put(1911, 30);
        sortableKeys_.put(1982, 10);
        sortableKeys_.put(2001, 1);
        sortableKeys_.put(2002, 4);
        sortableKeys_.put(2003, 10);
        sortableKeys_.put(2004, 4);
        sortableKeys_.put(2008, 4);
        sortableKeys_.put(2009, 4);
        sortableKeys_.put(2101, 24);
        sortableKeys_.put(2102, 4);
    }
}

