/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.ExtendedIOException;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.FileListener;
import com.ibm.as400.access.IFSFile;
import com.ibm.as400.access.IFSFileDescriptor;
import com.ibm.as400.access.IFSFileInputStream;
import com.ibm.as400.access.IFSFileOutputStreamImpl;
import com.ibm.as400.access.IFSJavaFile;
import com.ibm.as400.access.IFSKey;
import com.ibm.as400.access.Trace;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.channels.ClosedChannelException;
import java.util.Vector;

public class IFSFileOutputStream
extends OutputStream
implements Serializable {
    static final long serialVersionUID = 4L;
    public static final int SHARE_ALL = -1;
    public static final int SHARE_NONE = -4;
    public static final int SHARE_READERS = -3;
    public static final int SHARE_WRITERS = -2;
    protected transient PropertyChangeSupport changes_;
    protected transient VetoableChangeSupport vetos_;
    protected IFSFileDescriptor fd_;
    transient Vector fileListeners_;
    transient IFSFileOutputStreamImpl impl_;
    private boolean append_ = false;
    private int ccsid_ = -1;

    public IFSFileOutputStream() {
        this.fd_ = new IFSFileDescriptor(-1, this);
        this.initializeTransient();
    }

    public IFSFileOutputStream(AS400 system, String name) throws AS400SecurityException, IOException {
        if (system == null) {
            throw new NullPointerException("system");
        }
        if (name == null) {
            throw new NullPointerException("name");
        }
        this.myConstructor(system, name, -1, false, -1);
    }

    public IFSFileOutputStream(AS400 system, String name, int ccsid) throws AS400SecurityException, IOException {
        this(system, name, -1, false, ccsid);
    }

    public IFSFileOutputStream(AS400 system, String name, int shareOption, boolean append) throws AS400SecurityException, IOException {
        if (system == null) {
            throw new NullPointerException("system");
        }
        if (name == null) {
            throw new NullPointerException("name");
        }
        this.myConstructor(system, name, shareOption, append, -1);
    }

    public IFSFileOutputStream(AS400 system, String name, int shareOption, boolean append, int ccsid) throws AS400SecurityException, IOException {
        if (system == null) {
            throw new NullPointerException("system");
        }
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (ccsid < 0) {
            throw new ExtendedIllegalArgumentException("ccsid", 2);
        }
        this.myConstructor(system, name, shareOption, append, ccsid);
    }

    public IFSFileOutputStream(IFSFile file) throws AS400SecurityException, IOException {
        if (file == null) {
            throw new NullPointerException("file");
        }
        this.myConstructor(file.getSystem(), file.getAbsolutePath(), -1, false, -1);
    }

    public IFSFileOutputStream(AS400 system, IFSFile file, int shareOption, boolean append) throws AS400SecurityException, IOException {
        if (file == null) {
            throw new NullPointerException("file");
        }
        if (system == null) {
            throw new NullPointerException("system");
        }
        this.myConstructor(system, file.getAbsolutePath(), shareOption, append, -1);
    }

    public IFSFileOutputStream(IFSFile file, int shareOption, boolean append) throws AS400SecurityException, IOException {
        if (file == null) {
            throw new NullPointerException("file");
        }
        this.myConstructor(file.getSystem(), file.getAbsolutePath(), shareOption, append, -1);
    }

    public IFSFileOutputStream(AS400 system, IFSFile file, int shareOption, boolean append, int ccsid) throws AS400SecurityException, IOException {
        if (system == null) {
            throw new NullPointerException("system");
        }
        if (file == null) {
            throw new NullPointerException("file");
        }
        if (ccsid < 0) {
            throw new ExtendedIllegalArgumentException("ccsid", 2);
        }
        this.myConstructor(system, file.getAbsolutePath(), shareOption, append, ccsid);
    }

    public IFSFileOutputStream(IFSFile file, int shareOption, boolean append, int ccsid) throws AS400SecurityException, IOException {
        if (file == null) {
            throw new NullPointerException("file");
        }
        if (ccsid < 0) {
            throw new ExtendedIllegalArgumentException("ccsid", 2);
        }
        this.myConstructor(file.getSystem(), file.getAbsolutePath(), shareOption, append, ccsid);
    }

    void myConstructor(AS400 system, String filePath, int shareOption, boolean append, int ccsid) throws AS400SecurityException, IOException {
        IFSFileInputStream.validateShareOption(shareOption);
        this.append_ = append;
        this.ccsid_ = ccsid;
        this.initializeTransient();
        this.fd_ = new IFSFileDescriptor(system, filePath, shareOption, this);
        this.connectAndOpen();
    }

    public IFSFileOutputStream(IFSFileDescriptor fd) {
        if (fd == null) {
            throw new NullPointerException("fd");
        }
        IFSFileInputStream.validateShareOption(fd.getShareOption());
        this.initializeTransient();
        this.fd_ = fd;
    }

    public IFSFileOutputStream(IFSJavaFile file) throws AS400SecurityException, IOException {
        if (file == null) {
            throw new NullPointerException("file");
        }
        this.myConstructor(file.getSystem(), file.getAbsolutePath().replace(File.separatorChar, '/'), -1, false, -1);
    }

    public IFSFileOutputStream(AS400 system, IFSJavaFile file, int shareOption, boolean append) throws AS400SecurityException, IOException {
        if (file == null) {
            throw new NullPointerException("file");
        }
        if (system == null) {
            throw new NullPointerException("system");
        }
        IFSFileInputStream.validateShareOption(shareOption);
        this.myConstructor(system, file.getAbsolutePath().replace(File.separatorChar, '/'), shareOption, append, -1);
    }

    public IFSFileOutputStream(AS400 system, IFSJavaFile file, int shareOption, boolean append, int ccsid) throws AS400SecurityException, IOException {
        if (system == null) {
            throw new NullPointerException("system");
        }
        if (file == null) {
            throw new NullPointerException("file");
        }
        IFSFileInputStream.validateShareOption(shareOption);
        if (ccsid < 0) {
            throw new ExtendedIllegalArgumentException("ccsid", 2);
        }
        this.myConstructor(system, file.getAbsolutePath().replace(File.separatorChar, '/'), shareOption, append, ccsid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFileListener(FileListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        Vector vector = this.fileListeners_;
        synchronized (vector) {
            this.fileListeners_.addElement(listener);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        this.changes_.addPropertyChangeListener(listener);
    }

    public void addVetoableChangeListener(VetoableChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        this.vetos_.addVetoableChangeListener(listener);
    }

    private void chooseImpl() {
        if (this.impl_ == null) {
            AS400 system = this.fd_.getSystem();
            if (system == null) {
                throw new ExtendedIllegalStateException("system", 4);
            }
            this.impl_ = (IFSFileOutputStreamImpl)system.loadImpl2("com.ibm.as400.access.IFSFileOutputStreamImplRemote", "com.ibm.as400.access.IFSFileOutputStreamImplProxy");
            this.impl_.setFD(this.fd_.getImpl());
            this.impl_.setAppend(this.append_);
        }
    }

    @Override
    public void close() throws IOException {
        if (!this.fd_.isClosed() && this.fd_.isOpen()) {
            if (this.impl_ != null) {
                this.impl_.close();
            } else {
                this.fd_.close();
            }
            if (this.fileListeners_.size() != 0) {
                IFSFileDescriptor.fireClosedEvents(this, this.fileListeners_);
            }
        }
    }

    private void connectAndOpen() throws AS400SecurityException, IOException {
        if (this.impl_ == null) {
            this.chooseImpl();
            this.fd_.getSystem().connectService(0);
        }
        this.impl_.connectAndOpen(this.ccsid_);
        if (this.fileListeners_.size() != 0) {
            IFSFileDescriptor.fireOpenedEvents(this, this.fileListeners_);
        }
    }

    protected void finalize() throws IOException {
        if (this.fd_ != null && this.fd_.isOpen()) {
            if (this.impl_ != null) {
                this.impl_.close();
            } else {
                this.fd_.close();
            }
        }
        try {
            super.finalize();
        }
        catch (Throwable e) {
            throw new IOException(e.toString());
        }
    }

    @Override
    public void flush() throws IOException {
        if (this.fd_.isClosed()) {
            Trace.log(2, "The stream has been closed.");
            throw new ClosedChannelException();
        }
        this.open(this.ccsid_);
        this.impl_.flush();
    }

    int getCCSID() {
        return this.ccsid_;
    }

    public final IFSFileDescriptor getFD() throws IOException {
        return this.fd_;
    }

    IFSFileOutputStreamImpl getImpl() {
        return this.impl_;
    }

    public String getPath() {
        return this.fd_.getPath();
    }

    public int getShareOption() {
        return this.fd_.getShareOption();
    }

    public AS400 getSystem() {
        return this.fd_.getSystem();
    }

    private void initializeTransient() {
        this.changes_ = new PropertyChangeSupport(this);
        this.vetos_ = new VetoableChangeSupport(this);
        this.fileListeners_ = new Vector();
        this.impl_ = null;
    }

    public IFSKey lock(int length) throws IOException {
        return this.lock((long)length);
    }

    public IFSKey lock(long length) throws IOException {
        if (length <= 0L) {
            throw new ExtendedIllegalArgumentException("length (" + Long.toString(length) + ")", 2);
        }
        this.open(this.ccsid_);
        return this.impl_.lock(length);
    }

    protected void open(int fileDataCCSID) throws IOException {
        if (this.impl_ == null) {
            this.chooseImpl();
            try {
                this.fd_.getSystem().connectService(0);
            }
            catch (AS400SecurityException e) {
                Trace.log(2, "Access to byte stream server on '" + this.fd_.getSystem().getSystemName() + "' denied.", (Throwable)e);
                throw new ExtendedIOException(5);
            }
        }
        if (this.fd_.isOpen()) {
            return;
        }
        this.impl_.open(fileDataCCSID);
        if (this.fileListeners_.size() != 0) {
            IFSFileDescriptor.fireOpenedEvents(this, this.fileListeners_);
        }
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        this.initializeTransient();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFileListener(FileListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        Vector vector = this.fileListeners_;
        synchronized (vector) {
            this.fileListeners_.removeElement(listener);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        this.changes_.removePropertyChangeListener(listener);
    }

    public void removeVetoableChangeListener(VetoableChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        this.vetos_.removeVetoableChangeListener(listener);
    }

    public void setAppend(boolean append) throws PropertyVetoException {
        if (this.fd_.valid()) {
            throw new ExtendedIllegalStateException("append", 5);
        }
        Boolean oldAppend = this.append_;
        Boolean newAppend = append;
        this.vetos_.fireVetoableChange("append", oldAppend, newAppend);
        this.append_ = append;
        this.changes_.firePropertyChange("append", oldAppend, newAppend);
    }

    void setCCSID(int ccsid) throws PropertyVetoException {
        if (ccsid < 0) {
            throw new ExtendedIllegalArgumentException("ccsid", 2);
        }
        if (this.fd_.isOpen()) {
            throw new ExtendedIllegalStateException("CCSID", 5);
        }
        Integer oldCCSID = this.ccsid_;
        Integer newCCSID = ccsid;
        this.vetos_.fireVetoableChange("CCSID", oldCCSID, newCCSID);
        this.ccsid_ = ccsid;
        this.changes_.firePropertyChange("CCSID", oldCCSID, newCCSID);
    }

    public void setFD(IFSFileDescriptor fd) throws PropertyVetoException {
        if (fd == null) {
            throw new NullPointerException("fd");
        }
        if (this.fd_.valid()) {
            throw new ExtendedIllegalStateException("FD", 5);
        }
        this.vetos_.fireVetoableChange("FD", this.fd_, fd);
        IFSFileDescriptor oldFD = this.fd_;
        this.fd_ = fd;
        this.changes_.firePropertyChange("FD", oldFD, this.fd_);
    }

    public void setPath(String path) throws PropertyVetoException {
        if (path == null) {
            throw new NullPointerException("path");
        }
        if (this.fd_.valid()) {
            throw new ExtendedIllegalStateException("path", 5);
        }
        String oldPath = this.fd_.getPath();
        String newPath = path.length() == 0 || path.charAt(0) != '/' ? "/" + path : path;
        this.vetos_.fireVetoableChange("path", oldPath, newPath);
        this.fd_.setPath(newPath);
        this.changes_.firePropertyChange("path", oldPath, newPath);
    }

    public void setShareOption(int shareOption) throws PropertyVetoException {
        IFSFileInputStream.validateShareOption(shareOption);
        if (this.fd_.valid()) {
            throw new ExtendedIllegalStateException("shareOption", 5);
        }
        Integer oldShareOption = this.fd_.getShareOption();
        Integer newShareOption = shareOption;
        this.vetos_.fireVetoableChange("shareOption", oldShareOption, newShareOption);
        this.fd_.setShareOption(shareOption);
        this.changes_.firePropertyChange("shareOption", oldShareOption, newShareOption);
    }

    public void setSystem(AS400 system) throws PropertyVetoException {
        if (system == null) {
            throw new NullPointerException("system");
        }
        if (this.fd_.valid()) {
            Trace.log(2, "Cannot set property 'system' after connect.");
            throw new ExtendedIllegalStateException("system", 5);
        }
        AS400 oldSystem = this.fd_.getSystem();
        this.vetos_.fireVetoableChange("system", oldSystem, system);
        this.fd_.setSystem(system);
        this.changes_.firePropertyChange("system", oldSystem, system);
    }

    public void unlock(IFSKey key) throws IOException {
        if (key == null) {
            throw new NullPointerException("key");
        }
        this.open(this.ccsid_);
        this.impl_.unlock(key);
    }

    @Override
    public void write(int b) throws IOException {
        byte[] data = new byte[]{(byte)b};
        this.write(data, 0, 1);
    }

    @Override
    public void write(byte[] data) throws IOException {
        if (data == null) {
            throw new NullPointerException("data");
        }
        this.write(data, 0, data.length);
    }

    @Override
    public void write(byte[] data, int dataOffset, int length) throws IOException {
        if (data == null) {
            throw new NullPointerException("data");
        }
        if (dataOffset < 0) {
            throw new ExtendedIllegalArgumentException("dataOffset", 2);
        }
        if (length < 0) {
            throw new ExtendedIllegalArgumentException("length", 2);
        }
        this.open(this.ccsid_);
        this.impl_.write(data, dataOffset, length);
        if (this.fileListeners_.size() != 0) {
            IFSFileDescriptor.fireModifiedEvents(this, this.fileListeners_);
        }
    }
}

