/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.ExtendedIOException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;

class HexReaderInputStream
extends InputStream {
    private Reader reader_;
    private boolean cached_ = false;
    private char cachedChar_;

    public HexReaderInputStream(Reader reader) {
        this.reader_ = reader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int available() throws IOException {
        HexReaderInputStream hexReaderInputStream = this;
        synchronized (hexReaderInputStream) {
            if (this.cached_ && this.reader_.ready()) {
                return 1;
            }
        }
        return 0;
    }

    @Override
    public void close() throws IOException {
        this.reader_.close();
    }

    @Override
    public synchronized int read() throws IOException {
        if (this.cached_) {
            this.cached_ = false;
            int lo = this.reader_.read();
            if (lo == -1) {
                return -1;
            }
            try {
                return BinaryConverter.charsToByte(this.cachedChar_, (char)lo);
            }
            catch (NumberFormatException e) {
                throw new ExtendedIOException(21);
            }
        }
        int hi = this.reader_.read();
        if (hi == -1) {
            return -1;
        }
        int lo = this.reader_.read();
        if (lo == -1) {
            return -1;
        }
        try {
            return BinaryConverter.charsToByte((char)hi, (char)lo);
        }
        catch (NumberFormatException e) {
            throw new ExtendedIOException(21);
        }
    }

    @Override
    public synchronized int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public synchronized int read(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException("b");
        }
        if (len == 0) {
            return 0;
        }
        if (this.cached_) {
            this.cached_ = false;
            int lo = this.reader_.read();
            if (lo == -1) {
                return -1;
            }
            try {
                b[off] = BinaryConverter.charsToByte(this.cachedChar_, (char)lo);
            }
            catch (NumberFormatException e) {
                throw new ExtendedIOException(21);
            }
            return 1;
        }
        char[] buf = new char[len * 2];
        int numRead = this.reader_.read(buf);
        if (numRead == -1) {
            return -1;
        }
        if (numRead % 2 != 0) {
            this.cached_ = true;
            this.cachedChar_ = buf[numRead - 1];
            --numRead;
        }
        try {
            return BinaryConverter.stringToBytes(buf, 0, numRead, b, off);
        }
        catch (NumberFormatException e) {
            throw new ExtendedIOException(21);
        }
    }

    @Override
    public synchronized long skip(long n) throws IOException {
        if (n == 0L) {
            return 0L;
        }
        if (this.cached_) {
            this.cached_ = false;
        }
        long skipped = this.reader_.skip(n * 2L);
        return skipped / 2L;
    }
}

