/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark.stateful;

import java.io.Closeable;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import org.apache.beam.runners.core.construction.SerializablePipelineOptions;
import org.apache.beam.runners.core.metrics.MetricsContainerImpl;
import org.apache.beam.runners.core.metrics.MetricsContainerStepMap;
import org.apache.beam.runners.spark.coders.CoderHelpers;
import org.apache.beam.runners.spark.io.EmptyCheckpointMark;
import org.apache.beam.runners.spark.io.MicrobatchSource;
import org.apache.beam.runners.spark.io.SparkUnboundedSource;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.io.Source;
import org.apache.beam.sdk.io.UnboundedSource;
import org.apache.beam.sdk.metrics.MetricsContainer;
import org.apache.beam.sdk.metrics.MetricsEnvironment;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.GlobalWindow;
import org.apache.beam.sdk.transforms.windowing.PaneInfo;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Stopwatch;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Iterators;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Lists;
import org.apache.spark.streaming.State;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Instant;
import org.joda.time.ReadableInstant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function3;
import scala.Option;
import scala.Tuple2;
import scala.runtime.AbstractFunction3;

public class StateSpecFunctions {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(StateSpecFunctions.class);

    public static <T, CheckpointMarkT extends UnboundedSource.CheckpointMark> @UnknownKeyFor @NonNull @Initialized Function3<@UnknownKeyFor @NonNull @Initialized Source<T>, @UnknownKeyFor @NonNull @Initialized Option<CheckpointMarkT>, @UnknownKeyFor @NonNull @Initialized State<@UnknownKeyFor @NonNull @Initialized Tuple2<@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [], @UnknownKeyFor @NonNull @Initialized Instant>>, @UnknownKeyFor @NonNull @Initialized Tuple2<@UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized []>,  @UnknownKeyFor @NonNull @Initialized SparkUnboundedSource.Metadata>> mapSourceFunction(final @UnknownKeyFor @NonNull @Initialized SerializablePipelineOptions options, final @UnknownKeyFor @NonNull @Initialized String stepName) {
        return new SerializableFunction3<Source<T>, Option<CheckpointMarkT>, State<Tuple2<byte[], Instant>>, Tuple2<Iterable<byte[]>, SparkUnboundedSource.Metadata>>(){

            public @UnknownKeyFor @NonNull @Initialized Tuple2<@UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized []>,  @UnknownKeyFor @NonNull @Initialized SparkUnboundedSource.Metadata> apply(@UnknownKeyFor @NonNull @Initialized Source<T> source, @UnknownKeyFor @NonNull @Initialized Option<CheckpointMarkT> startCheckpointMark, @UnknownKeyFor @NonNull @Initialized State<@UnknownKeyFor @NonNull @Initialized Tuple2<@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [], @UnknownKeyFor @NonNull @Initialized Instant>> state) {
                Tuple2 tuple2;
                block17: {
                    MetricsContainerStepMap metricsContainers = new MetricsContainerStepMap();
                    MetricsContainerImpl metricsContainer = metricsContainers.getContainer(stepName);
                    Closeable ignored = MetricsEnvironment.scopedMetricsContainer((MetricsContainer)metricsContainer);
                    try {
                        Instant highWatermark;
                        MicrobatchSource.Reader microbatchReader;
                        UnboundedSource.CheckpointMark checkpointMark;
                        MicrobatchSource microbatchSource = (MicrobatchSource)source;
                        Instant lowWatermark = BoundedWindow.TIMESTAMP_MIN_VALUE;
                        Coder checkpointCoder = microbatchSource.getCheckpointMarkCoder();
                        if (state.exists()) {
                            lowWatermark = (Instant)((Tuple2)state.get())._2();
                            checkpointMark = (UnboundedSource.CheckpointMark)CoderHelpers.fromByteArray((byte[])((Tuple2)state.get())._1(), checkpointCoder);
                            LOG.info("Continue reading from an existing CheckpointMark.");
                        } else if (startCheckpointMark.isDefined() && !((UnboundedSource.CheckpointMark)startCheckpointMark.get()).equals(EmptyCheckpointMark.get())) {
                            checkpointMark = (UnboundedSource.CheckpointMark)startCheckpointMark.get();
                            LOG.info("Start reading from a provided CheckpointMark.");
                        } else {
                            checkpointMark = null;
                            LOG.info("No CheckpointMark provided, start reading from default.");
                        }
                        Stopwatch stopwatch = Stopwatch.createStarted();
                        long readDurationMillis = 0L;
                        try {
                            microbatchReader = (MicrobatchSource.Reader)microbatchSource.getOrCreateReader(options.get(), checkpointMark);
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                        ArrayList<byte[]> readValues = new ArrayList<byte[]>();
                        WindowedValue.FullWindowedValueCoder coder = WindowedValue.FullWindowedValueCoder.of((Coder)source.getOutputCoder(), (Coder)GlobalWindow.Coder.INSTANCE);
                        try {
                            boolean finished;
                            boolean bl = finished = !microbatchReader.start();
                            while (!finished) {
                                WindowedValue wv = WindowedValue.of(microbatchReader.getCurrent(), (Instant)microbatchReader.getCurrentTimestamp(), (BoundedWindow)GlobalWindow.INSTANCE, (PaneInfo)PaneInfo.NO_FIRING);
                                readValues.add(CoderHelpers.toByteArray(wv, coder));
                                finished = !microbatchReader.advance();
                            }
                            Instant sourceWatermark = microbatchReader.getWatermark();
                            highWatermark = sourceWatermark.isAfter((ReadableInstant)lowWatermark) ? sourceWatermark : lowWatermark;
                            readDurationMillis = stopwatch.stop().elapsed(TimeUnit.MILLISECONDS);
                            LOG.info("Source id {} spent {} millis on reading.", (Object)microbatchSource.getId(), (Object)readDurationMillis);
                            Object finishedReadCheckpointMark = microbatchReader.getCheckpointMark();
                            byte[] codedCheckpoint = CoderHelpers.toByteArray(finishedReadCheckpointMark, checkpointCoder);
                            state.update((Object)new Tuple2((Object)codedCheckpoint, (Object)highWatermark));
                        }
                        catch (IOException e) {
                            throw new RuntimeException("Failed to read from reader.", e);
                        }
                        ArrayList payload = Lists.newArrayList((Iterator)Iterators.unmodifiableIterator(readValues.iterator()));
                        tuple2 = new Tuple2((Object)payload, (Object)new SparkUnboundedSource.Metadata(readValues.size(), lowWatermark, highWatermark, readDurationMillis, metricsContainers));
                        if (ignored == null) break block17;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (ignored != null) {
                                try {
                                    ignored.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    }
                    ignored.close();
                }
                return tuple2;
            }
        };
    }

    private static abstract class SerializableFunction3<@UnknownKeyFor T1, @UnknownKeyFor T2, @UnknownKeyFor T3, @UnknownKeyFor T4>
    extends AbstractFunction3<T1, T2, T3, T4>
    implements Serializable {
        private SerializableFunction3() {
        }
    }
}

