/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.neo4j.execution.builder;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.Map;
import org.apache.hop.core.json.HopJson;
import org.apache.hop.neo4j.execution.builder.BaseCypherBuilder;

public class CypherMergeBuilder
extends BaseCypherBuilder {
    private CypherMergeBuilder() {
        this.cypher.append("MERGE");
    }

    public static CypherMergeBuilder of() {
        return new CypherMergeBuilder();
    }

    public CypherMergeBuilder withLabelAndKey(String label, String key, Object value) {
        this.cypher.append("(n:").append(label).append(" {").append(key).append(" : $").append(key).append("}) ");
        this.parameters.put(key, value);
        return this;
    }

    public CypherMergeBuilder withLabelAndKeys(String label, Map<String, Object> keyValueMap) {
        this.cypher.append("(n:").append(label).append(" {");
        boolean firstKey = true;
        for (String key : keyValueMap.keySet()) {
            Object value = keyValueMap.get(key);
            if (firstKey) {
                firstKey = false;
            } else {
                this.cypher.append(", ");
            }
            this.cypher.append(key).append(" : $").append(key);
            this.parameters.put(key, value);
        }
        this.cypher.append(" }) ");
        return this;
    }

    public CypherMergeBuilder withValue(String property, Object value) {
        if (this.firstParameter) {
            this.firstParameter = false;
            this.cypher.append("SET ");
        } else {
            this.cypher.append(", ");
        }
        this.cypher.append("n.").append(property).append("=$").append(property).append(" ");
        if (value instanceof Map) {
            String jsonString;
            try {
                jsonString = HopJson.newMapper().writeValueAsString(value);
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException("Error converting Map to a JSON String", e);
            }
            this.addParameter(property, jsonString);
        } else {
            this.addParameter(property, value);
        }
        return this;
    }
}

