/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.client;

import java.util.Map;
import org.apache.kafka.common.config.ConfigDef;

public class SchemaRegistryClientConfig {
    public static final String CLIENT_NAMESPACE = "schema.registry.";
    public static final String BASIC_AUTH_CREDENTIALS_SOURCE = "basic.auth.credentials.source";
    @Deprecated
    public static final String SCHEMA_REGISTRY_USER_INFO_CONFIG = "schema.registry.basic.auth.user.info";
    public static final String USER_INFO_CONFIG = "basic.auth.user.info";
    public static final String HTTP_CONNECT_TIMEOUT_MS = "http.connect.timeout.ms";
    public static final int HTTP_CONNECT_TIMEOUT_MS_DEFAULT = 60000;
    public static final String HTTP_READ_TIMEOUT_MS = "http.read.timeout.ms";
    public static final int HTTP_READ_TIMEOUT_MS_DEFAULT = 60000;
    public static final String BEARER_AUTH_CREDENTIALS_SOURCE = "bearer.auth.credentials.source";
    public static final String BEARER_AUTH_TOKEN_CONFIG = "bearer.auth.token";
    public static final String PROXY_HOST = "proxy.host";
    public static final String PROXY_PORT = "proxy.port";
    public static final String MISSING_CACHE_SIZE_CONFIG = "missing.cache.size";
    public static final String MISSING_ID_CACHE_TTL_CONFIG = "missing.id.cache.ttl.sec";
    public static final String MISSING_VERSION_CACHE_TTL_CONFIG = "missing.version.cache.ttl.sec";
    public static final String MISSING_SCHEMA_CACHE_TTL_CONFIG = "missing.schema.cache.ttl.sec";
    public static final String BEARER_AUTH_ISSUER_ENDPOINT_URL = "bearer.auth.issuer.endpoint.url";
    public static final String BEARER_AUTH_CLIENT_ID = "bearer.auth.client.id";
    public static final String BEARER_AUTH_CLIENT_SECRET = "bearer.auth.client.secret";
    public static final String BEARER_AUTH_SCOPE = "bearer.auth.scope";
    public static final String BEARER_AUTH_SCOPE_CLAIM_NAME = "bearer.auth.scope.claim.name";
    public static final String BEARER_AUTH_SCOPE_CLAIM_NAME_DEFAULT = "scope";
    public static final String BEARER_AUTH_SUB_CLAIM_NAME = "bearer.auth.sub.claim.name";
    public static final String BEARER_AUTH_SUB_CLAIM_NAME_DEFAULT = "sub";
    public static final String BEARER_AUTH_LOGICAL_CLUSTER = "bearer.auth.logical.cluster";
    public static final String BEARER_AUTH_IDENTITY_POOL_ID = "bearer.auth.identity.pool.id";
    public static final String BEARER_AUTH_CACHE_EXPIRY_BUFFER_SECONDS = "bearer.auth.cache.expiry.buffer.seconds";
    public static final short BEARER_AUTH_CACHE_EXPIRY_BUFFER_SECONDS_DEFAULT = 300;
    public static final String BEARER_AUTH_CUSTOM_PROVIDER_CLASS = "bearer.auth.custom.provider.class";

    public static void withClientSslSupport(ConfigDef configDef, String namespace) {
        ConfigDef sslConfigDef = new ConfigDef();
        sslConfigDef.withClientSslSupport();
        for (ConfigDef.ConfigKey configKey : sslConfigDef.configKeys().values()) {
            configDef.define(namespace + configKey.name, SchemaRegistryClientConfig.typeFor(configKey.type), configKey.defaultValue, SchemaRegistryClientConfig.importanceFor(configKey.importance), configKey.documentation);
        }
    }

    private static ConfigDef.Type typeFor(ConfigDef.Type type) {
        return ConfigDef.Type.valueOf((String)type.name());
    }

    private static ConfigDef.Importance importanceFor(ConfigDef.Importance importance) {
        return ConfigDef.Importance.valueOf((String)importance.name());
    }

    public static Integer getHttpConnectTimeoutMs(Map<String, ?> configs) {
        if (configs != null && configs.containsKey(HTTP_CONNECT_TIMEOUT_MS)) {
            Object httpConnectTimeoutMsVal = configs.get(HTTP_CONNECT_TIMEOUT_MS);
            return httpConnectTimeoutMsVal instanceof String ? Integer.valueOf((String)httpConnectTimeoutMsVal) : (Integer)httpConnectTimeoutMsVal;
        }
        return 60000;
    }

    public static Integer getHttpReadTimeoutMs(Map<String, ?> configs) {
        if (configs != null && configs.containsKey(HTTP_READ_TIMEOUT_MS)) {
            Object httpReadTimeoutMsVal = configs.get(HTTP_READ_TIMEOUT_MS);
            return httpReadTimeoutMsVal instanceof String ? Integer.valueOf((String)httpReadTimeoutMsVal) : (Integer)httpReadTimeoutMsVal;
        }
        return 60000;
    }

    public static long getMissingIdTTL(Map<String, ?> configs) {
        return configs != null && configs.containsKey(MISSING_ID_CACHE_TTL_CONFIG) ? (Long)configs.get(MISSING_ID_CACHE_TTL_CONFIG) : 0L;
    }

    public static long getMissingVersionTTL(Map<String, ?> configs) {
        return configs != null && configs.containsKey(MISSING_VERSION_CACHE_TTL_CONFIG) ? (Long)configs.get(MISSING_VERSION_CACHE_TTL_CONFIG) : 0L;
    }

    public static long getMissingSchemaTTL(Map<String, ?> configs) {
        return configs != null && configs.containsKey(MISSING_SCHEMA_CACHE_TTL_CONFIG) ? (Long)configs.get(MISSING_SCHEMA_CACHE_TTL_CONFIG) : 0L;
    }

    public static int getMaxMissingCacheSize(Map<String, ?> configs) {
        return configs != null && configs.containsKey(MISSING_CACHE_SIZE_CONFIG) ? (Integer)configs.get(MISSING_CACHE_SIZE_CONFIG) : 10000;
    }

    public static short getBearerAuthCacheExpiryBufferSeconds(Map<String, ?> configs) {
        return configs != null && configs.containsKey(BEARER_AUTH_CACHE_EXPIRY_BUFFER_SECONDS) ? (Short)configs.get(BEARER_AUTH_CACHE_EXPIRY_BUFFER_SECONDS) : (short)300;
    }

    public static String getBearerAuthScopeClaimName(Map<String, ?> configs) {
        return configs != null && configs.containsKey(BEARER_AUTH_SCOPE_CLAIM_NAME) ? (String)configs.get(BEARER_AUTH_SCOPE_CLAIM_NAME) : BEARER_AUTH_SCOPE_CLAIM_NAME_DEFAULT;
    }

    public static String getBearerAuthSubClaimName(Map<String, ?> configs) {
        return configs != null && configs.containsKey(BEARER_AUTH_SUB_CLAIM_NAME) ? (String)configs.get(BEARER_AUTH_SUB_CLAIM_NAME) : BEARER_AUTH_SUB_CLAIM_NAME_DEFAULT;
    }
}

