/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.stanford.nlp.simple;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.value.ValueMetaBoolean;
import org.apache.hop.core.row.value.ValueMetaInteger;
import org.apache.hop.core.row.value.ValueMetaString;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.stanford.nlp.simple.PennTreebankPartOfSpeech;
import org.apache.hop.pipeline.transforms.stanford.nlp.simple.StanfordSimpleNlp;
import org.apache.hop.pipeline.transforms.stanford.nlp.simple.StanfordSimpleNlpData;
import org.w3c.dom.Node;

@Transform(id="StanfordSimpleNlp", image="stanfordnlp.svg", name="i18n::BaseTransform.TypeLongDesc.StanfordSimpleNlp", description="i18n::BaseTransform.TypeTooltipDesc.StanfordSimpleNlp", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Transform", documentationUrl="/pipeline/transforms/stanfordnlp.html")
public class StanfordSimpleNlpMeta
extends BaseTransformMeta<StanfordSimpleNlp, StanfordSimpleNlpData> {
    private static final Class<?> PKG = StanfordSimpleNlpMeta.class;
    private String corpusField;
    private boolean includePartOfSpeech = false;
    private boolean parallelism = false;
    private String outputFieldNamePrefix = "sentence_";

    public void loadXml(Node transformNode, IHopMetadataProvider metadataProvider) throws HopXmlException {
        try {
            this.corpusField = XmlHandler.getTagValue((Node)transformNode, (String)"corpusField");
            this.includePartOfSpeech = StringUtils.equalsIgnoreCase((CharSequence)"Y", (CharSequence)XmlHandler.getTagValue((Node)transformNode, (String)"includePartOfSpeech"));
            this.parallelism = StringUtils.equalsIgnoreCase((CharSequence)"Y", (CharSequence)XmlHandler.getTagValue((Node)transformNode, (String)"parallelism"));
            this.outputFieldNamePrefix = XmlHandler.getTagValue((Node)transformNode, (String)"outputFieldNamePrefix");
        }
        catch (Exception e) {
            throw new HopXmlException(BaseMessages.getString(PKG, (String)"StanfordSimpleNlpMeta.Exception.UnableToReadTransformMeta", (String[])new String[0]), (Throwable)e);
        }
    }

    public void setDefault() {
        this.includePartOfSpeech = false;
        this.parallelism = false;
        this.outputFieldNamePrefix = "sentence_";
    }

    public void getFields(IRowMeta r, String name, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) {
        this.valueMetaString(r, name, this.outputFieldNamePrefix + "text");
        this.valueMetaInteger(r, name, this.outputFieldNamePrefix + "index");
        this.valueMetaInteger(r, name, this.outputFieldNamePrefix + "index_start");
        this.valueMetaInteger(r, name, this.outputFieldNamePrefix + "index_end");
        this.valueMetaInteger(r, name, this.outputFieldNamePrefix + "character_count");
        this.valueMetaInteger(r, name, this.outputFieldNamePrefix + "word_count");
        if (this.includePartOfSpeech) {
            this.valueMetaString(r, name, this.outputFieldNamePrefix + "pos_tagged");
            this.valueMetaString(r, name, this.outputFieldNamePrefix + "pos_tags");
            for (PennTreebankPartOfSpeech e : PennTreebankPartOfSpeech.values()) {
                this.valueMetaInteger(r, name, this.outputFieldNamePrefix + "penn_treebank_pos_" + e.name());
            }
        }
    }

    private void valueMetaString(IRowMeta r, String name, String metaName) {
        ValueMetaString sText = new ValueMetaString(metaName);
        sText.setOrigin(name);
        r.addValueMeta((IValueMeta)sText);
    }

    private void valueMetaBoolean(IRowMeta r, String name, String metaName) {
        ValueMetaBoolean sText = new ValueMetaBoolean(metaName);
        sText.setOrigin(name);
        r.addValueMeta((IValueMeta)sText);
    }

    private void valueMetaInteger(IRowMeta r, String name, String metaName) {
        ValueMetaInteger sText = new ValueMetaInteger(metaName);
        sText.setOrigin(name);
        r.addValueMeta((IValueMeta)sText);
    }

    public String getXml() {
        return "    " + XmlHandler.addTagValue((String)"corpusField", (String)this.corpusField) + "    " + XmlHandler.addTagValue((String)"includePartOfSpeech", (boolean)this.includePartOfSpeech) + "    " + XmlHandler.addTagValue((String)"parallelism", (boolean)this.parallelism) + "    " + XmlHandler.addTagValue((String)"outputFieldNamePrefix", (String)this.outputFieldNamePrefix);
    }

    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        CheckResult cr = Utils.isEmpty((CharSequence)this.corpusField) ? new CheckResult(4, BaseMessages.getString(PKG, (String)"StanfordSimpleNlpMeta.CheckResult.CorpusFieldMissing", (String[])new String[0]), (ICheckResultSource)transformMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"StanfordSimpleNlpMeta.CheckResult.CorpusFieldOK", (String[])new String[0]), (ICheckResultSource)transformMeta);
        remarks.add((ICheckResult)cr);
        cr = input.length > 0 ? new CheckResult(1, BaseMessages.getString(PKG, (String)"StanfordSimpleNlpMeta.CheckResult.ReceivingInfoFromOtherTransforms", (String[])new String[0]), (ICheckResultSource)transformMeta) : new CheckResult(4, BaseMessages.getString(PKG, (String)"StanfordSimpleNlpMeta.CheckResult.NoInpuReceived", (String[])new String[0]), (ICheckResultSource)transformMeta);
        remarks.add((ICheckResult)cr);
    }

    public boolean supportsErrorHandling() {
        return true;
    }

    public String getCorpusField() {
        return this.corpusField;
    }

    public void setCorpusField(String corpusField) {
        this.corpusField = corpusField;
    }

    public boolean isIncludePartOfSpeech() {
        return this.includePartOfSpeech;
    }

    public void setIncludePartOfSpeech(boolean includePartOfSpeech) {
        this.includePartOfSpeech = includePartOfSpeech;
    }

    public boolean isParallelism() {
        return this.parallelism;
    }

    public void setParallelism(boolean parallelism) {
        this.parallelism = parallelism;
    }

    public String getOutputFieldNamePrefix() {
        return this.outputFieldNamePrefix;
    }

    public void setOutputFieldNamePrefix(String outputFieldNamePrefix) {
        this.outputFieldNamePrefix = outputFieldNamePrefix;
    }
}

