/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.file.datalake.specialized;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.RequestConditions;
import com.azure.core.http.rest.Response;
import com.azure.core.util.FluxUtil;
import com.azure.storage.blob.specialized.BlobLeaseAsyncClient;
import com.azure.storage.file.datalake.implementation.util.DataLakeImplUtils;
import com.azure.storage.file.datalake.specialized.DataLakeLeaseClientBuilder;
import reactor.core.publisher.Mono;

@ServiceClient(builder=DataLakeLeaseClientBuilder.class, isAsync=true)
public final class DataLakeLeaseAsyncClient {
    private final BlobLeaseAsyncClient blobLeaseAsyncClient;

    DataLakeLeaseAsyncClient(BlobLeaseAsyncClient blobLeaseAsyncClient) {
        this.blobLeaseAsyncClient = blobLeaseAsyncClient;
    }

    public String getResourceUrl() {
        return this.blobLeaseAsyncClient.getResourceUrl();
    }

    public String getLeaseId() {
        return this.blobLeaseAsyncClient.getLeaseId();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<String> acquireLease(int durationInSeconds) {
        return this.acquireLeaseWithResponse(durationInSeconds, null).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<String>> acquireLeaseWithResponse(int durationInSeconds, RequestConditions modifiedRequestConditions) {
        return this.blobLeaseAsyncClient.acquireLeaseWithResponse(durationInSeconds, modifiedRequestConditions).onErrorMap(DataLakeImplUtils::transformBlobStorageException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<String> renewLease() {
        return this.renewLeaseWithResponse(null).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<String>> renewLeaseWithResponse(RequestConditions modifiedRequestConditions) {
        return this.blobLeaseAsyncClient.renewLeaseWithResponse(modifiedRequestConditions).onErrorMap(DataLakeImplUtils::transformBlobStorageException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> releaseLease() {
        return this.releaseLeaseWithResponse(null).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> releaseLeaseWithResponse(RequestConditions modifiedRequestConditions) {
        return this.blobLeaseAsyncClient.releaseLeaseWithResponse(modifiedRequestConditions).onErrorMap(DataLakeImplUtils::transformBlobStorageException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Integer> breakLease() {
        return this.breakLeaseWithResponse(null, null).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Integer>> breakLeaseWithResponse(Integer breakPeriodInSeconds, RequestConditions modifiedRequestConditions) {
        return this.blobLeaseAsyncClient.breakLeaseWithResponse(breakPeriodInSeconds, modifiedRequestConditions).onErrorMap(DataLakeImplUtils::transformBlobStorageException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<String> changeLease(String proposedId) {
        return this.changeLeaseWithResponse(proposedId, null).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<String>> changeLeaseWithResponse(String proposedId, RequestConditions modifiedRequestConditions) {
        return this.blobLeaseAsyncClient.changeLeaseWithResponse(proposedId, modifiedRequestConditions).onErrorMap(DataLakeImplUtils::transformBlobStorageException);
    }

    public String getAccountName() {
        return this.blobLeaseAsyncClient.getAccountName();
    }
}

