/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.marshal;

import java.nio.ByteBuffer;
import org.apache.cassandra.cql3.CQL3Type;
import org.apache.cassandra.cql3.Constants;
import org.apache.cassandra.cql3.Term;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.ValueAccessor;
import org.apache.cassandra.serializers.BooleanSerializer;
import org.apache.cassandra.serializers.MarshalException;
import org.apache.cassandra.serializers.TypeSerializer;
import org.apache.cassandra.transport.ProtocolVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BooleanType
extends AbstractType<Boolean> {
    private static final Logger logger = LoggerFactory.getLogger(BooleanType.class);
    public static final BooleanType instance = new BooleanType();

    BooleanType() {
        super(AbstractType.ComparisonType.CUSTOM);
    }

    @Override
    public boolean isEmptyValueMeaningless() {
        return true;
    }

    @Override
    public <VL, VR> int compareCustom(VL left, ValueAccessor<VL> accessorL, VR right, ValueAccessor<VR> accessorR) {
        if (accessorL.isEmpty(left) || accessorR.isEmpty(right)) {
            return Boolean.compare(accessorR.isEmpty(right), accessorL.isEmpty(left));
        }
        int v1 = accessorL.getByte(left, 0) == 0 ? 0 : 1;
        int v2 = accessorR.getByte(right, 0) == 0 ? 0 : 1;
        return v1 - v2;
    }

    @Override
    public ByteBuffer fromString(String source) throws MarshalException {
        if (source.isEmpty() || source.equalsIgnoreCase(Boolean.FALSE.toString())) {
            return this.decompose(false);
        }
        if (source.equalsIgnoreCase(Boolean.TRUE.toString())) {
            return this.decompose(true);
        }
        throw new MarshalException(String.format("Unable to make boolean from '%s'", source));
    }

    @Override
    public Term fromJSONObject(Object parsed) throws MarshalException {
        if (parsed instanceof String) {
            return new Constants.Value(this.fromString((String)parsed));
        }
        if (!(parsed instanceof Boolean)) {
            throw new MarshalException(String.format("Expected a boolean value, but got a %s: %s", parsed.getClass().getSimpleName(), parsed));
        }
        return new Constants.Value(this.getSerializer().serialize((Boolean)parsed));
    }

    @Override
    public String toJSONString(ByteBuffer buffer, ProtocolVersion protocolVersion) {
        return this.getSerializer().deserialize(buffer).toString();
    }

    @Override
    public CQL3Type asCQL3Type() {
        return CQL3Type.Native.BOOLEAN;
    }

    @Override
    public TypeSerializer<Boolean> getSerializer() {
        return BooleanSerializer.instance;
    }

    @Override
    public int valueLengthIfFixed() {
        return 1;
    }
}

