/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.statements.schema;

import org.apache.cassandra.audit.AuditLogContext;
import org.apache.cassandra.audit.AuditLogEntryType;
import org.apache.cassandra.auth.Permission;
import org.apache.cassandra.cql3.CQLStatement;
import org.apache.cassandra.cql3.QualifiedName;
import org.apache.cassandra.cql3.statements.schema.AlterSchemaStatement;
import org.apache.cassandra.schema.KeyspaceMetadata;
import org.apache.cassandra.schema.Keyspaces;
import org.apache.cassandra.schema.Schema;
import org.apache.cassandra.schema.ViewMetadata;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.transport.Event;

public final class DropViewStatement
extends AlterSchemaStatement {
    private final String viewName;
    private final boolean ifExists;

    public DropViewStatement(String keyspaceName, String viewName, boolean ifExists) {
        super(keyspaceName);
        this.viewName = viewName;
        this.ifExists = ifExists;
    }

    @Override
    public Keyspaces apply(Keyspaces schema) {
        ViewMetadata view;
        KeyspaceMetadata keyspace = schema.getNullable(this.keyspaceName);
        ViewMetadata viewMetadata = view = null == keyspace ? null : keyspace.views.getNullable(this.viewName);
        if (null == view) {
            if (this.ifExists) {
                return schema;
            }
            throw DropViewStatement.ire("Materialized view '%s.%s' doesn't exist", this.keyspaceName, this.viewName);
        }
        return schema.withAddedOrUpdated(keyspace.withSwapped(keyspace.views.without(this.viewName)));
    }

    @Override
    Event.SchemaChange schemaChangeEvent(Keyspaces.KeyspacesDiff diff) {
        return new Event.SchemaChange(Event.SchemaChange.Change.DROPPED, Event.SchemaChange.Target.TABLE, this.keyspaceName, this.viewName);
    }

    @Override
    public void authorize(ClientState client) {
        ViewMetadata view = Schema.instance.getView(this.keyspaceName, this.viewName);
        if (null != view) {
            client.ensureTablePermission(this.keyspaceName, view.baseTableName, Permission.ALTER);
        }
    }

    @Override
    public AuditLogContext getAuditLogContext() {
        return new AuditLogContext(AuditLogEntryType.DROP_VIEW, this.keyspaceName, this.viewName);
    }

    public String toString() {
        return String.format("%s (%s, %s)", this.getClass().getSimpleName(), this.keyspaceName, this.viewName);
    }

    public static final class Raw
    extends CQLStatement.Raw {
        private final QualifiedName name;
        private final boolean ifExists;

        public Raw(QualifiedName name, boolean ifExists) {
            this.name = name;
            this.ifExists = ifExists;
        }

        @Override
        public DropViewStatement prepare(ClientState state) {
            String keyspaceName = this.name.hasKeyspace() ? this.name.getKeyspace() : state.getKeyspace();
            return new DropViewStatement(keyspaceName, this.name.getName(), this.ifExists);
        }
    }
}

