/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.statements;

import java.util.Set;
import java.util.stream.Collectors;
import org.apache.cassandra.audit.AuditLogContext;
import org.apache.cassandra.audit.AuditLogEntryType;
import org.apache.cassandra.auth.IAuthorizer;
import org.apache.cassandra.auth.IResource;
import org.apache.cassandra.auth.Permission;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.cql3.RoleName;
import org.apache.cassandra.cql3.statements.PermissionsManagementStatement;
import org.apache.cassandra.exceptions.RequestExecutionException;
import org.apache.cassandra.exceptions.RequestValidationException;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.service.ClientWarn;
import org.apache.cassandra.transport.messages.ResultMessage;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public class RevokePermissionsStatement
extends PermissionsManagementStatement {
    public RevokePermissionsStatement(Set<Permission> permissions, IResource resource, RoleName grantee) {
        super(permissions, resource, grantee);
    }

    @Override
    public ResultMessage execute(ClientState state) throws RequestValidationException, RequestExecutionException {
        IAuthorizer authorizer = DatabaseDescriptor.getAuthorizer();
        Set<Permission> revoked = authorizer.revoke(state.getUser(), this.permissions, this.resource, this.grantee);
        if (!revoked.equals(this.permissions) && !this.permissions.equals(Permission.ALL)) {
            String permissionsStr = this.permissions.stream().filter(permission -> !revoked.contains(permission)).sorted(Enum::compareTo).map(Enum::name).collect(Collectors.joining(", "));
            ClientWarn.instance.warn(String.format("Role '%s' was not granted %s on %s", this.grantee.getRoleName(), permissionsStr, this.resource));
        }
        return null;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }

    @Override
    public AuditLogContext getAuditLogContext() {
        String keyspace = this.resource.hasParent() ? this.resource.getParent().getName() : this.resource.getName();
        return new AuditLogContext(AuditLogEntryType.REVOKE, keyspace, this.resource.getName());
    }
}

