/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms;

import java.io.Serializable;
import java.util.Comparator;
import org.apache.beam.sdk.transforms.Combine;
import org.apache.beam.sdk.transforms.Top;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class Min {
    private Min() {
    }

    public static @UnknownKeyFor @NonNull @Initialized Combine.Globally<@UnknownKeyFor @NonNull @Initialized Integer, @UnknownKeyFor @NonNull @Initialized Integer> integersGlobally() {
        return Combine.globally(new MinIntegerFn());
    }

    public static <K> @UnknownKeyFor @NonNull @Initialized Combine.PerKey<K, @UnknownKeyFor @NonNull @Initialized Integer, @UnknownKeyFor @NonNull @Initialized Integer> integersPerKey() {
        return Combine.perKey(new MinIntegerFn());
    }

    public static @UnknownKeyFor @NonNull @Initialized Combine.Globally<@UnknownKeyFor @NonNull @Initialized Long, @UnknownKeyFor @NonNull @Initialized Long> longsGlobally() {
        return Combine.globally(new MinLongFn());
    }

    public static <K> @UnknownKeyFor @NonNull @Initialized Combine.PerKey<K, @UnknownKeyFor @NonNull @Initialized Long, @UnknownKeyFor @NonNull @Initialized Long> longsPerKey() {
        return Combine.perKey(new MinLongFn());
    }

    public static @UnknownKeyFor @NonNull @Initialized Combine.Globally<@UnknownKeyFor @NonNull @Initialized Double, @UnknownKeyFor @NonNull @Initialized Double> doublesGlobally() {
        return Combine.globally(new MinDoubleFn());
    }

    public static <K> @UnknownKeyFor @NonNull @Initialized Combine.PerKey<K, @UnknownKeyFor @NonNull @Initialized Double, @UnknownKeyFor @NonNull @Initialized Double> doublesPerKey() {
        return Combine.perKey(new MinDoubleFn());
    }

    public static @UnknownKeyFor @NonNull @Initialized Combine.BinaryCombineIntegerFn ofIntegers() {
        return new MinIntegerFn();
    }

    public static @UnknownKeyFor @NonNull @Initialized Combine.BinaryCombineLongFn ofLongs() {
        return new MinLongFn();
    }

    public static @UnknownKeyFor @NonNull @Initialized Combine.BinaryCombineDoubleFn ofDoubles() {
        return new MinDoubleFn();
    }

    public static <T, ComparatorT extends Comparator<? super T> & Serializable> @UnknownKeyFor @NonNull @Initialized Combine.BinaryCombineFn<T> of(T identity, ComparatorT comparator) {
        return new MinFn(identity, comparator, null);
    }

    public static <T, ComparatorT extends Comparator<? super T> & Serializable> @UnknownKeyFor @NonNull @Initialized Combine.BinaryCombineFn<T> of(ComparatorT comparator) {
        return new MinFn(null, comparator, null);
    }

    public static <T extends Comparable<? super T>> @UnknownKeyFor @NonNull @Initialized Combine.BinaryCombineFn<T> naturalOrder(T identity) {
        return new MinFn(identity, new Top.Natural(), null);
    }

    public static <T extends Comparable<? super T>> @UnknownKeyFor @NonNull @Initialized Combine.BinaryCombineFn<T> naturalOrder() {
        return new MinFn(null, new Top.Natural(), null);
    }

    public static <T extends Comparable<? super T>> @UnknownKeyFor @NonNull @Initialized Combine.Globally<T, T> globally() {
        return Combine.globally(Min.naturalOrder());
    }

    public static <K, T extends Comparable<? super T>> @UnknownKeyFor @NonNull @Initialized Combine.PerKey<K, T, T> perKey() {
        return Combine.perKey(Min.naturalOrder());
    }

    public static <T, ComparatorT extends Comparator<? super T> & Serializable> @UnknownKeyFor @NonNull @Initialized Combine.Globally<T, T> globally(ComparatorT comparator) {
        return Combine.globally(Min.of(comparator));
    }

    public static <K, T, ComparatorT extends Comparator<? super T> & Serializable> @UnknownKeyFor @NonNull @Initialized Combine.PerKey<K, T, T> perKey(ComparatorT comparator) {
        return Combine.perKey(Min.of(comparator));
    }

    private static class MinDoubleFn
    extends Combine.BinaryCombineDoubleFn {
        private MinDoubleFn() {
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized double apply(@UnknownKeyFor @NonNull @Initialized double left, @UnknownKeyFor @NonNull @Initialized double right) {
            return Math.min(left, right);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized double identity() {
            return Double.POSITIVE_INFINITY;
        }
    }

    private static class MinLongFn
    extends Combine.BinaryCombineLongFn {
        private MinLongFn() {
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized long apply(@UnknownKeyFor @NonNull @Initialized long left, @UnknownKeyFor @NonNull @Initialized long right) {
            return Math.min(left, right);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized long identity() {
            return Long.MAX_VALUE;
        }
    }

    private static class MinIntegerFn
    extends Combine.BinaryCombineIntegerFn {
        private MinIntegerFn() {
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized int apply(@UnknownKeyFor @NonNull @Initialized int left, @UnknownKeyFor @NonNull @Initialized int right) {
            return Math.min(left, right);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized int identity() {
            return Integer.MAX_VALUE;
        }
    }

    private static class MinFn<@UnknownKeyFor T>
    extends Combine.BinaryCombineFn<T> {
        private final @Nullable T identity;
        private final @UnknownKeyFor @NonNull @Initialized Comparator<@UnknownKeyFor @Nullable @Initialized ? super T> comparator;

        private <ComparatorT extends Comparator<? super T> & Serializable> MinFn(@Nullable T identity, ComparatorT comparator) {
            this.identity = identity;
            this.comparator = comparator;
        }

        @Override
        public T identity() {
            return this.identity;
        }

        @Override
        public T apply(T left, T right) {
            return this.comparator.compare(left, right) <= 0 ? left : right;
        }

        @Override
        public void populateDisplayData(@UnknownKeyFor @NonNull @Initialized DisplayData.Builder builder) {
            super.populateDisplayData(builder);
            builder.add(DisplayData.item("comparer", this.comparator.getClass()).withLabel("Record Comparer"));
        }

        /* synthetic */ MinFn(Object x0, Comparator x1, 1 x2) {
            this(x0, x1);
        }
    }
}

