/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.testing;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Map;
import org.apache.beam.sdk.util.Preconditions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeMatcher;

public abstract class JsonMatcher<@UnknownKeyFor T>
extends TypeSafeMatcher<T> {
    private final @UnknownKeyFor @NonNull @Initialized Matcher<@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object>> mapMatcher;
    private static final @UnknownKeyFor @NonNull @Initialized ObjectMapper MAPPER = new ObjectMapper();
    private @MonotonicNonNull @UnknownKeyFor @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> actualMap;

    public JsonMatcher(@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> expectedMap) {
        this.mapMatcher = Matchers.is(expectedMap);
    }

    protected abstract @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> parse(T var1) throws @UnknownKeyFor @NonNull @Initialized IOException;

    public static @UnknownKeyFor @NonNull @Initialized Matcher<@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized []> jsonBytesLike(@UnknownKeyFor @NonNull @Initialized String json) throws @UnknownKeyFor @NonNull @Initialized IOException {
        Map fields = (Map)MAPPER.readValue(json, (TypeReference)new TypeReference<Map<String, Object>>(){});
        return JsonMatcher.jsonBytesLike(fields);
    }

    public static @UnknownKeyFor @NonNull @Initialized Matcher<@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized []> jsonBytesLike(@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> fields) throws @UnknownKeyFor @NonNull @Initialized IOException {
        return new JsonMatcher<byte[]>(fields){

            @Override
            protected @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> parse(@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] json) throws @UnknownKeyFor @NonNull @Initialized IOException {
                return (Map)MAPPER.readValue(json, (TypeReference)new TypeReference<Map<String, Object>>(){});
            }
        };
    }

    public static @UnknownKeyFor @NonNull @Initialized Matcher<@UnknownKeyFor @NonNull @Initialized String> jsonStringLike(@UnknownKeyFor @NonNull @Initialized String json) throws @UnknownKeyFor @NonNull @Initialized IOException {
        Map fields = (Map)MAPPER.readValue(json, (TypeReference)new TypeReference<Map<String, Object>>(){});
        return JsonMatcher.jsonStringLike(fields);
    }

    public static @UnknownKeyFor @NonNull @Initialized Matcher<@UnknownKeyFor @NonNull @Initialized String> jsonStringLike(@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> fields) throws @UnknownKeyFor @NonNull @Initialized IOException {
        return new JsonMatcher<String>(fields){

            @Override
            protected @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> parse(@UnknownKeyFor @NonNull @Initialized String json) throws @UnknownKeyFor @NonNull @Initialized IOException {
                return (Map)MAPPER.readValue(json, (TypeReference)new TypeReference<Map<String, Object>>(){});
            }
        };
    }

    protected @UnknownKeyFor @NonNull @Initialized boolean matchesSafely(T actual) {
        try {
            this.actualMap = this.parse(actual);
        }
        catch (IOException e) {
            return false;
        }
        return this.mapMatcher.matches(Preconditions.checkStateNotNull(this.actualMap));
    }

    public void describeTo(@UnknownKeyFor @NonNull @Initialized Description description) {
        this.mapMatcher.describeTo(description);
    }

    protected void describeMismatchSafely(T item, @UnknownKeyFor @NonNull @Initialized Description mismatchDescription) {
        this.mapMatcher.describeMismatch(Preconditions.checkStateNotNull(this.actualMap), mismatchDescription);
    }
}

