/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.api.data_formats;

import com.clickhouse.client.api.ClientException;
import com.clickhouse.client.api.data_formats.internal.AbstractBinaryFormatReader;
import com.clickhouse.client.api.data_formats.internal.BinaryStreamReader;
import com.clickhouse.client.api.metadata.TableSchema;
import com.clickhouse.client.api.query.QuerySettings;
import com.clickhouse.data.ClickHouseColumn;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;

public class RowBinaryWithNamesAndTypesFormatReader
extends AbstractBinaryFormatReader
implements Iterator<Map<String, Object>> {
    public RowBinaryWithNamesAndTypesFormatReader(InputStream inputStream, QuerySettings querySettings, BinaryStreamReader.ByteBufferAllocator byteBufferAllocator) {
        super(inputStream, querySettings, null, byteBufferAllocator);
        this.readSchema();
    }

    private void readSchema() {
        try {
            int nCol;
            ArrayList<String> names = new ArrayList<String>();
            try {
                nCol = BinaryStreamReader.readVarInt(this.input);
            }
            catch (EOFException e) {
                this.endReached();
                return;
            }
            for (int i = 0; i < nCol; ++i) {
                names.add(this.binaryStreamReader.readString());
            }
            ArrayList<ClickHouseColumn> columns = new ArrayList<ClickHouseColumn>(nCol);
            for (int i = 0; i < nCol; ++i) {
                columns.add(ClickHouseColumn.of((String)names.get(i), this.binaryStreamReader.readString()));
            }
            TableSchema schema = new TableSchema(columns);
            this.setSchema(schema);
        }
        catch (IOException e) {
            throw new ClientException("Failed to read header", e);
        }
    }
}

