/*
 * Decompiled with CFR 0.152.
 */
package org.kie.internal.runtime.conf;

import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;
import org.kie.internal.runtime.conf.ObjectModelResolver;

public class ObjectModelResolverProvider {
    private static ServiceLoader<ObjectModelResolver> serviceLoader = ServiceLoader.load(ObjectModelResolver.class);
    private static List<ObjectModelResolver> resolvers;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<ObjectModelResolver> getResolvers() {
        if (resolvers == null) {
            ServiceLoader<ObjectModelResolver> serviceLoader = ObjectModelResolverProvider.serviceLoader;
            synchronized (serviceLoader) {
                if (resolvers == null) {
                    ArrayList<ObjectModelResolver> foundResolvers = new ArrayList<ObjectModelResolver>();
                    for (ObjectModelResolver resolver : ObjectModelResolverProvider.serviceLoader) {
                        foundResolvers.add(resolver);
                    }
                    resolvers = foundResolvers;
                }
            }
        }
        return resolvers;
    }

    public static ObjectModelResolver get(String resolverId) {
        List<ObjectModelResolver> resolvers = ObjectModelResolverProvider.getResolvers();
        for (ObjectModelResolver resolver : resolvers) {
            if (!resolver.accept(resolverId)) continue;
            return resolver;
        }
        return null;
    }
}

