/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.pubsublite.internal;

import com.google.cloud.pubsublite.proto.AttributeValues;
import com.google.cloud.pubsublite.proto.PubSubMessage;
import org.apache.beam.sdk.io.gcp.pubsublite.internal.Uuid;
import org.apache.beam.sdk.transforms.MapElements;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.Reshuffle;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class AddUuidsTransform
extends PTransform<PCollection<PubSubMessage>, PCollection<PubSubMessage>> {
    private static @UnknownKeyFor @NonNull @Initialized PubSubMessage addUuid(@UnknownKeyFor @NonNull @Initialized PubSubMessage message) {
        PubSubMessage.Builder builder = message.toBuilder();
        builder.putAttributes("x-goog-pubsublite-dataflow-uuid", AttributeValues.newBuilder().addValues(Uuid.random().value()).build());
        return builder.build();
    }

    public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized PubSubMessage> expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized PubSubMessage> input) {
        PCollection withUuids = (PCollection)input.apply("AddUuids", (PTransform)MapElements.into((TypeDescriptor)new TypeDescriptor<PubSubMessage>(){}).via(AddUuidsTransform::addUuid));
        return (PCollection)withUuids.apply("ShuffleToPersist", (PTransform)Reshuffle.viaRandomKey().withNumBuckets(Integer.valueOf(1000)));
    }
}

