/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.beam.core.transform;

import org.apache.hop.core.row.IValueMeta;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.common.serialization.DoubleDeserializer;
import org.apache.kafka.common.serialization.DoubleSerializer;
import org.apache.kafka.common.serialization.LongDeserializer;
import org.apache.kafka.common.serialization.LongSerializer;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.kafka.common.serialization.StringSerializer;

public enum SerializerType {
    String("String", 2, StringSerializer.class.getName(), StringDeserializer.class.getName()),
    Integer("Integer", 5, LongSerializer.class.getName(), LongDeserializer.class.getName()),
    Binary("Binary", 8, ByteArraySerializer.class.getName(), ByteArrayDeserializer.class.getName()),
    Number("Number", 1, DoubleSerializer.class.getName(), DoubleDeserializer.class.getName()),
    Avro("Avro", 20, "io.confluent.kafka.serializers.KafkaAvroSerializer", "io.confluent.kafka.serializers.KafkaAvroDeserializer");

    private final String value;
    private final int valueMetaInterfaceType;
    private String kafkaSerializerClass;
    private String kafkaDeserializerClass;

    private SerializerType(String value, int valueMetaInterfaceType, String kafkaSerializerClass, String kafkaDeserializerClass) {
        this.value = value;
        this.valueMetaInterfaceType = valueMetaInterfaceType;
        this.kafkaSerializerClass = kafkaSerializerClass;
        this.kafkaDeserializerClass = kafkaDeserializerClass;
    }

    public String toString() {
        return this.value;
    }

    boolean isEqual(String value) {
        return this.value.equals(value);
    }

    public int getIValueMetaType() {
        return this.valueMetaInterfaceType;
    }

    public String getKafkaSerializerClass() {
        return this.kafkaSerializerClass;
    }

    public String getKafkaDeserializerClass() {
        return this.kafkaDeserializerClass;
    }

    public static SerializerType fromValueMeta(IValueMeta vmi) {
        if (vmi != null) {
            for (SerializerType t : SerializerType.values()) {
                if (vmi.getType() != t.getIValueMetaType()) continue;
                return t;
            }
            throw new IllegalArgumentException("There is no known serializer type for value " + vmi.getName() + " and type " + vmi.getType());
        }
        return String;
    }
}

