/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.teamlog;

import com.dropbox.core.stone.StoneDeserializerLogger;
import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class GeoLocationLogInfo {
    @Nullable
    protected final String city;
    @Nullable
    protected final String region;
    @Nullable
    protected final String country;
    @Nonnull
    protected final String ipAddress;

    public GeoLocationLogInfo(@Nonnull String ipAddress, @Nullable String city, @Nullable String region, @Nullable String country) {
        this.city = city;
        this.region = region;
        this.country = country;
        if (ipAddress == null) {
            throw new IllegalArgumentException("Required value for 'ipAddress' is null");
        }
        this.ipAddress = ipAddress;
    }

    public GeoLocationLogInfo(@Nonnull String ipAddress) {
        this(ipAddress, null, null, null);
    }

    @Nonnull
    public String getIpAddress() {
        return this.ipAddress;
    }

    @Nullable
    public String getCity() {
        return this.city;
    }

    @Nullable
    public String getRegion() {
        return this.region;
    }

    @Nullable
    public String getCountry() {
        return this.country;
    }

    public static Builder newBuilder(String ipAddress) {
        return new Builder(ipAddress);
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.city, this.region, this.country, this.ipAddress});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            GeoLocationLogInfo other = (GeoLocationLogInfo)obj;
            return (this.ipAddress == other.ipAddress || this.ipAddress.equals(other.ipAddress)) && (this.city == other.city || this.city != null && this.city.equals(other.city)) && (this.region == other.region || this.region != null && this.region.equals(other.region)) && (this.country == other.country || this.country != null && this.country.equals(other.country));
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends StructSerializer<GeoLocationLogInfo> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(GeoLocationLogInfo value, JsonGenerator g, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g.writeStartObject();
            }
            g.writeFieldName("ip_address");
            StoneSerializers.string().serialize(value.ipAddress, g);
            if (value.city != null) {
                g.writeFieldName("city");
                StoneSerializers.nullable(StoneSerializers.string()).serialize(value.city, g);
            }
            if (value.region != null) {
                g.writeFieldName("region");
                StoneSerializers.nullable(StoneSerializers.string()).serialize(value.region, g);
            }
            if (value.country != null) {
                g.writeFieldName("country");
                StoneSerializers.nullable(StoneSerializers.string()).serialize(value.country, g);
            }
            if (!collapse) {
                g.writeEndObject();
            }
        }

        @Override
        public GeoLocationLogInfo deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            String f_country;
            String f_region;
            String f_city;
            String f_ipAddress;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                f_ipAddress = null;
                f_city = null;
                f_region = null;
                f_country = null;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("ip_address".equals(field)) {
                        f_ipAddress = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    if ("city".equals(field)) {
                        f_city = StoneSerializers.nullable(StoneSerializers.string()).deserialize(p);
                        continue;
                    }
                    if ("region".equals(field)) {
                        f_region = StoneSerializers.nullable(StoneSerializers.string()).deserialize(p);
                        continue;
                    }
                    if ("country".equals(field)) {
                        f_country = StoneSerializers.nullable(StoneSerializers.string()).deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
                if (f_ipAddress == null) {
                    throw new JsonParseException(p, "Required field \"ip_address\" missing.");
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            GeoLocationLogInfo value = new GeoLocationLogInfo(f_ipAddress, f_city, f_region, f_country);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            StoneDeserializerLogger.log(value, value.toStringMultiline());
            return value;
        }
    }

    public static class Builder {
        protected final String ipAddress;
        protected String city;
        protected String region;
        protected String country;

        protected Builder(String ipAddress) {
            if (ipAddress == null) {
                throw new IllegalArgumentException("Required value for 'ipAddress' is null");
            }
            this.ipAddress = ipAddress;
            this.city = null;
            this.region = null;
            this.country = null;
        }

        public Builder withCity(String city) {
            this.city = city;
            return this;
        }

        public Builder withRegion(String region) {
            this.region = region;
            return this;
        }

        public Builder withCountry(String country) {
            this.country = country;
            return this;
        }

        public GeoLocationLogInfo build() {
            return new GeoLocationLogInfo(this.ipAddress, this.city, this.region, this.country);
        }
    }
}

