/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service.reads;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import org.apache.cassandra.db.ReadCommand;
import org.apache.cassandra.db.ReadResponse;
import org.apache.cassandra.db.SinglePartitionReadCommand;
import org.apache.cassandra.db.partitions.PartitionIterator;
import org.apache.cassandra.db.partitions.UnfilteredPartitionIterators;
import org.apache.cassandra.locator.Endpoints;
import org.apache.cassandra.locator.InetAddressAndPort;
import org.apache.cassandra.locator.Replica;
import org.apache.cassandra.locator.ReplicaPlan;
import org.apache.cassandra.net.Message;
import org.apache.cassandra.service.reads.DataResolver;
import org.apache.cassandra.service.reads.ResponseResolver;
import org.apache.cassandra.service.reads.repair.NoopReadRepair;
import org.apache.cassandra.transport.Dispatcher;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.Clock;

public class DigestResolver<E extends Endpoints<E>, P extends ReplicaPlan.ForRead<E, P>>
extends ResponseResolver<E, P> {
    private volatile Message<ReadResponse> dataResponse;

    public DigestResolver(ReadCommand command, ReplicaPlan.Shared<E, P> replicaPlan, Dispatcher.RequestTime requestTime) {
        super(command, replicaPlan, requestTime);
        Preconditions.checkArgument((boolean)(command instanceof SinglePartitionReadCommand), (Object)"DigestResolver can only be used with SinglePartitionReadCommand commands");
    }

    @Override
    public void preprocess(Message<ReadResponse> message) {
        super.preprocess(message);
        Replica replica = this.replicaPlan().lookup(message.from());
        if (this.dataResponse == null && !((ReadResponse)message.payload).isDigestResponse() && replica.isFull()) {
            this.dataResponse = message;
        }
    }

    @VisibleForTesting
    public boolean hasTransientResponse() {
        return this.hasTransientResponse(this.responses.snapshot());
    }

    private boolean hasTransientResponse(Collection<Message<ReadResponse>> responses) {
        return Iterables.any(responses, msg -> !((ReadResponse)msg.payload).isDigestResponse() && this.replicaPlan().lookup(msg.from()).isTransient());
    }

    public PartitionIterator getData() {
        Collection<Message<ReadResponse>> responses = this.responses.snapshot();
        if (!this.hasTransientResponse(responses)) {
            return UnfilteredPartitionIterators.filter(((ReadResponse)this.dataResponse.payload).makeIterator(this.command), this.command.nowInSec());
        }
        DataResolver dataResolver = new DataResolver(this.command, this.replicaPlan, NoopReadRepair.instance, this.requestTime);
        dataResolver.preprocess(this.dataResponse);
        for (Message<ReadResponse> response : responses) {
            Replica replica = this.replicaPlan().lookup(response.from());
            if (!replica.isTransient()) continue;
            dataResolver.preprocess(response);
        }
        return dataResolver.resolve();
    }

    public boolean responsesMatch() {
        long start = Clock.Global.nanoTime();
        ByteBuffer digest = null;
        Collection snapshot = this.responses.snapshot();
        assert (snapshot.size() > 0) : "Attempted response match comparison while no responses have been received.";
        if (snapshot.size() == 1) {
            return true;
        }
        for (Message message : snapshot) {
            if (this.replicaPlan().lookup(message.from()).isTransient()) continue;
            ByteBuffer newDigest = ((ReadResponse)message.payload).digest(this.command);
            if (digest == null) {
                digest = newDigest;
                continue;
            }
            if (digest.equals(newDigest)) continue;
            return false;
        }
        if (logger.isTraceEnabled()) {
            logger.trace("responsesMatch: {} ms.", (Object)TimeUnit.NANOSECONDS.toMillis(Clock.Global.nanoTime() - start));
        }
        return true;
    }

    @Override
    public boolean isDataPresent() {
        return this.dataResponse != null;
    }

    public DigestResolverDebugResult[] getDigestsByEndpoint() {
        DigestResolverDebugResult[] ret = new DigestResolverDebugResult[this.responses.size()];
        for (int i = 0; i < this.responses.size(); ++i) {
            Message message = (Message)this.responses.get(i);
            ReadResponse response = (ReadResponse)message.payload;
            String digestHex = ByteBufferUtil.bytesToHex(response.digest(this.command));
            ret[i] = new DigestResolverDebugResult(message.from(), digestHex, ((ReadResponse)message.payload).isDigestResponse());
        }
        return ret;
    }

    public static class DigestResolverDebugResult {
        public InetAddressAndPort from;
        public String digestHex;
        public boolean isDigestResponse;

        private DigestResolverDebugResult(InetAddressAndPort from, String digestHex, boolean isDigestResponse) {
            this.from = from;
            this.digestHex = digestHex;
            this.isDigestResponse = isDigestResponse;
        }
    }
}

