/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.avro.apacheimpl;

import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.dataformat.avro.deser.AvroParserImpl;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.apache.avro.io.Decoder;
import org.apache.avro.util.Utf8;

public class DecoderOverAvroParser
extends Decoder {
    protected final AvroParserImpl _parser;

    public DecoderOverAvroParser(AvroParserImpl parser) {
        this._parser = parser;
    }

    protected JsonToken consumeToken(JsonToken ... expectedTokens) throws IOException {
        JsonToken token = this.nextValue();
        for (JsonToken expectedToken : expectedTokens) {
            if (!token.equals((Object)expectedToken)) continue;
            this._parser.clearCurrentToken();
            return token;
        }
        throw new IllegalArgumentException("Expected " + Arrays.toString(expectedTokens) + ", got: " + token);
    }

    protected JsonToken nextValue() throws IOException {
        while ((this._parser.currentToken() == JsonToken.START_OBJECT || this._parser.currentToken() == JsonToken.END_OBJECT || this._parser.currentToken() == JsonToken.FIELD_NAME) && this._parser.isRecord() || this._parser.currentToken() == null || this._parser.currentToken() == JsonToken.END_ARRAY) {
            this._parser.nextToken();
            if (this._parser.currentToken() != null) continue;
            break;
        }
        return this._parser.currentToken();
    }

    protected JsonToken nextUnionValue() throws IOException {
        while ((this._parser.currentToken() == JsonToken.END_OBJECT || this._parser.currentToken() == JsonToken.FIELD_NAME) && this._parser.isRecord() || this._parser.currentToken() == null || this._parser.currentToken() == JsonToken.END_ARRAY) {
            this._parser.nextToken();
            if (this._parser.currentToken() != null) continue;
            break;
        }
        return this._parser.currentToken();
    }

    public void readNull() throws IOException {
        this.consumeToken(JsonToken.VALUE_NULL);
    }

    public boolean readBoolean() throws IOException {
        return this.consumeToken(JsonToken.VALUE_FALSE, JsonToken.VALUE_TRUE) == JsonToken.VALUE_TRUE;
    }

    public int readInt() throws IOException {
        this.consumeToken(JsonToken.VALUE_NUMBER_INT);
        return this._parser.getIntValue();
    }

    public long readLong() throws IOException {
        this.consumeToken(JsonToken.VALUE_NUMBER_INT);
        return this._parser.getLongValue();
    }

    public float readFloat() throws IOException {
        this.consumeToken(JsonToken.VALUE_NUMBER_FLOAT);
        return this._parser.getFloatValue();
    }

    public double readDouble() throws IOException {
        this.consumeToken(JsonToken.VALUE_NUMBER_FLOAT);
        return this._parser.getDoubleValue();
    }

    public Utf8 readString(Utf8 old) throws IOException {
        return new Utf8(this.readString());
    }

    public String readString() throws IOException {
        this.nextValue();
        String value = this._parser.getText();
        this._parser.clearCurrentToken();
        return value;
    }

    public void skipString() throws IOException {
        this.consumeToken(JsonToken.VALUE_STRING);
        this.readString();
    }

    public ByteBuffer readBytes(ByteBuffer old) throws IOException {
        this.consumeToken(JsonToken.VALUE_EMBEDDED_OBJECT);
        byte[] value = this._parser.getBinaryValue();
        if (old != null && value.length <= old.capacity()) {
            old.clear();
            old.put(value);
            old.flip();
            return old;
        }
        return ByteBuffer.wrap(value);
    }

    public void skipBytes() throws IOException {
        this.readBytes(null);
    }

    public void readFixed(byte[] bytes, int start, int length) throws IOException {
        this.consumeToken(JsonToken.VALUE_EMBEDDED_OBJECT);
        System.arraycopy(this._parser.getBinaryValue(), 0, bytes, start, length);
    }

    public void skipFixed(int length) throws IOException {
        this.readFixed(new byte[length], 0, length);
    }

    public int readEnum() throws IOException {
        this.nextValue();
        return this._parser.enumIndex();
    }

    public long readArrayStart() throws IOException {
        this.consumeToken(JsonToken.START_ARRAY);
        return this._parser.getRemainingElements();
    }

    public long arrayNext() throws IOException {
        return this._parser.getRemainingElements();
    }

    public long skipArray() throws IOException {
        this.consumeToken(JsonToken.START_ARRAY);
        this._parser.skipValue();
        this.consumeToken(JsonToken.END_ARRAY);
        return 0L;
    }

    public long readMapStart() throws IOException {
        this.consumeToken(JsonToken.START_OBJECT);
        return this._parser.getRemainingElements();
    }

    public long mapNext() throws IOException {
        return this._parser.getRemainingElements();
    }

    public long skipMap() throws IOException {
        this.consumeToken(JsonToken.START_OBJECT);
        this._parser.skipValue();
        this.consumeToken(JsonToken.END_OBJECT);
        return 0L;
    }

    public int readIndex() throws IOException {
        this.nextUnionValue();
        return this._parser.branchIndex();
    }
}

