/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.schemas;

import org.apache.beam.sdk.schemas.Schema;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class SchemaUtils {
    public static @UnknownKeyFor @NonNull @Initialized Schema mergeWideningNullable(@UnknownKeyFor @NonNull @Initialized Schema schema1, @UnknownKeyFor @NonNull @Initialized Schema schema2) {
        if (schema1.getFieldCount() != schema2.getFieldCount()) {
            throw new IllegalArgumentException("Cannot merge schemas with different numbers of fields. schema1: " + schema1 + " schema2: " + schema2);
        }
        Schema.Builder builder = Schema.builder();
        for (int i = 0; i < schema1.getFieldCount(); ++i) {
            String name = schema1.getField(i).getName();
            builder.addField(name, SchemaUtils.widenNullableTypes(schema1.getField(i).getType(), schema2.getField(i).getType()));
        }
        return builder.build();
    }

    static @UnknownKeyFor @NonNull @Initialized Schema.FieldType widenNullableTypes(@UnknownKeyFor @NonNull @Initialized Schema.FieldType fieldType1, @UnknownKeyFor @NonNull @Initialized Schema.FieldType fieldType2) {
        Schema.FieldType result;
        if (fieldType1.getTypeName() != fieldType2.getTypeName()) {
            throw new IllegalArgumentException("Cannot merge two types: " + (Object)((Object)fieldType1.getTypeName()) + " and " + (Object)((Object)fieldType2.getTypeName()));
        }
        switch (fieldType1.getTypeName()) {
            case ROW: {
                result = Schema.FieldType.row(SchemaUtils.mergeWideningNullable(fieldType1.getRowSchema(), fieldType2.getRowSchema()));
                break;
            }
            case ARRAY: {
                Schema.FieldType arrayElementType = SchemaUtils.widenNullableTypes(fieldType1.getCollectionElementType(), fieldType2.getCollectionElementType());
                result = Schema.FieldType.array(arrayElementType);
                break;
            }
            case ITERABLE: {
                Schema.FieldType iterableElementType = SchemaUtils.widenNullableTypes(fieldType1.getCollectionElementType(), fieldType2.getCollectionElementType());
                result = Schema.FieldType.iterable(iterableElementType);
                break;
            }
            case MAP: {
                Schema.FieldType keyType = SchemaUtils.widenNullableTypes(fieldType1.getMapKeyType(), fieldType2.getMapKeyType());
                Schema.FieldType valueType = SchemaUtils.widenNullableTypes(fieldType1.getMapValueType(), fieldType2.getMapValueType());
                result = Schema.FieldType.map(keyType, valueType);
                break;
            }
            case LOGICAL_TYPE: {
                if (!fieldType1.getLogicalType().getIdentifier().equals(fieldType2.getLogicalType().getIdentifier())) {
                    throw new IllegalArgumentException("Logical types don't match and cannot be merged: " + fieldType1.getLogicalType().getIdentifier() + ".v.s" + fieldType2.getLogicalType().getIdentifier());
                }
            }
            default: {
                result = fieldType1;
            }
        }
        return result.withNullable(fieldType1.getNullable() != false || fieldType2.getNullable() != false);
    }

    public static <InputT, BaseT> BaseT toLogicalBaseType(@UnknownKeyFor @NonNull @Initialized Schema.LogicalType<InputT, BaseT> logicalType, InputT inputType) {
        return logicalType.toBaseType(inputType);
    }

    public static <BaseT, InputT> InputT toLogicalInputType(@UnknownKeyFor @NonNull @Initialized Schema.LogicalType<InputT, BaseT> logicalType, BaseT baseType) {
        return logicalType.toInputType(baseType);
    }
}

