/*
 * Decompiled with CFR 0.152.
 */
package autovalue.shaded.com.google.escapevelocity;

import autovalue.shaded.com.google.common.collect.ImmutableList;
import autovalue.shaded.com.google.escapevelocity.BreakException;
import autovalue.shaded.com.google.escapevelocity.EvaluationContext;
import autovalue.shaded.com.google.escapevelocity.ExpressionNode;
import autovalue.shaded.com.google.escapevelocity.Macro;
import autovalue.shaded.com.google.escapevelocity.Node;
import autovalue.shaded.com.google.escapevelocity.ParseException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

abstract class DirectiveNode
extends Node {
    DirectiveNode(String resourceName, int lineNumber) {
        super(resourceName, lineNumber);
    }

    static class MacroCallNode
    extends DirectiveNode {
        private final String name;
        private final ImmutableList<ExpressionNode> thunks;
        private final Node bodyContent;

        MacroCallNode(String resourceName, int lineNumber, String name, ImmutableList<ExpressionNode> argumentNodes, Node bodyContent) {
            super(resourceName, lineNumber);
            this.name = name;
            this.thunks = argumentNodes;
            this.bodyContent = bodyContent;
        }

        @Override
        void render(EvaluationContext context, StringBuilder output) {
            Macro macro = context.getMacros().get(this.name);
            if (macro == null) {
                throw this.evaluationException("#" + this.name + " is neither a standard directive nor a macro that has been defined");
            }
            if (this.thunks.size() != macro.parameterCount()) {
                throw this.evaluationException("Wrong number of arguments to #" + this.name + ": expected " + macro.parameterCount() + ", got " + this.thunks.size());
            }
            macro.render(context, this.thunks, this.bodyContent, output);
        }
    }

    static class BreakNode
    extends DirectiveNode {
        private final ExpressionNode scope;

        BreakNode(String resourceName, int lineNumber, ExpressionNode scope) {
            super(resourceName, lineNumber);
            this.scope = scope;
        }

        @Override
        void render(EvaluationContext context, StringBuilder output) {
            boolean forEachScope = false;
            if (this.scope != null) {
                Object scopeValue = this.scope.evaluate(context);
                if (scopeValue instanceof ForEachNode.ForEachVar) {
                    forEachScope = true;
                } else {
                    throw this.evaluationException("Argument to #break is not a supported scope: " + this.scope);
                }
            }
            String message = "#break " + ParseException.where(this.resourceName, this.lineNumber);
            throw new BreakException(message, forEachScope);
        }
    }

    static class ForEachNode
    extends DirectiveNode {
        private final String var;
        private final ExpressionNode collection;
        private final Node body;

        ForEachNode(String resourceName, int lineNumber, String var, ExpressionNode in, Node body) {
            super(resourceName, lineNumber);
            this.var = var;
            this.collection = in;
            this.body = body;
        }

        @Override
        void render(EvaluationContext context, StringBuilder output) {
            Collection<Object> iterable;
            Object collectionValue = this.collection.evaluate(context);
            if (collectionValue instanceof Iterable) {
                iterable = (List<Object>)collectionValue;
            } else if (collectionValue instanceof Object[]) {
                iterable = Arrays.asList((Object[])collectionValue);
            } else if (collectionValue instanceof Map) {
                iterable = ((Map)collectionValue).values();
            } else {
                if (collectionValue == null) {
                    return;
                }
                throw this.evaluationException("Not iterable: " + collectionValue);
            }
            Runnable undo = context.setVar(this.var, null);
            CountingIterator it = new CountingIterator(iterable.iterator());
            Runnable undoForEach = context.setVar("foreach", new ForEachVar(it));
            try {
                while (it.hasNext()) {
                    context.setVar(this.var, it.next());
                    this.body.render(context, output);
                }
            }
            catch (BreakException breakException) {
                // empty catch block
            }
            undoForEach.run();
            undo.run();
        }

        private static class ForEachVar {
            private final CountingIterator iterator;

            ForEachVar(CountingIterator iterator2) {
                this.iterator = iterator2;
            }

            public boolean getHasNext() {
                return this.iterator.hasNext();
            }

            public boolean getFirst() {
                return this.iterator.index() == 0;
            }

            public boolean getLast() {
                return !this.iterator.hasNext();
            }

            public int getIndex() {
                return this.iterator.index();
            }

            public int getCount() {
                return this.iterator.index() + 1;
            }

            public String toString() {
                return "{}";
            }
        }

        private static class CountingIterator
        implements Iterator<Object> {
            private final Iterator<?> iterator;
            private int index = -1;

            CountingIterator(Iterator<?> iterator2) {
                this.iterator = iterator2;
            }

            @Override
            public boolean hasNext() {
                return this.iterator.hasNext();
            }

            @Override
            public Object next() {
                Object next = this.iterator.next();
                ++this.index;
                return next;
            }

            int index() {
                return this.index;
            }
        }
    }

    static class IfNode
    extends DirectiveNode {
        private final ExpressionNode condition;
        private final Node truePart;
        private final Node falsePart;

        IfNode(String resourceName, int lineNumber, ExpressionNode condition, Node trueNode, Node falseNode) {
            super(resourceName, lineNumber);
            this.condition = condition;
            this.truePart = trueNode;
            this.falsePart = falseNode;
        }

        @Override
        void render(EvaluationContext context, StringBuilder output) {
            Node branch = this.condition.isTrue(context, true) ? this.truePart : this.falsePart;
            branch.render(context, output);
        }
    }

    static class DefineNode
    extends DirectiveNode {
        private final String var;
        private final Node body;

        DefineNode(String var, Node body) {
            super(body.resourceName, body.lineNumber);
            this.var = var;
            this.body = body;
        }

        @Override
        void render(EvaluationContext context, StringBuilder output) {
            context.setVar(this.var, this.body);
        }
    }

    static class SetNode
    extends DirectiveNode {
        private final String var;
        private final ExpressionNode expression;

        SetNode(String var, ExpressionNode expression) {
            super(expression.resourceName, expression.lineNumber);
            this.var = var;
            this.expression = expression;
        }

        @Override
        void render(EvaluationContext context, StringBuilder output) {
            context.setVar(this.var, this.expression.evaluate(context));
        }
    }
}

