/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms;

import java.lang.reflect.Method;
import org.apache.beam.sdk.transforms.InferableFunction;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public abstract class SimpleFunction<@UnknownKeyFor InputT, @UnknownKeyFor OutputT>
extends InferableFunction<InputT, OutputT>
implements SerializableFunction<InputT, OutputT> {
    private final @Nullable @UnknownKeyFor @Initialized SerializableFunction<InputT, OutputT> fn;

    protected SimpleFunction() {
        this.fn = null;
        try {
            Method methodThatMustBeOverridden = SimpleFunction.class.getDeclaredMethod("apply", Object.class);
            Method methodOnSubclass = this.getClass().getMethod("apply", Object.class);
            if (methodOnSubclass.equals(methodThatMustBeOverridden)) {
                throw new IllegalStateException("Subclass of SimpleFunction must override 'apply' method or pass a SerializableFunction to the constructor, usually via a lambda or method reference.");
            }
        }
        catch (NoSuchMethodException exc) {
            throw new RuntimeException("Impossible state: missing 'apply' method entirely", exc);
        }
    }

    protected SimpleFunction(@UnknownKeyFor @NonNull @Initialized SerializableFunction<InputT, OutputT> fn) {
        this.fn = fn;
    }

    @Override
    public OutputT apply(InputT input) {
        return this.fn.apply(input);
    }

    public static <InputT, OutputT> @UnknownKeyFor @NonNull @Initialized SimpleFunction<InputT, OutputT> fromSerializableFunctionWithOutputType(@UnknownKeyFor @NonNull @Initialized SerializableFunction<InputT, OutputT> fn, @UnknownKeyFor @NonNull @Initialized TypeDescriptor<OutputT> outputType) {
        return new SimpleFunctionWithOutputType<InputT, OutputT>(fn, outputType);
    }

    private static class SimpleFunctionWithOutputType<@UnknownKeyFor InputT, @UnknownKeyFor OutputT>
    extends SimpleFunction<InputT, OutputT> {
        private final @UnknownKeyFor @NonNull @Initialized TypeDescriptor<OutputT> outputType;

        public SimpleFunctionWithOutputType(@UnknownKeyFor @NonNull @Initialized SerializableFunction<InputT, OutputT> fn, @UnknownKeyFor @NonNull @Initialized TypeDescriptor<OutputT> outputType) {
            super(fn);
            this.outputType = outputType;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized TypeDescriptor<OutputT> getOutputTypeDescriptor() {
            return this.outputType;
        }
    }
}

