/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.am;

import java.io.IOException;
import java.io.InputStream;
import org.apache.derby.client.am.SqlException;
import org.apache.derby.shared.common.info.ProductVersionHolder;

public class Configuration {
    private static ProductVersionHolder dncProductVersionHolder__;
    static final String dncDriverName = "Apache Derby Network Client JDBC Driver";
    private static final byte[] dncPackageConsistencyToken;
    public static final boolean jdbcCompliant = true;
    private static final String[] dncCompatibleJREVersions;
    public static final String jdbcDerbyNETProtocol = "jdbc:derby://";
    static final boolean rangeCheckCrossConverters = true;
    static final int bugCheckLevel = 255;
    static final int defaultIsolation = 2;
    public static final int defaultFetchSize = 64;
    static final String cursorAttribute_SensitiveStatic = "SENSITIVE STATIC SCROLL ";
    static final String cursorAttribute_Insensitive = "INSENSITIVE SCROLL ";
    static final String cursorAttribute_ForUpdate = "FOR UPDATE ";
    static final String cursorAttribute_WithHold = "WITH HOLD ";
    private static SqlException exceptionsOnLoadResources;

    private Configuration() {
    }

    static ProductVersionHolder getProductVersionHolder() {
        return dncProductVersionHolder__;
    }

    public static byte[] getDncPackageConsistencyToken() {
        return (byte[])dncPackageConsistencyToken.clone();
    }

    static String[] getDncCompatibleJREVersions() {
        return (String[])dncCompatibleJREVersions.clone();
    }

    public static SqlException getExceptionOnLoadResources() {
        return exceptionsOnLoadResources;
    }

    private static void loadProductVersionHolder() throws SqlException {
        try {
            dncProductVersionHolder__ = Configuration.buildProductVersionHolder();
        }
        catch (IOException iOException) {
            throw SqlException.javaException(null, iOException);
        }
    }

    private static ProductVersionHolder buildProductVersionHolder() throws IOException {
        InputStream inputStream = Configuration.class.getResourceAsStream("/org/apache/derby/info/client/info.properties");
        return ProductVersionHolder.getProductVersionHolderFromMyEnv((InputStream)inputStream);
    }

    public static boolean supportsJDBC42() {
        try {
            Class.forName("java.sql.SQLType");
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    static {
        dncPackageConsistencyToken = new byte[]{83, 89, 83, 76, 86, 76, 48, 49};
        dncCompatibleJREVersions = new String[]{"1.5", "1.6", "1.7", "1.8"};
        exceptionsOnLoadResources = null;
        try {
            Configuration.loadProductVersionHolder();
        }
        catch (SqlException sqlException) {
            exceptionsOnLoadResources = sqlException;
        }
    }
}

