/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400File;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.Record;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;

public class SequentialFile
extends AS400File
implements Serializable {
    static final long serialVersionUID = 4L;

    public SequentialFile() {
    }

    public SequentialFile(AS400 system, String name) {
        super(system, name);
    }

    public void deleteRecord(int recordNumber) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        this.positionCursor(recordNumber);
        this.deleteCurrentRecord();
    }

    public void positionCursor(int recordNumber) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        this.verifyState(recordNumber);
        this.impl_.doIt("positionCursor", new Class[]{Integer.TYPE}, new Object[]{recordNumber});
    }

    public void positionCursorAfter(int recordNumber) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        this.positionCursor(recordNumber);
        this.positionCursorToNext();
    }

    public void positionCursorBefore(int recordNumber) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        this.verifyState(recordNumber);
        this.impl_.doIt("positionCursorBefore", new Class[]{Integer.TYPE}, new Object[]{recordNumber});
    }

    public Record read(int recordNumber) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        this.verifyState(recordNumber);
        return this.fillInRecord(this.impl_.doItRecord("read", new Class[]{Integer.TYPE}, new Object[]{recordNumber}));
    }

    public Record readAfter(int recordNumber) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        this.verifyState(recordNumber);
        return this.fillInRecord(this.impl_.doItRecord("readAfter", new Class[]{Integer.TYPE}, new Object[]{recordNumber}));
    }

    @Override
    public Record[] readAll() throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        Record[] recs;
        if (this.isOpen_) {
            throw new ExtendedIllegalStateException(2);
        }
        if (this.recordFormat_ == null) {
            throw new ExtendedIllegalStateException("recordFormat", 4);
        }
        this.chooseImpl();
        this.recordFormat_.initializeTextObjects(this.system_);
        int bf = 2048 / (this.recordFormat_.getNewRecord().getRecordLength() + 16);
        if (bf <= 1) {
            bf = 100;
        }
        if ((recs = this.impl_.doItRecordArray("readAll", new Class[]{String.class, Integer.TYPE}, new Object[]{"seq", bf})) != null) {
            for (int i = 0; i < recs.length; ++i) {
                recs[i] = this.fillInRecord(recs[i]);
            }
        }
        return recs;
    }

    public Record readBefore(int recordNumber) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        this.verifyState(recordNumber);
        return this.fillInRecord(this.impl_.doItRecord("readBefore", new Class[]{Integer.TYPE}, new Object[]{recordNumber}));
    }

    private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
        in.defaultReadObject();
        this.initializeTransient();
    }

    public void update(int recordNumber, Record record) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        if (record == null) {
            throw new NullPointerException("record");
        }
        this.positionCursor(recordNumber);
        this.update(record);
    }

    private void verifyState(int recordNumber) {
        if (!this.isOpen_) {
            throw new ExtendedIllegalStateException(3);
        }
        if (recordNumber < 1) {
            throw new ExtendedIllegalArgumentException("recordNumber", 2);
        }
    }
}

