/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.UserPermission;

public class DLOPermission
extends UserPermission {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    static final long serialVersionUID = 4L;

    public DLOPermission(String userProfileName) {
        super(userProfileName);
        this.dataAuthority_ = "*EXCLUDE";
    }

    public String getDataAuthority() {
        if (this.isFromAuthorizationList()) {
            return "*AUTL";
        }
        this.parseBasic();
        switch (this.objectAuthority_) {
            case 0: {
                return "*ALL";
            }
            case 1: {
                return "*EXCLUDE";
            }
            case 2: {
                return "*USE";
            }
            case 3: {
                return "*CHANGE";
            }
            case -1: {
                return "USER DEFINED";
            }
        }
        return "USER DEFINED";
    }

    private synchronized void parseBasic() {
        for (int j = 0; j < 4; ++j) {
            boolean match = true;
            for (int i = 0; i < 10; ++i) {
                if (this.authorities_[i] == basicAutMapping[j][i]) continue;
                match = false;
                break;
            }
            if (!match) continue;
            this.objectAuthority_ = j;
            return;
        }
        this.objectAuthority_ = -1;
    }

    synchronized void setAdd(boolean authority) {
        this.changeAuthority();
        this.authorities_[6] = authority;
    }

    synchronized void setAlter(boolean authority) {
        this.changeAuthority();
        this.authorities_[3] = authority;
    }

    public synchronized void setDataAuthority(String authority) {
        if (authority == null) {
            throw new NullPointerException("authority");
        }
        String aut = authority.trim().toUpperCase();
        this.changeAuthority();
        if (this.getDataAuthority().equals(aut)) {
            return;
        }
        if (aut.equals("*ALL")) {
            System.arraycopy(basicAutMapping[0], 0, this.authorities_, 0, 10);
            this.objectAuthority_ = 0;
        } else if (aut.equals("*EXCLUDE")) {
            System.arraycopy(basicAutMapping[1], 0, this.authorities_, 0, 10);
            this.objectAuthority_ = 1;
        } else if (aut.equals("*USE")) {
            System.arraycopy(basicAutMapping[2], 0, this.authorities_, 0, 10);
            this.objectAuthority_ = 2;
        } else if (aut.equals("*CHANGE")) {
            System.arraycopy(basicAutMapping[3], 0, this.authorities_, 0, 10);
            this.objectAuthority_ = 3;
        } else if (aut.equals("*AUTL")) {
            this.setFromAuthorizationList(true);
        }
    }

    synchronized void setDelete(boolean authority) {
        this.changeAuthority();
        this.authorities_[8] = authority;
    }

    synchronized void setExecute(boolean authority) {
        this.changeAuthority();
        this.authorities_[9] = authority;
    }

    synchronized void setExistence(boolean authority) {
        this.changeAuthority();
        this.authorities_[2] = authority;
    }

    synchronized void setManagement(boolean authority) {
        this.changeAuthority();
        this.authorities_[1] = authority;
    }

    synchronized void setOperational(boolean authority) {
        this.changeAuthority();
        this.authorities_[0] = authority;
    }

    synchronized void setRead(boolean authority) {
        this.changeAuthority();
        this.authorities_[5] = authority;
    }

    synchronized void setReference(boolean authority) {
        this.changeAuthority();
        this.authorities_[4] = authority;
    }

    synchronized void setUpdate(boolean authority) {
        this.changeAuthority();
        this.authorities_[7] = authority;
    }
}

