/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.tunnel;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import org.apache.guacamole.net.auth.AuthenticatedUser;
import org.apache.guacamole.net.auth.Credentials;

public class StandardTokenMap
extends HashMap<String, String> {
    public static final String USERNAME_TOKEN = "GUAC_USERNAME";
    public static final String PASSWORD_TOKEN = "GUAC_PASSWORD";
    public static final String CLIENT_HOSTNAME_TOKEN = "GUAC_CLIENT_HOSTNAME";
    public static final String CLIENT_ADDRESS_TOKEN = "GUAC_CLIENT_ADDRESS";
    public static final String DATE_TOKEN = "GUAC_DATE";
    public static final String TIME_TOKEN = "GUAC_TIME";
    private static final String DATE_FORMAT = "yyyyMMdd";
    private static final String TIME_FORMAT = "HHmmss";

    public StandardTokenMap(AuthenticatedUser authenticatedUser) {
        String address;
        String hostname;
        Date currentTime = new Date();
        this.put((Object)DATE_TOKEN, (Object)new SimpleDateFormat(DATE_FORMAT).format(currentTime));
        this.put((Object)TIME_TOKEN, (Object)new SimpleDateFormat(TIME_FORMAT).format(currentTime));
        Credentials credentials = authenticatedUser.getCredentials();
        String username = credentials.getUsername();
        if (username != null) {
            this.put((Object)USERNAME_TOKEN, (Object)username);
        } else {
            this.put((Object)USERNAME_TOKEN, (Object)authenticatedUser.getIdentifier());
        }
        String password = credentials.getPassword();
        if (password != null) {
            this.put((Object)PASSWORD_TOKEN, (Object)password);
        }
        if ((hostname = credentials.getRemoteHostname()) != null) {
            this.put((Object)CLIENT_HOSTNAME_TOKEN, (Object)hostname);
        }
        if ((address = credentials.getRemoteAddress()) != null) {
            this.put((Object)CLIENT_ADDRESS_TOKEN, (Object)address);
        }
    }
}

