/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.rest.activeconnection;

import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.net.auth.ActiveConnection;
import org.apache.guacamole.net.auth.Connection;
import org.apache.guacamole.net.auth.Directory;
import org.apache.guacamole.net.auth.Identifiable;
import org.apache.guacamole.net.auth.UserContext;
import org.apache.guacamole.rest.activeconnection.APIActiveConnection;
import org.apache.guacamole.rest.activeconnection.APIUserCredentials;
import org.apache.guacamole.rest.connection.APIConnection;
import org.apache.guacamole.rest.directory.DirectoryObjectResource;
import org.apache.guacamole.rest.directory.DirectoryObjectTranslator;
import org.apache.guacamole.rest.directory.DirectoryResourceFactory;

@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class ActiveConnectionResource
extends DirectoryObjectResource<ActiveConnection, APIActiveConnection> {
    private final UserContext userContext;
    private final ActiveConnection activeConnection;
    @Inject
    private DirectoryResourceFactory<Connection, APIConnection> connectionDirectoryResourceFactory;

    @AssistedInject
    public ActiveConnectionResource(@Assisted UserContext userContext, @Assisted Directory<ActiveConnection> directory, @Assisted ActiveConnection activeConnection, DirectoryObjectTranslator<ActiveConnection, APIActiveConnection> translator) {
        super(userContext, directory, (Identifiable)activeConnection, translator);
        this.userContext = userContext;
        this.activeConnection = activeConnection;
    }

    @Path(value="connection")
    public DirectoryObjectResource<Connection, APIConnection> getConnection() throws GuacamoleException {
        return this.connectionDirectoryResourceFactory.create(this.userContext, this.userContext.getConnectionDirectory()).getObjectResource(this.activeConnection.getConnectionIdentifier());
    }

    @GET
    @Path(value="sharingCredentials/{sharingProfile}")
    public APIUserCredentials getSharingCredentials(@PathParam(value="sharingProfile") String sharingProfileIdentifier) throws GuacamoleException {
        return new APIUserCredentials(this.activeConnection.getSharingCredentials(sharingProfileIdentifier));
    }
}

