/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.rest;

import javax.inject.Inject;
import javax.inject.Singleton;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.apache.guacamole.GuacamoleClientException;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.GuacamoleUnauthorizedException;
import org.apache.guacamole.rest.APIError;
import org.apache.guacamole.rest.auth.AuthenticationService;
import org.glassfish.jersey.server.ContainerRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
@Singleton
public class RESTExceptionMapper
implements ExceptionMapper<Throwable> {
    private final Logger logger = LoggerFactory.getLogger(RESTExceptionMapper.class);
    @Context
    private ContainerRequest request;
    @Inject
    private AuthenticationService authenticationService;

    public Response toResponse(Throwable t) {
        String token;
        if (t instanceof WebApplicationException) {
            return ((WebApplicationException)t).getResponse();
        }
        if (t instanceof GuacamoleUnauthorizedException && this.authenticationService.destroyGuacamoleSession(token = this.authenticationService.getAuthenticationToken(this.request))) {
            this.logger.debug("Implicitly invalidated session for token \"{}\"", (Object)token);
        }
        if (t instanceof GuacamoleException) {
            if (t instanceof GuacamoleClientException) {
                this.logger.debug("Client request rejected: {}", (Object)t.getMessage());
            } else {
                this.logger.error("Request could not be processed: {}", (Object)t.getMessage());
                this.logger.debug("Processing of request aborted by extension.", t);
            }
            return Response.status((int)((GuacamoleException)t).getHttpStatusCode()).entity((Object)new APIError((GuacamoleException)t)).type("application/json").build();
        }
        String message = t.getMessage();
        if (message != null) {
            this.logger.error("Unexpected internal error: {}", (Object)message);
        } else {
            this.logger.error("An internal error occurred, but did not contain an error message. Enable debug-level logging for details.");
        }
        this.logger.debug("Unexpected error in REST endpoint.", t);
        return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)new APIError(new GuacamoleException("Unexpected internal error", t))).type("application/json").build();
    }
}

