/*
 * Decompiled with CFR 0.152.
 */
package grails.init;

import grails.init.GrailsVersion;
import java.io.File;

public class GrailsWrapperRepo {
    private String baseUrl;
    private String repoPath;
    private String metadataName;
    boolean isFile;

    private GrailsWrapperRepo() {
    }

    String getUrl() {
        return this.join(this.baseUrl, this.repoPath);
    }

    String getRootMetadataUrl() {
        return this.join(this.getUrl(), this.metadataName);
    }

    String getMetadataUrl(GrailsVersion version) {
        return this.join(this.getUrl(), version.version, this.metadataName);
    }

    String getFileUrl(GrailsVersion version, String name) {
        return this.join(this.getUrl(), version.version, name);
    }

    private String join(String ... elements) {
        return String.join((CharSequence)(this.isFile ? File.separator : "/"), elements);
    }

    static GrailsWrapperRepo getSelectedRepo() {
        GrailsWrapperRepo repo = new GrailsWrapperRepo();
        repo.repoPath = "org/apache/grails/grails-cli";
        String configured = GrailsWrapperRepo.getConfiguredMavenUrl();
        if (configured != null) {
            System.out.println("...Update Repository is overridden to: " + configured);
            repo.baseUrl = configured;
        } else {
            repo.baseUrl = "https://repository.apache.org/content/groups/public";
        }
        boolean bl = repo.isFile = !repo.baseUrl.startsWith("http");
        if (repo.isFile && repo.baseUrl.endsWith(File.separator) || !repo.isFile && repo.baseUrl.endsWith("/")) {
            repo.baseUrl = repo.baseUrl.substring(0, repo.baseUrl.length() - 1);
        }
        repo.metadataName = repo.isFile ? "maven-metadata-local.xml" : "maven-metadata.xml";
        return repo;
    }

    static String getConfiguredMavenUrl() {
        String baseUrl = System.getProperty("grails.repo.url");
        if (baseUrl != null) {
            return baseUrl;
        }
        return System.getenv("GRAILS_REPO_URL");
    }
}

