/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.proxy.spi.invocation;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.InterceptionType;
import jakarta.enterprise.inject.spi.Interceptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.deltaspike.core.api.provider.BeanManagerProvider;

@ApplicationScoped
public class DeltaSpikeProxyInterceptorLookup {
    private final Map<Method, List<Interceptor<?>>> cache = new HashMap();

    public List<Interceptor<?>> lookup(Object instance, Method method) {
        List<Interceptor<?>> interceptors = this.cache.get(method);
        if (interceptors == null) {
            interceptors = this.resolveInterceptors(instance, method);
            this.cache.put(method, interceptors);
        }
        return interceptors;
    }

    private List<Interceptor<?>> resolveInterceptors(Object instance, Method method) {
        BeanManager beanManager = BeanManagerProvider.getInstance().getBeanManager();
        Annotation[] interceptorBindings = this.extractInterceptorBindings(beanManager, instance, method);
        if (interceptorBindings.length > 0) {
            return beanManager.resolveInterceptors(InterceptionType.AROUND_INVOKE, interceptorBindings);
        }
        return new ArrayList();
    }

    private Annotation[] extractInterceptorBindings(BeanManager beanManager, Object instance, Method method) {
        ArrayList<Annotation> bindings = new ArrayList<Annotation>();
        this.addInterceptorBindings(beanManager, bindings, instance.getClass().getDeclaredAnnotations());
        this.addInterceptorBindings(beanManager, bindings, method.getDeclaredAnnotations());
        return bindings.toArray(new Annotation[bindings.size()]);
    }

    private void addInterceptorBindings(BeanManager beanManager, ArrayList<Annotation> bindings, Annotation[] declaredAnnotations) {
        for (Annotation annotation : declaredAnnotations) {
            if (bindings.contains(annotation)) continue;
            Class<? extends Annotation> annotationType = annotation.annotationType();
            if (beanManager.isInterceptorBinding(annotationType)) {
                bindings.add(annotation);
            }
            if (!beanManager.isStereotype(annotationType)) continue;
            for (Annotation subAnnotation : annotationType.getDeclaredAnnotations()) {
                if (bindings.contains(subAnnotation) || !beanManager.isInterceptorBinding(subAnnotation.annotationType())) continue;
                bindings.add(subAnnotation);
            }
        }
    }
}

