/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat.documentation.velocity;

import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.apache.rat.documentation.velocity.Matcher;
import org.apache.rat.documentation.velocity.MatcherTree;
import org.apache.rat.license.ILicense;

public final class License {
    private final ILicense license;

    License(ILicense license) {
        this.license = license;
    }

    public String name() {
        return this.license.getName();
    }

    public String family() {
        return this.license.getFamilyName();
    }

    public String note() {
        return StringUtils.normalizeSpace(this.license.getNote());
    }

    public String id() {
        String result = this.license.getId();
        try {
            UUID.fromString(result);
            return null;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return result;
        }
    }

    public Matcher getMatcher() {
        return new Matcher(this.license.getMatcher());
    }

    public MatcherTree getMatcherTree() {
        return new MatcherTree(this.license.getMatcher());
    }
}

