/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat.config.exclusion;

import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.LineIterator;
import org.apache.commons.lang3.StringUtils;
import org.apache.rat.ConfigurationException;
import org.apache.rat.api.EnvVar;
import org.apache.rat.config.exclusion.plexus.SelectorUtils;
import org.apache.rat.document.DocumentName;
import org.apache.rat.document.DocumentNameMatcher;
import org.apache.rat.utils.ExtendedIterator;

public final class ExclusionUtils {
    public static final List<String> COMMENT_PREFIXES = Arrays.asList("#", "##", "//", "/**", "/*");
    public static final String NEGATION_PREFIX = "!";
    public static final Predicate<String> NOT_MATCH_FILTER = s -> s.startsWith(NEGATION_PREFIX);
    public static final Predicate<String> MATCH_FILTER = NOT_MATCH_FILTER.negate();

    private ExclusionUtils() {
    }

    public static Predicate<String> commentFilter(Iterable<String> commentPrefixes) {
        return s -> {
            if (StringUtils.isNotBlank(s)) {
                int i = 1;
                while (StringUtils.isBlank(s.substring(0, i))) {
                    ++i;
                }
                String trimmed = i > 0 ? s.substring(i - 1) : s;
                for (String prefix : commentPrefixes) {
                    if (!trimmed.startsWith(prefix)) continue;
                    return false;
                }
                return true;
            }
            return false;
        };
    }

    public static Predicate<String> commentFilter(String commentPrefix) {
        return s -> {
            if (StringUtils.isNotBlank(s)) {
                int i = 1;
                while (StringUtils.isBlank(s.substring(0, i))) {
                    ++i;
                }
                String trimmed = i > 0 ? s.substring(i - 1) : s;
                return !trimmed.startsWith(commentPrefix);
            }
            return false;
        };
    }

    public static FileFilter asFileFilter(DocumentName parent, DocumentNameMatcher nameMatcher) {
        return file -> {
            DocumentName candidate = DocumentName.builder(file).setBaseName(parent.getBaseName()).build();
            return EnvVar.RAT_DECOMPOSE_MATCHER_ON_USE.isSet() ? nameMatcher.logDecompositionWhileMatching(candidate) : nameMatcher.matches(candidate);
        };
    }

    public static ExtendedIterator<String> asIterator(File patternFile, Predicate<String> commentFilters) {
        ExclusionUtils.verifyFile(patternFile);
        Objects.requireNonNull(commentFilters, "commentFilters");
        try {
            return ExtendedIterator.create(IOUtils.lineIterator(new FileReader(patternFile))).filter(commentFilters);
        }
        catch (FileNotFoundException e) {
            throw new ConfigurationException(String.format("%s is not a valid file.", patternFile));
        }
    }

    public static Iterable<String> asIterable(File patternFile, String commentPrefix) {
        return ExclusionUtils.asIterable(patternFile, ExclusionUtils.commentFilter(commentPrefix));
    }

    public static Iterable<String> asIterable(File patternFile, final Predicate<String> commentFilters) {
        ArrayList<String> arrayList;
        ExclusionUtils.verifyFile(patternFile);
        Objects.requireNonNull(commentFilters, "commentFilters");
        FileReader reader = new FileReader(patternFile);
        try {
            ArrayList<String> result = new ArrayList<String>();
            LineIterator iter = new LineIterator(reader){

                @Override
                protected boolean isValidLine(String line) {
                    return commentFilters.test(line);
                }
            };
            iter.forEachRemaining(result::add);
            arrayList = result;
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new ConfigurationException("Unable to read file " + patternFile, e);
            }
        }
        reader.close();
        return arrayList;
    }

    public static boolean isHidden(String fileName) {
        return fileName.startsWith(".") && !fileName.equals(".") && !fileName.equals("..");
    }

    private static void verifyFile(File file) {
        if (file == null || !file.exists() || !file.isFile()) {
            throw new ConfigurationException(String.format("%s is not a valid file.", file));
        }
    }

    public static String qualifyPattern(DocumentName documentName, String pattern) {
        boolean prefix = pattern.startsWith(NEGATION_PREFIX);
        String workingPattern = prefix ? pattern.substring(1) : pattern;
        String normalizedPattern = SelectorUtils.extractPattern(workingPattern, documentName.getDirectorySeparator());
        StringBuilder sb = new StringBuilder(prefix ? NEGATION_PREFIX : "");
        if (SelectorUtils.isRegexPrefixedPattern(workingPattern)) {
            sb.append("%regex[").append("\\Q").append(documentName.getBaseName()).append(documentName.getDirectorySeparator()).append("\\E").append(normalizedPattern).append("]");
        } else {
            sb.append(documentName.getBaseDocumentName().resolve(normalizedPattern).getName());
        }
        return sb.toString();
    }

    public static String convertSeparator(String source, String from, String to) {
        if (StringUtils.isEmpty(source) || from.equals(to)) {
            return source;
        }
        return String.join((CharSequence)to, source.split("\\Q" + from + "\\E"));
    }
}

