/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.function;

import java.io.IOException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.io.function.IOIterator;
import org.apache.commons.io.function.TestConstants;
import org.apache.commons.lang3.JavaVersion;
import org.apache.commons.lang3.SystemUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class IOIteratorTest {
    private IOIterator<Path> iterator;

    IOIteratorTest() {
    }

    @BeforeEach
    public void beforeEach() {
        this.iterator = IOIterator.adapt(this.newPathList().iterator());
    }

    private List<Path> newPathList() {
        return Arrays.asList(TestConstants.ABS_PATH_A, TestConstants.ABS_PATH_B);
    }

    @Test
    void testAdaptIterable() throws IOException {
        Assertions.assertEquals((Object)TestConstants.ABS_PATH_A, (Object)IOIterator.adapt(this.newPathList()).next());
    }

    @Test
    void testAdaptIterator() throws IOException {
        Assertions.assertEquals((Object)TestConstants.ABS_PATH_A, (Object)this.iterator.next());
    }

    @Test
    void testAsIterator() {
        Iterator asIterator = this.iterator.asIterator();
        Assertions.assertTrue((boolean)asIterator.hasNext());
        Assertions.assertEquals((Object)TestConstants.ABS_PATH_A, asIterator.next());
        Assertions.assertThrows(UnsupportedOperationException.class, asIterator::remove);
    }

    @Test
    void testForEachRemaining() throws IOException {
        ArrayList list = new ArrayList();
        this.iterator.forEachRemaining(p -> list.add(p.toRealPath(new LinkOption[0])));
        Assertions.assertFalse((boolean)this.iterator.hasNext());
        Assertions.assertEquals(this.newPathList(), list);
    }

    @Test
    void testHasNext() throws IOException {
        Assertions.assertTrue((boolean)this.iterator.hasNext());
        this.iterator.forEachRemaining(rec$ -> ((Path)rec$).toRealPath(new LinkOption[0]));
        Assertions.assertFalse((boolean)this.iterator.hasNext());
    }

    @Test
    void testNext() throws IOException {
        Assertions.assertEquals((Object)TestConstants.ABS_PATH_A, (Object)this.iterator.next());
    }

    @Test
    void testRemove() throws IOException {
        Class exClass = SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_1_8) ? IllegalStateException.class : UnsupportedOperationException.class;
        Assertions.assertThrows(exClass, () -> this.iterator.remove());
        Assertions.assertThrows(exClass, () -> this.iterator.remove());
        this.iterator.next();
        Assertions.assertThrows(UnsupportedOperationException.class, () -> this.iterator.remove());
        Assertions.assertThrows(UnsupportedOperationException.class, () -> this.iterator.remove());
    }
}

