/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.digester3;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.beanutils.ConstructorUtils;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.digester3.Digester;
import org.apache.commons.digester3.RecordedInvocation;
import org.apache.commons.digester3.Rule;
import org.apache.commons.digester3.internal.cglib.proxy.$Callback;
import org.apache.commons.digester3.internal.cglib.proxy.$Enhancer;
import org.apache.commons.digester3.internal.cglib.proxy.$Factory;
import org.apache.commons.digester3.internal.cglib.proxy.$MethodInterceptor;
import org.apache.commons.digester3.internal.cglib.proxy.$MethodProxy;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectCreateRule
extends Rule {
    protected String attributeName = null;
    protected Class<?> clazz = null;
    protected String className = null;
    private Class<?>[] constructorArgumentTypes;
    private Object[] defaultConstructorArguments;
    private ProxyManager proxyManager;

    public ObjectCreateRule(String className) {
        this(className, (String)null);
    }

    public ObjectCreateRule(Class<?> clazz) {
        this(clazz.getName(), (String)null);
        this.clazz = clazz;
    }

    public ObjectCreateRule(String className, String attributeName) {
        this.className = className;
        this.attributeName = attributeName;
    }

    public ObjectCreateRule(String attributeName, Class<?> clazz) {
        this(clazz.getName(), attributeName);
        this.clazz = clazz;
    }

    public void setConstructorArgumentTypes(Class<?> ... constructorArgumentTypes) {
        if (constructorArgumentTypes == null) {
            throw new IllegalArgumentException("Parameter 'constructorArgumentTypes' must not be null");
        }
        this.constructorArgumentTypes = constructorArgumentTypes;
    }

    public void setDefaultConstructorArguments(Object ... constructorArguments) {
        if (constructorArguments == null) {
            throw new IllegalArgumentException("Parameter 'constructorArguments' must not be null");
        }
        this.defaultConstructorArguments = constructorArguments;
    }

    @Override
    public void begin(String namespace, String name, Attributes attributes) throws Exception {
        Object instance;
        Class<?> clazz = this.clazz;
        if (clazz == null) {
            String value;
            String realClassName = this.className;
            if (this.attributeName != null && (value = attributes.getValue(this.attributeName)) != null) {
                realClassName = value;
            }
            if (this.getDigester().getLogger().isDebugEnabled()) {
                this.getDigester().getLogger().debug(String.format("[ObjectCreateRule]{%s} New '%s'", this.getDigester().getMatch(), realClassName));
            }
            clazz = this.getDigester().getClassLoader().loadClass(realClassName);
        }
        if (this.constructorArgumentTypes == null || this.constructorArgumentTypes.length == 0) {
            if (this.getDigester().getLogger().isDebugEnabled()) {
                this.getDigester().getLogger().debug(String.format("[ObjectCreateRule]{%s} New '%s' using default empty constructor", this.getDigester().getMatch(), clazz.getName()));
            }
            instance = clazz.newInstance();
        } else {
            if (this.proxyManager == null) {
                Constructor constructor = ConstructorUtils.getAccessibleConstructor(clazz, this.constructorArgumentTypes);
                if (constructor == null) {
                    throw new SAXException(String.format("[ObjectCreateRule]{%s} Class '%s' does not have a construcor with types %s", this.getDigester().getMatch(), clazz.getName(), Arrays.toString(this.constructorArgumentTypes)));
                }
                this.proxyManager = new ProxyManager(clazz, constructor, this.defaultConstructorArguments, this.getDigester());
            }
            instance = this.proxyManager.createProxy();
        }
        this.getDigester().push(instance);
    }

    @Override
    public void end(String namespace, String name) throws Exception {
        Object top = this.getDigester().pop();
        if (this.proxyManager != null) {
            this.proxyManager.finalize(top);
        }
        if (this.getDigester().getLogger().isDebugEnabled()) {
            this.getDigester().getLogger().debug(String.format("[ObjectCreateRule]{%s} Pop '%s'", this.getDigester().getMatch(), top.getClass().getName()));
        }
    }

    public String toString() {
        return String.format("ObjectCreateRule[className=%s, attributeName=%s]", this.className, this.attributeName);
    }

    private static void convertTo(Class<?>[] types, Object[] array) {
        if (array.length != types.length) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != null && (!(array[i] instanceof String) || String.class.isAssignableFrom(types[i]))) continue;
            array[i] = ConvertUtils.convert((String)array[i], types[i]);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ProxyManager {
        private final Class<?> clazz;
        private final Constructor<?> constructor;
        private final Object[] templateConstructorArguments;
        private final Digester digester;
        private final boolean hasDefaultConstructor;
        private $Factory factory;

        ProxyManager(Class<?> clazz, Constructor<?> constructor, Object[] constructorArguments, Digester digester) {
            this.clazz = clazz;
            this.hasDefaultConstructor = ConstructorUtils.getAccessibleConstructor(clazz, new Class[0]) != null;
            this.constructor = constructor;
            Class[] argTypes = constructor.getParameterTypes();
            this.templateConstructorArguments = new Object[argTypes.length];
            if (constructorArguments == null) {
                for (int i = 0; i < this.templateConstructorArguments.length; ++i) {
                    this.templateConstructorArguments[i] = argTypes[i].equals(Boolean.TYPE) ? Boolean.FALSE : (argTypes[i].isPrimitive() ? ConvertUtils.convert("0", argTypes[i]) : null);
                }
            } else {
                if (constructorArguments.length != argTypes.length) {
                    throw new IllegalArgumentException(String.format("wrong number of constructor arguments specified: %s instead of %s", constructorArguments.length, argTypes.length));
                }
                System.arraycopy(constructorArguments, 0, this.templateConstructorArguments, 0, constructorArguments.length);
            }
            ObjectCreateRule.convertTo(argTypes, this.templateConstructorArguments);
            this.digester = digester;
        }

        Object createProxy() {
            Object[] constructorArguments = new Object[this.templateConstructorArguments.length];
            System.arraycopy(this.templateConstructorArguments, 0, constructorArguments, 0, constructorArguments.length);
            this.digester.pushParams(constructorArguments);
            DeferredConstructionCallback callback = new DeferredConstructionCallback(this.constructor, constructorArguments);
            if (this.factory == null) {
                $Enhancer enhancer = new $Enhancer();
                enhancer.setSuperclass(this.clazz);
                enhancer.setCallback(callback);
                enhancer.setClassLoader(this.digester.getClassLoader());
                enhancer.setInterceptDuringConstruction(false);
                Object result = this.hasDefaultConstructor ? enhancer.create() : enhancer.create(this.constructor.getParameterTypes(), constructorArguments);
                this.factory = ($Factory)result;
                return result;
            }
            Object result = this.hasDefaultConstructor ? this.factory.newInstance(callback) : this.factory.newInstance(this.constructor.getParameterTypes(), constructorArguments, new $Callback[]{callback});
            return result;
        }

        void finalize(Object proxy) throws Exception {
            this.digester.popParams();
            ((DeferredConstructionCallback)(($Factory)proxy).getCallback(0)).establishDelegate();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DeferredConstructionCallback
    implements $MethodInterceptor {
        Constructor<?> constructor;
        Object[] constructorArgs;
        ArrayList<RecordedInvocation> invocations = new ArrayList();
        Object delegate;

        DeferredConstructionCallback(Constructor<?> constructor, Object[] constructorArgs) {
            this.constructor = constructor;
            this.constructorArgs = constructorArgs;
        }

        @Override
        public Object intercept(Object obj, Method method, Object[] args, $MethodProxy proxy) throws Throwable {
            boolean hasDelegate;
            boolean bl = hasDelegate = this.delegate != null;
            if (!hasDelegate) {
                this.invocations.add(new RecordedInvocation(method, args));
            }
            if (hasDelegate) {
                return proxy.invoke(this.delegate, args);
            }
            return proxy.invokeSuper(obj, args);
        }

        void establishDelegate() throws Exception {
            ObjectCreateRule.convertTo(this.constructor.getParameterTypes(), this.constructorArgs);
            this.delegate = this.constructor.newInstance(this.constructorArgs);
            for (RecordedInvocation invocation : this.invocations) {
                invocation.getInvokedMethod().invoke(this.delegate, invocation.getArguments());
            }
            this.constructor = null;
            this.constructorArgs = null;
            this.invocations = null;
        }
    }
}

