/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.tool;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.List;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import org.apache.avro.Schema;
import org.apache.avro.SchemaNormalization;
import org.apache.avro.tool.Tool;
import org.apache.avro.tool.Util;

public class SchemaFingerprintTool
implements Tool {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int run(InputStream in, PrintStream out, PrintStream err, List<String> args) throws Exception {
        OptionParser optParser = new OptionParser();
        ArgumentAcceptingOptionSpec fingerprintOpt = optParser.accepts("fingerprint", "Fingerprint algorithm to use. Recommended Avro practice dictiates that \"CRC-64-AVRO\" is used for 64-bit fingerprints, \"MD5\" is used for 128-bit fingerprints, and \"SHA-256\" is used for 256-bit fingerprints.").withRequiredArg().ofType(String.class).defaultsTo((Object)"CRC-64-AVRO", (Object[])new String[0]);
        OptionSet opts = optParser.parse(args.toArray(new String[0]));
        Schema.Parser parser = new Schema.Parser();
        List nargs = opts.nonOptionArguments();
        if (nargs.size() < 1) {
            this.printHelp(out, optParser);
            return 0;
        }
        for (String fileOrStdin : opts.nonOptionArguments()) {
            BufferedInputStream input = Util.fileOrStdin(fileOrStdin, in);
            try {
                Schema schema = parser.parse((InputStream)input);
                byte[] fingerprint = SchemaNormalization.parsingFingerprint((String)((String)opts.valueOf((OptionSpec)fingerprintOpt)), (Schema)schema);
                out.format("%s %s%n", Util.encodeHex(fingerprint), fileOrStdin);
            }
            finally {
                Util.close(input);
            }
        }
        return 0;
    }

    @Override
    public String getName() {
        return "fingerprint";
    }

    @Override
    public String getShortDescription() {
        return "Returns the fingerprint for the schemas.";
    }

    private void printHelp(PrintStream out, OptionParser optParser) throws IOException {
        out.println("fingerprint [--fingerprint <fingerprint>] input-file [inputfile [inputfile...]]");
        out.println();
        out.println("generates fingerprints based on Avro specification.");
        optParser.printHelpOn((OutputStream)out);
        out.println("A dash ('-') can be given to read a schema from stdin");
    }
}

