/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee9.nested.jmx;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jetty.ee9.nested.ContextHandler;
import org.eclipse.jetty.ee9.nested.jmx.AbstractHandlerMBean;
import org.eclipse.jetty.util.Attributes;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.annotation.ManagedOperation;
import org.eclipse.jetty.util.annotation.Name;

@ManagedObject(value="ContextHandler mbean wrapper")
public class ContextHandlerMBean
extends AbstractHandlerMBean {
    public ContextHandlerMBean(Object managedObject) {
        super(managedObject);
    }

    @Override
    public ContextHandler getManagedObject() {
        return (ContextHandler)super.getManagedObject();
    }

    public String getObjectNameBasis() {
        return this.getManagedObject().getDisplayName();
    }

    public String getObjectContextBasis() {
        String ctxPath = this.getManagedObject().getContextPath();
        if (StringUtil.isBlank((String)ctxPath) || "/".equals(ctxPath)) {
            ctxPath = "ROOT";
        }
        Object context = ctxPath.replaceAll("/", "_");
        String[] vHosts = this.getManagedObject().getVirtualHosts();
        if (vHosts != null && vHosts.length > 0) {
            context = (String)context + "@" + vHosts[0];
        }
        return context;
    }

    @ManagedAttribute(value="Map of context attributes")
    public Map<String, String> getContextAttributes() {
        HashMap<String, String> map = new HashMap<String, String>();
        Attributes attrs = this.getManagedObject().getAttributes();
        for (String name : attrs.getAttributeNameSet()) {
            map.put(name, String.valueOf(attrs.getAttribute(name)));
        }
        return map;
    }

    @ManagedOperation(value="Set context attribute", impact="ACTION")
    public void setContextAttribute(@Name(value="name", description="attribute name") String name, @Name(value="value", description="attribute value") Object value) {
        Attributes attrs = this.getManagedObject().getAttributes();
        attrs.setAttribute(name, value);
    }

    @ManagedOperation(value="Set context attribute", impact="ACTION")
    public void setContextAttribute(@Name(value="name", description="attribute name") String name, @Name(value="value", description="attribute value") String value) {
        Attributes attrs = this.getManagedObject().getAttributes();
        attrs.setAttribute(name, (Object)value);
    }

    @ManagedOperation(value="Remove context attribute", impact="ACTION")
    public void removeContextAttribute(@Name(value="name", description="attribute name") String name) {
        Attributes attrs = this.getManagedObject().getAttributes();
        attrs.removeAttribute(name);
    }
}

