/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language.simple.types;

public enum BinaryOperatorType {
    EQ,
    EQ_IGNORE,
    GT,
    GTE,
    LT,
    LTE,
    NOT_EQ,
    NOT_EQ_IGNORE,
    CONTAINS,
    NOT_CONTAINS,
    CONTAINS_IGNORECASE,
    NOT_CONTAINS_IGNORECASE,
    REGEX,
    NOT_REGEX,
    IN,
    NOT_IN,
    IS,
    NOT_IS,
    RANGE,
    NOT_RANGE,
    STARTS_WITH,
    ENDS_WITH;


    public static BinaryOperatorType asOperator(String text) {
        if ("==".equals(text)) {
            return EQ;
        }
        if ("=~".equals(text)) {
            return EQ_IGNORE;
        }
        if (">".equals(text)) {
            return GT;
        }
        if (">=".equals(text)) {
            return GTE;
        }
        if ("<".equals(text)) {
            return LT;
        }
        if ("<=".equals(text)) {
            return LTE;
        }
        if ("!=".equals(text)) {
            return NOT_EQ;
        }
        if ("!=~".equals(text)) {
            return NOT_EQ_IGNORE;
        }
        if ("contains".equals(text)) {
            return CONTAINS;
        }
        if ("!contains".equals(text) || "not contains".equals(text)) {
            return NOT_CONTAINS;
        }
        if ("~~".equals(text)) {
            return CONTAINS_IGNORECASE;
        }
        if ("!~~".equals(text)) {
            return NOT_CONTAINS_IGNORECASE;
        }
        if ("regex".equals(text)) {
            return REGEX;
        }
        if ("!regex".equals(text) || "not regex".equals(text)) {
            return NOT_REGEX;
        }
        if ("in".equals(text)) {
            return IN;
        }
        if ("!in".equals(text) || "not in".equals(text)) {
            return NOT_IN;
        }
        if ("is".equals(text)) {
            return IS;
        }
        if ("!is".equals(text) || "not is".equals(text)) {
            return NOT_IS;
        }
        if ("range".equals(text)) {
            return RANGE;
        }
        if ("!range".equals(text) || "not range".equals(text)) {
            return NOT_RANGE;
        }
        if ("startsWith".equals(text) || "starts with".equals(text)) {
            return STARTS_WITH;
        }
        if ("endsWith".equals(text) || "ends with".equals(text)) {
            return ENDS_WITH;
        }
        throw new IllegalArgumentException("Operator not supported: " + text);
    }

    public static String getOperatorText(BinaryOperatorType operator) {
        if (operator == EQ) {
            return "==";
        }
        if (operator == EQ_IGNORE) {
            return "=~";
        }
        if (operator == GT) {
            return ">";
        }
        if (operator == GTE) {
            return ">=";
        }
        if (operator == LT) {
            return "<";
        }
        if (operator == LTE) {
            return "<=";
        }
        if (operator == NOT_EQ) {
            return "!=";
        }
        if (operator == NOT_EQ_IGNORE) {
            return "!=~";
        }
        if (operator == CONTAINS) {
            return "contains";
        }
        if (operator == NOT_CONTAINS) {
            return "!contains";
        }
        if (operator == CONTAINS_IGNORECASE) {
            return "~~";
        }
        if (operator == NOT_CONTAINS_IGNORECASE) {
            return "!~~";
        }
        if (operator == REGEX) {
            return "regex";
        }
        if (operator == NOT_REGEX) {
            return "!regex";
        }
        if (operator == IN) {
            return "in";
        }
        if (operator == NOT_IN) {
            return "!in";
        }
        if (operator == IS) {
            return "is";
        }
        if (operator == NOT_IS) {
            return "!is";
        }
        if (operator == RANGE) {
            return "range";
        }
        if (operator == NOT_RANGE) {
            return "!range";
        }
        if (operator == STARTS_WITH) {
            return "startsWith";
        }
        if (operator == ENDS_WITH) {
            return "endsWith";
        }
        return "";
    }

    public static ParameterType[] supportedParameterTypes(BinaryOperatorType operator) {
        if (operator == EQ) {
            return null;
        }
        if (operator == EQ_IGNORE) {
            return null;
        }
        if (operator == GT) {
            return null;
        }
        if (operator == GTE) {
            return null;
        }
        if (operator == LT) {
            return null;
        }
        if (operator == LTE) {
            return null;
        }
        if (operator == NOT_EQ) {
            return null;
        }
        if (operator == NOT_EQ_IGNORE) {
            return null;
        }
        if (operator == CONTAINS) {
            return null;
        }
        if (operator == NOT_CONTAINS) {
            return null;
        }
        if (operator == CONTAINS_IGNORECASE) {
            return null;
        }
        if (operator == NOT_CONTAINS_IGNORECASE) {
            return null;
        }
        if (operator == REGEX) {
            return new ParameterType[]{ParameterType.Literal, ParameterType.Function};
        }
        if (operator == NOT_REGEX) {
            return new ParameterType[]{ParameterType.Literal, ParameterType.Function};
        }
        if (operator == IN) {
            return null;
        }
        if (operator == NOT_IN) {
            return null;
        }
        if (operator == IS) {
            return new ParameterType[]{ParameterType.LiteralWithFunction, ParameterType.Function};
        }
        if (operator == NOT_IS) {
            return new ParameterType[]{ParameterType.LiteralWithFunction, ParameterType.Function};
        }
        if (operator == RANGE) {
            return new ParameterType[]{ParameterType.LiteralWithFunction, ParameterType.Function};
        }
        if (operator == NOT_RANGE) {
            return new ParameterType[]{ParameterType.LiteralWithFunction, ParameterType.Function};
        }
        if (operator == STARTS_WITH) {
            return null;
        }
        if (operator == ENDS_WITH) {
            return null;
        }
        return null;
    }

    public String toString() {
        return BinaryOperatorType.getOperatorText(this);
    }

    public static enum ParameterType {
        Literal,
        LiteralWithFunction,
        Function,
        NumericValue,
        BooleanValue,
        NullValue,
        MinusValue;


        public boolean isLiteralSupported() {
            return this == Literal;
        }

        public boolean isLiteralWithFunctionSupport() {
            return this == LiteralWithFunction;
        }

        public boolean isFunctionSupport() {
            return this == Function;
        }

        public boolean isNumericValueSupported() {
            return this == NumericValue;
        }

        public boolean isBooleanValueSupported() {
            return this == BooleanValue;
        }

        public boolean isNullValueSupported() {
            return this == NullValue;
        }

        public boolean isMinusValueSupported() {
            return this == MinusValue;
        }
    }
}

