/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Navigate;
import org.apache.camel.Predicate;
import org.apache.camel.Processor;
import org.apache.camel.builder.PredicateBuilder;
import org.apache.camel.component.bean.BeanInfo;
import org.apache.camel.component.bean.BeanProcessor;
import org.apache.camel.processor.CamelInternalProcessor;
import org.apache.camel.support.ServiceSupport;
import org.apache.camel.util.AsyncProcessorHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.ServiceHelper;

public final class SubscribeMethodProcessor
extends ServiceSupport
implements AsyncProcessor,
Navigate<Processor> {
    private final Endpoint endpoint;
    private final Map<AsyncProcessor, Predicate> methods = new LinkedHashMap<AsyncProcessor, Predicate>();

    public SubscribeMethodProcessor(Endpoint endpoint) {
        this.endpoint = endpoint;
    }

    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    protected void addMethod(Object pojo, Method method, Endpoint endpoint, String predicate) {
        BeanInfo info = new BeanInfo(endpoint.getCamelContext(), method);
        BeanProcessor answer = new BeanProcessor(pojo, info);
        CamelInternalProcessor internal = new CamelInternalProcessor((Processor)answer);
        internal.addAdvice(new CamelInternalProcessor.UnitOfWorkProcessorAdvice(null));
        Predicate p = ObjectHelper.isEmpty(predicate) ? PredicateBuilder.constant(true) : endpoint.getCamelContext().resolveLanguage("simple").createPredicate(predicate);
        this.methods.put(internal, p);
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        AsyncProcessorHelper.process(this, exchange);
    }

    @Override
    public boolean process(Exchange exchange, AsyncCallback callback) {
        try {
            for (Map.Entry<AsyncProcessor, Predicate> entry : this.methods.entrySet()) {
                Predicate predicate = entry.getValue();
                if (!predicate.matches(exchange)) continue;
                return entry.getKey().process(exchange, callback);
            }
        }
        catch (Throwable e) {
            exchange.setException(e);
        }
        callback.done(true);
        return true;
    }

    @Override
    protected void doStart() throws Exception {
        ServiceHelper.startServices(this.methods.keySet());
    }

    @Override
    protected void doStop() throws Exception {
        ServiceHelper.stopServices(this.methods.keySet());
    }

    @Override
    protected void doShutdown() throws Exception {
        ServiceHelper.stopAndShutdownServices(this.methods.keySet());
    }

    public String toString() {
        return "SubscribeMethodProcessor[" + this.endpoint + "]";
    }

    @Override
    public List<Processor> next() {
        return new ArrayList<Processor>(this.methods.keySet());
    }

    @Override
    public boolean hasNext() {
        return !this.methods.isEmpty();
    }
}

