/* sp_x86_64_asm
 *
 * Copyright (C) 2006-2021 wolfSSL Inc.
 *
 * This file is part of wolfSSL.
 *
 * wolfSSL is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * wolfSSL is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1335, USA
 */

#ifndef HAVE_INTEL_AVX1
#define HAVE_INTEL_AVX1
#endif /* HAVE_INTEL_AVX1 */
#ifndef NO_AVX2_SUPPORT
#define HAVE_INTEL_AVX2
#endif /* NO_AVX2_SUPPORT */

#ifdef WOLFSSL_SP_X86_64_ASM
#ifndef WOLFSSL_SP_NO_2048
#ifndef WOLFSSL_SP_NO_2048
/* Read big endian unsigned byte array into r.
 * Uses the bswap instruction.
 *
 * r  A single precision integer.
 * size  Maximum number of bytes to convert
 * a  Byte array.
 * n  Number of bytes in array to read.
 */
#ifndef __APPLE__
.text
.globl	sp_2048_from_bin_bswap
.type	sp_2048_from_bin_bswap,@function
.align	16
sp_2048_from_bin_bswap:
#else
.section	__TEXT,__text
.globl	_sp_2048_from_bin_bswap
.p2align	4
_sp_2048_from_bin_bswap:
#endif /* __APPLE__ */
        movq	%rdx, %r9
        movq	%rdi, %r10
        addq	%rcx, %r9
        addq	$0x100, %r10
        xorq	%r11, %r11
        jmp	L_2048_from_bin_bswap_64_end
L_2048_from_bin_bswap_64_start:
        subq	$0x40, %r9
        movq	56(%r9), %rax
        movq	48(%r9), %r8
        bswapq	%rax
        bswapq	%r8
        movq	%rax, (%rdi)
        movq	%r8, 8(%rdi)
        movq	40(%r9), %rax
        movq	32(%r9), %r8
        bswapq	%rax
        bswapq	%r8
        movq	%rax, 16(%rdi)
        movq	%r8, 24(%rdi)
        movq	24(%r9), %rax
        movq	16(%r9), %r8
        bswapq	%rax
        bswapq	%r8
        movq	%rax, 32(%rdi)
        movq	%r8, 40(%rdi)
        movq	8(%r9), %rax
        movq	(%r9), %r8
        bswapq	%rax
        bswapq	%r8
        movq	%rax, 48(%rdi)
        movq	%r8, 56(%rdi)
        addq	$0x40, %rdi
        subq	$0x40, %rcx
L_2048_from_bin_bswap_64_end:
        cmpq	$63, %rcx
        jg	L_2048_from_bin_bswap_64_start
        jmp	L_2048_from_bin_bswap_8_end
L_2048_from_bin_bswap_8_start:
        subq	$8, %r9
        movq	(%r9), %rax
        bswapq	%rax
        movq	%rax, (%rdi)
        addq	$8, %rdi
        subq	$8, %rcx
L_2048_from_bin_bswap_8_end:
        cmpq	$7, %rcx
        jg	L_2048_from_bin_bswap_8_start
        cmpq	%r11, %rcx
        je	L_2048_from_bin_bswap_hi_end
        movq	%r11, %r8
        movq	%r11, %rax
L_2048_from_bin_bswap_hi_start:
        movb	(%rdx), %al
        shlq	$8, %r8
        incq	%rdx
        addq	%rax, %r8
        decq	%rcx
        jg	L_2048_from_bin_bswap_hi_start
        movq	%r8, (%rdi)
        addq	$8, %rdi
L_2048_from_bin_bswap_hi_end:
        cmpq	%r10, %rdi
        jge	L_2048_from_bin_bswap_zero_end
L_2048_from_bin_bswap_zero_start:
        movq	%r11, (%rdi)
        addq	$8, %rdi
        cmpq	%r10, %rdi
        jl	L_2048_from_bin_bswap_zero_start
L_2048_from_bin_bswap_zero_end:
        repz retq
#ifndef __APPLE__
.size	sp_2048_from_bin_bswap,.-sp_2048_from_bin_bswap
#endif /* __APPLE__ */
#ifndef NO_MOVBE_SUPPORT
/* Read big endian unsigned byte array into r.
 * Uses the movbe instruction which is an optional instruction.
 *
 * r  A single precision integer.
 * size  Maximum number of bytes to convert
 * a  Byte array.
 * n  Number of bytes in array to read.
 */
#ifndef __APPLE__
.text
.globl	sp_2048_from_bin_movbe
.type	sp_2048_from_bin_movbe,@function
.align	16
sp_2048_from_bin_movbe:
#else
.section	__TEXT,__text
.globl	_sp_2048_from_bin_movbe
.p2align	4
_sp_2048_from_bin_movbe:
#endif /* __APPLE__ */
        movq	%rdx, %r9
        movq	%rdi, %r10
        addq	%rcx, %r9
        addq	$0x100, %r10
        jmp	L_2048_from_bin_movbe_64_end
L_2048_from_bin_movbe_64_start:
        subq	$0x40, %r9
        movbeq	56(%r9), %rax
        movbeq	48(%r9), %r8
        movq	%rax, (%rdi)
        movq	%r8, 8(%rdi)
        movbeq	40(%r9), %rax
        movbeq	32(%r9), %r8
        movq	%rax, 16(%rdi)
        movq	%r8, 24(%rdi)
        movbeq	24(%r9), %rax
        movbeq	16(%r9), %r8
        movq	%rax, 32(%rdi)
        movq	%r8, 40(%rdi)
        movbeq	8(%r9), %rax
        movbeq	(%r9), %r8
        movq	%rax, 48(%rdi)
        movq	%r8, 56(%rdi)
        addq	$0x40, %rdi
        subq	$0x40, %rcx
L_2048_from_bin_movbe_64_end:
        cmpq	$63, %rcx
        jg	L_2048_from_bin_movbe_64_start
        jmp	L_2048_from_bin_movbe_8_end
L_2048_from_bin_movbe_8_start:
        subq	$8, %r9
        movbeq	(%r9), %rax
        movq	%rax, (%rdi)
        addq	$8, %rdi
        subq	$8, %rcx
L_2048_from_bin_movbe_8_end:
        cmpq	$7, %rcx
        jg	L_2048_from_bin_movbe_8_start
        cmpq	$0x00, %rcx
        je	L_2048_from_bin_movbe_hi_end
        movq	$0x00, %r8
        movq	$0x00, %rax
L_2048_from_bin_movbe_hi_start:
        movb	(%rdx), %al
        shlq	$8, %r8
        incq	%rdx
        addq	%rax, %r8
        decq	%rcx
        jg	L_2048_from_bin_movbe_hi_start
        movq	%r8, (%rdi)
        addq	$8, %rdi
L_2048_from_bin_movbe_hi_end:
        cmpq	%r10, %rdi
        jge	L_2048_from_bin_movbe_zero_end
L_2048_from_bin_movbe_zero_start:
        movq	$0x00, (%rdi)
        addq	$8, %rdi
        cmpq	%r10, %rdi
        jl	L_2048_from_bin_movbe_zero_start
L_2048_from_bin_movbe_zero_end:
        repz retq
#ifndef __APPLE__
.size	sp_2048_from_bin_movbe,.-sp_2048_from_bin_movbe
#endif /* __APPLE__ */
#endif /* !NO_MOVBE_SUPPORT */
/* Write r as big endian to byte array.
 * Fixed length number of bytes written: 256
 * Uses the bswap instruction.
 *
 * r  A single precision integer.
 * a  Byte array.
 */
#ifndef __APPLE__
.text
.globl	sp_2048_to_bin_bswap_32
.type	sp_2048_to_bin_bswap_32,@function
.align	16
sp_2048_to_bin_bswap_32:
#else
.section	__TEXT,__text
.globl	_sp_2048_to_bin_bswap_32
.p2align	4
_sp_2048_to_bin_bswap_32:
#endif /* __APPLE__ */
        movq	248(%rdi), %rdx
        movq	240(%rdi), %rax
        bswapq	%rdx
        bswapq	%rax
        movq	%rdx, (%rsi)
        movq	%rax, 8(%rsi)
        movq	232(%rdi), %rdx
        movq	224(%rdi), %rax
        bswapq	%rdx
        bswapq	%rax
        movq	%rdx, 16(%rsi)
        movq	%rax, 24(%rsi)
        movq	216(%rdi), %rdx
        movq	208(%rdi), %rax
        bswapq	%rdx
        bswapq	%rax
        movq	%rdx, 32(%rsi)
        movq	%rax, 40(%rsi)
        movq	200(%rdi), %rdx
        movq	192(%rdi), %rax
        bswapq	%rdx
        bswapq	%rax
        movq	%rdx, 48(%rsi)
        movq	%rax, 56(%rsi)
        movq	184(%rdi), %rdx
        movq	176(%rdi), %rax
        bswapq	%rdx
        bswapq	%rax
        movq	%rdx, 64(%rsi)
        movq	%rax, 72(%rsi)
        movq	168(%rdi), %rdx
        movq	160(%rdi), %rax
        bswapq	%rdx
        bswapq	%rax
        movq	%rdx, 80(%rsi)
        movq	%rax, 88(%rsi)
        movq	152(%rdi), %rdx
        movq	144(%rdi), %rax
        bswapq	%rdx
        bswapq	%rax
        movq	%rdx, 96(%rsi)
        movq	%rax, 104(%rsi)
        movq	136(%rdi), %rdx
        movq	128(%rdi), %rax
        bswapq	%rdx
        bswapq	%rax
        movq	%rdx, 112(%rsi)
        movq	%rax, 120(%rsi)
        movq	120(%rdi), %rdx
        movq	112(%rdi), %rax
        bswapq	%rdx
        bswapq	%rax
        movq	%rdx, 128(%rsi)
        movq	%rax, 136(%rsi)
        movq	104(%rdi), %rdx
        movq	96(%rdi), %rax
        bswapq	%rdx
        bswapq	%rax
        movq	%rdx, 144(%rsi)
        movq	%rax, 152(%rsi)
        movq	88(%rdi), %rdx
        movq	80(%rdi), %rax
        bswapq	%rdx
        bswapq	%rax
        movq	%rdx, 160(%rsi)
        movq	%rax, 168(%rsi)
        movq	72(%rdi), %rdx
        movq	64(%rdi), %rax
        bswapq	%rdx
        bswapq	%rax
        movq	%rdx, 176(%rsi)
        movq	%rax, 184(%rsi)
        movq	56(%rdi), %rdx
        movq	48(%rdi), %rax
        bswapq	%rdx
        bswapq	%rax
        movq	%rdx, 192(%rsi)
        movq	%rax, 200(%rsi)
        movq	40(%rdi), %rdx
        movq	32(%rdi), %rax
        bswapq	%rdx
        bswapq	%rax
        movq	%rdx, 208(%rsi)
        movq	%rax, 216(%rsi)
        movq	24(%rdi), %rdx
        movq	16(%rdi), %rax
        bswapq	%rdx
        bswapq	%rax
        movq	%rdx, 224(%rsi)
        movq	%rax, 232(%rsi)
        movq	8(%rdi), %rdx
        movq	(%rdi), %rax
        bswapq	%rdx
        bswapq	%rax
        movq	%rdx, 240(%rsi)
        movq	%rax, 248(%rsi)
        repz retq
#ifndef __APPLE__
.size	sp_2048_to_bin_bswap_32,.-sp_2048_to_bin_bswap_32
#endif /* __APPLE__ */
#ifndef NO_MOVBE_SUPPORT
/* Write r as big endian to byte array.
 * Fixed length number of bytes written: 256
 * Uses the movbe instruction which is optional.
 *
 * r  A single precision integer.
 * a  Byte array.
 */
#ifndef __APPLE__
.text
.globl	sp_2048_to_bin_movbe_32
.type	sp_2048_to_bin_movbe_32,@function
.align	16
sp_2048_to_bin_movbe_32:
#else
.section	__TEXT,__text
.globl	_sp_2048_to_bin_movbe_32
.p2align	4
_sp_2048_to_bin_movbe_32:
#endif /* __APPLE__ */
        movbeq	248(%rdi), %rdx
        movbeq	240(%rdi), %rax
        movq	%rdx, (%rsi)
        movq	%rax, 8(%rsi)
        movbeq	232(%rdi), %rdx
        movbeq	224(%rdi), %rax
        movq	%rdx, 16(%rsi)
        movq	%rax, 24(%rsi)
        movbeq	216(%rdi), %rdx
        movbeq	208(%rdi), %rax
        movq	%rdx, 32(%rsi)
        movq	%rax, 40(%rsi)
        movbeq	200(%rdi), %rdx
        movbeq	192(%rdi), %rax
        movq	%rdx, 48(%rsi)
        movq	%rax, 56(%rsi)
        movbeq	184(%rdi), %rdx
        movbeq	176(%rdi), %rax
        movq	%rdx, 64(%rsi)
        movq	%rax, 72(%rsi)
        movbeq	168(%rdi), %rdx
        movbeq	160(%rdi), %rax
        movq	%rdx, 80(%rsi)
        movq	%rax, 88(%rsi)
        movbeq	152(%rdi), %rdx
        movbeq	144(%rdi), %rax
        movq	%rdx, 96(%rsi)
        movq	%rax, 104(%rsi)
        movbeq	136(%rdi), %rdx
        movbeq	128(%rdi), %rax
        movq	%rdx, 112(%rsi)
        movq	%rax, 120(%rsi)
        movbeq	120(%rdi), %rdx
        movbeq	112(%rdi), %rax
        movq	%rdx, 128(%rsi)
        movq	%rax, 136(%rsi)
        movbeq	104(%rdi), %rdx
        movbeq	96(%rdi), %rax
        movq	%rdx, 144(%rsi)
        movq	%rax, 152(%rsi)
        movbeq	88(%rdi), %rdx
        movbeq	80(%rdi), %rax
        movq	%rdx, 160(%rsi)
        movq	%rax, 168(%rsi)
        movbeq	72(%rdi), %rdx
        movbeq	64(%rdi), %rax
        movq	%rdx, 176(%rsi)
        movq	%rax, 184(%rsi)
        movbeq	56(%rdi), %rdx
        movbeq	48(%rdi), %rax
        movq	%rdx, 192(%rsi)
        movq	%rax, 200(%rsi)
        movbeq	40(%rdi), %rdx
        movbeq	32(%rdi), %rax
        movq	%rdx, 208(%rsi)
        movq	%rax, 216(%rsi)
        movbeq	24(%rdi), %rdx
        movbeq	16(%rdi), %rax
        movq	%rdx, 224(%rsi)
        movq	%rax, 232(%rsi)
        movbeq	8(%rdi), %rdx
        movbeq	(%rdi), %rax
        movq	%rdx, 240(%rsi)
        movq	%rax, 248(%rsi)
        repz retq
#ifndef __APPLE__
.size	sp_2048_to_bin_movbe_32,.-sp_2048_to_bin_movbe_32
#endif /* __APPLE__ */
#endif /* NO_MOVBE_SUPPORT */
/* Multiply a and b into r. (r = a * b)
 *
 * r  A single precision integer.
 * a  A single precision integer.
 * b  A single precision integer.
 */
#ifndef __APPLE__
.text
.globl	sp_2048_mul_16
.type	sp_2048_mul_16,@function
.align	16
sp_2048_mul_16:
#else
.section	__TEXT,__text
.globl	_sp_2048_mul_16
.p2align	4
_sp_2048_mul_16:
#endif /* __APPLE__ */
        movq	%rdx, %rcx
        subq	$0x80, %rsp
        # A[0] * B[0]
        movq	(%rcx), %rax
        mulq	(%rsi)
        xorq	%r10, %r10
        movq	%rax, (%rsp)
        movq	%rdx, %r9
        # A[0] * B[1]
        movq	8(%rcx), %rax
        mulq	(%rsi)
        xorq	%r8, %r8
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0x00, %r8
        # A[1] * B[0]
        movq	(%rcx), %rax
        mulq	8(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0x00, %r8
        movq	%r9, 8(%rsp)
        # A[0] * B[2]
        movq	16(%rcx), %rax
        mulq	(%rsi)
        xorq	%r9, %r9
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0x00, %r9
        # A[1] * B[1]
        movq	8(%rcx), %rax
        mulq	8(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0x00, %r9
        # A[2] * B[0]
        movq	(%rcx), %rax
        mulq	16(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0x00, %r9
        movq	%r10, 16(%rsp)
        # A[0] * B[3]
        movq	24(%rcx), %rax
        mulq	(%rsi)
        xorq	%r10, %r10
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0x00, %r10
        # A[1] * B[2]
        movq	16(%rcx), %rax
        mulq	8(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0x00, %r10
        # A[2] * B[1]
        movq	8(%rcx), %rax
        mulq	16(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0x00, %r10
        # A[3] * B[0]
        movq	(%rcx), %rax
        mulq	24(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0x00, %r10
        movq	%r8, 24(%rsp)
        # A[0] * B[4]
        movq	32(%rcx), %rax
        mulq	(%rsi)
        xorq	%r8, %r8
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0x00, %r8
        # A[1] * B[3]
        movq	24(%rcx), %rax
        mulq	8(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0x00, %r8
        # A[2] * B[2]
        movq	16(%rcx), %rax
        mulq	16(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0x00, %r8
        # A[3] * B[1]
        movq	8(%rcx), %rax
        mulq	24(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0x00, %r8
        # A[4] * B[0]
        movq	(%rcx), %rax
        mulq	32(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0x00, %r8
        movq	%r9, 32(%rsp)
        # A[0] * B[5]
        movq	40(%rcx), %rax
        mulq	(%rsi)
        xorq	%r9, %r9
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0x00, %r9
        # A[1] * B[4]
        movq	32(%rcx), %rax
        mulq	8(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0x00, %r9
        # A[2] * B[3]
        movq	24(%rcx), %rax
        mulq	16(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0x00, %r9
        # A[3] * B[2]
        movq	16(%rcx), %rax
        mulq	24(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0x00, %r9
        # A[4] * B[1]
        movq	8(%rcx), %rax
        mulq	32(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0x00, %r9
        # A[5] * B[0]
        movq	(%rcx), %rax
        mulq	40(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0x00, %r9
        movq	%r10, 40(%rsp)
        # A[0] * B[6]
        movq	48(%rcx), %rax
        mulq	(%rsi)
        xorq	%r10, %r10
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0x00, %r10
        # A[1] * B[5]
        movq	40(%rcx), %rax
        mulq	8(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0x00, %r10
        # A[2] * B[4]
        movq	32(%rcx), %rax
        mulq	16(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0x00, %r10
        # A[3] * B[3]
        movq	24(%rcx), %rax
        mulq	24(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0x00, %r10
        # A[4] * B[2]
        movq	16(%rcx), %rax
        mulq	32(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0x00, %r10
        # A[5] * B[1]
        movq	8(%rcx), %rax
        mulq	40(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0x00, %r10
        # A[6] * B[0]
        movq	(%rcx), %rax
        mulq	48(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0x00, %r10
        movq	%r8, 48(%rsp)
        # A[0] * B[7]
        movq	56(%rcx), %rax
        mulq	(%rsi)
        xorq	%r8, %r8
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0x00, %r8
        # A[1] * B[6]
        movq	48(%rcx), %rax
        mulq	8(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0x00, %r8
        # A[2] * B[5]
        movq	40(%rcx), %rax
        mulq	16(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0x00, %r8
        # A[3] * B[4]
        movq	32(%rcx), %rax
        mulq	24(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0x00, %r8
        # A[4] * B[3]
        movq	24(%rcx), %rax
        mulq	32(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0x00, %r8
        # A[5] * B[2]
        movq	16(%rcx), %rax
        mulq	40(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0x00, %r8
        # A[6] * B[1]
        movq	8(%rcx), %rax
        mulq	48(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0x00, %r8
        # A[7] * B[0]
        movq	(%rcx), %rax
        mulq	56(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0x00, %r8
        movq	%r9, 56(%rsp)
        # A[0] * B[8]
        movq	64(%rcx), %rax
        mulq	(%rsi)
        xorq	%r9, %r9
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0x00, %r9
        # A[1] * B[7]
        movq	56(%rcx), %rax
        mulq	8(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0x00, %r9
        # A[2] * B[6]
        movq	48(%rcx), %rax
        mulq	16(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0x00, %r9
        # A[3] * B[5]
        movq	40(%rcx), %rax
        mulq	24(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0x00, %r9
        # A[4] * B[4]
        movq	32(%rcx), %rax
        mulq	32(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0x00, %r9
        # A[5] * B[3]
        movq	24(%rcx), %rax
        mulq	40(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0x00, %r9
        # A[6] * B[2]
        movq	16(%rcx), %rax
        mulq	48(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0x00, %r9
        # A[7] * B[1]
        movq	8(%rcx), %rax
        mulq	56(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0x00, %r9
        # A[8] * B[0]
        movq	(%rcx), %rax
        mulq	64(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0x00, %r9
        movq	%r10, 64(%rsp)
        # A[0] * B[9]
        movq	72(%rcx), %rax
        mulq	(%rsi)
        xorq	%r10, %r10
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0x00, %r10
        # A[1] * B[8]
        movq	64(%rcx), %rax
        mulq	8(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0x00, %r10
        # A[2] * B[7]
        movq	56(%rcx), %rax
        mulq	16(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0x00, %r10
        # A[3] * B[6]
        movq	48(%rcx), %rax
        mulq	24(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0x00, %r10
        # A[4] * B[5]
        movq	40(%rcx), %rax
        mulq	32(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0x00, %r10
        # A[5] * B[4]
        movq	32(%rcx), %rax
        mulq	40(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0x00, %r10
        # A[6] * B[3]
        movq	24(%rcx), %rax
        mulq	48(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0x00, %r10
        # A[7] * B[2]
        movq	16(%rcx), %rax
        mulq	56(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0x00, %r10
        # A[8] * B[1]
        movq	8(%rcx), %rax
        mulq	64(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0x00, %r10
        # A[9] * B[0]
        movq	(%rcx), %rax
        mulq	72(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0x00, %r10
        movq	%r8, 72(%rsp)
        # A[0] * B[10]
        movq	80(%rcx), %rax
        mulq	(%rsi)
        xorq	%r8, %r8
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0x00, %r8
        # A[1] * B[9]
        movq	72(%rcx), %rax
        mulq	8(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0x00, %r8
        # A[2] * B[8]
        movq	64(%rcx), %rax
        mulq	16(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0x00, %r8
        # A[3] * B[7]
        movq	56(%rcx), %rax
        mulq	24(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0x00, %r8
        # A[4] * B[6]
        movq	48(%rcx), %rax
        mulq	32(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0x00, %r8
        # A[5] * B[5]
        movq	40(%rcx), %rax
        mulq	40(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0x00, %r8
        # A[6] * B[4]
        movq	32(%rcx), %rax
        mulq	48(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0x00, %r8
        # A[7] * B[3]
        movq	24(%rcx), %rax
        mulq	56(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0x00, %r8
        # A[8] * B[2]
        movq	16(%rcx), %rax
        mulq	64(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0x00, %r8
        # A[9] * B[1]
        movq	8(%rcx), %rax
        mulq	72(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0x00, %r8
        # A[10] * B[0]
        movq	(%rcx), %rax
        mulq	80(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0x00, %r8
        movq	%r9, 80(%rsp)
        # A[0] * B[11]
        movq	88(%rcx), %rax
        mulq	(%rsi)
        xorq	%r9, %r9
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0x00, %r9
        # A[1] * B[10]
        movq	80(%rcx), %rax
        mulq	8(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0x00, %r9
        # A[2] * B[9]
        movq	72(%rcx), %rax
        mulq	16(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0x00, %r9
        # A[3] * B[8]
        movq	64(%rcx), %rax
        mulq	24(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0x00, %r9
        # A[4] * B[7]
        movq	56(%rcx), %rax
        mulq	32(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0x00, %r9
        # A[5] * B[6]
        movq	48(%rcx), %rax
        mulq	40(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0x00, %r9
        # A[6] * B[5]
        movq	40(%rcx), %rax
        mulq	48(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0x00, %r9
        # A[7] * B[4]
        movq	32(%rcx), %rax
        mulq	56(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0x00, %r9
        # A[8] * B[3]
        movq	24(%rcx), %rax
        mulq	64(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0x00, %r9
        # A[9] * B[2]
        movq	16(%rcx), %rax
        mulq	72(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0x00, %r9
        # A[10] * B[1]
        movq	8(%rcx), %rax
        mulq	80(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0x00, %r9
        # A[11] * B[0]
        movq	(%rcx), %rax
        mulq	88(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0x00, %r9
        movq	%r10, 88(%rsp)
        # A[0] * B[12]
        movq	96(%rcx), %rax
        mulq	(%rsi)
        xorq	%r10, %r10
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0x00, %r10
        # A[1] * B[11]
        movq	88(%rcx), %rax
        mulq	8(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0x00, %r10
        # A[2] * B[10]
        movq	80(%rcx), %rax
        mulq	16(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0x00, %r10
        # A[3] * B[9]
        movq	72(%rcx), %rax
        mulq	24(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0x00, %r10
        # A[4] * B[8]
        movq	64(%rcx), %rax
        mulq	32(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0x00, %r10
        # A[5] * B[7]
        movq	56(%rcx), %rax
        mulq	40(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0x00, %r10
        # A[6] * B[6]
        movq	48(%rcx), %rax
        mulq	48(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0x00, %r10
        # A[7] * B[5]
        movq	40(%rcx), %rax
        mulq	56(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0x00, %r10
        # A[8] * B[4]
        movq	32(%rcx), %rax
        mulq	64(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0x00, %r10
        # A[9] * B[3]
        movq	24(%rcx), %rax
        mulq	72(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0x00, %r10
        # A[10] * B[2]
        movq	16(%rcx), %rax
        mulq	80(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0x00, %r10
        # A[11] * B[1]
        movq	8(%rcx), %rax
        mulq	88(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0x00, %r10
        # A[12] * B[0]
        movq	(%rcx), %rax
        mulq	96(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0x00, %r10
        movq	%r8, 96(%rsp)
        # A[0] * B[13]
        movq	104(%rcx), %rax
        mulq	(%rsi)
        xorq	%r8, %r8
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0x00, %r8
        # A[1] * B[12]
        movq	96(%rcx), %rax
        mulq	8(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0x00, %r8
        # A[2] * B[11]
        movq	88(%rcx), %rax
        mulq	16(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0x00, %r8
        # A[3] * B[10]
        movq	80(%rcx), %rax
        mulq	24(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0x00, %r8
        # A[4] * B[9]
        movq	72(%rcx), %rax
        mulq	32(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0x00, %r8
        # A[5] * B[8]
        movq	64(%rcx), %rax
        mulq	40(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0x00, %r8
        # A[6] * B[7]
        movq	56(%rcx), %rax
        mulq	48(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0x00, %r8
        # A[7] * B[6]
        movq	48(%rcx), %rax
        mulq	56(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0x00, %r8
        # A[8] * B[5]
        movq	40(%rcx), %rax
        mulq	64(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0x00, %r8
        # A[9] * B[4]
        movq	32(%rcx), %rax
        mulq	72(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0x00, %r8
        # A[10] * B[3]
        movq	24(%rcx), %rax
        mulq	80(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0x00, %r8
        # A[11] * B[2]
        movq	16(%rcx), %rax
        mulq	88(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0x00, %r8
        # A[12] * B[1]
        movq	8(%rcx), %rax
        mulq	96(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0x00, %r8
        # A[13] * B[0]
        movq	(%rcx), %rax
        mulq	104(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0x00, %r8
        movq	%r9, 104(%rsp)
        # A[0] * B[14]
        movq	112(%rcx), %rax
        mulq	(%rsi)
        xorq	%r9, %r9
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0x00, %r9
        # A[1] * B[13]
        movq	104(%rcx), %rax
        mulq	8(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0x00, %r9
        # A[2] * B[12]
        movq	96(%rcx), %rax
        mulq	16(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0x00, %r9
        # A[3] * B[11]
        movq	88(%rcx), %rax
        mulq	24(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0x00, %r9
        # A[4] * B[10]
        movq	80(%rcx), %rax
        mulq	32(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0x00, %r9
        # A[5] * B[9]
        movq	72(%rcx), %rax
        mulq	40(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0x00, %r9
        # A[6] * B[8]
        movq	64(%rcx), %rax
        mulq	48(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0x00, %r9
        # A[7] * B[7]
        movq	56(%rcx), %rax
        mulq	56(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0x00, %r9
        # A[8] * B[6]
        movq	48(%rcx), %rax
        mulq	64(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0x00, %r9
        # A[9] * B[5]
        movq	40(%rcx), %rax
        mulq	72(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0x00, %r9
        # A[10] * B[4]
        movq	32(%rcx), %rax
        mulq	80(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0x00, %r9
        # A[11] * B[3]
        movq	24(%rcx), %rax
        mulq	88(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0x00, %r9
        # A[12] * B[2]
        movq	16(%rcx), %rax
        mulq	96(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0x00, %r9
        # A[13] * B[1]
        movq	8(%rcx), %rax
        mulq	104(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0x00, %r9
        # A[14] * B[0]
        movq	(%rcx), %rax
        mulq	112(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0x00, %r9
        movq	%r10, 112(%rsp)
        # A[0] * B[15]
        movq	120(%rcx), %rax
        mulq	(%rsi)
        xorq	%r10, %r10
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0x00, %r10
        # A[1] * B[14]
        movq	112(%rcx), %rax
        mulq	8(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0x00, %r10
        # A[2] * B[13]
        movq	104(%rcx), %rax
        mulq	16(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0x00, %r10
        # A[3] * B[12]
        movq	96(%rcx), %rax
        mulq	24(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0x00, %r10
        # A[4] * B[11]
        movq	88(%rcx), %rax
        mulq	32(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0x00, %r10
        # A[5] * B[10]
        movq	80(%rcx), %rax
        mulq	40(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0x00, %r10
        # A[6] * B[9]
        movq	72(%rcx), %rax
        mulq	48(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0x00, %r10
        # A[7] * B[8]
        movq	64(%rcx), %rax
        mulq	56(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0x00, %r10
        # A[8] * B[7]
        movq	56(%rcx), %rax
        mulq	64(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0x00, %r10
        # A[9] * B[6]
        movq	48(%rcx), %rax
        mulq	72(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0x00, %r10
        # A[10] * B[5]
        movq	40(%rcx), %rax
        mulq	80(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0x00, %r10
        # A[11] * B[4]
        movq	32(%rcx), %rax
        mulq	88(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0x00, %r10
        # A[12] * B[3]
        movq	24(%rcx), %rax
        mulq	96(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0x00, %r10
        # A[13] * B[2]
        movq	16(%rcx), %rax
        mulq	104(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0x00, %r10
        # A[14] * B[1]
        movq	8(%rcx), %rax
        mulq	112(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0x00, %r10
        # A[15] * B[0]
        movq	(%rcx), %rax
        mulq	120(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0x00, %r10
        movq	%r8, 120(%rsp)
        # A[1] * B[15]
        movq	120(%rcx), %rax
        mulq	8(%rsi)
        xorq	%r8, %r8
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0x00, %r8
        # A[2] * B[14]
        movq	112(%rcx), %rax
        mulq	16(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0x00, %r8
        # A[3] * B[13]
        movq	104(%rcx), %rax
        mulq	24(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0x00, %r8
        # A[4] * B[12]
        movq	96(%rcx), %rax
        mulq	32(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0x00, %r8
        # A[5] * B[11]
        movq	88(%rcx), %rax
        mulq	40(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0x00, %r8
        # A[6] * B[10]
        movq	80(%rcx), %rax
        mulq	48(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0x00, %r8
        # A[7] * B[9]
        movq	72(%rcx), %rax
        mulq	56(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0x00, %r8
        # A[8] * B[8]
        movq	64(%rcx), %rax
        mulq	64(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0x00, %r8
        # A[9] * B[7]
        movq	56(%rcx), %rax
        mulq	72(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0x00, %r8
        # A[10] * B[6]
        movq	48(%rcx), %rax
        mulq	80(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0x00, %r8
        # A[11] * B[5]
        movq	40(%rcx), %rax
        mulq	88(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0x00, %r8
        # A[12] * B[4]
        movq	32(%rcx), %rax
        mulq	96(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0x00, %r8
        # A[13] * B[3]
        movq	24(%rcx), %rax
        mulq	104(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0x00, %r8
        # A[14] * B[2]
        movq	16(%rcx), %rax
        mulq	112(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0x00, %r8
        # A[15] * B[1]
        movq	8(%rcx), %rax
        mulq	120(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0x00, %r8
        movq	%r9, 128(%rdi)
        # A[2] * B[15]
        movq	120(%rcx), %rax
        mulq	16(%rsi)
        xorq	%r9, %r9
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0x00, %r9
        # A[3] * B[14]
        movq	112(%rcx), %rax
        mulq	24(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0x00, %r9
        # A[4] * B[13]
        movq	104(%rcx), %rax
        mulq	32(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0x00, %r9
        # A[5] * B[12]
        movq	96(%rcx), %rax
        mulq	40(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0x00, %r9
        # A[6] * B[11]
        movq	88(%rcx), %rax
        mulq	48(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0x00, %r9
        # A[7] * B[10]
        movq	80(%rcx), %rax
        mulq	56(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0x00, %r9
        # A[8] * B[9]
        movq	72(%rcx), %rax
        mulq	64(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0x00, %r9
        # A[9] * B[8]
        movq	64(%rcx), %rax
        mulq	72(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0x00, %r9
        # A[10] * B[7]
        movq	56(%rcx), %rax
        mulq	80(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0x00, %r9
        # A[11] * B[6]
        movq	48(%rcx), %rax
        mulq	88(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0x00, %r9
        # A[12] * B[5]
        movq	40(%rcx), %rax
        mulq	96(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0x00, %r9
        # A[13] * B[4]
        movq	32(%rcx), %rax
        mulq	104(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0x00, %r9
        # A[14] * B[3]
        movq	24(%rcx), %rax
        mulq	112(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0x00, %r9
        # A[15] * B[2]
        movq	16(%rcx), %rax
        mulq	120(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0x00, %r9
        movq	%r10, 136(%rdi)
        # A[3] * B[15]
        movq	120(%rcx), %rax
        mulq	24(%rsi)
        xorq	%r10, %r10
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0x00, %r10
        # A[4] * B[14]
        movq	112(%rcx), %rax
        mulq	32(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0x00, %r10
        # A[5] * B[13]
        movq	104(%rcx), %rax
        mulq	40(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0x00, %r10
        # A[6] * B[12]
        movq	96(%rcx), %rax
        mulq	48(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0x00, %r10
        # A[7] * B[11]
        movq	88(%rcx), %rax
        mulq	56(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0x00, %r10
        # A[8] * B[10]
        movq	80(%rcx), %rax
        mulq	64(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0x00, %r10
        # A[9] * B[9]
        movq	72(%rcx), %rax
        mulq	72(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0x00, %r10
        # A[10] * B[8]
        movq	64(%rcx), %rax
        mulq	80(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0x00, %r10
        # A[11] * B[7]
        movq	56(%rcx), %rax
        mulq	88(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0x00, %r10
        # A[12] * B[6]
        movq	48(%rcx), %rax
        mulq	96(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0x00, %r10
        # A[13] * B[5]
        movq	40(%rcx), %rax
        mulq	104(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0x00, %r10
        # A[14] * B[4]
        movq	32(%rcx), %rax
        mulq	112(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0x00, %r10
        # A[15] * B[3]
        movq	24(%rcx), %rax
        mulq	120(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0x00, %r10
        movq	%r8, 144(%rdi)
        # A[4] * B[15]
        movq	120(%rcx), %rax
        mulq	32(%rsi)
        xorq	%r8, %r8
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0x00, %r8
        # A[5] * B[14]
        movq	112(%rcx), %rax
        mulq	40(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0x00, %r8
        # A[6] * B[13]
        movq	104(%rcx), %rax
        mulq	48(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0x00, %r8
        # A[7] * B[12]
        movq	96(%rcx), %rax
        mulq	56(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0x00, %r8
        # A[8] * B[11]
        movq	88(%rcx), %rax
        mulq	64(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0x00, %r8
        # A[9] * B[10]
        movq	80(%rcx), %rax
        mulq	72(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0x00, %r8
        # A[10] * B[9]
        movq	72(%rcx), %rax
        mulq	80(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0x00, %r8
        # A[11] * B[8]
        movq	64(%rcx), %rax
        mulq	88(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0x00, %r8
        # A[12] * B[7]
        movq	56(%rcx), %rax
        mulq	96(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0x00, %r8
        # A[13] * B[6]
        movq	48(%rcx), %rax
        mulq	104(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0x00, %r8
        # A[14] * B[5]
        movq	40(%rcx), %rax
        mulq	112(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0x00, %r8
        # A[15] * B[4]
        movq	32(%rcx), %rax
        mulq	120(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0x00, %r8
        movq	%r9, 152(%rdi)
        # A[5] * B[15]
        movq	120(%rcx), %rax
        mulq	40(%rsi)
        xorq	%r9, %r9
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0x00, %r9
        # A[6] * B[14]
        movq	112(%rcx), %rax
        mulq	48(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0x00, %r9
        # A[7] * B[13]
        movq	104(%rcx), %rax
        mulq	56(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0x00, %r9
        # A[8] * B[12]
        movq	96(%rcx), %rax
        mulq	64(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0x00, %r9
        # A[9] * B[11]
        movq	88(%rcx), %rax
        mulq	72(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0x00, %r9
        # A[10] * B[10]
        movq	80(%rcx), %rax
        mulq	80(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0x00, %r9
        # A[11] * B[9]
        movq	72(%rcx), %rax
        mulq	88(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0x00, %r9
        # A[12] * B[8]
        movq	64(%rcx), %rax
        mulq	96(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0x00, %r9
        # A[13] * B[7]
        movq	56(%rcx), %rax
        mulq	104(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0x00, %r9
        # A[14] * B[6]
        movq	48(%rcx), %rax
        mulq	112(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0x00, %r9
        # A[15] * B[5]
        movq	40(%rcx), %rax
        mulq	120(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0x00, %r9
        movq	%r10, 160(%rdi)
        # A[6] * B[15]
        movq	120(%rcx), %rax
        mulq	48(%rsi)
        xorq	%r10, %r10
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0x00, %r10
        # A[7] * B[14]
        movq	112(%rcx), %rax
        mulq	56(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0x00, %r10
        # A[8] * B[13]
        movq	104(%rcx), %rax
        mulq	64(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0x00, %r10
        # A[9] * B[12]
        movq	96(%rcx), %rax
        mulq	72(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0x00, %r10
        # A[10] * B[11]
        movq	88(%rcx), %rax
        mulq	80(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0x00, %r10
        # A[11] * B[10]
        movq	80(%rcx), %rax
        mulq	88(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0x00, %r10
        # A[12] * B[9]
        movq	72(%rcx), %rax
        mulq	96(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0x00, %r10
        # A[13] * B[8]
        movq	64(%rcx), %rax
        mulq	104(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0x00, %r10
        # A[14] * B[7]
        movq	56(%rcx), %rax
        mulq	112(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0x00, %r10
        # A[15] * B[6]
        movq	48(%rcx), %rax
        mulq	120(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0x00, %r10
        movq	%r8, 168(%rdi)
        # A[7] * B[15]
        movq	120(%rcx), %rax
        mulq	56(%rsi)
        xorq	%r8, %r8
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0x00, %r8
        # A[8] * B[14]
        movq	112(%rcx), %rax
        mulq	64(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0x00, %r8
        # A[9] * B[13]
        movq	104(%rcx), %rax
        mulq	72(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0x00, %r8
        # A[10] * B[12]
        movq	96(%rcx), %rax
        mulq	80(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0x00, %r8
        # A[11] * B[11]
        movq	88(%rcx), %rax
        mulq	88(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0x00, %r8
        # A[12] * B[10]
        movq	80(%rcx), %rax
        mulq	96(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0x00, %r8
        # A[13] * B[9]
        movq	72(%rcx), %rax
        mulq	104(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0x00, %r8
        # A[14] * B[8]
        movq	64(%rcx), %rax
        mulq	112(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0x00, %r8
        # A[15] * B[7]
        movq	56(%rcx), %rax
        mulq	120(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0x00, %r8
        movq	%r9, 176(%rdi)
        # A[8] * B[15]
        movq	120(%rcx), %rax
        mulq	64(%rsi)
        xorq	%r9, %r9
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0x00, %r9
        # A[9] * B[14]
        movq	112(%rcx), %rax
        mulq	72(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0x00, %r9
        # A[10] * B[13]
        movq	104(%rcx), %rax
        mulq	80(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0x00, %r9
        # A[11] * B[12]
        movq	96(%rcx), %rax
        mulq	88(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0x00, %r9
        # A[12] * B[11]
        movq	88(%rcx), %rax
        mulq	96(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0x00, %r9
        # A[13] * B[10]
        movq	80(%rcx), %rax
        mulq	104(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0x00, %r9
        # A[14] * B[9]
        movq	72(%rcx), %rax
        mulq	112(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0x00, %r9
        # A[15] * B[8]
        movq	64(%rcx), %rax
        mulq	120(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0x00, %r9
        movq	%r10, 184(%rdi)
        # A[9] * B[15]
        movq	120(%rcx), %rax
        mulq	72(%rsi)
        xorq	%r10, %r10
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0x00, %r10
        # A[10] * B[14]
        movq	112(%rcx), %rax
        mulq	80(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0x00, %r10
        # A[11] * B[13]
        movq	104(%rcx), %rax
        mulq	88(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0x00, %r10
        # A[12] * B[12]
        movq	96(%rcx), %rax
        mulq	96(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0x00, %r10
        # A[13] * B[11]
        movq	88(%rcx), %rax
        mulq	104(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0x00, %r10
        # A[14] * B[10]
        movq	80(%rcx), %rax
        mulq	112(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0x00, %r10
        # A[15] * B[9]
        movq	72(%rcx), %rax
        mulq	120(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0x00, %r10
        movq	%r8, 192(%rdi)
        # A[10] * B[15]
        movq	120(%rcx), %rax
        mulq	80(%rsi)
        xorq	%r8, %r8
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0x00, %r8
        # A[11] * B[14]
        movq	112(%rcx), %rax
        mulq	88(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0x00, %r8
        # A[12] * B[13]
        movq	104(%rcx), %rax
        mulq	96(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0x00, %r8
        # A[13] * B[12]
        movq	96(%rcx), %rax
        mulq	104(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0x00, %r8
        # A[14] * B[11]
        movq	88(%rcx), %rax
        mulq	112(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0x00, %r8
        # A[15] * B[10]
        movq	80(%rcx), %rax
        mulq	120(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0x00, %r8
        movq	%r9, 200(%rdi)
        # A[11] * B[15]
        movq	120(%rcx), %rax
        mulq	88(%rsi)
        xorq	%r9, %r9
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0x00, %r9
        # A[12] * B[14]
        movq	112(%rcx), %rax
        mulq	96(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0x00, %r9
        # A[13] * B[13]
        movq	104(%rcx), %rax
        mulq	104(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0x00, %r9
        # A[14] * B[12]
        movq	96(%rcx), %rax
        mulq	112(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0x00, %r9
        # A[15] * B[11]
        movq	88(%rcx), %rax
        mulq	120(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0x00, %r9
        movq	%r10, 208(%rdi)
        # A[12] * B[15]
        movq	120(%rcx), %rax
        mulq	96(%rsi)
        xorq	%r10, %r10
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0x00, %r10
        # A[13] * B[14]
        movq	112(%rcx), %rax
        mulq	104(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0x00, %r10
        # A[14] * B[13]
        movq	104(%rcx), %rax
        mulq	112(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0x00, %r10
        # A[15] * B[12]
        movq	96(%rcx), %rax
        mulq	120(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0x00, %r10
        movq	%r8, 216(%rdi)
        # A[13] * B[15]
        movq	120(%rcx), %rax
        mulq	104(%rsi)
        xorq	%r8, %r8
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0x00, %r8
        # A[14] * B[14]
        movq	112(%rcx), %rax
        mulq	112(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0x00, %r8
        # A[15] * B[13]
        movq	104(%rcx), %rax
        mulq	120(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0x00, %r8
        movq	%r9, 224(%rdi)
        # A[14] * B[15]
        movq	120(%rcx), %rax
        mulq	112(%rsi)
        xorq	%r9, %r9
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0x00, %r9
        # A[15] * B[14]
        movq	112(%rcx), %rax
        mulq	120(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0x00, %r9
        movq	%r10, 232(%rdi)
        # A[15] * B[15]
        movq	120(%rcx), %rax
        mulq	120(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        movq	%r8, 240(%rdi)
        movq	%r9, 248(%rdi)
        movq	(%rsp), %rax
        movq	8(%rsp), %rdx
        movq	16(%rsp), %r8
        movq	24(%rsp), %r9
        movq	%rax, (%rdi)
        movq	%rdx, 8(%rdi)
        movq	%r8, 16(%rdi)
        movq	%r9, 24(%rdi)
        movq	32(%rsp), %rax
        movq	40(%rsp), %rdx
        movq	48(%rsp), %r8
        movq	56(%rsp), %r9
        movq	%rax, 32(%rdi)
        movq	%rdx, 40(%rdi)
        movq	%r8, 48(%rdi)
        movq	%r9, 56(%rdi)
        movq	64(%rsp), %rax
        movq	72(%rsp), %rdx
        movq	80(%rsp), %r8
        movq	88(%rsp), %r9
        movq	%rax, 64(%rdi)
        movq	%rdx, 72(%rdi)
        movq	%r8, 80(%rdi)
        movq	%r9, 88(%rdi)
        movq	96(%rsp), %rax
        movq	104(%rsp), %rdx
        movq	112(%rsp), %r8
        movq	120(%rsp), %r9
        movq	%rax, 96(%rdi)
        movq	%rdx, 104(%rdi)
        movq	%r8, 112(%rdi)
        movq	%r9, 120(%rdi)
        addq	$0x80, %rsp
        repz retq
#ifndef __APPLE__
.size	sp_2048_mul_16,.-sp_2048_mul_16
#endif /* __APPLE__ */
#ifdef HAVE_INTEL_AVX2
/* Multiply a and b into r. (r = a * b)
 *
 * r   Result of multiplication.
 * a   First number to multiply.
 * b   Second number to multiply.
 */
#ifndef __APPLE__
.text
.globl	sp_2048_mul_avx2_16
.type	sp_2048_mul_avx2_16,@function
.align	16
sp_2048_mul_avx2_16:
#else
.section	__TEXT,__text
.globl	_sp_2048_mul_avx2_16
.p2align	4
_sp_2048_mul_avx2_16:
#endif /* __APPLE__ */
        pushq	%rbx
        pushq	%rbp
        pushq	%r12
        pushq	%r13
        pushq	%r14
        movq	%rdx, %rbp
        subq	$0x80, %rsp
        cmpq	%rdi, %rsi
        movq	%rsp, %rbx
        cmovne	%rdi, %rbx
        cmpq	%rdi, %rbp
        cmove	%rsp, %rbx
        addq	$0x80, %rdi
        xorq	%r14, %r14
        movq	(%rsi), %rdx
        # A[0] * B[0]
        mulx	(%rbp), %r8, %r9
        # A[0] * B[1]
        mulx	8(%rbp), %rax, %r10
        movq	%r8, (%rbx)
        adcxq	%rax, %r9
        # A[0] * B[2]
        mulx	16(%rbp), %rax, %r11
        movq	%r9, 8(%rbx)
        adcxq	%rax, %r10
        # A[0] * B[3]
        mulx	24(%rbp), %rax, %r12
        movq	%r10, 16(%rbx)
        adcxq	%rax, %r11
        movq	%r11, 24(%rbx)
        # A[0] * B[4]
        mulx	32(%rbp), %rax, %r8
        adcxq	%rax, %r12
        # A[0] * B[5]
        mulx	40(%rbp), %rax, %r9
        movq	%r12, 32(%rbx)
        adcxq	%rax, %r8
        # A[0] * B[6]
        mulx	48(%rbp), %rax, %r10
        movq	%r8, 40(%rbx)
        adcxq	%rax, %r9
        # A[0] * B[7]
        mulx	56(%rbp), %rax, %r11
        movq	%r9, 48(%rbx)
        adcxq	%rax, %r10
        movq	%r10, 56(%rbx)
        # A[0] * B[8]
        mulx	64(%rbp), %rax, %r12
        adcxq	%rax, %r11
        # A[0] * B[9]
        mulx	72(%rbp), %rax, %r8
        movq	%r11, 64(%rbx)
        adcxq	%rax, %r12
        # A[0] * B[10]
        mulx	80(%rbp), %rax, %r9
        movq	%r12, 72(%rbx)
        adcxq	%rax, %r8
        # A[0] * B[11]
        mulx	88(%rbp), %rax, %r10
        movq	%r8, 80(%rbx)
        adcxq	%rax, %r9
        movq	%r9, 88(%rbx)
        # A[0] * B[12]
        mulx	96(%rbp), %rax, %r11
        adcxq	%rax, %r10
        # A[0] * B[13]
        mulx	104(%rbp), %rax, %r12
        movq	%r10, 96(%rbx)
        adcxq	%rax, %r11
        # A[0] * B[14]
        mulx	112(%rbp), %rax, %r8
        movq	%r11, 104(%rbx)
        adcxq	%rax, %r12
        # A[0] * B[15]
        mulx	120(%rbp), %rax, %r9
        movq	%r12, 112(%rbx)
        adcxq	%rax, %r8
        adcxq	%r14, %r9
        movq	%r14, %r13
        adcxq	%r14, %r13
        movq	%r8, 120(%rbx)
        movq	%r9, (%rdi)
        movq	8(%rsi), %rdx
        movq	8(%rbx), %r9
        movq	16(%rbx), %r10
        movq	24(%rbx), %r11
        movq	32(%rbx), %r12
        movq	40(%rbx), %r8
        # A[1] * B[0]
        mulx	(%rbp), %rax, %rcx
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        # A[1] * B[1]
        mulx	8(%rbp), %rax, %rcx
        movq	%r9, 8(%rbx)
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        # A[1] * B[2]
        mulx	16(%rbp), %rax, %rcx
        movq	%r10, 16(%rbx)
        adcxq	%rax, %r11
        adoxq	%rcx, %r12
        # A[1] * B[3]
        mulx	24(%rbp), %rax, %rcx
        movq	%r11, 24(%rbx)
        adcxq	%rax, %r12
        adoxq	%rcx, %r8
        movq	%r12, 32(%rbx)
        movq	48(%rbx), %r9
        movq	56(%rbx), %r10
        movq	64(%rbx), %r11
        movq	72(%rbx), %r12
        # A[1] * B[4]
        mulx	32(%rbp), %rax, %rcx
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        # A[1] * B[5]
        mulx	40(%rbp), %rax, %rcx
        movq	%r8, 40(%rbx)
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        # A[1] * B[6]
        mulx	48(%rbp), %rax, %rcx
        movq	%r9, 48(%rbx)
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        # A[1] * B[7]
        mulx	56(%rbp), %rax, %rcx
        movq	%r10, 56(%rbx)
        adcxq	%rax, %r11
        adoxq	%rcx, %r12
        movq	%r11, 64(%rbx)
        movq	80(%rbx), %r8
        movq	88(%rbx), %r9
        movq	96(%rbx), %r10
        movq	104(%rbx), %r11
        # A[1] * B[8]
        mulx	64(%rbp), %rax, %rcx
        adcxq	%rax, %r12
        adoxq	%rcx, %r8
        # A[1] * B[9]
        mulx	72(%rbp), %rax, %rcx
        movq	%r12, 72(%rbx)
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        # A[1] * B[10]
        mulx	80(%rbp), %rax, %rcx
        movq	%r8, 80(%rbx)
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        # A[1] * B[11]
        mulx	88(%rbp), %rax, %rcx
        movq	%r9, 88(%rbx)
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        movq	%r10, 96(%rbx)
        movq	112(%rbx), %r12
        movq	120(%rbx), %r8
        movq	(%rdi), %r9
        # A[1] * B[12]
        mulx	96(%rbp), %rax, %rcx
        adcxq	%rax, %r11
        adoxq	%rcx, %r12
        # A[1] * B[13]
        mulx	104(%rbp), %rax, %rcx
        movq	%r11, 104(%rbx)
        adcxq	%rax, %r12
        adoxq	%rcx, %r8
        # A[1] * B[14]
        mulx	112(%rbp), %rax, %rcx
        movq	%r12, 112(%rbx)
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        # A[1] * B[15]
        mulx	120(%rbp), %rax, %rcx
        movq	%r8, 120(%rbx)
        movq	%r14, %r10
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        adcxq	%r13, %r10
        movq	%r14, %r13
        adoxq	%r14, %r13
        adcxq	%r14, %r13
        movq	%r9, (%rdi)
        movq	%r10, 8(%rdi)
        movq	16(%rsi), %rdx
        movq	16(%rbx), %r10
        movq	24(%rbx), %r11
        movq	32(%rbx), %r12
        movq	40(%rbx), %r8
        movq	48(%rbx), %r9
        # A[2] * B[0]
        mulx	(%rbp), %rax, %rcx
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        # A[2] * B[1]
        mulx	8(%rbp), %rax, %rcx
        movq	%r10, 16(%rbx)
        adcxq	%rax, %r11
        adoxq	%rcx, %r12
        # A[2] * B[2]
        mulx	16(%rbp), %rax, %rcx
        movq	%r11, 24(%rbx)
        adcxq	%rax, %r12
        adoxq	%rcx, %r8
        # A[2] * B[3]
        mulx	24(%rbp), %rax, %rcx
        movq	%r12, 32(%rbx)
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        movq	%r8, 40(%rbx)
        movq	56(%rbx), %r10
        movq	64(%rbx), %r11
        movq	72(%rbx), %r12
        movq	80(%rbx), %r8
        # A[2] * B[4]
        mulx	32(%rbp), %rax, %rcx
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        # A[2] * B[5]
        mulx	40(%rbp), %rax, %rcx
        movq	%r9, 48(%rbx)
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        # A[2] * B[6]
        mulx	48(%rbp), %rax, %rcx
        movq	%r10, 56(%rbx)
        adcxq	%rax, %r11
        adoxq	%rcx, %r12
        # A[2] * B[7]
        mulx	56(%rbp), %rax, %rcx
        movq	%r11, 64(%rbx)
        adcxq	%rax, %r12
        adoxq	%rcx, %r8
        movq	%r12, 72(%rbx)
        movq	88(%rbx), %r9
        movq	96(%rbx), %r10
        movq	104(%rbx), %r11
        movq	112(%rbx), %r12
        # A[2] * B[8]
        mulx	64(%rbp), %rax, %rcx
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        # A[2] * B[9]
        mulx	72(%rbp), %rax, %rcx
        movq	%r8, 80(%rbx)
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        # A[2] * B[10]
        mulx	80(%rbp), %rax, %rcx
        movq	%r9, 88(%rbx)
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        # A[2] * B[11]
        mulx	88(%rbp), %rax, %rcx
        movq	%r10, 96(%rbx)
        adcxq	%rax, %r11
        adoxq	%rcx, %r12
        movq	%r11, 104(%rbx)
        movq	120(%rbx), %r8
        movq	(%rdi), %r9
        movq	8(%rdi), %r10
        # A[2] * B[12]
        mulx	96(%rbp), %rax, %rcx
        adcxq	%rax, %r12
        adoxq	%rcx, %r8
        # A[2] * B[13]
        mulx	104(%rbp), %rax, %rcx
        movq	%r12, 112(%rbx)
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        # A[2] * B[14]
        mulx	112(%rbp), %rax, %rcx
        movq	%r8, 120(%rbx)
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        # A[2] * B[15]
        mulx	120(%rbp), %rax, %rcx
        movq	%r9, (%rdi)
        movq	%r14, %r11
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        adcxq	%r13, %r11
        movq	%r14, %r13
        adoxq	%r14, %r13
        adcxq	%r14, %r13
        movq	%r10, 8(%rdi)
        movq	%r11, 16(%rdi)
        movq	24(%rsi), %rdx
        movq	24(%rbx), %r11
        movq	32(%rbx), %r12
        movq	40(%rbx), %r8
        movq	48(%rbx), %r9
        movq	56(%rbx), %r10
        # A[3] * B[0]
        mulx	(%rbp), %rax, %rcx
        adcxq	%rax, %r11
        adoxq	%rcx, %r12
        # A[3] * B[1]
        mulx	8(%rbp), %rax, %rcx
        movq	%r11, 24(%rbx)
        adcxq	%rax, %r12
        adoxq	%rcx, %r8
        # A[3] * B[2]
        mulx	16(%rbp), %rax, %rcx
        movq	%r12, 32(%rbx)
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        # A[3] * B[3]
        mulx	24(%rbp), %rax, %rcx
        movq	%r8, 40(%rbx)
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        movq	%r9, 48(%rbx)
        movq	64(%rbx), %r11
        movq	72(%rbx), %r12
        movq	80(%rbx), %r8
        movq	88(%rbx), %r9
        # A[3] * B[4]
        mulx	32(%rbp), %rax, %rcx
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        # A[3] * B[5]
        mulx	40(%rbp), %rax, %rcx
        movq	%r10, 56(%rbx)
        adcxq	%rax, %r11
        adoxq	%rcx, %r12
        # A[3] * B[6]
        mulx	48(%rbp), %rax, %rcx
        movq	%r11, 64(%rbx)
        adcxq	%rax, %r12
        adoxq	%rcx, %r8
        # A[3] * B[7]
        mulx	56(%rbp), %rax, %rcx
        movq	%r12, 72(%rbx)
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        movq	%r8, 80(%rbx)
        movq	96(%rbx), %r10
        movq	104(%rbx), %r11
        movq	112(%rbx), %r12
        movq	120(%rbx), %r8
        # A[3] * B[8]
        mulx	64(%rbp), %rax, %rcx
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        # A[3] * B[9]
        mulx	72(%rbp), %rax, %rcx
        movq	%r9, 88(%rbx)
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        # A[3] * B[10]
        mulx	80(%rbp), %rax, %rcx
        movq	%r10, 96(%rbx)
        adcxq	%rax, %r11
        adoxq	%rcx, %r12
        # A[3] * B[11]
        mulx	88(%rbp), %rax, %rcx
        movq	%r11, 104(%rbx)
        adcxq	%rax, %r12
        adoxq	%rcx, %r8
        movq	%r12, 112(%rbx)
        movq	(%rdi), %r9
        movq	8(%rdi), %r10
        movq	16(%rdi), %r11
        # A[3] * B[12]
        mulx	96(%rbp), %rax, %rcx
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        # A[3] * B[13]
        mulx	104(%rbp), %rax, %rcx
        movq	%r8, 120(%rbx)
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        # A[3] * B[14]
        mulx	112(%rbp), %rax, %rcx
        movq	%r9, (%rdi)
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        # A[3] * B[15]
        mulx	120(%rbp), %rax, %rcx
        movq	%r10, 8(%rdi)
        movq	%r14, %r12
        adcxq	%rax, %r11
        adoxq	%rcx, %r12
        adcxq	%r13, %r12
        movq	%r14, %r13
        adoxq	%r14, %r13
        adcxq	%r14, %r13
        movq	%r11, 16(%rdi)
        movq	%r12, 24(%rdi)
        movq	32(%rsi), %rdx
        movq	32(%rbx), %r12
        movq	40(%rbx), %r8
        movq	48(%rbx), %r9
        movq	56(%rbx), %r10
        movq	64(%rbx), %r11
        # A[4] * B[0]
        mulx	(%rbp), %rax, %rcx
        adcxq	%rax, %r12
        adoxq	%rcx, %r8
        # A[4] * B[1]
        mulx	8(%rbp), %rax, %rcx
        movq	%r12, 32(%rbx)
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        # A[4] * B[2]
        mulx	16(%rbp), %rax, %rcx
        movq	%r8, 40(%rbx)
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        # A[4] * B[3]
        mulx	24(%rbp), %rax, %rcx
        movq	%r9, 48(%rbx)
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        movq	%r10, 56(%rbx)
        movq	72(%rbx), %r12
        movq	80(%rbx), %r8
        movq	88(%rbx), %r9
        movq	96(%rbx), %r10
        # A[4] * B[4]
        mulx	32(%rbp), %rax, %rcx
        adcxq	%rax, %r11
        adoxq	%rcx, %r12
        # A[4] * B[5]
        mulx	40(%rbp), %rax, %rcx
        movq	%r11, 64(%rbx)
        adcxq	%rax, %r12
        adoxq	%rcx, %r8
        # A[4] * B[6]
        mulx	48(%rbp), %rax, %rcx
        movq	%r12, 72(%rbx)
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        # A[4] * B[7]
        mulx	56(%rbp), %rax, %rcx
        movq	%r8, 80(%rbx)
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        movq	%r9, 88(%rbx)
        movq	104(%rbx), %r11
        movq	112(%rbx), %r12
        movq	120(%rbx), %r8
        movq	(%rdi), %r9
        # A[4] * B[8]
        mulx	64(%rbp), %rax, %rcx
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        # A[4] * B[9]
        mulx	72(%rbp), %rax, %rcx
        movq	%r10, 96(%rbx)
        adcxq	%rax, %r11
        adoxq	%rcx, %r12
        # A[4] * B[10]
        mulx	80(%rbp), %rax, %rcx
        movq	%r11, 104(%rbx)
        adcxq	%rax, %r12
        adoxq	%rcx, %r8
        # A[4] * B[11]
        mulx	88(%rbp), %rax, %rcx
        movq	%r12, 112(%rbx)
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        movq	%r8, 120(%rbx)
        movq	8(%rdi), %r10
        movq	16(%rdi), %r11
        movq	24(%rdi), %r12
        # A[4] * B[12]
        mulx	96(%rbp), %rax, %rcx
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        # A[4] * B[13]
        mulx	104(%rbp), %rax, %rcx
        movq	%r9, (%rdi)
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        # A[4] * B[14]
        mulx	112(%rbp), %rax, %rcx
        movq	%r10, 8(%rdi)
        adcxq	%rax, %r11
        adoxq	%rcx, %r12
        # A[4] * B[15]
        mulx	120(%rbp), %rax, %rcx
        movq	%r11, 16(%rdi)
        movq	%r14, %r8
        adcxq	%rax, %r12
        adoxq	%rcx, %r8
        adcxq	%r13, %r8
        movq	%r14, %r13
        adoxq	%r14, %r13
        adcxq	%r14, %r13
        movq	%r12, 24(%rdi)
        movq	%r8, 32(%rdi)
        movq	40(%rsi), %rdx
        movq	40(%rbx), %r8
        movq	48(%rbx), %r9
        movq	56(%rbx), %r10
        movq	64(%rbx), %r11
        movq	72(%rbx), %r12
        # A[5] * B[0]
        mulx	(%rbp), %rax, %rcx
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        # A[5] * B[1]
        mulx	8(%rbp), %rax, %rcx
        movq	%r8, 40(%rbx)
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        # A[5] * B[2]
        mulx	16(%rbp), %rax, %rcx
        movq	%r9, 48(%rbx)
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        # A[5] * B[3]
        mulx	24(%rbp), %rax, %rcx
        movq	%r10, 56(%rbx)
        adcxq	%rax, %r11
        adoxq	%rcx, %r12
        movq	%r11, 64(%rbx)
        movq	80(%rbx), %r8
        movq	88(%rbx), %r9
        movq	96(%rbx), %r10
        movq	104(%rbx), %r11
        # A[5] * B[4]
        mulx	32(%rbp), %rax, %rcx
        adcxq	%rax, %r12
        adoxq	%rcx, %r8
        # A[5] * B[5]
        mulx	40(%rbp), %rax, %rcx
        movq	%r12, 72(%rbx)
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        # A[5] * B[6]
        mulx	48(%rbp), %rax, %rcx
        movq	%r8, 80(%rbx)
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        # A[5] * B[7]
        mulx	56(%rbp), %rax, %rcx
        movq	%r9, 88(%rbx)
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        movq	%r10, 96(%rbx)
        movq	112(%rbx), %r12
        movq	120(%rbx), %r8
        movq	(%rdi), %r9
        movq	8(%rdi), %r10
        # A[5] * B[8]
        mulx	64(%rbp), %rax, %rcx
        adcxq	%rax, %r11
        adoxq	%rcx, %r12
        # A[5] * B[9]
        mulx	72(%rbp), %rax, %rcx
        movq	%r11, 104(%rbx)
        adcxq	%rax, %r12
        adoxq	%rcx, %r8
        # A[5] * B[10]
        mulx	80(%rbp), %rax, %rcx
        movq	%r12, 112(%rbx)
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        # A[5] * B[11]
        mulx	88(%rbp), %rax, %rcx
        movq	%r8, 120(%rbx)
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        movq	%r9, (%rdi)
        movq	16(%rdi), %r11
        movq	24(%rdi), %r12
        movq	32(%rdi), %r8
        # A[5] * B[12]
        mulx	96(%rbp), %rax, %rcx
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        # A[5] * B[13]
        mulx	104(%rbp), %rax, %rcx
        movq	%r10, 8(%rdi)
        adcxq	%rax, %r11
        adoxq	%rcx, %r12
        # A[5] * B[14]
        mulx	112(%rbp), %rax, %rcx
        movq	%r11, 16(%rdi)
        adcxq	%rax, %r12
        adoxq	%rcx, %r8
        # A[5] * B[15]
        mulx	120(%rbp), %rax, %rcx
        movq	%r12, 24(%rdi)
        movq	%r14, %r9
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        adcxq	%r13, %r9
        movq	%r14, %r13
        adoxq	%r14, %r13
        adcxq	%r14, %r13
        movq	%r8, 32(%rdi)
        movq	%r9, 40(%rdi)
        movq	48(%rsi), %rdx
        movq	48(%rbx), %r9
        movq	56(%rbx), %r10
        movq	64(%rbx), %r11
        movq	72(%rbx), %r12
        movq	80(%rbx), %r8
        # A[6] * B[0]
        mulx	(%rbp), %rax, %rcx
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        # A[6] * B[1]
        mulx	8(%rbp), %rax, %rcx
        movq	%r9, 48(%rbx)
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        # A[6] * B[2]
        mulx	16(%rbp), %rax, %rcx
        movq	%r10, 56(%rbx)
        adcxq	%rax, %r11
        adoxq	%rcx, %r12
        # A[6] * B[3]
        mulx	24(%rbp), %rax, %rcx
        movq	%r11, 64(%rbx)
        adcxq	%rax, %r12
        adoxq	%rcx, %r8
        movq	%r12, 72(%rbx)
        movq	88(%rbx), %r9
        movq	96(%rbx), %r10
        movq	104(%rbx), %r11
        movq	112(%rbx), %r12
        # A[6] * B[4]
        mulx	32(%rbp), %rax, %rcx
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        # A[6] * B[5]
        mulx	40(%rbp), %rax, %rcx
        movq	%r8, 80(%rbx)
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        # A[6] * B[6]
        mulx	48(%rbp), %rax, %rcx
        movq	%r9, 88(%rbx)
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        # A[6] * B[7]
        mulx	56(%rbp), %rax, %rcx
        movq	%r10, 96(%rbx)
        adcxq	%rax, %r11
        adoxq	%rcx, %r12
        movq	%r11, 104(%rbx)
        movq	120(%rbx), %r8
        movq	(%rdi), %r9
        movq	8(%rdi), %r10
        movq	16(%rdi), %r11
        # A[6] * B[8]
        mulx	64(%rbp), %rax, %rcx
        adcxq	%rax, %r12
        adoxq	%rcx, %r8
        # A[6] * B[9]
        mulx	72(%rbp), %rax, %rcx
        movq	%r12, 112(%rbx)
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        # A[6] * B[10]
        mulx	80(%rbp), %rax, %rcx
        movq	%r8, 120(%rbx)
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        # A[6] * B[11]
        mulx	88(%rbp), %rax, %rcx
        movq	%r9, (%rdi)
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        movq	%r10, 8(%rdi)
        movq	24(%rdi), %r12
        movq	32(%rdi), %r8
        movq	40(%rdi), %r9
        # A[6] * B[12]
        mulx	96(%rbp), %rax, %rcx
        adcxq	%rax, %r11
        adoxq	%rcx, %r12
        # A[6] * B[13]
        mulx	104(%rbp), %rax, %rcx
        movq	%r11, 16(%rdi)
        adcxq	%rax, %r12
        adoxq	%rcx, %r8
        # A[6] * B[14]
        mulx	112(%rbp), %rax, %rcx
        movq	%r12, 24(%rdi)
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        # A[6] * B[15]
        mulx	120(%rbp), %rax, %rcx
        movq	%r8, 32(%rdi)
        movq	%r14, %r10
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        adcxq	%r13, %r10
        movq	%r14, %r13
        adoxq	%r14, %r13
        adcxq	%r14, %r13
        movq	%r9, 40(%rdi)
        movq	%r10, 48(%rdi)
        movq	56(%rsi), %rdx
        movq	56(%rbx), %r10
        movq	64(%rbx), %r11
        movq	72(%rbx), %r12
        movq	80(%rbx), %r8
        movq	88(%rbx), %r9
        # A[7] * B[0]
        mulx	(%rbp), %rax, %rcx
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        # A[7] * B[1]
        mulx	8(%rbp), %rax, %rcx
        movq	%r10, 56(%rbx)
        adcxq	%rax, %r11
        adoxq	%rcx, %r12
        # A[7] * B[2]
        mulx	16(%rbp), %rax, %rcx
        movq	%r11, 64(%rbx)
        adcxq	%rax, %r12
        adoxq	%rcx, %r8
        # A[7] * B[3]
        mulx	24(%rbp), %rax, %rcx
        movq	%r12, 72(%rbx)
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        movq	%r8, 80(%rbx)
        movq	96(%rbx), %r10
        movq	104(%rbx), %r11
        movq	112(%rbx), %r12
        movq	120(%rbx), %r8
        # A[7] * B[4]
        mulx	32(%rbp), %rax, %rcx
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        # A[7] * B[5]
        mulx	40(%rbp), %rax, %rcx
        movq	%r9, 88(%rbx)
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        # A[7] * B[6]
        mulx	48(%rbp), %rax, %rcx
        movq	%r10, 96(%rbx)
        adcxq	%rax, %r11
        adoxq	%rcx, %r12
        # A[7] * B[7]
        mulx	56(%rbp), %rax, %rcx
        movq	%r11, 104(%rbx)
        adcxq	%rax, %r12
        adoxq	%rcx, %r8
        movq	%r12, 112(%rbx)
        movq	(%rdi), %r9
        movq	8(%rdi), %r10
        movq	16(%rdi), %r11
        movq	24(%rdi), %r12
        # A[7] * B[8]
        mulx	64(%rbp), %rax, %rcx
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        # A[7] * B[9]
        mulx	72(%rbp), %rax, %rcx
        movq	%r8, 120(%rbx)
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        # A[7] * B[10]
        mulx	80(%rbp), %rax, %rcx
        movq	%r9, (%rdi)
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        # A[7] * B[11]
        mulx	88(%rbp), %rax, %rcx
        movq	%r10, 8(%rdi)
        adcxq	%rax, %r11
        adoxq	%rcx, %r12
        movq	%r11, 16(%rdi)
        movq	32(%rdi), %r8
        movq	40(%rdi), %r9
        movq	48(%rdi), %r10
        # A[7] * B[12]
        mulx	96(%rbp), %rax, %rcx
        adcxq	%rax, %r12
        adoxq	%rcx, %r8
        # A[7] * B[13]
        mulx	104(%rbp), %rax, %rcx
        movq	%r12, 24(%rdi)
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        # A[7] * B[14]
        mulx	112(%rbp), %rax, %rcx
        movq	%r8, 32(%rdi)
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        # A[7] * B[15]
        mulx	120(%rbp), %rax, %rcx
        movq	%r9, 40(%rdi)
        movq	%r14, %r11
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        adcxq	%r13, %r11
        movq	%r14, %r13
        adoxq	%r14, %r13
        adcxq	%r14, %r13
        movq	%r10, 48(%rdi)
        movq	%r11, 56(%rdi)
        movq	64(%rsi), %rdx
        movq	64(%rbx), %r11
        movq	72(%rbx), %r12
        movq	80(%rbx), %r8
        movq	88(%rbx), %r9
        movq	96(%rbx), %r10
        # A[8] * B[0]
        mulx	(%rbp), %rax, %rcx
        adcxq	%rax, %r11
        adoxq	%rcx, %r12
        # A[8] * B[1]
        mulx	8(%rbp), %rax, %rcx
        movq	%r11, 64(%rbx)
        adcxq	%rax, %r12
        adoxq	%rcx, %r8
        # A[8] * B[2]
        mulx	16(%rbp), %rax, %rcx
        movq	%r12, 72(%rbx)
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        # A[8] * B[3]
        mulx	24(%rbp), %rax, %rcx
        movq	%r8, 80(%rbx)
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        movq	%r9, 88(%rbx)
        movq	104(%rbx), %r11
        movq	112(%rbx), %r12
        movq	120(%rbx), %r8
        movq	(%rdi), %r9
        # A[8] * B[4]
        mulx	32(%rbp), %rax, %rcx
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        # A[8] * B[5]
        mulx	40(%rbp), %rax, %rcx
        movq	%r10, 96(%rbx)
        adcxq	%rax, %r11
        adoxq	%rcx, %r12
        # A[8] * B[6]
        mulx	48(%rbp), %rax, %rcx
        movq	%r11, 104(%rbx)
        adcxq	%rax, %r12
        adoxq	%rcx, %r8
        # A[8] * B[7]
        mulx	56(%rbp), %rax, %rcx
        movq	%r12, 112(%rbx)
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        movq	%r8, 120(%rbx)
        movq	8(%rdi), %r10
        movq	16(%rdi), %r11
        movq	24(%rdi), %r12
        movq	32(%rdi), %r8
        # A[8] * B[8]
        mulx	64(%rbp), %rax, %rcx
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        # A[8] * B[9]
        mulx	72(%rbp), %rax, %rcx
        movq	%r9, (%rdi)
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        # A[8] * B[10]
        mulx	80(%rbp), %rax, %rcx
        movq	%r10, 8(%rdi)
        adcxq	%rax, %r11
        adoxq	%rcx, %r12
        # A[8] * B[11]
        mulx	88(%rbp), %rax, %rcx
        movq	%r11, 16(%rdi)
        adcxq	%rax, %r12
        adoxq	%rcx, %r8
        movq	%r12, 24(%rdi)
        movq	40(%rdi), %r9
        movq	48(%rdi), %r10
        movq	56(%rdi), %r11
        # A[8] * B[12]
        mulx	96(%rbp), %rax, %rcx
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        # A[8] * B[13]
        mulx	104(%rbp), %rax, %rcx
        movq	%r8, 32(%rdi)
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        # A[8] * B[14]
        mulx	112(%rbp), %rax, %rcx
        movq	%r9, 40(%rdi)
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        # A[8] * B[15]
        mulx	120(%rbp), %rax, %rcx
        movq	%r10, 48(%rdi)
        movq	%r14, %r12
        adcxq	%rax, %r11
        adoxq	%rcx, %r12
        adcxq	%r13, %r12
        movq	%r14, %r13
        adoxq	%r14, %r13
        adcxq	%r14, %r13
        movq	%r11, 56(%rdi)
        movq	%r12, 64(%rdi)
        movq	72(%rsi), %rdx
        movq	72(%rbx), %r12
        movq	80(%rbx), %r8
        movq	88(%rbx), %r9
        movq	96(%rbx), %r10
        movq	104(%rbx), %r11
        # A[9] * B[0]
        mulx	(%rbp), %rax, %rcx
        adcxq	%rax, %r12
        adoxq	%rcx, %r8
        # A[9] * B[1]
        mulx	8(%rbp), %rax, %rcx
        movq	%r12, 72(%rbx)
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        # A[9] * B[2]
        mulx	16(%rbp), %rax, %rcx
        movq	%r8, 80(%rbx)
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        # A[9] * B[3]
        mulx	24(%rbp), %rax, %rcx
        movq	%r9, 88(%rbx)
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        movq	%r10, 96(%rbx)
        movq	112(%rbx), %r12
        movq	120(%rbx), %r8
        movq	(%rdi), %r9
        movq	8(%rdi), %r10
        # A[9] * B[4]
        mulx	32(%rbp), %rax, %rcx
        adcxq	%rax, %r11
        adoxq	%rcx, %r12
        # A[9] * B[5]
        mulx	40(%rbp), %rax, %rcx
        movq	%r11, 104(%rbx)
        adcxq	%rax, %r12
        adoxq	%rcx, %r8
        # A[9] * B[6]
        mulx	48(%rbp), %rax, %rcx
        movq	%r12, 112(%rbx)
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        # A[9] * B[7]
        mulx	56(%rbp), %rax, %rcx
        movq	%r8, 120(%rbx)
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        movq	%r9, (%rdi)
        movq	16(%rdi), %r11
        movq	24(%rdi), %r12
        movq	32(%rdi), %r8
        movq	40(%rdi), %r9
        # A[9] * B[8]
        mulx	64(%rbp), %rax, %rcx
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        # A[9] * B[9]
        mulx	72(%rbp), %rax, %rcx
        movq	%r10, 8(%rdi)
        adcxq	%rax, %r11
        adoxq	%rcx, %r12
        # A[9] * B[10]
        mulx	80(%rbp), %rax, %rcx
        movq	%r11, 16(%rdi)
        adcxq	%rax, %r12
        adoxq	%rcx, %r8
        # A[9] * B[11]
        mulx	88(%rbp), %rax, %rcx
        movq	%r12, 24(%rdi)
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        movq	%r8, 32(%rdi)
        movq	48(%rdi), %r10
        movq	56(%rdi), %r11
        movq	64(%rdi), %r12
        # A[9] * B[12]
        mulx	96(%rbp), %rax, %rcx
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        # A[9] * B[13]
        mulx	104(%rbp), %rax, %rcx
        movq	%r9, 40(%rdi)
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        # A[9] * B[14]
        mulx	112(%rbp), %rax, %rcx
        movq	%r10, 48(%rdi)
        adcxq	%rax, %r11
        adoxq	%rcx, %r12
        # A[9] * B[15]
        mulx	120(%rbp), %rax, %rcx
        movq	%r11, 56(%rdi)
        movq	%r14, %r8
        adcxq	%rax, %r12
        adoxq	%rcx, %r8
        adcxq	%r13, %r8
        movq	%r14, %r13
        adoxq	%r14, %r13
        adcxq	%r14, %r13
        movq	%r12, 64(%rdi)
        movq	%r8, 72(%rdi)
        movq	80(%rsi), %rdx
        movq	80(%rbx), %r8
        movq	88(%rbx), %r9
        movq	96(%rbx), %r10
        movq	104(%rbx), %r11
        movq	112(%rbx), %r12
        # A[10] * B[0]
        mulx	(%rbp), %rax, %rcx
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        # A[10] * B[1]
        mulx	8(%rbp), %rax, %rcx
        movq	%r8, 80(%rbx)
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        # A[10] * B[2]
        mulx	16(%rbp), %rax, %rcx
        movq	%r9, 88(%rbx)
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        # A[10] * B[3]
        mulx	24(%rbp), %rax, %rcx
        movq	%r10, 96(%rbx)
        adcxq	%rax, %r11
        adoxq	%rcx, %r12
        movq	%r11, 104(%rbx)
        movq	120(%rbx), %r8
        movq	(%rdi), %r9
        movq	8(%rdi), %r10
        movq	16(%rdi), %r11
        # A[10] * B[4]
        mulx	32(%rbp), %rax, %rcx
        adcxq	%rax, %r12
        adoxq	%rcx, %r8
        # A[10] * B[5]
        mulx	40(%rbp), %rax, %rcx
        movq	%r12, 112(%rbx)
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        # A[10] * B[6]
        mulx	48(%rbp), %rax, %rcx
        movq	%r8, 120(%rbx)
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        # A[10] * B[7]
        mulx	56(%rbp), %rax, %rcx
        movq	%r9, (%rdi)
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        movq	%r10, 8(%rdi)
        movq	24(%rdi), %r12
        movq	32(%rdi), %r8
        movq	40(%rdi), %r9
        movq	48(%rdi), %r10
        # A[10] * B[8]
        mulx	64(%rbp), %rax, %rcx
        adcxq	%rax, %r11
        adoxq	%rcx, %r12
        # A[10] * B[9]
        mulx	72(%rbp), %rax, %rcx
        movq	%r11, 16(%rdi)
        adcxq	%rax, %r12
        adoxq	%rcx, %r8
        # A[10] * B[10]
        mulx	80(%rbp), %rax, %rcx
        movq	%r12, 24(%rdi)
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        # A[10] * B[11]
        mulx	88(%rbp), %rax, %rcx
        movq	%r8, 32(%rdi)
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        movq	%r9, 40(%rdi)
        movq	56(%rdi), %r11
        movq	64(%rdi), %r12
        movq	72(%rdi), %r8
        # A[10] * B[12]
        mulx	96(%rbp), %rax, %rcx
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        # A[10] * B[13]
        mulx	104(%rbp), %rax, %rcx
        movq	%r10, 48(%rdi)
        adcxq	%rax, %r11
        adoxq	%rcx, %r12
        # A[10] * B[14]
        mulx	112(%rbp), %rax, %rcx
        movq	%r11, 56(%rdi)
        adcxq	%rax, %r12
        adoxq	%rcx, %r8
        # A[10] * B[15]
        mulx	120(%rbp), %rax, %rcx
        movq	%r12, 64(%rdi)
        movq	%r14, %r9
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        adcxq	%r13, %r9
        movq	%r14, %r13
        adoxq	%r14, %r13
        adcxq	%r14, %r13
        movq	%r8, 72(%rdi)
        movq	%r9, 80(%rdi)
        movq	88(%rsi), %rdx
        movq	88(%rbx), %r9
        movq	96(%rbx), %r10
        movq	104(%rbx), %r11
        movq	112(%rbx), %r12
        movq	120(%rbx), %r8
        # A[11] * B[0]
        mulx	(%rbp), %rax, %rcx
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        # A[11] * B[1]
        mulx	8(%rbp), %rax, %rcx
        movq	%r9, 88(%rbx)
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        # A[11] * B[2]
        mulx	16(%rbp), %rax, %rcx
        movq	%r10, 96(%rbx)
        adcxq	%rax, %r11
        adoxq	%rcx, %r12
        # A[11] * B[3]
        mulx	24(%rbp), %rax, %rcx
        movq	%r11, 104(%rbx)
        adcxq	%rax, %r12
        adoxq	%rcx, %r8
        movq	%r12, 112(%rbx)
        movq	(%rdi), %r9
        movq	8(%rdi), %r10
        movq	16(%rdi), %r11
        movq	24(%rdi), %r12
        # A[11] * B[4]
        mulx	32(%rbp), %rax, %rcx
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        # A[11] * B[5]
        mulx	40(%rbp), %rax, %rcx
        movq	%r8, 120(%rbx)
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        # A[11] * B[6]
        mulx	48(%rbp), %rax, %rcx
        movq	%r9, (%rdi)
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        # A[11] * B[7]
        mulx	56(%rbp), %rax, %rcx
        movq	%r10, 8(%rdi)
        adcxq	%rax, %r11
        adoxq	%rcx, %r12
        movq	%r11, 16(%rdi)
        movq	32(%rdi), %r8
        movq	40(%rdi), %r9
        movq	48(%rdi), %r10
        movq	56(%rdi), %r11
        # A[11] * B[8]
        mulx	64(%rbp), %rax, %rcx
        adcxq	%rax, %r12
        adoxq	%rcx, %r8
        # A[11] * B[9]
        mulx	72(%rbp), %rax, %rcx
        movq	%r12, 24(%rdi)
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        # A[11] * B[10]
        mulx	80(%rbp), %rax, %rcx
        movq	%r8, 32(%rdi)
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        # A[11] * B[11]
        mulx	88(%rbp), %rax, %rcx
        movq	%r9, 40(%rdi)
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        movq	%r10, 48(%rdi)
        movq	64(%rdi), %r12
        movq	72(%rdi), %r8
        movq	80(%rdi), %r9
        # A[11] * B[12]
        mulx	96(%rbp), %rax, %rcx
        adcxq	%rax, %r11
        adoxq	%rcx, %r12
        # A[11] * B[13]
        mulx	104(%rbp), %rax, %rcx
        movq	%r11, 56(%rdi)
        adcxq	%rax, %r12
        adoxq	%rcx, %r8
        # A[11] * B[14]
        mulx	112(%rbp), %rax, %rcx
        movq	%r12, 64(%rdi)
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        # A[11] * B[15]
        mulx	120(%rbp), %rax, %rcx
        movq	%r8, 72(%rdi)
        movq	%r14, %r10
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        adcxq	%r13, %r10
        movq	%r14, %r13
        adoxq	%r14, %r13
        adcxq	%r14, %r13
        movq	%r9, 80(%rdi)
        movq	%r10, 88(%rdi)
        movq	96(%rsi), %rdx
        movq	96(%rbx), %r10
        movq	104(%rbx), %r11
        movq	112(%rbx), %r12
        movq	120(%rbx), %r8
        movq	(%rdi), %r9
        # A[12] * B[0]
        mulx	(%rbp), %rax, %rcx
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        # A[12] * B[1]
        mulx	8(%rbp), %rax, %rcx
        movq	%r10, 96(%rbx)
        adcxq	%rax, %r11
        adoxq	%rcx, %r12
        # A[12] * B[2]
        mulx	16(%rbp), %rax, %rcx
        movq	%r11, 104(%rbx)
        adcxq	%rax, %r12
        adoxq	%rcx, %r8
        # A[12] * B[3]
        mulx	24(%rbp), %rax, %rcx
        movq	%r12, 112(%rbx)
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        movq	%r8, 120(%rbx)
        movq	8(%rdi), %r10
        movq	16(%rdi), %r11
        movq	24(%rdi), %r12
        movq	32(%rdi), %r8
        # A[12] * B[4]
        mulx	32(%rbp), %rax, %rcx
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        # A[12] * B[5]
        mulx	40(%rbp), %rax, %rcx
        movq	%r9, (%rdi)
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        # A[12] * B[6]
        mulx	48(%rbp), %rax, %rcx
        movq	%r10, 8(%rdi)
        adcxq	%rax, %r11
        adoxq	%rcx, %r12
        # A[12] * B[7]
        mulx	56(%rbp), %rax, %rcx
        movq	%r11, 16(%rdi)
        adcxq	%rax, %r12
        adoxq	%rcx, %r8
        movq	%r12, 24(%rdi)
        movq	40(%rdi), %r9
        movq	48(%rdi), %r10
        movq	56(%rdi), %r11
        movq	64(%rdi), %r12
        # A[12] * B[8]
        mulx	64(%rbp), %rax, %rcx
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        # A[12] * B[9]
        mulx	72(%rbp), %rax, %rcx
        movq	%r8, 32(%rdi)
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        # A[12] * B[10]
        mulx	80(%rbp), %rax, %rcx
        movq	%r9, 40(%rdi)
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        # A[12] * B[11]
        mulx	88(%rbp), %rax, %rcx
        movq	%r10, 48(%rdi)
        adcxq	%rax, %r11
        adoxq	%rcx, %r12
        movq	%r11, 56(%rdi)
        movq	72(%rdi), %r8
        movq	80(%rdi), %r9
        movq	88(%rdi), %r10
        # A[12] * B[12]
        mulx	96(%rbp), %rax, %rcx
        adcxq	%rax, %r12
        adoxq	%rcx, %r8
        # A[12] * B[13]
        mulx	104(%rbp), %rax, %rcx
        movq	%r12, 64(%rdi)
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        # A[12] * B[14]
        mulx	112(%rbp), %rax, %rcx
        movq	%r8, 72(%rdi)
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        # A[12] * B[15]
        mulx	120(%rbp), %rax, %rcx
        movq	%r9, 80(%rdi)
        movq	%r14, %r11
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        adcxq	%r13, %r11
        movq	%r14, %r13
        adoxq	%r14, %r13
        adcxq	%r14, %r13
        movq	%r10, 88(%rdi)
        movq	%r11, 96(%rdi)
        movq	104(%rsi), %rdx
        movq	104(%rbx), %r11
        movq	112(%rbx), %r12
        movq	120(%rbx), %r8
        movq	(%rdi), %r9
        movq	8(%rdi), %r10
        # A[13] * B[0]
        mulx	(%rbp), %rax, %rcx
        adcxq	%rax, %r11
        adoxq	%rcx, %r12
        # A[13] * B[1]
        mulx	8(%rbp), %rax, %rcx
        movq	%r11, 104(%rbx)
        adcxq	%rax, %r12
        adoxq	%rcx, %r8
        # A[13] * B[2]
        mulx	16(%rbp), %rax, %rcx
        movq	%r12, 112(%rbx)
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        # A[13] * B[3]
        mulx	24(%rbp), %rax, %rcx
        movq	%r8, 120(%rbx)
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        movq	%r9, (%rdi)
        movq	16(%rdi), %r11
        movq	24(%rdi), %r12
        movq	32(%rdi), %r8
        movq	40(%rdi), %r9
        # A[13] * B[4]
        mulx	32(%rbp), %rax, %rcx
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        # A[13] * B[5]
        mulx	40(%rbp), %rax, %rcx
        movq	%r10, 8(%rdi)
        adcxq	%rax, %r11
        adoxq	%rcx, %r12
        # A[13] * B[6]
        mulx	48(%rbp), %rax, %rcx
        movq	%r11, 16(%rdi)
        adcxq	%rax, %r12
        adoxq	%rcx, %r8
        # A[13] * B[7]
        mulx	56(%rbp), %rax, %rcx
        movq	%r12, 24(%rdi)
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        movq	%r8, 32(%rdi)
        movq	48(%rdi), %r10
        movq	56(%rdi), %r11
        movq	64(%rdi), %r12
        movq	72(%rdi), %r8
        # A[13] * B[8]
        mulx	64(%rbp), %rax, %rcx
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        # A[13] * B[9]
        mulx	72(%rbp), %rax, %rcx
        movq	%r9, 40(%rdi)
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        # A[13] * B[10]
        mulx	80(%rbp), %rax, %rcx
        movq	%r10, 48(%rdi)
        adcxq	%rax, %r11
        adoxq	%rcx, %r12
        # A[13] * B[11]
        mulx	88(%rbp), %rax, %rcx
        movq	%r11, 56(%rdi)
        adcxq	%rax, %r12
        adoxq	%rcx, %r8
        movq	%r12, 64(%rdi)
        movq	80(%rdi), %r9
        movq	88(%rdi), %r10
        movq	96(%rdi), %r11
        # A[13] * B[12]
        mulx	96(%rbp), %rax, %rcx
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        # A[13] * B[13]
        mulx	104(%rbp), %rax, %rcx
        movq	%r8, 72(%rdi)
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        # A[13] * B[14]
        mulx	112(%rbp), %rax, %rcx
        movq	%r9, 80(%rdi)
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        # A[13] * B[15]
        mulx	120(%rbp), %rax, %rcx
        movq	%r10, 88(%rdi)
        movq	%r14, %r12
        adcxq	%rax, %r11
        adoxq	%rcx, %r12
        adcxq	%r13, %r12
        movq	%r14, %r13
        adoxq	%r14, %r13
        adcxq	%r14, %r13
        movq	%r11, 96(%rdi)
        movq	%r12, 104(%rdi)
        movq	112(%rsi), %rdx
        movq	112(%rbx), %r12
        movq	120(%rbx), %r8
        movq	(%rdi), %r9
        movq	8(%rdi), %r10
        movq	16(%rdi), %r11
        # A[14] * B[0]
        mulx	(%rbp), %rax, %rcx
        adcxq	%rax, %r12
        adoxq	%rcx, %r8
        # A[14] * B[1]
        mulx	8(%rbp), %rax, %rcx
        movq	%r12, 112(%rbx)
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        # A[14] * B[2]
        mulx	16(%rbp), %rax, %rcx
        movq	%r8, 120(%rbx)
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        # A[14] * B[3]
        mulx	24(%rbp), %rax, %rcx
        movq	%r9, (%rdi)
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        movq	%r10, 8(%rdi)
        movq	24(%rdi), %r12
        movq	32(%rdi), %r8
        movq	40(%rdi), %r9
        movq	48(%rdi), %r10
        # A[14] * B[4]
        mulx	32(%rbp), %rax, %rcx
        adcxq	%rax, %r11
        adoxq	%rcx, %r12
        # A[14] * B[5]
        mulx	40(%rbp), %rax, %rcx
        movq	%r11, 16(%rdi)
        adcxq	%rax, %r12
        adoxq	%rcx, %r8
        # A[14] * B[6]
        mulx	48(%rbp), %rax, %rcx
        movq	%r12, 24(%rdi)
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        # A[14] * B[7]
        mulx	56(%rbp), %rax, %rcx
        movq	%r8, 32(%rdi)
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        movq	%r9, 40(%rdi)
        movq	56(%rdi), %r11
        movq	64(%rdi), %r12
        movq	72(%rdi), %r8
        movq	80(%rdi), %r9
        # A[14] * B[8]
        mulx	64(%rbp), %rax, %rcx
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        # A[14] * B[9]
        mulx	72(%rbp), %rax, %rcx
        movq	%r10, 48(%rdi)
        adcxq	%rax, %r11
        adoxq	%rcx, %r12
        # A[14] * B[10]
        mulx	80(%rbp), %rax, %rcx
        movq	%r11, 56(%rdi)
        adcxq	%rax, %r12
        adoxq	%rcx, %r8
        # A[14] * B[11]
        mulx	88(%rbp), %rax, %rcx
        movq	%r12, 64(%rdi)
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        movq	%r8, 72(%rdi)
        movq	88(%rdi), %r10
        movq	96(%rdi), %r11
        movq	104(%rdi), %r12
        # A[14] * B[12]
        mulx	96(%rbp), %rax, %rcx
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        # A[14] * B[13]
        mulx	104(%rbp), %rax, %rcx
        movq	%r9, 80(%rdi)
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        # A[14] * B[14]
        mulx	112(%rbp), %rax, %rcx
        movq	%r10, 88(%rdi)
        adcxq	%rax, %r11
        adoxq	%rcx, %r12
        # A[14] * B[15]
        mulx	120(%rbp), %rax, %rcx
        movq	%r11, 96(%rdi)
        movq	%r14, %r8
        adcxq	%rax, %r12
        adoxq	%rcx, %r8
        adcxq	%r13, %r8
        movq	%r14, %r13
        adoxq	%r14, %r13
        adcxq	%r14, %r13
        movq	%r12, 104(%rdi)
        movq	%r8, 112(%rdi)
        movq	120(%rsi), %rdx
        movq	120(%rbx), %r8
        movq	(%rdi), %r9
        movq	8(%rdi), %r10
        movq	16(%rdi), %r11
        movq	24(%rdi), %r12
        # A[15] * B[0]
        mulx	(%rbp), %rax, %rcx
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        # A[15] * B[1]
        mulx	8(%rbp), %rax, %rcx
        movq	%r8, 120(%rbx)
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        # A[15] * B[2]
        mulx	16(%rbp), %rax, %rcx
        movq	%r9, (%rdi)
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        # A[15] * B[3]
        mulx	24(%rbp), %rax, %rcx
        movq	%r10, 8(%rdi)
        adcxq	%rax, %r11
        adoxq	%rcx, %r12
        movq	%r11, 16(%rdi)
        movq	32(%rdi), %r8
        movq	40(%rdi), %r9
        movq	48(%rdi), %r10
        movq	56(%rdi), %r11
        # A[15] * B[4]
        mulx	32(%rbp), %rax, %rcx
        adcxq	%rax, %r12
        adoxq	%rcx, %r8
        # A[15] * B[5]
        mulx	40(%rbp), %rax, %rcx
        movq	%r12, 24(%rdi)
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        # A[15] * B[6]
        mulx	48(%rbp), %rax, %rcx
        movq	%r8, 32(%rdi)
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        # A[15] * B[7]
        mulx	56(%rbp), %rax, %rcx
        movq	%r9, 40(%rdi)
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        movq	%r10, 48(%rdi)
        movq	64(%rdi), %r12
        movq	72(%rdi), %r8
        movq	80(%rdi), %r9
        movq	88(%rdi), %r10
        # A[15] * B[8]
        mulx	64(%rbp), %rax, %rcx
        adcxq	%rax, %r11
        adoxq	%rcx, %r12
        # A[15] * B[9]
        mulx	72(%rbp), %rax, %rcx
        movq	%r11, 56(%rdi)
        adcxq	%rax, %r12
        adoxq	%rcx, %r8
        # A[15] * B[10]
        mulx	80(%rbp), %rax, %rcx
        movq	%r12, 64(%rdi)
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        # A[15] * B[11]
        mulx	88(%rbp), %rax, %rcx
        movq	%r8, 72(%rdi)
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        movq	%r9, 80(%rdi)
        movq	96(%rdi), %r11
        movq	104(%rdi), %r12
        movq	112(%rdi), %r8
        # A[15] * B[12]
        mulx	96(%rbp), %rax, %rcx
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        # A[15] * B[13]
        mulx	104(%rbp), %rax, %rcx
        movq	%r10, 88(%rdi)
        adcxq	%rax, %r11
        adoxq	%rcx, %r12
        # A[15] * B[14]
        mulx	112(%rbp), %rax, %rcx
        movq	%r11, 96(%rdi)
        adcxq	%rax, %r12
        adoxq	%rcx, %r8
        # A[15] * B[15]
        mulx	120(%rbp), %rax, %rcx
        movq	%r12, 104(%rdi)
        movq	%r14, %r9
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        adcxq	%r13, %r9
        movq	%r8, 112(%rdi)
        movq	%r9, 120(%rdi)
        subq	$0x80, %rdi
        cmpq	%rdi, %rsi
        je	L_start_2048_mul_avx2_16
        cmpq	%rdi, %rbp
        jne	L_end_2048_mul_avx2_16
L_start_2048_mul_avx2_16:
        vmovdqu	(%rbx), %xmm0
        vmovups	%xmm0, (%rdi)
        vmovdqu	16(%rbx), %xmm0
        vmovups	%xmm0, 16(%rdi)
        vmovdqu	32(%rbx), %xmm0
        vmovups	%xmm0, 32(%rdi)
        vmovdqu	48(%rbx), %xmm0
        vmovups	%xmm0, 48(%rdi)
        vmovdqu	64(%rbx), %xmm0
        vmovups	%xmm0, 64(%rdi)
        vmovdqu	80(%rbx), %xmm0
        vmovups	%xmm0, 80(%rdi)
        vmovdqu	96(%rbx), %xmm0
        vmovups	%xmm0, 96(%rdi)
        vmovdqu	112(%rbx), %xmm0
        vmovups	%xmm0, 112(%rdi)
L_end_2048_mul_avx2_16:
        addq	$0x80, %rsp
        popq	%r14
        popq	%r13
        popq	%r12
        popq	%rbp
        popq	%rbx
        repz retq
#ifndef __APPLE__
.size	sp_2048_mul_avx2_16,.-sp_2048_mul_avx2_16
#endif /* __APPLE__ */
#endif /* HAVE_INTEL_AVX2 */
/* Add b to a into r. (r = a + b)
 *
 * r  A single precision integer.
 * a  A single precision integer.
 * b  A single precision integer.
 */
#ifndef __APPLE__
.text
.globl	sp_2048_add_16
.type	sp_2048_add_16,@function
.align	16
sp_2048_add_16:
#else
.section	__TEXT,__text
.globl	_sp_2048_add_16
.p2align	4
_sp_2048_add_16:
#endif /* __APPLE__ */
        # Add
        movq	(%rsi), %rcx
        xorq	%rax, %rax
        addq	(%rdx), %rcx
        movq	8(%rsi), %r8
        movq	%rcx, (%rdi)
        adcq	8(%rdx), %r8
        movq	16(%rsi), %rcx
        movq	%r8, 8(%rdi)
        adcq	16(%rdx), %rcx
        movq	24(%rsi), %r8
        movq	%rcx, 16(%rdi)
        adcq	24(%rdx), %r8
        movq	32(%rsi), %rcx
        movq	%r8, 24(%rdi)
        adcq	32(%rdx), %rcx
        movq	40(%rsi), %r8
        movq	%rcx, 32(%rdi)
        adcq	40(%rdx), %r8
        movq	48(%rsi), %rcx
        movq	%r8, 40(%rdi)
        adcq	48(%rdx), %rcx
        movq	56(%rsi), %r8
        movq	%rcx, 48(%rdi)
        adcq	56(%rdx), %r8
        movq	64(%rsi), %rcx
        movq	%r8, 56(%rdi)
        adcq	64(%rdx), %rcx
        movq	72(%rsi), %r8
        movq	%rcx, 64(%rdi)
        adcq	72(%rdx), %r8
        movq	80(%rsi), %rcx
        movq	%r8, 72(%rdi)
        adcq	80(%rdx), %rcx
        movq	88(%rsi), %r8
        movq	%rcx, 80(%rdi)
        adcq	88(%rdx), %r8
        movq	96(%rsi), %rcx
        movq	%r8, 88(%rdi)
        adcq	96(%rdx), %rcx
        movq	104(%rsi), %r8
        movq	%rcx, 96(%rdi)
        adcq	104(%rdx), %r8
        movq	112(%rsi), %rcx
        movq	%r8, 104(%rdi)
        adcq	112(%rdx), %rcx
        movq	120(%rsi), %r8
        movq	%rcx, 112(%rdi)
        adcq	120(%rdx), %r8
        movq	%r8, 120(%rdi)
        adcq	$0x00, %rax
        repz retq
#ifndef __APPLE__
.size	sp_2048_add_16,.-sp_2048_add_16
#endif /* __APPLE__ */
/* Sub b from a into a. (a -= b)
 *
 * a  A single precision integer and result.
 * b  A single precision integer.
 */
#ifndef __APPLE__
.text
.globl	sp_2048_sub_in_place_32
.type	sp_2048_sub_in_place_32,@function
.align	16
sp_2048_sub_in_place_32:
#else
.section	__TEXT,__text
.globl	_sp_2048_sub_in_place_32
.p2align	4
_sp_2048_sub_in_place_32:
#endif /* __APPLE__ */
        movq	(%rdi), %rdx
        subq	(%rsi), %rdx
        movq	8(%rdi), %rcx
        movq	%rdx, (%rdi)
        sbbq	8(%rsi), %rcx
        movq	16(%rdi), %rdx
        movq	%rcx, 8(%rdi)
        sbbq	16(%rsi), %rdx
        movq	24(%rdi), %rcx
        movq	%rdx, 16(%rdi)
        sbbq	24(%rsi), %rcx
        movq	32(%rdi), %rdx
        movq	%rcx, 24(%rdi)
        sbbq	32(%rsi), %rdx
        movq	40(%rdi), %rcx
        movq	%rdx, 32(%rdi)
        sbbq	40(%rsi), %rcx
        movq	48(%rdi), %rdx
        movq	%rcx, 40(%rdi)
        sbbq	48(%rsi), %rdx
        movq	56(%rdi), %rcx
        movq	%rdx, 48(%rdi)
        sbbq	56(%rsi), %rcx
        movq	64(%rdi), %rdx
        movq	%rcx, 56(%rdi)
        sbbq	64(%rsi), %rdx
        movq	72(%rdi), %rcx
        movq	%rdx, 64(%rdi)
        sbbq	72(%rsi), %rcx
        movq	80(%rdi), %rdx
        movq	%rcx, 72(%rdi)
        sbbq	80(%rsi), %rdx
        movq	88(%rdi), %rcx
        movq	%rdx, 80(%rdi)
        sbbq	88(%rsi), %rcx
        movq	96(%rdi), %rdx
        movq	%rcx, 88(%rdi)
        sbbq	96(%rsi), %rdx
        movq	104(%rdi), %rcx
        movq	%rdx, 96(%rdi)
        sbbq	104(%rsi), %rcx
        movq	112(%rdi), %rdx
        movq	%rcx, 104(%rdi)
        sbbq	112(%rsi), %rdx
        movq	120(%rdi), %rcx
        movq	%rdx, 112(%rdi)
        sbbq	120(%rsi), %rcx
        movq	128(%rdi), %rdx
        movq	%rcx, 120(%rdi)
        sbbq	128(%rsi), %rdx
        movq	136(%rdi), %rcx
        movq	%rdx, 128(%rdi)
        sbbq	136(%rsi), %rcx
        movq	144(%rdi), %rdx
        movq	%rcx, 136(%rdi)
        sbbq	144(%rsi), %rdx
        movq	152(%rdi), %rcx
        movq	%rdx, 144(%rdi)
        sbbq	152(%rsi), %rcx
        movq	160(%rdi), %rdx
        movq	%rcx, 152(%rdi)
        sbbq	160(%rsi), %rdx
        movq	168(%rdi), %rcx
        movq	%rdx, 160(%rdi)
        sbbq	168(%rsi), %rcx
        movq	176(%rdi), %rdx
        movq	%rcx, 168(%rdi)
        sbbq	176(%rsi), %rdx
        movq	184(%rdi), %rcx
        movq	%rdx, 176(%rdi)
        sbbq	184(%rsi), %rcx
        movq	192(%rdi), %rdx
        movq	%rcx, 184(%rdi)
        sbbq	192(%rsi), %rdx
        movq	200(%rdi), %rcx
        movq	%rdx, 192(%rdi)
        sbbq	200(%rsi), %rcx
        movq	208(%rdi), %rdx
        movq	%rcx, 200(%rdi)
        sbbq	208(%rsi), %rdx
        movq	216(%rdi), %rcx
        movq	%rdx, 208(%rdi)
        sbbq	216(%rsi), %rcx
        movq	224(%rdi), %rdx
        movq	%rcx, 216(%rdi)
        sbbq	224(%rsi), %rdx
        movq	232(%rdi), %rcx
        movq	%rdx, 224(%rdi)
        sbbq	232(%rsi), %rcx
        movq	240(%rdi), %rdx
        movq	%rcx, 232(%rdi)
        sbbq	240(%rsi), %rdx
        movq	248(%rdi), %rcx
        movq	%rdx, 240(%rdi)
        sbbq	248(%rsi), %rcx
        movq	%rcx, 248(%rdi)
        sbbq	%rax, %rax
        repz retq
#ifndef __APPLE__
.size	sp_2048_sub_in_place_32,.-sp_2048_sub_in_place_32
#endif /* __APPLE__ */
/* Add b to a into r. (r = a + b)
 *
 * r  A single precision integer.
 * a  A single precision integer.
 * b  A single precision integer.
 */
#ifndef __APPLE__
.text
.globl	sp_2048_add_32
.type	sp_2048_add_32,@function
.align	16
sp_2048_add_32:
#else
.section	__TEXT,__text
.globl	_sp_2048_add_32
.p2align	4
_sp_2048_add_32:
#endif /* __APPLE__ */
        # Add
        movq	(%rsi), %rcx
        xorq	%rax, %rax
        addq	(%rdx), %rcx
        movq	8(%rsi), %r8
        movq	%rcx, (%rdi)
        adcq	8(%rdx), %r8
        movq	16(%rsi), %rcx
        movq	%r8, 8(%rdi)
        adcq	16(%rdx), %rcx
        movq	24(%rsi), %r8
        movq	%rcx, 16(%rdi)
        adcq	24(%rdx), %r8
        movq	32(%rsi), %rcx
        movq	%r8, 24(%rdi)
        adcq	32(%rdx), %rcx
        movq	40(%rsi), %r8
        movq	%rcx, 32(%rdi)
        adcq	40(%rdx), %r8
        movq	48(%rsi), %rcx
        movq	%r8, 40(%rdi)
        adcq	48(%rdx), %rcx
        movq	56(%rsi), %r8
        movq	%rcx, 48(%rdi)
        adcq	56(%rdx), %r8
        movq	64(%rsi), %rcx
        movq	%r8, 56(%rdi)
        adcq	64(%rdx), %rcx
        movq	72(%rsi), %r8
        movq	%rcx, 64(%rdi)
        adcq	72(%rdx), %r8
        movq	80(%rsi), %rcx
        movq	%r8, 72(%rdi)
        adcq	80(%rdx), %rcx
        movq	88(%rsi), %r8
        movq	%rcx, 80(%rdi)
        adcq	88(%rdx), %r8
        movq	96(%rsi), %rcx
        movq	%r8, 88(%rdi)
        adcq	96(%rdx), %rcx
        movq	104(%rsi), %r8
        movq	%rcx, 96(%rdi)
        adcq	104(%rdx), %r8
        movq	112(%rsi), %rcx
        movq	%r8, 104(%rdi)
        adcq	112(%rdx), %rcx
        movq	120(%rsi), %r8
        movq	%rcx, 112(%rdi)
        adcq	120(%rdx), %r8
        movq	128(%rsi), %rcx
        movq	%r8, 120(%rdi)
        adcq	128(%rdx), %rcx
        movq	136(%rsi), %r8
        movq	%rcx, 128(%rdi)
        adcq	136(%rdx), %r8
        movq	144(%rsi), %rcx
        movq	%r8, 136(%rdi)
        adcq	144(%rdx), %rcx
        movq	152(%rsi), %r8
        movq	%rcx, 144(%rdi)
        adcq	152(%rdx), %r8
        movq	160(%rsi), %rcx
        movq	%r8, 152(%rdi)
        adcq	160(%rdx), %rcx
        movq	168(%rsi), %r8
        movq	%rcx, 160(%rdi)
        adcq	168(%rdx), %r8
        movq	176(%rsi), %rcx
        movq	%r8, 168(%rdi)
        adcq	176(%rdx), %rcx
        movq	184(%rsi), %r8
        movq	%rcx, 176(%rdi)
        adcq	184(%rdx), %r8
        movq	192(%rsi), %rcx
        movq	%r8, 184(%rdi)
        adcq	192(%rdx), %rcx
        movq	200(%rsi), %r8
        movq	%rcx, 192(%rdi)
        adcq	200(%rdx), %r8
        movq	208(%rsi), %rcx
        movq	%r8, 200(%rdi)
        adcq	208(%rdx), %rcx
        movq	216(%rsi), %r8
        movq	%rcx, 208(%rdi)
        adcq	216(%rdx), %r8
        movq	224(%rsi), %rcx
        movq	%r8, 216(%rdi)
        adcq	224(%rdx), %rcx
        movq	232(%rsi), %r8
        movq	%rcx, 224(%rdi)
        adcq	232(%rdx), %r8
        movq	240(%rsi), %rcx
        movq	%r8, 232(%rdi)
        adcq	240(%rdx), %rcx
        movq	248(%rsi), %r8
        movq	%rcx, 240(%rdi)
        adcq	248(%rdx), %r8
        movq	%r8, 248(%rdi)
        adcq	$0x00, %rax
        repz retq
#ifndef __APPLE__
.size	sp_2048_add_32,.-sp_2048_add_32
#endif /* __APPLE__ */
/* Multiply a and b into r. (r = a * b)
 *
 * r  A single precision integer.
 * a  A single precision integer.
 * b  A single precision integer.
 */
#ifndef __APPLE__
.text
.globl	sp_2048_mul_32
.type	sp_2048_mul_32,@function
.align	16
sp_2048_mul_32:
#else
.section	__TEXT,__text
.globl	_sp_2048_mul_32
.p2align	4
_sp_2048_mul_32:
#endif /* __APPLE__ */
        pushq	%r12
        pushq	%r13
        pushq	%r14
        pushq	%r15
        subq	$0x328, %rsp
        movq	%rdi, 768(%rsp)
        movq	%rsi, 776(%rsp)
        movq	%rdx, 784(%rsp)
        leaq	512(%rsp), %r10
        leaq	128(%rsi), %r12
        # Add
        movq	(%rsi), %rax
        xorq	%r13, %r13
        addq	(%r12), %rax
        movq	8(%rsi), %rcx
        movq	%rax, (%r10)
        adcq	8(%r12), %rcx
        movq	16(%rsi), %r8
        movq	%rcx, 8(%r10)
        adcq	16(%r12), %r8
        movq	24(%rsi), %rax
        movq	%r8, 16(%r10)
        adcq	24(%r12), %rax
        movq	32(%rsi), %rcx
        movq	%rax, 24(%r10)
        adcq	32(%r12), %rcx
        movq	40(%rsi), %r8
        movq	%rcx, 32(%r10)
        adcq	40(%r12), %r8
        movq	48(%rsi), %rax
        movq	%r8, 40(%r10)
        adcq	48(%r12), %rax
        movq	56(%rsi), %rcx
        movq	%rax, 48(%r10)
        adcq	56(%r12), %rcx
        movq	64(%rsi), %r8
        movq	%rcx, 56(%r10)
        adcq	64(%r12), %r8
        movq	72(%rsi), %rax
        movq	%r8, 64(%r10)
        adcq	72(%r12), %rax
        movq	80(%rsi), %rcx
        movq	%rax, 72(%r10)
        adcq	80(%r12), %rcx
        movq	88(%rsi), %r8
        movq	%rcx, 80(%r10)
        adcq	88(%r12), %r8
        movq	96(%rsi), %rax
        movq	%r8, 88(%r10)
        adcq	96(%r12), %rax
        movq	104(%rsi), %rcx
        movq	%rax, 96(%r10)
        adcq	104(%r12), %rcx
        movq	112(%rsi), %r8
        movq	%rcx, 104(%r10)
        adcq	112(%r12), %r8
        movq	120(%rsi), %rax
        movq	%r8, 112(%r10)
        adcq	120(%r12), %rax
        movq	%rax, 120(%r10)
        adcq	$0x00, %r13
        movq	%r13, 792(%rsp)
        leaq	640(%rsp), %r11
        leaq	128(%rdx), %r12
        # Add
        movq	(%rdx), %rax
        xorq	%r14, %r14
        addq	(%r12), %rax
        movq	8(%rdx), %rcx
        movq	%rax, (%r11)
        adcq	8(%r12), %rcx
        movq	16(%rdx), %r8
        movq	%rcx, 8(%r11)
        adcq	16(%r12), %r8
        movq	24(%rdx), %rax
        movq	%r8, 16(%r11)
        adcq	24(%r12), %rax
        movq	32(%rdx), %rcx
        movq	%rax, 24(%r11)
        adcq	32(%r12), %rcx
        movq	40(%rdx), %r8
        movq	%rcx, 32(%r11)
        adcq	40(%r12), %r8
        movq	48(%rdx), %rax
        movq	%r8, 40(%r11)
        adcq	48(%r12), %rax
        movq	56(%rdx), %rcx
        movq	%rax, 48(%r11)
        adcq	56(%r12), %rcx
        movq	64(%rdx), %r8
        movq	%rcx, 56(%r11)
        adcq	64(%r12), %r8
        movq	72(%rdx), %rax
        movq	%r8, 64(%r11)
        adcq	72(%r12), %rax
        movq	80(%rdx), %rcx
        movq	%rax, 72(%r11)
        adcq	80(%r12), %rcx
        movq	88(%rdx), %r8
        movq	%rcx, 80(%r11)
        adcq	88(%r12), %r8
        movq	96(%rdx), %rax
        movq	%r8, 88(%r11)
        adcq	96(%r12), %rax
        movq	104(%rdx), %rcx
        movq	%rax, 96(%r11)
        adcq	104(%r12), %rcx
        movq	112(%rdx), %r8
        movq	%rcx, 104(%r11)
        adcq	112(%r12), %r8
        movq	120(%rdx), %rax
        movq	%r8, 112(%r11)
        adcq	120(%r12), %rax
        movq	%rax, 120(%r11)
        adcq	$0x00, %r14
        movq	%r14, 800(%rsp)
        movq	%r11, %rdx
        movq	%r10, %rsi
        movq	%rsp, %rdi
#ifndef __APPLE__
        callq	sp_2048_mul_16@plt
#else
        callq	_sp_2048_mul_16
#endif /* __APPLE__ */
        movq	784(%rsp), %rdx
        movq	776(%rsp), %rsi
        leaq	256(%rsp), %rdi
        addq	$0x80, %rdx
        addq	$0x80, %rsi
#ifndef __APPLE__
        callq	sp_2048_mul_16@plt
#else
        callq	_sp_2048_mul_16
#endif /* __APPLE__ */
        movq	784(%rsp), %rdx
        movq	776(%rsp), %rsi
        movq	768(%rsp), %rdi
#ifndef __APPLE__
        callq	sp_2048_mul_16@plt
#else
        callq	_sp_2048_mul_16
#endif /* __APPLE__ */
#ifdef _WIN64
        movq	784(%rsp), %rdx
        movq	776(%rsp), %rsi
        movq	768(%rsp), %rdi
#endif /* _WIN64 */
        movq	792(%rsp), %r13
        movq	800(%rsp), %r14
        movq	768(%rsp), %r15
        movq	%r13, %r9
        leaq	512(%rsp), %r10
        leaq	640(%rsp), %r11
        andq	%r14, %r9
        negq	%r13
        negq	%r14
        addq	$0x100, %r15
        movq	(%r10), %rax
        movq	(%r11), %rcx
        andq	%r14, %rax
        andq	%r13, %rcx
        movq	%rax, (%r10)
        movq	%rcx, (%r11)
        movq	8(%r10), %rax
        movq	8(%r11), %rcx
        andq	%r14, %rax
        andq	%r13, %rcx
        movq	%rax, 8(%r10)
        movq	%rcx, 8(%r11)
        movq	16(%r10), %rax
        movq	16(%r11), %rcx
        andq	%r14, %rax
        andq	%r13, %rcx
        movq	%rax, 16(%r10)
        movq	%rcx, 16(%r11)
        movq	24(%r10), %rax
        movq	24(%r11), %rcx
        andq	%r14, %rax
        andq	%r13, %rcx
        movq	%rax, 24(%r10)
        movq	%rcx, 24(%r11)
        movq	32(%r10), %rax
        movq	32(%r11), %rcx
        andq	%r14, %rax
        andq	%r13, %rcx
        movq	%rax, 32(%r10)
        movq	%rcx, 32(%r11)
        movq	40(%r10), %rax
        movq	40(%r11), %rcx
        andq	%r14, %rax
        andq	%r13, %rcx
        movq	%rax, 40(%r10)
        movq	%rcx, 40(%r11)
        movq	48(%r10), %rax
        movq	48(%r11), %rcx
        andq	%r14, %rax
        andq	%r13, %rcx
        movq	%rax, 48(%r10)
        movq	%rcx, 48(%r11)
        movq	56(%r10), %rax
        movq	56(%r11), %rcx
        andq	%r14, %rax
        andq	%r13, %rcx
        movq	%rax, 56(%r10)
        movq	%rcx, 56(%r11)
        movq	64(%r10), %rax
        movq	64(%r11), %rcx
        andq	%r14, %rax
        andq	%r13, %rcx
        movq	%rax, 64(%r10)
        movq	%rcx, 64(%r11)
        movq	72(%r10), %rax
        movq	72(%r11), %rcx
        andq	%r14, %rax
        andq	%r13, %rcx
        movq	%rax, 72(%r10)
        movq	%rcx, 72(%r11)
        movq	80(%r10), %rax
        movq	80(%r11), %rcx
        andq	%r14, %rax
        andq	%r13, %rcx
        movq	%rax, 80(%r10)
        movq	%rcx, 80(%r11)
        movq	88(%r10), %rax
        movq	88(%r11), %rcx
        andq	%r14, %rax
        andq	%r13, %rcx
        movq	%rax, 88(%r10)
        movq	%rcx, 88(%r11)
        movq	96(%r10), %rax
        movq	96(%r11), %rcx
        andq	%r14, %rax
        andq	%r13, %rcx
        movq	%rax, 96(%r10)
        movq	%rcx, 96(%r11)
        movq	104(%r10), %rax
        movq	104(%r11), %rcx
        andq	%r14, %rax
        andq	%r13, %rcx
        movq	%rax, 104(%r10)
        movq	%rcx, 104(%r11)
        movq	112(%r10), %rax
        movq	112(%r11), %rcx
        andq	%r14, %rax
        andq	%r13, %rcx
        movq	%rax, 112(%r10)
        movq	%rcx, 112(%r11)
        movq	120(%r10), %rax
        movq	120(%r11), %rcx
        andq	%r14, %rax
        andq	%r13, %rcx
        movq	%rax, 120(%r10)
        movq	%rcx, 120(%r11)
        movq	(%r10), %rax
        addq	(%r11), %rax
        movq	8(%r10), %rcx
        movq	%rax, (%r15)
        adcq	8(%r11), %rcx
        movq	16(%r10), %r8
        movq	%rcx, 8(%r15)
        adcq	16(%r11), %r8
        movq	24(%r10), %rax
        movq	%r8, 16(%r15)
        adcq	24(%r11), %rax
        movq	32(%r10), %rcx
        movq	%rax, 24(%r15)
        adcq	32(%r11), %rcx
        movq	40(%r10), %r8
        movq	%rcx, 32(%r15)
        adcq	40(%r11), %r8
        movq	48(%r10), %rax
        movq	%r8, 40(%r15)
        adcq	48(%r11), %rax
        movq	56(%r10), %rcx
        movq	%rax, 48(%r15)
        adcq	56(%r11), %rcx
        movq	64(%r10), %r8
        movq	%rcx, 56(%r15)
        adcq	64(%r11), %r8
        movq	72(%r10), %rax
        movq	%r8, 64(%r15)
        adcq	72(%r11), %rax
        movq	80(%r10), %rcx
        movq	%rax, 72(%r15)
        adcq	80(%r11), %rcx
        movq	88(%r10), %r8
        movq	%rcx, 80(%r15)
        adcq	88(%r11), %r8
        movq	96(%r10), %rax
        movq	%r8, 88(%r15)
        adcq	96(%r11), %rax
        movq	104(%r10), %rcx
        movq	%rax, 96(%r15)
        adcq	104(%r11), %rcx
        movq	112(%r10), %r8
        movq	%rcx, 104(%r15)
        adcq	112(%r11), %r8
        movq	120(%r10), %rax
        movq	%r8, 112(%r15)
        adcq	120(%r11), %rax
        movq	%rax, 120(%r15)
        adcq	$0x00, %r9
        leaq	256(%rsp), %r11
        movq	%rsp, %r10
        movq	(%r10), %rax
        subq	(%r11), %rax
        movq	8(%r10), %rcx
        movq	%rax, (%r10)
        sbbq	8(%r11), %rcx
        movq	16(%r10), %r8
        movq	%rcx, 8(%r10)
        sbbq	16(%r11), %r8
        movq	24(%r10), %rax
        movq	%r8, 16(%r10)
        sbbq	24(%r11), %rax
        movq	32(%r10), %rcx
        movq	%rax, 24(%r10)
        sbbq	32(%r11), %rcx
        movq	40(%r10), %r8
        movq	%rcx, 32(%r10)
        sbbq	40(%r11), %r8
        movq	48(%r10), %rax
        movq	%r8, 40(%r10)
        sbbq	48(%r11), %rax
        movq	56(%r10), %rcx
        movq	%rax, 48(%r10)
        sbbq	56(%r11), %rcx
        movq	64(%r10), %r8
        movq	%rcx, 56(%r10)
        sbbq	64(%r11), %r8
        movq	72(%r10), %rax
        movq	%r8, 64(%r10)
        sbbq	72(%r11), %rax
        movq	80(%r10), %rcx
        movq	%rax, 72(%r10)
        sbbq	80(%r11), %rcx
        movq	88(%r10), %r8
        movq	%rcx, 80(%r10)
        sbbq	88(%r11), %r8
        movq	96(%r10), %rax
        movq	%r8, 88(%r10)
        sbbq	96(%r11), %rax
        movq	104(%r10), %rcx
        movq	%rax, 96(%r10)
        sbbq	104(%r11), %rcx
        movq	112(%r10), %r8
        movq	%rcx, 104(%r10)
        sbbq	112(%r11), %r8
        movq	120(%r10), %rax
        movq	%r8, 112(%r10)
        sbbq	120(%r11), %rax
        movq	128(%r10), %rcx
        movq	%rax, 120(%r10)
        sbbq	128(%r11), %rcx
        movq	136(%r10), %r8
        movq	%rcx, 128(%r10)
        sbbq	136(%r11), %r8
        movq	144(%r10), %rax
        movq	%r8, 136(%r10)
        sbbq	144(%r11), %rax
        movq	152(%r10), %rcx
        movq	%rax, 144(%r10)
        sbbq	152(%r11), %rcx
        movq	160(%r10), %r8
        movq	%rcx, 152(%r10)
        sbbq	160(%r11), %r8
        movq	168(%r10), %rax
        movq	%r8, 160(%r10)
        sbbq	168(%r11), %rax
        movq	176(%r10), %rcx
        movq	%rax, 168(%r10)
        sbbq	176(%r11), %rcx
        movq	184(%r10), %r8
        movq	%rcx, 176(%r10)
        sbbq	184(%r11), %r8
        movq	192(%r10), %rax
        movq	%r8, 184(%r10)
        sbbq	192(%r11), %rax
        movq	200(%r10), %rcx
        movq	%rax, 192(%r10)
        sbbq	200(%r11), %rcx
        movq	208(%r10), %r8
        movq	%rcx, 200(%r10)
        sbbq	208(%r11), %r8
        movq	216(%r10), %rax
        movq	%r8, 208(%r10)
        sbbq	216(%r11), %rax
        movq	224(%r10), %rcx
        movq	%rax, 216(%r10)
        sbbq	224(%r11), %rcx
        movq	232(%r10), %r8
        movq	%rcx, 224(%r10)
        sbbq	232(%r11), %r8
        movq	240(%r10), %rax
        movq	%r8, 232(%r10)
        sbbq	240(%r11), %rax
        movq	248(%r10), %rcx
        movq	%rax, 240(%r10)
        sbbq	248(%r11), %rcx
        movq	%rcx, 248(%r10)
        sbbq	$0x00, %r9
        movq	(%r10), %rax
        subq	(%rdi), %rax
        movq	8(%r10), %rcx
        movq	%rax, (%r10)
        sbbq	8(%rdi), %rcx
        movq	16(%r10), %r8
        movq	%rcx, 8(%r10)
        sbbq	16(%rdi), %r8
        movq	24(%r10), %rax
        movq	%r8, 16(%r10)
        sbbq	24(%rdi), %rax
        movq	32(%r10), %rcx
        movq	%rax, 24(%r10)
        sbbq	32(%rdi), %rcx
        movq	40(%r10), %r8
        movq	%rcx, 32(%r10)
        sbbq	40(%rdi), %r8
        movq	48(%r10), %rax
        movq	%r8, 40(%r10)
        sbbq	48(%rdi), %rax
        movq	56(%r10), %rcx
        movq	%rax, 48(%r10)
        sbbq	56(%rdi), %rcx
        movq	64(%r10), %r8
        movq	%rcx, 56(%r10)
        sbbq	64(%rdi), %r8
        movq	72(%r10), %rax
        movq	%r8, 64(%r10)
        sbbq	72(%rdi), %rax
        movq	80(%r10), %rcx
        movq	%rax, 72(%r10)
        sbbq	80(%rdi), %rcx
        movq	88(%r10), %r8
        movq	%rcx, 80(%r10)
        sbbq	88(%rdi), %r8
        movq	96(%r10), %rax
        movq	%r8, 88(%r10)
        sbbq	96(%rdi), %rax
        movq	104(%r10), %rcx
        movq	%rax, 96(%r10)
        sbbq	104(%rdi), %rcx
        movq	112(%r10), %r8
        movq	%rcx, 104(%r10)
        sbbq	112(%rdi), %r8
        movq	120(%r10), %rax
        movq	%r8, 112(%r10)
        sbbq	120(%rdi), %rax
        movq	128(%r10), %rcx
        movq	%rax, 120(%r10)
        sbbq	128(%rdi), %rcx
        movq	136(%r10), %r8
        movq	%rcx, 128(%r10)
        sbbq	136(%rdi), %r8
        movq	144(%r10), %rax
        movq	%r8, 136(%r10)
        sbbq	144(%rdi), %rax
        movq	152(%r10), %rcx
        movq	%rax, 144(%r10)
        sbbq	152(%rdi), %rcx
        movq	160(%r10), %r8
        movq	%rcx, 152(%r10)
        sbbq	160(%rdi), %r8
        movq	168(%r10), %rax
        movq	%r8, 160(%r10)
        sbbq	168(%rdi), %rax
        movq	176(%r10), %rcx
        movq	%rax, 168(%r10)
        sbbq	176(%rdi), %rcx
        movq	184(%r10), %r8
        movq	%rcx, 176(%r10)
        sbbq	184(%rdi), %r8
        movq	192(%r10), %rax
        movq	%r8, 184(%r10)
        sbbq	192(%rdi), %rax
        movq	200(%r10), %rcx
        movq	%rax, 192(%r10)
        sbbq	200(%rdi), %rcx
        movq	208(%r10), %r8
        movq	%rcx, 200(%r10)
        sbbq	208(%rdi), %r8
        movq	216(%r10), %rax
        movq	%r8, 208(%r10)
        sbbq	216(%rdi), %rax
        movq	224(%r10), %rcx
        movq	%rax, 216(%r10)
        sbbq	224(%rdi), %rcx
        movq	232(%r10), %r8
        movq	%rcx, 224(%r10)
        sbbq	232(%rdi), %r8
        movq	240(%r10), %rax
        movq	%r8, 232(%r10)
        sbbq	240(%rdi), %rax
        movq	248(%r10), %rcx
        movq	%rax, 240(%r10)
        sbbq	248(%rdi), %rcx
        movq	%rcx, 248(%r10)
        sbbq	$0x00, %r9
        subq	$0x80, %r15
        # Add
        movq	(%r15), %rax
        addq	(%r10), %rax
        movq	8(%r15), %rcx
        movq	%rax, (%r15)
        adcq	8(%r10), %rcx
        movq	16(%r15), %r8
        movq	%rcx, 8(%r15)
        adcq	16(%r10), %r8
        movq	24(%r15), %rax
        movq	%r8, 16(%r15)
        adcq	24(%r10), %rax
        movq	32(%r15), %rcx
        movq	%rax, 24(%r15)
        adcq	32(%r10), %rcx
        movq	40(%r15), %r8
        movq	%rcx, 32(%r15)
        adcq	40(%r10), %r8
        movq	48(%r15), %rax
        movq	%r8, 40(%r15)
        adcq	48(%r10), %rax
        movq	56(%r15), %rcx
        movq	%rax, 48(%r15)
        adcq	56(%r10), %rcx
        movq	64(%r15), %r8
        movq	%rcx, 56(%r15)
        adcq	64(%r10), %r8
        movq	72(%r15), %rax
        movq	%r8, 64(%r15)
        adcq	72(%r10), %rax
        movq	80(%r15), %rcx
        movq	%rax, 72(%r15)
        adcq	80(%r10), %rcx
        movq	88(%r15), %r8
        movq	%rcx, 80(%r15)
        adcq	88(%r10), %r8
        movq	96(%r15), %rax
        movq	%r8, 88(%r15)
        adcq	96(%r10), %rax
        movq	104(%r15), %rcx
        movq	%rax, 96(%r15)
        adcq	104(%r10), %rcx
        movq	112(%r15), %r8
        movq	%rcx, 104(%r15)
        adcq	112(%r10), %r8
        movq	120(%r15), %rax
        movq	%r8, 112(%r15)
        adcq	120(%r10), %rax
        movq	128(%r15), %rcx
        movq	%rax, 120(%r15)
        adcq	128(%r10), %rcx
        movq	136(%r15), %r8
        movq	%rcx, 128(%r15)
        adcq	136(%r10), %r8
        movq	144(%r15), %rax
        movq	%r8, 136(%r15)
        adcq	144(%r10), %rax
        movq	152(%r15), %rcx
        movq	%rax, 144(%r15)
        adcq	152(%r10), %rcx
        movq	160(%r15), %r8
        movq	%rcx, 152(%r15)
        adcq	160(%r10), %r8
        movq	168(%r15), %rax
        movq	%r8, 160(%r15)
        adcq	168(%r10), %rax
        movq	176(%r15), %rcx
        movq	%rax, 168(%r15)
        adcq	176(%r10), %rcx
        movq	184(%r15), %r8
        movq	%rcx, 176(%r15)
        adcq	184(%r10), %r8
        movq	192(%r15), %rax
        movq	%r8, 184(%r15)
        adcq	192(%r10), %rax
        movq	200(%r15), %rcx
        movq	%rax, 192(%r15)
        adcq	200(%r10), %rcx
        movq	208(%r15), %r8
        movq	%rcx, 200(%r15)
        adcq	208(%r10), %r8
        movq	216(%r15), %rax
        movq	%r8, 208(%r15)
        adcq	216(%r10), %rax
        movq	224(%r15), %rcx
        movq	%rax, 216(%r15)
        adcq	224(%r10), %rcx
        movq	232(%r15), %r8
        movq	%rcx, 224(%r15)
        adcq	232(%r10), %r8
        movq	240(%r15), %rax
        movq	%r8, 232(%r15)
        adcq	240(%r10), %rax
        movq	248(%r15), %rcx
        movq	%rax, 240(%r15)
        adcq	248(%r10), %rcx
        movq	%rcx, 248(%r15)
        adcq	$0x00, %r9
        movq	%r9, 384(%rdi)
        addq	$0x80, %r15
        # Add
        movq	(%r15), %rax
        addq	(%r11), %rax
        movq	8(%r15), %rcx
        movq	%rax, (%r15)
        adcq	8(%r11), %rcx
        movq	16(%r15), %r8
        movq	%rcx, 8(%r15)
        adcq	16(%r11), %r8
        movq	24(%r15), %rax
        movq	%r8, 16(%r15)
        adcq	24(%r11), %rax
        movq	32(%r15), %rcx
        movq	%rax, 24(%r15)
        adcq	32(%r11), %rcx
        movq	40(%r15), %r8
        movq	%rcx, 32(%r15)
        adcq	40(%r11), %r8
        movq	48(%r15), %rax
        movq	%r8, 40(%r15)
        adcq	48(%r11), %rax
        movq	56(%r15), %rcx
        movq	%rax, 48(%r15)
        adcq	56(%r11), %rcx
        movq	64(%r15), %r8
        movq	%rcx, 56(%r15)
        adcq	64(%r11), %r8
        movq	72(%r15), %rax
        movq	%r8, 64(%r15)
        adcq	72(%r11), %rax
        movq	80(%r15), %rcx
        movq	%rax, 72(%r15)
        adcq	80(%r11), %rcx
        movq	88(%r15), %r8
        movq	%rcx, 80(%r15)
        adcq	88(%r11), %r8
        movq	96(%r15), %rax
        movq	%r8, 88(%r15)
        adcq	96(%r11), %rax
        movq	104(%r15), %rcx
        movq	%rax, 96(%r15)
        adcq	104(%r11), %rcx
        movq	112(%r15), %r8
        movq	%rcx, 104(%r15)
        adcq	112(%r11), %r8
        movq	120(%r15), %rax
        movq	%r8, 112(%r15)
        adcq	120(%r11), %rax
        movq	128(%r15), %rcx
        movq	%rax, 120(%r15)
        adcq	128(%r11), %rcx
        movq	%rcx, 128(%r15)
        # Add to zero
        movq	136(%r11), %rax
        adcq	$0x00, %rax
        movq	144(%r11), %rcx
        movq	%rax, 136(%r15)
        adcq	$0x00, %rcx
        movq	152(%r11), %r8
        movq	%rcx, 144(%r15)
        adcq	$0x00, %r8
        movq	160(%r11), %rax
        movq	%r8, 152(%r15)
        adcq	$0x00, %rax
        movq	168(%r11), %rcx
        movq	%rax, 160(%r15)
        adcq	$0x00, %rcx
        movq	176(%r11), %r8
        movq	%rcx, 168(%r15)
        adcq	$0x00, %r8
        movq	184(%r11), %rax
        movq	%r8, 176(%r15)
        adcq	$0x00, %rax
        movq	192(%r11), %rcx
        movq	%rax, 184(%r15)
        adcq	$0x00, %rcx
        movq	200(%r11), %r8
        movq	%rcx, 192(%r15)
        adcq	$0x00, %r8
        movq	208(%r11), %rax
        movq	%r8, 200(%r15)
        adcq	$0x00, %rax
        movq	216(%r11), %rcx
        movq	%rax, 208(%r15)
        adcq	$0x00, %rcx
        movq	224(%r11), %r8
        movq	%rcx, 216(%r15)
        adcq	$0x00, %r8
        movq	232(%r11), %rax
        movq	%r8, 224(%r15)
        adcq	$0x00, %rax
        movq	240(%r11), %rcx
        movq	%rax, 232(%r15)
        adcq	$0x00, %rcx
        movq	248(%r11), %r8
        movq	%rcx, 240(%r15)
        adcq	$0x00, %r8
        movq	%r8, 248(%r15)
        addq	$0x328, %rsp
        popq	%r15
        popq	%r14
        popq	%r13
        popq	%r12
        repz retq
#ifndef __APPLE__
.size	sp_2048_mul_32,.-sp_2048_mul_32
#endif /* __APPLE__ */
#ifdef HAVE_INTEL_AVX2
/* Multiply a and b into r. (r = a * b)
 *
 * r  A single precision integer.
 * a  A single precision integer.
 * b  A single precision integer.
 */
#ifndef __APPLE__
.text
.globl	sp_2048_mul_avx2_32
.type	sp_2048_mul_avx2_32,@function
.align	16
sp_2048_mul_avx2_32:
#else
.section	__TEXT,__text
.globl	_sp_2048_mul_avx2_32
.p2align	4
_sp_2048_mul_avx2_32:
#endif /* __APPLE__ */
        pushq	%r12
        pushq	%r13
        pushq	%r14
        pushq	%r15
        subq	$0x328, %rsp
        movq	%rdi, 768(%rsp)
        movq	%rsi, 776(%rsp)
        movq	%rdx, 784(%rsp)
        leaq	512(%rsp), %r10
        leaq	128(%rsi), %r12
        # Add
        movq	(%rsi), %rax
        xorq	%r13, %r13
        addq	(%r12), %rax
        movq	8(%rsi), %rcx
        movq	%rax, (%r10)
        adcq	8(%r12), %rcx
        movq	16(%rsi), %r8
        movq	%rcx, 8(%r10)
        adcq	16(%r12), %r8
        movq	24(%rsi), %rax
        movq	%r8, 16(%r10)
        adcq	24(%r12), %rax
        movq	32(%rsi), %rcx
        movq	%rax, 24(%r10)
        adcq	32(%r12), %rcx
        movq	40(%rsi), %r8
        movq	%rcx, 32(%r10)
        adcq	40(%r12), %r8
        movq	48(%rsi), %rax
        movq	%r8, 40(%r10)
        adcq	48(%r12), %rax
        movq	56(%rsi), %rcx
        movq	%rax, 48(%r10)
        adcq	56(%r12), %rcx
        movq	64(%rsi), %r8
        movq	%rcx, 56(%r10)
        adcq	64(%r12), %r8
        movq	72(%rsi), %rax
        movq	%r8, 64(%r10)
        adcq	72(%r12), %rax
        movq	80(%rsi), %rcx
        movq	%rax, 72(%r10)
        adcq	80(%r12), %rcx
        movq	88(%rsi), %r8
        movq	%rcx, 80(%r10)
        adcq	88(%r12), %r8
        movq	96(%rsi), %rax
        movq	%r8, 88(%r10)
        adcq	96(%r12), %rax
        movq	104(%rsi), %rcx
        movq	%rax, 96(%r10)
        adcq	104(%r12), %rcx
        movq	112(%rsi), %r8
        movq	%rcx, 104(%r10)
        adcq	112(%r12), %r8
        movq	120(%rsi), %rax
        movq	%r8, 112(%r10)
        adcq	120(%r12), %rax
        movq	%rax, 120(%r10)
        adcq	$0x00, %r13
        movq	%r13, 792(%rsp)
        leaq	640(%rsp), %r11
        leaq	128(%rdx), %r12
        # Add
        movq	(%rdx), %rax
        xorq	%r14, %r14
        addq	(%r12), %rax
        movq	8(%rdx), %rcx
        movq	%rax, (%r11)
        adcq	8(%r12), %rcx
        movq	16(%rdx), %r8
        movq	%rcx, 8(%r11)
        adcq	16(%r12), %r8
        movq	24(%rdx), %rax
        movq	%r8, 16(%r11)
        adcq	24(%r12), %rax
        movq	32(%rdx), %rcx
        movq	%rax, 24(%r11)
        adcq	32(%r12), %rcx
        movq	40(%rdx), %r8
        movq	%rcx, 32(%r11)
        adcq	40(%r12), %r8
        movq	48(%rdx), %rax
        movq	%r8, 40(%r11)
        adcq	48(%r12), %rax
        movq	56(%rdx), %rcx
        movq	%rax, 48(%r11)
        adcq	56(%r12), %rcx
        movq	64(%rdx), %r8
        movq	%rcx, 56(%r11)
        adcq	64(%r12), %r8
        movq	72(%rdx), %rax
        movq	%r8, 64(%r11)
        adcq	72(%r12), %rax
        movq	80(%rdx), %rcx
        movq	%rax, 72(%r11)
        adcq	80(%r12), %rcx
        movq	88(%rdx), %r8
        movq	%rcx, 80(%r11)
        adcq	88(%r12), %r8
        movq	96(%rdx), %rax
        movq	%r8, 88(%r11)
        adcq	96(%r12), %rax
        movq	104(%rdx), %rcx
        movq	%rax, 96(%r11)
        adcq	104(%r12), %rcx
        movq	112(%rdx), %r8
        movq	%rcx, 104(%r11)
        adcq	112(%r12), %r8
        movq	120(%rdx), %rax
        movq	%r8, 112(%r11)
        adcq	120(%r12), %rax
        movq	%rax, 120(%r11)
        adcq	$0x00, %r14
        movq	%r14, 800(%rsp)
        movq	%r11, %rdx
        movq	%r10, %rsi
        movq	%rsp, %rdi
#ifndef __APPLE__
        callq	sp_2048_mul_avx2_16@plt
#else
        callq	_sp_2048_mul_avx2_16
#endif /* __APPLE__ */
        movq	784(%rsp), %rdx
        movq	776(%rsp), %rsi
        leaq	256(%rsp), %rdi
        addq	$0x80, %rdx
        addq	$0x80, %rsi
#ifndef __APPLE__
        callq	sp_2048_mul_avx2_16@plt
#else
        callq	_sp_2048_mul_avx2_16
#endif /* __APPLE__ */
        movq	784(%rsp), %rdx
        movq	776(%rsp), %rsi
        movq	768(%rsp), %rdi
#ifndef __APPLE__
        callq	sp_2048_mul_avx2_16@plt
#else
        callq	_sp_2048_mul_avx2_16
#endif /* __APPLE__ */
#ifdef _WIN64
        movq	784(%rsp), %rdx
        movq	776(%rsp), %rsi
        movq	768(%rsp), %rdi
#endif /* _WIN64 */
        movq	792(%rsp), %r13
        movq	800(%rsp), %r14
        movq	768(%rsp), %r15
        movq	%r13, %r9
        leaq	512(%rsp), %r10
        leaq	640(%rsp), %r11
        andq	%r14, %r9
        negq	%r13
        negq	%r14
        addq	$0x100, %r15
        movq	(%r10), %rax
        movq	(%r11), %rcx
        pextq	%r14, %rax, %rax
        pextq	%r13, %rcx, %rcx
        addq	%rcx, %rax
        movq	8(%r10), %rcx
        movq	8(%r11), %r8
        pextq	%r14, %rcx, %rcx
        pextq	%r13, %r8, %r8
        movq	%rax, (%r15)
        adcq	%r8, %rcx
        movq	16(%r10), %r8
        movq	16(%r11), %rax
        pextq	%r14, %r8, %r8
        pextq	%r13, %rax, %rax
        movq	%rcx, 8(%r15)
        adcq	%rax, %r8
        movq	24(%r10), %rax
        movq	24(%r11), %rcx
        pextq	%r14, %rax, %rax
        pextq	%r13, %rcx, %rcx
        movq	%r8, 16(%r15)
        adcq	%rcx, %rax
        movq	32(%r10), %rcx
        movq	32(%r11), %r8
        pextq	%r14, %rcx, %rcx
        pextq	%r13, %r8, %r8
        movq	%rax, 24(%r15)
        adcq	%r8, %rcx
        movq	40(%r10), %r8
        movq	40(%r11), %rax
        pextq	%r14, %r8, %r8
        pextq	%r13, %rax, %rax
        movq	%rcx, 32(%r15)
        adcq	%rax, %r8
        movq	48(%r10), %rax
        movq	48(%r11), %rcx
        pextq	%r14, %rax, %rax
        pextq	%r13, %rcx, %rcx
        movq	%r8, 40(%r15)
        adcq	%rcx, %rax
        movq	56(%r10), %rcx
        movq	56(%r11), %r8
        pextq	%r14, %rcx, %rcx
        pextq	%r13, %r8, %r8
        movq	%rax, 48(%r15)
        adcq	%r8, %rcx
        movq	64(%r10), %r8
        movq	64(%r11), %rax
        pextq	%r14, %r8, %r8
        pextq	%r13, %rax, %rax
        movq	%rcx, 56(%r15)
        adcq	%rax, %r8
        movq	72(%r10), %rax
        movq	72(%r11), %rcx
        pextq	%r14, %rax, %rax
        pextq	%r13, %rcx, %rcx
        movq	%r8, 64(%r15)
        adcq	%rcx, %rax
        movq	80(%r10), %rcx
        movq	80(%r11), %r8
        pextq	%r14, %rcx, %rcx
        pextq	%r13, %r8, %r8
        movq	%rax, 72(%r15)
        adcq	%r8, %rcx
        movq	88(%r10), %r8
        movq	88(%r11), %rax
        pextq	%r14, %r8, %r8
        pextq	%r13, %rax, %rax
        movq	%rcx, 80(%r15)
        adcq	%rax, %r8
        movq	96(%r10), %rax
        movq	96(%r11), %rcx
        pextq	%r14, %rax, %rax
        pextq	%r13, %rcx, %rcx
        movq	%r8, 88(%r15)
        adcq	%rcx, %rax
        movq	104(%r10), %rcx
        movq	104(%r11), %r8
        pextq	%r14, %rcx, %rcx
        pextq	%r13, %r8, %r8
        movq	%rax, 96(%r15)
        adcq	%r8, %rcx
        movq	112(%r10), %r8
        movq	112(%r11), %rax
        pextq	%r14, %r8, %r8
        pextq	%r13, %rax, %rax
        movq	%rcx, 104(%r15)
        adcq	%rax, %r8
        movq	120(%r10), %rax
        movq	120(%r11), %rcx
        pextq	%r14, %rax, %rax
        pextq	%r13, %rcx, %rcx
        movq	%r8, 112(%r15)
        adcq	%rcx, %rax
        movq	%rax, 120(%r15)
        adcq	$0x00, %r9
        leaq	256(%rsp), %r11
        movq	%rsp, %r10
        movq	(%r10), %rax
        subq	(%r11), %rax
        movq	8(%r10), %rcx
        movq	%rax, (%r10)
        sbbq	8(%r11), %rcx
        movq	16(%r10), %r8
        movq	%rcx, 8(%r10)
        sbbq	16(%r11), %r8
        movq	24(%r10), %rax
        movq	%r8, 16(%r10)
        sbbq	24(%r11), %rax
        movq	32(%r10), %rcx
        movq	%rax, 24(%r10)
        sbbq	32(%r11), %rcx
        movq	40(%r10), %r8
        movq	%rcx, 32(%r10)
        sbbq	40(%r11), %r8
        movq	48(%r10), %rax
        movq	%r8, 40(%r10)
        sbbq	48(%r11), %rax
        movq	56(%r10), %rcx
        movq	%rax, 48(%r10)
        sbbq	56(%r11), %rcx
        movq	64(%r10), %r8
        movq	%rcx, 56(%r10)
        sbbq	64(%r11), %r8
        movq	72(%r10), %rax
        movq	%r8, 64(%r10)
        sbbq	72(%r11), %rax
        movq	80(%r10), %rcx
        movq	%rax, 72(%r10)
        sbbq	80(%r11), %rcx
        movq	88(%r10), %r8
        movq	%rcx, 80(%r10)
        sbbq	88(%r11), %r8
        movq	96(%r10), %rax
        movq	%r8, 88(%r10)
        sbbq	96(%r11), %rax
        movq	104(%r10), %rcx
        movq	%rax, 96(%r10)
        sbbq	104(%r11), %rcx
        movq	112(%r10), %r8
        movq	%rcx, 104(%r10)
        sbbq	112(%r11), %r8
        movq	120(%r10), %rax
        movq	%r8, 112(%r10)
        sbbq	120(%r11), %rax
        movq	128(%r10), %rcx
        movq	%rax, 120(%r10)
        sbbq	128(%r11), %rcx
        movq	136(%r10), %r8
        movq	%rcx, 128(%r10)
        sbbq	136(%r11), %r8
        movq	144(%r10), %rax
        movq	%r8, 136(%r10)
        sbbq	144(%r11), %rax
        movq	152(%r10), %rcx
        movq	%rax, 144(%r10)
        sbbq	152(%r11), %rcx
        movq	160(%r10), %r8
        movq	%rcx, 152(%r10)
        sbbq	160(%r11), %r8
        movq	168(%r10), %rax
        movq	%r8, 160(%r10)
        sbbq	168(%r11), %rax
        movq	176(%r10), %rcx
        movq	%rax, 168(%r10)
        sbbq	176(%r11), %rcx
        movq	184(%r10), %r8
        movq	%rcx, 176(%r10)
        sbbq	184(%r11), %r8
        movq	192(%r10), %rax
        movq	%r8, 184(%r10)
        sbbq	192(%r11), %rax
        movq	200(%r10), %rcx
        movq	%rax, 192(%r10)
        sbbq	200(%r11), %rcx
        movq	208(%r10), %r8
        movq	%rcx, 200(%r10)
        sbbq	208(%r11), %r8
        movq	216(%r10), %rax
        movq	%r8, 208(%r10)
        sbbq	216(%r11), %rax
        movq	224(%r10), %rcx
        movq	%rax, 216(%r10)
        sbbq	224(%r11), %rcx
        movq	232(%r10), %r8
        movq	%rcx, 224(%r10)
        sbbq	232(%r11), %r8
        movq	240(%r10), %rax
        movq	%r8, 232(%r10)
        sbbq	240(%r11), %rax
        movq	248(%r10), %rcx
        movq	%rax, 240(%r10)
        sbbq	248(%r11), %rcx
        movq	%rcx, 248(%r10)
        sbbq	$0x00, %r9
        movq	(%r10), %rax
        subq	(%rdi), %rax
        movq	8(%r10), %rcx
        movq	%rax, (%r10)
        sbbq	8(%rdi), %rcx
        movq	16(%r10), %r8
        movq	%rcx, 8(%r10)
        sbbq	16(%rdi), %r8
        movq	24(%r10), %rax
        movq	%r8, 16(%r10)
        sbbq	24(%rdi), %rax
        movq	32(%r10), %rcx
        movq	%rax, 24(%r10)
        sbbq	32(%rdi), %rcx
        movq	40(%r10), %r8
        movq	%rcx, 32(%r10)
        sbbq	40(%rdi), %r8
        movq	48(%r10), %rax
        movq	%r8, 40(%r10)
        sbbq	48(%rdi), %rax
        movq	56(%r10), %rcx
        movq	%rax, 48(%r10)
        sbbq	56(%rdi), %rcx
        movq	64(%r10), %r8
        movq	%rcx, 56(%r10)
        sbbq	64(%rdi), %r8
        movq	72(%r10), %rax
        movq	%r8, 64(%r10)
        sbbq	72(%rdi), %rax
        movq	80(%r10), %rcx
        movq	%rax, 72(%r10)
        sbbq	80(%rdi), %rcx
        movq	88(%r10), %r8
        movq	%rcx, 80(%r10)
        sbbq	88(%rdi), %r8
        movq	96(%r10), %rax
        movq	%r8, 88(%r10)
        sbbq	96(%rdi), %rax
        movq	104(%r10), %rcx
        movq	%rax, 96(%r10)
        sbbq	104(%rdi), %rcx
        movq	112(%r10), %r8
        movq	%rcx, 104(%r10)
        sbbq	112(%rdi), %r8
        movq	120(%r10), %rax
        movq	%r8, 112(%r10)
        sbbq	120(%rdi), %rax
        movq	128(%r10), %rcx
        movq	%rax, 120(%r10)
        sbbq	128(%rdi), %rcx
        movq	136(%r10), %r8
        movq	%rcx, 128(%r10)
        sbbq	136(%rdi), %r8
        movq	144(%r10), %rax
        movq	%r8, 136(%r10)
        sbbq	144(%rdi), %rax
        movq	152(%r10), %rcx
        movq	%rax, 144(%r10)
        sbbq	152(%rdi), %rcx
        movq	160(%r10), %r8
        movq	%rcx, 152(%r10)
        sbbq	160(%rdi), %r8
        movq	168(%r10), %rax
        movq	%r8, 160(%r10)
        sbbq	168(%rdi), %rax
        movq	176(%r10), %rcx
        movq	%rax, 168(%r10)
        sbbq	176(%rdi), %rcx
        movq	184(%r10), %r8
        movq	%rcx, 176(%r10)
        sbbq	184(%rdi), %r8
        movq	192(%r10), %rax
        movq	%r8, 184(%r10)
        sbbq	192(%rdi), %rax
        movq	200(%r10), %rcx
        movq	%rax, 192(%r10)
        sbbq	200(%rdi), %rcx
        movq	208(%r10), %r8
        movq	%rcx, 200(%r10)
        sbbq	208(%rdi), %r8
        movq	216(%r10), %rax
        movq	%r8, 208(%r10)
        sbbq	216(%rdi), %rax
        movq	224(%r10), %rcx
        movq	%rax, 216(%r10)
        sbbq	224(%rdi), %rcx
        movq	232(%r10), %r8
        movq	%rcx, 224(%r10)
        sbbq	232(%rdi), %r8
        movq	240(%r10), %rax
        movq	%r8, 232(%r10)
        sbbq	240(%rdi), %rax
        movq	248(%r10), %rcx
        movq	%rax, 240(%r10)
        sbbq	248(%rdi), %rcx
        movq	%rcx, 248(%r10)
        sbbq	$0x00, %r9
        subq	$0x80, %r15
        # Add
        movq	(%r15), %rax
        addq	(%r10), %rax
        movq	8(%r15), %rcx
        movq	%rax, (%r15)
        adcq	8(%r10), %rcx
        movq	16(%r15), %r8
        movq	%rcx, 8(%r15)
        adcq	16(%r10), %r8
        movq	24(%r15), %rax
        movq	%r8, 16(%r15)
        adcq	24(%r10), %rax
        movq	32(%r15), %rcx
        movq	%rax, 24(%r15)
        adcq	32(%r10), %rcx
        movq	40(%r15), %r8
        movq	%rcx, 32(%r15)
        adcq	40(%r10), %r8
        movq	48(%r15), %rax
        movq	%r8, 40(%r15)
        adcq	48(%r10), %rax
        movq	56(%r15), %rcx
        movq	%rax, 48(%r15)
        adcq	56(%r10), %rcx
        movq	64(%r15), %r8
        movq	%rcx, 56(%r15)
        adcq	64(%r10), %r8
        movq	72(%r15), %rax
        movq	%r8, 64(%r15)
        adcq	72(%r10), %rax
        movq	80(%r15), %rcx
        movq	%rax, 72(%r15)
        adcq	80(%r10), %rcx
        movq	88(%r15), %r8
        movq	%rcx, 80(%r15)
        adcq	88(%r10), %r8
        movq	96(%r15), %rax
        movq	%r8, 88(%r15)
        adcq	96(%r10), %rax
        movq	104(%r15), %rcx
        movq	%rax, 96(%r15)
        adcq	104(%r10), %rcx
        movq	112(%r15), %r8
        movq	%rcx, 104(%r15)
        adcq	112(%r10), %r8
        movq	120(%r15), %rax
        movq	%r8, 112(%r15)
        adcq	120(%r10), %rax
        movq	128(%r15), %rcx
        movq	%rax, 120(%r15)
        adcq	128(%r10), %rcx
        movq	136(%r15), %r8
        movq	%rcx, 128(%r15)
        adcq	136(%r10), %r8
        movq	144(%r15), %rax
        movq	%r8, 136(%r15)
        adcq	144(%r10), %rax
        movq	152(%r15), %rcx
        movq	%rax, 144(%r15)
        adcq	152(%r10), %rcx
        movq	160(%r15), %r8
        movq	%rcx, 152(%r15)
        adcq	160(%r10), %r8
        movq	168(%r15), %rax
        movq	%r8, 160(%r15)
        adcq	168(%r10), %rax
        movq	176(%r15), %rcx
        movq	%rax, 168(%r15)
        adcq	176(%r10), %rcx
        movq	184(%r15), %r8
        movq	%rcx, 176(%r15)
        adcq	184(%r10), %r8
        movq	192(%r15), %rax
        movq	%r8, 184(%r15)
        adcq	192(%r10), %rax
        movq	200(%r15), %rcx
        movq	%rax, 192(%r15)
        adcq	200(%r10), %rcx
        movq	208(%r15), %r8
        movq	%rcx, 200(%r15)
        adcq	208(%r10), %r8
        movq	216(%r15), %rax
        movq	%r8, 208(%r15)
        adcq	216(%r10), %rax
        movq	224(%r15), %rcx
        movq	%rax, 216(%r15)
        adcq	224(%r10), %rcx
        movq	232(%r15), %r8
        movq	%rcx, 224(%r15)
        adcq	232(%r10), %r8
        movq	240(%r15), %rax
        movq	%r8, 232(%r15)
        adcq	240(%r10), %rax
        movq	248(%r15), %rcx
        movq	%rax, 240(%r15)
        adcq	248(%r10), %rcx
        movq	%rcx, 248(%r15)
        adcq	$0x00, %r9
        movq	%r9, 384(%rdi)
        addq	$0x80, %r15
        # Add
        movq	(%r15), %rax
        addq	(%r11), %rax
        movq	8(%r15), %rcx
        movq	%rax, (%r15)
        adcq	8(%r11), %rcx
        movq	16(%r15), %r8
        movq	%rcx, 8(%r15)
        adcq	16(%r11), %r8
        movq	24(%r15), %rax
        movq	%r8, 16(%r15)
        adcq	24(%r11), %rax
        movq	32(%r15), %rcx
        movq	%rax, 24(%r15)
        adcq	32(%r11), %rcx
        movq	40(%r15), %r8
        movq	%rcx, 32(%r15)
        adcq	40(%r11), %r8
        movq	48(%r15), %rax
        movq	%r8, 40(%r15)
        adcq	48(%r11), %rax
        movq	56(%r15), %rcx
        movq	%rax, 48(%r15)
        adcq	56(%r11), %rcx
        movq	64(%r15), %r8
        movq	%rcx, 56(%r15)
        adcq	64(%r11), %r8
        movq	72(%r15), %rax
        movq	%r8, 64(%r15)
        adcq	72(%r11), %rax
        movq	80(%r15), %rcx
        movq	%rax, 72(%r15)
        adcq	80(%r11), %rcx
        movq	88(%r15), %r8
        movq	%rcx, 80(%r15)
        adcq	88(%r11), %r8
        movq	96(%r15), %rax
        movq	%r8, 88(%r15)
        adcq	96(%r11), %rax
        movq	104(%r15), %rcx
        movq	%rax, 96(%r15)
        adcq	104(%r11), %rcx
        movq	112(%r15), %r8
        movq	%rcx, 104(%r15)
        adcq	112(%r11), %r8
        movq	120(%r15), %rax
        movq	%r8, 112(%r15)
        adcq	120(%r11), %rax
        movq	128(%r15), %rcx
        movq	%rax, 120(%r15)
        adcq	128(%r11), %rcx
        movq	%rcx, 128(%r15)
        # Add to zero
        movq	136(%r11), %rax
        adcq	$0x00, %rax
        movq	144(%r11), %rcx
        movq	%rax, 136(%r15)
        adcq	$0x00, %rcx
        movq	152(%r11), %r8
        movq	%rcx, 144(%r15)
        adcq	$0x00, %r8
        movq	160(%r11), %rax
        movq	%r8, 152(%r15)
        adcq	$0x00, %rax
        movq	168(%r11), %rcx
        movq	%rax, 160(%r15)
        adcq	$0x00, %rcx
        movq	176(%r11), %r8
        movq	%rcx, 168(%r15)
        adcq	$0x00, %r8
        movq	184(%r11), %rax
        movq	%r8, 176(%r15)
        adcq	$0x00, %rax
        movq	192(%r11), %rcx
        movq	%rax, 184(%r15)
        adcq	$0x00, %rcx
        movq	200(%r11), %r8
        movq	%rcx, 192(%r15)
        adcq	$0x00, %r8
        movq	208(%r11), %rax
        movq	%r8, 200(%r15)
        adcq	$0x00, %rax
        movq	216(%r11), %rcx
        movq	%rax, 208(%r15)
        adcq	$0x00, %rcx
        movq	224(%r11), %r8
        movq	%rcx, 216(%r15)
        adcq	$0x00, %r8
        movq	232(%r11), %rax
        movq	%r8, 224(%r15)
        adcq	$0x00, %rax
        movq	240(%r11), %rcx
        movq	%rax, 232(%r15)
        adcq	$0x00, %rcx
        movq	248(%r11), %r8
        movq	%rcx, 240(%r15)
        adcq	$0x00, %r8
        movq	%r8, 248(%r15)
        addq	$0x328, %rsp
        popq	%r15
        popq	%r14
        popq	%r13
        popq	%r12
        repz retq
#ifndef __APPLE__
.size	sp_2048_mul_avx2_32,.-sp_2048_mul_avx2_32
#endif /* __APPLE__ */
#endif /* HAVE_INTEL_AVX2 */
/* Square a and put result in r. (r = a * a)
 *
 * r  A single precision integer.
 * a  A single precision integer.
 */
#ifndef __APPLE__
.text
.globl	sp_2048_sqr_16
.type	sp_2048_sqr_16,@function
.align	16
sp_2048_sqr_16:
#else
.section	__TEXT,__text
.globl	_sp_2048_sqr_16
.p2align	4
_sp_2048_sqr_16:
#endif /* __APPLE__ */
        pushq	%r12
        subq	$0x80, %rsp
        # A[0] * A[0]
        movq	(%rsi), %rax
        mulq	%rax
        xorq	%r9, %r9
        movq	%rax, (%rsp)
        movq	%rdx, %r8
        # A[0] * A[1]
        movq	8(%rsi), %rax
        mulq	(%rsi)
        xorq	%rcx, %rcx
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0x00, %rcx
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0x00, %rcx
        movq	%r8, 8(%rsp)
        # A[0] * A[2]
        movq	16(%rsi), %rax
        mulq	(%rsi)
        xorq	%r8, %r8
        addq	%rax, %r9
        adcq	%rdx, %rcx
        adcq	$0x00, %r8
        addq	%rax, %r9
        adcq	%rdx, %rcx
        adcq	$0x00, %r8
        # A[1] * A[1]
        movq	8(%rsi), %rax
        mulq	%rax
        addq	%rax, %r9
        adcq	%rdx, %rcx
        adcq	$0x00, %r8
        movq	%r9, 16(%rsp)
        # A[0] * A[3]
        movq	24(%rsi), %rax
        mulq	(%rsi)
        xorq	%r9, %r9
        addq	%rax, %rcx
        adcq	%rdx, %r8
        adcq	$0x00, %r9
        addq	%rax, %rcx
        adcq	%rdx, %r8
        adcq	$0x00, %r9
        # A[1] * A[2]
        movq	16(%rsi), %rax
        mulq	8(%rsi)
        addq	%rax, %rcx
        adcq	%rdx, %r8
        adcq	$0x00, %r9
        addq	%rax, %rcx
        adcq	%rdx, %r8
        adcq	$0x00, %r9
        movq	%rcx, 24(%rsp)
        # A[0] * A[4]
        movq	32(%rsi), %rax
        mulq	(%rsi)
        xorq	%rcx, %rcx
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0x00, %rcx
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0x00, %rcx
        # A[1] * A[3]
        movq	24(%rsi), %rax
        mulq	8(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0x00, %rcx
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0x00, %rcx
        # A[2] * A[2]
        movq	16(%rsi), %rax
        mulq	%rax
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0x00, %rcx
        movq	%r8, 32(%rsp)
        # A[0] * A[5]
        movq	40(%rsi), %rax
        mulq	(%rsi)
        xorq	%r8, %r8
        xorq	%r12, %r12
        movq	%rax, %r10
        movq	%rdx, %r11
        # A[1] * A[4]
        movq	32(%rsi), %rax
        mulq	8(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0x00, %r12
        # A[2] * A[3]
        movq	24(%rsi), %rax
        mulq	16(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0x00, %r12
        addq	%r10, %r10
        adcq	%r11, %r11
        adcq	%r12, %r12
        addq	%r10, %r9
        adcq	%r11, %rcx
        adcq	%r12, %r8
        movq	%r9, 40(%rsp)
        # A[0] * A[6]
        movq	48(%rsi), %rax
        mulq	(%rsi)
        xorq	%r9, %r9
        xorq	%r12, %r12
        movq	%rax, %r10
        movq	%rdx, %r11
        # A[1] * A[5]
        movq	40(%rsi), %rax
        mulq	8(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0x00, %r12
        # A[2] * A[4]
        movq	32(%rsi), %rax
        mulq	16(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0x00, %r12
        # A[3] * A[3]
        movq	24(%rsi), %rax
        mulq	%rax
        addq	%r10, %r10
        adcq	%r11, %r11
        adcq	%r12, %r12
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0x00, %r12
        addq	%r10, %rcx
        adcq	%r11, %r8
        adcq	%r12, %r9
        movq	%rcx, 48(%rsp)
        # A[0] * A[7]
        movq	56(%rsi), %rax
        mulq	(%rsi)
        xorq	%rcx, %rcx
        xorq	%r12, %r12
        movq	%rax, %r10
        movq	%rdx, %r11
        # A[1] * A[6]
        movq	48(%rsi), %rax
        mulq	8(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0x00, %r12
        # A[2] * A[5]
        movq	40(%rsi), %rax
        mulq	16(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0x00, %r12
        # A[3] * A[4]
        movq	32(%rsi), %rax
        mulq	24(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0x00, %r12
        addq	%r10, %r10
        adcq	%r11, %r11
        adcq	%r12, %r12
        addq	%r10, %r8
        adcq	%r11, %r9
        adcq	%r12, %rcx
        movq	%r8, 56(%rsp)
        # A[0] * A[8]
        movq	64(%rsi), %rax
        mulq	(%rsi)
        xorq	%r8, %r8
        xorq	%r12, %r12
        movq	%rax, %r10
        movq	%rdx, %r11
        # A[1] * A[7]
        movq	56(%rsi), %rax
        mulq	8(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0x00, %r12
        # A[2] * A[6]
        movq	48(%rsi), %rax
        mulq	16(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0x00, %r12
        # A[3] * A[5]
        movq	40(%rsi), %rax
        mulq	24(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0x00, %r12
        # A[4] * A[4]
        movq	32(%rsi), %rax
        mulq	%rax
        addq	%r10, %r10
        adcq	%r11, %r11
        adcq	%r12, %r12
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0x00, %r12
        addq	%r10, %r9
        adcq	%r11, %rcx
        adcq	%r12, %r8
        movq	%r9, 64(%rsp)
        # A[0] * A[9]
        movq	72(%rsi), %rax
        mulq	(%rsi)
        xorq	%r9, %r9
        xorq	%r12, %r12
        movq	%rax, %r10
        movq	%rdx, %r11
        # A[1] * A[8]
        movq	64(%rsi), %rax
        mulq	8(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0x00, %r12
        # A[2] * A[7]
        movq	56(%rsi), %rax
        mulq	16(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0x00, %r12
        # A[3] * A[6]
        movq	48(%rsi), %rax
        mulq	24(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0x00, %r12
        # A[4] * A[5]
        movq	40(%rsi), %rax
        mulq	32(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0x00, %r12
        addq	%r10, %r10
        adcq	%r11, %r11
        adcq	%r12, %r12
        addq	%r10, %rcx
        adcq	%r11, %r8
        adcq	%r12, %r9
        movq	%rcx, 72(%rsp)
        # A[0] * A[10]
        movq	80(%rsi), %rax
        mulq	(%rsi)
        xorq	%rcx, %rcx
        xorq	%r12, %r12
        movq	%rax, %r10
        movq	%rdx, %r11
        # A[1] * A[9]
        movq	72(%rsi), %rax
        mulq	8(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0x00, %r12
        # A[2] * A[8]
        movq	64(%rsi), %rax
        mulq	16(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0x00, %r12
        # A[3] * A[7]
        movq	56(%rsi), %rax
        mulq	24(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0x00, %r12
        # A[4] * A[6]
        movq	48(%rsi), %rax
        mulq	32(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0x00, %r12
        # A[5] * A[5]
        movq	40(%rsi), %rax
        mulq	%rax
        addq	%r10, %r10
        adcq	%r11, %r11
        adcq	%r12, %r12
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0x00, %r12
        addq	%r10, %r8
        adcq	%r11, %r9
        adcq	%r12, %rcx
        movq	%r8, 80(%rsp)
        # A[0] * A[11]
        movq	88(%rsi), %rax
        mulq	(%rsi)
        xorq	%r8, %r8
        xorq	%r12, %r12
        movq	%rax, %r10
        movq	%rdx, %r11
        # A[1] * A[10]
        movq	80(%rsi), %rax
        mulq	8(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0x00, %r12
        # A[2] * A[9]
        movq	72(%rsi), %rax
        mulq	16(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0x00, %r12
        # A[3] * A[8]
        movq	64(%rsi), %rax
        mulq	24(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0x00, %r12
        # A[4] * A[7]
        movq	56(%rsi), %rax
        mulq	32(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0x00, %r12
        # A[5] * A[6]
        movq	48(%rsi), %rax
        mulq	40(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0x00, %r12
        addq	%r10, %r10
        adcq	%r11, %r11
        adcq	%r12, %r12
        addq	%r10, %r9
        adcq	%r11, %rcx
        adcq	%r12, %r8
        movq	%r9, 88(%rsp)
        # A[0] * A[12]
        movq	96(%rsi), %rax
        mulq	(%rsi)
        xorq	%r9, %r9
        xorq	%r12, %r12
        movq	%rax, %r10
        movq	%rdx, %r11
        # A[1] * A[11]
        movq	88(%rsi), %rax
        mulq	8(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0x00, %r12
        # A[2] * A[10]
        movq	80(%rsi), %rax
        mulq	16(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0x00, %r12
        # A[3] * A[9]
        movq	72(%rsi), %rax
        mulq	24(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0x00, %r12
        # A[4] * A[8]
        movq	64(%rsi), %rax
        mulq	32(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0x00, %r12
        # A[5] * A[7]
        movq	56(%rsi), %rax
        mulq	40(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0x00, %r12
        # A[6] * A[6]
        movq	48(%rsi), %rax
        mulq	%rax
        addq	%r10, %r10
        adcq	%r11, %r11
        adcq	%r12, %r12
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0x00, %r12
        addq	%r10, %rcx
        adcq	%r11, %r8
        adcq	%r12, %r9
        movq	%rcx, 96(%rsp)
        # A[0] * A[13]
        movq	104(%rsi), %rax
        mulq	(%rsi)
        xorq	%rcx, %rcx
        xorq	%r12, %r12
        movq	%rax, %r10
        movq	%rdx, %r11
        # A[1] * A[12]
        movq	96(%rsi), %rax
        mulq	8(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0x00, %r12
        # A[2] * A[11]
        movq	88(%rsi), %rax
        mulq	16(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0x00, %r12
        # A[3] * A[10]
        movq	80(%rsi), %rax
        mulq	24(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0x00, %r12
        # A[4] * A[9]
        movq	72(%rsi), %rax
        mulq	32(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0x00, %r12
        # A[5] * A[8]
        movq	64(%rsi), %rax
        mulq	40(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0x00, %r12
        # A[6] * A[7]
        movq	56(%rsi), %rax
        mulq	48(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0x00, %r12
        addq	%r10, %r10
        adcq	%r11, %r11
        adcq	%r12, %r12
        addq	%r10, %r8
        adcq	%r11, %r9
        adcq	%r12, %rcx
        movq	%r8, 104(%rsp)
        # A[0] * A[14]
        movq	112(%rsi), %rax
        mulq	(%rsi)
        xorq	%r8, %r8
        xorq	%r12, %r12
        movq	%rax, %r10
        movq	%rdx, %r11
        # A[1] * A[13]
        movq	104(%rsi), %rax
        mulq	8(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0x00, %r12
        # A[2] * A[12]
        movq	96(%rsi), %rax
        mulq	16(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0x00, %r12
        # A[3] * A[11]
        movq	88(%rsi), %rax
        mulq	24(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0x00, %r12
        # A[4] * A[10]
        movq	80(%rsi), %rax
        mulq	32(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0x00, %r12
        # A[5] * A[9]
        movq	72(%rsi), %rax
        mulq	40(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0x00, %r12
        # A[6] * A[8]
        movq	64(%rsi), %rax
        mulq	48(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0x00, %r12
        # A[7] * A[7]
        movq	56(%rsi), %rax
        mulq	%rax
        addq	%r10, %r10
        adcq	%r11, %r11
        adcq	%r12, %r12
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0x00, %r12
        addq	%r10, %r9
        adcq	%r11, %rcx
        adcq	%r12, %r8
        movq	%r9, 112(%rsp)
        # A[0] * A[15]
        movq	120(%rsi), %rax
        mulq	(%rsi)
        xorq	%r9, %r9
        xorq	%r12, %r12
        movq	%rax, %r10
        movq	%rdx, %r11
        # A[1] * A[14]
        movq	112(%rsi), %rax
        mulq	8(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0x00, %r12
        # A[2] * A[13]
        movq	104(%rsi), %rax
        mulq	16(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0x00, %r12
        # A[3] * A[12]
        movq	96(%rsi), %rax
        mulq	24(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0x00, %r12
        # A[4] * A[11]
        movq	88(%rsi), %rax
        mulq	32(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0x00, %r12
        # A[5] * A[10]
        movq	80(%rsi), %rax
        mulq	40(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0x00, %r12
        # A[6] * A[9]
        movq	72(%rsi), %rax
        mulq	48(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0x00, %r12
        # A[7] * A[8]
        movq	64(%rsi), %rax
        mulq	56(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0x00, %r12
        addq	%r10, %r10
        adcq	%r11, %r11
        adcq	%r12, %r12
        addq	%r10, %rcx
        adcq	%r11, %r8
        adcq	%r12, %r9
        movq	%rcx, 120(%rsp)
        # A[1] * A[15]
        movq	120(%rsi), %rax
        mulq	8(%rsi)
        xorq	%rcx, %rcx
        xorq	%r12, %r12
        movq	%rax, %r10
        movq	%rdx, %r11
        # A[2] * A[14]
        movq	112(%rsi), %rax
        mulq	16(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0x00, %r12
        # A[3] * A[13]
        movq	104(%rsi), %rax
        mulq	24(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0x00, %r12
        # A[4] * A[12]
        movq	96(%rsi), %rax
        mulq	32(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0x00, %r12
        # A[5] * A[11]
        movq	88(%rsi), %rax
        mulq	40(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0x00, %r12
        # A[6] * A[10]
        movq	80(%rsi), %rax
        mulq	48(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0x00, %r12
        # A[7] * A[9]
        movq	72(%rsi), %rax
        mulq	56(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0x00, %r12
        # A[8] * A[8]
        movq	64(%rsi), %rax
        mulq	%rax
        addq	%r10, %r10
        adcq	%r11, %r11
        adcq	%r12, %r12
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0x00, %r12
        addq	%r10, %r8
        adcq	%r11, %r9
        adcq	%r12, %rcx
        movq	%r8, 128(%rdi)
        # A[2] * A[15]
        movq	120(%rsi), %rax
        mulq	16(%rsi)
        xorq	%r8, %r8
        xorq	%r12, %r12
        movq	%rax, %r10
        movq	%rdx, %r11
        # A[3] * A[14]
        movq	112(%rsi), %rax
        mulq	24(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0x00, %r12
        # A[4] * A[13]
        movq	104(%rsi), %rax
        mulq	32(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0x00, %r12
        # A[5] * A[12]
        movq	96(%rsi), %rax
        mulq	40(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0x00, %r12
        # A[6] * A[11]
        movq	88(%rsi), %rax
        mulq	48(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0x00, %r12
        # A[7] * A[10]
        movq	80(%rsi), %rax
        mulq	56(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0x00, %r12
        # A[8] * A[9]
        movq	72(%rsi), %rax
        mulq	64(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0x00, %r12
        addq	%r10, %r10
        adcq	%r11, %r11
        adcq	%r12, %r12
        addq	%r10, %r9
        adcq	%r11, %rcx
        adcq	%r12, %r8
        movq	%r9, 136(%rdi)
        # A[3] * A[15]
        movq	120(%rsi), %rax
        mulq	24(%rsi)
        xorq	%r9, %r9
        xorq	%r12, %r12
        movq	%rax, %r10
        movq	%rdx, %r11
        # A[4] * A[14]
        movq	112(%rsi), %rax
        mulq	32(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0x00, %r12
        # A[5] * A[13]
        movq	104(%rsi), %rax
        mulq	40(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0x00, %r12
        # A[6] * A[12]
        movq	96(%rsi), %rax
        mulq	48(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0x00, %r12
        # A[7] * A[11]
        movq	88(%rsi), %rax
        mulq	56(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0x00, %r12
        # A[8] * A[10]
        movq	80(%rsi), %rax
        mulq	64(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0x00, %r12
        # A[9] * A[9]
        movq	72(%rsi), %rax
        mulq	%rax
        addq	%r10, %r10
        adcq	%r11, %r11
        adcq	%r12, %r12
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0x00, %r12
        addq	%r10, %rcx
        adcq	%r11, %r8
        adcq	%r12, %r9
        movq	%rcx, 144(%rdi)
        # A[4] * A[15]
        movq	120(%rsi), %rax
        mulq	32(%rsi)
        xorq	%rcx, %rcx
        xorq	%r12, %r12
        movq	%rax, %r10
        movq	%rdx, %r11
        # A[5] * A[14]
        movq	112(%rsi), %rax
        mulq	40(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0x00, %r12
        # A[6] * A[13]
        movq	104(%rsi), %rax
        mulq	48(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0x00, %r12
        # A[7] * A[12]
        movq	96(%rsi), %rax
        mulq	56(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0x00, %r12
        # A[8] * A[11]
        movq	88(%rsi), %rax
        mulq	64(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0x00, %r12
        # A[9] * A[10]
        movq	80(%rsi), %rax
        mulq	72(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0x00, %r12
        addq	%r10, %r10
        adcq	%r11, %r11
        adcq	%r12, %r12
        addq	%r10, %r8
        adcq	%r11, %r9
        adcq	%r12, %rcx
        movq	%r8, 152(%rdi)
        # A[5] * A[15]
        movq	120(%rsi), %rax
        mulq	40(%rsi)
        xorq	%r8, %r8
        xorq	%r12, %r12
        movq	%rax, %r10
        movq	%rdx, %r11
        # A[6] * A[14]
        movq	112(%rsi), %rax
        mulq	48(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0x00, %r12
        # A[7] * A[13]
        movq	104(%rsi), %rax
        mulq	56(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0x00, %r12
        # A[8] * A[12]
        movq	96(%rsi), %rax
        mulq	64(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0x00, %r12
        # A[9] * A[11]
        movq	88(%rsi), %rax
        mulq	72(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0x00, %r12
        # A[10] * A[10]
        movq	80(%rsi), %rax
        mulq	%rax
        addq	%r10, %r10
        adcq	%r11, %r11
        adcq	%r12, %r12
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0x00, %r12
        addq	%r10, %r9
        adcq	%r11, %rcx
        adcq	%r12, %r8
        movq	%r9, 160(%rdi)
        # A[6] * A[15]
        movq	120(%rsi), %rax
        mulq	48(%rsi)
        xorq	%r9, %r9
        xorq	%r12, %r12
        movq	%rax, %r10
        movq	%rdx, %r11
        # A[7] * A[14]
        movq	112(%rsi), %rax
        mulq	56(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0x00, %r12
        # A[8] * A[13]
        movq	104(%rsi), %rax
        mulq	64(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0x00, %r12
        # A[9] * A[12]
        movq	96(%rsi), %rax
        mulq	72(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0x00, %r12
        # A[10] * A[11]
        movq	88(%rsi), %rax
        mulq	80(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0x00, %r12
        addq	%r10, %r10
        adcq	%r11, %r11
        adcq	%r12, %r12
        addq	%r10, %rcx
        adcq	%r11, %r8
        adcq	%r12, %r9
        movq	%rcx, 168(%rdi)
        # A[7] * A[15]
        movq	120(%rsi), %rax
        mulq	56(%rsi)
        xorq	%rcx, %rcx
        xorq	%r12, %r12
        movq	%rax, %r10
        movq	%rdx, %r11
        # A[8] * A[14]
        movq	112(%rsi), %rax
        mulq	64(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0x00, %r12
        # A[9] * A[13]
        movq	104(%rsi), %rax
        mulq	72(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0x00, %r12
        # A[10] * A[12]
        movq	96(%rsi), %rax
        mulq	80(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0x00, %r12
        # A[11] * A[11]
        movq	88(%rsi), %rax
        mulq	%rax
        addq	%r10, %r10
        adcq	%r11, %r11
        adcq	%r12, %r12
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0x00, %r12
        addq	%r10, %r8
        adcq	%r11, %r9
        adcq	%r12, %rcx
        movq	%r8, 176(%rdi)
        # A[8] * A[15]
        movq	120(%rsi), %rax
        mulq	64(%rsi)
        xorq	%r8, %r8
        xorq	%r12, %r12
        movq	%rax, %r10
        movq	%rdx, %r11
        # A[9] * A[14]
        movq	112(%rsi), %rax
        mulq	72(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0x00, %r12
        # A[10] * A[13]
        movq	104(%rsi), %rax
        mulq	80(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0x00, %r12
        # A[11] * A[12]
        movq	96(%rsi), %rax
        mulq	88(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0x00, %r12
        addq	%r10, %r10
        adcq	%r11, %r11
        adcq	%r12, %r12
        addq	%r10, %r9
        adcq	%r11, %rcx
        adcq	%r12, %r8
        movq	%r9, 184(%rdi)
        # A[9] * A[15]
        movq	120(%rsi), %rax
        mulq	72(%rsi)
        xorq	%r9, %r9
        xorq	%r12, %r12
        movq	%rax, %r10
        movq	%rdx, %r11
        # A[10] * A[14]
        movq	112(%rsi), %rax
        mulq	80(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0x00, %r12
        # A[11] * A[13]
        movq	104(%rsi), %rax
        mulq	88(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0x00, %r12
        # A[12] * A[12]
        movq	96(%rsi), %rax
        mulq	%rax
        addq	%r10, %r10
        adcq	%r11, %r11
        adcq	%r12, %r12
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0x00, %r12
        addq	%r10, %rcx
        adcq	%r11, %r8
        adcq	%r12, %r9
        movq	%rcx, 192(%rdi)
        # A[10] * A[15]
        movq	120(%rsi), %rax
        mulq	80(%rsi)
        xorq	%rcx, %rcx
        xorq	%r12, %r12
        movq	%rax, %r10
        movq	%rdx, %r11
        # A[11] * A[14]
        movq	112(%rsi), %rax
        mulq	88(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0x00, %r12
        # A[12] * A[13]
        movq	104(%rsi), %rax
        mulq	96(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0x00, %r12
        addq	%r10, %r10
        adcq	%r11, %r11
        adcq	%r12, %r12
        addq	%r10, %r8
        adcq	%r11, %r9
        adcq	%r12, %rcx
        movq	%r8, 200(%rdi)
        # A[11] * A[15]
        movq	120(%rsi), %rax
        mulq	88(%rsi)
        xorq	%r8, %r8
        addq	%rax, %r9
        adcq	%rdx, %rcx
        adcq	$0x00, %r8
        addq	%rax, %r9
        adcq	%rdx, %rcx
        adcq	$0x00, %r8
        # A[12] * A[14]
        movq	112(%rsi), %rax
        mulq	96(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %rcx
        adcq	$0x00, %r8
        addq	%rax, %r9
        adcq	%rdx, %rcx
        adcq	$0x00, %r8
        # A[13] * A[13]
        movq	104(%rsi), %rax
        mulq	%rax
        addq	%rax, %r9
        adcq	%rdx, %rcx
        adcq	$0x00, %r8
        movq	%r9, 208(%rdi)
        # A[12] * A[15]
        movq	120(%rsi), %rax
        mulq	96(%rsi)
        xorq	%r9, %r9
        addq	%rax, %rcx
        adcq	%rdx, %r8
        adcq	$0x00, %r9
        addq	%rax, %rcx
        adcq	%rdx, %r8
        adcq	$0x00, %r9
        # A[13] * A[14]
        movq	112(%rsi), %rax
        mulq	104(%rsi)
        addq	%rax, %rcx
        adcq	%rdx, %r8
        adcq	$0x00, %r9
        addq	%rax, %rcx
        adcq	%rdx, %r8
        adcq	$0x00, %r9
        movq	%rcx, 216(%rdi)
        # A[13] * A[15]
        movq	120(%rsi), %rax
        mulq	104(%rsi)
        xorq	%rcx, %rcx
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0x00, %rcx
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0x00, %rcx
        # A[14] * A[14]
        movq	112(%rsi), %rax
        mulq	%rax
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0x00, %rcx
        movq	%r8, 224(%rdi)
        # A[14] * A[15]
        movq	120(%rsi), %rax
        mulq	112(%rsi)
        xorq	%r8, %r8
        addq	%rax, %r9
        adcq	%rdx, %rcx
        adcq	$0x00, %r8
        addq	%rax, %r9
        adcq	%rdx, %rcx
        adcq	$0x00, %r8
        movq	%r9, 232(%rdi)
        # A[15] * A[15]
        movq	120(%rsi), %rax
        mulq	%rax
        addq	%rax, %rcx
        adcq	%rdx, %r8
        movq	%rcx, 240(%rdi)
        movq	%r8, 248(%rdi)
        movq	(%rsp), %rax
        movq	8(%rsp), %rdx
        movq	16(%rsp), %r10
        movq	24(%rsp), %r11
        movq	%rax, (%rdi)
        movq	%rdx, 8(%rdi)
        movq	%r10, 16(%rdi)
        movq	%r11, 24(%rdi)
        movq	32(%rsp), %rax
        movq	40(%rsp), %rdx
        movq	48(%rsp), %r10
        movq	56(%rsp), %r11
        movq	%rax, 32(%rdi)
        movq	%rdx, 40(%rdi)
        movq	%r10, 48(%rdi)
        movq	%r11, 56(%rdi)
        movq	64(%rsp), %rax
        movq	72(%rsp), %rdx
        movq	80(%rsp), %r10
        movq	88(%rsp), %r11
        movq	%rax, 64(%rdi)
        movq	%rdx, 72(%rdi)
        movq	%r10, 80(%rdi)
        movq	%r11, 88(%rdi)
        movq	96(%rsp), %rax
        movq	104(%rsp), %rdx
        movq	112(%rsp), %r10
        movq	120(%rsp), %r11
        movq	%rax, 96(%rdi)
        movq	%rdx, 104(%rdi)
        movq	%r10, 112(%rdi)
        movq	%r11, 120(%rdi)
        addq	$0x80, %rsp
        popq	%r12
        repz retq
#ifndef __APPLE__
.size	sp_2048_sqr_16,.-sp_2048_sqr_16
#endif /* __APPLE__ */
#ifdef HAVE_INTEL_AVX2
/* Square a and put result in r. (r = a * a)
 *
 * r  A single precision integer.
 * a  A single precision integer.
 */
#ifndef __APPLE__
.text
.globl	sp_2048_sqr_avx2_16
.type	sp_2048_sqr_avx2_16,@function
.align	16
sp_2048_sqr_avx2_16:
#else
.section	__TEXT,__text
.globl	_sp_2048_sqr_avx2_16
.p2align	4
_sp_2048_sqr_avx2_16:
#endif /* __APPLE__ */
        pushq	%rbp
        pushq	%r12
        pushq	%r13
        pushq	%r14
        pushq	%r15
        pushq	%rbx
        subq	$0x80, %rsp
        cmpq	%rdi, %rsi
        movq	%rsp, %rbp
        cmovne	%rdi, %rbp
        addq	$0x80, %rdi
        xorq	%r11, %r11
        # Diagonal 1
        # Zero into %r9
        # Zero into %r10
        # A[1] x A[0]
        movq	(%rsi), %rdx
        mulxq	8(%rsi), %r8, %r9
        # A[2] x A[0]
        mulxq	16(%rsi), %rax, %r10
        adcxq	%rax, %r9
        adoxq	%r11, %r10
        movq	%r8, 8(%rbp)
        movq	%r9, 16(%rbp)
        # Zero into %r8
        # Zero into %r9
        # A[3] x A[0]
        mulxq	24(%rsi), %rax, %r8
        adcxq	%rax, %r10
        adoxq	%r11, %r8
        # A[4] x A[0]
        mulxq	32(%rsi), %rax, %r9
        adcxq	%rax, %r8
        adoxq	%r11, %r9
        movq	%r10, 24(%rbp)
        movq	%r8, 32(%rbp)
        # Zero into %r10
        # Zero into %r8
        # A[5] x A[0]
        mulxq	40(%rsi), %rax, %r10
        adcxq	%rax, %r9
        adoxq	%r11, %r10
        # A[6] x A[0]
        mulxq	48(%rsi), %rax, %r8
        adcxq	%rax, %r10
        adoxq	%r11, %r8
        movq	%r9, 40(%rbp)
        movq	%r10, 48(%rbp)
        # Zero into %r9
        # Zero into %r10
        # A[7] x A[0]
        mulxq	56(%rsi), %rax, %r9
        adcxq	%rax, %r8
        adoxq	%r11, %r9
        # A[8] x A[0]
        mulxq	64(%rsi), %rax, %r10
        adcxq	%rax, %r9
        adoxq	%r11, %r10
        movq	%r8, 56(%rbp)
        movq	%r9, 64(%rbp)
        # Zero into %r8
        # Zero into %r9
        # A[9] x A[0]
        mulxq	72(%rsi), %rax, %r8
        adcxq	%rax, %r10
        adoxq	%r11, %r8
        # A[10] x A[0]
        mulxq	80(%rsi), %rax, %r9
        adcxq	%rax, %r8
        adoxq	%r11, %r9
        movq	%r10, 72(%rbp)
        movq	%r8, 80(%rbp)
        # No load %r13 - %r10
        # A[11] x A[0]
        mulxq	88(%rsi), %rax, %r13
        adcxq	%rax, %r9
        adoxq	%r11, %r13
        # A[12] x A[0]
        mulxq	96(%rsi), %rax, %r14
        adcxq	%rax, %r13
        adoxq	%r11, %r14
        movq	%r9, 88(%rbp)
        # No store %r13 - %r10
        # No load %r15 - %r9
        # A[13] x A[0]
        mulxq	104(%rsi), %rax, %r15
        adcxq	%rax, %r14
        adoxq	%r11, %r15
        # A[14] x A[0]
        mulxq	112(%rsi), %rax, %rbx
        adcxq	%rax, %r15
        adoxq	%r11, %rbx
        # No store %r14 - %r8
        # No store %r15 - %r9
        # Zero into %r8
        # Zero into %r9
        # A[15] x A[0]
        mulxq	120(%rsi), %rax, %r8
        adcxq	%rax, %rbx
        adoxq	%r11, %r8
        # No store %rbx - %r10
        #  Carry
        adcxq	%r11, %r8
        movq	%r11, %r12
        adcxq	%r11, %r12
        adoxq	%r11, %r12
        movq	%r8, (%rdi)
        # Diagonal 2
        movq	24(%rbp), %r8
        movq	32(%rbp), %r9
        movq	40(%rbp), %r10
        # A[2] x A[1]
        movq	8(%rsi), %rdx
        mulxq	16(%rsi), %rax, %rcx
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        # A[3] x A[1]
        mulxq	24(%rsi), %rax, %rcx
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        movq	%r8, 24(%rbp)
        movq	%r9, 32(%rbp)
        movq	48(%rbp), %r8
        movq	56(%rbp), %r9
        # A[4] x A[1]
        mulxq	32(%rsi), %rax, %rcx
        adcxq	%rax, %r10
        adoxq	%rcx, %r8
        # A[5] x A[1]
        mulxq	40(%rsi), %rax, %rcx
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        movq	%r10, 40(%rbp)
        movq	%r8, 48(%rbp)
        movq	64(%rbp), %r10
        movq	72(%rbp), %r8
        # A[6] x A[1]
        mulxq	48(%rsi), %rax, %rcx
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        # A[7] x A[1]
        mulxq	56(%rsi), %rax, %rcx
        adcxq	%rax, %r10
        adoxq	%rcx, %r8
        movq	%r9, 56(%rbp)
        movq	%r10, 64(%rbp)
        movq	80(%rbp), %r9
        movq	88(%rbp), %r10
        # A[8] x A[1]
        mulxq	64(%rsi), %rax, %rcx
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        # A[9] x A[1]
        mulxq	72(%rsi), %rax, %rcx
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        movq	%r8, 72(%rbp)
        movq	%r9, 80(%rbp)
        # No load %r13 - %r8
        # A[10] x A[1]
        mulxq	80(%rsi), %rax, %rcx
        adcxq	%rax, %r10
        adoxq	%rcx, %r13
        # A[11] x A[1]
        mulxq	88(%rsi), %rax, %rcx
        adcxq	%rax, %r13
        adoxq	%rcx, %r14
        movq	%r10, 88(%rbp)
        # No store %r13 - %r8
        # No load %r15 - %r10
        # A[12] x A[1]
        mulxq	96(%rsi), %rax, %rcx
        adcxq	%rax, %r14
        adoxq	%rcx, %r15
        # A[13] x A[1]
        mulxq	104(%rsi), %rax, %rcx
        adcxq	%rax, %r15
        adoxq	%rcx, %rbx
        # No store %r14 - %r9
        # No store %r15 - %r10
        movq	(%rdi), %r9
        # Zero into %r10
        # A[14] x A[1]
        mulxq	112(%rsi), %rax, %rcx
        adcxq	%rax, %rbx
        adoxq	%rcx, %r9
        # A[15] x A[1]
        mulxq	120(%rsi), %rax, %r10
        adcxq	%rax, %r9
        adoxq	%r11, %r10
        # No store %rbx - %r8
        movq	%r9, (%rdi)
        # Zero into %r8
        # Zero into %r9
        # A[15] x A[2]
        movq	16(%rsi), %rdx
        mulxq	120(%rsi), %rax, %r8
        adcxq	%rax, %r10
        adoxq	%r11, %r8
        movq	%r10, 8(%rdi)
        #  Carry
        adcxq	%r12, %r8
        movq	%r11, %r12
        adcxq	%r11, %r12
        adoxq	%r11, %r12
        movq	%r8, 16(%rdi)
        # Diagonal 3
        movq	40(%rbp), %r8
        movq	48(%rbp), %r9
        movq	56(%rbp), %r10
        # A[3] x A[2]
        mulxq	24(%rsi), %rax, %rcx
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        # A[4] x A[2]
        mulxq	32(%rsi), %rax, %rcx
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        movq	%r8, 40(%rbp)
        movq	%r9, 48(%rbp)
        movq	64(%rbp), %r8
        movq	72(%rbp), %r9
        # A[5] x A[2]
        mulxq	40(%rsi), %rax, %rcx
        adcxq	%rax, %r10
        adoxq	%rcx, %r8
        # A[6] x A[2]
        mulxq	48(%rsi), %rax, %rcx
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        movq	%r10, 56(%rbp)
        movq	%r8, 64(%rbp)
        movq	80(%rbp), %r10
        movq	88(%rbp), %r8
        # A[7] x A[2]
        mulxq	56(%rsi), %rax, %rcx
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        # A[8] x A[2]
        mulxq	64(%rsi), %rax, %rcx
        adcxq	%rax, %r10
        adoxq	%rcx, %r8
        movq	%r9, 72(%rbp)
        movq	%r10, 80(%rbp)
        # No load %r13 - %r9
        # A[9] x A[2]
        mulxq	72(%rsi), %rax, %rcx
        adcxq	%rax, %r8
        adoxq	%rcx, %r13
        # A[10] x A[2]
        mulxq	80(%rsi), %rax, %rcx
        adcxq	%rax, %r13
        adoxq	%rcx, %r14
        movq	%r8, 88(%rbp)
        # No store %r13 - %r9
        # No load %r15 - %r8
        # A[11] x A[2]
        mulxq	88(%rsi), %rax, %rcx
        adcxq	%rax, %r14
        adoxq	%rcx, %r15
        # A[12] x A[2]
        mulxq	96(%rsi), %rax, %rcx
        adcxq	%rax, %r15
        adoxq	%rcx, %rbx
        # No store %r14 - %r10
        # No store %r15 - %r8
        movq	(%rdi), %r10
        movq	8(%rdi), %r8
        # A[13] x A[2]
        mulxq	104(%rsi), %rax, %rcx
        adcxq	%rax, %rbx
        adoxq	%rcx, %r10
        # A[14] x A[2]
        mulxq	112(%rsi), %rax, %rcx
        adcxq	%rax, %r10
        adoxq	%rcx, %r8
        # No store %rbx - %r9
        movq	%r10, (%rdi)
        movq	16(%rdi), %r9
        # Zero into %r10
        # A[14] x A[3]
        movq	24(%rsi), %rdx
        mulxq	112(%rsi), %rax, %rcx
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        # A[14] x A[4]
        movq	32(%rsi), %rdx
        mulxq	112(%rsi), %rax, %r10
        adcxq	%rax, %r9
        adoxq	%r11, %r10
        movq	%r8, 8(%rdi)
        movq	%r9, 16(%rdi)
        # Zero into %r8
        # Zero into %r9
        # A[14] x A[5]
        movq	40(%rsi), %rdx
        mulxq	112(%rsi), %rax, %r8
        adcxq	%rax, %r10
        adoxq	%r11, %r8
        movq	%r10, 24(%rdi)
        #  Carry
        adcxq	%r12, %r8
        movq	%r11, %r12
        adcxq	%r11, %r12
        adoxq	%r11, %r12
        movq	%r8, 32(%rdi)
        # Diagonal 4
        movq	56(%rbp), %r8
        movq	64(%rbp), %r9
        movq	72(%rbp), %r10
        # A[4] x A[3]
        movq	24(%rsi), %rdx
        mulxq	32(%rsi), %rax, %rcx
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        # A[5] x A[3]
        mulxq	40(%rsi), %rax, %rcx
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        movq	%r8, 56(%rbp)
        movq	%r9, 64(%rbp)
        movq	80(%rbp), %r8
        movq	88(%rbp), %r9
        # A[6] x A[3]
        mulxq	48(%rsi), %rax, %rcx
        adcxq	%rax, %r10
        adoxq	%rcx, %r8
        # A[7] x A[3]
        mulxq	56(%rsi), %rax, %rcx
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        movq	%r10, 72(%rbp)
        movq	%r8, 80(%rbp)
        # No load %r13 - %r10
        # A[8] x A[3]
        mulxq	64(%rsi), %rax, %rcx
        adcxq	%rax, %r9
        adoxq	%rcx, %r13
        # A[9] x A[3]
        mulxq	72(%rsi), %rax, %rcx
        adcxq	%rax, %r13
        adoxq	%rcx, %r14
        movq	%r9, 88(%rbp)
        # No store %r13 - %r10
        # No load %r15 - %r9
        # A[10] x A[3]
        mulxq	80(%rsi), %rax, %rcx
        adcxq	%rax, %r14
        adoxq	%rcx, %r15
        # A[11] x A[3]
        mulxq	88(%rsi), %rax, %rcx
        adcxq	%rax, %r15
        adoxq	%rcx, %rbx
        # No store %r14 - %r8
        # No store %r15 - %r9
        movq	(%rdi), %r8
        movq	8(%rdi), %r9
        # A[12] x A[3]
        mulxq	96(%rsi), %rax, %rcx
        adcxq	%rax, %rbx
        adoxq	%rcx, %r8
        # A[13] x A[3]
        mulxq	104(%rsi), %rax, %rcx
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        # No store %rbx - %r10
        movq	%r8, (%rdi)
        movq	16(%rdi), %r10
        movq	24(%rdi), %r8
        # A[13] x A[4]
        movq	32(%rsi), %rdx
        mulxq	104(%rsi), %rax, %rcx
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        # A[13] x A[5]
        movq	40(%rsi), %rdx
        mulxq	104(%rsi), %rax, %rcx
        adcxq	%rax, %r10
        adoxq	%rcx, %r8
        movq	%r9, 8(%rdi)
        movq	%r10, 16(%rdi)
        movq	32(%rdi), %r9
        # Zero into %r10
        # A[13] x A[6]
        movq	48(%rsi), %rdx
        mulxq	104(%rsi), %rax, %rcx
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        # A[13] x A[7]
        movq	56(%rsi), %rdx
        mulxq	104(%rsi), %rax, %r10
        adcxq	%rax, %r9
        adoxq	%r11, %r10
        movq	%r8, 24(%rdi)
        movq	%r9, 32(%rdi)
        # Zero into %r8
        # Zero into %r9
        # A[13] x A[8]
        movq	64(%rsi), %rdx
        mulxq	104(%rsi), %rax, %r8
        adcxq	%rax, %r10
        adoxq	%r11, %r8
        movq	%r10, 40(%rdi)
        #  Carry
        adcxq	%r12, %r8
        movq	%r11, %r12
        adcxq	%r11, %r12
        adoxq	%r11, %r12
        movq	%r8, 48(%rdi)
        # Diagonal 5
        movq	72(%rbp), %r8
        movq	80(%rbp), %r9
        movq	88(%rbp), %r10
        # A[5] x A[4]
        movq	32(%rsi), %rdx
        mulxq	40(%rsi), %rax, %rcx
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        # A[6] x A[4]
        mulxq	48(%rsi), %rax, %rcx
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        movq	%r8, 72(%rbp)
        movq	%r9, 80(%rbp)
        # No load %r13 - %r8
        # A[7] x A[4]
        mulxq	56(%rsi), %rax, %rcx
        adcxq	%rax, %r10
        adoxq	%rcx, %r13
        # A[8] x A[4]
        mulxq	64(%rsi), %rax, %rcx
        adcxq	%rax, %r13
        adoxq	%rcx, %r14
        movq	%r10, 88(%rbp)
        # No store %r13 - %r8
        # No load %r15 - %r10
        # A[9] x A[4]
        mulxq	72(%rsi), %rax, %rcx
        adcxq	%rax, %r14
        adoxq	%rcx, %r15
        # A[10] x A[4]
        mulxq	80(%rsi), %rax, %rcx
        adcxq	%rax, %r15
        adoxq	%rcx, %rbx
        # No store %r14 - %r9
        # No store %r15 - %r10
        movq	(%rdi), %r9
        movq	8(%rdi), %r10
        # A[11] x A[4]
        mulxq	88(%rsi), %rax, %rcx
        adcxq	%rax, %rbx
        adoxq	%rcx, %r9
        # A[12] x A[4]
        mulxq	96(%rsi), %rax, %rcx
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        # No store %rbx - %r8
        movq	%r9, (%rdi)
        movq	16(%rdi), %r8
        movq	24(%rdi), %r9
        # A[12] x A[5]
        movq	40(%rsi), %rdx
        mulxq	96(%rsi), %rax, %rcx
        adcxq	%rax, %r10
        adoxq	%rcx, %r8
        # A[12] x A[6]
        movq	48(%rsi), %rdx
        mulxq	96(%rsi), %rax, %rcx
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        movq	%r10, 8(%rdi)
        movq	%r8, 16(%rdi)
        movq	32(%rdi), %r10
        movq	40(%rdi), %r8
        # A[12] x A[7]
        movq	56(%rsi), %rdx
        mulxq	96(%rsi), %rax, %rcx
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        # A[12] x A[8]
        movq	64(%rsi), %rdx
        mulxq	96(%rsi), %rax, %rcx
        adcxq	%rax, %r10
        adoxq	%rcx, %r8
        movq	%r9, 24(%rdi)
        movq	%r10, 32(%rdi)
        movq	48(%rdi), %r9
        # Zero into %r10
        # A[12] x A[9]
        movq	72(%rsi), %rdx
        mulxq	96(%rsi), %rax, %rcx
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        # A[12] x A[10]
        movq	80(%rsi), %rdx
        mulxq	96(%rsi), %rax, %r10
        adcxq	%rax, %r9
        adoxq	%r11, %r10
        movq	%r8, 40(%rdi)
        movq	%r9, 48(%rdi)
        # Zero into %r8
        # Zero into %r9
        # A[12] x A[11]
        movq	88(%rsi), %rdx
        mulxq	96(%rsi), %rax, %r8
        adcxq	%rax, %r10
        adoxq	%r11, %r8
        movq	%r10, 56(%rdi)
        #  Carry
        adcxq	%r12, %r8
        movq	%r11, %r12
        adcxq	%r11, %r12
        adoxq	%r11, %r12
        movq	%r8, 64(%rdi)
        # Diagonal 6
        movq	88(%rbp), %r8
        # No load %r13 - %r9
        # A[6] x A[5]
        movq	40(%rsi), %rdx
        mulxq	48(%rsi), %rax, %rcx
        adcxq	%rax, %r8
        adoxq	%rcx, %r13
        # A[7] x A[5]
        mulxq	56(%rsi), %rax, %rcx
        adcxq	%rax, %r13
        adoxq	%rcx, %r14
        movq	%r8, 88(%rbp)
        # No store %r13 - %r9
        # No load %r15 - %r8
        # A[8] x A[5]
        mulxq	64(%rsi), %rax, %rcx
        adcxq	%rax, %r14
        adoxq	%rcx, %r15
        # A[9] x A[5]
        mulxq	72(%rsi), %rax, %rcx
        adcxq	%rax, %r15
        adoxq	%rcx, %rbx
        # No store %r14 - %r10
        # No store %r15 - %r8
        movq	(%rdi), %r10
        movq	8(%rdi), %r8
        # A[10] x A[5]
        mulxq	80(%rsi), %rax, %rcx
        adcxq	%rax, %rbx
        adoxq	%rcx, %r10
        # A[11] x A[5]
        mulxq	88(%rsi), %rax, %rcx
        adcxq	%rax, %r10
        adoxq	%rcx, %r8
        # No store %rbx - %r9
        movq	%r10, (%rdi)
        movq	16(%rdi), %r9
        movq	24(%rdi), %r10
        # A[11] x A[6]
        movq	48(%rsi), %rdx
        mulxq	88(%rsi), %rax, %rcx
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        # A[11] x A[7]
        movq	56(%rsi), %rdx
        mulxq	88(%rsi), %rax, %rcx
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        movq	%r8, 8(%rdi)
        movq	%r9, 16(%rdi)
        movq	32(%rdi), %r8
        movq	40(%rdi), %r9
        # A[11] x A[8]
        movq	64(%rsi), %rdx
        mulxq	88(%rsi), %rax, %rcx
        adcxq	%rax, %r10
        adoxq	%rcx, %r8
        # A[11] x A[9]
        movq	72(%rsi), %rdx
        mulxq	88(%rsi), %rax, %rcx
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        movq	%r10, 24(%rdi)
        movq	%r8, 32(%rdi)
        movq	48(%rdi), %r10
        movq	56(%rdi), %r8
        # A[11] x A[10]
        movq	80(%rsi), %rdx
        mulxq	88(%rsi), %rax, %rcx
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        # A[13] x A[9]
        movq	72(%rsi), %rdx
        mulxq	104(%rsi), %rax, %rcx
        adcxq	%rax, %r10
        adoxq	%rcx, %r8
        movq	%r9, 40(%rdi)
        movq	%r10, 48(%rdi)
        movq	64(%rdi), %r9
        # Zero into %r10
        # A[13] x A[10]
        movq	80(%rsi), %rdx
        mulxq	104(%rsi), %rax, %rcx
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        # A[13] x A[11]
        movq	88(%rsi), %rdx
        mulxq	104(%rsi), %rax, %r10
        adcxq	%rax, %r9
        adoxq	%r11, %r10
        movq	%r8, 56(%rdi)
        movq	%r9, 64(%rdi)
        # Zero into %r8
        # Zero into %r9
        # A[13] x A[12]
        movq	96(%rsi), %rdx
        mulxq	104(%rsi), %rax, %r8
        adcxq	%rax, %r10
        adoxq	%r11, %r8
        movq	%r10, 72(%rdi)
        #  Carry
        adcxq	%r12, %r8
        movq	%r11, %r12
        adcxq	%r11, %r12
        adoxq	%r11, %r12
        movq	%r8, 80(%rdi)
        # Diagonal 7
        # No load %r15 - %r9
        # A[7] x A[6]
        movq	48(%rsi), %rdx
        mulxq	56(%rsi), %rax, %rcx
        adcxq	%rax, %r14
        adoxq	%rcx, %r15
        # A[8] x A[6]
        mulxq	64(%rsi), %rax, %rcx
        adcxq	%rax, %r15
        adoxq	%rcx, %rbx
        # No store %r14 - %r8
        # No store %r15 - %r9
        movq	(%rdi), %r8
        movq	8(%rdi), %r9
        # A[9] x A[6]
        mulxq	72(%rsi), %rax, %rcx
        adcxq	%rax, %rbx
        adoxq	%rcx, %r8
        # A[10] x A[6]
        mulxq	80(%rsi), %rax, %rcx
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        # No store %rbx - %r10
        movq	%r8, (%rdi)
        movq	16(%rdi), %r10
        movq	24(%rdi), %r8
        # A[10] x A[7]
        movq	56(%rsi), %rdx
        mulxq	80(%rsi), %rax, %rcx
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        # A[10] x A[8]
        movq	64(%rsi), %rdx
        mulxq	80(%rsi), %rax, %rcx
        adcxq	%rax, %r10
        adoxq	%rcx, %r8
        movq	%r9, 8(%rdi)
        movq	%r10, 16(%rdi)
        movq	32(%rdi), %r9
        movq	40(%rdi), %r10
        # A[10] x A[9]
        movq	72(%rsi), %rdx
        mulxq	80(%rsi), %rax, %rcx
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        # A[14] x A[6]
        movq	48(%rsi), %rdx
        mulxq	112(%rsi), %rax, %rcx
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        movq	%r8, 24(%rdi)
        movq	%r9, 32(%rdi)
        movq	48(%rdi), %r8
        movq	56(%rdi), %r9
        # A[14] x A[7]
        movq	56(%rsi), %rdx
        mulxq	112(%rsi), %rax, %rcx
        adcxq	%rax, %r10
        adoxq	%rcx, %r8
        # A[14] x A[8]
        movq	64(%rsi), %rdx
        mulxq	112(%rsi), %rax, %rcx
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        movq	%r10, 40(%rdi)
        movq	%r8, 48(%rdi)
        movq	64(%rdi), %r10
        movq	72(%rdi), %r8
        # A[14] x A[9]
        movq	72(%rsi), %rdx
        mulxq	112(%rsi), %rax, %rcx
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        # A[14] x A[10]
        movq	80(%rsi), %rdx
        mulxq	112(%rsi), %rax, %rcx
        adcxq	%rax, %r10
        adoxq	%rcx, %r8
        movq	%r9, 56(%rdi)
        movq	%r10, 64(%rdi)
        movq	80(%rdi), %r9
        # Zero into %r10
        # A[14] x A[11]
        movq	88(%rsi), %rdx
        mulxq	112(%rsi), %rax, %rcx
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        # A[14] x A[12]
        movq	96(%rsi), %rdx
        mulxq	112(%rsi), %rax, %r10
        adcxq	%rax, %r9
        adoxq	%r11, %r10
        movq	%r8, 72(%rdi)
        movq	%r9, 80(%rdi)
        # Zero into %r8
        # Zero into %r9
        # A[14] x A[13]
        movq	104(%rsi), %rdx
        mulxq	112(%rsi), %rax, %r8
        adcxq	%rax, %r10
        adoxq	%r11, %r8
        movq	%r10, 88(%rdi)
        #  Carry
        adcxq	%r12, %r8
        movq	%r11, %r12
        adcxq	%r11, %r12
        adoxq	%r11, %r12
        movq	%r8, 96(%rdi)
        # Diagonal 8
        movq	(%rdi), %r9
        movq	8(%rdi), %r10
        # A[8] x A[7]
        movq	56(%rsi), %rdx
        mulxq	64(%rsi), %rax, %rcx
        adcxq	%rax, %rbx
        adoxq	%rcx, %r9
        # A[9] x A[7]
        mulxq	72(%rsi), %rax, %rcx
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        # No store %rbx - %r8
        movq	%r9, (%rdi)
        movq	16(%rdi), %r8
        movq	24(%rdi), %r9
        # A[9] x A[8]
        movq	64(%rsi), %rdx
        mulxq	72(%rsi), %rax, %rcx
        adcxq	%rax, %r10
        adoxq	%rcx, %r8
        # A[15] x A[3]
        movq	24(%rsi), %rdx
        mulxq	120(%rsi), %rax, %rcx
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        movq	%r10, 8(%rdi)
        movq	%r8, 16(%rdi)
        movq	32(%rdi), %r10
        movq	40(%rdi), %r8
        # A[15] x A[4]
        movq	32(%rsi), %rdx
        mulxq	120(%rsi), %rax, %rcx
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        # A[15] x A[5]
        movq	40(%rsi), %rdx
        mulxq	120(%rsi), %rax, %rcx
        adcxq	%rax, %r10
        adoxq	%rcx, %r8
        movq	%r9, 24(%rdi)
        movq	%r10, 32(%rdi)
        movq	48(%rdi), %r9
        movq	56(%rdi), %r10
        # A[15] x A[6]
        movq	48(%rsi), %rdx
        mulxq	120(%rsi), %rax, %rcx
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        # A[15] x A[7]
        movq	56(%rsi), %rdx
        mulxq	120(%rsi), %rax, %rcx
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        movq	%r8, 40(%rdi)
        movq	%r9, 48(%rdi)
        movq	64(%rdi), %r8
        movq	72(%rdi), %r9
        # A[15] x A[8]
        movq	64(%rsi), %rdx
        mulxq	120(%rsi), %rax, %rcx
        adcxq	%rax, %r10
        adoxq	%rcx, %r8
        # A[15] x A[9]
        movq	72(%rsi), %rdx
        mulxq	120(%rsi), %rax, %rcx
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        movq	%r10, 56(%rdi)
        movq	%r8, 64(%rdi)
        movq	80(%rdi), %r10
        movq	88(%rdi), %r8
        # A[15] x A[10]
        movq	80(%rsi), %rdx
        mulxq	120(%rsi), %rax, %rcx
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        # A[15] x A[11]
        movq	88(%rsi), %rdx
        mulxq	120(%rsi), %rax, %rcx
        adcxq	%rax, %r10
        adoxq	%rcx, %r8
        movq	%r9, 72(%rdi)
        movq	%r10, 80(%rdi)
        movq	96(%rdi), %r9
        # Zero into %r10
        # A[15] x A[12]
        movq	96(%rsi), %rdx
        mulxq	120(%rsi), %rax, %rcx
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        # A[15] x A[13]
        movq	104(%rsi), %rdx
        mulxq	120(%rsi), %rax, %r10
        adcxq	%rax, %r9
        adoxq	%r11, %r10
        movq	%r8, 88(%rdi)
        movq	%r9, 96(%rdi)
        # Zero into %r8
        # Zero into %r9
        # A[15] x A[14]
        movq	112(%rsi), %rdx
        mulxq	120(%rsi), %rax, %r8
        adcxq	%rax, %r10
        adoxq	%r11, %r8
        movq	%r10, 104(%rdi)
        #  Carry
        adcxq	%r12, %r8
        movq	%r11, %r12
        adcxq	%r11, %r12
        adoxq	%r11, %r12
        movq	%r8, 112(%rdi)
        movq	%r12, 120(%rdi)
        # Double and Add in A[i] x A[i]
        movq	8(%rbp), %r9
        # A[0] x A[0]
        movq	(%rsi), %rdx
        mulxq	%rdx, %rax, %rcx
        movq	%rax, (%rbp)
        adoxq	%r9, %r9
        adcxq	%rcx, %r9
        movq	%r9, 8(%rbp)
        movq	16(%rbp), %r8
        movq	24(%rbp), %r9
        # A[1] x A[1]
        movq	8(%rsi), %rdx
        mulxq	%rdx, %rax, %rcx
        adoxq	%r8, %r8
        adoxq	%r9, %r9
        adcxq	%rax, %r8
        adcxq	%rcx, %r9
        movq	%r8, 16(%rbp)
        movq	%r9, 24(%rbp)
        movq	32(%rbp), %r8
        movq	40(%rbp), %r9
        # A[2] x A[2]
        movq	16(%rsi), %rdx
        mulxq	%rdx, %rax, %rcx
        adoxq	%r8, %r8
        adoxq	%r9, %r9
        adcxq	%rax, %r8
        adcxq	%rcx, %r9
        movq	%r8, 32(%rbp)
        movq	%r9, 40(%rbp)
        movq	48(%rbp), %r8
        movq	56(%rbp), %r9
        # A[3] x A[3]
        movq	24(%rsi), %rdx
        mulxq	%rdx, %rax, %rcx
        adoxq	%r8, %r8
        adoxq	%r9, %r9
        adcxq	%rax, %r8
        adcxq	%rcx, %r9
        movq	%r8, 48(%rbp)
        movq	%r9, 56(%rbp)
        movq	64(%rbp), %r8
        movq	72(%rbp), %r9
        # A[4] x A[4]
        movq	32(%rsi), %rdx
        mulxq	%rdx, %rax, %rcx
        adoxq	%r8, %r8
        adoxq	%r9, %r9
        adcxq	%rax, %r8
        adcxq	%rcx, %r9
        movq	%r8, 64(%rbp)
        movq	%r9, 72(%rbp)
        movq	80(%rbp), %r8
        movq	88(%rbp), %r9
        # A[5] x A[5]
        movq	40(%rsi), %rdx
        mulxq	%rdx, %rax, %rcx
        adoxq	%r8, %r8
        adoxq	%r9, %r9
        adcxq	%rax, %r8
        adcxq	%rcx, %r9
        movq	%r8, 80(%rbp)
        movq	%r9, 88(%rbp)
        # A[6] x A[6]
        movq	48(%rsi), %rdx
        mulxq	%rdx, %rax, %rcx
        adoxq	%r13, %r13
        adoxq	%r14, %r14
        adcxq	%rax, %r13
        adcxq	%rcx, %r14
        # A[7] x A[7]
        movq	56(%rsi), %rdx
        mulxq	%rdx, %rax, %rcx
        adoxq	%r15, %r15
        adoxq	%rbx, %rbx
        adcxq	%rax, %r15
        adcxq	%rcx, %rbx
        movq	(%rdi), %r8
        movq	8(%rdi), %r9
        # A[8] x A[8]
        movq	64(%rsi), %rdx
        mulxq	%rdx, %rax, %rcx
        adoxq	%r8, %r8
        adoxq	%r9, %r9
        adcxq	%rax, %r8
        adcxq	%rcx, %r9
        movq	%r8, (%rdi)
        movq	%r9, 8(%rdi)
        movq	16(%rdi), %r8
        movq	24(%rdi), %r9
        # A[9] x A[9]
        movq	72(%rsi), %rdx
        mulxq	%rdx, %rax, %rcx
        adoxq	%r8, %r8
        adoxq	%r9, %r9
        adcxq	%rax, %r8
        adcxq	%rcx, %r9
        movq	%r8, 16(%rdi)
        movq	%r9, 24(%rdi)
        movq	32(%rdi), %r8
        movq	40(%rdi), %r9
        # A[10] x A[10]
        movq	80(%rsi), %rdx
        mulxq	%rdx, %rax, %rcx
        adoxq	%r8, %r8
        adoxq	%r9, %r9
        adcxq	%rax, %r8
        adcxq	%rcx, %r9
        movq	%r8, 32(%rdi)
        movq	%r9, 40(%rdi)
        movq	48(%rdi), %r8
        movq	56(%rdi), %r9
        # A[11] x A[11]
        movq	88(%rsi), %rdx
        mulxq	%rdx, %rax, %rcx
        adoxq	%r8, %r8
        adoxq	%r9, %r9
        adcxq	%rax, %r8
        adcxq	%rcx, %r9
        movq	%r8, 48(%rdi)
        movq	%r9, 56(%rdi)
        movq	64(%rdi), %r8
        movq	72(%rdi), %r9
        # A[12] x A[12]
        movq	96(%rsi), %rdx
        mulxq	%rdx, %rax, %rcx
        adoxq	%r8, %r8
        adoxq	%r9, %r9
        adcxq	%rax, %r8
        adcxq	%rcx, %r9
        movq	%r8, 64(%rdi)
        movq	%r9, 72(%rdi)
        movq	80(%rdi), %r8
        movq	88(%rdi), %r9
        # A[13] x A[13]
        movq	104(%rsi), %rdx
        mulxq	%rdx, %rax, %rcx
        adoxq	%r8, %r8
        adoxq	%r9, %r9
        adcxq	%rax, %r8
        adcxq	%rcx, %r9
        movq	%r8, 80(%rdi)
        movq	%r9, 88(%rdi)
        movq	96(%rdi), %r8
        movq	104(%rdi), %r9
        # A[14] x A[14]
        movq	112(%rsi), %rdx
        mulxq	%rdx, %rax, %rcx
        adoxq	%r8, %r8
        adoxq	%r9, %r9
        adcxq	%rax, %r8
        adcxq	%rcx, %r9
        movq	%r8, 96(%rdi)
        movq	%r9, 104(%rdi)
        movq	112(%rdi), %r8
        movq	120(%rdi), %r9
        # A[15] x A[15]
        movq	120(%rsi), %rdx
        mulxq	%rdx, %rax, %rcx
        adoxq	%r8, %r8
        adoxq	%r9, %r9
        adcxq	%rax, %r8
        adcxq	%rcx, %r9
        movq	%r8, 112(%rdi)
        movq	%r9, 120(%rdi)
        movq	%r13, -32(%rdi)
        movq	%r14, -24(%rdi)
        movq	%r15, -16(%rdi)
        movq	%rbx, -8(%rdi)
        subq	$0x80, %rdi
        cmpq	%rdi, %rsi
        jne	L_end_2048_sqr_avx2_16
        vmovdqu	(%rbp), %xmm0
        vmovups	%xmm0, (%rdi)
        vmovdqu	16(%rbp), %xmm0
        vmovups	%xmm0, 16(%rdi)
        vmovdqu	32(%rbp), %xmm0
        vmovups	%xmm0, 32(%rdi)
        vmovdqu	48(%rbp), %xmm0
        vmovups	%xmm0, 48(%rdi)
        vmovdqu	64(%rbp), %xmm0
        vmovups	%xmm0, 64(%rdi)
        vmovdqu	80(%rbp), %xmm0
        vmovups	%xmm0, 80(%rdi)
L_end_2048_sqr_avx2_16:
        addq	$0x80, %rsp
        popq	%rbx
        popq	%r15
        popq	%r14
        popq	%r13
        popq	%r12
        popq	%rbp
        repz retq
#ifndef __APPLE__
.size	sp_2048_sqr_avx2_16,.-sp_2048_sqr_avx2_16
#endif /* __APPLE__ */
#endif /* HAVE_INTEL_AVX2 */
/* Square a and put result in r. (r = a * a)
 *
 * Karatsuba: ah^2, al^2, (al - ah)^2
 *
 * r  A single precision integer.
 * a  A single precision integer.
 */
#ifndef __APPLE__
.text
.globl	sp_2048_sqr_32
.type	sp_2048_sqr_32,@function
.align	16
sp_2048_sqr_32:
#else
.section	__TEXT,__text
.globl	_sp_2048_sqr_32
.p2align	4
_sp_2048_sqr_32:
#endif /* __APPLE__ */
        subq	$0x110, %rsp
        movq	%rdi, 256(%rsp)
        movq	%rsi, 264(%rsp)
        movq	$0x00, %rcx
        movq	%rsp, %r8
        leaq	128(%rsi), %r9
        movq	(%rsi), %rdx
        subq	(%r9), %rdx
        movq	8(%rsi), %rax
        movq	%rdx, (%r8)
        sbbq	8(%r9), %rax
        movq	16(%rsi), %rdx
        movq	%rax, 8(%r8)
        sbbq	16(%r9), %rdx
        movq	24(%rsi), %rax
        movq	%rdx, 16(%r8)
        sbbq	24(%r9), %rax
        movq	32(%rsi), %rdx
        movq	%rax, 24(%r8)
        sbbq	32(%r9), %rdx
        movq	40(%rsi), %rax
        movq	%rdx, 32(%r8)
        sbbq	40(%r9), %rax
        movq	48(%rsi), %rdx
        movq	%rax, 40(%r8)
        sbbq	48(%r9), %rdx
        movq	56(%rsi), %rax
        movq	%rdx, 48(%r8)
        sbbq	56(%r9), %rax
        movq	64(%rsi), %rdx
        movq	%rax, 56(%r8)
        sbbq	64(%r9), %rdx
        movq	72(%rsi), %rax
        movq	%rdx, 64(%r8)
        sbbq	72(%r9), %rax
        movq	80(%rsi), %rdx
        movq	%rax, 72(%r8)
        sbbq	80(%r9), %rdx
        movq	88(%rsi), %rax
        movq	%rdx, 80(%r8)
        sbbq	88(%r9), %rax
        movq	96(%rsi), %rdx
        movq	%rax, 88(%r8)
        sbbq	96(%r9), %rdx
        movq	104(%rsi), %rax
        movq	%rdx, 96(%r8)
        sbbq	104(%r9), %rax
        movq	112(%rsi), %rdx
        movq	%rax, 104(%r8)
        sbbq	112(%r9), %rdx
        movq	120(%rsi), %rax
        movq	%rdx, 112(%r8)
        sbbq	120(%r9), %rax
        movq	%rax, 120(%r8)
        sbbq	$0x00, %rcx
        # Cond Negate
        movq	(%r8), %rdx
        movq	%rcx, %r9
        xorq	%rcx, %rdx
        negq	%r9
        subq	%rcx, %rdx
        movq	8(%r8), %rax
        sbbq	$0x00, %r9
        movq	%rdx, (%r8)
        xorq	%rcx, %rax
        addq	%r9, %rax
        movq	16(%r8), %rdx
        setc	%r9b
        movq	%rax, 8(%r8)
        xorq	%rcx, %rdx
        addq	%r9, %rdx
        movq	24(%r8), %rax
        setc	%r9b
        movq	%rdx, 16(%r8)
        xorq	%rcx, %rax
        addq	%r9, %rax
        movq	32(%r8), %rdx
        setc	%r9b
        movq	%rax, 24(%r8)
        xorq	%rcx, %rdx
        addq	%r9, %rdx
        movq	40(%r8), %rax
        setc	%r9b
        movq	%rdx, 32(%r8)
        xorq	%rcx, %rax
        addq	%r9, %rax
        movq	48(%r8), %rdx
        setc	%r9b
        movq	%rax, 40(%r8)
        xorq	%rcx, %rdx
        addq	%r9, %rdx
        movq	56(%r8), %rax
        setc	%r9b
        movq	%rdx, 48(%r8)
        xorq	%rcx, %rax
        addq	%r9, %rax
        movq	64(%r8), %rdx
        setc	%r9b
        movq	%rax, 56(%r8)
        xorq	%rcx, %rdx
        addq	%r9, %rdx
        movq	72(%r8), %rax
        setc	%r9b
        movq	%rdx, 64(%r8)
        xorq	%rcx, %rax
        addq	%r9, %rax
        movq	80(%r8), %rdx
        setc	%r9b
        movq	%rax, 72(%r8)
        xorq	%rcx, %rdx
        addq	%r9, %rdx
        movq	88(%r8), %rax
        setc	%r9b
        movq	%rdx, 80(%r8)
        xorq	%rcx, %rax
        addq	%r9, %rax
        movq	96(%r8), %rdx
        setc	%r9b
        movq	%rax, 88(%r8)
        xorq	%rcx, %rdx
        addq	%r9, %rdx
        movq	104(%r8), %rax
        setc	%r9b
        movq	%rdx, 96(%r8)
        xorq	%rcx, %rax
        addq	%r9, %rax
        movq	112(%r8), %rdx
        setc	%r9b
        movq	%rax, 104(%r8)
        xorq	%rcx, %rdx
        addq	%r9, %rdx
        movq	120(%r8), %rax
        setc	%r9b
        movq	%rdx, 112(%r8)
        xorq	%rcx, %rax
        addq	%r9, %rax
        movq	%rax, 120(%r8)
        movq	%r8, %rsi
        movq	%rsp, %rdi
#ifndef __APPLE__
        callq	sp_2048_sqr_16@plt
#else
        callq	_sp_2048_sqr_16
#endif /* __APPLE__ */
        movq	264(%rsp), %rsi
        movq	256(%rsp), %rdi
        addq	$0x80, %rsi
        addq	$0x100, %rdi
#ifndef __APPLE__
        callq	sp_2048_sqr_16@plt
#else
        callq	_sp_2048_sqr_16
#endif /* __APPLE__ */
        movq	264(%rsp), %rsi
        movq	256(%rsp), %rdi
#ifndef __APPLE__
        callq	sp_2048_sqr_16@plt
#else
        callq	_sp_2048_sqr_16
#endif /* __APPLE__ */
#ifdef _WIN64
        movq	264(%rsp), %rsi
        movq	256(%rsp), %rdi
#endif /* _WIN64 */
        movq	256(%rsp), %rsi
        leaq	128(%rsp), %r8
        addq	$0x180, %rsi
        movq	$0x00, %rcx
        movq	-128(%r8), %rax
        subq	-128(%rsi), %rax
        movq	-120(%r8), %rdx
        movq	%rax, -128(%r8)
        sbbq	-120(%rsi), %rdx
        movq	-112(%r8), %rax
        movq	%rdx, -120(%r8)
        sbbq	-112(%rsi), %rax
        movq	-104(%r8), %rdx
        movq	%rax, -112(%r8)
        sbbq	-104(%rsi), %rdx
        movq	-96(%r8), %rax
        movq	%rdx, -104(%r8)
        sbbq	-96(%rsi), %rax
        movq	-88(%r8), %rdx
        movq	%rax, -96(%r8)
        sbbq	-88(%rsi), %rdx
        movq	-80(%r8), %rax
        movq	%rdx, -88(%r8)
        sbbq	-80(%rsi), %rax
        movq	-72(%r8), %rdx
        movq	%rax, -80(%r8)
        sbbq	-72(%rsi), %rdx
        movq	-64(%r8), %rax
        movq	%rdx, -72(%r8)
        sbbq	-64(%rsi), %rax
        movq	-56(%r8), %rdx
        movq	%rax, -64(%r8)
        sbbq	-56(%rsi), %rdx
        movq	-48(%r8), %rax
        movq	%rdx, -56(%r8)
        sbbq	-48(%rsi), %rax
        movq	-40(%r8), %rdx
        movq	%rax, -48(%r8)
        sbbq	-40(%rsi), %rdx
        movq	-32(%r8), %rax
        movq	%rdx, -40(%r8)
        sbbq	-32(%rsi), %rax
        movq	-24(%r8), %rdx
        movq	%rax, -32(%r8)
        sbbq	-24(%rsi), %rdx
        movq	-16(%r8), %rax
        movq	%rdx, -24(%r8)
        sbbq	-16(%rsi), %rax
        movq	-8(%r8), %rdx
        movq	%rax, -16(%r8)
        sbbq	-8(%rsi), %rdx
        movq	(%r8), %rax
        movq	%rdx, -8(%r8)
        sbbq	(%rsi), %rax
        movq	8(%r8), %rdx
        movq	%rax, (%r8)
        sbbq	8(%rsi), %rdx
        movq	16(%r8), %rax
        movq	%rdx, 8(%r8)
        sbbq	16(%rsi), %rax
        movq	24(%r8), %rdx
        movq	%rax, 16(%r8)
        sbbq	24(%rsi), %rdx
        movq	32(%r8), %rax
        movq	%rdx, 24(%r8)
        sbbq	32(%rsi), %rax
        movq	40(%r8), %rdx
        movq	%rax, 32(%r8)
        sbbq	40(%rsi), %rdx
        movq	48(%r8), %rax
        movq	%rdx, 40(%r8)
        sbbq	48(%rsi), %rax
        movq	56(%r8), %rdx
        movq	%rax, 48(%r8)
        sbbq	56(%rsi), %rdx
        movq	64(%r8), %rax
        movq	%rdx, 56(%r8)
        sbbq	64(%rsi), %rax
        movq	72(%r8), %rdx
        movq	%rax, 64(%r8)
        sbbq	72(%rsi), %rdx
        movq	80(%r8), %rax
        movq	%rdx, 72(%r8)
        sbbq	80(%rsi), %rax
        movq	88(%r8), %rdx
        movq	%rax, 80(%r8)
        sbbq	88(%rsi), %rdx
        movq	96(%r8), %rax
        movq	%rdx, 88(%r8)
        sbbq	96(%rsi), %rax
        movq	104(%r8), %rdx
        movq	%rax, 96(%r8)
        sbbq	104(%rsi), %rdx
        movq	112(%r8), %rax
        movq	%rdx, 104(%r8)
        sbbq	112(%rsi), %rax
        movq	120(%r8), %rdx
        movq	%rax, 112(%r8)
        sbbq	120(%rsi), %rdx
        movq	%rdx, 120(%r8)
        sbbq	$0x00, %rcx
        subq	$0x100, %rsi
        movq	-128(%r8), %rax
        subq	-128(%rsi), %rax
        movq	-120(%r8), %rdx
        movq	%rax, -128(%r8)
        sbbq	-120(%rsi), %rdx
        movq	-112(%r8), %rax
        movq	%rdx, -120(%r8)
        sbbq	-112(%rsi), %rax
        movq	-104(%r8), %rdx
        movq	%rax, -112(%r8)
        sbbq	-104(%rsi), %rdx
        movq	-96(%r8), %rax
        movq	%rdx, -104(%r8)
        sbbq	-96(%rsi), %rax
        movq	-88(%r8), %rdx
        movq	%rax, -96(%r8)
        sbbq	-88(%rsi), %rdx
        movq	-80(%r8), %rax
        movq	%rdx, -88(%r8)
        sbbq	-80(%rsi), %rax
        movq	-72(%r8), %rdx
        movq	%rax, -80(%r8)
        sbbq	-72(%rsi), %rdx
        movq	-64(%r8), %rax
        movq	%rdx, -72(%r8)
        sbbq	-64(%rsi), %rax
        movq	-56(%r8), %rdx
        movq	%rax, -64(%r8)
        sbbq	-56(%rsi), %rdx
        movq	-48(%r8), %rax
        movq	%rdx, -56(%r8)
        sbbq	-48(%rsi), %rax
        movq	-40(%r8), %rdx
        movq	%rax, -48(%r8)
        sbbq	-40(%rsi), %rdx
        movq	-32(%r8), %rax
        movq	%rdx, -40(%r8)
        sbbq	-32(%rsi), %rax
        movq	-24(%r8), %rdx
        movq	%rax, -32(%r8)
        sbbq	-24(%rsi), %rdx
        movq	-16(%r8), %rax
        movq	%rdx, -24(%r8)
        sbbq	-16(%rsi), %rax
        movq	-8(%r8), %rdx
        movq	%rax, -16(%r8)
        sbbq	-8(%rsi), %rdx
        movq	(%r8), %rax
        movq	%rdx, -8(%r8)
        sbbq	(%rsi), %rax
        movq	8(%r8), %rdx
        movq	%rax, (%r8)
        sbbq	8(%rsi), %rdx
        movq	16(%r8), %rax
        movq	%rdx, 8(%r8)
        sbbq	16(%rsi), %rax
        movq	24(%r8), %rdx
        movq	%rax, 16(%r8)
        sbbq	24(%rsi), %rdx
        movq	32(%r8), %rax
        movq	%rdx, 24(%r8)
        sbbq	32(%rsi), %rax
        movq	40(%r8), %rdx
        movq	%rax, 32(%r8)
        sbbq	40(%rsi), %rdx
        movq	48(%r8), %rax
        movq	%rdx, 40(%r8)
        sbbq	48(%rsi), %rax
        movq	56(%r8), %rdx
        movq	%rax, 48(%r8)
        sbbq	56(%rsi), %rdx
        movq	64(%r8), %rax
        movq	%rdx, 56(%r8)
        sbbq	64(%rsi), %rax
        movq	72(%r8), %rdx
        movq	%rax, 64(%r8)
        sbbq	72(%rsi), %rdx
        movq	80(%r8), %rax
        movq	%rdx, 72(%r8)
        sbbq	80(%rsi), %rax
        movq	88(%r8), %rdx
        movq	%rax, 80(%r8)
        sbbq	88(%rsi), %rdx
        movq	96(%r8), %rax
        movq	%rdx, 88(%r8)
        sbbq	96(%rsi), %rax
        movq	104(%r8), %rdx
        movq	%rax, 96(%r8)
        sbbq	104(%rsi), %rdx
        movq	112(%r8), %rax
        movq	%rdx, 104(%r8)
        sbbq	112(%rsi), %rax
        movq	120(%r8), %rdx
        movq	%rax, 112(%r8)
        sbbq	120(%rsi), %rdx
        movq	%rdx, 120(%r8)
        sbbq	$0x00, %rcx
        movq	256(%rsp), %rdi
        negq	%rcx
        addq	$0x100, %rdi
        movq	-128(%rdi), %rax
        subq	-128(%r8), %rax
        movq	-120(%rdi), %rdx
        movq	%rax, -128(%rdi)
        sbbq	-120(%r8), %rdx
        movq	-112(%rdi), %rax
        movq	%rdx, -120(%rdi)
        sbbq	-112(%r8), %rax
        movq	-104(%rdi), %rdx
        movq	%rax, -112(%rdi)
        sbbq	-104(%r8), %rdx
        movq	-96(%rdi), %rax
        movq	%rdx, -104(%rdi)
        sbbq	-96(%r8), %rax
        movq	-88(%rdi), %rdx
        movq	%rax, -96(%rdi)
        sbbq	-88(%r8), %rdx
        movq	-80(%rdi), %rax
        movq	%rdx, -88(%rdi)
        sbbq	-80(%r8), %rax
        movq	-72(%rdi), %rdx
        movq	%rax, -80(%rdi)
        sbbq	-72(%r8), %rdx
        movq	-64(%rdi), %rax
        movq	%rdx, -72(%rdi)
        sbbq	-64(%r8), %rax
        movq	-56(%rdi), %rdx
        movq	%rax, -64(%rdi)
        sbbq	-56(%r8), %rdx
        movq	-48(%rdi), %rax
        movq	%rdx, -56(%rdi)
        sbbq	-48(%r8), %rax
        movq	-40(%rdi), %rdx
        movq	%rax, -48(%rdi)
        sbbq	-40(%r8), %rdx
        movq	-32(%rdi), %rax
        movq	%rdx, -40(%rdi)
        sbbq	-32(%r8), %rax
        movq	-24(%rdi), %rdx
        movq	%rax, -32(%rdi)
        sbbq	-24(%r8), %rdx
        movq	-16(%rdi), %rax
        movq	%rdx, -24(%rdi)
        sbbq	-16(%r8), %rax
        movq	-8(%rdi), %rdx
        movq	%rax, -16(%rdi)
        sbbq	-8(%r8), %rdx
        movq	(%rdi), %rax
        movq	%rdx, -8(%rdi)
        sbbq	(%r8), %rax
        movq	8(%rdi), %rdx
        movq	%rax, (%rdi)
        sbbq	8(%r8), %rdx
        movq	16(%rdi), %rax
        movq	%rdx, 8(%rdi)
        sbbq	16(%r8), %rax
        movq	24(%rdi), %rdx
        movq	%rax, 16(%rdi)
        sbbq	24(%r8), %rdx
        movq	32(%rdi), %rax
        movq	%rdx, 24(%rdi)
        sbbq	32(%r8), %rax
        movq	40(%rdi), %rdx
        movq	%rax, 32(%rdi)
        sbbq	40(%r8), %rdx
        movq	48(%rdi), %rax
        movq	%rdx, 40(%rdi)
        sbbq	48(%r8), %rax
        movq	56(%rdi), %rdx
        movq	%rax, 48(%rdi)
        sbbq	56(%r8), %rdx
        movq	64(%rdi), %rax
        movq	%rdx, 56(%rdi)
        sbbq	64(%r8), %rax
        movq	72(%rdi), %rdx
        movq	%rax, 64(%rdi)
        sbbq	72(%r8), %rdx
        movq	80(%rdi), %rax
        movq	%rdx, 72(%rdi)
        sbbq	80(%r8), %rax
        movq	88(%rdi), %rdx
        movq	%rax, 80(%rdi)
        sbbq	88(%r8), %rdx
        movq	96(%rdi), %rax
        movq	%rdx, 88(%rdi)
        sbbq	96(%r8), %rax
        movq	104(%rdi), %rdx
        movq	%rax, 96(%rdi)
        sbbq	104(%r8), %rdx
        movq	112(%rdi), %rax
        movq	%rdx, 104(%rdi)
        sbbq	112(%r8), %rax
        movq	120(%rdi), %rdx
        movq	%rax, 112(%rdi)
        sbbq	120(%r8), %rdx
        movq	%rdx, 120(%rdi)
        sbbq	$0x00, %rcx
        movq	256(%rsp), %rdi
        addq	$0x180, %rdi
        # Add in word
        movq	(%rdi), %rax
        addq	%rcx, %rax
        movq	8(%rdi), %rdx
        movq	%rax, (%rdi)
        adcq	$0x00, %rdx
        movq	16(%rdi), %rax
        movq	%rdx, 8(%rdi)
        adcq	$0x00, %rax
        movq	24(%rdi), %rdx
        movq	%rax, 16(%rdi)
        adcq	$0x00, %rdx
        movq	32(%rdi), %rax
        movq	%rdx, 24(%rdi)
        adcq	$0x00, %rax
        movq	40(%rdi), %rdx
        movq	%rax, 32(%rdi)
        adcq	$0x00, %rdx
        movq	48(%rdi), %rax
        movq	%rdx, 40(%rdi)
        adcq	$0x00, %rax
        movq	56(%rdi), %rdx
        movq	%rax, 48(%rdi)
        adcq	$0x00, %rdx
        movq	64(%rdi), %rax
        movq	%rdx, 56(%rdi)
        adcq	$0x00, %rax
        movq	72(%rdi), %rdx
        movq	%rax, 64(%rdi)
        adcq	$0x00, %rdx
        movq	80(%rdi), %rax
        movq	%rdx, 72(%rdi)
        adcq	$0x00, %rax
        movq	88(%rdi), %rdx
        movq	%rax, 80(%rdi)
        adcq	$0x00, %rdx
        movq	96(%rdi), %rax
        movq	%rdx, 88(%rdi)
        adcq	$0x00, %rax
        movq	104(%rdi), %rdx
        movq	%rax, 96(%rdi)
        adcq	$0x00, %rdx
        movq	112(%rdi), %rax
        movq	%rdx, 104(%rdi)
        adcq	$0x00, %rax
        movq	120(%rdi), %rdx
        movq	%rax, 112(%rdi)
        adcq	$0x00, %rdx
        movq	%rdx, 120(%rdi)
        movq	264(%rsp), %rsi
        movq	256(%rsp), %rdi
        addq	$0x110, %rsp
        repz retq
#ifndef __APPLE__
.size	sp_2048_sqr_32,.-sp_2048_sqr_32
#endif /* __APPLE__ */
#ifdef HAVE_INTEL_AVX2
/* Square a and put result in r. (r = a * a)
 *
 * Karatsuba: ah^2, al^2, (al - ah)^2
 *
 * r  A single precision integer.
 * a  A single precision integer.
 */
#ifndef __APPLE__
.text
.globl	sp_2048_sqr_avx2_32
.type	sp_2048_sqr_avx2_32,@function
.align	16
sp_2048_sqr_avx2_32:
#else
.section	__TEXT,__text
.globl	_sp_2048_sqr_avx2_32
.p2align	4
_sp_2048_sqr_avx2_32:
#endif /* __APPLE__ */
        subq	$0x110, %rsp
        movq	%rdi, 256(%rsp)
        movq	%rsi, 264(%rsp)
        movq	$0x00, %rcx
        movq	%rsp, %r8
        leaq	128(%rsi), %r9
        movq	(%rsi), %rdx
        subq	(%r9), %rdx
        movq	8(%rsi), %rax
        movq	%rdx, (%r8)
        sbbq	8(%r9), %rax
        movq	16(%rsi), %rdx
        movq	%rax, 8(%r8)
        sbbq	16(%r9), %rdx
        movq	24(%rsi), %rax
        movq	%rdx, 16(%r8)
        sbbq	24(%r9), %rax
        movq	32(%rsi), %rdx
        movq	%rax, 24(%r8)
        sbbq	32(%r9), %rdx
        movq	40(%rsi), %rax
        movq	%rdx, 32(%r8)
        sbbq	40(%r9), %rax
        movq	48(%rsi), %rdx
        movq	%rax, 40(%r8)
        sbbq	48(%r9), %rdx
        movq	56(%rsi), %rax
        movq	%rdx, 48(%r8)
        sbbq	56(%r9), %rax
        movq	64(%rsi), %rdx
        movq	%rax, 56(%r8)
        sbbq	64(%r9), %rdx
        movq	72(%rsi), %rax
        movq	%rdx, 64(%r8)
        sbbq	72(%r9), %rax
        movq	80(%rsi), %rdx
        movq	%rax, 72(%r8)
        sbbq	80(%r9), %rdx
        movq	88(%rsi), %rax
        movq	%rdx, 80(%r8)
        sbbq	88(%r9), %rax
        movq	96(%rsi), %rdx
        movq	%rax, 88(%r8)
        sbbq	96(%r9), %rdx
        movq	104(%rsi), %rax
        movq	%rdx, 96(%r8)
        sbbq	104(%r9), %rax
        movq	112(%rsi), %rdx
        movq	%rax, 104(%r8)
        sbbq	112(%r9), %rdx
        movq	120(%rsi), %rax
        movq	%rdx, 112(%r8)
        sbbq	120(%r9), %rax
        movq	%rax, 120(%r8)
        sbbq	$0x00, %rcx
        # Cond Negate
        movq	(%r8), %rdx
        movq	%rcx, %r9
        xorq	%rcx, %rdx
        negq	%r9
        subq	%rcx, %rdx
        movq	8(%r8), %rax
        sbbq	$0x00, %r9
        movq	%rdx, (%r8)
        xorq	%rcx, %rax
        addq	%r9, %rax
        movq	16(%r8), %rdx
        setc	%r9b
        movq	%rax, 8(%r8)
        xorq	%rcx, %rdx
        addq	%r9, %rdx
        movq	24(%r8), %rax
        setc	%r9b
        movq	%rdx, 16(%r8)
        xorq	%rcx, %rax
        addq	%r9, %rax
        movq	32(%r8), %rdx
        setc	%r9b
        movq	%rax, 24(%r8)
        xorq	%rcx, %rdx
        addq	%r9, %rdx
        movq	40(%r8), %rax
        setc	%r9b
        movq	%rdx, 32(%r8)
        xorq	%rcx, %rax
        addq	%r9, %rax
        movq	48(%r8), %rdx
        setc	%r9b
        movq	%rax, 40(%r8)
        xorq	%rcx, %rdx
        addq	%r9, %rdx
        movq	56(%r8), %rax
        setc	%r9b
        movq	%rdx, 48(%r8)
        xorq	%rcx, %rax
        addq	%r9, %rax
        movq	64(%r8), %rdx
        setc	%r9b
        movq	%rax, 56(%r8)
        xorq	%rcx, %rdx
        addq	%r9, %rdx
        movq	72(%r8), %rax
        setc	%r9b
        movq	%rdx, 64(%r8)
        xorq	%rcx, %rax
        addq	%r9, %rax
        movq	80(%r8), %rdx
        setc	%r9b
        movq	%rax, 72(%r8)
        xorq	%rcx, %rdx
        addq	%r9, %rdx
        movq	88(%r8), %rax
        setc	%r9b
        movq	%rdx, 80(%r8)
        xorq	%rcx, %rax
        addq	%r9, %rax
        movq	96(%r8), %rdx
        setc	%r9b
        movq	%rax, 88(%r8)
        xorq	%rcx, %rdx
        addq	%r9, %rdx
        movq	104(%r8), %rax
        setc	%r9b
        movq	%rdx, 96(%r8)
        xorq	%rcx, %rax
        addq	%r9, %rax
        movq	112(%r8), %rdx
        setc	%r9b
        movq	%rax, 104(%r8)
        xorq	%rcx, %rdx
        addq	%r9, %rdx
        movq	120(%r8), %rax
        setc	%r9b
        movq	%rdx, 112(%r8)
        xorq	%rcx, %rax
        addq	%r9, %rax
        movq	%rax, 120(%r8)
        movq	%r8, %rsi
        movq	%rsp, %rdi
#ifndef __APPLE__
        callq	sp_2048_sqr_avx2_16@plt
#else
        callq	_sp_2048_sqr_avx2_16
#endif /* __APPLE__ */
        movq	264(%rsp), %rsi
        movq	256(%rsp), %rdi
        addq	$0x80, %rsi
        addq	$0x100, %rdi
#ifndef __APPLE__
        callq	sp_2048_sqr_avx2_16@plt
#else
        callq	_sp_2048_sqr_avx2_16
#endif /* __APPLE__ */
        movq	264(%rsp), %rsi
        movq	256(%rsp), %rdi
#ifndef __APPLE__
        callq	sp_2048_sqr_avx2_16@plt
#else
        callq	_sp_2048_sqr_avx2_16
#endif /* __APPLE__ */
#ifdef _WIN64
        movq	264(%rsp), %rsi
        movq	256(%rsp), %rdi
#endif /* _WIN64 */
        movq	256(%rsp), %rsi
        leaq	128(%rsp), %r8
        addq	$0x180, %rsi
        movq	$0x00, %rcx
        movq	-128(%r8), %rax
        subq	-128(%rsi), %rax
        movq	-120(%r8), %rdx
        movq	%rax, -128(%r8)
        sbbq	-120(%rsi), %rdx
        movq	-112(%r8), %rax
        movq	%rdx, -120(%r8)
        sbbq	-112(%rsi), %rax
        movq	-104(%r8), %rdx
        movq	%rax, -112(%r8)
        sbbq	-104(%rsi), %rdx
        movq	-96(%r8), %rax
        movq	%rdx, -104(%r8)
        sbbq	-96(%rsi), %rax
        movq	-88(%r8), %rdx
        movq	%rax, -96(%r8)
        sbbq	-88(%rsi), %rdx
        movq	-80(%r8), %rax
        movq	%rdx, -88(%r8)
        sbbq	-80(%rsi), %rax
        movq	-72(%r8), %rdx
        movq	%rax, -80(%r8)
        sbbq	-72(%rsi), %rdx
        movq	-64(%r8), %rax
        movq	%rdx, -72(%r8)
        sbbq	-64(%rsi), %rax
        movq	-56(%r8), %rdx
        movq	%rax, -64(%r8)
        sbbq	-56(%rsi), %rdx
        movq	-48(%r8), %rax
        movq	%rdx, -56(%r8)
        sbbq	-48(%rsi), %rax
        movq	-40(%r8), %rdx
        movq	%rax, -48(%r8)
        sbbq	-40(%rsi), %rdx
        movq	-32(%r8), %rax
        movq	%rdx, -40(%r8)
        sbbq	-32(%rsi), %rax
        movq	-24(%r8), %rdx
        movq	%rax, -32(%r8)
        sbbq	-24(%rsi), %rdx
        movq	-16(%r8), %rax
        movq	%rdx, -24(%r8)
        sbbq	-16(%rsi), %rax
        movq	-8(%r8), %rdx
        movq	%rax, -16(%r8)
        sbbq	-8(%rsi), %rdx
        movq	(%r8), %rax
        movq	%rdx, -8(%r8)
        sbbq	(%rsi), %rax
        movq	8(%r8), %rdx
        movq	%rax, (%r8)
        sbbq	8(%rsi), %rdx
        movq	16(%r8), %rax
        movq	%rdx, 8(%r8)
        sbbq	16(%rsi), %rax
        movq	24(%r8), %rdx
        movq	%rax, 16(%r8)
        sbbq	24(%rsi), %rdx
        movq	32(%r8), %rax
        movq	%rdx, 24(%r8)
        sbbq	32(%rsi), %rax
        movq	40(%r8), %rdx
        movq	%rax, 32(%r8)
        sbbq	40(%rsi), %rdx
        movq	48(%r8), %rax
        movq	%rdx, 40(%r8)
        sbbq	48(%rsi), %rax
        movq	56(%r8), %rdx
        movq	%rax, 48(%r8)
        sbbq	56(%rsi), %rdx
        movq	64(%r8), %rax
        movq	%rdx, 56(%r8)
        sbbq	64(%rsi), %rax
        movq	72(%r8), %rdx
        movq	%rax, 64(%r8)
        sbbq	72(%rsi), %rdx
        movq	80(%r8), %rax
        movq	%rdx, 72(%r8)
        sbbq	80(%rsi), %rax
        movq	88(%r8), %rdx
        movq	%rax, 80(%r8)
        sbbq	88(%rsi), %rdx
        movq	96(%r8), %rax
        movq	%rdx, 88(%r8)
        sbbq	96(%rsi), %rax
        movq	104(%r8), %rdx
        movq	%rax, 96(%r8)
        sbbq	104(%rsi), %rdx
        movq	112(%r8), %rax
        movq	%rdx, 104(%r8)
        sbbq	112(%rsi), %rax
        movq	120(%r8), %rdx
        movq	%rax, 112(%r8)
        sbbq	120(%rsi), %rdx
        movq	%rdx, 120(%r8)
        sbbq	$0x00, %rcx
        subq	$0x100, %rsi
        movq	-128(%r8), %rax
        subq	-128(%rsi), %rax
        movq	-120(%r8), %rdx
        movq	%rax, -128(%r8)
        sbbq	-120(%rsi), %rdx
        movq	-112(%r8), %rax
        movq	%rdx, -120(%r8)
        sbbq	-112(%rsi), %rax
        movq	-104(%r8), %rdx
        movq	%rax, -112(%r8)
        sbbq	-104(%rsi), %rdx
        movq	-96(%r8), %rax
        movq	%rdx, -104(%r8)
        sbbq	-96(%rsi), %rax
        movq	-88(%r8), %rdx
        movq	%rax, -96(%r8)
        sbbq	-88(%rsi), %rdx
        movq	-80(%r8), %rax
        movq	%rdx, -88(%r8)
        sbbq	-80(%rsi), %rax
        movq	-72(%r8), %rdx
        movq	%rax, -80(%r8)
        sbbq	-72(%rsi), %rdx
        movq	-64(%r8), %rax
        movq	%rdx, -72(%r8)
        sbbq	-64(%rsi), %rax
        movq	-56(%r8), %rdx
        movq	%rax, -64(%r8)
        sbbq	-56(%rsi), %rdx
        movq	-48(%r8), %rax
        movq	%rdx, -56(%r8)
        sbbq	-48(%rsi), %rax
        movq	-40(%r8), %rdx
        movq	%rax, -48(%r8)
        sbbq	-40(%rsi), %rdx
        movq	-32(%r8), %rax
        movq	%rdx, -40(%r8)
        sbbq	-32(%rsi), %rax
        movq	-24(%r8), %rdx
        movq	%rax, -32(%r8)
        sbbq	-24(%rsi), %rdx
        movq	-16(%r8), %rax
        movq	%rdx, -24(%r8)
        sbbq	-16(%rsi), %rax
        movq	-8(%r8), %rdx
        movq	%rax, -16(%r8)
        sbbq	-8(%rsi), %rdx
        movq	(%r8), %rax
        movq	%rdx, -8(%r8)
        sbbq	(%rsi), %rax
        movq	8(%r8), %rdx
        movq	%rax, (%r8)
        sbbq	8(%rsi), %rdx
        movq	16(%r8), %rax
        movq	%rdx, 8(%r8)
        sbbq	16(%rsi), %rax
        movq	24(%r8), %rdx
        movq	%rax, 16(%r8)
        sbbq	24(%rsi), %rdx
        movq	32(%r8), %rax
        movq	%rdx, 24(%r8)
        sbbq	32(%rsi), %rax
        movq	40(%r8), %rdx
        movq	%rax, 32(%r8)
        sbbq	40(%rsi), %rdx
        movq	48(%r8), %rax
        movq	%rdx, 40(%r8)
        sbbq	48(%rsi), %rax
        movq	56(%r8), %rdx
        movq	%rax, 48(%r8)
        sbbq	56(%rsi), %rdx
        movq	64(%r8), %rax
        movq	%rdx, 56(%r8)
        sbbq	64(%rsi), %rax
        movq	72(%r8), %rdx
        movq	%rax, 64(%r8)
        sbbq	72(%rsi), %rdx
        movq	80(%r8), %rax
        movq	%rdx, 72(%r8)
        sbbq	80(%rsi), %rax
        movq	88(%r8), %rdx
        movq	%rax, 80(%r8)
        sbbq	88(%rsi), %rdx
        movq	96(%r8), %rax
        movq	%rdx, 88(%r8)
        sbbq	96(%rsi), %rax
        movq	104(%r8), %rdx
        movq	%rax, 96(%r8)
        sbbq	104(%rsi), %rdx
        movq	112(%r8), %rax
        movq	%rdx, 104(%r8)
        sbbq	112(%rsi), %rax
        movq	120(%r8), %rdx
        movq	%rax, 112(%r8)
        sbbq	120(%rsi), %rdx
        movq	%rdx, 120(%r8)
        sbbq	$0x00, %rcx
        movq	256(%rsp), %rdi
        negq	%rcx
        addq	$0x100, %rdi
        movq	-128(%rdi), %rax
        subq	-128(%r8), %rax
        movq	-120(%rdi), %rdx
        movq	%rax, -128(%rdi)
        sbbq	-120(%r8), %rdx
        movq	-112(%rdi), %rax
        movq	%rdx, -120(%rdi)
        sbbq	-112(%r8), %rax
        movq	-104(%rdi), %rdx
        movq	%rax, -112(%rdi)
        sbbq	-104(%r8), %rdx
        movq	-96(%rdi), %rax
        movq	%rdx, -104(%rdi)
        sbbq	-96(%r8), %rax
        movq	-88(%rdi), %rdx
        movq	%rax, -96(%rdi)
        sbbq	-88(%r8), %rdx
        movq	-80(%rdi), %rax
        movq	%rdx, -88(%rdi)
        sbbq	-80(%r8), %rax
        movq	-72(%rdi), %rdx
        movq	%rax, -80(%rdi)
        sbbq	-72(%r8), %rdx
        movq	-64(%rdi), %rax
        movq	%rdx, -72(%rdi)
        sbbq	-64(%r8), %rax
        movq	-56(%rdi), %rdx
        movq	%rax, -64(%rdi)
        sbbq	-56(%r8), %rdx
        movq	-48(%rdi), %rax
        movq	%rdx, -56(%rdi)
        sbbq	-48(%r8), %rax
        movq	-40(%rdi), %rdx
        movq	%rax, -48(%rdi)
        sbbq	-40(%r8), %rdx
        movq	-32(%rdi), %rax
        movq	%rdx, -40(%rdi)
        sbbq	-32(%r8), %rax
        movq	-24(%rdi), %rdx
        movq	%rax, -32(%rdi)
        sbbq	-24(%r8), %rdx
        movq	-16(%rdi), %rax
        movq	%rdx, -24(%rdi)
        sbbq	-16(%r8), %rax
        movq	-8(%rdi), %rdx
        movq	%rax, -16(%rdi)
        sbbq	-8(%r8), %rdx
        movq	(%rdi), %rax
        movq	%rdx, -8(%rdi)
        sbbq	(%r8), %rax
        movq	8(%rdi), %rdx
        movq	%rax, (%rdi)
        sbbq	8(%r8), %rdx
        movq	16(%rdi), %rax
        movq	%rdx, 8(%rdi)
        sbbq	16(%r8), %rax
        movq	24(%rdi), %rdx
        movq	%rax, 16(%rdi)
        sbbq	24(%r8), %rdx
        movq	32(%rdi), %rax
        movq	%rdx, 24(%rdi)
        sbbq	32(%r8), %rax
        movq	40(%rdi), %rdx
        movq	%rax, 32(%rdi)
        sbbq	40(%r8), %rdx
        movq	48(%rdi), %rax
        movq	%rdx, 40(%rdi)
        sbbq	48(%r8), %rax
        movq	56(%rdi), %rdx
        movq	%rax, 48(%rdi)
        sbbq	56(%r8), %rdx
        movq	64(%rdi), %rax
        movq	%rdx, 56(%rdi)
        sbbq	64(%r8), %rax
        movq	72(%rdi), %rdx
        movq	%rax, 64(%rdi)
        sbbq	72(%r8), %rdx
        movq	80(%rdi), %rax
        movq	%rdx, 72(%rdi)
        sbbq	80(%r8), %rax
        movq	88(%rdi), %rdx
        movq	%rax, 80(%rdi)
        sbbq	88(%r8), %rdx
        movq	96(%rdi), %rax
        movq	%rdx, 88(%rdi)
        sbbq	96(%r8), %rax
        movq	104(%rdi), %rdx
        movq	%rax, 96(%rdi)
        sbbq	104(%r8), %rdx
        movq	112(%rdi), %rax
        movq	%rdx, 104(%rdi)
        sbbq	112(%r8), %rax
        movq	120(%rdi), %rdx
        movq	%rax, 112(%rdi)
        sbbq	120(%r8), %rdx
        movq	%rdx, 120(%rdi)
        sbbq	$0x00, %rcx
        movq	256(%rsp), %rdi
        addq	$0x180, %rdi
        # Add in word
        movq	(%rdi), %rax
        addq	%rcx, %rax
        movq	8(%rdi), %rdx
        movq	%rax, (%rdi)
        adcq	$0x00, %rdx
        movq	16(%rdi), %rax
        movq	%rdx, 8(%rdi)
        adcq	$0x00, %rax
        movq	24(%rdi), %rdx
        movq	%rax, 16(%rdi)
        adcq	$0x00, %rdx
        movq	32(%rdi), %rax
        movq	%rdx, 24(%rdi)
        adcq	$0x00, %rax
        movq	40(%rdi), %rdx
        movq	%rax, 32(%rdi)
        adcq	$0x00, %rdx
        movq	48(%rdi), %rax
        movq	%rdx, 40(%rdi)
        adcq	$0x00, %rax
        movq	56(%rdi), %rdx
        movq	%rax, 48(%rdi)
        adcq	$0x00, %rdx
        movq	64(%rdi), %rax
        movq	%rdx, 56(%rdi)
        adcq	$0x00, %rax
        movq	72(%rdi), %rdx
        movq	%rax, 64(%rdi)
        adcq	$0x00, %rdx
        movq	80(%rdi), %rax
        movq	%rdx, 72(%rdi)
        adcq	$0x00, %rax
        movq	88(%rdi), %rdx
        movq	%rax, 80(%rdi)
        adcq	$0x00, %rdx
        movq	96(%rdi), %rax
        movq	%rdx, 88(%rdi)
        adcq	$0x00, %rax
        movq	104(%rdi), %rdx
        movq	%rax, 96(%rdi)
        adcq	$0x00, %rdx
        movq	112(%rdi), %rax
        movq	%rdx, 104(%rdi)
        adcq	$0x00, %rax
        movq	120(%rdi), %rdx
        movq	%rax, 112(%rdi)
        adcq	$0x00, %rdx
        movq	%rdx, 120(%rdi)
        movq	264(%rsp), %rsi
        movq	256(%rsp), %rdi
        addq	$0x110, %rsp
        repz retq
#ifndef __APPLE__
.size	sp_2048_sqr_avx2_32,.-sp_2048_sqr_avx2_32
#endif /* __APPLE__ */
#endif /* HAVE_INTEL_AVX2 */
/* Sub b from a into a. (a -= b)
 *
 * a  A single precision integer and result.
 * b  A single precision integer.
 */
#ifndef __APPLE__
.text
.globl	sp_2048_sub_in_place_16
.type	sp_2048_sub_in_place_16,@function
.align	16
sp_2048_sub_in_place_16:
#else
.section	__TEXT,__text
.globl	_sp_2048_sub_in_place_16
.p2align	4
_sp_2048_sub_in_place_16:
#endif /* __APPLE__ */
        movq	(%rdi), %rdx
        subq	(%rsi), %rdx
        movq	8(%rdi), %rcx
        movq	%rdx, (%rdi)
        sbbq	8(%rsi), %rcx
        movq	16(%rdi), %rdx
        movq	%rcx, 8(%rdi)
        sbbq	16(%rsi), %rdx
        movq	24(%rdi), %rcx
        movq	%rdx, 16(%rdi)
        sbbq	24(%rsi), %rcx
        movq	32(%rdi), %rdx
        movq	%rcx, 24(%rdi)
        sbbq	32(%rsi), %rdx
        movq	40(%rdi), %rcx
        movq	%rdx, 32(%rdi)
        sbbq	40(%rsi), %rcx
        movq	48(%rdi), %rdx
        movq	%rcx, 40(%rdi)
        sbbq	48(%rsi), %rdx
        movq	56(%rdi), %rcx
        movq	%rdx, 48(%rdi)
        sbbq	56(%rsi), %rcx
        movq	64(%rdi), %rdx
        movq	%rcx, 56(%rdi)
        sbbq	64(%rsi), %rdx
        movq	72(%rdi), %rcx
        movq	%rdx, 64(%rdi)
        sbbq	72(%rsi), %rcx
        movq	80(%rdi), %rdx
        movq	%rcx, 72(%rdi)
        sbbq	80(%rsi), %rdx
        movq	88(%rdi), %rcx
        movq	%rdx, 80(%rdi)
        sbbq	88(%rsi), %rcx
        movq	96(%rdi), %rdx
        movq	%rcx, 88(%rdi)
        sbbq	96(%rsi), %rdx
        movq	104(%rdi), %rcx
        movq	%rdx, 96(%rdi)
        sbbq	104(%rsi), %rcx
        movq	112(%rdi), %rdx
        movq	%rcx, 104(%rdi)
        sbbq	112(%rsi), %rdx
        movq	120(%rdi), %rcx
        movq	%rdx, 112(%rdi)
        sbbq	120(%rsi), %rcx
        movq	%rcx, 120(%rdi)
        sbbq	%rax, %rax
        repz retq
#ifndef __APPLE__
.size	sp_2048_sub_in_place_16,.-sp_2048_sub_in_place_16
#endif /* __APPLE__ */
/* Mul a by digit b into r. (r = a * b)
 *
 * r  A single precision integer.
 * a  A single precision integer.
 * b  A single precision digit.
 */
#ifndef __APPLE__
.text
.globl	sp_2048_mul_d_32
.type	sp_2048_mul_d_32,@function
.align	16
sp_2048_mul_d_32:
#else
.section	__TEXT,__text
.globl	_sp_2048_mul_d_32
.p2align	4
_sp_2048_mul_d_32:
#endif /* __APPLE__ */
        movq	%rdx, %rcx
        # A[0] * B
        movq	%rcx, %rax
        xorq	%r10, %r10
        mulq	(%rsi)
        movq	%rax, %r8
        movq	%rdx, %r9
        movq	%r8, (%rdi)
        # A[1] * B
        movq	%rcx, %rax
        xorq	%r8, %r8
        mulq	8(%rsi)
        addq	%rax, %r9
        movq	%r9, 8(%rdi)
        adcq	%rdx, %r10
        adcq	$0x00, %r8
        # A[2] * B
        movq	%rcx, %rax
        xorq	%r9, %r9
        mulq	16(%rsi)
        addq	%rax, %r10
        movq	%r10, 16(%rdi)
        adcq	%rdx, %r8
        adcq	$0x00, %r9
        # A[3] * B
        movq	%rcx, %rax
        xorq	%r10, %r10
        mulq	24(%rsi)
        addq	%rax, %r8
        movq	%r8, 24(%rdi)
        adcq	%rdx, %r9
        adcq	$0x00, %r10
        # A[4] * B
        movq	%rcx, %rax
        xorq	%r8, %r8
        mulq	32(%rsi)
        addq	%rax, %r9
        movq	%r9, 32(%rdi)
        adcq	%rdx, %r10
        adcq	$0x00, %r8
        # A[5] * B
        movq	%rcx, %rax
        xorq	%r9, %r9
        mulq	40(%rsi)
        addq	%rax, %r10
        movq	%r10, 40(%rdi)
        adcq	%rdx, %r8
        adcq	$0x00, %r9
        # A[6] * B
        movq	%rcx, %rax
        xorq	%r10, %r10
        mulq	48(%rsi)
        addq	%rax, %r8
        movq	%r8, 48(%rdi)
        adcq	%rdx, %r9
        adcq	$0x00, %r10
        # A[7] * B
        movq	%rcx, %rax
        xorq	%r8, %r8
        mulq	56(%rsi)
        addq	%rax, %r9
        movq	%r9, 56(%rdi)
        adcq	%rdx, %r10
        adcq	$0x00, %r8
        # A[8] * B
        movq	%rcx, %rax
        xorq	%r9, %r9
        mulq	64(%rsi)
        addq	%rax, %r10
        movq	%r10, 64(%rdi)
        adcq	%rdx, %r8
        adcq	$0x00, %r9
        # A[9] * B
        movq	%rcx, %rax
        xorq	%r10, %r10
        mulq	72(%rsi)
        addq	%rax, %r8
        movq	%r8, 72(%rdi)
        adcq	%rdx, %r9
        adcq	$0x00, %r10
        # A[10] * B
        movq	%rcx, %rax
        xorq	%r8, %r8
        mulq	80(%rsi)
        addq	%rax, %r9
        movq	%r9, 80(%rdi)
        adcq	%rdx, %r10
        adcq	$0x00, %r8
        # A[11] * B
        movq	%rcx, %rax
        xorq	%r9, %r9
        mulq	88(%rsi)
        addq	%rax, %r10
        movq	%r10, 88(%rdi)
        adcq	%rdx, %r8
        adcq	$0x00, %r9
        # A[12] * B
        movq	%rcx, %rax
        xorq	%r10, %r10
        mulq	96(%rsi)
        addq	%rax, %r8
        movq	%r8, 96(%rdi)
        adcq	%rdx, %r9
        adcq	$0x00, %r10
        # A[13] * B
        movq	%rcx, %rax
        xorq	%r8, %r8
        mulq	104(%rsi)
        addq	%rax, %r9
        movq	%r9, 104(%rdi)
        adcq	%rdx, %r10
        adcq	$0x00, %r8
        # A[14] * B
        movq	%rcx, %rax
        xorq	%r9, %r9
        mulq	112(%rsi)
        addq	%rax, %r10
        movq	%r10, 112(%rdi)
        adcq	%rdx, %r8
        adcq	$0x00, %r9
        # A[15] * B
        movq	%rcx, %rax
        xorq	%r10, %r10
        mulq	120(%rsi)
        addq	%rax, %r8
        movq	%r8, 120(%rdi)
        adcq	%rdx, %r9
        adcq	$0x00, %r10
        # A[16] * B
        movq	%rcx, %rax
        xorq	%r8, %r8
        mulq	128(%rsi)
        addq	%rax, %r9
        movq	%r9, 128(%rdi)
        adcq	%rdx, %r10
        adcq	$0x00, %r8
        # A[17] * B
        movq	%rcx, %rax
        xorq	%r9, %r9
        mulq	136(%rsi)
        addq	%rax, %r10
        movq	%r10, 136(%rdi)
        adcq	%rdx, %r8
        adcq	$0x00, %r9
        # A[18] * B
        movq	%rcx, %rax
        xorq	%r10, %r10
        mulq	144(%rsi)
        addq	%rax, %r8
        movq	%r8, 144(%rdi)
        adcq	%rdx, %r9
        adcq	$0x00, %r10
        # A[19] * B
        movq	%rcx, %rax
        xorq	%r8, %r8
        mulq	152(%rsi)
        addq	%rax, %r9
        movq	%r9, 152(%rdi)
        adcq	%rdx, %r10
        adcq	$0x00, %r8
        # A[20] * B
        movq	%rcx, %rax
        xorq	%r9, %r9
        mulq	160(%rsi)
        addq	%rax, %r10
        movq	%r10, 160(%rdi)
        adcq	%rdx, %r8
        adcq	$0x00, %r9
        # A[21] * B
        movq	%rcx, %rax
        xorq	%r10, %r10
        mulq	168(%rsi)
        addq	%rax, %r8
        movq	%r8, 168(%rdi)
        adcq	%rdx, %r9
        adcq	$0x00, %r10
        # A[22] * B
        movq	%rcx, %rax
        xorq	%r8, %r8
        mulq	176(%rsi)
        addq	%rax, %r9
        movq	%r9, 176(%rdi)
        adcq	%rdx, %r10
        adcq	$0x00, %r8
        # A[23] * B
        movq	%rcx, %rax
        xorq	%r9, %r9
        mulq	184(%rsi)
        addq	%rax, %r10
        movq	%r10, 184(%rdi)
        adcq	%rdx, %r8
        adcq	$0x00, %r9
        # A[24] * B
        movq	%rcx, %rax
        xorq	%r10, %r10
        mulq	192(%rsi)
        addq	%rax, %r8
        movq	%r8, 192(%rdi)
        adcq	%rdx, %r9
        adcq	$0x00, %r10
        # A[25] * B
        movq	%rcx, %rax
        xorq	%r8, %r8
        mulq	200(%rsi)
        addq	%rax, %r9
        movq	%r9, 200(%rdi)
        adcq	%rdx, %r10
        adcq	$0x00, %r8
        # A[26] * B
        movq	%rcx, %rax
        xorq	%r9, %r9
        mulq	208(%rsi)
        addq	%rax, %r10
        movq	%r10, 208(%rdi)
        adcq	%rdx, %r8
        adcq	$0x00, %r9
        # A[27] * B
        movq	%rcx, %rax
        xorq	%r10, %r10
        mulq	216(%rsi)
        addq	%rax, %r8
        movq	%r8, 216(%rdi)
        adcq	%rdx, %r9
        adcq	$0x00, %r10
        # A[28] * B
        movq	%rcx, %rax
        xorq	%r8, %r8
        mulq	224(%rsi)
        addq	%rax, %r9
        movq	%r9, 224(%rdi)
        adcq	%rdx, %r10
        adcq	$0x00, %r8
        # A[29] * B
        movq	%rcx, %rax
        xorq	%r9, %r9
        mulq	232(%rsi)
        addq	%rax, %r10
        movq	%r10, 232(%rdi)
        adcq	%rdx, %r8
        adcq	$0x00, %r9
        # A[30] * B
        movq	%rcx, %rax
        xorq	%r10, %r10
        mulq	240(%rsi)
        addq	%rax, %r8
        movq	%r8, 240(%rdi)
        adcq	%rdx, %r9
        adcq	$0x00, %r10
        # A[31] * B
        movq	%rcx, %rax
        mulq	248(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        movq	%r9, 248(%rdi)
        movq	%r10, 256(%rdi)
        repz retq
#ifndef __APPLE__
.size	sp_2048_mul_d_32,.-sp_2048_mul_d_32
#endif /* __APPLE__ */
/* Conditionally subtract b from a using the mask m.
 * m is -1 to subtract and 0 when not copying.
 *
 * r  A single precision number representing condition subtract result.
 * a  A single precision number to subtract from.
 * b  A single precision number to subtract.
 * m  Mask value to apply.
 */
#ifndef __APPLE__
.text
.globl	sp_2048_cond_sub_16
.type	sp_2048_cond_sub_16,@function
.align	16
sp_2048_cond_sub_16:
#else
.section	__TEXT,__text
.globl	_sp_2048_cond_sub_16
.p2align	4
_sp_2048_cond_sub_16:
#endif /* __APPLE__ */
        subq	$0x80, %rsp
        movq	(%rdx), %r8
        movq	8(%rdx), %r9
        andq	%rcx, %r8
        andq	%rcx, %r9
        movq	%r8, (%rsp)
        movq	%r9, 8(%rsp)
        movq	16(%rdx), %r8
        movq	24(%rdx), %r9
        andq	%rcx, %r8
        andq	%rcx, %r9
        movq	%r8, 16(%rsp)
        movq	%r9, 24(%rsp)
        movq	32(%rdx), %r8
        movq	40(%rdx), %r9
        andq	%rcx, %r8
        andq	%rcx, %r9
        movq	%r8, 32(%rsp)
        movq	%r9, 40(%rsp)
        movq	48(%rdx), %r8
        movq	56(%rdx), %r9
        andq	%rcx, %r8
        andq	%rcx, %r9
        movq	%r8, 48(%rsp)
        movq	%r9, 56(%rsp)
        movq	64(%rdx), %r8
        movq	72(%rdx), %r9
        andq	%rcx, %r8
        andq	%rcx, %r9
        movq	%r8, 64(%rsp)
        movq	%r9, 72(%rsp)
        movq	80(%rdx), %r8
        movq	88(%rdx), %r9
        andq	%rcx, %r8
        andq	%rcx, %r9
        movq	%r8, 80(%rsp)
        movq	%r9, 88(%rsp)
        movq	96(%rdx), %r8
        movq	104(%rdx), %r9
        andq	%rcx, %r8
        andq	%rcx, %r9
        movq	%r8, 96(%rsp)
        movq	%r9, 104(%rsp)
        movq	112(%rdx), %r8
        movq	120(%rdx), %r9
        andq	%rcx, %r8
        andq	%rcx, %r9
        movq	%r8, 112(%rsp)
        movq	%r9, 120(%rsp)
        movq	(%rsi), %r8
        movq	(%rsp), %rdx
        subq	%rdx, %r8
        movq	8(%rsi), %r9
        movq	8(%rsp), %rdx
        sbbq	%rdx, %r9
        movq	%r8, (%rdi)
        movq	16(%rsi), %r8
        movq	16(%rsp), %rdx
        sbbq	%rdx, %r8
        movq	%r9, 8(%rdi)
        movq	24(%rsi), %r9
        movq	24(%rsp), %rdx
        sbbq	%rdx, %r9
        movq	%r8, 16(%rdi)
        movq	32(%rsi), %r8
        movq	32(%rsp), %rdx
        sbbq	%rdx, %r8
        movq	%r9, 24(%rdi)
        movq	40(%rsi), %r9
        movq	40(%rsp), %rdx
        sbbq	%rdx, %r9
        movq	%r8, 32(%rdi)
        movq	48(%rsi), %r8
        movq	48(%rsp), %rdx
        sbbq	%rdx, %r8
        movq	%r9, 40(%rdi)
        movq	56(%rsi), %r9
        movq	56(%rsp), %rdx
        sbbq	%rdx, %r9
        movq	%r8, 48(%rdi)
        movq	64(%rsi), %r8
        movq	64(%rsp), %rdx
        sbbq	%rdx, %r8
        movq	%r9, 56(%rdi)
        movq	72(%rsi), %r9
        movq	72(%rsp), %rdx
        sbbq	%rdx, %r9
        movq	%r8, 64(%rdi)
        movq	80(%rsi), %r8
        movq	80(%rsp), %rdx
        sbbq	%rdx, %r8
        movq	%r9, 72(%rdi)
        movq	88(%rsi), %r9
        movq	88(%rsp), %rdx
        sbbq	%rdx, %r9
        movq	%r8, 80(%rdi)
        movq	96(%rsi), %r8
        movq	96(%rsp), %rdx
        sbbq	%rdx, %r8
        movq	%r9, 88(%rdi)
        movq	104(%rsi), %r9
        movq	104(%rsp), %rdx
        sbbq	%rdx, %r9
        movq	%r8, 96(%rdi)
        movq	112(%rsi), %r8
        movq	112(%rsp), %rdx
        sbbq	%rdx, %r8
        movq	%r9, 104(%rdi)
        movq	120(%rsi), %r9
        movq	120(%rsp), %rdx
        sbbq	%rdx, %r9
        movq	%r8, 112(%rdi)
        movq	%r9, 120(%rdi)
        sbbq	%rax, %rax
        addq	$0x80, %rsp
        repz retq
#ifndef __APPLE__
.size	sp_2048_cond_sub_16,.-sp_2048_cond_sub_16
#endif /* __APPLE__ */
/* Reduce the number back to 2048 bits using Montgomery reduction.
 *
 * a   A single precision number to reduce in place.
 * m   The single precision number representing the modulus.
 * mp  The digit representing the negative inverse of m mod 2^n.
 */
#ifndef __APPLE__
.text
.globl	sp_2048_mont_reduce_16
.type	sp_2048_mont_reduce_16,@function
.align	16
sp_2048_mont_reduce_16:
#else
.section	__TEXT,__text
.globl	_sp_2048_mont_reduce_16
.p2align	4
_sp_2048_mont_reduce_16:
#endif /* __APPLE__ */
        pushq	%r12
        pushq	%r13
        pushq	%r14
        pushq	%r15
        movq	%rdx, %rcx
        xorq	%r15, %r15
        # i = 16
        movq	$16, %r8
        movq	(%rdi), %r13
        movq	8(%rdi), %r14
L_2048_mont_reduce_16_loop:
        # mu = a[i] * mp
        movq	%r13, %r11
        imulq	%rcx, %r11
        # a[i+0] += m[0] * mu
        movq	%r11, %rax
        xorq	%r10, %r10
        mulq	(%rsi)
        addq	%rax, %r13
        adcq	%rdx, %r10
        # a[i+1] += m[1] * mu
        movq	%r11, %rax
        xorq	%r9, %r9
        mulq	8(%rsi)
        movq	%r14, %r13
        addq	%rax, %r13
        adcq	%rdx, %r9
        addq	%r10, %r13
        adcq	$0x00, %r9
        # a[i+2] += m[2] * mu
        movq	%r11, %rax
        xorq	%r10, %r10
        mulq	16(%rsi)
        movq	16(%rdi), %r14
        addq	%rax, %r14
        adcq	%rdx, %r10
        addq	%r9, %r14
        adcq	$0x00, %r10
        # a[i+3] += m[3] * mu
        movq	%r11, %rax
        xorq	%r9, %r9
        mulq	24(%rsi)
        movq	24(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r9
        addq	%r10, %r12
        movq	%r12, 24(%rdi)
        adcq	$0x00, %r9
        # a[i+4] += m[4] * mu
        movq	%r11, %rax
        xorq	%r10, %r10
        mulq	32(%rsi)
        movq	32(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r10
        addq	%r9, %r12
        movq	%r12, 32(%rdi)
        adcq	$0x00, %r10
        # a[i+5] += m[5] * mu
        movq	%r11, %rax
        xorq	%r9, %r9
        mulq	40(%rsi)
        movq	40(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r9
        addq	%r10, %r12
        movq	%r12, 40(%rdi)
        adcq	$0x00, %r9
        # a[i+6] += m[6] * mu
        movq	%r11, %rax
        xorq	%r10, %r10
        mulq	48(%rsi)
        movq	48(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r10
        addq	%r9, %r12
        movq	%r12, 48(%rdi)
        adcq	$0x00, %r10
        # a[i+7] += m[7] * mu
        movq	%r11, %rax
        xorq	%r9, %r9
        mulq	56(%rsi)
        movq	56(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r9
        addq	%r10, %r12
        movq	%r12, 56(%rdi)
        adcq	$0x00, %r9
        # a[i+8] += m[8] * mu
        movq	%r11, %rax
        xorq	%r10, %r10
        mulq	64(%rsi)
        movq	64(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r10
        addq	%r9, %r12
        movq	%r12, 64(%rdi)
        adcq	$0x00, %r10
        # a[i+9] += m[9] * mu
        movq	%r11, %rax
        xorq	%r9, %r9
        mulq	72(%rsi)
        movq	72(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r9
        addq	%r10, %r12
        movq	%r12, 72(%rdi)
        adcq	$0x00, %r9
        # a[i+10] += m[10] * mu
        movq	%r11, %rax
        xorq	%r10, %r10
        mulq	80(%rsi)
        movq	80(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r10
        addq	%r9, %r12
        movq	%r12, 80(%rdi)
        adcq	$0x00, %r10
        # a[i+11] += m[11] * mu
        movq	%r11, %rax
        xorq	%r9, %r9
        mulq	88(%rsi)
        movq	88(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r9
        addq	%r10, %r12
        movq	%r12, 88(%rdi)
        adcq	$0x00, %r9
        # a[i+12] += m[12] * mu
        movq	%r11, %rax
        xorq	%r10, %r10
        mulq	96(%rsi)
        movq	96(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r10
        addq	%r9, %r12
        movq	%r12, 96(%rdi)
        adcq	$0x00, %r10
        # a[i+13] += m[13] * mu
        movq	%r11, %rax
        xorq	%r9, %r9
        mulq	104(%rsi)
        movq	104(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r9
        addq	%r10, %r12
        movq	%r12, 104(%rdi)
        adcq	$0x00, %r9
        # a[i+14] += m[14] * mu
        movq	%r11, %rax
        xorq	%r10, %r10
        mulq	112(%rsi)
        movq	112(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r10
        addq	%r9, %r12
        movq	%r12, 112(%rdi)
        adcq	$0x00, %r10
        # a[i+15] += m[15] * mu
        movq	%r11, %rax
        mulq	120(%rsi)
        movq	120(%rdi), %r12
        addq	%rax, %r10
        adcq	%r15, %rdx
        movq	$0x00, %r15
        adcq	$0x00, %r15
        addq	%r10, %r12
        movq	%r12, 120(%rdi)
        adcq	%rdx, 128(%rdi)
        adcq	$0x00, %r15
        # i -= 1
        addq	$8, %rdi
        decq	%r8
        jnz	L_2048_mont_reduce_16_loop
        movq	%r13, (%rdi)
        movq	%r14, 8(%rdi)
        negq	%r15
#ifdef _WIN64
        movq	%rsi, %rdx
        movq	%r15, %rcx
#else
        movq	%r15, %rcx
        movq	%rsi, %rdx
#endif /* _WIN64 */
        movq	%rdi, %rsi
        movq	%rdi, %rdi
        subq	$0x80, %rdi
#ifndef __APPLE__
        callq	sp_2048_cond_sub_16@plt
#else
        callq	_sp_2048_cond_sub_16
#endif /* __APPLE__ */
        popq	%r15
        popq	%r14
        popq	%r13
        popq	%r12
        repz retq
#ifndef __APPLE__
.size	sp_2048_mont_reduce_16,.-sp_2048_mont_reduce_16
#endif /* __APPLE__ */
#ifdef HAVE_INTEL_AVX2
/* Conditionally subtract b from a using the mask m.
 * m is -1 to subtract and 0 when not copying.
 *
 * r  A single precision number representing condition subtract result.
 * a  A single precision number to subtract from.
 * b  A single precision number to subtract.
 * m  Mask value to apply.
 */
#ifndef __APPLE__
.text
.globl	sp_2048_cond_sub_avx2_16
.type	sp_2048_cond_sub_avx2_16,@function
.align	16
sp_2048_cond_sub_avx2_16:
#else
.section	__TEXT,__text
.globl	_sp_2048_cond_sub_avx2_16
.p2align	4
_sp_2048_cond_sub_avx2_16:
#endif /* __APPLE__ */
        movq	(%rdx), %r10
        movq	(%rsi), %r8
        pextq	%rcx, %r10, %r10
        subq	%r10, %r8
        movq	8(%rdx), %r10
        movq	8(%rsi), %r9
        pextq	%rcx, %r10, %r10
        movq	%r8, (%rdi)
        sbbq	%r10, %r9
        movq	16(%rdx), %r8
        movq	16(%rsi), %r10
        pextq	%rcx, %r8, %r8
        movq	%r9, 8(%rdi)
        sbbq	%r8, %r10
        movq	24(%rdx), %r9
        movq	24(%rsi), %r8
        pextq	%rcx, %r9, %r9
        movq	%r10, 16(%rdi)
        sbbq	%r9, %r8
        movq	32(%rdx), %r10
        movq	32(%rsi), %r9
        pextq	%rcx, %r10, %r10
        movq	%r8, 24(%rdi)
        sbbq	%r10, %r9
        movq	40(%rdx), %r8
        movq	40(%rsi), %r10
        pextq	%rcx, %r8, %r8
        movq	%r9, 32(%rdi)
        sbbq	%r8, %r10
        movq	48(%rdx), %r9
        movq	48(%rsi), %r8
        pextq	%rcx, %r9, %r9
        movq	%r10, 40(%rdi)
        sbbq	%r9, %r8
        movq	56(%rdx), %r10
        movq	56(%rsi), %r9
        pextq	%rcx, %r10, %r10
        movq	%r8, 48(%rdi)
        sbbq	%r10, %r9
        movq	64(%rdx), %r8
        movq	64(%rsi), %r10
        pextq	%rcx, %r8, %r8
        movq	%r9, 56(%rdi)
        sbbq	%r8, %r10
        movq	72(%rdx), %r9
        movq	72(%rsi), %r8
        pextq	%rcx, %r9, %r9
        movq	%r10, 64(%rdi)
        sbbq	%r9, %r8
        movq	80(%rdx), %r10
        movq	80(%rsi), %r9
        pextq	%rcx, %r10, %r10
        movq	%r8, 72(%rdi)
        sbbq	%r10, %r9
        movq	88(%rdx), %r8
        movq	88(%rsi), %r10
        pextq	%rcx, %r8, %r8
        movq	%r9, 80(%rdi)
        sbbq	%r8, %r10
        movq	96(%rdx), %r9
        movq	96(%rsi), %r8
        pextq	%rcx, %r9, %r9
        movq	%r10, 88(%rdi)
        sbbq	%r9, %r8
        movq	104(%rdx), %r10
        movq	104(%rsi), %r9
        pextq	%rcx, %r10, %r10
        movq	%r8, 96(%rdi)
        sbbq	%r10, %r9
        movq	112(%rdx), %r8
        movq	112(%rsi), %r10
        pextq	%rcx, %r8, %r8
        movq	%r9, 104(%rdi)
        sbbq	%r8, %r10
        movq	120(%rdx), %r9
        movq	120(%rsi), %r8
        pextq	%rcx, %r9, %r9
        movq	%r10, 112(%rdi)
        sbbq	%r9, %r8
        movq	%r8, 120(%rdi)
        sbbq	%rax, %rax
        repz retq
#ifndef __APPLE__
.size	sp_2048_cond_sub_avx2_16,.-sp_2048_cond_sub_avx2_16
#endif /* __APPLE__ */
#endif /* HAVE_INTEL_AVX2 */
/* Mul a by digit b into r. (r = a * b)
 *
 * r  A single precision integer.
 * a  A single precision integer.
 * b  A single precision digit.
 */
#ifndef __APPLE__
.text
.globl	sp_2048_mul_d_16
.type	sp_2048_mul_d_16,@function
.align	16
sp_2048_mul_d_16:
#else
.section	__TEXT,__text
.globl	_sp_2048_mul_d_16
.p2align	4
_sp_2048_mul_d_16:
#endif /* __APPLE__ */
        movq	%rdx, %rcx
        # A[0] * B
        movq	%rcx, %rax
        xorq	%r10, %r10
        mulq	(%rsi)
        movq	%rax, %r8
        movq	%rdx, %r9
        movq	%r8, (%rdi)
        # A[1] * B
        movq	%rcx, %rax
        xorq	%r8, %r8
        mulq	8(%rsi)
        addq	%rax, %r9
        movq	%r9, 8(%rdi)
        adcq	%rdx, %r10
        adcq	$0x00, %r8
        # A[2] * B
        movq	%rcx, %rax
        xorq	%r9, %r9
        mulq	16(%rsi)
        addq	%rax, %r10
        movq	%r10, 16(%rdi)
        adcq	%rdx, %r8
        adcq	$0x00, %r9
        # A[3] * B
        movq	%rcx, %rax
        xorq	%r10, %r10
        mulq	24(%rsi)
        addq	%rax, %r8
        movq	%r8, 24(%rdi)
        adcq	%rdx, %r9
        adcq	$0x00, %r10
        # A[4] * B
        movq	%rcx, %rax
        xorq	%r8, %r8
        mulq	32(%rsi)
        addq	%rax, %r9
        movq	%r9, 32(%rdi)
        adcq	%rdx, %r10
        adcq	$0x00, %r8
        # A[5] * B
        movq	%rcx, %rax
        xorq	%r9, %r9
        mulq	40(%rsi)
        addq	%rax, %r10
        movq	%r10, 40(%rdi)
        adcq	%rdx, %r8
        adcq	$0x00, %r9
        # A[6] * B
        movq	%rcx, %rax
        xorq	%r10, %r10
        mulq	48(%rsi)
        addq	%rax, %r8
        movq	%r8, 48(%rdi)
        adcq	%rdx, %r9
        adcq	$0x00, %r10
        # A[7] * B
        movq	%rcx, %rax
        xorq	%r8, %r8
        mulq	56(%rsi)
        addq	%rax, %r9
        movq	%r9, 56(%rdi)
        adcq	%rdx, %r10
        adcq	$0x00, %r8
        # A[8] * B
        movq	%rcx, %rax
        xorq	%r9, %r9
        mulq	64(%rsi)
        addq	%rax, %r10
        movq	%r10, 64(%rdi)
        adcq	%rdx, %r8
        adcq	$0x00, %r9
        # A[9] * B
        movq	%rcx, %rax
        xorq	%r10, %r10
        mulq	72(%rsi)
        addq	%rax, %r8
        movq	%r8, 72(%rdi)
        adcq	%rdx, %r9
        adcq	$0x00, %r10
        # A[10] * B
        movq	%rcx, %rax
        xorq	%r8, %r8
        mulq	80(%rsi)
        addq	%rax, %r9
        movq	%r9, 80(%rdi)
        adcq	%rdx, %r10
        adcq	$0x00, %r8
        # A[11] * B
        movq	%rcx, %rax
        xorq	%r9, %r9
        mulq	88(%rsi)
        addq	%rax, %r10
        movq	%r10, 88(%rdi)
        adcq	%rdx, %r8
        adcq	$0x00, %r9
        # A[12] * B
        movq	%rcx, %rax
        xorq	%r10, %r10
        mulq	96(%rsi)
        addq	%rax, %r8
        movq	%r8, 96(%rdi)
        adcq	%rdx, %r9
        adcq	$0x00, %r10
        # A[13] * B
        movq	%rcx, %rax
        xorq	%r8, %r8
        mulq	104(%rsi)
        addq	%rax, %r9
        movq	%r9, 104(%rdi)
        adcq	%rdx, %r10
        adcq	$0x00, %r8
        # A[14] * B
        movq	%rcx, %rax
        xorq	%r9, %r9
        mulq	112(%rsi)
        addq	%rax, %r10
        movq	%r10, 112(%rdi)
        adcq	%rdx, %r8
        adcq	$0x00, %r9
        # A[15] * B
        movq	%rcx, %rax
        mulq	120(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        movq	%r8, 120(%rdi)
        movq	%r9, 128(%rdi)
        repz retq
#ifndef __APPLE__
.size	sp_2048_mul_d_16,.-sp_2048_mul_d_16
#endif /* __APPLE__ */
#ifdef HAVE_INTEL_AVX2
/* Mul a by digit b into r. (r = a * b)
 *
 * r  A single precision integer.
 * a  A single precision integer.
 * b  A single precision digit.
 */
#ifndef __APPLE__
.text
.globl	sp_2048_mul_d_avx2_16
.type	sp_2048_mul_d_avx2_16,@function
.align	16
sp_2048_mul_d_avx2_16:
#else
.section	__TEXT,__text
.globl	_sp_2048_mul_d_avx2_16
.p2align	4
_sp_2048_mul_d_avx2_16:
#endif /* __APPLE__ */
        movq	%rdx, %rax
        # A[0] * B
        movq	%rax, %rdx
        xorq	%r11, %r11
        mulxq	(%rsi), %r9, %r10
        movq	%r9, (%rdi)
        # A[1] * B
        mulxq	8(%rsi), %rcx, %r8
        movq	%r11, %r9
        adcxq	%rcx, %r10
        adoxq	%r8, %r9
        movq	%r10, 8(%rdi)
        # A[2] * B
        mulxq	16(%rsi), %rcx, %r8
        movq	%r11, %r10
        adcxq	%rcx, %r9
        adoxq	%r8, %r10
        movq	%r9, 16(%rdi)
        # A[3] * B
        mulxq	24(%rsi), %rcx, %r8
        movq	%r11, %r9
        adcxq	%rcx, %r10
        adoxq	%r8, %r9
        movq	%r10, 24(%rdi)
        # A[4] * B
        mulxq	32(%rsi), %rcx, %r8
        movq	%r11, %r10
        adcxq	%rcx, %r9
        adoxq	%r8, %r10
        movq	%r9, 32(%rdi)
        # A[5] * B
        mulxq	40(%rsi), %rcx, %r8
        movq	%r11, %r9
        adcxq	%rcx, %r10
        adoxq	%r8, %r9
        movq	%r10, 40(%rdi)
        # A[6] * B
        mulxq	48(%rsi), %rcx, %r8
        movq	%r11, %r10
        adcxq	%rcx, %r9
        adoxq	%r8, %r10
        movq	%r9, 48(%rdi)
        # A[7] * B
        mulxq	56(%rsi), %rcx, %r8
        movq	%r11, %r9
        adcxq	%rcx, %r10
        adoxq	%r8, %r9
        movq	%r10, 56(%rdi)
        # A[8] * B
        mulxq	64(%rsi), %rcx, %r8
        movq	%r11, %r10
        adcxq	%rcx, %r9
        adoxq	%r8, %r10
        movq	%r9, 64(%rdi)
        # A[9] * B
        mulxq	72(%rsi), %rcx, %r8
        movq	%r11, %r9
        adcxq	%rcx, %r10
        adoxq	%r8, %r9
        movq	%r10, 72(%rdi)
        # A[10] * B
        mulxq	80(%rsi), %rcx, %r8
        movq	%r11, %r10
        adcxq	%rcx, %r9
        adoxq	%r8, %r10
        movq	%r9, 80(%rdi)
        # A[11] * B
        mulxq	88(%rsi), %rcx, %r8
        movq	%r11, %r9
        adcxq	%rcx, %r10
        adoxq	%r8, %r9
        movq	%r10, 88(%rdi)
        # A[12] * B
        mulxq	96(%rsi), %rcx, %r8
        movq	%r11, %r10
        adcxq	%rcx, %r9
        adoxq	%r8, %r10
        movq	%r9, 96(%rdi)
        # A[13] * B
        mulxq	104(%rsi), %rcx, %r8
        movq	%r11, %r9
        adcxq	%rcx, %r10
        adoxq	%r8, %r9
        movq	%r10, 104(%rdi)
        # A[14] * B
        mulxq	112(%rsi), %rcx, %r8
        movq	%r11, %r10
        adcxq	%rcx, %r9
        adoxq	%r8, %r10
        movq	%r9, 112(%rdi)
        # A[15] * B
        mulxq	120(%rsi), %rcx, %r8
        movq	%r11, %r9
        adcxq	%rcx, %r10
        adoxq	%r8, %r9
        adcxq	%r11, %r9
        movq	%r10, 120(%rdi)
        movq	%r9, 128(%rdi)
        repz retq
#ifndef __APPLE__
.size	sp_2048_mul_d_avx2_16,.-sp_2048_mul_d_avx2_16
#endif /* __APPLE__ */
#endif /* HAVE_INTEL_AVX2 */
#ifdef _WIN64
/* Divide the double width number (d1|d0) by the dividend. (d1|d0 / div)
 *
 * d1   The high order half of the number to divide.
 * d0   The low order half of the number to divide.
 * div  The dividend.
 * returns the result of the division.
 */
#ifndef __APPLE__
.text
.globl	div_2048_word_asm_16
.type	div_2048_word_asm_16,@function
.align	16
div_2048_word_asm_16:
#else
.section	__TEXT,__text
.globl	_div_2048_word_asm_16
.p2align	4
_div_2048_word_asm_16:
#endif /* __APPLE__ */
        movq	%rdx, %rcx
        movq	%rsi, %rax
        movq	%rdi, %rdx
        divq	%rcx
        repz retq
#ifndef __APPLE__
.size	div_2048_word_asm_16,.-div_2048_word_asm_16
#endif /* __APPLE__ */
#endif /* _WIN64 */
/* Compare a with b in constant time.
 *
 * a  A single precision integer.
 * b  A single precision integer.
 * return -ve, 0 or +ve if a is less than, equal to or greater than b
 * respectively.
 */
#ifndef __APPLE__
.text
.globl	sp_2048_cmp_16
.type	sp_2048_cmp_16,@function
.align	16
sp_2048_cmp_16:
#else
.section	__TEXT,__text
.globl	_sp_2048_cmp_16
.p2align	4
_sp_2048_cmp_16:
#endif /* __APPLE__ */
        xorq	%rcx, %rcx
        movq	$-1, %rdx
        movq	$-1, %rax
        movq	$0x01, %r8
        movq	120(%rdi), %r9
        movq	120(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	112(%rdi), %r9
        movq	112(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	104(%rdi), %r9
        movq	104(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	96(%rdi), %r9
        movq	96(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	88(%rdi), %r9
        movq	88(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	80(%rdi), %r9
        movq	80(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	72(%rdi), %r9
        movq	72(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	64(%rdi), %r9
        movq	64(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	56(%rdi), %r9
        movq	56(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	48(%rdi), %r9
        movq	48(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	40(%rdi), %r9
        movq	40(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	32(%rdi), %r9
        movq	32(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	24(%rdi), %r9
        movq	24(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	16(%rdi), %r9
        movq	16(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	8(%rdi), %r9
        movq	8(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	(%rdi), %r9
        movq	(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        xorq	%rdx, %rax
        repz retq
#ifndef __APPLE__
.size	sp_2048_cmp_16,.-sp_2048_cmp_16
#endif /* __APPLE__ */
#ifndef WC_NO_CACHE_RESISTANT
#ifndef __APPLE__
.text
.globl	sp_2048_get_from_table_16
.type	sp_2048_get_from_table_16,@function
.align	16
sp_2048_get_from_table_16:
#else
.section	__TEXT,__text
.globl	_sp_2048_get_from_table_16
.p2align	4
_sp_2048_get_from_table_16:
#endif /* __APPLE__ */
        movq	$0x01, %rax
        movd	%rdx, %xmm10
        movd	%rax, %xmm11
        pxor	%xmm13, %xmm13
        pshufd	$0x00, %xmm11, %xmm11
        pshufd	$0x00, %xmm10, %xmm10
        # START: 0-7
        pxor	%xmm13, %xmm13
        pxor	%xmm4, %xmm4
        pxor	%xmm5, %xmm5
        pxor	%xmm6, %xmm6
        pxor	%xmm7, %xmm7
        # ENTRY: 0
        movq	(%rsi), %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 1
        movq	8(%rsi), %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 2
        movq	16(%rsi), %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 3
        movq	24(%rsi), %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 4
        movq	32(%rsi), %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 5
        movq	40(%rsi), %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 6
        movq	48(%rsi), %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 7
        movq	56(%rsi), %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 8
        movq	64(%rsi), %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 9
        movq	72(%rsi), %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 10
        movq	80(%rsi), %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 11
        movq	88(%rsi), %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 12
        movq	96(%rsi), %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 13
        movq	104(%rsi), %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 14
        movq	112(%rsi), %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 15
        movq	120(%rsi), %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 16
        movq	128(%rsi), %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 17
        movq	136(%rsi), %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 18
        movq	144(%rsi), %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 19
        movq	152(%rsi), %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 20
        movq	160(%rsi), %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 21
        movq	168(%rsi), %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 22
        movq	176(%rsi), %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 23
        movq	184(%rsi), %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 24
        movq	192(%rsi), %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 25
        movq	200(%rsi), %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 26
        movq	208(%rsi), %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 27
        movq	216(%rsi), %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 28
        movq	224(%rsi), %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 29
        movq	232(%rsi), %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 30
        movq	240(%rsi), %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 31
        movq	248(%rsi), %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        movdqu	%xmm4, (%rdi)
        movdqu	%xmm5, 16(%rdi)
        movdqu	%xmm6, 32(%rdi)
        movdqu	%xmm7, 48(%rdi)
        addq	$0x40, %rdi
        # END: 0-7
        # START: 8-15
        pxor	%xmm13, %xmm13
        pxor	%xmm4, %xmm4
        pxor	%xmm5, %xmm5
        pxor	%xmm6, %xmm6
        pxor	%xmm7, %xmm7
        # ENTRY: 0
        movq	(%rsi), %rcx
        addq	$0x40, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 1
        movq	8(%rsi), %rcx
        addq	$0x40, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 2
        movq	16(%rsi), %rcx
        addq	$0x40, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 3
        movq	24(%rsi), %rcx
        addq	$0x40, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 4
        movq	32(%rsi), %rcx
        addq	$0x40, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 5
        movq	40(%rsi), %rcx
        addq	$0x40, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 6
        movq	48(%rsi), %rcx
        addq	$0x40, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 7
        movq	56(%rsi), %rcx
        addq	$0x40, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 8
        movq	64(%rsi), %rcx
        addq	$0x40, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 9
        movq	72(%rsi), %rcx
        addq	$0x40, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 10
        movq	80(%rsi), %rcx
        addq	$0x40, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 11
        movq	88(%rsi), %rcx
        addq	$0x40, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 12
        movq	96(%rsi), %rcx
        addq	$0x40, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 13
        movq	104(%rsi), %rcx
        addq	$0x40, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 14
        movq	112(%rsi), %rcx
        addq	$0x40, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 15
        movq	120(%rsi), %rcx
        addq	$0x40, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 16
        movq	128(%rsi), %rcx
        addq	$0x40, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 17
        movq	136(%rsi), %rcx
        addq	$0x40, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 18
        movq	144(%rsi), %rcx
        addq	$0x40, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 19
        movq	152(%rsi), %rcx
        addq	$0x40, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 20
        movq	160(%rsi), %rcx
        addq	$0x40, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 21
        movq	168(%rsi), %rcx
        addq	$0x40, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 22
        movq	176(%rsi), %rcx
        addq	$0x40, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 23
        movq	184(%rsi), %rcx
        addq	$0x40, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 24
        movq	192(%rsi), %rcx
        addq	$0x40, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 25
        movq	200(%rsi), %rcx
        addq	$0x40, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 26
        movq	208(%rsi), %rcx
        addq	$0x40, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 27
        movq	216(%rsi), %rcx
        addq	$0x40, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 28
        movq	224(%rsi), %rcx
        addq	$0x40, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 29
        movq	232(%rsi), %rcx
        addq	$0x40, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 30
        movq	240(%rsi), %rcx
        addq	$0x40, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 31
        movq	248(%rsi), %rcx
        addq	$0x40, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        movdqu	%xmm4, (%rdi)
        movdqu	%xmm5, 16(%rdi)
        movdqu	%xmm6, 32(%rdi)
        movdqu	%xmm7, 48(%rdi)
        # END: 8-15
        repz retq
#ifndef __APPLE__
.size	sp_2048_get_from_table_16,.-sp_2048_get_from_table_16
#endif /* __APPLE__ */
#endif /* !WC_NO_CACHE_RESISTANT */
#ifdef HAVE_INTEL_AVX2
/* Reduce the number back to 2048 bits using Montgomery reduction.
 *
 * a   A single precision number to reduce in place.
 * m   The single precision number representing the modulus.
 * mp  The digit representing the negative inverse of m mod 2^n.
 */
#ifndef __APPLE__
.text
.globl	sp_2048_mont_reduce_avx2_16
.type	sp_2048_mont_reduce_avx2_16,@function
.align	16
sp_2048_mont_reduce_avx2_16:
#else
.section	__TEXT,__text
.globl	_sp_2048_mont_reduce_avx2_16
.p2align	4
_sp_2048_mont_reduce_avx2_16:
#endif /* __APPLE__ */
        pushq	%r12
        pushq	%r13
        pushq	%r14
        pushq	%r15
        pushq	%rbx
        pushq	%rbp
        movq	%rdx, %r8
        xorq	%rbp, %rbp
        # i = 16
        movq	$16, %r9
        movq	(%rdi), %r12
        movq	8(%rdi), %r13
        movq	16(%rdi), %r14
        movq	24(%rdi), %r15
        addq	$0x40, %rdi
        xorq	%rbp, %rbp
L_2048_mont_reduce_avx2_16_loop:
        # mu = a[i] * mp
        movq	%r12, %rdx
        movq	%r12, %r10
        imulq	%r8, %rdx
        xorq	%rbx, %rbx
        # a[i+0] += m[0] * mu
        mulxq	(%rsi), %rax, %rcx
        movq	%r13, %r12
        adcxq	%rax, %r10
        adoxq	%rcx, %r12
        # a[i+1] += m[1] * mu
        mulxq	8(%rsi), %rax, %rcx
        movq	%r14, %r13
        adcxq	%rax, %r12
        adoxq	%rcx, %r13
        # a[i+2] += m[2] * mu
        mulxq	16(%rsi), %rax, %rcx
        movq	%r15, %r14
        adcxq	%rax, %r13
        adoxq	%rcx, %r14
        # a[i+3] += m[3] * mu
        mulxq	24(%rsi), %rax, %rcx
        movq	-32(%rdi), %r15
        adcxq	%rax, %r14
        adoxq	%rcx, %r15
        # a[i+4] += m[4] * mu
        mulxq	32(%rsi), %rax, %rcx
        movq	-24(%rdi), %r11
        adcxq	%rax, %r15
        adoxq	%rcx, %r11
        # a[i+5] += m[5] * mu
        mulxq	40(%rsi), %rax, %rcx
        movq	-16(%rdi), %r10
        adcxq	%rax, %r11
        adoxq	%rcx, %r10
        movq	%r11, -24(%rdi)
        # a[i+6] += m[6] * mu
        mulxq	48(%rsi), %rax, %rcx
        movq	-8(%rdi), %r11
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        movq	%r10, -16(%rdi)
        # a[i+7] += m[7] * mu
        mulxq	56(%rsi), %rax, %rcx
        movq	(%rdi), %r10
        adcxq	%rax, %r11
        adoxq	%rcx, %r10
        movq	%r11, -8(%rdi)
        # a[i+8] += m[8] * mu
        mulxq	64(%rsi), %rax, %rcx
        movq	8(%rdi), %r11
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        movq	%r10, (%rdi)
        # a[i+9] += m[9] * mu
        mulxq	72(%rsi), %rax, %rcx
        movq	16(%rdi), %r10
        adcxq	%rax, %r11
        adoxq	%rcx, %r10
        movq	%r11, 8(%rdi)
        # a[i+10] += m[10] * mu
        mulxq	80(%rsi), %rax, %rcx
        movq	24(%rdi), %r11
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        movq	%r10, 16(%rdi)
        # a[i+11] += m[11] * mu
        mulxq	88(%rsi), %rax, %rcx
        movq	32(%rdi), %r10
        adcxq	%rax, %r11
        adoxq	%rcx, %r10
        movq	%r11, 24(%rdi)
        # a[i+12] += m[12] * mu
        mulxq	96(%rsi), %rax, %rcx
        movq	40(%rdi), %r11
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        movq	%r10, 32(%rdi)
        # a[i+13] += m[13] * mu
        mulxq	104(%rsi), %rax, %rcx
        movq	48(%rdi), %r10
        adcxq	%rax, %r11
        adoxq	%rcx, %r10
        movq	%r11, 40(%rdi)
        # a[i+14] += m[14] * mu
        mulxq	112(%rsi), %rax, %rcx
        movq	56(%rdi), %r11
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        movq	%r10, 48(%rdi)
        # a[i+15] += m[15] * mu
        mulxq	120(%rsi), %rax, %rcx
        movq	64(%rdi), %r10
        adcxq	%rax, %r11
        adoxq	%rcx, %r10
        movq	%r11, 56(%rdi)
        adcxq	%rbp, %r10
        movq	%rbx, %rbp
        movq	%r10, 64(%rdi)
        adoxq	%rbx, %rbp
        adcxq	%rbx, %rbp
        # mu = a[i] * mp
        movq	%r12, %rdx
        movq	%r12, %r10
        imulq	%r8, %rdx
        xorq	%rbx, %rbx
        # a[i+0] += m[0] * mu
        mulxq	(%rsi), %rax, %rcx
        movq	%r13, %r12
        adcxq	%rax, %r10
        adoxq	%rcx, %r12
        # a[i+1] += m[1] * mu
        mulxq	8(%rsi), %rax, %rcx
        movq	%r14, %r13
        adcxq	%rax, %r12
        adoxq	%rcx, %r13
        # a[i+2] += m[2] * mu
        mulxq	16(%rsi), %rax, %rcx
        movq	%r15, %r14
        adcxq	%rax, %r13
        adoxq	%rcx, %r14
        # a[i+3] += m[3] * mu
        mulxq	24(%rsi), %rax, %rcx
        movq	-24(%rdi), %r15
        adcxq	%rax, %r14
        adoxq	%rcx, %r15
        # a[i+4] += m[4] * mu
        mulxq	32(%rsi), %rax, %rcx
        movq	-16(%rdi), %r11
        adcxq	%rax, %r15
        adoxq	%rcx, %r11
        # a[i+5] += m[5] * mu
        mulxq	40(%rsi), %rax, %rcx
        movq	-8(%rdi), %r10
        adcxq	%rax, %r11
        adoxq	%rcx, %r10
        movq	%r11, -16(%rdi)
        # a[i+6] += m[6] * mu
        mulxq	48(%rsi), %rax, %rcx
        movq	(%rdi), %r11
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        movq	%r10, -8(%rdi)
        # a[i+7] += m[7] * mu
        mulxq	56(%rsi), %rax, %rcx
        movq	8(%rdi), %r10
        adcxq	%rax, %r11
        adoxq	%rcx, %r10
        movq	%r11, (%rdi)
        # a[i+8] += m[8] * mu
        mulxq	64(%rsi), %rax, %rcx
        movq	16(%rdi), %r11
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        movq	%r10, 8(%rdi)
        # a[i+9] += m[9] * mu
        mulxq	72(%rsi), %rax, %rcx
        movq	24(%rdi), %r10
        adcxq	%rax, %r11
        adoxq	%rcx, %r10
        movq	%r11, 16(%rdi)
        # a[i+10] += m[10] * mu
        mulxq	80(%rsi), %rax, %rcx
        movq	32(%rdi), %r11
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        movq	%r10, 24(%rdi)
        # a[i+11] += m[11] * mu
        mulxq	88(%rsi), %rax, %rcx
        movq	40(%rdi), %r10
        adcxq	%rax, %r11
        adoxq	%rcx, %r10
        movq	%r11, 32(%rdi)
        # a[i+12] += m[12] * mu
        mulxq	96(%rsi), %rax, %rcx
        movq	48(%rdi), %r11
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        movq	%r10, 40(%rdi)
        # a[i+13] += m[13] * mu
        mulxq	104(%rsi), %rax, %rcx
        movq	56(%rdi), %r10
        adcxq	%rax, %r11
        adoxq	%rcx, %r10
        movq	%r11, 48(%rdi)
        # a[i+14] += m[14] * mu
        mulxq	112(%rsi), %rax, %rcx
        movq	64(%rdi), %r11
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        movq	%r10, 56(%rdi)
        # a[i+15] += m[15] * mu
        mulxq	120(%rsi), %rax, %rcx
        movq	72(%rdi), %r10
        adcxq	%rax, %r11
        adoxq	%rcx, %r10
        movq	%r11, 64(%rdi)
        adcxq	%rbp, %r10
        movq	%rbx, %rbp
        movq	%r10, 72(%rdi)
        adoxq	%rbx, %rbp
        adcxq	%rbx, %rbp
        # a += 2
        addq	$16, %rdi
        # i -= 2
        subq	$2, %r9
        jnz	L_2048_mont_reduce_avx2_16_loop
        subq	$0x40, %rdi
        negq	%rbp
        movq	%rdi, %r8
        subq	$0x80, %rdi
        movq	(%rsi), %rcx
        movq	%r12, %rdx
        pextq	%rbp, %rcx, %rcx
        subq	%rcx, %rdx
        movq	8(%rsi), %rcx
        movq	%r13, %rax
        pextq	%rbp, %rcx, %rcx
        movq	%rdx, (%rdi)
        sbbq	%rcx, %rax
        movq	16(%rsi), %rdx
        movq	%r14, %rcx
        pextq	%rbp, %rdx, %rdx
        movq	%rax, 8(%rdi)
        sbbq	%rdx, %rcx
        movq	24(%rsi), %rax
        movq	%r15, %rdx
        pextq	%rbp, %rax, %rax
        movq	%rcx, 16(%rdi)
        sbbq	%rax, %rdx
        movq	32(%rsi), %rcx
        movq	32(%r8), %rax
        pextq	%rbp, %rcx, %rcx
        movq	%rdx, 24(%rdi)
        sbbq	%rcx, %rax
        movq	40(%rsi), %rdx
        movq	40(%r8), %rcx
        pextq	%rbp, %rdx, %rdx
        movq	%rax, 32(%rdi)
        sbbq	%rdx, %rcx
        movq	48(%rsi), %rax
        movq	48(%r8), %rdx
        pextq	%rbp, %rax, %rax
        movq	%rcx, 40(%rdi)
        sbbq	%rax, %rdx
        movq	56(%rsi), %rcx
        movq	56(%r8), %rax
        pextq	%rbp, %rcx, %rcx
        movq	%rdx, 48(%rdi)
        sbbq	%rcx, %rax
        movq	64(%rsi), %rdx
        movq	64(%r8), %rcx
        pextq	%rbp, %rdx, %rdx
        movq	%rax, 56(%rdi)
        sbbq	%rdx, %rcx
        movq	72(%rsi), %rax
        movq	72(%r8), %rdx
        pextq	%rbp, %rax, %rax
        movq	%rcx, 64(%rdi)
        sbbq	%rax, %rdx
        movq	80(%rsi), %rcx
        movq	80(%r8), %rax
        pextq	%rbp, %rcx, %rcx
        movq	%rdx, 72(%rdi)
        sbbq	%rcx, %rax
        movq	88(%rsi), %rdx
        movq	88(%r8), %rcx
        pextq	%rbp, %rdx, %rdx
        movq	%rax, 80(%rdi)
        sbbq	%rdx, %rcx
        movq	96(%rsi), %rax
        movq	96(%r8), %rdx
        pextq	%rbp, %rax, %rax
        movq	%rcx, 88(%rdi)
        sbbq	%rax, %rdx
        movq	104(%rsi), %rcx
        movq	104(%r8), %rax
        pextq	%rbp, %rcx, %rcx
        movq	%rdx, 96(%rdi)
        sbbq	%rcx, %rax
        movq	112(%rsi), %rdx
        movq	112(%r8), %rcx
        pextq	%rbp, %rdx, %rdx
        movq	%rax, 104(%rdi)
        sbbq	%rdx, %rcx
        movq	120(%rsi), %rax
        movq	120(%r8), %rdx
        pextq	%rbp, %rax, %rax
        movq	%rcx, 112(%rdi)
        sbbq	%rax, %rdx
        movq	%rdx, 120(%rdi)
        popq	%rbp
        popq	%rbx
        popq	%r15
        popq	%r14
        popq	%r13
        popq	%r12
        repz retq
#ifndef __APPLE__
.size	sp_2048_mont_reduce_avx2_16,.-sp_2048_mont_reduce_avx2_16
#endif /* __APPLE__ */
#endif /* HAVE_INTEL_AVX2 */
#ifndef WC_NO_CACHE_RESISTANT
#ifndef __APPLE__
.text
.globl	sp_2048_get_from_table_avx2_16
.type	sp_2048_get_from_table_avx2_16,@function
.align	16
sp_2048_get_from_table_avx2_16:
#else
.section	__TEXT,__text
.globl	_sp_2048_get_from_table_avx2_16
.p2align	4
_sp_2048_get_from_table_avx2_16:
#endif /* __APPLE__ */
        movq	$0x01, %rax
        movd	%rdx, %xmm10
        movd	%rax, %xmm11
        vpxor	%ymm13, %ymm13, %ymm13
        vpermd	%ymm10, %ymm13, %ymm10
        vpermd	%ymm11, %ymm13, %ymm11
        # START: 0-15
        vpxor	%ymm13, %ymm13, %ymm13
        vpxor	%ymm4, %ymm4, %ymm4
        vpxor	%ymm5, %ymm5, %ymm5
        vpxor	%ymm6, %ymm6, %ymm6
        vpxor	%ymm7, %ymm7, %ymm7
        # ENTRY: 0
        movq	(%rsi), %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vmovdqu	64(%rcx), %ymm2
        vmovdqu	96(%rcx), %ymm3
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpand	%ymm12, %ymm2, %ymm2
        vpand	%ymm12, %ymm3, %ymm3
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpor	%ymm2, %ymm6, %ymm6
        vpor	%ymm3, %ymm7, %ymm7
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 1
        movq	8(%rsi), %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vmovdqu	64(%rcx), %ymm2
        vmovdqu	96(%rcx), %ymm3
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpand	%ymm12, %ymm2, %ymm2
        vpand	%ymm12, %ymm3, %ymm3
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpor	%ymm2, %ymm6, %ymm6
        vpor	%ymm3, %ymm7, %ymm7
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 2
        movq	16(%rsi), %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vmovdqu	64(%rcx), %ymm2
        vmovdqu	96(%rcx), %ymm3
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpand	%ymm12, %ymm2, %ymm2
        vpand	%ymm12, %ymm3, %ymm3
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpor	%ymm2, %ymm6, %ymm6
        vpor	%ymm3, %ymm7, %ymm7
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 3
        movq	24(%rsi), %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vmovdqu	64(%rcx), %ymm2
        vmovdqu	96(%rcx), %ymm3
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpand	%ymm12, %ymm2, %ymm2
        vpand	%ymm12, %ymm3, %ymm3
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpor	%ymm2, %ymm6, %ymm6
        vpor	%ymm3, %ymm7, %ymm7
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 4
        movq	32(%rsi), %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vmovdqu	64(%rcx), %ymm2
        vmovdqu	96(%rcx), %ymm3
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpand	%ymm12, %ymm2, %ymm2
        vpand	%ymm12, %ymm3, %ymm3
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpor	%ymm2, %ymm6, %ymm6
        vpor	%ymm3, %ymm7, %ymm7
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 5
        movq	40(%rsi), %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vmovdqu	64(%rcx), %ymm2
        vmovdqu	96(%rcx), %ymm3
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpand	%ymm12, %ymm2, %ymm2
        vpand	%ymm12, %ymm3, %ymm3
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpor	%ymm2, %ymm6, %ymm6
        vpor	%ymm3, %ymm7, %ymm7
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 6
        movq	48(%rsi), %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vmovdqu	64(%rcx), %ymm2
        vmovdqu	96(%rcx), %ymm3
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpand	%ymm12, %ymm2, %ymm2
        vpand	%ymm12, %ymm3, %ymm3
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpor	%ymm2, %ymm6, %ymm6
        vpor	%ymm3, %ymm7, %ymm7
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 7
        movq	56(%rsi), %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vmovdqu	64(%rcx), %ymm2
        vmovdqu	96(%rcx), %ymm3
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpand	%ymm12, %ymm2, %ymm2
        vpand	%ymm12, %ymm3, %ymm3
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpor	%ymm2, %ymm6, %ymm6
        vpor	%ymm3, %ymm7, %ymm7
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 8
        movq	64(%rsi), %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vmovdqu	64(%rcx), %ymm2
        vmovdqu	96(%rcx), %ymm3
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpand	%ymm12, %ymm2, %ymm2
        vpand	%ymm12, %ymm3, %ymm3
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpor	%ymm2, %ymm6, %ymm6
        vpor	%ymm3, %ymm7, %ymm7
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 9
        movq	72(%rsi), %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vmovdqu	64(%rcx), %ymm2
        vmovdqu	96(%rcx), %ymm3
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpand	%ymm12, %ymm2, %ymm2
        vpand	%ymm12, %ymm3, %ymm3
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpor	%ymm2, %ymm6, %ymm6
        vpor	%ymm3, %ymm7, %ymm7
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 10
        movq	80(%rsi), %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vmovdqu	64(%rcx), %ymm2
        vmovdqu	96(%rcx), %ymm3
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpand	%ymm12, %ymm2, %ymm2
        vpand	%ymm12, %ymm3, %ymm3
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpor	%ymm2, %ymm6, %ymm6
        vpor	%ymm3, %ymm7, %ymm7
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 11
        movq	88(%rsi), %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vmovdqu	64(%rcx), %ymm2
        vmovdqu	96(%rcx), %ymm3
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpand	%ymm12, %ymm2, %ymm2
        vpand	%ymm12, %ymm3, %ymm3
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpor	%ymm2, %ymm6, %ymm6
        vpor	%ymm3, %ymm7, %ymm7
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 12
        movq	96(%rsi), %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vmovdqu	64(%rcx), %ymm2
        vmovdqu	96(%rcx), %ymm3
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpand	%ymm12, %ymm2, %ymm2
        vpand	%ymm12, %ymm3, %ymm3
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpor	%ymm2, %ymm6, %ymm6
        vpor	%ymm3, %ymm7, %ymm7
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 13
        movq	104(%rsi), %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vmovdqu	64(%rcx), %ymm2
        vmovdqu	96(%rcx), %ymm3
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpand	%ymm12, %ymm2, %ymm2
        vpand	%ymm12, %ymm3, %ymm3
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpor	%ymm2, %ymm6, %ymm6
        vpor	%ymm3, %ymm7, %ymm7
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 14
        movq	112(%rsi), %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vmovdqu	64(%rcx), %ymm2
        vmovdqu	96(%rcx), %ymm3
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpand	%ymm12, %ymm2, %ymm2
        vpand	%ymm12, %ymm3, %ymm3
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpor	%ymm2, %ymm6, %ymm6
        vpor	%ymm3, %ymm7, %ymm7
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 15
        movq	120(%rsi), %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vmovdqu	64(%rcx), %ymm2
        vmovdqu	96(%rcx), %ymm3
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpand	%ymm12, %ymm2, %ymm2
        vpand	%ymm12, %ymm3, %ymm3
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpor	%ymm2, %ymm6, %ymm6
        vpor	%ymm3, %ymm7, %ymm7
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 16
        movq	128(%rsi), %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vmovdqu	64(%rcx), %ymm2
        vmovdqu	96(%rcx), %ymm3
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpand	%ymm12, %ymm2, %ymm2
        vpand	%ymm12, %ymm3, %ymm3
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpor	%ymm2, %ymm6, %ymm6
        vpor	%ymm3, %ymm7, %ymm7
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 17
        movq	136(%rsi), %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vmovdqu	64(%rcx), %ymm2
        vmovdqu	96(%rcx), %ymm3
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpand	%ymm12, %ymm2, %ymm2
        vpand	%ymm12, %ymm3, %ymm3
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpor	%ymm2, %ymm6, %ymm6
        vpor	%ymm3, %ymm7, %ymm7
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 18
        movq	144(%rsi), %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vmovdqu	64(%rcx), %ymm2
        vmovdqu	96(%rcx), %ymm3
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpand	%ymm12, %ymm2, %ymm2
        vpand	%ymm12, %ymm3, %ymm3
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpor	%ymm2, %ymm6, %ymm6
        vpor	%ymm3, %ymm7, %ymm7
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 19
        movq	152(%rsi), %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vmovdqu	64(%rcx), %ymm2
        vmovdqu	96(%rcx), %ymm3
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpand	%ymm12, %ymm2, %ymm2
        vpand	%ymm12, %ymm3, %ymm3
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpor	%ymm2, %ymm6, %ymm6
        vpor	%ymm3, %ymm7, %ymm7
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 20
        movq	160(%rsi), %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vmovdqu	64(%rcx), %ymm2
        vmovdqu	96(%rcx), %ymm3
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpand	%ymm12, %ymm2, %ymm2
        vpand	%ymm12, %ymm3, %ymm3
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpor	%ymm2, %ymm6, %ymm6
        vpor	%ymm3, %ymm7, %ymm7
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 21
        movq	168(%rsi), %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vmovdqu	64(%rcx), %ymm2
        vmovdqu	96(%rcx), %ymm3
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpand	%ymm12, %ymm2, %ymm2
        vpand	%ymm12, %ymm3, %ymm3
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpor	%ymm2, %ymm6, %ymm6
        vpor	%ymm3, %ymm7, %ymm7
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 22
        movq	176(%rsi), %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vmovdqu	64(%rcx), %ymm2
        vmovdqu	96(%rcx), %ymm3
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpand	%ymm12, %ymm2, %ymm2
        vpand	%ymm12, %ymm3, %ymm3
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpor	%ymm2, %ymm6, %ymm6
        vpor	%ymm3, %ymm7, %ymm7
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 23
        movq	184(%rsi), %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vmovdqu	64(%rcx), %ymm2
        vmovdqu	96(%rcx), %ymm3
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpand	%ymm12, %ymm2, %ymm2
        vpand	%ymm12, %ymm3, %ymm3
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpor	%ymm2, %ymm6, %ymm6
        vpor	%ymm3, %ymm7, %ymm7
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 24
        movq	192(%rsi), %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vmovdqu	64(%rcx), %ymm2
        vmovdqu	96(%rcx), %ymm3
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpand	%ymm12, %ymm2, %ymm2
        vpand	%ymm12, %ymm3, %ymm3
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpor	%ymm2, %ymm6, %ymm6
        vpor	%ymm3, %ymm7, %ymm7
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 25
        movq	200(%rsi), %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vmovdqu	64(%rcx), %ymm2
        vmovdqu	96(%rcx), %ymm3
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpand	%ymm12, %ymm2, %ymm2
        vpand	%ymm12, %ymm3, %ymm3
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpor	%ymm2, %ymm6, %ymm6
        vpor	%ymm3, %ymm7, %ymm7
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 26
        movq	208(%rsi), %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vmovdqu	64(%rcx), %ymm2
        vmovdqu	96(%rcx), %ymm3
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpand	%ymm12, %ymm2, %ymm2
        vpand	%ymm12, %ymm3, %ymm3
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpor	%ymm2, %ymm6, %ymm6
        vpor	%ymm3, %ymm7, %ymm7
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 27
        movq	216(%rsi), %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vmovdqu	64(%rcx), %ymm2
        vmovdqu	96(%rcx), %ymm3
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpand	%ymm12, %ymm2, %ymm2
        vpand	%ymm12, %ymm3, %ymm3
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpor	%ymm2, %ymm6, %ymm6
        vpor	%ymm3, %ymm7, %ymm7
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 28
        movq	224(%rsi), %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vmovdqu	64(%rcx), %ymm2
        vmovdqu	96(%rcx), %ymm3
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpand	%ymm12, %ymm2, %ymm2
        vpand	%ymm12, %ymm3, %ymm3
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpor	%ymm2, %ymm6, %ymm6
        vpor	%ymm3, %ymm7, %ymm7
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 29
        movq	232(%rsi), %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vmovdqu	64(%rcx), %ymm2
        vmovdqu	96(%rcx), %ymm3
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpand	%ymm12, %ymm2, %ymm2
        vpand	%ymm12, %ymm3, %ymm3
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpor	%ymm2, %ymm6, %ymm6
        vpor	%ymm3, %ymm7, %ymm7
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 30
        movq	240(%rsi), %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vmovdqu	64(%rcx), %ymm2
        vmovdqu	96(%rcx), %ymm3
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpand	%ymm12, %ymm2, %ymm2
        vpand	%ymm12, %ymm3, %ymm3
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpor	%ymm2, %ymm6, %ymm6
        vpor	%ymm3, %ymm7, %ymm7
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 31
        movq	248(%rsi), %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vmovdqu	64(%rcx), %ymm2
        vmovdqu	96(%rcx), %ymm3
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpand	%ymm12, %ymm2, %ymm2
        vpand	%ymm12, %ymm3, %ymm3
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpor	%ymm2, %ymm6, %ymm6
        vpor	%ymm3, %ymm7, %ymm7
        vpaddd	%ymm11, %ymm13, %ymm13
        vmovdqu	%ymm4, (%rdi)
        vmovdqu	%ymm5, 32(%rdi)
        vmovdqu	%ymm6, 64(%rdi)
        vmovdqu	%ymm7, 96(%rdi)
        # END: 0-15
        repz retq
#ifndef __APPLE__
.size	sp_2048_get_from_table_avx2_16,.-sp_2048_get_from_table_avx2_16
#endif /* __APPLE__ */
#endif /* !WC_NO_CACHE_RESISTANT */
/* Conditionally subtract b from a using the mask m.
 * m is -1 to subtract and 0 when not copying.
 *
 * r  A single precision number representing condition subtract result.
 * a  A single precision number to subtract from.
 * b  A single precision number to subtract.
 * m  Mask value to apply.
 */
#ifndef __APPLE__
.text
.globl	sp_2048_cond_sub_32
.type	sp_2048_cond_sub_32,@function
.align	16
sp_2048_cond_sub_32:
#else
.section	__TEXT,__text
.globl	_sp_2048_cond_sub_32
.p2align	4
_sp_2048_cond_sub_32:
#endif /* __APPLE__ */
        subq	$0x100, %rsp
        movq	(%rdx), %r8
        movq	8(%rdx), %r9
        andq	%rcx, %r8
        andq	%rcx, %r9
        movq	%r8, (%rsp)
        movq	%r9, 8(%rsp)
        movq	16(%rdx), %r8
        movq	24(%rdx), %r9
        andq	%rcx, %r8
        andq	%rcx, %r9
        movq	%r8, 16(%rsp)
        movq	%r9, 24(%rsp)
        movq	32(%rdx), %r8
        movq	40(%rdx), %r9
        andq	%rcx, %r8
        andq	%rcx, %r9
        movq	%r8, 32(%rsp)
        movq	%r9, 40(%rsp)
        movq	48(%rdx), %r8
        movq	56(%rdx), %r9
        andq	%rcx, %r8
        andq	%rcx, %r9
        movq	%r8, 48(%rsp)
        movq	%r9, 56(%rsp)
        movq	64(%rdx), %r8
        movq	72(%rdx), %r9
        andq	%rcx, %r8
        andq	%rcx, %r9
        movq	%r8, 64(%rsp)
        movq	%r9, 72(%rsp)
        movq	80(%rdx), %r8
        movq	88(%rdx), %r9
        andq	%rcx, %r8
        andq	%rcx, %r9
        movq	%r8, 80(%rsp)
        movq	%r9, 88(%rsp)
        movq	96(%rdx), %r8
        movq	104(%rdx), %r9
        andq	%rcx, %r8
        andq	%rcx, %r9
        movq	%r8, 96(%rsp)
        movq	%r9, 104(%rsp)
        movq	112(%rdx), %r8
        movq	120(%rdx), %r9
        andq	%rcx, %r8
        andq	%rcx, %r9
        movq	%r8, 112(%rsp)
        movq	%r9, 120(%rsp)
        movq	128(%rdx), %r8
        movq	136(%rdx), %r9
        andq	%rcx, %r8
        andq	%rcx, %r9
        movq	%r8, 128(%rsp)
        movq	%r9, 136(%rsp)
        movq	144(%rdx), %r8
        movq	152(%rdx), %r9
        andq	%rcx, %r8
        andq	%rcx, %r9
        movq	%r8, 144(%rsp)
        movq	%r9, 152(%rsp)
        movq	160(%rdx), %r8
        movq	168(%rdx), %r9
        andq	%rcx, %r8
        andq	%rcx, %r9
        movq	%r8, 160(%rsp)
        movq	%r9, 168(%rsp)
        movq	176(%rdx), %r8
        movq	184(%rdx), %r9
        andq	%rcx, %r8
        andq	%rcx, %r9
        movq	%r8, 176(%rsp)
        movq	%r9, 184(%rsp)
        movq	192(%rdx), %r8
        movq	200(%rdx), %r9
        andq	%rcx, %r8
        andq	%rcx, %r9
        movq	%r8, 192(%rsp)
        movq	%r9, 200(%rsp)
        movq	208(%rdx), %r8
        movq	216(%rdx), %r9
        andq	%rcx, %r8
        andq	%rcx, %r9
        movq	%r8, 208(%rsp)
        movq	%r9, 216(%rsp)
        movq	224(%rdx), %r8
        movq	232(%rdx), %r9
        andq	%rcx, %r8
        andq	%rcx, %r9
        movq	%r8, 224(%rsp)
        movq	%r9, 232(%rsp)
        movq	240(%rdx), %r8
        movq	248(%rdx), %r9
        andq	%rcx, %r8
        andq	%rcx, %r9
        movq	%r8, 240(%rsp)
        movq	%r9, 248(%rsp)
        movq	(%rsi), %r8
        movq	(%rsp), %rdx
        subq	%rdx, %r8
        movq	8(%rsi), %r9
        movq	8(%rsp), %rdx
        sbbq	%rdx, %r9
        movq	%r8, (%rdi)
        movq	16(%rsi), %r8
        movq	16(%rsp), %rdx
        sbbq	%rdx, %r8
        movq	%r9, 8(%rdi)
        movq	24(%rsi), %r9
        movq	24(%rsp), %rdx
        sbbq	%rdx, %r9
        movq	%r8, 16(%rdi)
        movq	32(%rsi), %r8
        movq	32(%rsp), %rdx
        sbbq	%rdx, %r8
        movq	%r9, 24(%rdi)
        movq	40(%rsi), %r9
        movq	40(%rsp), %rdx
        sbbq	%rdx, %r9
        movq	%r8, 32(%rdi)
        movq	48(%rsi), %r8
        movq	48(%rsp), %rdx
        sbbq	%rdx, %r8
        movq	%r9, 40(%rdi)
        movq	56(%rsi), %r9
        movq	56(%rsp), %rdx
        sbbq	%rdx, %r9
        movq	%r8, 48(%rdi)
        movq	64(%rsi), %r8
        movq	64(%rsp), %rdx
        sbbq	%rdx, %r8
        movq	%r9, 56(%rdi)
        movq	72(%rsi), %r9
        movq	72(%rsp), %rdx
        sbbq	%rdx, %r9
        movq	%r8, 64(%rdi)
        movq	80(%rsi), %r8
        movq	80(%rsp), %rdx
        sbbq	%rdx, %r8
        movq	%r9, 72(%rdi)
        movq	88(%rsi), %r9
        movq	88(%rsp), %rdx
        sbbq	%rdx, %r9
        movq	%r8, 80(%rdi)
        movq	96(%rsi), %r8
        movq	96(%rsp), %rdx
        sbbq	%rdx, %r8
        movq	%r9, 88(%rdi)
        movq	104(%rsi), %r9
        movq	104(%rsp), %rdx
        sbbq	%rdx, %r9
        movq	%r8, 96(%rdi)
        movq	112(%rsi), %r8
        movq	112(%rsp), %rdx
        sbbq	%rdx, %r8
        movq	%r9, 104(%rdi)
        movq	120(%rsi), %r9
        movq	120(%rsp), %rdx
        sbbq	%rdx, %r9
        movq	%r8, 112(%rdi)
        movq	128(%rsi), %r8
        movq	128(%rsp), %rdx
        sbbq	%rdx, %r8
        movq	%r9, 120(%rdi)
        movq	136(%rsi), %r9
        movq	136(%rsp), %rdx
        sbbq	%rdx, %r9
        movq	%r8, 128(%rdi)
        movq	144(%rsi), %r8
        movq	144(%rsp), %rdx
        sbbq	%rdx, %r8
        movq	%r9, 136(%rdi)
        movq	152(%rsi), %r9
        movq	152(%rsp), %rdx
        sbbq	%rdx, %r9
        movq	%r8, 144(%rdi)
        movq	160(%rsi), %r8
        movq	160(%rsp), %rdx
        sbbq	%rdx, %r8
        movq	%r9, 152(%rdi)
        movq	168(%rsi), %r9
        movq	168(%rsp), %rdx
        sbbq	%rdx, %r9
        movq	%r8, 160(%rdi)
        movq	176(%rsi), %r8
        movq	176(%rsp), %rdx
        sbbq	%rdx, %r8
        movq	%r9, 168(%rdi)
        movq	184(%rsi), %r9
        movq	184(%rsp), %rdx
        sbbq	%rdx, %r9
        movq	%r8, 176(%rdi)
        movq	192(%rsi), %r8
        movq	192(%rsp), %rdx
        sbbq	%rdx, %r8
        movq	%r9, 184(%rdi)
        movq	200(%rsi), %r9
        movq	200(%rsp), %rdx
        sbbq	%rdx, %r9
        movq	%r8, 192(%rdi)
        movq	208(%rsi), %r8
        movq	208(%rsp), %rdx
        sbbq	%rdx, %r8
        movq	%r9, 200(%rdi)
        movq	216(%rsi), %r9
        movq	216(%rsp), %rdx
        sbbq	%rdx, %r9
        movq	%r8, 208(%rdi)
        movq	224(%rsi), %r8
        movq	224(%rsp), %rdx
        sbbq	%rdx, %r8
        movq	%r9, 216(%rdi)
        movq	232(%rsi), %r9
        movq	232(%rsp), %rdx
        sbbq	%rdx, %r9
        movq	%r8, 224(%rdi)
        movq	240(%rsi), %r8
        movq	240(%rsp), %rdx
        sbbq	%rdx, %r8
        movq	%r9, 232(%rdi)
        movq	248(%rsi), %r9
        movq	248(%rsp), %rdx
        sbbq	%rdx, %r9
        movq	%r8, 240(%rdi)
        movq	%r9, 248(%rdi)
        sbbq	%rax, %rax
        addq	$0x100, %rsp
        repz retq
#ifndef __APPLE__
.size	sp_2048_cond_sub_32,.-sp_2048_cond_sub_32
#endif /* __APPLE__ */
/* Reduce the number back to 2048 bits using Montgomery reduction.
 *
 * a   A single precision number to reduce in place.
 * m   The single precision number representing the modulus.
 * mp  The digit representing the negative inverse of m mod 2^n.
 */
#ifndef __APPLE__
.text
.globl	sp_2048_mont_reduce_32
.type	sp_2048_mont_reduce_32,@function
.align	16
sp_2048_mont_reduce_32:
#else
.section	__TEXT,__text
.globl	_sp_2048_mont_reduce_32
.p2align	4
_sp_2048_mont_reduce_32:
#endif /* __APPLE__ */
        pushq	%r12
        pushq	%r13
        pushq	%r14
        pushq	%r15
        movq	%rdx, %rcx
        xorq	%r15, %r15
        # i = 32
        movq	$32, %r8
        movq	(%rdi), %r13
        movq	8(%rdi), %r14
L_2048_mont_reduce_32_loop:
        # mu = a[i] * mp
        movq	%r13, %r11
        imulq	%rcx, %r11
        # a[i+0] += m[0] * mu
        movq	%r11, %rax
        xorq	%r10, %r10
        mulq	(%rsi)
        addq	%rax, %r13
        adcq	%rdx, %r10
        # a[i+1] += m[1] * mu
        movq	%r11, %rax
        xorq	%r9, %r9
        mulq	8(%rsi)
        movq	%r14, %r13
        addq	%rax, %r13
        adcq	%rdx, %r9
        addq	%r10, %r13
        adcq	$0x00, %r9
        # a[i+2] += m[2] * mu
        movq	%r11, %rax
        xorq	%r10, %r10
        mulq	16(%rsi)
        movq	16(%rdi), %r14
        addq	%rax, %r14
        adcq	%rdx, %r10
        addq	%r9, %r14
        adcq	$0x00, %r10
        # a[i+3] += m[3] * mu
        movq	%r11, %rax
        xorq	%r9, %r9
        mulq	24(%rsi)
        movq	24(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r9
        addq	%r10, %r12
        movq	%r12, 24(%rdi)
        adcq	$0x00, %r9
        # a[i+4] += m[4] * mu
        movq	%r11, %rax
        xorq	%r10, %r10
        mulq	32(%rsi)
        movq	32(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r10
        addq	%r9, %r12
        movq	%r12, 32(%rdi)
        adcq	$0x00, %r10
        # a[i+5] += m[5] * mu
        movq	%r11, %rax
        xorq	%r9, %r9
        mulq	40(%rsi)
        movq	40(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r9
        addq	%r10, %r12
        movq	%r12, 40(%rdi)
        adcq	$0x00, %r9
        # a[i+6] += m[6] * mu
        movq	%r11, %rax
        xorq	%r10, %r10
        mulq	48(%rsi)
        movq	48(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r10
        addq	%r9, %r12
        movq	%r12, 48(%rdi)
        adcq	$0x00, %r10
        # a[i+7] += m[7] * mu
        movq	%r11, %rax
        xorq	%r9, %r9
        mulq	56(%rsi)
        movq	56(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r9
        addq	%r10, %r12
        movq	%r12, 56(%rdi)
        adcq	$0x00, %r9
        # a[i+8] += m[8] * mu
        movq	%r11, %rax
        xorq	%r10, %r10
        mulq	64(%rsi)
        movq	64(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r10
        addq	%r9, %r12
        movq	%r12, 64(%rdi)
        adcq	$0x00, %r10
        # a[i+9] += m[9] * mu
        movq	%r11, %rax
        xorq	%r9, %r9
        mulq	72(%rsi)
        movq	72(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r9
        addq	%r10, %r12
        movq	%r12, 72(%rdi)
        adcq	$0x00, %r9
        # a[i+10] += m[10] * mu
        movq	%r11, %rax
        xorq	%r10, %r10
        mulq	80(%rsi)
        movq	80(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r10
        addq	%r9, %r12
        movq	%r12, 80(%rdi)
        adcq	$0x00, %r10
        # a[i+11] += m[11] * mu
        movq	%r11, %rax
        xorq	%r9, %r9
        mulq	88(%rsi)
        movq	88(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r9
        addq	%r10, %r12
        movq	%r12, 88(%rdi)
        adcq	$0x00, %r9
        # a[i+12] += m[12] * mu
        movq	%r11, %rax
        xorq	%r10, %r10
        mulq	96(%rsi)
        movq	96(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r10
        addq	%r9, %r12
        movq	%r12, 96(%rdi)
        adcq	$0x00, %r10
        # a[i+13] += m[13] * mu
        movq	%r11, %rax
        xorq	%r9, %r9
        mulq	104(%rsi)
        movq	104(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r9
        addq	%r10, %r12
        movq	%r12, 104(%rdi)
        adcq	$0x00, %r9
        # a[i+14] += m[14] * mu
        movq	%r11, %rax
        xorq	%r10, %r10
        mulq	112(%rsi)
        movq	112(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r10
        addq	%r9, %r12
        movq	%r12, 112(%rdi)
        adcq	$0x00, %r10
        # a[i+15] += m[15] * mu
        movq	%r11, %rax
        xorq	%r9, %r9
        mulq	120(%rsi)
        movq	120(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r9
        addq	%r10, %r12
        movq	%r12, 120(%rdi)
        adcq	$0x00, %r9
        # a[i+16] += m[16] * mu
        movq	%r11, %rax
        xorq	%r10, %r10
        mulq	128(%rsi)
        movq	128(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r10
        addq	%r9, %r12
        movq	%r12, 128(%rdi)
        adcq	$0x00, %r10
        # a[i+17] += m[17] * mu
        movq	%r11, %rax
        xorq	%r9, %r9
        mulq	136(%rsi)
        movq	136(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r9
        addq	%r10, %r12
        movq	%r12, 136(%rdi)
        adcq	$0x00, %r9
        # a[i+18] += m[18] * mu
        movq	%r11, %rax
        xorq	%r10, %r10
        mulq	144(%rsi)
        movq	144(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r10
        addq	%r9, %r12
        movq	%r12, 144(%rdi)
        adcq	$0x00, %r10
        # a[i+19] += m[19] * mu
        movq	%r11, %rax
        xorq	%r9, %r9
        mulq	152(%rsi)
        movq	152(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r9
        addq	%r10, %r12
        movq	%r12, 152(%rdi)
        adcq	$0x00, %r9
        # a[i+20] += m[20] * mu
        movq	%r11, %rax
        xorq	%r10, %r10
        mulq	160(%rsi)
        movq	160(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r10
        addq	%r9, %r12
        movq	%r12, 160(%rdi)
        adcq	$0x00, %r10
        # a[i+21] += m[21] * mu
        movq	%r11, %rax
        xorq	%r9, %r9
        mulq	168(%rsi)
        movq	168(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r9
        addq	%r10, %r12
        movq	%r12, 168(%rdi)
        adcq	$0x00, %r9
        # a[i+22] += m[22] * mu
        movq	%r11, %rax
        xorq	%r10, %r10
        mulq	176(%rsi)
        movq	176(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r10
        addq	%r9, %r12
        movq	%r12, 176(%rdi)
        adcq	$0x00, %r10
        # a[i+23] += m[23] * mu
        movq	%r11, %rax
        xorq	%r9, %r9
        mulq	184(%rsi)
        movq	184(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r9
        addq	%r10, %r12
        movq	%r12, 184(%rdi)
        adcq	$0x00, %r9
        # a[i+24] += m[24] * mu
        movq	%r11, %rax
        xorq	%r10, %r10
        mulq	192(%rsi)
        movq	192(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r10
        addq	%r9, %r12
        movq	%r12, 192(%rdi)
        adcq	$0x00, %r10
        # a[i+25] += m[25] * mu
        movq	%r11, %rax
        xorq	%r9, %r9
        mulq	200(%rsi)
        movq	200(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r9
        addq	%r10, %r12
        movq	%r12, 200(%rdi)
        adcq	$0x00, %r9
        # a[i+26] += m[26] * mu
        movq	%r11, %rax
        xorq	%r10, %r10
        mulq	208(%rsi)
        movq	208(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r10
        addq	%r9, %r12
        movq	%r12, 208(%rdi)
        adcq	$0x00, %r10
        # a[i+27] += m[27] * mu
        movq	%r11, %rax
        xorq	%r9, %r9
        mulq	216(%rsi)
        movq	216(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r9
        addq	%r10, %r12
        movq	%r12, 216(%rdi)
        adcq	$0x00, %r9
        # a[i+28] += m[28] * mu
        movq	%r11, %rax
        xorq	%r10, %r10
        mulq	224(%rsi)
        movq	224(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r10
        addq	%r9, %r12
        movq	%r12, 224(%rdi)
        adcq	$0x00, %r10
        # a[i+29] += m[29] * mu
        movq	%r11, %rax
        xorq	%r9, %r9
        mulq	232(%rsi)
        movq	232(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r9
        addq	%r10, %r12
        movq	%r12, 232(%rdi)
        adcq	$0x00, %r9
        # a[i+30] += m[30] * mu
        movq	%r11, %rax
        xorq	%r10, %r10
        mulq	240(%rsi)
        movq	240(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r10
        addq	%r9, %r12
        movq	%r12, 240(%rdi)
        adcq	$0x00, %r10
        # a[i+31] += m[31] * mu
        movq	%r11, %rax
        mulq	248(%rsi)
        movq	248(%rdi), %r12
        addq	%rax, %r10
        adcq	%r15, %rdx
        movq	$0x00, %r15
        adcq	$0x00, %r15
        addq	%r10, %r12
        movq	%r12, 248(%rdi)
        adcq	%rdx, 256(%rdi)
        adcq	$0x00, %r15
        # i -= 1
        addq	$8, %rdi
        decq	%r8
        jnz	L_2048_mont_reduce_32_loop
        movq	%r13, (%rdi)
        movq	%r14, 8(%rdi)
        negq	%r15
#ifdef _WIN64
        movq	%rsi, %rdx
        movq	%r15, %rcx
#else
        movq	%r15, %rcx
        movq	%rsi, %rdx
#endif /* _WIN64 */
        movq	%rdi, %rsi
        movq	%rdi, %rdi
        subq	$0x100, %rdi
#ifndef __APPLE__
        callq	sp_2048_cond_sub_32@plt
#else
        callq	_sp_2048_cond_sub_32
#endif /* __APPLE__ */
        popq	%r15
        popq	%r14
        popq	%r13
        popq	%r12
        repz retq
#ifndef __APPLE__
.size	sp_2048_mont_reduce_32,.-sp_2048_mont_reduce_32
#endif /* __APPLE__ */
/* Sub b from a into r. (r = a - b)
 *
 * r  A single precision integer.
 * a  A single precision integer.
 * b  A single precision integer.
 */
#ifndef __APPLE__
.text
.globl	sp_2048_sub_32
.type	sp_2048_sub_32,@function
.align	16
sp_2048_sub_32:
#else
.section	__TEXT,__text
.globl	_sp_2048_sub_32
.p2align	4
_sp_2048_sub_32:
#endif /* __APPLE__ */
        movq	(%rsi), %rcx
        subq	(%rdx), %rcx
        movq	8(%rsi), %r8
        movq	%rcx, (%rdi)
        sbbq	8(%rdx), %r8
        movq	16(%rsi), %rcx
        movq	%r8, 8(%rdi)
        sbbq	16(%rdx), %rcx
        movq	24(%rsi), %r8
        movq	%rcx, 16(%rdi)
        sbbq	24(%rdx), %r8
        movq	32(%rsi), %rcx
        movq	%r8, 24(%rdi)
        sbbq	32(%rdx), %rcx
        movq	40(%rsi), %r8
        movq	%rcx, 32(%rdi)
        sbbq	40(%rdx), %r8
        movq	48(%rsi), %rcx
        movq	%r8, 40(%rdi)
        sbbq	48(%rdx), %rcx
        movq	56(%rsi), %r8
        movq	%rcx, 48(%rdi)
        sbbq	56(%rdx), %r8
        movq	64(%rsi), %rcx
        movq	%r8, 56(%rdi)
        sbbq	64(%rdx), %rcx
        movq	72(%rsi), %r8
        movq	%rcx, 64(%rdi)
        sbbq	72(%rdx), %r8
        movq	80(%rsi), %rcx
        movq	%r8, 72(%rdi)
        sbbq	80(%rdx), %rcx
        movq	88(%rsi), %r8
        movq	%rcx, 80(%rdi)
        sbbq	88(%rdx), %r8
        movq	96(%rsi), %rcx
        movq	%r8, 88(%rdi)
        sbbq	96(%rdx), %rcx
        movq	104(%rsi), %r8
        movq	%rcx, 96(%rdi)
        sbbq	104(%rdx), %r8
        movq	112(%rsi), %rcx
        movq	%r8, 104(%rdi)
        sbbq	112(%rdx), %rcx
        movq	120(%rsi), %r8
        movq	%rcx, 112(%rdi)
        sbbq	120(%rdx), %r8
        movq	128(%rsi), %rcx
        movq	%r8, 120(%rdi)
        sbbq	128(%rdx), %rcx
        movq	136(%rsi), %r8
        movq	%rcx, 128(%rdi)
        sbbq	136(%rdx), %r8
        movq	144(%rsi), %rcx
        movq	%r8, 136(%rdi)
        sbbq	144(%rdx), %rcx
        movq	152(%rsi), %r8
        movq	%rcx, 144(%rdi)
        sbbq	152(%rdx), %r8
        movq	160(%rsi), %rcx
        movq	%r8, 152(%rdi)
        sbbq	160(%rdx), %rcx
        movq	168(%rsi), %r8
        movq	%rcx, 160(%rdi)
        sbbq	168(%rdx), %r8
        movq	176(%rsi), %rcx
        movq	%r8, 168(%rdi)
        sbbq	176(%rdx), %rcx
        movq	184(%rsi), %r8
        movq	%rcx, 176(%rdi)
        sbbq	184(%rdx), %r8
        movq	192(%rsi), %rcx
        movq	%r8, 184(%rdi)
        sbbq	192(%rdx), %rcx
        movq	200(%rsi), %r8
        movq	%rcx, 192(%rdi)
        sbbq	200(%rdx), %r8
        movq	208(%rsi), %rcx
        movq	%r8, 200(%rdi)
        sbbq	208(%rdx), %rcx
        movq	216(%rsi), %r8
        movq	%rcx, 208(%rdi)
        sbbq	216(%rdx), %r8
        movq	224(%rsi), %rcx
        movq	%r8, 216(%rdi)
        sbbq	224(%rdx), %rcx
        movq	232(%rsi), %r8
        movq	%rcx, 224(%rdi)
        sbbq	232(%rdx), %r8
        movq	240(%rsi), %rcx
        movq	%r8, 232(%rdi)
        sbbq	240(%rdx), %rcx
        movq	248(%rsi), %r8
        movq	%rcx, 240(%rdi)
        sbbq	248(%rdx), %r8
        movq	%r8, 248(%rdi)
        sbbq	%rax, %rax
        repz retq
#ifndef __APPLE__
.size	sp_2048_sub_32,.-sp_2048_sub_32
#endif /* __APPLE__ */
#ifdef HAVE_INTEL_AVX2
/* Mul a by digit b into r. (r = a * b)
 *
 * r  A single precision integer.
 * a  A single precision integer.
 * b  A single precision digit.
 */
#ifndef __APPLE__
.text
.globl	sp_2048_mul_d_avx2_32
.type	sp_2048_mul_d_avx2_32,@function
.align	16
sp_2048_mul_d_avx2_32:
#else
.section	__TEXT,__text
.globl	_sp_2048_mul_d_avx2_32
.p2align	4
_sp_2048_mul_d_avx2_32:
#endif /* __APPLE__ */
        movq	%rdx, %rax
        # A[0] * B
        movq	%rax, %rdx
        xorq	%r11, %r11
        mulxq	(%rsi), %r9, %r10
        movq	%r9, (%rdi)
        # A[1] * B
        mulxq	8(%rsi), %rcx, %r8
        movq	%r11, %r9
        adcxq	%rcx, %r10
        adoxq	%r8, %r9
        movq	%r10, 8(%rdi)
        # A[2] * B
        mulxq	16(%rsi), %rcx, %r8
        movq	%r11, %r10
        adcxq	%rcx, %r9
        adoxq	%r8, %r10
        movq	%r9, 16(%rdi)
        # A[3] * B
        mulxq	24(%rsi), %rcx, %r8
        movq	%r11, %r9
        adcxq	%rcx, %r10
        adoxq	%r8, %r9
        movq	%r10, 24(%rdi)
        # A[4] * B
        mulxq	32(%rsi), %rcx, %r8
        movq	%r11, %r10
        adcxq	%rcx, %r9
        adoxq	%r8, %r10
        movq	%r9, 32(%rdi)
        # A[5] * B
        mulxq	40(%rsi), %rcx, %r8
        movq	%r11, %r9
        adcxq	%rcx, %r10
        adoxq	%r8, %r9
        movq	%r10, 40(%rdi)
        # A[6] * B
        mulxq	48(%rsi), %rcx, %r8
        movq	%r11, %r10
        adcxq	%rcx, %r9
        adoxq	%r8, %r10
        movq	%r9, 48(%rdi)
        # A[7] * B
        mulxq	56(%rsi), %rcx, %r8
        movq	%r11, %r9
        adcxq	%rcx, %r10
        adoxq	%r8, %r9
        movq	%r10, 56(%rdi)
        # A[8] * B
        mulxq	64(%rsi), %rcx, %r8
        movq	%r11, %r10
        adcxq	%rcx, %r9
        adoxq	%r8, %r10
        movq	%r9, 64(%rdi)
        # A[9] * B
        mulxq	72(%rsi), %rcx, %r8
        movq	%r11, %r9
        adcxq	%rcx, %r10
        adoxq	%r8, %r9
        movq	%r10, 72(%rdi)
        # A[10] * B
        mulxq	80(%rsi), %rcx, %r8
        movq	%r11, %r10
        adcxq	%rcx, %r9
        adoxq	%r8, %r10
        movq	%r9, 80(%rdi)
        # A[11] * B
        mulxq	88(%rsi), %rcx, %r8
        movq	%r11, %r9
        adcxq	%rcx, %r10
        adoxq	%r8, %r9
        movq	%r10, 88(%rdi)
        # A[12] * B
        mulxq	96(%rsi), %rcx, %r8
        movq	%r11, %r10
        adcxq	%rcx, %r9
        adoxq	%r8, %r10
        movq	%r9, 96(%rdi)
        # A[13] * B
        mulxq	104(%rsi), %rcx, %r8
        movq	%r11, %r9
        adcxq	%rcx, %r10
        adoxq	%r8, %r9
        movq	%r10, 104(%rdi)
        # A[14] * B
        mulxq	112(%rsi), %rcx, %r8
        movq	%r11, %r10
        adcxq	%rcx, %r9
        adoxq	%r8, %r10
        movq	%r9, 112(%rdi)
        # A[15] * B
        mulxq	120(%rsi), %rcx, %r8
        movq	%r11, %r9
        adcxq	%rcx, %r10
        adoxq	%r8, %r9
        movq	%r10, 120(%rdi)
        # A[16] * B
        mulxq	128(%rsi), %rcx, %r8
        movq	%r11, %r10
        adcxq	%rcx, %r9
        adoxq	%r8, %r10
        movq	%r9, 128(%rdi)
        # A[17] * B
        mulxq	136(%rsi), %rcx, %r8
        movq	%r11, %r9
        adcxq	%rcx, %r10
        adoxq	%r8, %r9
        movq	%r10, 136(%rdi)
        # A[18] * B
        mulxq	144(%rsi), %rcx, %r8
        movq	%r11, %r10
        adcxq	%rcx, %r9
        adoxq	%r8, %r10
        movq	%r9, 144(%rdi)
        # A[19] * B
        mulxq	152(%rsi), %rcx, %r8
        movq	%r11, %r9
        adcxq	%rcx, %r10
        adoxq	%r8, %r9
        movq	%r10, 152(%rdi)
        # A[20] * B
        mulxq	160(%rsi), %rcx, %r8
        movq	%r11, %r10
        adcxq	%rcx, %r9
        adoxq	%r8, %r10
        movq	%r9, 160(%rdi)
        # A[21] * B
        mulxq	168(%rsi), %rcx, %r8
        movq	%r11, %r9
        adcxq	%rcx, %r10
        adoxq	%r8, %r9
        movq	%r10, 168(%rdi)
        # A[22] * B
        mulxq	176(%rsi), %rcx, %r8
        movq	%r11, %r10
        adcxq	%rcx, %r9
        adoxq	%r8, %r10
        movq	%r9, 176(%rdi)
        # A[23] * B
        mulxq	184(%rsi), %rcx, %r8
        movq	%r11, %r9
        adcxq	%rcx, %r10
        adoxq	%r8, %r9
        movq	%r10, 184(%rdi)
        # A[24] * B
        mulxq	192(%rsi), %rcx, %r8
        movq	%r11, %r10
        adcxq	%rcx, %r9
        adoxq	%r8, %r10
        movq	%r9, 192(%rdi)
        # A[25] * B
        mulxq	200(%rsi), %rcx, %r8
        movq	%r11, %r9
        adcxq	%rcx, %r10
        adoxq	%r8, %r9
        movq	%r10, 200(%rdi)
        # A[26] * B
        mulxq	208(%rsi), %rcx, %r8
        movq	%r11, %r10
        adcxq	%rcx, %r9
        adoxq	%r8, %r10
        movq	%r9, 208(%rdi)
        # A[27] * B
        mulxq	216(%rsi), %rcx, %r8
        movq	%r11, %r9
        adcxq	%rcx, %r10
        adoxq	%r8, %r9
        movq	%r10, 216(%rdi)
        # A[28] * B
        mulxq	224(%rsi), %rcx, %r8
        movq	%r11, %r10
        adcxq	%rcx, %r9
        adoxq	%r8, %r10
        movq	%r9, 224(%rdi)
        # A[29] * B
        mulxq	232(%rsi), %rcx, %r8
        movq	%r11, %r9
        adcxq	%rcx, %r10
        adoxq	%r8, %r9
        movq	%r10, 232(%rdi)
        # A[30] * B
        mulxq	240(%rsi), %rcx, %r8
        movq	%r11, %r10
        adcxq	%rcx, %r9
        adoxq	%r8, %r10
        movq	%r9, 240(%rdi)
        # A[31] * B
        mulxq	248(%rsi), %rcx, %r8
        movq	%r11, %r9
        adcxq	%rcx, %r10
        adoxq	%r8, %r9
        adcxq	%r11, %r9
        movq	%r10, 248(%rdi)
        movq	%r9, 256(%rdi)
        repz retq
#ifndef __APPLE__
.size	sp_2048_mul_d_avx2_32,.-sp_2048_mul_d_avx2_32
#endif /* __APPLE__ */
#endif /* HAVE_INTEL_AVX2 */
#ifdef _WIN64
/* Divide the double width number (d1|d0) by the dividend. (d1|d0 / div)
 *
 * d1   The high order half of the number to divide.
 * d0   The low order half of the number to divide.
 * div  The dividend.
 * returns the result of the division.
 */
#ifndef __APPLE__
.text
.globl	div_2048_word_asm_32
.type	div_2048_word_asm_32,@function
.align	16
div_2048_word_asm_32:
#else
.section	__TEXT,__text
.globl	_div_2048_word_asm_32
.p2align	4
_div_2048_word_asm_32:
#endif /* __APPLE__ */
        movq	%rdx, %rcx
        movq	%rsi, %rax
        movq	%rdi, %rdx
        divq	%rcx
        repz retq
#ifndef __APPLE__
.size	div_2048_word_asm_32,.-div_2048_word_asm_32
#endif /* __APPLE__ */
#endif /* _WIN64 */
#ifdef HAVE_INTEL_AVX2
/* Conditionally subtract b from a using the mask m.
 * m is -1 to subtract and 0 when not copying.
 *
 * r  A single precision number representing condition subtract result.
 * a  A single precision number to subtract from.
 * b  A single precision number to subtract.
 * m  Mask value to apply.
 */
#ifndef __APPLE__
.text
.globl	sp_2048_cond_sub_avx2_32
.type	sp_2048_cond_sub_avx2_32,@function
.align	16
sp_2048_cond_sub_avx2_32:
#else
.section	__TEXT,__text
.globl	_sp_2048_cond_sub_avx2_32
.p2align	4
_sp_2048_cond_sub_avx2_32:
#endif /* __APPLE__ */
        movq	(%rdx), %r10
        movq	(%rsi), %r8
        pextq	%rcx, %r10, %r10
        subq	%r10, %r8
        movq	8(%rdx), %r10
        movq	8(%rsi), %r9
        pextq	%rcx, %r10, %r10
        movq	%r8, (%rdi)
        sbbq	%r10, %r9
        movq	16(%rdx), %r8
        movq	16(%rsi), %r10
        pextq	%rcx, %r8, %r8
        movq	%r9, 8(%rdi)
        sbbq	%r8, %r10
        movq	24(%rdx), %r9
        movq	24(%rsi), %r8
        pextq	%rcx, %r9, %r9
        movq	%r10, 16(%rdi)
        sbbq	%r9, %r8
        movq	32(%rdx), %r10
        movq	32(%rsi), %r9
        pextq	%rcx, %r10, %r10
        movq	%r8, 24(%rdi)
        sbbq	%r10, %r9
        movq	40(%rdx), %r8
        movq	40(%rsi), %r10
        pextq	%rcx, %r8, %r8
        movq	%r9, 32(%rdi)
        sbbq	%r8, %r10
        movq	48(%rdx), %r9
        movq	48(%rsi), %r8
        pextq	%rcx, %r9, %r9
        movq	%r10, 40(%rdi)
        sbbq	%r9, %r8
        movq	56(%rdx), %r10
        movq	56(%rsi), %r9
        pextq	%rcx, %r10, %r10
        movq	%r8, 48(%rdi)
        sbbq	%r10, %r9
        movq	64(%rdx), %r8
        movq	64(%rsi), %r10
        pextq	%rcx, %r8, %r8
        movq	%r9, 56(%rdi)
        sbbq	%r8, %r10
        movq	72(%rdx), %r9
        movq	72(%rsi), %r8
        pextq	%rcx, %r9, %r9
        movq	%r10, 64(%rdi)
        sbbq	%r9, %r8
        movq	80(%rdx), %r10
        movq	80(%rsi), %r9
        pextq	%rcx, %r10, %r10
        movq	%r8, 72(%rdi)
        sbbq	%r10, %r9
        movq	88(%rdx), %r8
        movq	88(%rsi), %r10
        pextq	%rcx, %r8, %r8
        movq	%r9, 80(%rdi)
        sbbq	%r8, %r10
        movq	96(%rdx), %r9
        movq	96(%rsi), %r8
        pextq	%rcx, %r9, %r9
        movq	%r10, 88(%rdi)
        sbbq	%r9, %r8
        movq	104(%rdx), %r10
        movq	104(%rsi), %r9
        pextq	%rcx, %r10, %r10
        movq	%r8, 96(%rdi)
        sbbq	%r10, %r9
        movq	112(%rdx), %r8
        movq	112(%rsi), %r10
        pextq	%rcx, %r8, %r8
        movq	%r9, 104(%rdi)
        sbbq	%r8, %r10
        movq	120(%rdx), %r9
        movq	120(%rsi), %r8
        pextq	%rcx, %r9, %r9
        movq	%r10, 112(%rdi)
        sbbq	%r9, %r8
        movq	128(%rdx), %r10
        movq	128(%rsi), %r9
        pextq	%rcx, %r10, %r10
        movq	%r8, 120(%rdi)
        sbbq	%r10, %r9
        movq	136(%rdx), %r8
        movq	136(%rsi), %r10
        pextq	%rcx, %r8, %r8
        movq	%r9, 128(%rdi)
        sbbq	%r8, %r10
        movq	144(%rdx), %r9
        movq	144(%rsi), %r8
        pextq	%rcx, %r9, %r9
        movq	%r10, 136(%rdi)
        sbbq	%r9, %r8
        movq	152(%rdx), %r10
        movq	152(%rsi), %r9
        pextq	%rcx, %r10, %r10
        movq	%r8, 144(%rdi)
        sbbq	%r10, %r9
        movq	160(%rdx), %r8
        movq	160(%rsi), %r10
        pextq	%rcx, %r8, %r8
        movq	%r9, 152(%rdi)
        sbbq	%r8, %r10
        movq	168(%rdx), %r9
        movq	168(%rsi), %r8
        pextq	%rcx, %r9, %r9
        movq	%r10, 160(%rdi)
        sbbq	%r9, %r8
        movq	176(%rdx), %r10
        movq	176(%rsi), %r9
        pextq	%rcx, %r10, %r10
        movq	%r8, 168(%rdi)
        sbbq	%r10, %r9
        movq	184(%rdx), %r8
        movq	184(%rsi), %r10
        pextq	%rcx, %r8, %r8
        movq	%r9, 176(%rdi)
        sbbq	%r8, %r10
        movq	192(%rdx), %r9
        movq	192(%rsi), %r8
        pextq	%rcx, %r9, %r9
        movq	%r10, 184(%rdi)
        sbbq	%r9, %r8
        movq	200(%rdx), %r10
        movq	200(%rsi), %r9
        pextq	%rcx, %r10, %r10
        movq	%r8, 192(%rdi)
        sbbq	%r10, %r9
        movq	208(%rdx), %r8
        movq	208(%rsi), %r10
        pextq	%rcx, %r8, %r8
        movq	%r9, 200(%rdi)
        sbbq	%r8, %r10
        movq	216(%rdx), %r9
        movq	216(%rsi), %r8
        pextq	%rcx, %r9, %r9
        movq	%r10, 208(%rdi)
        sbbq	%r9, %r8
        movq	224(%rdx), %r10
        movq	224(%rsi), %r9
        pextq	%rcx, %r10, %r10
        movq	%r8, 216(%rdi)
        sbbq	%r10, %r9
        movq	232(%rdx), %r8
        movq	232(%rsi), %r10
        pextq	%rcx, %r8, %r8
        movq	%r9, 224(%rdi)
        sbbq	%r8, %r10
        movq	240(%rdx), %r9
        movq	240(%rsi), %r8
        pextq	%rcx, %r9, %r9
        movq	%r10, 232(%rdi)
        sbbq	%r9, %r8
        movq	248(%rdx), %r10
        movq	248(%rsi), %r9
        pextq	%rcx, %r10, %r10
        movq	%r8, 240(%rdi)
        sbbq	%r10, %r9
        movq	%r9, 248(%rdi)
        sbbq	%rax, %rax
        repz retq
#ifndef __APPLE__
.size	sp_2048_cond_sub_avx2_32,.-sp_2048_cond_sub_avx2_32
#endif /* __APPLE__ */
#endif /* HAVE_INTEL_AVX2 */
/* Compare a with b in constant time.
 *
 * a  A single precision integer.
 * b  A single precision integer.
 * return -ve, 0 or +ve if a is less than, equal to or greater than b
 * respectively.
 */
#ifndef __APPLE__
.text
.globl	sp_2048_cmp_32
.type	sp_2048_cmp_32,@function
.align	16
sp_2048_cmp_32:
#else
.section	__TEXT,__text
.globl	_sp_2048_cmp_32
.p2align	4
_sp_2048_cmp_32:
#endif /* __APPLE__ */
        xorq	%rcx, %rcx
        movq	$-1, %rdx
        movq	$-1, %rax
        movq	$0x01, %r8
        movq	248(%rdi), %r9
        movq	248(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	240(%rdi), %r9
        movq	240(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	232(%rdi), %r9
        movq	232(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	224(%rdi), %r9
        movq	224(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	216(%rdi), %r9
        movq	216(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	208(%rdi), %r9
        movq	208(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	200(%rdi), %r9
        movq	200(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	192(%rdi), %r9
        movq	192(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	184(%rdi), %r9
        movq	184(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	176(%rdi), %r9
        movq	176(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	168(%rdi), %r9
        movq	168(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	160(%rdi), %r9
        movq	160(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	152(%rdi), %r9
        movq	152(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	144(%rdi), %r9
        movq	144(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	136(%rdi), %r9
        movq	136(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	128(%rdi), %r9
        movq	128(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	120(%rdi), %r9
        movq	120(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	112(%rdi), %r9
        movq	112(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	104(%rdi), %r9
        movq	104(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	96(%rdi), %r9
        movq	96(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	88(%rdi), %r9
        movq	88(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	80(%rdi), %r9
        movq	80(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	72(%rdi), %r9
        movq	72(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	64(%rdi), %r9
        movq	64(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	56(%rdi), %r9
        movq	56(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	48(%rdi), %r9
        movq	48(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	40(%rdi), %r9
        movq	40(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	32(%rdi), %r9
        movq	32(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	24(%rdi), %r9
        movq	24(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	16(%rdi), %r9
        movq	16(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	8(%rdi), %r9
        movq	8(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	(%rdi), %r9
        movq	(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        xorq	%rdx, %rax
        repz retq
#ifndef __APPLE__
.size	sp_2048_cmp_32,.-sp_2048_cmp_32
#endif /* __APPLE__ */
#ifndef WC_NO_CACHE_RESISTANT
#ifndef __APPLE__
.text
.globl	sp_2048_get_from_table_32
.type	sp_2048_get_from_table_32,@function
.align	16
sp_2048_get_from_table_32:
#else
.section	__TEXT,__text
.globl	_sp_2048_get_from_table_32
.p2align	4
_sp_2048_get_from_table_32:
#endif /* __APPLE__ */
        movq	$0x01, %rax
        movd	%rdx, %xmm10
        movd	%rax, %xmm11
        pxor	%xmm13, %xmm13
        pshufd	$0x00, %xmm11, %xmm11
        pshufd	$0x00, %xmm10, %xmm10
        # START: 0-7
        pxor	%xmm13, %xmm13
        pxor	%xmm4, %xmm4
        pxor	%xmm5, %xmm5
        pxor	%xmm6, %xmm6
        pxor	%xmm7, %xmm7
        # ENTRY: 0
        movq	(%rsi), %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 1
        movq	8(%rsi), %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 2
        movq	16(%rsi), %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 3
        movq	24(%rsi), %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 4
        movq	32(%rsi), %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 5
        movq	40(%rsi), %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 6
        movq	48(%rsi), %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 7
        movq	56(%rsi), %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 8
        movq	64(%rsi), %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 9
        movq	72(%rsi), %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 10
        movq	80(%rsi), %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 11
        movq	88(%rsi), %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 12
        movq	96(%rsi), %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 13
        movq	104(%rsi), %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 14
        movq	112(%rsi), %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 15
        movq	120(%rsi), %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 16
        movq	128(%rsi), %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 17
        movq	136(%rsi), %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 18
        movq	144(%rsi), %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 19
        movq	152(%rsi), %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 20
        movq	160(%rsi), %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 21
        movq	168(%rsi), %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 22
        movq	176(%rsi), %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 23
        movq	184(%rsi), %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 24
        movq	192(%rsi), %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 25
        movq	200(%rsi), %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 26
        movq	208(%rsi), %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 27
        movq	216(%rsi), %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 28
        movq	224(%rsi), %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 29
        movq	232(%rsi), %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 30
        movq	240(%rsi), %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 31
        movq	248(%rsi), %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 32
        movq	256(%rsi), %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 33
        movq	264(%rsi), %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 34
        movq	272(%rsi), %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 35
        movq	280(%rsi), %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 36
        movq	288(%rsi), %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 37
        movq	296(%rsi), %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 38
        movq	304(%rsi), %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 39
        movq	312(%rsi), %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 40
        movq	320(%rsi), %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 41
        movq	328(%rsi), %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 42
        movq	336(%rsi), %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 43
        movq	344(%rsi), %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 44
        movq	352(%rsi), %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 45
        movq	360(%rsi), %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 46
        movq	368(%rsi), %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 47
        movq	376(%rsi), %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 48
        movq	384(%rsi), %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 49
        movq	392(%rsi), %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 50
        movq	400(%rsi), %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 51
        movq	408(%rsi), %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 52
        movq	416(%rsi), %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 53
        movq	424(%rsi), %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 54
        movq	432(%rsi), %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 55
        movq	440(%rsi), %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 56
        movq	448(%rsi), %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 57
        movq	456(%rsi), %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 58
        movq	464(%rsi), %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 59
        movq	472(%rsi), %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 60
        movq	480(%rsi), %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 61
        movq	488(%rsi), %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 62
        movq	496(%rsi), %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 63
        movq	504(%rsi), %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        movdqu	%xmm4, (%rdi)
        movdqu	%xmm5, 16(%rdi)
        movdqu	%xmm6, 32(%rdi)
        movdqu	%xmm7, 48(%rdi)
        addq	$0x40, %rdi
        # END: 0-7
        # START: 8-15
        pxor	%xmm13, %xmm13
        pxor	%xmm4, %xmm4
        pxor	%xmm5, %xmm5
        pxor	%xmm6, %xmm6
        pxor	%xmm7, %xmm7
        # ENTRY: 0
        movq	(%rsi), %rcx
        addq	$0x40, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 1
        movq	8(%rsi), %rcx
        addq	$0x40, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 2
        movq	16(%rsi), %rcx
        addq	$0x40, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 3
        movq	24(%rsi), %rcx
        addq	$0x40, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 4
        movq	32(%rsi), %rcx
        addq	$0x40, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 5
        movq	40(%rsi), %rcx
        addq	$0x40, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 6
        movq	48(%rsi), %rcx
        addq	$0x40, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 7
        movq	56(%rsi), %rcx
        addq	$0x40, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 8
        movq	64(%rsi), %rcx
        addq	$0x40, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 9
        movq	72(%rsi), %rcx
        addq	$0x40, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 10
        movq	80(%rsi), %rcx
        addq	$0x40, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 11
        movq	88(%rsi), %rcx
        addq	$0x40, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 12
        movq	96(%rsi), %rcx
        addq	$0x40, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 13
        movq	104(%rsi), %rcx
        addq	$0x40, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 14
        movq	112(%rsi), %rcx
        addq	$0x40, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 15
        movq	120(%rsi), %rcx
        addq	$0x40, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 16
        movq	128(%rsi), %rcx
        addq	$0x40, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 17
        movq	136(%rsi), %rcx
        addq	$0x40, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 18
        movq	144(%rsi), %rcx
        addq	$0x40, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 19
        movq	152(%rsi), %rcx
        addq	$0x40, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 20
        movq	160(%rsi), %rcx
        addq	$0x40, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 21
        movq	168(%rsi), %rcx
        addq	$0x40, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 22
        movq	176(%rsi), %rcx
        addq	$0x40, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 23
        movq	184(%rsi), %rcx
        addq	$0x40, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 24
        movq	192(%rsi), %rcx
        addq	$0x40, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 25
        movq	200(%rsi), %rcx
        addq	$0x40, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 26
        movq	208(%rsi), %rcx
        addq	$0x40, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 27
        movq	216(%rsi), %rcx
        addq	$0x40, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 28
        movq	224(%rsi), %rcx
        addq	$0x40, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 29
        movq	232(%rsi), %rcx
        addq	$0x40, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 30
        movq	240(%rsi), %rcx
        addq	$0x40, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 31
        movq	248(%rsi), %rcx
        addq	$0x40, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 32
        movq	256(%rsi), %rcx
        addq	$0x40, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 33
        movq	264(%rsi), %rcx
        addq	$0x40, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 34
        movq	272(%rsi), %rcx
        addq	$0x40, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 35
        movq	280(%rsi), %rcx
        addq	$0x40, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 36
        movq	288(%rsi), %rcx
        addq	$0x40, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 37
        movq	296(%rsi), %rcx
        addq	$0x40, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 38
        movq	304(%rsi), %rcx
        addq	$0x40, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 39
        movq	312(%rsi), %rcx
        addq	$0x40, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 40
        movq	320(%rsi), %rcx
        addq	$0x40, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 41
        movq	328(%rsi), %rcx
        addq	$0x40, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 42
        movq	336(%rsi), %rcx
        addq	$0x40, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 43
        movq	344(%rsi), %rcx
        addq	$0x40, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 44
        movq	352(%rsi), %rcx
        addq	$0x40, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 45
        movq	360(%rsi), %rcx
        addq	$0x40, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 46
        movq	368(%rsi), %rcx
        addq	$0x40, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 47
        movq	376(%rsi), %rcx
        addq	$0x40, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 48
        movq	384(%rsi), %rcx
        addq	$0x40, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 49
        movq	392(%rsi), %rcx
        addq	$0x40, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 50
        movq	400(%rsi), %rcx
        addq	$0x40, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 51
        movq	408(%rsi), %rcx
        addq	$0x40, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 52
        movq	416(%rsi), %rcx
        addq	$0x40, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 53
        movq	424(%rsi), %rcx
        addq	$0x40, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 54
        movq	432(%rsi), %rcx
        addq	$0x40, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 55
        movq	440(%rsi), %rcx
        addq	$0x40, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 56
        movq	448(%rsi), %rcx
        addq	$0x40, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 57
        movq	456(%rsi), %rcx
        addq	$0x40, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 58
        movq	464(%rsi), %rcx
        addq	$0x40, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 59
        movq	472(%rsi), %rcx
        addq	$0x40, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 60
        movq	480(%rsi), %rcx
        addq	$0x40, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 61
        movq	488(%rsi), %rcx
        addq	$0x40, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 62
        movq	496(%rsi), %rcx
        addq	$0x40, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 63
        movq	504(%rsi), %rcx
        addq	$0x40, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        movdqu	%xmm4, (%rdi)
        movdqu	%xmm5, 16(%rdi)
        movdqu	%xmm6, 32(%rdi)
        movdqu	%xmm7, 48(%rdi)
        addq	$0x40, %rdi
        # END: 8-15
        # START: 16-23
        pxor	%xmm13, %xmm13
        pxor	%xmm4, %xmm4
        pxor	%xmm5, %xmm5
        pxor	%xmm6, %xmm6
        pxor	%xmm7, %xmm7
        # ENTRY: 0
        movq	(%rsi), %rcx
        addq	$0x80, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 1
        movq	8(%rsi), %rcx
        addq	$0x80, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 2
        movq	16(%rsi), %rcx
        addq	$0x80, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 3
        movq	24(%rsi), %rcx
        addq	$0x80, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 4
        movq	32(%rsi), %rcx
        addq	$0x80, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 5
        movq	40(%rsi), %rcx
        addq	$0x80, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 6
        movq	48(%rsi), %rcx
        addq	$0x80, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 7
        movq	56(%rsi), %rcx
        addq	$0x80, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 8
        movq	64(%rsi), %rcx
        addq	$0x80, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 9
        movq	72(%rsi), %rcx
        addq	$0x80, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 10
        movq	80(%rsi), %rcx
        addq	$0x80, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 11
        movq	88(%rsi), %rcx
        addq	$0x80, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 12
        movq	96(%rsi), %rcx
        addq	$0x80, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 13
        movq	104(%rsi), %rcx
        addq	$0x80, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 14
        movq	112(%rsi), %rcx
        addq	$0x80, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 15
        movq	120(%rsi), %rcx
        addq	$0x80, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 16
        movq	128(%rsi), %rcx
        addq	$0x80, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 17
        movq	136(%rsi), %rcx
        addq	$0x80, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 18
        movq	144(%rsi), %rcx
        addq	$0x80, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 19
        movq	152(%rsi), %rcx
        addq	$0x80, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 20
        movq	160(%rsi), %rcx
        addq	$0x80, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 21
        movq	168(%rsi), %rcx
        addq	$0x80, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 22
        movq	176(%rsi), %rcx
        addq	$0x80, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 23
        movq	184(%rsi), %rcx
        addq	$0x80, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 24
        movq	192(%rsi), %rcx
        addq	$0x80, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 25
        movq	200(%rsi), %rcx
        addq	$0x80, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 26
        movq	208(%rsi), %rcx
        addq	$0x80, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 27
        movq	216(%rsi), %rcx
        addq	$0x80, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 28
        movq	224(%rsi), %rcx
        addq	$0x80, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 29
        movq	232(%rsi), %rcx
        addq	$0x80, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 30
        movq	240(%rsi), %rcx
        addq	$0x80, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 31
        movq	248(%rsi), %rcx
        addq	$0x80, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 32
        movq	256(%rsi), %rcx
        addq	$0x80, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 33
        movq	264(%rsi), %rcx
        addq	$0x80, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 34
        movq	272(%rsi), %rcx
        addq	$0x80, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 35
        movq	280(%rsi), %rcx
        addq	$0x80, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 36
        movq	288(%rsi), %rcx
        addq	$0x80, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 37
        movq	296(%rsi), %rcx
        addq	$0x80, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 38
        movq	304(%rsi), %rcx
        addq	$0x80, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 39
        movq	312(%rsi), %rcx
        addq	$0x80, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 40
        movq	320(%rsi), %rcx
        addq	$0x80, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 41
        movq	328(%rsi), %rcx
        addq	$0x80, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 42
        movq	336(%rsi), %rcx
        addq	$0x80, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 43
        movq	344(%rsi), %rcx
        addq	$0x80, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 44
        movq	352(%rsi), %rcx
        addq	$0x80, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 45
        movq	360(%rsi), %rcx
        addq	$0x80, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 46
        movq	368(%rsi), %rcx
        addq	$0x80, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 47
        movq	376(%rsi), %rcx
        addq	$0x80, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 48
        movq	384(%rsi), %rcx
        addq	$0x80, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 49
        movq	392(%rsi), %rcx
        addq	$0x80, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 50
        movq	400(%rsi), %rcx
        addq	$0x80, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 51
        movq	408(%rsi), %rcx
        addq	$0x80, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 52
        movq	416(%rsi), %rcx
        addq	$0x80, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 53
        movq	424(%rsi), %rcx
        addq	$0x80, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 54
        movq	432(%rsi), %rcx
        addq	$0x80, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 55
        movq	440(%rsi), %rcx
        addq	$0x80, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 56
        movq	448(%rsi), %rcx
        addq	$0x80, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 57
        movq	456(%rsi), %rcx
        addq	$0x80, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 58
        movq	464(%rsi), %rcx
        addq	$0x80, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 59
        movq	472(%rsi), %rcx
        addq	$0x80, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 60
        movq	480(%rsi), %rcx
        addq	$0x80, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 61
        movq	488(%rsi), %rcx
        addq	$0x80, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 62
        movq	496(%rsi), %rcx
        addq	$0x80, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 63
        movq	504(%rsi), %rcx
        addq	$0x80, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        movdqu	%xmm4, (%rdi)
        movdqu	%xmm5, 16(%rdi)
        movdqu	%xmm6, 32(%rdi)
        movdqu	%xmm7, 48(%rdi)
        addq	$0x40, %rdi
        # END: 16-23
        # START: 24-31
        pxor	%xmm13, %xmm13
        pxor	%xmm4, %xmm4
        pxor	%xmm5, %xmm5
        pxor	%xmm6, %xmm6
        pxor	%xmm7, %xmm7
        # ENTRY: 0
        movq	(%rsi), %rcx
        addq	$0xc0, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 1
        movq	8(%rsi), %rcx
        addq	$0xc0, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 2
        movq	16(%rsi), %rcx
        addq	$0xc0, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 3
        movq	24(%rsi), %rcx
        addq	$0xc0, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 4
        movq	32(%rsi), %rcx
        addq	$0xc0, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 5
        movq	40(%rsi), %rcx
        addq	$0xc0, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 6
        movq	48(%rsi), %rcx
        addq	$0xc0, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 7
        movq	56(%rsi), %rcx
        addq	$0xc0, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 8
        movq	64(%rsi), %rcx
        addq	$0xc0, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 9
        movq	72(%rsi), %rcx
        addq	$0xc0, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 10
        movq	80(%rsi), %rcx
        addq	$0xc0, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 11
        movq	88(%rsi), %rcx
        addq	$0xc0, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 12
        movq	96(%rsi), %rcx
        addq	$0xc0, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 13
        movq	104(%rsi), %rcx
        addq	$0xc0, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 14
        movq	112(%rsi), %rcx
        addq	$0xc0, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 15
        movq	120(%rsi), %rcx
        addq	$0xc0, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 16
        movq	128(%rsi), %rcx
        addq	$0xc0, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 17
        movq	136(%rsi), %rcx
        addq	$0xc0, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 18
        movq	144(%rsi), %rcx
        addq	$0xc0, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 19
        movq	152(%rsi), %rcx
        addq	$0xc0, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 20
        movq	160(%rsi), %rcx
        addq	$0xc0, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 21
        movq	168(%rsi), %rcx
        addq	$0xc0, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 22
        movq	176(%rsi), %rcx
        addq	$0xc0, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 23
        movq	184(%rsi), %rcx
        addq	$0xc0, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 24
        movq	192(%rsi), %rcx
        addq	$0xc0, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 25
        movq	200(%rsi), %rcx
        addq	$0xc0, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 26
        movq	208(%rsi), %rcx
        addq	$0xc0, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 27
        movq	216(%rsi), %rcx
        addq	$0xc0, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 28
        movq	224(%rsi), %rcx
        addq	$0xc0, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 29
        movq	232(%rsi), %rcx
        addq	$0xc0, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 30
        movq	240(%rsi), %rcx
        addq	$0xc0, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 31
        movq	248(%rsi), %rcx
        addq	$0xc0, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 32
        movq	256(%rsi), %rcx
        addq	$0xc0, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 33
        movq	264(%rsi), %rcx
        addq	$0xc0, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 34
        movq	272(%rsi), %rcx
        addq	$0xc0, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 35
        movq	280(%rsi), %rcx
        addq	$0xc0, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 36
        movq	288(%rsi), %rcx
        addq	$0xc0, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 37
        movq	296(%rsi), %rcx
        addq	$0xc0, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 38
        movq	304(%rsi), %rcx
        addq	$0xc0, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 39
        movq	312(%rsi), %rcx
        addq	$0xc0, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 40
        movq	320(%rsi), %rcx
        addq	$0xc0, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 41
        movq	328(%rsi), %rcx
        addq	$0xc0, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 42
        movq	336(%rsi), %rcx
        addq	$0xc0, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 43
        movq	344(%rsi), %rcx
        addq	$0xc0, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 44
        movq	352(%rsi), %rcx
        addq	$0xc0, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 45
        movq	360(%rsi), %rcx
        addq	$0xc0, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 46
        movq	368(%rsi), %rcx
        addq	$0xc0, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 47
        movq	376(%rsi), %rcx
        addq	$0xc0, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 48
        movq	384(%rsi), %rcx
        addq	$0xc0, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 49
        movq	392(%rsi), %rcx
        addq	$0xc0, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 50
        movq	400(%rsi), %rcx
        addq	$0xc0, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 51
        movq	408(%rsi), %rcx
        addq	$0xc0, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 52
        movq	416(%rsi), %rcx
        addq	$0xc0, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 53
        movq	424(%rsi), %rcx
        addq	$0xc0, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 54
        movq	432(%rsi), %rcx
        addq	$0xc0, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 55
        movq	440(%rsi), %rcx
        addq	$0xc0, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 56
        movq	448(%rsi), %rcx
        addq	$0xc0, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 57
        movq	456(%rsi), %rcx
        addq	$0xc0, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 58
        movq	464(%rsi), %rcx
        addq	$0xc0, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 59
        movq	472(%rsi), %rcx
        addq	$0xc0, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 60
        movq	480(%rsi), %rcx
        addq	$0xc0, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 61
        movq	488(%rsi), %rcx
        addq	$0xc0, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 62
        movq	496(%rsi), %rcx
        addq	$0xc0, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 63
        movq	504(%rsi), %rcx
        addq	$0xc0, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        movdqu	%xmm4, (%rdi)
        movdqu	%xmm5, 16(%rdi)
        movdqu	%xmm6, 32(%rdi)
        movdqu	%xmm7, 48(%rdi)
        # END: 24-31
        repz retq
#ifndef __APPLE__
.size	sp_2048_get_from_table_32,.-sp_2048_get_from_table_32
#endif /* __APPLE__ */
#endif /* !WC_NO_CACHE_RESISTANT */
#ifdef HAVE_INTEL_AVX2
/* Reduce the number back to 2048 bits using Montgomery reduction.
 *
 * a   A single precision number to reduce in place.
 * m   The single precision number representing the modulus.
 * mp  The digit representing the negative inverse of m mod 2^n.
 */
#ifndef __APPLE__
.text
.globl	sp_2048_mont_reduce_avx2_32
.type	sp_2048_mont_reduce_avx2_32,@function
.align	16
sp_2048_mont_reduce_avx2_32:
#else
.section	__TEXT,__text
.globl	_sp_2048_mont_reduce_avx2_32
.p2align	4
_sp_2048_mont_reduce_avx2_32:
#endif /* __APPLE__ */
        pushq	%r12
        pushq	%r13
        pushq	%r14
        pushq	%r15
        pushq	%rbx
        pushq	%rbp
        movq	%rdx, %r8
        xorq	%rbp, %rbp
        # i = 32
        movq	$32, %r9
        movq	(%rdi), %r12
        movq	8(%rdi), %r13
        movq	16(%rdi), %r14
        movq	24(%rdi), %r15
        addq	$0x80, %rdi
        xorq	%rbp, %rbp
L_2048_mont_reduce_avx2_32_loop:
        # mu = a[i] * mp
        movq	%r12, %rdx
        movq	%r12, %r10
        imulq	%r8, %rdx
        xorq	%rbx, %rbx
        # a[i+0] += m[0] * mu
        mulxq	(%rsi), %rax, %rcx
        movq	%r13, %r12
        adcxq	%rax, %r10
        adoxq	%rcx, %r12
        # a[i+1] += m[1] * mu
        mulxq	8(%rsi), %rax, %rcx
        movq	%r14, %r13
        adcxq	%rax, %r12
        adoxq	%rcx, %r13
        # a[i+2] += m[2] * mu
        mulxq	16(%rsi), %rax, %rcx
        movq	%r15, %r14
        adcxq	%rax, %r13
        adoxq	%rcx, %r14
        # a[i+3] += m[3] * mu
        mulxq	24(%rsi), %rax, %rcx
        movq	-96(%rdi), %r15
        adcxq	%rax, %r14
        adoxq	%rcx, %r15
        # a[i+4] += m[4] * mu
        mulxq	32(%rsi), %rax, %rcx
        movq	-88(%rdi), %r11
        adcxq	%rax, %r15
        adoxq	%rcx, %r11
        # a[i+5] += m[5] * mu
        mulxq	40(%rsi), %rax, %rcx
        movq	-80(%rdi), %r10
        adcxq	%rax, %r11
        adoxq	%rcx, %r10
        movq	%r11, -88(%rdi)
        # a[i+6] += m[6] * mu
        mulxq	48(%rsi), %rax, %rcx
        movq	-72(%rdi), %r11
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        movq	%r10, -80(%rdi)
        # a[i+7] += m[7] * mu
        mulxq	56(%rsi), %rax, %rcx
        movq	-64(%rdi), %r10
        adcxq	%rax, %r11
        adoxq	%rcx, %r10
        movq	%r11, -72(%rdi)
        # a[i+8] += m[8] * mu
        mulxq	64(%rsi), %rax, %rcx
        movq	-56(%rdi), %r11
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        movq	%r10, -64(%rdi)
        # a[i+9] += m[9] * mu
        mulxq	72(%rsi), %rax, %rcx
        movq	-48(%rdi), %r10
        adcxq	%rax, %r11
        adoxq	%rcx, %r10
        movq	%r11, -56(%rdi)
        # a[i+10] += m[10] * mu
        mulxq	80(%rsi), %rax, %rcx
        movq	-40(%rdi), %r11
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        movq	%r10, -48(%rdi)
        # a[i+11] += m[11] * mu
        mulxq	88(%rsi), %rax, %rcx
        movq	-32(%rdi), %r10
        adcxq	%rax, %r11
        adoxq	%rcx, %r10
        movq	%r11, -40(%rdi)
        # a[i+12] += m[12] * mu
        mulxq	96(%rsi), %rax, %rcx
        movq	-24(%rdi), %r11
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        movq	%r10, -32(%rdi)
        # a[i+13] += m[13] * mu
        mulxq	104(%rsi), %rax, %rcx
        movq	-16(%rdi), %r10
        adcxq	%rax, %r11
        adoxq	%rcx, %r10
        movq	%r11, -24(%rdi)
        # a[i+14] += m[14] * mu
        mulxq	112(%rsi), %rax, %rcx
        movq	-8(%rdi), %r11
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        movq	%r10, -16(%rdi)
        # a[i+15] += m[15] * mu
        mulxq	120(%rsi), %rax, %rcx
        movq	(%rdi), %r10
        adcxq	%rax, %r11
        adoxq	%rcx, %r10
        movq	%r11, -8(%rdi)
        # a[i+16] += m[16] * mu
        mulxq	128(%rsi), %rax, %rcx
        movq	8(%rdi), %r11
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        movq	%r10, (%rdi)
        # a[i+17] += m[17] * mu
        mulxq	136(%rsi), %rax, %rcx
        movq	16(%rdi), %r10
        adcxq	%rax, %r11
        adoxq	%rcx, %r10
        movq	%r11, 8(%rdi)
        # a[i+18] += m[18] * mu
        mulxq	144(%rsi), %rax, %rcx
        movq	24(%rdi), %r11
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        movq	%r10, 16(%rdi)
        # a[i+19] += m[19] * mu
        mulxq	152(%rsi), %rax, %rcx
        movq	32(%rdi), %r10
        adcxq	%rax, %r11
        adoxq	%rcx, %r10
        movq	%r11, 24(%rdi)
        # a[i+20] += m[20] * mu
        mulxq	160(%rsi), %rax, %rcx
        movq	40(%rdi), %r11
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        movq	%r10, 32(%rdi)
        # a[i+21] += m[21] * mu
        mulxq	168(%rsi), %rax, %rcx
        movq	48(%rdi), %r10
        adcxq	%rax, %r11
        adoxq	%rcx, %r10
        movq	%r11, 40(%rdi)
        # a[i+22] += m[22] * mu
        mulxq	176(%rsi), %rax, %rcx
        movq	56(%rdi), %r11
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        movq	%r10, 48(%rdi)
        # a[i+23] += m[23] * mu
        mulxq	184(%rsi), %rax, %rcx
        movq	64(%rdi), %r10
        adcxq	%rax, %r11
        adoxq	%rcx, %r10
        movq	%r11, 56(%rdi)
        # a[i+24] += m[24] * mu
        mulxq	192(%rsi), %rax, %rcx
        movq	72(%rdi), %r11
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        movq	%r10, 64(%rdi)
        # a[i+25] += m[25] * mu
        mulxq	200(%rsi), %rax, %rcx
        movq	80(%rdi), %r10
        adcxq	%rax, %r11
        adoxq	%rcx, %r10
        movq	%r11, 72(%rdi)
        # a[i+26] += m[26] * mu
        mulxq	208(%rsi), %rax, %rcx
        movq	88(%rdi), %r11
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        movq	%r10, 80(%rdi)
        # a[i+27] += m[27] * mu
        mulxq	216(%rsi), %rax, %rcx
        movq	96(%rdi), %r10
        adcxq	%rax, %r11
        adoxq	%rcx, %r10
        movq	%r11, 88(%rdi)
        # a[i+28] += m[28] * mu
        mulxq	224(%rsi), %rax, %rcx
        movq	104(%rdi), %r11
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        movq	%r10, 96(%rdi)
        # a[i+29] += m[29] * mu
        mulxq	232(%rsi), %rax, %rcx
        movq	112(%rdi), %r10
        adcxq	%rax, %r11
        adoxq	%rcx, %r10
        movq	%r11, 104(%rdi)
        # a[i+30] += m[30] * mu
        mulxq	240(%rsi), %rax, %rcx
        movq	120(%rdi), %r11
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        movq	%r10, 112(%rdi)
        # a[i+31] += m[31] * mu
        mulxq	248(%rsi), %rax, %rcx
        movq	128(%rdi), %r10
        adcxq	%rax, %r11
        adoxq	%rcx, %r10
        movq	%r11, 120(%rdi)
        adcxq	%rbp, %r10
        movq	%rbx, %rbp
        movq	%r10, 128(%rdi)
        adoxq	%rbx, %rbp
        adcxq	%rbx, %rbp
        # a += 1
        addq	$8, %rdi
        # i -= 1
        subq	$0x01, %r9
        jnz	L_2048_mont_reduce_avx2_32_loop
        subq	$0x80, %rdi
        negq	%rbp
        movq	%rdi, %r8
        subq	$0x100, %rdi
        movq	(%rsi), %rcx
        movq	%r12, %rdx
        pextq	%rbp, %rcx, %rcx
        subq	%rcx, %rdx
        movq	8(%rsi), %rcx
        movq	%r13, %rax
        pextq	%rbp, %rcx, %rcx
        movq	%rdx, (%rdi)
        sbbq	%rcx, %rax
        movq	16(%rsi), %rdx
        movq	%r14, %rcx
        pextq	%rbp, %rdx, %rdx
        movq	%rax, 8(%rdi)
        sbbq	%rdx, %rcx
        movq	24(%rsi), %rax
        movq	%r15, %rdx
        pextq	%rbp, %rax, %rax
        movq	%rcx, 16(%rdi)
        sbbq	%rax, %rdx
        movq	32(%rsi), %rcx
        movq	32(%r8), %rax
        pextq	%rbp, %rcx, %rcx
        movq	%rdx, 24(%rdi)
        sbbq	%rcx, %rax
        movq	40(%rsi), %rdx
        movq	40(%r8), %rcx
        pextq	%rbp, %rdx, %rdx
        movq	%rax, 32(%rdi)
        sbbq	%rdx, %rcx
        movq	48(%rsi), %rax
        movq	48(%r8), %rdx
        pextq	%rbp, %rax, %rax
        movq	%rcx, 40(%rdi)
        sbbq	%rax, %rdx
        movq	56(%rsi), %rcx
        movq	56(%r8), %rax
        pextq	%rbp, %rcx, %rcx
        movq	%rdx, 48(%rdi)
        sbbq	%rcx, %rax
        movq	64(%rsi), %rdx
        movq	64(%r8), %rcx
        pextq	%rbp, %rdx, %rdx
        movq	%rax, 56(%rdi)
        sbbq	%rdx, %rcx
        movq	72(%rsi), %rax
        movq	72(%r8), %rdx
        pextq	%rbp, %rax, %rax
        movq	%rcx, 64(%rdi)
        sbbq	%rax, %rdx
        movq	80(%rsi), %rcx
        movq	80(%r8), %rax
        pextq	%rbp, %rcx, %rcx
        movq	%rdx, 72(%rdi)
        sbbq	%rcx, %rax
        movq	88(%rsi), %rdx
        movq	88(%r8), %rcx
        pextq	%rbp, %rdx, %rdx
        movq	%rax, 80(%rdi)
        sbbq	%rdx, %rcx
        movq	96(%rsi), %rax
        movq	96(%r8), %rdx
        pextq	%rbp, %rax, %rax
        movq	%rcx, 88(%rdi)
        sbbq	%rax, %rdx
        movq	104(%rsi), %rcx
        movq	104(%r8), %rax
        pextq	%rbp, %rcx, %rcx
        movq	%rdx, 96(%rdi)
        sbbq	%rcx, %rax
        movq	112(%rsi), %rdx
        movq	112(%r8), %rcx
        pextq	%rbp, %rdx, %rdx
        movq	%rax, 104(%rdi)
        sbbq	%rdx, %rcx
        movq	120(%rsi), %rax
        movq	120(%r8), %rdx
        pextq	%rbp, %rax, %rax
        movq	%rcx, 112(%rdi)
        sbbq	%rax, %rdx
        movq	128(%rsi), %rcx
        movq	128(%r8), %rax
        pextq	%rbp, %rcx, %rcx
        movq	%rdx, 120(%rdi)
        sbbq	%rcx, %rax
        movq	136(%rsi), %rdx
        movq	136(%r8), %rcx
        pextq	%rbp, %rdx, %rdx
        movq	%rax, 128(%rdi)
        sbbq	%rdx, %rcx
        movq	144(%rsi), %rax
        movq	144(%r8), %rdx
        pextq	%rbp, %rax, %rax
        movq	%rcx, 136(%rdi)
        sbbq	%rax, %rdx
        movq	152(%rsi), %rcx
        movq	152(%r8), %rax
        pextq	%rbp, %rcx, %rcx
        movq	%rdx, 144(%rdi)
        sbbq	%rcx, %rax
        movq	160(%rsi), %rdx
        movq	160(%r8), %rcx
        pextq	%rbp, %rdx, %rdx
        movq	%rax, 152(%rdi)
        sbbq	%rdx, %rcx
        movq	168(%rsi), %rax
        movq	168(%r8), %rdx
        pextq	%rbp, %rax, %rax
        movq	%rcx, 160(%rdi)
        sbbq	%rax, %rdx
        movq	176(%rsi), %rcx
        movq	176(%r8), %rax
        pextq	%rbp, %rcx, %rcx
        movq	%rdx, 168(%rdi)
        sbbq	%rcx, %rax
        movq	184(%rsi), %rdx
        movq	184(%r8), %rcx
        pextq	%rbp, %rdx, %rdx
        movq	%rax, 176(%rdi)
        sbbq	%rdx, %rcx
        movq	192(%rsi), %rax
        movq	192(%r8), %rdx
        pextq	%rbp, %rax, %rax
        movq	%rcx, 184(%rdi)
        sbbq	%rax, %rdx
        movq	200(%rsi), %rcx
        movq	200(%r8), %rax
        pextq	%rbp, %rcx, %rcx
        movq	%rdx, 192(%rdi)
        sbbq	%rcx, %rax
        movq	208(%rsi), %rdx
        movq	208(%r8), %rcx
        pextq	%rbp, %rdx, %rdx
        movq	%rax, 200(%rdi)
        sbbq	%rdx, %rcx
        movq	216(%rsi), %rax
        movq	216(%r8), %rdx
        pextq	%rbp, %rax, %rax
        movq	%rcx, 208(%rdi)
        sbbq	%rax, %rdx
        movq	224(%rsi), %rcx
        movq	224(%r8), %rax
        pextq	%rbp, %rcx, %rcx
        movq	%rdx, 216(%rdi)
        sbbq	%rcx, %rax
        movq	232(%rsi), %rdx
        movq	232(%r8), %rcx
        pextq	%rbp, %rdx, %rdx
        movq	%rax, 224(%rdi)
        sbbq	%rdx, %rcx
        movq	240(%rsi), %rax
        movq	240(%r8), %rdx
        pextq	%rbp, %rax, %rax
        movq	%rcx, 232(%rdi)
        sbbq	%rax, %rdx
        movq	248(%rsi), %rcx
        movq	248(%r8), %rax
        pextq	%rbp, %rcx, %rcx
        movq	%rdx, 240(%rdi)
        sbbq	%rcx, %rax
        movq	%rax, 248(%rdi)
        popq	%rbp
        popq	%rbx
        popq	%r15
        popq	%r14
        popq	%r13
        popq	%r12
        repz retq
#ifndef __APPLE__
.size	sp_2048_mont_reduce_avx2_32,.-sp_2048_mont_reduce_avx2_32
#endif /* __APPLE__ */
#endif /* HAVE_INTEL_AVX2 */
#ifndef WC_NO_CACHE_RESISTANT
#ifndef __APPLE__
.text
.globl	sp_2048_get_from_table_avx2_32
.type	sp_2048_get_from_table_avx2_32,@function
.align	16
sp_2048_get_from_table_avx2_32:
#else
.section	__TEXT,__text
.globl	_sp_2048_get_from_table_avx2_32
.p2align	4
_sp_2048_get_from_table_avx2_32:
#endif /* __APPLE__ */
        movq	$0x01, %rax
        movd	%rdx, %xmm10
        movd	%rax, %xmm11
        vpxor	%ymm13, %ymm13, %ymm13
        vpermd	%ymm10, %ymm13, %ymm10
        vpermd	%ymm11, %ymm13, %ymm11
        # START: 0-15
        vpxor	%ymm13, %ymm13, %ymm13
        vpxor	%ymm4, %ymm4, %ymm4
        vpxor	%ymm5, %ymm5, %ymm5
        vpxor	%ymm6, %ymm6, %ymm6
        vpxor	%ymm7, %ymm7, %ymm7
        # ENTRY: 0
        movq	(%rsi), %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vmovdqu	64(%rcx), %ymm2
        vmovdqu	96(%rcx), %ymm3
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpand	%ymm12, %ymm2, %ymm2
        vpand	%ymm12, %ymm3, %ymm3
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpor	%ymm2, %ymm6, %ymm6
        vpor	%ymm3, %ymm7, %ymm7
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 1
        movq	8(%rsi), %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vmovdqu	64(%rcx), %ymm2
        vmovdqu	96(%rcx), %ymm3
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpand	%ymm12, %ymm2, %ymm2
        vpand	%ymm12, %ymm3, %ymm3
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpor	%ymm2, %ymm6, %ymm6
        vpor	%ymm3, %ymm7, %ymm7
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 2
        movq	16(%rsi), %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vmovdqu	64(%rcx), %ymm2
        vmovdqu	96(%rcx), %ymm3
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpand	%ymm12, %ymm2, %ymm2
        vpand	%ymm12, %ymm3, %ymm3
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpor	%ymm2, %ymm6, %ymm6
        vpor	%ymm3, %ymm7, %ymm7
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 3
        movq	24(%rsi), %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vmovdqu	64(%rcx), %ymm2
        vmovdqu	96(%rcx), %ymm3
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpand	%ymm12, %ymm2, %ymm2
        vpand	%ymm12, %ymm3, %ymm3
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpor	%ymm2, %ymm6, %ymm6
        vpor	%ymm3, %ymm7, %ymm7
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 4
        movq	32(%rsi), %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vmovdqu	64(%rcx), %ymm2
        vmovdqu	96(%rcx), %ymm3
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpand	%ymm12, %ymm2, %ymm2
        vpand	%ymm12, %ymm3, %ymm3
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpor	%ymm2, %ymm6, %ymm6
        vpor	%ymm3, %ymm7, %ymm7
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 5
        movq	40(%rsi), %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vmovdqu	64(%rcx), %ymm2
        vmovdqu	96(%rcx), %ymm3
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpand	%ymm12, %ymm2, %ymm2
        vpand	%ymm12, %ymm3, %ymm3
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpor	%ymm2, %ymm6, %ymm6
        vpor	%ymm3, %ymm7, %ymm7
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 6
        movq	48(%rsi), %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vmovdqu	64(%rcx), %ymm2
        vmovdqu	96(%rcx), %ymm3
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpand	%ymm12, %ymm2, %ymm2
        vpand	%ymm12, %ymm3, %ymm3
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpor	%ymm2, %ymm6, %ymm6
        vpor	%ymm3, %ymm7, %ymm7
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 7
        movq	56(%rsi), %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vmovdqu	64(%rcx), %ymm2
        vmovdqu	96(%rcx), %ymm3
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpand	%ymm12, %ymm2, %ymm2
        vpand	%ymm12, %ymm3, %ymm3
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpor	%ymm2, %ymm6, %ymm6
        vpor	%ymm3, %ymm7, %ymm7
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 8
        movq	64(%rsi), %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vmovdqu	64(%rcx), %ymm2
        vmovdqu	96(%rcx), %ymm3
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpand	%ymm12, %ymm2, %ymm2
        vpand	%ymm12, %ymm3, %ymm3
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpor	%ymm2, %ymm6, %ymm6
        vpor	%ymm3, %ymm7, %ymm7
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 9
        movq	72(%rsi), %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vmovdqu	64(%rcx), %ymm2
        vmovdqu	96(%rcx), %ymm3
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpand	%ymm12, %ymm2, %ymm2
        vpand	%ymm12, %ymm3, %ymm3
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpor	%ymm2, %ymm6, %ymm6
        vpor	%ymm3, %ymm7, %ymm7
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 10
        movq	80(%rsi), %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vmovdqu	64(%rcx), %ymm2
        vmovdqu	96(%rcx), %ymm3
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpand	%ymm12, %ymm2, %ymm2
        vpand	%ymm12, %ymm3, %ymm3
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpor	%ymm2, %ymm6, %ymm6
        vpor	%ymm3, %ymm7, %ymm7
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 11
        movq	88(%rsi), %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vmovdqu	64(%rcx), %ymm2
        vmovdqu	96(%rcx), %ymm3
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpand	%ymm12, %ymm2, %ymm2
        vpand	%ymm12, %ymm3, %ymm3
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpor	%ymm2, %ymm6, %ymm6
        vpor	%ymm3, %ymm7, %ymm7
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 12
        movq	96(%rsi), %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vmovdqu	64(%rcx), %ymm2
        vmovdqu	96(%rcx), %ymm3
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpand	%ymm12, %ymm2, %ymm2
        vpand	%ymm12, %ymm3, %ymm3
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpor	%ymm2, %ymm6, %ymm6
        vpor	%ymm3, %ymm7, %ymm7
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 13
        movq	104(%rsi), %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vmovdqu	64(%rcx), %ymm2
        vmovdqu	96(%rcx), %ymm3
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpand	%ymm12, %ymm2, %ymm2
        vpand	%ymm12, %ymm3, %ymm3
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpor	%ymm2, %ymm6, %ymm6
        vpor	%ymm3, %ymm7, %ymm7
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 14
        movq	112(%rsi), %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vmovdqu	64(%rcx), %ymm2
        vmovdqu	96(%rcx), %ymm3
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpand	%ymm12, %ymm2, %ymm2
        vpand	%ymm12, %ymm3, %ymm3
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpor	%ymm2, %ymm6, %ymm6
        vpor	%ymm3, %ymm7, %ymm7
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 15
        movq	120(%rsi), %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vmovdqu	64(%rcx), %ymm2
        vmovdqu	96(%rcx), %ymm3
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpand	%ymm12, %ymm2, %ymm2
        vpand	%ymm12, %ymm3, %ymm3
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpor	%ymm2, %ymm6, %ymm6
        vpor	%ymm3, %ymm7, %ymm7
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 16
        movq	128(%rsi), %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vmovdqu	64(%rcx), %ymm2
        vmovdqu	96(%rcx), %ymm3
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpand	%ymm12, %ymm2, %ymm2
        vpand	%ymm12, %ymm3, %ymm3
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpor	%ymm2, %ymm6, %ymm6
        vpor	%ymm3, %ymm7, %ymm7
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 17
        movq	136(%rsi), %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vmovdqu	64(%rcx), %ymm2
        vmovdqu	96(%rcx), %ymm3
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpand	%ymm12, %ymm2, %ymm2
        vpand	%ymm12, %ymm3, %ymm3
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpor	%ymm2, %ymm6, %ymm6
        vpor	%ymm3, %ymm7, %ymm7
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 18
        movq	144(%rsi), %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vmovdqu	64(%rcx), %ymm2
        vmovdqu	96(%rcx), %ymm3
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpand	%ymm12, %ymm2, %ymm2
        vpand	%ymm12, %ymm3, %ymm3
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpor	%ymm2, %ymm6, %ymm6
        vpor	%ymm3, %ymm7, %ymm7
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 19
        movq	152(%rsi), %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vmovdqu	64(%rcx), %ymm2
        vmovdqu	96(%rcx), %ymm3
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpand	%ymm12, %ymm2, %ymm2
        vpand	%ymm12, %ymm3, %ymm3
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpor	%ymm2, %ymm6, %ymm6
        vpor	%ymm3, %ymm7, %ymm7
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 20
        movq	160(%rsi), %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vmovdqu	64(%rcx), %ymm2
        vmovdqu	96(%rcx), %ymm3
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpand	%ymm12, %ymm2, %ymm2
        vpand	%ymm12, %ymm3, %ymm3
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpor	%ymm2, %ymm6, %ymm6
        vpor	%ymm3, %ymm7, %ymm7
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 21
        movq	168(%rsi), %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vmovdqu	64(%rcx), %ymm2
        vmovdqu	96(%rcx), %ymm3
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpand	%ymm12, %ymm2, %ymm2
        vpand	%ymm12, %ymm3, %ymm3
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpor	%ymm2, %ymm6, %ymm6
        vpor	%ymm3, %ymm7, %ymm7
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 22
        movq	176(%rsi), %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vmovdqu	64(%rcx), %ymm2
        vmovdqu	96(%rcx), %ymm3
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpand	%ymm12, %ymm2, %ymm2
        vpand	%ymm12, %ymm3, %ymm3
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpor	%ymm2, %ymm6, %ymm6
        vpor	%ymm3, %ymm7, %ymm7
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 23
        movq	184(%rsi), %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vmovdqu	64(%rcx), %ymm2
        vmovdqu	96(%rcx), %ymm3
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpand	%ymm12, %ymm2, %ymm2
        vpand	%ymm12, %ymm3, %ymm3
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpor	%ymm2, %ymm6, %ymm6
        vpor	%ymm3, %ymm7, %ymm7
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 24
        movq	192(%rsi), %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vmovdqu	64(%rcx), %ymm2
        vmovdqu	96(%rcx), %ymm3
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpand	%ymm12, %ymm2, %ymm2
        vpand	%ymm12, %ymm3, %ymm3
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpor	%ymm2, %ymm6, %ymm6
        vpor	%ymm3, %ymm7, %ymm7
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 25
        movq	200(%rsi), %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vmovdqu	64(%rcx), %ymm2
        vmovdqu	96(%rcx), %ymm3
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpand	%ymm12, %ymm2, %ymm2
        vpand	%ymm12, %ymm3, %ymm3
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpor	%ymm2, %ymm6, %ymm6
        vpor	%ymm3, %ymm7, %ymm7
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 26
        movq	208(%rsi), %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vmovdqu	64(%rcx), %ymm2
        vmovdqu	96(%rcx), %ymm3
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpand	%ymm12, %ymm2, %ymm2
        vpand	%ymm12, %ymm3, %ymm3
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpor	%ymm2, %ymm6, %ymm6
        vpor	%ymm3, %ymm7, %ymm7
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 27
        movq	216(%rsi), %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vmovdqu	64(%rcx), %ymm2
        vmovdqu	96(%rcx), %ymm3
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpand	%ymm12, %ymm2, %ymm2
        vpand	%ymm12, %ymm3, %ymm3
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpor	%ymm2, %ymm6, %ymm6
        vpor	%ymm3, %ymm7, %ymm7
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 28
        movq	224(%rsi), %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vmovdqu	64(%rcx), %ymm2
        vmovdqu	96(%rcx), %ymm3
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpand	%ymm12, %ymm2, %ymm2
        vpand	%ymm12, %ymm3, %ymm3
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpor	%ymm2, %ymm6, %ymm6
        vpor	%ymm3, %ymm7, %ymm7
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 29
        movq	232(%rsi), %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vmovdqu	64(%rcx), %ymm2
        vmovdqu	96(%rcx), %ymm3
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpand	%ymm12, %ymm2, %ymm2
        vpand	%ymm12, %ymm3, %ymm3
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpor	%ymm2, %ymm6, %ymm6
        vpor	%ymm3, %ymm7, %ymm7
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 30
        movq	240(%rsi), %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vmovdqu	64(%rcx), %ymm2
        vmovdqu	96(%rcx), %ymm3
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpand	%ymm12, %ymm2, %ymm2
        vpand	%ymm12, %ymm3, %ymm3
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpor	%ymm2, %ymm6, %ymm6
        vpor	%ymm3, %ymm7, %ymm7
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 31
        movq	248(%rsi), %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vmovdqu	64(%rcx), %ymm2
        vmovdqu	96(%rcx), %ymm3
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpand	%ymm12, %ymm2, %ymm2
        vpand	%ymm12, %ymm3, %ymm3
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpor	%ymm2, %ymm6, %ymm6
        vpor	%ymm3, %ymm7, %ymm7
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 32
        movq	256(%rsi), %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vmovdqu	64(%rcx), %ymm2
        vmovdqu	96(%rcx), %ymm3
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpand	%ymm12, %ymm2, %ymm2
        vpand	%ymm12, %ymm3, %ymm3
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpor	%ymm2, %ymm6, %ymm6
        vpor	%ymm3, %ymm7, %ymm7
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 33
        movq	264(%rsi), %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vmovdqu	64(%rcx), %ymm2
        vmovdqu	96(%rcx), %ymm3
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpand	%ymm12, %ymm2, %ymm2
        vpand	%ymm12, %ymm3, %ymm3
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpor	%ymm2, %ymm6, %ymm6
        vpor	%ymm3, %ymm7, %ymm7
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 34
        movq	272(%rsi), %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vmovdqu	64(%rcx), %ymm2
        vmovdqu	96(%rcx), %ymm3
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpand	%ymm12, %ymm2, %ymm2
        vpand	%ymm12, %ymm3, %ymm3
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpor	%ymm2, %ymm6, %ymm6
        vpor	%ymm3, %ymm7, %ymm7
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 35
        movq	280(%rsi), %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vmovdqu	64(%rcx), %ymm2
        vmovdqu	96(%rcx), %ymm3
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpand	%ymm12, %ymm2, %ymm2
        vpand	%ymm12, %ymm3, %ymm3
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpor	%ymm2, %ymm6, %ymm6
        vpor	%ymm3, %ymm7, %ymm7
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 36
        movq	288(%rsi), %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vmovdqu	64(%rcx), %ymm2
        vmovdqu	96(%rcx), %ymm3
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpand	%ymm12, %ymm2, %ymm2
        vpand	%ymm12, %ymm3, %ymm3
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpor	%ymm2, %ymm6, %ymm6
        vpor	%ymm3, %ymm7, %ymm7
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 37
        movq	296(%rsi), %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vmovdqu	64(%rcx), %ymm2
        vmovdqu	96(%rcx), %ymm3
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpand	%ymm12, %ymm2, %ymm2
        vpand	%ymm12, %ymm3, %ymm3
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpor	%ymm2, %ymm6, %ymm6
        vpor	%ymm3, %ymm7, %ymm7
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 38
        movq	304(%rsi), %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vmovdqu	64(%rcx), %ymm2
        vmovdqu	96(%rcx), %ymm3
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpand	%ymm12, %ymm2, %ymm2
        vpand	%ymm12, %ymm3, %ymm3
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpor	%ymm2, %ymm6, %ymm6
        vpor	%ymm3, %ymm7, %ymm7
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 39
        movq	312(%rsi), %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vmovdqu	64(%rcx), %ymm2
        vmovdqu	96(%rcx), %ymm3
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpand	%ymm12, %ymm2, %ymm2
        vpand	%ymm12, %ymm3, %ymm3
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpor	%ymm2, %ymm6, %ymm6
        vpor	%ymm3, %ymm7, %ymm7
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 40
        movq	320(%rsi), %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vmovdqu	64(%rcx), %ymm2
        vmovdqu	96(%rcx), %ymm3
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpand	%ymm12, %ymm2, %ymm2
        vpand	%ymm12, %ymm3, %ymm3
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpor	%ymm2, %ymm6, %ymm6
        vpor	%ymm3, %ymm7, %ymm7
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 41
        movq	328(%rsi), %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vmovdqu	64(%rcx), %ymm2
        vmovdqu	96(%rcx), %ymm3
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpand	%ymm12, %ymm2, %ymm2
        vpand	%ymm12, %ymm3, %ymm3
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpor	%ymm2, %ymm6, %ymm6
        vpor	%ymm3, %ymm7, %ymm7
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 42
        movq	336(%rsi), %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vmovdqu	64(%rcx), %ymm2
        vmovdqu	96(%rcx), %ymm3
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpand	%ymm12, %ymm2, %ymm2
        vpand	%ymm12, %ymm3, %ymm3
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpor	%ymm2, %ymm6, %ymm6
        vpor	%ymm3, %ymm7, %ymm7
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 43
        movq	344(%rsi), %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vmovdqu	64(%rcx), %ymm2
        vmovdqu	96(%rcx), %ymm3
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpand	%ymm12, %ymm2, %ymm2
        vpand	%ymm12, %ymm3, %ymm3
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpor	%ymm2, %ymm6, %ymm6
        vpor	%ymm3, %ymm7, %ymm7
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 44
        movq	352(%rsi), %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vmovdqu	64(%rcx), %ymm2
        vmovdqu	96(%rcx), %ymm3
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpand	%ymm12, %ymm2, %ymm2
        vpand	%ymm12, %ymm3, %ymm3
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpor	%ymm2, %ymm6, %ymm6
        vpor	%ymm3, %ymm7, %ymm7
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 45
        movq	360(%rsi), %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vmovdqu	64(%rcx), %ymm2
        vmovdqu	96(%rcx), %ymm3
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpand	%ymm12, %ymm2, %ymm2
        vpand	%ymm12, %ymm3, %ymm3
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpor	%ymm2, %ymm6, %ymm6
        vpor	%ymm3, %ymm7, %ymm7
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 46
        movq	368(%rsi), %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vmovdqu	64(%rcx), %ymm2
        vmovdqu	96(%rcx), %ymm3
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpand	%ymm12, %ymm2, %ymm2
        vpand	%ymm12, %ymm3, %ymm3
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpor	%ymm2, %ymm6, %ymm6
        vpor	%ymm3, %ymm7, %ymm7
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 47
        movq	376(%rsi), %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vmovdqu	64(%rcx), %ymm2
        vmovdqu	96(%rcx), %ymm3
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpand	%ymm12, %ymm2, %ymm2
        vpand	%ymm12, %ymm3, %ymm3
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpor	%ymm2, %ymm6, %ymm6
        vpor	%ymm3, %ymm7, %ymm7
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 48
        movq	384(%rsi), %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vmovdqu	64(%rcx), %ymm2
        vmovdqu	96(%rcx), %ymm3
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpand	%ymm12, %ymm2, %ymm2
        vpand	%ymm12, %ymm3, %ymm3
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpor	%ymm2, %ymm6, %ymm6
        vpor	%ymm3, %ymm7, %ymm7
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 49
        movq	392(%rsi), %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vmovdqu	64(%rcx), %ymm2
        vmovdqu	96(%rcx), %ymm3
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpand	%ymm12, %ymm2, %ymm2
        vpand	%ymm12, %ymm3, %ymm3
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpor	%ymm2, %ymm6, %ymm6
        vpor	%ymm3, %ymm7, %ymm7
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 50
        movq	400(%rsi), %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vmovdqu	64(%rcx), %ymm2
        vmovdqu	96(%rcx), %ymm3
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpand	%ymm12, %ymm2, %ymm2
        vpand	%ymm12, %ymm3, %ymm3
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpor	%ymm2, %ymm6, %ymm6
        vpor	%ymm3, %ymm7, %ymm7
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 51
        movq	408(%rsi), %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vmovdqu	64(%rcx), %ymm2
        vmovdqu	96(%rcx), %ymm3
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpand	%ymm12, %ymm2, %ymm2
        vpand	%ymm12, %ymm3, %ymm3
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpor	%ymm2, %ymm6, %ymm6
        vpor	%ymm3, %ymm7, %ymm7
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 52
        movq	416(%rsi), %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vmovdqu	64(%rcx), %ymm2
        vmovdqu	96(%rcx), %ymm3
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpand	%ymm12, %ymm2, %ymm2
        vpand	%ymm12, %ymm3, %ymm3
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpor	%ymm2, %ymm6, %ymm6
        vpor	%ymm3, %ymm7, %ymm7
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 53
        movq	424(%rsi), %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vmovdqu	64(%rcx), %ymm2
        vmovdqu	96(%rcx), %ymm3
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpand	%ymm12, %ymm2, %ymm2
        vpand	%ymm12, %ymm3, %ymm3
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpor	%ymm2, %ymm6, %ymm6
        vpor	%ymm3, %ymm7, %ymm7
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 54
        movq	432(%rsi), %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vmovdqu	64(%rcx), %ymm2
        vmovdqu	96(%rcx), %ymm3
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpand	%ymm12, %ymm2, %ymm2
        vpand	%ymm12, %ymm3, %ymm3
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpor	%ymm2, %ymm6, %ymm6
        vpor	%ymm3, %ymm7, %ymm7
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 55
        movq	440(%rsi), %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vmovdqu	64(%rcx), %ymm2
        vmovdqu	96(%rcx), %ymm3
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpand	%ymm12, %ymm2, %ymm2
        vpand	%ymm12, %ymm3, %ymm3
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpor	%ymm2, %ymm6, %ymm6
        vpor	%ymm3, %ymm7, %ymm7
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 56
        movq	448(%rsi), %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vmovdqu	64(%rcx), %ymm2
        vmovdqu	96(%rcx), %ymm3
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpand	%ymm12, %ymm2, %ymm2
        vpand	%ymm12, %ymm3, %ymm3
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpor	%ymm2, %ymm6, %ymm6
        vpor	%ymm3, %ymm7, %ymm7
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 57
        movq	456(%rsi), %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vmovdqu	64(%rcx), %ymm2
        vmovdqu	96(%rcx), %ymm3
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpand	%ymm12, %ymm2, %ymm2
        vpand	%ymm12, %ymm3, %ymm3
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpor	%ymm2, %ymm6, %ymm6
        vpor	%ymm3, %ymm7, %ymm7
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 58
        movq	464(%rsi), %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vmovdqu	64(%rcx), %ymm2
        vmovdqu	96(%rcx), %ymm3
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpand	%ymm12, %ymm2, %ymm2
        vpand	%ymm12, %ymm3, %ymm3
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpor	%ymm2, %ymm6, %ymm6
        vpor	%ymm3, %ymm7, %ymm7
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 59
        movq	472(%rsi), %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vmovdqu	64(%rcx), %ymm2
        vmovdqu	96(%rcx), %ymm3
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpand	%ymm12, %ymm2, %ymm2
        vpand	%ymm12, %ymm3, %ymm3
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpor	%ymm2, %ymm6, %ymm6
        vpor	%ymm3, %ymm7, %ymm7
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 60
        movq	480(%rsi), %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vmovdqu	64(%rcx), %ymm2
        vmovdqu	96(%rcx), %ymm3
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpand	%ymm12, %ymm2, %ymm2
        vpand	%ymm12, %ymm3, %ymm3
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpor	%ymm2, %ymm6, %ymm6
        vpor	%ymm3, %ymm7, %ymm7
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 61
        movq	488(%rsi), %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vmovdqu	64(%rcx), %ymm2
        vmovdqu	96(%rcx), %ymm3
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpand	%ymm12, %ymm2, %ymm2
        vpand	%ymm12, %ymm3, %ymm3
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpor	%ymm2, %ymm6, %ymm6
        vpor	%ymm3, %ymm7, %ymm7
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 62
        movq	496(%rsi), %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vmovdqu	64(%rcx), %ymm2
        vmovdqu	96(%rcx), %ymm3
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpand	%ymm12, %ymm2, %ymm2
        vpand	%ymm12, %ymm3, %ymm3
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpor	%ymm2, %ymm6, %ymm6
        vpor	%ymm3, %ymm7, %ymm7
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 63
        movq	504(%rsi), %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vmovdqu	64(%rcx), %ymm2
        vmovdqu	96(%rcx), %ymm3
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpand	%ymm12, %ymm2, %ymm2
        vpand	%ymm12, %ymm3, %ymm3
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpor	%ymm2, %ymm6, %ymm6
        vpor	%ymm3, %ymm7, %ymm7
        vpaddd	%ymm11, %ymm13, %ymm13
        vmovdqu	%ymm4, (%rdi)
        vmovdqu	%ymm5, 32(%rdi)
        vmovdqu	%ymm6, 64(%rdi)
        vmovdqu	%ymm7, 96(%rdi)
        addq	$0x80, %rdi
        # END: 0-15
        # START: 16-31
        vpxor	%ymm13, %ymm13, %ymm13
        vpxor	%ymm4, %ymm4, %ymm4
        vpxor	%ymm5, %ymm5, %ymm5
        vpxor	%ymm6, %ymm6, %ymm6
        vpxor	%ymm7, %ymm7, %ymm7
        # ENTRY: 0
        movq	(%rsi), %rcx
        addq	$0x80, %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vmovdqu	64(%rcx), %ymm2
        vmovdqu	96(%rcx), %ymm3
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpand	%ymm12, %ymm2, %ymm2
        vpand	%ymm12, %ymm3, %ymm3
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpor	%ymm2, %ymm6, %ymm6
        vpor	%ymm3, %ymm7, %ymm7
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 1
        movq	8(%rsi), %rcx
        addq	$0x80, %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vmovdqu	64(%rcx), %ymm2
        vmovdqu	96(%rcx), %ymm3
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpand	%ymm12, %ymm2, %ymm2
        vpand	%ymm12, %ymm3, %ymm3
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpor	%ymm2, %ymm6, %ymm6
        vpor	%ymm3, %ymm7, %ymm7
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 2
        movq	16(%rsi), %rcx
        addq	$0x80, %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vmovdqu	64(%rcx), %ymm2
        vmovdqu	96(%rcx), %ymm3
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpand	%ymm12, %ymm2, %ymm2
        vpand	%ymm12, %ymm3, %ymm3
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpor	%ymm2, %ymm6, %ymm6
        vpor	%ymm3, %ymm7, %ymm7
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 3
        movq	24(%rsi), %rcx
        addq	$0x80, %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vmovdqu	64(%rcx), %ymm2
        vmovdqu	96(%rcx), %ymm3
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpand	%ymm12, %ymm2, %ymm2
        vpand	%ymm12, %ymm3, %ymm3
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpor	%ymm2, %ymm6, %ymm6
        vpor	%ymm3, %ymm7, %ymm7
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 4
        movq	32(%rsi), %rcx
        addq	$0x80, %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vmovdqu	64(%rcx), %ymm2
        vmovdqu	96(%rcx), %ymm3
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpand	%ymm12, %ymm2, %ymm2
        vpand	%ymm12, %ymm3, %ymm3
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpor	%ymm2, %ymm6, %ymm6
        vpor	%ymm3, %ymm7, %ymm7
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 5
        movq	40(%rsi), %rcx
        addq	$0x80, %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vmovdqu	64(%rcx), %ymm2
        vmovdqu	96(%rcx), %ymm3
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpand	%ymm12, %ymm2, %ymm2
        vpand	%ymm12, %ymm3, %ymm3
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpor	%ymm2, %ymm6, %ymm6
        vpor	%ymm3, %ymm7, %ymm7
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 6
        movq	48(%rsi), %rcx
        addq	$0x80, %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vmovdqu	64(%rcx), %ymm2
        vmovdqu	96(%rcx), %ymm3
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpand	%ymm12, %ymm2, %ymm2
        vpand	%ymm12, %ymm3, %ymm3
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpor	%ymm2, %ymm6, %ymm6
        vpor	%ymm3, %ymm7, %ymm7
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 7
        movq	56(%rsi), %rcx
        addq	$0x80, %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vmovdqu	64(%rcx), %ymm2
        vmovdqu	96(%rcx), %ymm3
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpand	%ymm12, %ymm2, %ymm2
        vpand	%ymm12, %ymm3, %ymm3
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpor	%ymm2, %ymm6, %ymm6
        vpor	%ymm3, %ymm7, %ymm7
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 8
        movq	64(%rsi), %rcx
        addq	$0x80, %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vmovdqu	64(%rcx), %ymm2
        vmovdqu	96(%rcx), %ymm3
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpand	%ymm12, %ymm2, %ymm2
        vpand	%ymm12, %ymm3, %ymm3
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpor	%ymm2, %ymm6, %ymm6
        vpor	%ymm3, %ymm7, %ymm7
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 9
        movq	72(%rsi), %rcx
        addq	$0x80, %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vmovdqu	64(%rcx), %ymm2
        vmovdqu	96(%rcx), %ymm3
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpand	%ymm12, %ymm2, %ymm2
        vpand	%ymm12, %ymm3, %ymm3
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpor	%ymm2, %ymm6, %ymm6
        vpor	%ymm3, %ymm7, %ymm7
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 10
        movq	80(%rsi), %rcx
        addq	$0x80, %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vmovdqu	64(%rcx), %ymm2
        vmovdqu	96(%rcx), %ymm3
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpand	%ymm12, %ymm2, %ymm2
        vpand	%ymm12, %ymm3, %ymm3
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpor	%ymm2, %ymm6, %ymm6
        vpor	%ymm3, %ymm7, %ymm7
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 11
        movq	88(%rsi), %rcx
        addq	$0x80, %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vmovdqu	64(%rcx), %ymm2
        vmovdqu	96(%rcx), %ymm3
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpand	%ymm12, %ymm2, %ymm2
        vpand	%ymm12, %ymm3, %ymm3
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpor	%ymm2, %ymm6, %ymm6
        vpor	%ymm3, %ymm7, %ymm7
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 12
        movq	96(%rsi), %rcx
        addq	$0x80, %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vmovdqu	64(%rcx), %ymm2
        vmovdqu	96(%rcx), %ymm3
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpand	%ymm12, %ymm2, %ymm2
        vpand	%ymm12, %ymm3, %ymm3
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpor	%ymm2, %ymm6, %ymm6
        vpor	%ymm3, %ymm7, %ymm7
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 13
        movq	104(%rsi), %rcx
        addq	$0x80, %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vmovdqu	64(%rcx), %ymm2
        vmovdqu	96(%rcx), %ymm3
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpand	%ymm12, %ymm2, %ymm2
        vpand	%ymm12, %ymm3, %ymm3
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpor	%ymm2, %ymm6, %ymm6
        vpor	%ymm3, %ymm7, %ymm7
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 14
        movq	112(%rsi), %rcx
        addq	$0x80, %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vmovdqu	64(%rcx), %ymm2
        vmovdqu	96(%rcx), %ymm3
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpand	%ymm12, %ymm2, %ymm2
        vpand	%ymm12, %ymm3, %ymm3
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpor	%ymm2, %ymm6, %ymm6
        vpor	%ymm3, %ymm7, %ymm7
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 15
        movq	120(%rsi), %rcx
        addq	$0x80, %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vmovdqu	64(%rcx), %ymm2
        vmovdqu	96(%rcx), %ymm3
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpand	%ymm12, %ymm2, %ymm2
        vpand	%ymm12, %ymm3, %ymm3
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpor	%ymm2, %ymm6, %ymm6
        vpor	%ymm3, %ymm7, %ymm7
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 16
        movq	128(%rsi), %rcx
        addq	$0x80, %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vmovdqu	64(%rcx), %ymm2
        vmovdqu	96(%rcx), %ymm3
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpand	%ymm12, %ymm2, %ymm2
        vpand	%ymm12, %ymm3, %ymm3
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpor	%ymm2, %ymm6, %ymm6
        vpor	%ymm3, %ymm7, %ymm7
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 17
        movq	136(%rsi), %rcx
        addq	$0x80, %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vmovdqu	64(%rcx), %ymm2
        vmovdqu	96(%rcx), %ymm3
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpand	%ymm12, %ymm2, %ymm2
        vpand	%ymm12, %ymm3, %ymm3
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpor	%ymm2, %ymm6, %ymm6
        vpor	%ymm3, %ymm7, %ymm7
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 18
        movq	144(%rsi), %rcx
        addq	$0x80, %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vmovdqu	64(%rcx), %ymm2
        vmovdqu	96(%rcx), %ymm3
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpand	%ymm12, %ymm2, %ymm2
        vpand	%ymm12, %ymm3, %ymm3
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpor	%ymm2, %ymm6, %ymm6
        vpor	%ymm3, %ymm7, %ymm7
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 19
        movq	152(%rsi), %rcx
        addq	$0x80, %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vmovdqu	64(%rcx), %ymm2
        vmovdqu	96(%rcx), %ymm3
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpand	%ymm12, %ymm2, %ymm2
        vpand	%ymm12, %ymm3, %ymm3
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpor	%ymm2, %ymm6, %ymm6
        vpor	%ymm3, %ymm7, %ymm7
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 20
        movq	160(%rsi), %rcx
        addq	$0x80, %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vmovdqu	64(%rcx), %ymm2
        vmovdqu	96(%rcx), %ymm3
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpand	%ymm12, %ymm2, %ymm2
        vpand	%ymm12, %ymm3, %ymm3
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpor	%ymm2, %ymm6, %ymm6
        vpor	%ymm3, %ymm7, %ymm7
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 21
        movq	168(%rsi), %rcx
        addq	$0x80, %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vmovdqu	64(%rcx), %ymm2
        vmovdqu	96(%rcx), %ymm3
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpand	%ymm12, %ymm2, %ymm2
        vpand	%ymm12, %ymm3, %ymm3
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpor	%ymm2, %ymm6, %ymm6
        vpor	%ymm3, %ymm7, %ymm7
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 22
        movq	176(%rsi), %rcx
        addq	$0x80, %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vmovdqu	64(%rcx), %ymm2
        vmovdqu	96(%rcx), %ymm3
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpand	%ymm12, %ymm2, %ymm2
        vpand	%ymm12, %ymm3, %ymm3
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpor	%ymm2, %ymm6, %ymm6
        vpor	%ymm3, %ymm7, %ymm7
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 23
        movq	184(%rsi), %rcx
        addq	$0x80, %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vmovdqu	64(%rcx), %ymm2
        vmovdqu	96(%rcx), %ymm3
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpand	%ymm12, %ymm2, %ymm2
        vpand	%ymm12, %ymm3, %ymm3
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpor	%ymm2, %ymm6, %ymm6
        vpor	%ymm3, %ymm7, %ymm7
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 24
        movq	192(%rsi), %rcx
        addq	$0x80, %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vmovdqu	64(%rcx), %ymm2
        vmovdqu	96(%rcx), %ymm3
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpand	%ymm12, %ymm2, %ymm2
        vpand	%ymm12, %ymm3, %ymm3
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpor	%ymm2, %ymm6, %ymm6
        vpor	%ymm3, %ymm7, %ymm7
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 25
        movq	200(%rsi), %rcx
        addq	$0x80, %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vmovdqu	64(%rcx), %ymm2
        vmovdqu	96(%rcx), %ymm3
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpand	%ymm12, %ymm2, %ymm2
        vpand	%ymm12, %ymm3, %ymm3
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpor	%ymm2, %ymm6, %ymm6
        vpor	%ymm3, %ymm7, %ymm7
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 26
        movq	208(%rsi), %rcx
        addq	$0x80, %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vmovdqu	64(%rcx), %ymm2
        vmovdqu	96(%rcx), %ymm3
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpand	%ymm12, %ymm2, %ymm2
        vpand	%ymm12, %ymm3, %ymm3
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpor	%ymm2, %ymm6, %ymm6
        vpor	%ymm3, %ymm7, %ymm7
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 27
        movq	216(%rsi), %rcx
        addq	$0x80, %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vmovdqu	64(%rcx), %ymm2
        vmovdqu	96(%rcx), %ymm3
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpand	%ymm12, %ymm2, %ymm2
        vpand	%ymm12, %ymm3, %ymm3
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpor	%ymm2, %ymm6, %ymm6
        vpor	%ymm3, %ymm7, %ymm7
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 28
        movq	224(%rsi), %rcx
        addq	$0x80, %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vmovdqu	64(%rcx), %ymm2
        vmovdqu	96(%rcx), %ymm3
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpand	%ymm12, %ymm2, %ymm2
        vpand	%ymm12, %ymm3, %ymm3
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpor	%ymm2, %ymm6, %ymm6
        vpor	%ymm3, %ymm7, %ymm7
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 29
        movq	232(%rsi), %rcx
        addq	$0x80, %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vmovdqu	64(%rcx), %ymm2
        vmovdqu	96(%rcx), %ymm3
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpand	%ymm12, %ymm2, %ymm2
        vpand	%ymm12, %ymm3, %ymm3
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpor	%ymm2, %ymm6, %ymm6
        vpor	%ymm3, %ymm7, %ymm7
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 30
        movq	240(%rsi), %rcx
        addq	$0x80, %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vmovdqu	64(%rcx), %ymm2
        vmovdqu	96(%rcx), %ymm3
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpand	%ymm12, %ymm2, %ymm2
        vpand	%ymm12, %ymm3, %ymm3
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpor	%ymm2, %ymm6, %ymm6
        vpor	%ymm3, %ymm7, %ymm7
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 31
        movq	248(%rsi), %rcx
        addq	$0x80, %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vmovdqu	64(%rcx), %ymm2
        vmovdqu	96(%rcx), %ymm3
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpand	%ymm12, %ymm2, %ymm2
        vpand	%ymm12, %ymm3, %ymm3
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpor	%ymm2, %ymm6, %ymm6
        vpor	%ymm3, %ymm7, %ymm7
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 32
        movq	256(%rsi), %rcx
        addq	$0x80, %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vmovdqu	64(%rcx), %ymm2
        vmovdqu	96(%rcx), %ymm3
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpand	%ymm12, %ymm2, %ymm2
        vpand	%ymm12, %ymm3, %ymm3
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpor	%ymm2, %ymm6, %ymm6
        vpor	%ymm3, %ymm7, %ymm7
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 33
        movq	264(%rsi), %rcx
        addq	$0x80, %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vmovdqu	64(%rcx), %ymm2
        vmovdqu	96(%rcx), %ymm3
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpand	%ymm12, %ymm2, %ymm2
        vpand	%ymm12, %ymm3, %ymm3
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpor	%ymm2, %ymm6, %ymm6
        vpor	%ymm3, %ymm7, %ymm7
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 34
        movq	272(%rsi), %rcx
        addq	$0x80, %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vmovdqu	64(%rcx), %ymm2
        vmovdqu	96(%rcx), %ymm3
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpand	%ymm12, %ymm2, %ymm2
        vpand	%ymm12, %ymm3, %ymm3
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpor	%ymm2, %ymm6, %ymm6
        vpor	%ymm3, %ymm7, %ymm7
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 35
        movq	280(%rsi), %rcx
        addq	$0x80, %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vmovdqu	64(%rcx), %ymm2
        vmovdqu	96(%rcx), %ymm3
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpand	%ymm12, %ymm2, %ymm2
        vpand	%ymm12, %ymm3, %ymm3
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpor	%ymm2, %ymm6, %ymm6
        vpor	%ymm3, %ymm7, %ymm7
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 36
        movq	288(%rsi), %rcx
        addq	$0x80, %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vmovdqu	64(%rcx), %ymm2
        vmovdqu	96(%rcx), %ymm3
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpand	%ymm12, %ymm2, %ymm2
        vpand	%ymm12, %ymm3, %ymm3
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpor	%ymm2, %ymm6, %ymm6
        vpor	%ymm3, %ymm7, %ymm7
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 37
        movq	296(%rsi), %rcx
        addq	$0x80, %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vmovdqu	64(%rcx), %ymm2
        vmovdqu	96(%rcx), %ymm3
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpand	%ymm12, %ymm2, %ymm2
        vpand	%ymm12, %ymm3, %ymm3
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpor	%ymm2, %ymm6, %ymm6
        vpor	%ymm3, %ymm7, %ymm7
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 38
        movq	304(%rsi), %rcx
        addq	$0x80, %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vmovdqu	64(%rcx), %ymm2
        vmovdqu	96(%rcx), %ymm3
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpand	%ymm12, %ymm2, %ymm2
        vpand	%ymm12, %ymm3, %ymm3
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpor	%ymm2, %ymm6, %ymm6
        vpor	%ymm3, %ymm7, %ymm7
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 39
        movq	312(%rsi), %rcx
        addq	$0x80, %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vmovdqu	64(%rcx), %ymm2
        vmovdqu	96(%rcx), %ymm3
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpand	%ymm12, %ymm2, %ymm2
        vpand	%ymm12, %ymm3, %ymm3
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpor	%ymm2, %ymm6, %ymm6
        vpor	%ymm3, %ymm7, %ymm7
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 40
        movq	320(%rsi), %rcx
        addq	$0x80, %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vmovdqu	64(%rcx), %ymm2
        vmovdqu	96(%rcx), %ymm3
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpand	%ymm12, %ymm2, %ymm2
        vpand	%ymm12, %ymm3, %ymm3
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpor	%ymm2, %ymm6, %ymm6
        vpor	%ymm3, %ymm7, %ymm7
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 41
        movq	328(%rsi), %rcx
        addq	$0x80, %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vmovdqu	64(%rcx), %ymm2
        vmovdqu	96(%rcx), %ymm3
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpand	%ymm12, %ymm2, %ymm2
        vpand	%ymm12, %ymm3, %ymm3
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpor	%ymm2, %ymm6, %ymm6
        vpor	%ymm3, %ymm7, %ymm7
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 42
        movq	336(%rsi), %rcx
        addq	$0x80, %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vmovdqu	64(%rcx), %ymm2
        vmovdqu	96(%rcx), %ymm3
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpand	%ymm12, %ymm2, %ymm2
        vpand	%ymm12, %ymm3, %ymm3
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpor	%ymm2, %ymm6, %ymm6
        vpor	%ymm3, %ymm7, %ymm7
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 43
        movq	344(%rsi), %rcx
        addq	$0x80, %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vmovdqu	64(%rcx), %ymm2
        vmovdqu	96(%rcx), %ymm3
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpand	%ymm12, %ymm2, %ymm2
        vpand	%ymm12, %ymm3, %ymm3
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpor	%ymm2, %ymm6, %ymm6
        vpor	%ymm3, %ymm7, %ymm7
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 44
        movq	352(%rsi), %rcx
        addq	$0x80, %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vmovdqu	64(%rcx), %ymm2
        vmovdqu	96(%rcx), %ymm3
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpand	%ymm12, %ymm2, %ymm2
        vpand	%ymm12, %ymm3, %ymm3
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpor	%ymm2, %ymm6, %ymm6
        vpor	%ymm3, %ymm7, %ymm7
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 45
        movq	360(%rsi), %rcx
        addq	$0x80, %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vmovdqu	64(%rcx), %ymm2
        vmovdqu	96(%rcx), %ymm3
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpand	%ymm12, %ymm2, %ymm2
        vpand	%ymm12, %ymm3, %ymm3
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpor	%ymm2, %ymm6, %ymm6
        vpor	%ymm3, %ymm7, %ymm7
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 46
        movq	368(%rsi), %rcx
        addq	$0x80, %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vmovdqu	64(%rcx), %ymm2
        vmovdqu	96(%rcx), %ymm3
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpand	%ymm12, %ymm2, %ymm2
        vpand	%ymm12, %ymm3, %ymm3
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpor	%ymm2, %ymm6, %ymm6
        vpor	%ymm3, %ymm7, %ymm7
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 47
        movq	376(%rsi), %rcx
        addq	$0x80, %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vmovdqu	64(%rcx), %ymm2
        vmovdqu	96(%rcx), %ymm3
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpand	%ymm12, %ymm2, %ymm2
        vpand	%ymm12, %ymm3, %ymm3
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpor	%ymm2, %ymm6, %ymm6
        vpor	%ymm3, %ymm7, %ymm7
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 48
        movq	384(%rsi), %rcx
        addq	$0x80, %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vmovdqu	64(%rcx), %ymm2
        vmovdqu	96(%rcx), %ymm3
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpand	%ymm12, %ymm2, %ymm2
        vpand	%ymm12, %ymm3, %ymm3
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpor	%ymm2, %ymm6, %ymm6
        vpor	%ymm3, %ymm7, %ymm7
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 49
        movq	392(%rsi), %rcx
        addq	$0x80, %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vmovdqu	64(%rcx), %ymm2
        vmovdqu	96(%rcx), %ymm3
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpand	%ymm12, %ymm2, %ymm2
        vpand	%ymm12, %ymm3, %ymm3
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpor	%ymm2, %ymm6, %ymm6
        vpor	%ymm3, %ymm7, %ymm7
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 50
        movq	400(%rsi), %rcx
        addq	$0x80, %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vmovdqu	64(%rcx), %ymm2
        vmovdqu	96(%rcx), %ymm3
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpand	%ymm12, %ymm2, %ymm2
        vpand	%ymm12, %ymm3, %ymm3
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpor	%ymm2, %ymm6, %ymm6
        vpor	%ymm3, %ymm7, %ymm7
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 51
        movq	408(%rsi), %rcx
        addq	$0x80, %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vmovdqu	64(%rcx), %ymm2
        vmovdqu	96(%rcx), %ymm3
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpand	%ymm12, %ymm2, %ymm2
        vpand	%ymm12, %ymm3, %ymm3
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpor	%ymm2, %ymm6, %ymm6
        vpor	%ymm3, %ymm7, %ymm7
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 52
        movq	416(%rsi), %rcx
        addq	$0x80, %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vmovdqu	64(%rcx), %ymm2
        vmovdqu	96(%rcx), %ymm3
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpand	%ymm12, %ymm2, %ymm2
        vpand	%ymm12, %ymm3, %ymm3
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpor	%ymm2, %ymm6, %ymm6
        vpor	%ymm3, %ymm7, %ymm7
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 53
        movq	424(%rsi), %rcx
        addq	$0x80, %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vmovdqu	64(%rcx), %ymm2
        vmovdqu	96(%rcx), %ymm3
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpand	%ymm12, %ymm2, %ymm2
        vpand	%ymm12, %ymm3, %ymm3
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpor	%ymm2, %ymm6, %ymm6
        vpor	%ymm3, %ymm7, %ymm7
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 54
        movq	432(%rsi), %rcx
        addq	$0x80, %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vmovdqu	64(%rcx), %ymm2
        vmovdqu	96(%rcx), %ymm3
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpand	%ymm12, %ymm2, %ymm2
        vpand	%ymm12, %ymm3, %ymm3
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpor	%ymm2, %ymm6, %ymm6
        vpor	%ymm3, %ymm7, %ymm7
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 55
        movq	440(%rsi), %rcx
        addq	$0x80, %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vmovdqu	64(%rcx), %ymm2
        vmovdqu	96(%rcx), %ymm3
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpand	%ymm12, %ymm2, %ymm2
        vpand	%ymm12, %ymm3, %ymm3
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpor	%ymm2, %ymm6, %ymm6
        vpor	%ymm3, %ymm7, %ymm7
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 56
        movq	448(%rsi), %rcx
        addq	$0x80, %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vmovdqu	64(%rcx), %ymm2
        vmovdqu	96(%rcx), %ymm3
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpand	%ymm12, %ymm2, %ymm2
        vpand	%ymm12, %ymm3, %ymm3
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpor	%ymm2, %ymm6, %ymm6
        vpor	%ymm3, %ymm7, %ymm7
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 57
        movq	456(%rsi), %rcx
        addq	$0x80, %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vmovdqu	64(%rcx), %ymm2
        vmovdqu	96(%rcx), %ymm3
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpand	%ymm12, %ymm2, %ymm2
        vpand	%ymm12, %ymm3, %ymm3
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpor	%ymm2, %ymm6, %ymm6
        vpor	%ymm3, %ymm7, %ymm7
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 58
        movq	464(%rsi), %rcx
        addq	$0x80, %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vmovdqu	64(%rcx), %ymm2
        vmovdqu	96(%rcx), %ymm3
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpand	%ymm12, %ymm2, %ymm2
        vpand	%ymm12, %ymm3, %ymm3
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpor	%ymm2, %ymm6, %ymm6
        vpor	%ymm3, %ymm7, %ymm7
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 59
        movq	472(%rsi), %rcx
        addq	$0x80, %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vmovdqu	64(%rcx), %ymm2
        vmovdqu	96(%rcx), %ymm3
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpand	%ymm12, %ymm2, %ymm2
        vpand	%ymm12, %ymm3, %ymm3
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpor	%ymm2, %ymm6, %ymm6
        vpor	%ymm3, %ymm7, %ymm7
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 60
        movq	480(%rsi), %rcx
        addq	$0x80, %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vmovdqu	64(%rcx), %ymm2
        vmovdqu	96(%rcx), %ymm3
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpand	%ymm12, %ymm2, %ymm2
        vpand	%ymm12, %ymm3, %ymm3
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpor	%ymm2, %ymm6, %ymm6
        vpor	%ymm3, %ymm7, %ymm7
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 61
        movq	488(%rsi), %rcx
        addq	$0x80, %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vmovdqu	64(%rcx), %ymm2
        vmovdqu	96(%rcx), %ymm3
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpand	%ymm12, %ymm2, %ymm2
        vpand	%ymm12, %ymm3, %ymm3
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpor	%ymm2, %ymm6, %ymm6
        vpor	%ymm3, %ymm7, %ymm7
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 62
        movq	496(%rsi), %rcx
        addq	$0x80, %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vmovdqu	64(%rcx), %ymm2
        vmovdqu	96(%rcx), %ymm3
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpand	%ymm12, %ymm2, %ymm2
        vpand	%ymm12, %ymm3, %ymm3
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpor	%ymm2, %ymm6, %ymm6
        vpor	%ymm3, %ymm7, %ymm7
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 63
        movq	504(%rsi), %rcx
        addq	$0x80, %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vmovdqu	64(%rcx), %ymm2
        vmovdqu	96(%rcx), %ymm3
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpand	%ymm12, %ymm2, %ymm2
        vpand	%ymm12, %ymm3, %ymm3
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpor	%ymm2, %ymm6, %ymm6
        vpor	%ymm3, %ymm7, %ymm7
        vpaddd	%ymm11, %ymm13, %ymm13
        vmovdqu	%ymm4, (%rdi)
        vmovdqu	%ymm5, 32(%rdi)
        vmovdqu	%ymm6, 64(%rdi)
        vmovdqu	%ymm7, 96(%rdi)
        # END: 16-31
        repz retq
#ifndef __APPLE__
.size	sp_2048_get_from_table_avx2_32,.-sp_2048_get_from_table_avx2_32
#endif /* __APPLE__ */
#endif /* !WC_NO_CACHE_RESISTANT */
/* Conditionally add a and b using the mask m.
 * m is -1 to add and 0 when not.
 *
 * r  A single precision number representing conditional add result.
 * a  A single precision number to add with.
 * b  A single precision number to add.
 * m  Mask value to apply.
 */
#ifndef __APPLE__
.text
.globl	sp_2048_cond_add_16
.type	sp_2048_cond_add_16,@function
.align	16
sp_2048_cond_add_16:
#else
.section	__TEXT,__text
.globl	_sp_2048_cond_add_16
.p2align	4
_sp_2048_cond_add_16:
#endif /* __APPLE__ */
        subq	$0x80, %rsp
        movq	$0x00, %rax
        movq	(%rdx), %r8
        movq	8(%rdx), %r9
        andq	%rcx, %r8
        andq	%rcx, %r9
        movq	%r8, (%rsp)
        movq	%r9, 8(%rsp)
        movq	16(%rdx), %r8
        movq	24(%rdx), %r9
        andq	%rcx, %r8
        andq	%rcx, %r9
        movq	%r8, 16(%rsp)
        movq	%r9, 24(%rsp)
        movq	32(%rdx), %r8
        movq	40(%rdx), %r9
        andq	%rcx, %r8
        andq	%rcx, %r9
        movq	%r8, 32(%rsp)
        movq	%r9, 40(%rsp)
        movq	48(%rdx), %r8
        movq	56(%rdx), %r9
        andq	%rcx, %r8
        andq	%rcx, %r9
        movq	%r8, 48(%rsp)
        movq	%r9, 56(%rsp)
        movq	64(%rdx), %r8
        movq	72(%rdx), %r9
        andq	%rcx, %r8
        andq	%rcx, %r9
        movq	%r8, 64(%rsp)
        movq	%r9, 72(%rsp)
        movq	80(%rdx), %r8
        movq	88(%rdx), %r9
        andq	%rcx, %r8
        andq	%rcx, %r9
        movq	%r8, 80(%rsp)
        movq	%r9, 88(%rsp)
        movq	96(%rdx), %r8
        movq	104(%rdx), %r9
        andq	%rcx, %r8
        andq	%rcx, %r9
        movq	%r8, 96(%rsp)
        movq	%r9, 104(%rsp)
        movq	112(%rdx), %r8
        movq	120(%rdx), %r9
        andq	%rcx, %r8
        andq	%rcx, %r9
        movq	%r8, 112(%rsp)
        movq	%r9, 120(%rsp)
        movq	(%rsi), %r8
        movq	(%rsp), %rdx
        addq	%rdx, %r8
        movq	8(%rsi), %r9
        movq	8(%rsp), %rdx
        adcq	%rdx, %r9
        movq	%r8, (%rdi)
        movq	16(%rsi), %r8
        movq	16(%rsp), %rdx
        adcq	%rdx, %r8
        movq	%r9, 8(%rdi)
        movq	24(%rsi), %r9
        movq	24(%rsp), %rdx
        adcq	%rdx, %r9
        movq	%r8, 16(%rdi)
        movq	32(%rsi), %r8
        movq	32(%rsp), %rdx
        adcq	%rdx, %r8
        movq	%r9, 24(%rdi)
        movq	40(%rsi), %r9
        movq	40(%rsp), %rdx
        adcq	%rdx, %r9
        movq	%r8, 32(%rdi)
        movq	48(%rsi), %r8
        movq	48(%rsp), %rdx
        adcq	%rdx, %r8
        movq	%r9, 40(%rdi)
        movq	56(%rsi), %r9
        movq	56(%rsp), %rdx
        adcq	%rdx, %r9
        movq	%r8, 48(%rdi)
        movq	64(%rsi), %r8
        movq	64(%rsp), %rdx
        adcq	%rdx, %r8
        movq	%r9, 56(%rdi)
        movq	72(%rsi), %r9
        movq	72(%rsp), %rdx
        adcq	%rdx, %r9
        movq	%r8, 64(%rdi)
        movq	80(%rsi), %r8
        movq	80(%rsp), %rdx
        adcq	%rdx, %r8
        movq	%r9, 72(%rdi)
        movq	88(%rsi), %r9
        movq	88(%rsp), %rdx
        adcq	%rdx, %r9
        movq	%r8, 80(%rdi)
        movq	96(%rsi), %r8
        movq	96(%rsp), %rdx
        adcq	%rdx, %r8
        movq	%r9, 88(%rdi)
        movq	104(%rsi), %r9
        movq	104(%rsp), %rdx
        adcq	%rdx, %r9
        movq	%r8, 96(%rdi)
        movq	112(%rsi), %r8
        movq	112(%rsp), %rdx
        adcq	%rdx, %r8
        movq	%r9, 104(%rdi)
        movq	120(%rsi), %r9
        movq	120(%rsp), %rdx
        adcq	%rdx, %r9
        movq	%r8, 112(%rdi)
        movq	%r9, 120(%rdi)
        adcq	$0x00, %rax
        addq	$0x80, %rsp
        repz retq
#ifndef __APPLE__
.size	sp_2048_cond_add_16,.-sp_2048_cond_add_16
#endif /* __APPLE__ */
#ifdef HAVE_INTEL_AVX2
/* Conditionally add a and b using the mask m.
 * m is -1 to add and 0 when not.
 *
 * r  A single precision number representing conditional add result.
 * a  A single precision number to add with.
 * b  A single precision number to add.
 * m  Mask value to apply.
 */
#ifndef __APPLE__
.text
.globl	sp_2048_cond_add_avx2_16
.type	sp_2048_cond_add_avx2_16,@function
.align	16
sp_2048_cond_add_avx2_16:
#else
.section	__TEXT,__text
.globl	_sp_2048_cond_add_avx2_16
.p2align	4
_sp_2048_cond_add_avx2_16:
#endif /* __APPLE__ */
        movq	$0x00, %rax
        movq	(%rdx), %r10
        movq	(%rsi), %r8
        pextq	%rcx, %r10, %r10
        addq	%r10, %r8
        movq	8(%rdx), %r10
        movq	8(%rsi), %r9
        pextq	%rcx, %r10, %r10
        movq	%r8, (%rdi)
        adcq	%r10, %r9
        movq	16(%rdx), %r8
        movq	16(%rsi), %r10
        pextq	%rcx, %r8, %r8
        movq	%r9, 8(%rdi)
        adcq	%r8, %r10
        movq	24(%rdx), %r9
        movq	24(%rsi), %r8
        pextq	%rcx, %r9, %r9
        movq	%r10, 16(%rdi)
        adcq	%r9, %r8
        movq	32(%rdx), %r10
        movq	32(%rsi), %r9
        pextq	%rcx, %r10, %r10
        movq	%r8, 24(%rdi)
        adcq	%r10, %r9
        movq	40(%rdx), %r8
        movq	40(%rsi), %r10
        pextq	%rcx, %r8, %r8
        movq	%r9, 32(%rdi)
        adcq	%r8, %r10
        movq	48(%rdx), %r9
        movq	48(%rsi), %r8
        pextq	%rcx, %r9, %r9
        movq	%r10, 40(%rdi)
        adcq	%r9, %r8
        movq	56(%rdx), %r10
        movq	56(%rsi), %r9
        pextq	%rcx, %r10, %r10
        movq	%r8, 48(%rdi)
        adcq	%r10, %r9
        movq	64(%rdx), %r8
        movq	64(%rsi), %r10
        pextq	%rcx, %r8, %r8
        movq	%r9, 56(%rdi)
        adcq	%r8, %r10
        movq	72(%rdx), %r9
        movq	72(%rsi), %r8
        pextq	%rcx, %r9, %r9
        movq	%r10, 64(%rdi)
        adcq	%r9, %r8
        movq	80(%rdx), %r10
        movq	80(%rsi), %r9
        pextq	%rcx, %r10, %r10
        movq	%r8, 72(%rdi)
        adcq	%r10, %r9
        movq	88(%rdx), %r8
        movq	88(%rsi), %r10
        pextq	%rcx, %r8, %r8
        movq	%r9, 80(%rdi)
        adcq	%r8, %r10
        movq	96(%rdx), %r9
        movq	96(%rsi), %r8
        pextq	%rcx, %r9, %r9
        movq	%r10, 88(%rdi)
        adcq	%r9, %r8
        movq	104(%rdx), %r10
        movq	104(%rsi), %r9
        pextq	%rcx, %r10, %r10
        movq	%r8, 96(%rdi)
        adcq	%r10, %r9
        movq	112(%rdx), %r8
        movq	112(%rsi), %r10
        pextq	%rcx, %r8, %r8
        movq	%r9, 104(%rdi)
        adcq	%r8, %r10
        movq	120(%rdx), %r9
        movq	120(%rsi), %r8
        pextq	%rcx, %r9, %r9
        movq	%r10, 112(%rdi)
        adcq	%r9, %r8
        movq	%r8, 120(%rdi)
        adcq	$0x00, %rax
        repz retq
#ifndef __APPLE__
.size	sp_2048_cond_add_avx2_16,.-sp_2048_cond_add_avx2_16
#endif /* __APPLE__ */
#endif /* HAVE_INTEL_AVX2 */
/* Shift number left by n bit. (r = a << n)
 *
 * r  Result of left shift by n.
 * a  Number to shift.
 * n  Amoutnt o shift.
 */
#ifndef __APPLE__
.text
.globl	sp_2048_lshift_32
.type	sp_2048_lshift_32,@function
.align	16
sp_2048_lshift_32:
#else
.section	__TEXT,__text
.globl	_sp_2048_lshift_32
.p2align	4
_sp_2048_lshift_32:
#endif /* __APPLE__ */
        movb	%dl, %cl
        movq	$0x00, %r10
        movq	216(%rsi), %r11
        movq	224(%rsi), %rdx
        movq	232(%rsi), %rax
        movq	240(%rsi), %r8
        movq	248(%rsi), %r9
        shldq	%cl, %r9, %r10
        shldq	%cl, %r8, %r9
        shldq	%cl, %rax, %r8
        shldq	%cl, %rdx, %rax
        shldq	%cl, %r11, %rdx
        movq	%rdx, 224(%rdi)
        movq	%rax, 232(%rdi)
        movq	%r8, 240(%rdi)
        movq	%r9, 248(%rdi)
        movq	%r10, 256(%rdi)
        movq	184(%rsi), %r9
        movq	192(%rsi), %rdx
        movq	200(%rsi), %rax
        movq	208(%rsi), %r8
        shldq	%cl, %r8, %r11
        shldq	%cl, %rax, %r8
        shldq	%cl, %rdx, %rax
        shldq	%cl, %r9, %rdx
        movq	%rdx, 192(%rdi)
        movq	%rax, 200(%rdi)
        movq	%r8, 208(%rdi)
        movq	%r11, 216(%rdi)
        movq	152(%rsi), %r11
        movq	160(%rsi), %rdx
        movq	168(%rsi), %rax
        movq	176(%rsi), %r8
        shldq	%cl, %r8, %r9
        shldq	%cl, %rax, %r8
        shldq	%cl, %rdx, %rax
        shldq	%cl, %r11, %rdx
        movq	%rdx, 160(%rdi)
        movq	%rax, 168(%rdi)
        movq	%r8, 176(%rdi)
        movq	%r9, 184(%rdi)
        movq	120(%rsi), %r9
        movq	128(%rsi), %rdx
        movq	136(%rsi), %rax
        movq	144(%rsi), %r8
        shldq	%cl, %r8, %r11
        shldq	%cl, %rax, %r8
        shldq	%cl, %rdx, %rax
        shldq	%cl, %r9, %rdx
        movq	%rdx, 128(%rdi)
        movq	%rax, 136(%rdi)
        movq	%r8, 144(%rdi)
        movq	%r11, 152(%rdi)
        movq	88(%rsi), %r11
        movq	96(%rsi), %rdx
        movq	104(%rsi), %rax
        movq	112(%rsi), %r8
        shldq	%cl, %r8, %r9
        shldq	%cl, %rax, %r8
        shldq	%cl, %rdx, %rax
        shldq	%cl, %r11, %rdx
        movq	%rdx, 96(%rdi)
        movq	%rax, 104(%rdi)
        movq	%r8, 112(%rdi)
        movq	%r9, 120(%rdi)
        movq	56(%rsi), %r9
        movq	64(%rsi), %rdx
        movq	72(%rsi), %rax
        movq	80(%rsi), %r8
        shldq	%cl, %r8, %r11
        shldq	%cl, %rax, %r8
        shldq	%cl, %rdx, %rax
        shldq	%cl, %r9, %rdx
        movq	%rdx, 64(%rdi)
        movq	%rax, 72(%rdi)
        movq	%r8, 80(%rdi)
        movq	%r11, 88(%rdi)
        movq	24(%rsi), %r11
        movq	32(%rsi), %rdx
        movq	40(%rsi), %rax
        movq	48(%rsi), %r8
        shldq	%cl, %r8, %r9
        shldq	%cl, %rax, %r8
        shldq	%cl, %rdx, %rax
        shldq	%cl, %r11, %rdx
        movq	%rdx, 32(%rdi)
        movq	%rax, 40(%rdi)
        movq	%r8, 48(%rdi)
        movq	%r9, 56(%rdi)
        movq	(%rsi), %rdx
        movq	8(%rsi), %rax
        movq	16(%rsi), %r8
        shldq	%cl, %r8, %r11
        shldq	%cl, %rax, %r8
        shldq	%cl, %rdx, %rax
        shlq	%cl, %rdx
        movq	%rdx, (%rdi)
        movq	%rax, 8(%rdi)
        movq	%r8, 16(%rdi)
        movq	%r11, 24(%rdi)
        repz retq
#ifndef __APPLE__
.size	sp_2048_lshift_32,.-sp_2048_lshift_32
#endif /* __APPLE__ */
#endif /* !WOLFSSL_SP_NO_2048 */
#endif /* !WOLFSSL_SP_NO_2048 */
#ifndef WOLFSSL_SP_NO_3072
#ifndef WOLFSSL_SP_NO_3072
/* Read big endian unsigned byte array into r.
 * Uses the bswap instruction.
 *
 * r  A single precision integer.
 * size  Maximum number of bytes to convert
 * a  Byte array.
 * n  Number of bytes in array to read.
 */
#ifndef __APPLE__
.text
.globl	sp_3072_from_bin_bswap
.type	sp_3072_from_bin_bswap,@function
.align	16
sp_3072_from_bin_bswap:
#else
.section	__TEXT,__text
.globl	_sp_3072_from_bin_bswap
.p2align	4
_sp_3072_from_bin_bswap:
#endif /* __APPLE__ */
        movq	%rdx, %r9
        movq	%rdi, %r10
        addq	%rcx, %r9
        addq	$0x180, %r10
        xorq	%r11, %r11
        jmp	L_3072_from_bin_bswap_64_end
L_3072_from_bin_bswap_64_start:
        subq	$0x40, %r9
        movq	56(%r9), %rax
        movq	48(%r9), %r8
        bswapq	%rax
        bswapq	%r8
        movq	%rax, (%rdi)
        movq	%r8, 8(%rdi)
        movq	40(%r9), %rax
        movq	32(%r9), %r8
        bswapq	%rax
        bswapq	%r8
        movq	%rax, 16(%rdi)
        movq	%r8, 24(%rdi)
        movq	24(%r9), %rax
        movq	16(%r9), %r8
        bswapq	%rax
        bswapq	%r8
        movq	%rax, 32(%rdi)
        movq	%r8, 40(%rdi)
        movq	8(%r9), %rax
        movq	(%r9), %r8
        bswapq	%rax
        bswapq	%r8
        movq	%rax, 48(%rdi)
        movq	%r8, 56(%rdi)
        addq	$0x40, %rdi
        subq	$0x40, %rcx
L_3072_from_bin_bswap_64_end:
        cmpq	$63, %rcx
        jg	L_3072_from_bin_bswap_64_start
        jmp	L_3072_from_bin_bswap_8_end
L_3072_from_bin_bswap_8_start:
        subq	$8, %r9
        movq	(%r9), %rax
        bswapq	%rax
        movq	%rax, (%rdi)
        addq	$8, %rdi
        subq	$8, %rcx
L_3072_from_bin_bswap_8_end:
        cmpq	$7, %rcx
        jg	L_3072_from_bin_bswap_8_start
        cmpq	%r11, %rcx
        je	L_3072_from_bin_bswap_hi_end
        movq	%r11, %r8
        movq	%r11, %rax
L_3072_from_bin_bswap_hi_start:
        movb	(%rdx), %al
        shlq	$8, %r8
        incq	%rdx
        addq	%rax, %r8
        decq	%rcx
        jg	L_3072_from_bin_bswap_hi_start
        movq	%r8, (%rdi)
        addq	$8, %rdi
L_3072_from_bin_bswap_hi_end:
        cmpq	%r10, %rdi
        jge	L_3072_from_bin_bswap_zero_end
L_3072_from_bin_bswap_zero_start:
        movq	%r11, (%rdi)
        addq	$8, %rdi
        cmpq	%r10, %rdi
        jl	L_3072_from_bin_bswap_zero_start
L_3072_from_bin_bswap_zero_end:
        repz retq
#ifndef __APPLE__
.size	sp_3072_from_bin_bswap,.-sp_3072_from_bin_bswap
#endif /* __APPLE__ */
#ifndef NO_MOVBE_SUPPORT
/* Read big endian unsigned byte array into r.
 * Uses the movbe instruction which is an optional instruction.
 *
 * r  A single precision integer.
 * size  Maximum number of bytes to convert
 * a  Byte array.
 * n  Number of bytes in array to read.
 */
#ifndef __APPLE__
.text
.globl	sp_3072_from_bin_movbe
.type	sp_3072_from_bin_movbe,@function
.align	16
sp_3072_from_bin_movbe:
#else
.section	__TEXT,__text
.globl	_sp_3072_from_bin_movbe
.p2align	4
_sp_3072_from_bin_movbe:
#endif /* __APPLE__ */
        movq	%rdx, %r9
        movq	%rdi, %r10
        addq	%rcx, %r9
        addq	$0x180, %r10
        jmp	L_3072_from_bin_movbe_64_end
L_3072_from_bin_movbe_64_start:
        subq	$0x40, %r9
        movbeq	56(%r9), %rax
        movbeq	48(%r9), %r8
        movq	%rax, (%rdi)
        movq	%r8, 8(%rdi)
        movbeq	40(%r9), %rax
        movbeq	32(%r9), %r8
        movq	%rax, 16(%rdi)
        movq	%r8, 24(%rdi)
        movbeq	24(%r9), %rax
        movbeq	16(%r9), %r8
        movq	%rax, 32(%rdi)
        movq	%r8, 40(%rdi)
        movbeq	8(%r9), %rax
        movbeq	(%r9), %r8
        movq	%rax, 48(%rdi)
        movq	%r8, 56(%rdi)
        addq	$0x40, %rdi
        subq	$0x40, %rcx
L_3072_from_bin_movbe_64_end:
        cmpq	$63, %rcx
        jg	L_3072_from_bin_movbe_64_start
        jmp	L_3072_from_bin_movbe_8_end
L_3072_from_bin_movbe_8_start:
        subq	$8, %r9
        movbeq	(%r9), %rax
        movq	%rax, (%rdi)
        addq	$8, %rdi
        subq	$8, %rcx
L_3072_from_bin_movbe_8_end:
        cmpq	$7, %rcx
        jg	L_3072_from_bin_movbe_8_start
        cmpq	$0x00, %rcx
        je	L_3072_from_bin_movbe_hi_end
        movq	$0x00, %r8
        movq	$0x00, %rax
L_3072_from_bin_movbe_hi_start:
        movb	(%rdx), %al
        shlq	$8, %r8
        incq	%rdx
        addq	%rax, %r8
        decq	%rcx
        jg	L_3072_from_bin_movbe_hi_start
        movq	%r8, (%rdi)
        addq	$8, %rdi
L_3072_from_bin_movbe_hi_end:
        cmpq	%r10, %rdi
        jge	L_3072_from_bin_movbe_zero_end
L_3072_from_bin_movbe_zero_start:
        movq	$0x00, (%rdi)
        addq	$8, %rdi
        cmpq	%r10, %rdi
        jl	L_3072_from_bin_movbe_zero_start
L_3072_from_bin_movbe_zero_end:
        repz retq
#ifndef __APPLE__
.size	sp_3072_from_bin_movbe,.-sp_3072_from_bin_movbe
#endif /* __APPLE__ */
#endif /* !NO_MOVBE_SUPPORT */
/* Write r as big endian to byte array.
 * Fixed length number of bytes written: 384
 * Uses the bswap instruction.
 *
 * r  A single precision integer.
 * a  Byte array.
 */
#ifndef __APPLE__
.text
.globl	sp_3072_to_bin_bswap_48
.type	sp_3072_to_bin_bswap_48,@function
.align	16
sp_3072_to_bin_bswap_48:
#else
.section	__TEXT,__text
.globl	_sp_3072_to_bin_bswap_48
.p2align	4
_sp_3072_to_bin_bswap_48:
#endif /* __APPLE__ */
        movq	376(%rdi), %rdx
        movq	368(%rdi), %rax
        bswapq	%rdx
        bswapq	%rax
        movq	%rdx, (%rsi)
        movq	%rax, 8(%rsi)
        movq	360(%rdi), %rdx
        movq	352(%rdi), %rax
        bswapq	%rdx
        bswapq	%rax
        movq	%rdx, 16(%rsi)
        movq	%rax, 24(%rsi)
        movq	344(%rdi), %rdx
        movq	336(%rdi), %rax
        bswapq	%rdx
        bswapq	%rax
        movq	%rdx, 32(%rsi)
        movq	%rax, 40(%rsi)
        movq	328(%rdi), %rdx
        movq	320(%rdi), %rax
        bswapq	%rdx
        bswapq	%rax
        movq	%rdx, 48(%rsi)
        movq	%rax, 56(%rsi)
        movq	312(%rdi), %rdx
        movq	304(%rdi), %rax
        bswapq	%rdx
        bswapq	%rax
        movq	%rdx, 64(%rsi)
        movq	%rax, 72(%rsi)
        movq	296(%rdi), %rdx
        movq	288(%rdi), %rax
        bswapq	%rdx
        bswapq	%rax
        movq	%rdx, 80(%rsi)
        movq	%rax, 88(%rsi)
        movq	280(%rdi), %rdx
        movq	272(%rdi), %rax
        bswapq	%rdx
        bswapq	%rax
        movq	%rdx, 96(%rsi)
        movq	%rax, 104(%rsi)
        movq	264(%rdi), %rdx
        movq	256(%rdi), %rax
        bswapq	%rdx
        bswapq	%rax
        movq	%rdx, 112(%rsi)
        movq	%rax, 120(%rsi)
        movq	248(%rdi), %rdx
        movq	240(%rdi), %rax
        bswapq	%rdx
        bswapq	%rax
        movq	%rdx, 128(%rsi)
        movq	%rax, 136(%rsi)
        movq	232(%rdi), %rdx
        movq	224(%rdi), %rax
        bswapq	%rdx
        bswapq	%rax
        movq	%rdx, 144(%rsi)
        movq	%rax, 152(%rsi)
        movq	216(%rdi), %rdx
        movq	208(%rdi), %rax
        bswapq	%rdx
        bswapq	%rax
        movq	%rdx, 160(%rsi)
        movq	%rax, 168(%rsi)
        movq	200(%rdi), %rdx
        movq	192(%rdi), %rax
        bswapq	%rdx
        bswapq	%rax
        movq	%rdx, 176(%rsi)
        movq	%rax, 184(%rsi)
        movq	184(%rdi), %rdx
        movq	176(%rdi), %rax
        bswapq	%rdx
        bswapq	%rax
        movq	%rdx, 192(%rsi)
        movq	%rax, 200(%rsi)
        movq	168(%rdi), %rdx
        movq	160(%rdi), %rax
        bswapq	%rdx
        bswapq	%rax
        movq	%rdx, 208(%rsi)
        movq	%rax, 216(%rsi)
        movq	152(%rdi), %rdx
        movq	144(%rdi), %rax
        bswapq	%rdx
        bswapq	%rax
        movq	%rdx, 224(%rsi)
        movq	%rax, 232(%rsi)
        movq	136(%rdi), %rdx
        movq	128(%rdi), %rax
        bswapq	%rdx
        bswapq	%rax
        movq	%rdx, 240(%rsi)
        movq	%rax, 248(%rsi)
        movq	120(%rdi), %rdx
        movq	112(%rdi), %rax
        bswapq	%rdx
        bswapq	%rax
        movq	%rdx, 256(%rsi)
        movq	%rax, 264(%rsi)
        movq	104(%rdi), %rdx
        movq	96(%rdi), %rax
        bswapq	%rdx
        bswapq	%rax
        movq	%rdx, 272(%rsi)
        movq	%rax, 280(%rsi)
        movq	88(%rdi), %rdx
        movq	80(%rdi), %rax
        bswapq	%rdx
        bswapq	%rax
        movq	%rdx, 288(%rsi)
        movq	%rax, 296(%rsi)
        movq	72(%rdi), %rdx
        movq	64(%rdi), %rax
        bswapq	%rdx
        bswapq	%rax
        movq	%rdx, 304(%rsi)
        movq	%rax, 312(%rsi)
        movq	56(%rdi), %rdx
        movq	48(%rdi), %rax
        bswapq	%rdx
        bswapq	%rax
        movq	%rdx, 320(%rsi)
        movq	%rax, 328(%rsi)
        movq	40(%rdi), %rdx
        movq	32(%rdi), %rax
        bswapq	%rdx
        bswapq	%rax
        movq	%rdx, 336(%rsi)
        movq	%rax, 344(%rsi)
        movq	24(%rdi), %rdx
        movq	16(%rdi), %rax
        bswapq	%rdx
        bswapq	%rax
        movq	%rdx, 352(%rsi)
        movq	%rax, 360(%rsi)
        movq	8(%rdi), %rdx
        movq	(%rdi), %rax
        bswapq	%rdx
        bswapq	%rax
        movq	%rdx, 368(%rsi)
        movq	%rax, 376(%rsi)
        repz retq
#ifndef __APPLE__
.size	sp_3072_to_bin_bswap_48,.-sp_3072_to_bin_bswap_48
#endif /* __APPLE__ */
#ifndef NO_MOVBE_SUPPORT
/* Write r as big endian to byte array.
 * Fixed length number of bytes written: 384
 * Uses the movbe instruction which is optional.
 *
 * r  A single precision integer.
 * a  Byte array.
 */
#ifndef __APPLE__
.text
.globl	sp_3072_to_bin_movbe_48
.type	sp_3072_to_bin_movbe_48,@function
.align	16
sp_3072_to_bin_movbe_48:
#else
.section	__TEXT,__text
.globl	_sp_3072_to_bin_movbe_48
.p2align	4
_sp_3072_to_bin_movbe_48:
#endif /* __APPLE__ */
        movbeq	376(%rdi), %rdx
        movbeq	368(%rdi), %rax
        movq	%rdx, (%rsi)
        movq	%rax, 8(%rsi)
        movbeq	360(%rdi), %rdx
        movbeq	352(%rdi), %rax
        movq	%rdx, 16(%rsi)
        movq	%rax, 24(%rsi)
        movbeq	344(%rdi), %rdx
        movbeq	336(%rdi), %rax
        movq	%rdx, 32(%rsi)
        movq	%rax, 40(%rsi)
        movbeq	328(%rdi), %rdx
        movbeq	320(%rdi), %rax
        movq	%rdx, 48(%rsi)
        movq	%rax, 56(%rsi)
        movbeq	312(%rdi), %rdx
        movbeq	304(%rdi), %rax
        movq	%rdx, 64(%rsi)
        movq	%rax, 72(%rsi)
        movbeq	296(%rdi), %rdx
        movbeq	288(%rdi), %rax
        movq	%rdx, 80(%rsi)
        movq	%rax, 88(%rsi)
        movbeq	280(%rdi), %rdx
        movbeq	272(%rdi), %rax
        movq	%rdx, 96(%rsi)
        movq	%rax, 104(%rsi)
        movbeq	264(%rdi), %rdx
        movbeq	256(%rdi), %rax
        movq	%rdx, 112(%rsi)
        movq	%rax, 120(%rsi)
        movbeq	248(%rdi), %rdx
        movbeq	240(%rdi), %rax
        movq	%rdx, 128(%rsi)
        movq	%rax, 136(%rsi)
        movbeq	232(%rdi), %rdx
        movbeq	224(%rdi), %rax
        movq	%rdx, 144(%rsi)
        movq	%rax, 152(%rsi)
        movbeq	216(%rdi), %rdx
        movbeq	208(%rdi), %rax
        movq	%rdx, 160(%rsi)
        movq	%rax, 168(%rsi)
        movbeq	200(%rdi), %rdx
        movbeq	192(%rdi), %rax
        movq	%rdx, 176(%rsi)
        movq	%rax, 184(%rsi)
        movbeq	184(%rdi), %rdx
        movbeq	176(%rdi), %rax
        movq	%rdx, 192(%rsi)
        movq	%rax, 200(%rsi)
        movbeq	168(%rdi), %rdx
        movbeq	160(%rdi), %rax
        movq	%rdx, 208(%rsi)
        movq	%rax, 216(%rsi)
        movbeq	152(%rdi), %rdx
        movbeq	144(%rdi), %rax
        movq	%rdx, 224(%rsi)
        movq	%rax, 232(%rsi)
        movbeq	136(%rdi), %rdx
        movbeq	128(%rdi), %rax
        movq	%rdx, 240(%rsi)
        movq	%rax, 248(%rsi)
        movbeq	120(%rdi), %rdx
        movbeq	112(%rdi), %rax
        movq	%rdx, 256(%rsi)
        movq	%rax, 264(%rsi)
        movbeq	104(%rdi), %rdx
        movbeq	96(%rdi), %rax
        movq	%rdx, 272(%rsi)
        movq	%rax, 280(%rsi)
        movbeq	88(%rdi), %rdx
        movbeq	80(%rdi), %rax
        movq	%rdx, 288(%rsi)
        movq	%rax, 296(%rsi)
        movbeq	72(%rdi), %rdx
        movbeq	64(%rdi), %rax
        movq	%rdx, 304(%rsi)
        movq	%rax, 312(%rsi)
        movbeq	56(%rdi), %rdx
        movbeq	48(%rdi), %rax
        movq	%rdx, 320(%rsi)
        movq	%rax, 328(%rsi)
        movbeq	40(%rdi), %rdx
        movbeq	32(%rdi), %rax
        movq	%rdx, 336(%rsi)
        movq	%rax, 344(%rsi)
        movbeq	24(%rdi), %rdx
        movbeq	16(%rdi), %rax
        movq	%rdx, 352(%rsi)
        movq	%rax, 360(%rsi)
        movbeq	8(%rdi), %rdx
        movbeq	(%rdi), %rax
        movq	%rdx, 368(%rsi)
        movq	%rax, 376(%rsi)
        repz retq
#ifndef __APPLE__
.size	sp_3072_to_bin_movbe_48,.-sp_3072_to_bin_movbe_48
#endif /* __APPLE__ */
#endif /* NO_MOVBE_SUPPORT */
/* Multiply a and b into r. (r = a * b)
 *
 * r  A single precision integer.
 * a  A single precision integer.
 * b  A single precision integer.
 */
#ifndef __APPLE__
.text
.globl	sp_3072_mul_12
.type	sp_3072_mul_12,@function
.align	16
sp_3072_mul_12:
#else
.section	__TEXT,__text
.globl	_sp_3072_mul_12
.p2align	4
_sp_3072_mul_12:
#endif /* __APPLE__ */
        movq	%rdx, %rcx
        subq	$0x60, %rsp
        # A[0] * B[0]
        movq	(%rcx), %rax
        mulq	(%rsi)
        xorq	%r10, %r10
        movq	%rax, (%rsp)
        movq	%rdx, %r9
        # A[0] * B[1]
        movq	8(%rcx), %rax
        mulq	(%rsi)
        xorq	%r8, %r8
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0x00, %r8
        # A[1] * B[0]
        movq	(%rcx), %rax
        mulq	8(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0x00, %r8
        movq	%r9, 8(%rsp)
        # A[0] * B[2]
        movq	16(%rcx), %rax
        mulq	(%rsi)
        xorq	%r9, %r9
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0x00, %r9
        # A[1] * B[1]
        movq	8(%rcx), %rax
        mulq	8(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0x00, %r9
        # A[2] * B[0]
        movq	(%rcx), %rax
        mulq	16(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0x00, %r9
        movq	%r10, 16(%rsp)
        # A[0] * B[3]
        movq	24(%rcx), %rax
        mulq	(%rsi)
        xorq	%r10, %r10
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0x00, %r10
        # A[1] * B[2]
        movq	16(%rcx), %rax
        mulq	8(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0x00, %r10
        # A[2] * B[1]
        movq	8(%rcx), %rax
        mulq	16(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0x00, %r10
        # A[3] * B[0]
        movq	(%rcx), %rax
        mulq	24(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0x00, %r10
        movq	%r8, 24(%rsp)
        # A[0] * B[4]
        movq	32(%rcx), %rax
        mulq	(%rsi)
        xorq	%r8, %r8
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0x00, %r8
        # A[1] * B[3]
        movq	24(%rcx), %rax
        mulq	8(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0x00, %r8
        # A[2] * B[2]
        movq	16(%rcx), %rax
        mulq	16(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0x00, %r8
        # A[3] * B[1]
        movq	8(%rcx), %rax
        mulq	24(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0x00, %r8
        # A[4] * B[0]
        movq	(%rcx), %rax
        mulq	32(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0x00, %r8
        movq	%r9, 32(%rsp)
        # A[0] * B[5]
        movq	40(%rcx), %rax
        mulq	(%rsi)
        xorq	%r9, %r9
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0x00, %r9
        # A[1] * B[4]
        movq	32(%rcx), %rax
        mulq	8(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0x00, %r9
        # A[2] * B[3]
        movq	24(%rcx), %rax
        mulq	16(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0x00, %r9
        # A[3] * B[2]
        movq	16(%rcx), %rax
        mulq	24(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0x00, %r9
        # A[4] * B[1]
        movq	8(%rcx), %rax
        mulq	32(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0x00, %r9
        # A[5] * B[0]
        movq	(%rcx), %rax
        mulq	40(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0x00, %r9
        movq	%r10, 40(%rsp)
        # A[0] * B[6]
        movq	48(%rcx), %rax
        mulq	(%rsi)
        xorq	%r10, %r10
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0x00, %r10
        # A[1] * B[5]
        movq	40(%rcx), %rax
        mulq	8(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0x00, %r10
        # A[2] * B[4]
        movq	32(%rcx), %rax
        mulq	16(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0x00, %r10
        # A[3] * B[3]
        movq	24(%rcx), %rax
        mulq	24(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0x00, %r10
        # A[4] * B[2]
        movq	16(%rcx), %rax
        mulq	32(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0x00, %r10
        # A[5] * B[1]
        movq	8(%rcx), %rax
        mulq	40(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0x00, %r10
        # A[6] * B[0]
        movq	(%rcx), %rax
        mulq	48(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0x00, %r10
        movq	%r8, 48(%rsp)
        # A[0] * B[7]
        movq	56(%rcx), %rax
        mulq	(%rsi)
        xorq	%r8, %r8
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0x00, %r8
        # A[1] * B[6]
        movq	48(%rcx), %rax
        mulq	8(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0x00, %r8
        # A[2] * B[5]
        movq	40(%rcx), %rax
        mulq	16(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0x00, %r8
        # A[3] * B[4]
        movq	32(%rcx), %rax
        mulq	24(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0x00, %r8
        # A[4] * B[3]
        movq	24(%rcx), %rax
        mulq	32(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0x00, %r8
        # A[5] * B[2]
        movq	16(%rcx), %rax
        mulq	40(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0x00, %r8
        # A[6] * B[1]
        movq	8(%rcx), %rax
        mulq	48(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0x00, %r8
        # A[7] * B[0]
        movq	(%rcx), %rax
        mulq	56(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0x00, %r8
        movq	%r9, 56(%rsp)
        # A[0] * B[8]
        movq	64(%rcx), %rax
        mulq	(%rsi)
        xorq	%r9, %r9
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0x00, %r9
        # A[1] * B[7]
        movq	56(%rcx), %rax
        mulq	8(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0x00, %r9
        # A[2] * B[6]
        movq	48(%rcx), %rax
        mulq	16(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0x00, %r9
        # A[3] * B[5]
        movq	40(%rcx), %rax
        mulq	24(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0x00, %r9
        # A[4] * B[4]
        movq	32(%rcx), %rax
        mulq	32(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0x00, %r9
        # A[5] * B[3]
        movq	24(%rcx), %rax
        mulq	40(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0x00, %r9
        # A[6] * B[2]
        movq	16(%rcx), %rax
        mulq	48(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0x00, %r9
        # A[7] * B[1]
        movq	8(%rcx), %rax
        mulq	56(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0x00, %r9
        # A[8] * B[0]
        movq	(%rcx), %rax
        mulq	64(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0x00, %r9
        movq	%r10, 64(%rsp)
        # A[0] * B[9]
        movq	72(%rcx), %rax
        mulq	(%rsi)
        xorq	%r10, %r10
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0x00, %r10
        # A[1] * B[8]
        movq	64(%rcx), %rax
        mulq	8(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0x00, %r10
        # A[2] * B[7]
        movq	56(%rcx), %rax
        mulq	16(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0x00, %r10
        # A[3] * B[6]
        movq	48(%rcx), %rax
        mulq	24(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0x00, %r10
        # A[4] * B[5]
        movq	40(%rcx), %rax
        mulq	32(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0x00, %r10
        # A[5] * B[4]
        movq	32(%rcx), %rax
        mulq	40(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0x00, %r10
        # A[6] * B[3]
        movq	24(%rcx), %rax
        mulq	48(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0x00, %r10
        # A[7] * B[2]
        movq	16(%rcx), %rax
        mulq	56(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0x00, %r10
        # A[8] * B[1]
        movq	8(%rcx), %rax
        mulq	64(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0x00, %r10
        # A[9] * B[0]
        movq	(%rcx), %rax
        mulq	72(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0x00, %r10
        movq	%r8, 72(%rsp)
        # A[0] * B[10]
        movq	80(%rcx), %rax
        mulq	(%rsi)
        xorq	%r8, %r8
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0x00, %r8
        # A[1] * B[9]
        movq	72(%rcx), %rax
        mulq	8(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0x00, %r8
        # A[2] * B[8]
        movq	64(%rcx), %rax
        mulq	16(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0x00, %r8
        # A[3] * B[7]
        movq	56(%rcx), %rax
        mulq	24(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0x00, %r8
        # A[4] * B[6]
        movq	48(%rcx), %rax
        mulq	32(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0x00, %r8
        # A[5] * B[5]
        movq	40(%rcx), %rax
        mulq	40(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0x00, %r8
        # A[6] * B[4]
        movq	32(%rcx), %rax
        mulq	48(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0x00, %r8
        # A[7] * B[3]
        movq	24(%rcx), %rax
        mulq	56(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0x00, %r8
        # A[8] * B[2]
        movq	16(%rcx), %rax
        mulq	64(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0x00, %r8
        # A[9] * B[1]
        movq	8(%rcx), %rax
        mulq	72(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0x00, %r8
        # A[10] * B[0]
        movq	(%rcx), %rax
        mulq	80(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0x00, %r8
        movq	%r9, 80(%rsp)
        # A[0] * B[11]
        movq	88(%rcx), %rax
        mulq	(%rsi)
        xorq	%r9, %r9
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0x00, %r9
        # A[1] * B[10]
        movq	80(%rcx), %rax
        mulq	8(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0x00, %r9
        # A[2] * B[9]
        movq	72(%rcx), %rax
        mulq	16(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0x00, %r9
        # A[3] * B[8]
        movq	64(%rcx), %rax
        mulq	24(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0x00, %r9
        # A[4] * B[7]
        movq	56(%rcx), %rax
        mulq	32(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0x00, %r9
        # A[5] * B[6]
        movq	48(%rcx), %rax
        mulq	40(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0x00, %r9
        # A[6] * B[5]
        movq	40(%rcx), %rax
        mulq	48(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0x00, %r9
        # A[7] * B[4]
        movq	32(%rcx), %rax
        mulq	56(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0x00, %r9
        # A[8] * B[3]
        movq	24(%rcx), %rax
        mulq	64(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0x00, %r9
        # A[9] * B[2]
        movq	16(%rcx), %rax
        mulq	72(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0x00, %r9
        # A[10] * B[1]
        movq	8(%rcx), %rax
        mulq	80(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0x00, %r9
        # A[11] * B[0]
        movq	(%rcx), %rax
        mulq	88(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0x00, %r9
        movq	%r10, 88(%rsp)
        # A[1] * B[11]
        movq	88(%rcx), %rax
        mulq	8(%rsi)
        xorq	%r10, %r10
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0x00, %r10
        # A[2] * B[10]
        movq	80(%rcx), %rax
        mulq	16(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0x00, %r10
        # A[3] * B[9]
        movq	72(%rcx), %rax
        mulq	24(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0x00, %r10
        # A[4] * B[8]
        movq	64(%rcx), %rax
        mulq	32(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0x00, %r10
        # A[5] * B[7]
        movq	56(%rcx), %rax
        mulq	40(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0x00, %r10
        # A[6] * B[6]
        movq	48(%rcx), %rax
        mulq	48(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0x00, %r10
        # A[7] * B[5]
        movq	40(%rcx), %rax
        mulq	56(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0x00, %r10
        # A[8] * B[4]
        movq	32(%rcx), %rax
        mulq	64(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0x00, %r10
        # A[9] * B[3]
        movq	24(%rcx), %rax
        mulq	72(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0x00, %r10
        # A[10] * B[2]
        movq	16(%rcx), %rax
        mulq	80(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0x00, %r10
        # A[11] * B[1]
        movq	8(%rcx), %rax
        mulq	88(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0x00, %r10
        movq	%r8, 96(%rdi)
        # A[2] * B[11]
        movq	88(%rcx), %rax
        mulq	16(%rsi)
        xorq	%r8, %r8
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0x00, %r8
        # A[3] * B[10]
        movq	80(%rcx), %rax
        mulq	24(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0x00, %r8
        # A[4] * B[9]
        movq	72(%rcx), %rax
        mulq	32(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0x00, %r8
        # A[5] * B[8]
        movq	64(%rcx), %rax
        mulq	40(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0x00, %r8
        # A[6] * B[7]
        movq	56(%rcx), %rax
        mulq	48(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0x00, %r8
        # A[7] * B[6]
        movq	48(%rcx), %rax
        mulq	56(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0x00, %r8
        # A[8] * B[5]
        movq	40(%rcx), %rax
        mulq	64(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0x00, %r8
        # A[9] * B[4]
        movq	32(%rcx), %rax
        mulq	72(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0x00, %r8
        # A[10] * B[3]
        movq	24(%rcx), %rax
        mulq	80(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0x00, %r8
        # A[11] * B[2]
        movq	16(%rcx), %rax
        mulq	88(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0x00, %r8
        movq	%r9, 104(%rdi)
        # A[3] * B[11]
        movq	88(%rcx), %rax
        mulq	24(%rsi)
        xorq	%r9, %r9
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0x00, %r9
        # A[4] * B[10]
        movq	80(%rcx), %rax
        mulq	32(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0x00, %r9
        # A[5] * B[9]
        movq	72(%rcx), %rax
        mulq	40(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0x00, %r9
        # A[6] * B[8]
        movq	64(%rcx), %rax
        mulq	48(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0x00, %r9
        # A[7] * B[7]
        movq	56(%rcx), %rax
        mulq	56(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0x00, %r9
        # A[8] * B[6]
        movq	48(%rcx), %rax
        mulq	64(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0x00, %r9
        # A[9] * B[5]
        movq	40(%rcx), %rax
        mulq	72(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0x00, %r9
        # A[10] * B[4]
        movq	32(%rcx), %rax
        mulq	80(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0x00, %r9
        # A[11] * B[3]
        movq	24(%rcx), %rax
        mulq	88(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0x00, %r9
        movq	%r10, 112(%rdi)
        # A[4] * B[11]
        movq	88(%rcx), %rax
        mulq	32(%rsi)
        xorq	%r10, %r10
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0x00, %r10
        # A[5] * B[10]
        movq	80(%rcx), %rax
        mulq	40(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0x00, %r10
        # A[6] * B[9]
        movq	72(%rcx), %rax
        mulq	48(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0x00, %r10
        # A[7] * B[8]
        movq	64(%rcx), %rax
        mulq	56(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0x00, %r10
        # A[8] * B[7]
        movq	56(%rcx), %rax
        mulq	64(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0x00, %r10
        # A[9] * B[6]
        movq	48(%rcx), %rax
        mulq	72(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0x00, %r10
        # A[10] * B[5]
        movq	40(%rcx), %rax
        mulq	80(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0x00, %r10
        # A[11] * B[4]
        movq	32(%rcx), %rax
        mulq	88(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0x00, %r10
        movq	%r8, 120(%rdi)
        # A[5] * B[11]
        movq	88(%rcx), %rax
        mulq	40(%rsi)
        xorq	%r8, %r8
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0x00, %r8
        # A[6] * B[10]
        movq	80(%rcx), %rax
        mulq	48(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0x00, %r8
        # A[7] * B[9]
        movq	72(%rcx), %rax
        mulq	56(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0x00, %r8
        # A[8] * B[8]
        movq	64(%rcx), %rax
        mulq	64(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0x00, %r8
        # A[9] * B[7]
        movq	56(%rcx), %rax
        mulq	72(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0x00, %r8
        # A[10] * B[6]
        movq	48(%rcx), %rax
        mulq	80(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0x00, %r8
        # A[11] * B[5]
        movq	40(%rcx), %rax
        mulq	88(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0x00, %r8
        movq	%r9, 128(%rdi)
        # A[6] * B[11]
        movq	88(%rcx), %rax
        mulq	48(%rsi)
        xorq	%r9, %r9
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0x00, %r9
        # A[7] * B[10]
        movq	80(%rcx), %rax
        mulq	56(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0x00, %r9
        # A[8] * B[9]
        movq	72(%rcx), %rax
        mulq	64(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0x00, %r9
        # A[9] * B[8]
        movq	64(%rcx), %rax
        mulq	72(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0x00, %r9
        # A[10] * B[7]
        movq	56(%rcx), %rax
        mulq	80(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0x00, %r9
        # A[11] * B[6]
        movq	48(%rcx), %rax
        mulq	88(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0x00, %r9
        movq	%r10, 136(%rdi)
        # A[7] * B[11]
        movq	88(%rcx), %rax
        mulq	56(%rsi)
        xorq	%r10, %r10
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0x00, %r10
        # A[8] * B[10]
        movq	80(%rcx), %rax
        mulq	64(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0x00, %r10
        # A[9] * B[9]
        movq	72(%rcx), %rax
        mulq	72(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0x00, %r10
        # A[10] * B[8]
        movq	64(%rcx), %rax
        mulq	80(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0x00, %r10
        # A[11] * B[7]
        movq	56(%rcx), %rax
        mulq	88(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0x00, %r10
        movq	%r8, 144(%rdi)
        # A[8] * B[11]
        movq	88(%rcx), %rax
        mulq	64(%rsi)
        xorq	%r8, %r8
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0x00, %r8
        # A[9] * B[10]
        movq	80(%rcx), %rax
        mulq	72(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0x00, %r8
        # A[10] * B[9]
        movq	72(%rcx), %rax
        mulq	80(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0x00, %r8
        # A[11] * B[8]
        movq	64(%rcx), %rax
        mulq	88(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0x00, %r8
        movq	%r9, 152(%rdi)
        # A[9] * B[11]
        movq	88(%rcx), %rax
        mulq	72(%rsi)
        xorq	%r9, %r9
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0x00, %r9
        # A[10] * B[10]
        movq	80(%rcx), %rax
        mulq	80(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0x00, %r9
        # A[11] * B[9]
        movq	72(%rcx), %rax
        mulq	88(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0x00, %r9
        movq	%r10, 160(%rdi)
        # A[10] * B[11]
        movq	88(%rcx), %rax
        mulq	80(%rsi)
        xorq	%r10, %r10
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0x00, %r10
        # A[11] * B[10]
        movq	80(%rcx), %rax
        mulq	88(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0x00, %r10
        movq	%r8, 168(%rdi)
        # A[11] * B[11]
        movq	88(%rcx), %rax
        mulq	88(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        movq	%r9, 176(%rdi)
        movq	%r10, 184(%rdi)
        movq	(%rsp), %rax
        movq	8(%rsp), %rdx
        movq	16(%rsp), %r8
        movq	24(%rsp), %r9
        movq	%rax, (%rdi)
        movq	%rdx, 8(%rdi)
        movq	%r8, 16(%rdi)
        movq	%r9, 24(%rdi)
        movq	32(%rsp), %rax
        movq	40(%rsp), %rdx
        movq	48(%rsp), %r8
        movq	56(%rsp), %r9
        movq	%rax, 32(%rdi)
        movq	%rdx, 40(%rdi)
        movq	%r8, 48(%rdi)
        movq	%r9, 56(%rdi)
        movq	64(%rsp), %rax
        movq	72(%rsp), %rdx
        movq	80(%rsp), %r8
        movq	88(%rsp), %r9
        movq	%rax, 64(%rdi)
        movq	%rdx, 72(%rdi)
        movq	%r8, 80(%rdi)
        movq	%r9, 88(%rdi)
        addq	$0x60, %rsp
        repz retq
#ifndef __APPLE__
.size	sp_3072_mul_12,.-sp_3072_mul_12
#endif /* __APPLE__ */
#ifdef HAVE_INTEL_AVX2
/* Multiply a and b into r. (r = a * b)
 *
 * r   Result of multiplication.
 * a   First number to multiply.
 * b   Second number to multiply.
 */
#ifndef __APPLE__
.text
.globl	sp_3072_mul_avx2_12
.type	sp_3072_mul_avx2_12,@function
.align	16
sp_3072_mul_avx2_12:
#else
.section	__TEXT,__text
.globl	_sp_3072_mul_avx2_12
.p2align	4
_sp_3072_mul_avx2_12:
#endif /* __APPLE__ */
        pushq	%rbx
        pushq	%rbp
        pushq	%r12
        movq	%rdx, %rbp
        subq	$0x60, %rsp
        cmpq	%rdi, %rsi
        movq	%rsp, %rbx
        cmovne	%rdi, %rbx
        cmpq	%rdi, %rbp
        cmove	%rsp, %rbx
        addq	$0x60, %rdi
        xorq	%r12, %r12
        movq	(%rsi), %rdx
        # A[0] * B[0]
        mulx	(%rbp), %r8, %r9
        # A[0] * B[1]
        mulx	8(%rbp), %rax, %r10
        movq	%r8, (%rbx)
        adcxq	%rax, %r9
        movq	%r9, 8(%rbx)
        # A[0] * B[2]
        mulx	16(%rbp), %rax, %r8
        adcxq	%rax, %r10
        # A[0] * B[3]
        mulx	24(%rbp), %rax, %r9
        movq	%r10, 16(%rbx)
        adcxq	%rax, %r8
        movq	%r8, 24(%rbx)
        # A[0] * B[4]
        mulx	32(%rbp), %rax, %r10
        adcxq	%rax, %r9
        # A[0] * B[5]
        mulx	40(%rbp), %rax, %r8
        movq	%r9, 32(%rbx)
        adcxq	%rax, %r10
        movq	%r10, 40(%rbx)
        # A[0] * B[6]
        mulx	48(%rbp), %rax, %r9
        adcxq	%rax, %r8
        # A[0] * B[7]
        mulx	56(%rbp), %rax, %r10
        movq	%r8, 48(%rbx)
        adcxq	%rax, %r9
        movq	%r9, 56(%rbx)
        # A[0] * B[8]
        mulx	64(%rbp), %rax, %r8
        adcxq	%rax, %r10
        # A[0] * B[9]
        mulx	72(%rbp), %rax, %r9
        movq	%r10, 64(%rbx)
        adcxq	%rax, %r8
        movq	%r8, 72(%rbx)
        # A[0] * B[10]
        mulx	80(%rbp), %rax, %r10
        adcxq	%rax, %r9
        # A[0] * B[11]
        mulx	88(%rbp), %rax, %r8
        movq	%r9, 80(%rbx)
        adcxq	%rax, %r10
        adcxq	%r12, %r8
        movq	%r12, %r11
        adcxq	%r12, %r11
        movq	%r10, 88(%rbx)
        movq	%r8, (%rdi)
        movq	8(%rsi), %rdx
        movq	8(%rbx), %r9
        movq	16(%rbx), %r10
        movq	24(%rbx), %r8
        # A[1] * B[0]
        mulx	(%rbp), %rax, %rcx
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        # A[1] * B[1]
        mulx	8(%rbp), %rax, %rcx
        movq	%r9, 8(%rbx)
        adcxq	%rax, %r10
        adoxq	%rcx, %r8
        movq	%r10, 16(%rbx)
        movq	32(%rbx), %r9
        movq	40(%rbx), %r10
        # A[1] * B[2]
        mulx	16(%rbp), %rax, %rcx
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        # A[1] * B[3]
        mulx	24(%rbp), %rax, %rcx
        movq	%r8, 24(%rbx)
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        movq	%r9, 32(%rbx)
        movq	48(%rbx), %r8
        movq	56(%rbx), %r9
        # A[1] * B[4]
        mulx	32(%rbp), %rax, %rcx
        adcxq	%rax, %r10
        adoxq	%rcx, %r8
        # A[1] * B[5]
        mulx	40(%rbp), %rax, %rcx
        movq	%r10, 40(%rbx)
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        movq	%r8, 48(%rbx)
        movq	64(%rbx), %r10
        movq	72(%rbx), %r8
        # A[1] * B[6]
        mulx	48(%rbp), %rax, %rcx
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        # A[1] * B[7]
        mulx	56(%rbp), %rax, %rcx
        movq	%r9, 56(%rbx)
        adcxq	%rax, %r10
        adoxq	%rcx, %r8
        movq	%r10, 64(%rbx)
        movq	80(%rbx), %r9
        movq	88(%rbx), %r10
        # A[1] * B[8]
        mulx	64(%rbp), %rax, %rcx
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        # A[1] * B[9]
        mulx	72(%rbp), %rax, %rcx
        movq	%r8, 72(%rbx)
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        movq	%r9, 80(%rbx)
        movq	(%rdi), %r8
        # A[1] * B[10]
        mulx	80(%rbp), %rax, %rcx
        adcxq	%rax, %r10
        adoxq	%rcx, %r8
        # A[1] * B[11]
        mulx	88(%rbp), %rax, %rcx
        movq	%r10, 88(%rbx)
        movq	%r12, %r9
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        adcxq	%r11, %r9
        movq	%r12, %r11
        adoxq	%r12, %r11
        adcxq	%r12, %r11
        movq	%r8, (%rdi)
        movq	%r9, 8(%rdi)
        movq	16(%rsi), %rdx
        movq	16(%rbx), %r10
        movq	24(%rbx), %r8
        movq	32(%rbx), %r9
        # A[2] * B[0]
        mulx	(%rbp), %rax, %rcx
        adcxq	%rax, %r10
        adoxq	%rcx, %r8
        # A[2] * B[1]
        mulx	8(%rbp), %rax, %rcx
        movq	%r10, 16(%rbx)
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        movq	%r8, 24(%rbx)
        movq	40(%rbx), %r10
        movq	48(%rbx), %r8
        # A[2] * B[2]
        mulx	16(%rbp), %rax, %rcx
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        # A[2] * B[3]
        mulx	24(%rbp), %rax, %rcx
        movq	%r9, 32(%rbx)
        adcxq	%rax, %r10
        adoxq	%rcx, %r8
        movq	%r10, 40(%rbx)
        movq	56(%rbx), %r9
        movq	64(%rbx), %r10
        # A[2] * B[4]
        mulx	32(%rbp), %rax, %rcx
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        # A[2] * B[5]
        mulx	40(%rbp), %rax, %rcx
        movq	%r8, 48(%rbx)
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        movq	%r9, 56(%rbx)
        movq	72(%rbx), %r8
        movq	80(%rbx), %r9
        # A[2] * B[6]
        mulx	48(%rbp), %rax, %rcx
        adcxq	%rax, %r10
        adoxq	%rcx, %r8
        # A[2] * B[7]
        mulx	56(%rbp), %rax, %rcx
        movq	%r10, 64(%rbx)
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        movq	%r8, 72(%rbx)
        movq	88(%rbx), %r10
        movq	(%rdi), %r8
        # A[2] * B[8]
        mulx	64(%rbp), %rax, %rcx
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        # A[2] * B[9]
        mulx	72(%rbp), %rax, %rcx
        movq	%r9, 80(%rbx)
        adcxq	%rax, %r10
        adoxq	%rcx, %r8
        movq	%r10, 88(%rbx)
        movq	8(%rdi), %r9
        # A[2] * B[10]
        mulx	80(%rbp), %rax, %rcx
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        # A[2] * B[11]
        mulx	88(%rbp), %rax, %rcx
        movq	%r8, (%rdi)
        movq	%r12, %r10
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        adcxq	%r11, %r10
        movq	%r12, %r11
        adoxq	%r12, %r11
        adcxq	%r12, %r11
        movq	%r9, 8(%rdi)
        movq	%r10, 16(%rdi)
        movq	24(%rsi), %rdx
        movq	24(%rbx), %r8
        movq	32(%rbx), %r9
        movq	40(%rbx), %r10
        # A[3] * B[0]
        mulx	(%rbp), %rax, %rcx
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        # A[3] * B[1]
        mulx	8(%rbp), %rax, %rcx
        movq	%r8, 24(%rbx)
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        movq	%r9, 32(%rbx)
        movq	48(%rbx), %r8
        movq	56(%rbx), %r9
        # A[3] * B[2]
        mulx	16(%rbp), %rax, %rcx
        adcxq	%rax, %r10
        adoxq	%rcx, %r8
        # A[3] * B[3]
        mulx	24(%rbp), %rax, %rcx
        movq	%r10, 40(%rbx)
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        movq	%r8, 48(%rbx)
        movq	64(%rbx), %r10
        movq	72(%rbx), %r8
        # A[3] * B[4]
        mulx	32(%rbp), %rax, %rcx
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        # A[3] * B[5]
        mulx	40(%rbp), %rax, %rcx
        movq	%r9, 56(%rbx)
        adcxq	%rax, %r10
        adoxq	%rcx, %r8
        movq	%r10, 64(%rbx)
        movq	80(%rbx), %r9
        movq	88(%rbx), %r10
        # A[3] * B[6]
        mulx	48(%rbp), %rax, %rcx
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        # A[3] * B[7]
        mulx	56(%rbp), %rax, %rcx
        movq	%r8, 72(%rbx)
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        movq	%r9, 80(%rbx)
        movq	(%rdi), %r8
        movq	8(%rdi), %r9
        # A[3] * B[8]
        mulx	64(%rbp), %rax, %rcx
        adcxq	%rax, %r10
        adoxq	%rcx, %r8
        # A[3] * B[9]
        mulx	72(%rbp), %rax, %rcx
        movq	%r10, 88(%rbx)
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        movq	%r8, (%rdi)
        movq	16(%rdi), %r10
        # A[3] * B[10]
        mulx	80(%rbp), %rax, %rcx
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        # A[3] * B[11]
        mulx	88(%rbp), %rax, %rcx
        movq	%r9, 8(%rdi)
        movq	%r12, %r8
        adcxq	%rax, %r10
        adoxq	%rcx, %r8
        adcxq	%r11, %r8
        movq	%r12, %r11
        adoxq	%r12, %r11
        adcxq	%r12, %r11
        movq	%r10, 16(%rdi)
        movq	%r8, 24(%rdi)
        movq	32(%rsi), %rdx
        movq	32(%rbx), %r9
        movq	40(%rbx), %r10
        movq	48(%rbx), %r8
        # A[4] * B[0]
        mulx	(%rbp), %rax, %rcx
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        # A[4] * B[1]
        mulx	8(%rbp), %rax, %rcx
        movq	%r9, 32(%rbx)
        adcxq	%rax, %r10
        adoxq	%rcx, %r8
        movq	%r10, 40(%rbx)
        movq	56(%rbx), %r9
        movq	64(%rbx), %r10
        # A[4] * B[2]
        mulx	16(%rbp), %rax, %rcx
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        # A[4] * B[3]
        mulx	24(%rbp), %rax, %rcx
        movq	%r8, 48(%rbx)
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        movq	%r9, 56(%rbx)
        movq	72(%rbx), %r8
        movq	80(%rbx), %r9
        # A[4] * B[4]
        mulx	32(%rbp), %rax, %rcx
        adcxq	%rax, %r10
        adoxq	%rcx, %r8
        # A[4] * B[5]
        mulx	40(%rbp), %rax, %rcx
        movq	%r10, 64(%rbx)
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        movq	%r8, 72(%rbx)
        movq	88(%rbx), %r10
        movq	(%rdi), %r8
        # A[4] * B[6]
        mulx	48(%rbp), %rax, %rcx
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        # A[4] * B[7]
        mulx	56(%rbp), %rax, %rcx
        movq	%r9, 80(%rbx)
        adcxq	%rax, %r10
        adoxq	%rcx, %r8
        movq	%r10, 88(%rbx)
        movq	8(%rdi), %r9
        movq	16(%rdi), %r10
        # A[4] * B[8]
        mulx	64(%rbp), %rax, %rcx
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        # A[4] * B[9]
        mulx	72(%rbp), %rax, %rcx
        movq	%r8, (%rdi)
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        movq	%r9, 8(%rdi)
        movq	24(%rdi), %r8
        # A[4] * B[10]
        mulx	80(%rbp), %rax, %rcx
        adcxq	%rax, %r10
        adoxq	%rcx, %r8
        # A[4] * B[11]
        mulx	88(%rbp), %rax, %rcx
        movq	%r10, 16(%rdi)
        movq	%r12, %r9
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        adcxq	%r11, %r9
        movq	%r12, %r11
        adoxq	%r12, %r11
        adcxq	%r12, %r11
        movq	%r8, 24(%rdi)
        movq	%r9, 32(%rdi)
        movq	40(%rsi), %rdx
        movq	40(%rbx), %r10
        movq	48(%rbx), %r8
        movq	56(%rbx), %r9
        # A[5] * B[0]
        mulx	(%rbp), %rax, %rcx
        adcxq	%rax, %r10
        adoxq	%rcx, %r8
        # A[5] * B[1]
        mulx	8(%rbp), %rax, %rcx
        movq	%r10, 40(%rbx)
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        movq	%r8, 48(%rbx)
        movq	64(%rbx), %r10
        movq	72(%rbx), %r8
        # A[5] * B[2]
        mulx	16(%rbp), %rax, %rcx
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        # A[5] * B[3]
        mulx	24(%rbp), %rax, %rcx
        movq	%r9, 56(%rbx)
        adcxq	%rax, %r10
        adoxq	%rcx, %r8
        movq	%r10, 64(%rbx)
        movq	80(%rbx), %r9
        movq	88(%rbx), %r10
        # A[5] * B[4]
        mulx	32(%rbp), %rax, %rcx
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        # A[5] * B[5]
        mulx	40(%rbp), %rax, %rcx
        movq	%r8, 72(%rbx)
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        movq	%r9, 80(%rbx)
        movq	(%rdi), %r8
        movq	8(%rdi), %r9
        # A[5] * B[6]
        mulx	48(%rbp), %rax, %rcx
        adcxq	%rax, %r10
        adoxq	%rcx, %r8
        # A[5] * B[7]
        mulx	56(%rbp), %rax, %rcx
        movq	%r10, 88(%rbx)
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        movq	%r8, (%rdi)
        movq	16(%rdi), %r10
        movq	24(%rdi), %r8
        # A[5] * B[8]
        mulx	64(%rbp), %rax, %rcx
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        # A[5] * B[9]
        mulx	72(%rbp), %rax, %rcx
        movq	%r9, 8(%rdi)
        adcxq	%rax, %r10
        adoxq	%rcx, %r8
        movq	%r10, 16(%rdi)
        movq	32(%rdi), %r9
        # A[5] * B[10]
        mulx	80(%rbp), %rax, %rcx
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        # A[5] * B[11]
        mulx	88(%rbp), %rax, %rcx
        movq	%r8, 24(%rdi)
        movq	%r12, %r10
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        adcxq	%r11, %r10
        movq	%r12, %r11
        adoxq	%r12, %r11
        adcxq	%r12, %r11
        movq	%r9, 32(%rdi)
        movq	%r10, 40(%rdi)
        movq	48(%rsi), %rdx
        movq	48(%rbx), %r8
        movq	56(%rbx), %r9
        movq	64(%rbx), %r10
        # A[6] * B[0]
        mulx	(%rbp), %rax, %rcx
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        # A[6] * B[1]
        mulx	8(%rbp), %rax, %rcx
        movq	%r8, 48(%rbx)
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        movq	%r9, 56(%rbx)
        movq	72(%rbx), %r8
        movq	80(%rbx), %r9
        # A[6] * B[2]
        mulx	16(%rbp), %rax, %rcx
        adcxq	%rax, %r10
        adoxq	%rcx, %r8
        # A[6] * B[3]
        mulx	24(%rbp), %rax, %rcx
        movq	%r10, 64(%rbx)
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        movq	%r8, 72(%rbx)
        movq	88(%rbx), %r10
        movq	(%rdi), %r8
        # A[6] * B[4]
        mulx	32(%rbp), %rax, %rcx
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        # A[6] * B[5]
        mulx	40(%rbp), %rax, %rcx
        movq	%r9, 80(%rbx)
        adcxq	%rax, %r10
        adoxq	%rcx, %r8
        movq	%r10, 88(%rbx)
        movq	8(%rdi), %r9
        movq	16(%rdi), %r10
        # A[6] * B[6]
        mulx	48(%rbp), %rax, %rcx
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        # A[6] * B[7]
        mulx	56(%rbp), %rax, %rcx
        movq	%r8, (%rdi)
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        movq	%r9, 8(%rdi)
        movq	24(%rdi), %r8
        movq	32(%rdi), %r9
        # A[6] * B[8]
        mulx	64(%rbp), %rax, %rcx
        adcxq	%rax, %r10
        adoxq	%rcx, %r8
        # A[6] * B[9]
        mulx	72(%rbp), %rax, %rcx
        movq	%r10, 16(%rdi)
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        movq	%r8, 24(%rdi)
        movq	40(%rdi), %r10
        # A[6] * B[10]
        mulx	80(%rbp), %rax, %rcx
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        # A[6] * B[11]
        mulx	88(%rbp), %rax, %rcx
        movq	%r9, 32(%rdi)
        movq	%r12, %r8
        adcxq	%rax, %r10
        adoxq	%rcx, %r8
        adcxq	%r11, %r8
        movq	%r12, %r11
        adoxq	%r12, %r11
        adcxq	%r12, %r11
        movq	%r10, 40(%rdi)
        movq	%r8, 48(%rdi)
        movq	56(%rsi), %rdx
        movq	56(%rbx), %r9
        movq	64(%rbx), %r10
        movq	72(%rbx), %r8
        # A[7] * B[0]
        mulx	(%rbp), %rax, %rcx
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        # A[7] * B[1]
        mulx	8(%rbp), %rax, %rcx
        movq	%r9, 56(%rbx)
        adcxq	%rax, %r10
        adoxq	%rcx, %r8
        movq	%r10, 64(%rbx)
        movq	80(%rbx), %r9
        movq	88(%rbx), %r10
        # A[7] * B[2]
        mulx	16(%rbp), %rax, %rcx
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        # A[7] * B[3]
        mulx	24(%rbp), %rax, %rcx
        movq	%r8, 72(%rbx)
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        movq	%r9, 80(%rbx)
        movq	(%rdi), %r8
        movq	8(%rdi), %r9
        # A[7] * B[4]
        mulx	32(%rbp), %rax, %rcx
        adcxq	%rax, %r10
        adoxq	%rcx, %r8
        # A[7] * B[5]
        mulx	40(%rbp), %rax, %rcx
        movq	%r10, 88(%rbx)
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        movq	%r8, (%rdi)
        movq	16(%rdi), %r10
        movq	24(%rdi), %r8
        # A[7] * B[6]
        mulx	48(%rbp), %rax, %rcx
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        # A[7] * B[7]
        mulx	56(%rbp), %rax, %rcx
        movq	%r9, 8(%rdi)
        adcxq	%rax, %r10
        adoxq	%rcx, %r8
        movq	%r10, 16(%rdi)
        movq	32(%rdi), %r9
        movq	40(%rdi), %r10
        # A[7] * B[8]
        mulx	64(%rbp), %rax, %rcx
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        # A[7] * B[9]
        mulx	72(%rbp), %rax, %rcx
        movq	%r8, 24(%rdi)
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        movq	%r9, 32(%rdi)
        movq	48(%rdi), %r8
        # A[7] * B[10]
        mulx	80(%rbp), %rax, %rcx
        adcxq	%rax, %r10
        adoxq	%rcx, %r8
        # A[7] * B[11]
        mulx	88(%rbp), %rax, %rcx
        movq	%r10, 40(%rdi)
        movq	%r12, %r9
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        adcxq	%r11, %r9
        movq	%r12, %r11
        adoxq	%r12, %r11
        adcxq	%r12, %r11
        movq	%r8, 48(%rdi)
        movq	%r9, 56(%rdi)
        movq	64(%rsi), %rdx
        movq	64(%rbx), %r10
        movq	72(%rbx), %r8
        movq	80(%rbx), %r9
        # A[8] * B[0]
        mulx	(%rbp), %rax, %rcx
        adcxq	%rax, %r10
        adoxq	%rcx, %r8
        # A[8] * B[1]
        mulx	8(%rbp), %rax, %rcx
        movq	%r10, 64(%rbx)
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        movq	%r8, 72(%rbx)
        movq	88(%rbx), %r10
        movq	(%rdi), %r8
        # A[8] * B[2]
        mulx	16(%rbp), %rax, %rcx
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        # A[8] * B[3]
        mulx	24(%rbp), %rax, %rcx
        movq	%r9, 80(%rbx)
        adcxq	%rax, %r10
        adoxq	%rcx, %r8
        movq	%r10, 88(%rbx)
        movq	8(%rdi), %r9
        movq	16(%rdi), %r10
        # A[8] * B[4]
        mulx	32(%rbp), %rax, %rcx
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        # A[8] * B[5]
        mulx	40(%rbp), %rax, %rcx
        movq	%r8, (%rdi)
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        movq	%r9, 8(%rdi)
        movq	24(%rdi), %r8
        movq	32(%rdi), %r9
        # A[8] * B[6]
        mulx	48(%rbp), %rax, %rcx
        adcxq	%rax, %r10
        adoxq	%rcx, %r8
        # A[8] * B[7]
        mulx	56(%rbp), %rax, %rcx
        movq	%r10, 16(%rdi)
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        movq	%r8, 24(%rdi)
        movq	40(%rdi), %r10
        movq	48(%rdi), %r8
        # A[8] * B[8]
        mulx	64(%rbp), %rax, %rcx
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        # A[8] * B[9]
        mulx	72(%rbp), %rax, %rcx
        movq	%r9, 32(%rdi)
        adcxq	%rax, %r10
        adoxq	%rcx, %r8
        movq	%r10, 40(%rdi)
        movq	56(%rdi), %r9
        # A[8] * B[10]
        mulx	80(%rbp), %rax, %rcx
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        # A[8] * B[11]
        mulx	88(%rbp), %rax, %rcx
        movq	%r8, 48(%rdi)
        movq	%r12, %r10
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        adcxq	%r11, %r10
        movq	%r12, %r11
        adoxq	%r12, %r11
        adcxq	%r12, %r11
        movq	%r9, 56(%rdi)
        movq	%r10, 64(%rdi)
        movq	72(%rsi), %rdx
        movq	72(%rbx), %r8
        movq	80(%rbx), %r9
        movq	88(%rbx), %r10
        # A[9] * B[0]
        mulx	(%rbp), %rax, %rcx
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        # A[9] * B[1]
        mulx	8(%rbp), %rax, %rcx
        movq	%r8, 72(%rbx)
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        movq	%r9, 80(%rbx)
        movq	(%rdi), %r8
        movq	8(%rdi), %r9
        # A[9] * B[2]
        mulx	16(%rbp), %rax, %rcx
        adcxq	%rax, %r10
        adoxq	%rcx, %r8
        # A[9] * B[3]
        mulx	24(%rbp), %rax, %rcx
        movq	%r10, 88(%rbx)
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        movq	%r8, (%rdi)
        movq	16(%rdi), %r10
        movq	24(%rdi), %r8
        # A[9] * B[4]
        mulx	32(%rbp), %rax, %rcx
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        # A[9] * B[5]
        mulx	40(%rbp), %rax, %rcx
        movq	%r9, 8(%rdi)
        adcxq	%rax, %r10
        adoxq	%rcx, %r8
        movq	%r10, 16(%rdi)
        movq	32(%rdi), %r9
        movq	40(%rdi), %r10
        # A[9] * B[6]
        mulx	48(%rbp), %rax, %rcx
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        # A[9] * B[7]
        mulx	56(%rbp), %rax, %rcx
        movq	%r8, 24(%rdi)
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        movq	%r9, 32(%rdi)
        movq	48(%rdi), %r8
        movq	56(%rdi), %r9
        # A[9] * B[8]
        mulx	64(%rbp), %rax, %rcx
        adcxq	%rax, %r10
        adoxq	%rcx, %r8
        # A[9] * B[9]
        mulx	72(%rbp), %rax, %rcx
        movq	%r10, 40(%rdi)
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        movq	%r8, 48(%rdi)
        movq	64(%rdi), %r10
        # A[9] * B[10]
        mulx	80(%rbp), %rax, %rcx
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        # A[9] * B[11]
        mulx	88(%rbp), %rax, %rcx
        movq	%r9, 56(%rdi)
        movq	%r12, %r8
        adcxq	%rax, %r10
        adoxq	%rcx, %r8
        adcxq	%r11, %r8
        movq	%r12, %r11
        adoxq	%r12, %r11
        adcxq	%r12, %r11
        movq	%r10, 64(%rdi)
        movq	%r8, 72(%rdi)
        movq	80(%rsi), %rdx
        movq	80(%rbx), %r9
        movq	88(%rbx), %r10
        movq	(%rdi), %r8
        # A[10] * B[0]
        mulx	(%rbp), %rax, %rcx
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        # A[10] * B[1]
        mulx	8(%rbp), %rax, %rcx
        movq	%r9, 80(%rbx)
        adcxq	%rax, %r10
        adoxq	%rcx, %r8
        movq	%r10, 88(%rbx)
        movq	8(%rdi), %r9
        movq	16(%rdi), %r10
        # A[10] * B[2]
        mulx	16(%rbp), %rax, %rcx
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        # A[10] * B[3]
        mulx	24(%rbp), %rax, %rcx
        movq	%r8, (%rdi)
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        movq	%r9, 8(%rdi)
        movq	24(%rdi), %r8
        movq	32(%rdi), %r9
        # A[10] * B[4]
        mulx	32(%rbp), %rax, %rcx
        adcxq	%rax, %r10
        adoxq	%rcx, %r8
        # A[10] * B[5]
        mulx	40(%rbp), %rax, %rcx
        movq	%r10, 16(%rdi)
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        movq	%r8, 24(%rdi)
        movq	40(%rdi), %r10
        movq	48(%rdi), %r8
        # A[10] * B[6]
        mulx	48(%rbp), %rax, %rcx
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        # A[10] * B[7]
        mulx	56(%rbp), %rax, %rcx
        movq	%r9, 32(%rdi)
        adcxq	%rax, %r10
        adoxq	%rcx, %r8
        movq	%r10, 40(%rdi)
        movq	56(%rdi), %r9
        movq	64(%rdi), %r10
        # A[10] * B[8]
        mulx	64(%rbp), %rax, %rcx
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        # A[10] * B[9]
        mulx	72(%rbp), %rax, %rcx
        movq	%r8, 48(%rdi)
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        movq	%r9, 56(%rdi)
        movq	72(%rdi), %r8
        # A[10] * B[10]
        mulx	80(%rbp), %rax, %rcx
        adcxq	%rax, %r10
        adoxq	%rcx, %r8
        # A[10] * B[11]
        mulx	88(%rbp), %rax, %rcx
        movq	%r10, 64(%rdi)
        movq	%r12, %r9
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        adcxq	%r11, %r9
        movq	%r12, %r11
        adoxq	%r12, %r11
        adcxq	%r12, %r11
        movq	%r8, 72(%rdi)
        movq	%r9, 80(%rdi)
        movq	88(%rsi), %rdx
        movq	88(%rbx), %r10
        movq	(%rdi), %r8
        movq	8(%rdi), %r9
        # A[11] * B[0]
        mulx	(%rbp), %rax, %rcx
        adcxq	%rax, %r10
        adoxq	%rcx, %r8
        # A[11] * B[1]
        mulx	8(%rbp), %rax, %rcx
        movq	%r10, 88(%rbx)
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        movq	%r8, (%rdi)
        movq	16(%rdi), %r10
        movq	24(%rdi), %r8
        # A[11] * B[2]
        mulx	16(%rbp), %rax, %rcx
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        # A[11] * B[3]
        mulx	24(%rbp), %rax, %rcx
        movq	%r9, 8(%rdi)
        adcxq	%rax, %r10
        adoxq	%rcx, %r8
        movq	%r10, 16(%rdi)
        movq	32(%rdi), %r9
        movq	40(%rdi), %r10
        # A[11] * B[4]
        mulx	32(%rbp), %rax, %rcx
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        # A[11] * B[5]
        mulx	40(%rbp), %rax, %rcx
        movq	%r8, 24(%rdi)
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        movq	%r9, 32(%rdi)
        movq	48(%rdi), %r8
        movq	56(%rdi), %r9
        # A[11] * B[6]
        mulx	48(%rbp), %rax, %rcx
        adcxq	%rax, %r10
        adoxq	%rcx, %r8
        # A[11] * B[7]
        mulx	56(%rbp), %rax, %rcx
        movq	%r10, 40(%rdi)
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        movq	%r8, 48(%rdi)
        movq	64(%rdi), %r10
        movq	72(%rdi), %r8
        # A[11] * B[8]
        mulx	64(%rbp), %rax, %rcx
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        # A[11] * B[9]
        mulx	72(%rbp), %rax, %rcx
        movq	%r9, 56(%rdi)
        adcxq	%rax, %r10
        adoxq	%rcx, %r8
        movq	%r10, 64(%rdi)
        movq	80(%rdi), %r9
        # A[11] * B[10]
        mulx	80(%rbp), %rax, %rcx
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        # A[11] * B[11]
        mulx	88(%rbp), %rax, %rcx
        movq	%r8, 72(%rdi)
        movq	%r12, %r10
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        adcxq	%r11, %r10
        movq	%r9, 80(%rdi)
        movq	%r10, 88(%rdi)
        subq	$0x60, %rdi
        cmpq	%rdi, %rsi
        je	L_start_3072_mul_avx2_12
        cmpq	%rdi, %rbp
        jne	L_end_3072_mul_avx2_12
L_start_3072_mul_avx2_12:
        vmovdqu	(%rbx), %xmm0
        vmovups	%xmm0, (%rdi)
        vmovdqu	16(%rbx), %xmm0
        vmovups	%xmm0, 16(%rdi)
        vmovdqu	32(%rbx), %xmm0
        vmovups	%xmm0, 32(%rdi)
        vmovdqu	48(%rbx), %xmm0
        vmovups	%xmm0, 48(%rdi)
        vmovdqu	64(%rbx), %xmm0
        vmovups	%xmm0, 64(%rdi)
        vmovdqu	80(%rbx), %xmm0
        vmovups	%xmm0, 80(%rdi)
L_end_3072_mul_avx2_12:
        addq	$0x60, %rsp
        popq	%r12
        popq	%rbp
        popq	%rbx
        repz retq
#ifndef __APPLE__
.size	sp_3072_mul_avx2_12,.-sp_3072_mul_avx2_12
#endif /* __APPLE__ */
#endif /* HAVE_INTEL_AVX2 */
/* Add b to a into r. (r = a + b)
 *
 * r  A single precision integer.
 * a  A single precision integer.
 * b  A single precision integer.
 */
#ifndef __APPLE__
.text
.globl	sp_3072_add_12
.type	sp_3072_add_12,@function
.align	16
sp_3072_add_12:
#else
.section	__TEXT,__text
.globl	_sp_3072_add_12
.p2align	4
_sp_3072_add_12:
#endif /* __APPLE__ */
        # Add
        movq	(%rsi), %rcx
        xorq	%rax, %rax
        addq	(%rdx), %rcx
        movq	8(%rsi), %r8
        movq	%rcx, (%rdi)
        adcq	8(%rdx), %r8
        movq	16(%rsi), %rcx
        movq	%r8, 8(%rdi)
        adcq	16(%rdx), %rcx
        movq	24(%rsi), %r8
        movq	%rcx, 16(%rdi)
        adcq	24(%rdx), %r8
        movq	32(%rsi), %rcx
        movq	%r8, 24(%rdi)
        adcq	32(%rdx), %rcx
        movq	40(%rsi), %r8
        movq	%rcx, 32(%rdi)
        adcq	40(%rdx), %r8
        movq	48(%rsi), %rcx
        movq	%r8, 40(%rdi)
        adcq	48(%rdx), %rcx
        movq	56(%rsi), %r8
        movq	%rcx, 48(%rdi)
        adcq	56(%rdx), %r8
        movq	64(%rsi), %rcx
        movq	%r8, 56(%rdi)
        adcq	64(%rdx), %rcx
        movq	72(%rsi), %r8
        movq	%rcx, 64(%rdi)
        adcq	72(%rdx), %r8
        movq	80(%rsi), %rcx
        movq	%r8, 72(%rdi)
        adcq	80(%rdx), %rcx
        movq	88(%rsi), %r8
        movq	%rcx, 80(%rdi)
        adcq	88(%rdx), %r8
        movq	%r8, 88(%rdi)
        adcq	$0x00, %rax
        repz retq
#ifndef __APPLE__
.size	sp_3072_add_12,.-sp_3072_add_12
#endif /* __APPLE__ */
/* Sub b from a into a. (a -= b)
 *
 * a  A single precision integer and result.
 * b  A single precision integer.
 */
#ifndef __APPLE__
.text
.globl	sp_3072_sub_in_place_24
.type	sp_3072_sub_in_place_24,@function
.align	16
sp_3072_sub_in_place_24:
#else
.section	__TEXT,__text
.globl	_sp_3072_sub_in_place_24
.p2align	4
_sp_3072_sub_in_place_24:
#endif /* __APPLE__ */
        movq	(%rdi), %rdx
        subq	(%rsi), %rdx
        movq	8(%rdi), %rcx
        movq	%rdx, (%rdi)
        sbbq	8(%rsi), %rcx
        movq	16(%rdi), %rdx
        movq	%rcx, 8(%rdi)
        sbbq	16(%rsi), %rdx
        movq	24(%rdi), %rcx
        movq	%rdx, 16(%rdi)
        sbbq	24(%rsi), %rcx
        movq	32(%rdi), %rdx
        movq	%rcx, 24(%rdi)
        sbbq	32(%rsi), %rdx
        movq	40(%rdi), %rcx
        movq	%rdx, 32(%rdi)
        sbbq	40(%rsi), %rcx
        movq	48(%rdi), %rdx
        movq	%rcx, 40(%rdi)
        sbbq	48(%rsi), %rdx
        movq	56(%rdi), %rcx
        movq	%rdx, 48(%rdi)
        sbbq	56(%rsi), %rcx
        movq	64(%rdi), %rdx
        movq	%rcx, 56(%rdi)
        sbbq	64(%rsi), %rdx
        movq	72(%rdi), %rcx
        movq	%rdx, 64(%rdi)
        sbbq	72(%rsi), %rcx
        movq	80(%rdi), %rdx
        movq	%rcx, 72(%rdi)
        sbbq	80(%rsi), %rdx
        movq	88(%rdi), %rcx
        movq	%rdx, 80(%rdi)
        sbbq	88(%rsi), %rcx
        movq	96(%rdi), %rdx
        movq	%rcx, 88(%rdi)
        sbbq	96(%rsi), %rdx
        movq	104(%rdi), %rcx
        movq	%rdx, 96(%rdi)
        sbbq	104(%rsi), %rcx
        movq	112(%rdi), %rdx
        movq	%rcx, 104(%rdi)
        sbbq	112(%rsi), %rdx
        movq	120(%rdi), %rcx
        movq	%rdx, 112(%rdi)
        sbbq	120(%rsi), %rcx
        movq	128(%rdi), %rdx
        movq	%rcx, 120(%rdi)
        sbbq	128(%rsi), %rdx
        movq	136(%rdi), %rcx
        movq	%rdx, 128(%rdi)
        sbbq	136(%rsi), %rcx
        movq	144(%rdi), %rdx
        movq	%rcx, 136(%rdi)
        sbbq	144(%rsi), %rdx
        movq	152(%rdi), %rcx
        movq	%rdx, 144(%rdi)
        sbbq	152(%rsi), %rcx
        movq	160(%rdi), %rdx
        movq	%rcx, 152(%rdi)
        sbbq	160(%rsi), %rdx
        movq	168(%rdi), %rcx
        movq	%rdx, 160(%rdi)
        sbbq	168(%rsi), %rcx
        movq	176(%rdi), %rdx
        movq	%rcx, 168(%rdi)
        sbbq	176(%rsi), %rdx
        movq	184(%rdi), %rcx
        movq	%rdx, 176(%rdi)
        sbbq	184(%rsi), %rcx
        movq	%rcx, 184(%rdi)
        sbbq	%rax, %rax
        repz retq
#ifndef __APPLE__
.size	sp_3072_sub_in_place_24,.-sp_3072_sub_in_place_24
#endif /* __APPLE__ */
/* Add b to a into r. (r = a + b)
 *
 * r  A single precision integer.
 * a  A single precision integer.
 * b  A single precision integer.
 */
#ifndef __APPLE__
.text
.globl	sp_3072_add_24
.type	sp_3072_add_24,@function
.align	16
sp_3072_add_24:
#else
.section	__TEXT,__text
.globl	_sp_3072_add_24
.p2align	4
_sp_3072_add_24:
#endif /* __APPLE__ */
        # Add
        movq	(%rsi), %rcx
        xorq	%rax, %rax
        addq	(%rdx), %rcx
        movq	8(%rsi), %r8
        movq	%rcx, (%rdi)
        adcq	8(%rdx), %r8
        movq	16(%rsi), %rcx
        movq	%r8, 8(%rdi)
        adcq	16(%rdx), %rcx
        movq	24(%rsi), %r8
        movq	%rcx, 16(%rdi)
        adcq	24(%rdx), %r8
        movq	32(%rsi), %rcx
        movq	%r8, 24(%rdi)
        adcq	32(%rdx), %rcx
        movq	40(%rsi), %r8
        movq	%rcx, 32(%rdi)
        adcq	40(%rdx), %r8
        movq	48(%rsi), %rcx
        movq	%r8, 40(%rdi)
        adcq	48(%rdx), %rcx
        movq	56(%rsi), %r8
        movq	%rcx, 48(%rdi)
        adcq	56(%rdx), %r8
        movq	64(%rsi), %rcx
        movq	%r8, 56(%rdi)
        adcq	64(%rdx), %rcx
        movq	72(%rsi), %r8
        movq	%rcx, 64(%rdi)
        adcq	72(%rdx), %r8
        movq	80(%rsi), %rcx
        movq	%r8, 72(%rdi)
        adcq	80(%rdx), %rcx
        movq	88(%rsi), %r8
        movq	%rcx, 80(%rdi)
        adcq	88(%rdx), %r8
        movq	96(%rsi), %rcx
        movq	%r8, 88(%rdi)
        adcq	96(%rdx), %rcx
        movq	104(%rsi), %r8
        movq	%rcx, 96(%rdi)
        adcq	104(%rdx), %r8
        movq	112(%rsi), %rcx
        movq	%r8, 104(%rdi)
        adcq	112(%rdx), %rcx
        movq	120(%rsi), %r8
        movq	%rcx, 112(%rdi)
        adcq	120(%rdx), %r8
        movq	128(%rsi), %rcx
        movq	%r8, 120(%rdi)
        adcq	128(%rdx), %rcx
        movq	136(%rsi), %r8
        movq	%rcx, 128(%rdi)
        adcq	136(%rdx), %r8
        movq	144(%rsi), %rcx
        movq	%r8, 136(%rdi)
        adcq	144(%rdx), %rcx
        movq	152(%rsi), %r8
        movq	%rcx, 144(%rdi)
        adcq	152(%rdx), %r8
        movq	160(%rsi), %rcx
        movq	%r8, 152(%rdi)
        adcq	160(%rdx), %rcx
        movq	168(%rsi), %r8
        movq	%rcx, 160(%rdi)
        adcq	168(%rdx), %r8
        movq	176(%rsi), %rcx
        movq	%r8, 168(%rdi)
        adcq	176(%rdx), %rcx
        movq	184(%rsi), %r8
        movq	%rcx, 176(%rdi)
        adcq	184(%rdx), %r8
        movq	%r8, 184(%rdi)
        adcq	$0x00, %rax
        repz retq
#ifndef __APPLE__
.size	sp_3072_add_24,.-sp_3072_add_24
#endif /* __APPLE__ */
/* Multiply a and b into r. (r = a * b)
 *
 * r  A single precision integer.
 * a  A single precision integer.
 * b  A single precision integer.
 */
#ifndef __APPLE__
.text
.globl	sp_3072_mul_24
.type	sp_3072_mul_24,@function
.align	16
sp_3072_mul_24:
#else
.section	__TEXT,__text
.globl	_sp_3072_mul_24
.p2align	4
_sp_3072_mul_24:
#endif /* __APPLE__ */
        pushq	%r12
        pushq	%r13
        pushq	%r14
        pushq	%r15
        subq	$0x268, %rsp
        movq	%rdi, 576(%rsp)
        movq	%rsi, 584(%rsp)
        movq	%rdx, 592(%rsp)
        leaq	384(%rsp), %r10
        leaq	96(%rsi), %r12
        # Add
        movq	(%rsi), %rax
        xorq	%r13, %r13
        addq	(%r12), %rax
        movq	8(%rsi), %rcx
        movq	%rax, (%r10)
        adcq	8(%r12), %rcx
        movq	16(%rsi), %r8
        movq	%rcx, 8(%r10)
        adcq	16(%r12), %r8
        movq	24(%rsi), %rax
        movq	%r8, 16(%r10)
        adcq	24(%r12), %rax
        movq	32(%rsi), %rcx
        movq	%rax, 24(%r10)
        adcq	32(%r12), %rcx
        movq	40(%rsi), %r8
        movq	%rcx, 32(%r10)
        adcq	40(%r12), %r8
        movq	48(%rsi), %rax
        movq	%r8, 40(%r10)
        adcq	48(%r12), %rax
        movq	56(%rsi), %rcx
        movq	%rax, 48(%r10)
        adcq	56(%r12), %rcx
        movq	64(%rsi), %r8
        movq	%rcx, 56(%r10)
        adcq	64(%r12), %r8
        movq	72(%rsi), %rax
        movq	%r8, 64(%r10)
        adcq	72(%r12), %rax
        movq	80(%rsi), %rcx
        movq	%rax, 72(%r10)
        adcq	80(%r12), %rcx
        movq	88(%rsi), %r8
        movq	%rcx, 80(%r10)
        adcq	88(%r12), %r8
        movq	%r8, 88(%r10)
        adcq	$0x00, %r13
        movq	%r13, 600(%rsp)
        leaq	480(%rsp), %r11
        leaq	96(%rdx), %r12
        # Add
        movq	(%rdx), %rax
        xorq	%r14, %r14
        addq	(%r12), %rax
        movq	8(%rdx), %rcx
        movq	%rax, (%r11)
        adcq	8(%r12), %rcx
        movq	16(%rdx), %r8
        movq	%rcx, 8(%r11)
        adcq	16(%r12), %r8
        movq	24(%rdx), %rax
        movq	%r8, 16(%r11)
        adcq	24(%r12), %rax
        movq	32(%rdx), %rcx
        movq	%rax, 24(%r11)
        adcq	32(%r12), %rcx
        movq	40(%rdx), %r8
        movq	%rcx, 32(%r11)
        adcq	40(%r12), %r8
        movq	48(%rdx), %rax
        movq	%r8, 40(%r11)
        adcq	48(%r12), %rax
        movq	56(%rdx), %rcx
        movq	%rax, 48(%r11)
        adcq	56(%r12), %rcx
        movq	64(%rdx), %r8
        movq	%rcx, 56(%r11)
        adcq	64(%r12), %r8
        movq	72(%rdx), %rax
        movq	%r8, 64(%r11)
        adcq	72(%r12), %rax
        movq	80(%rdx), %rcx
        movq	%rax, 72(%r11)
        adcq	80(%r12), %rcx
        movq	88(%rdx), %r8
        movq	%rcx, 80(%r11)
        adcq	88(%r12), %r8
        movq	%r8, 88(%r11)
        adcq	$0x00, %r14
        movq	%r14, 608(%rsp)
        movq	%r11, %rdx
        movq	%r10, %rsi
        movq	%rsp, %rdi
#ifndef __APPLE__
        callq	sp_3072_mul_12@plt
#else
        callq	_sp_3072_mul_12
#endif /* __APPLE__ */
        movq	592(%rsp), %rdx
        movq	584(%rsp), %rsi
        leaq	192(%rsp), %rdi
        addq	$0x60, %rdx
        addq	$0x60, %rsi
#ifndef __APPLE__
        callq	sp_3072_mul_12@plt
#else
        callq	_sp_3072_mul_12
#endif /* __APPLE__ */
        movq	592(%rsp), %rdx
        movq	584(%rsp), %rsi
        movq	576(%rsp), %rdi
#ifndef __APPLE__
        callq	sp_3072_mul_12@plt
#else
        callq	_sp_3072_mul_12
#endif /* __APPLE__ */
#ifdef _WIN64
        movq	592(%rsp), %rdx
        movq	584(%rsp), %rsi
        movq	576(%rsp), %rdi
#endif /* _WIN64 */
        movq	600(%rsp), %r13
        movq	608(%rsp), %r14
        movq	576(%rsp), %r15
        movq	%r13, %r9
        leaq	384(%rsp), %r10
        leaq	480(%rsp), %r11
        andq	%r14, %r9
        negq	%r13
        negq	%r14
        addq	$0xc0, %r15
        movq	(%r10), %rax
        movq	(%r11), %rcx
        andq	%r14, %rax
        andq	%r13, %rcx
        movq	%rax, (%r10)
        movq	%rcx, (%r11)
        movq	8(%r10), %rax
        movq	8(%r11), %rcx
        andq	%r14, %rax
        andq	%r13, %rcx
        movq	%rax, 8(%r10)
        movq	%rcx, 8(%r11)
        movq	16(%r10), %rax
        movq	16(%r11), %rcx
        andq	%r14, %rax
        andq	%r13, %rcx
        movq	%rax, 16(%r10)
        movq	%rcx, 16(%r11)
        movq	24(%r10), %rax
        movq	24(%r11), %rcx
        andq	%r14, %rax
        andq	%r13, %rcx
        movq	%rax, 24(%r10)
        movq	%rcx, 24(%r11)
        movq	32(%r10), %rax
        movq	32(%r11), %rcx
        andq	%r14, %rax
        andq	%r13, %rcx
        movq	%rax, 32(%r10)
        movq	%rcx, 32(%r11)
        movq	40(%r10), %rax
        movq	40(%r11), %rcx
        andq	%r14, %rax
        andq	%r13, %rcx
        movq	%rax, 40(%r10)
        movq	%rcx, 40(%r11)
        movq	48(%r10), %rax
        movq	48(%r11), %rcx
        andq	%r14, %rax
        andq	%r13, %rcx
        movq	%rax, 48(%r10)
        movq	%rcx, 48(%r11)
        movq	56(%r10), %rax
        movq	56(%r11), %rcx
        andq	%r14, %rax
        andq	%r13, %rcx
        movq	%rax, 56(%r10)
        movq	%rcx, 56(%r11)
        movq	64(%r10), %rax
        movq	64(%r11), %rcx
        andq	%r14, %rax
        andq	%r13, %rcx
        movq	%rax, 64(%r10)
        movq	%rcx, 64(%r11)
        movq	72(%r10), %rax
        movq	72(%r11), %rcx
        andq	%r14, %rax
        andq	%r13, %rcx
        movq	%rax, 72(%r10)
        movq	%rcx, 72(%r11)
        movq	80(%r10), %rax
        movq	80(%r11), %rcx
        andq	%r14, %rax
        andq	%r13, %rcx
        movq	%rax, 80(%r10)
        movq	%rcx, 80(%r11)
        movq	88(%r10), %rax
        movq	88(%r11), %rcx
        andq	%r14, %rax
        andq	%r13, %rcx
        movq	%rax, 88(%r10)
        movq	%rcx, 88(%r11)
        movq	(%r10), %rax
        addq	(%r11), %rax
        movq	8(%r10), %rcx
        movq	%rax, (%r15)
        adcq	8(%r11), %rcx
        movq	16(%r10), %r8
        movq	%rcx, 8(%r15)
        adcq	16(%r11), %r8
        movq	24(%r10), %rax
        movq	%r8, 16(%r15)
        adcq	24(%r11), %rax
        movq	32(%r10), %rcx
        movq	%rax, 24(%r15)
        adcq	32(%r11), %rcx
        movq	40(%r10), %r8
        movq	%rcx, 32(%r15)
        adcq	40(%r11), %r8
        movq	48(%r10), %rax
        movq	%r8, 40(%r15)
        adcq	48(%r11), %rax
        movq	56(%r10), %rcx
        movq	%rax, 48(%r15)
        adcq	56(%r11), %rcx
        movq	64(%r10), %r8
        movq	%rcx, 56(%r15)
        adcq	64(%r11), %r8
        movq	72(%r10), %rax
        movq	%r8, 64(%r15)
        adcq	72(%r11), %rax
        movq	80(%r10), %rcx
        movq	%rax, 72(%r15)
        adcq	80(%r11), %rcx
        movq	88(%r10), %r8
        movq	%rcx, 80(%r15)
        adcq	88(%r11), %r8
        movq	%r8, 88(%r15)
        adcq	$0x00, %r9
        leaq	192(%rsp), %r11
        movq	%rsp, %r10
        movq	(%r10), %rax
        subq	(%r11), %rax
        movq	8(%r10), %rcx
        movq	%rax, (%r10)
        sbbq	8(%r11), %rcx
        movq	16(%r10), %r8
        movq	%rcx, 8(%r10)
        sbbq	16(%r11), %r8
        movq	24(%r10), %rax
        movq	%r8, 16(%r10)
        sbbq	24(%r11), %rax
        movq	32(%r10), %rcx
        movq	%rax, 24(%r10)
        sbbq	32(%r11), %rcx
        movq	40(%r10), %r8
        movq	%rcx, 32(%r10)
        sbbq	40(%r11), %r8
        movq	48(%r10), %rax
        movq	%r8, 40(%r10)
        sbbq	48(%r11), %rax
        movq	56(%r10), %rcx
        movq	%rax, 48(%r10)
        sbbq	56(%r11), %rcx
        movq	64(%r10), %r8
        movq	%rcx, 56(%r10)
        sbbq	64(%r11), %r8
        movq	72(%r10), %rax
        movq	%r8, 64(%r10)
        sbbq	72(%r11), %rax
        movq	80(%r10), %rcx
        movq	%rax, 72(%r10)
        sbbq	80(%r11), %rcx
        movq	88(%r10), %r8
        movq	%rcx, 80(%r10)
        sbbq	88(%r11), %r8
        movq	96(%r10), %rax
        movq	%r8, 88(%r10)
        sbbq	96(%r11), %rax
        movq	104(%r10), %rcx
        movq	%rax, 96(%r10)
        sbbq	104(%r11), %rcx
        movq	112(%r10), %r8
        movq	%rcx, 104(%r10)
        sbbq	112(%r11), %r8
        movq	120(%r10), %rax
        movq	%r8, 112(%r10)
        sbbq	120(%r11), %rax
        movq	128(%r10), %rcx
        movq	%rax, 120(%r10)
        sbbq	128(%r11), %rcx
        movq	136(%r10), %r8
        movq	%rcx, 128(%r10)
        sbbq	136(%r11), %r8
        movq	144(%r10), %rax
        movq	%r8, 136(%r10)
        sbbq	144(%r11), %rax
        movq	152(%r10), %rcx
        movq	%rax, 144(%r10)
        sbbq	152(%r11), %rcx
        movq	160(%r10), %r8
        movq	%rcx, 152(%r10)
        sbbq	160(%r11), %r8
        movq	168(%r10), %rax
        movq	%r8, 160(%r10)
        sbbq	168(%r11), %rax
        movq	176(%r10), %rcx
        movq	%rax, 168(%r10)
        sbbq	176(%r11), %rcx
        movq	184(%r10), %r8
        movq	%rcx, 176(%r10)
        sbbq	184(%r11), %r8
        movq	%r8, 184(%r10)
        sbbq	$0x00, %r9
        movq	(%r10), %rax
        subq	(%rdi), %rax
        movq	8(%r10), %rcx
        movq	%rax, (%r10)
        sbbq	8(%rdi), %rcx
        movq	16(%r10), %r8
        movq	%rcx, 8(%r10)
        sbbq	16(%rdi), %r8
        movq	24(%r10), %rax
        movq	%r8, 16(%r10)
        sbbq	24(%rdi), %rax
        movq	32(%r10), %rcx
        movq	%rax, 24(%r10)
        sbbq	32(%rdi), %rcx
        movq	40(%r10), %r8
        movq	%rcx, 32(%r10)
        sbbq	40(%rdi), %r8
        movq	48(%r10), %rax
        movq	%r8, 40(%r10)
        sbbq	48(%rdi), %rax
        movq	56(%r10), %rcx
        movq	%rax, 48(%r10)
        sbbq	56(%rdi), %rcx
        movq	64(%r10), %r8
        movq	%rcx, 56(%r10)
        sbbq	64(%rdi), %r8
        movq	72(%r10), %rax
        movq	%r8, 64(%r10)
        sbbq	72(%rdi), %rax
        movq	80(%r10), %rcx
        movq	%rax, 72(%r10)
        sbbq	80(%rdi), %rcx
        movq	88(%r10), %r8
        movq	%rcx, 80(%r10)
        sbbq	88(%rdi), %r8
        movq	96(%r10), %rax
        movq	%r8, 88(%r10)
        sbbq	96(%rdi), %rax
        movq	104(%r10), %rcx
        movq	%rax, 96(%r10)
        sbbq	104(%rdi), %rcx
        movq	112(%r10), %r8
        movq	%rcx, 104(%r10)
        sbbq	112(%rdi), %r8
        movq	120(%r10), %rax
        movq	%r8, 112(%r10)
        sbbq	120(%rdi), %rax
        movq	128(%r10), %rcx
        movq	%rax, 120(%r10)
        sbbq	128(%rdi), %rcx
        movq	136(%r10), %r8
        movq	%rcx, 128(%r10)
        sbbq	136(%rdi), %r8
        movq	144(%r10), %rax
        movq	%r8, 136(%r10)
        sbbq	144(%rdi), %rax
        movq	152(%r10), %rcx
        movq	%rax, 144(%r10)
        sbbq	152(%rdi), %rcx
        movq	160(%r10), %r8
        movq	%rcx, 152(%r10)
        sbbq	160(%rdi), %r8
        movq	168(%r10), %rax
        movq	%r8, 160(%r10)
        sbbq	168(%rdi), %rax
        movq	176(%r10), %rcx
        movq	%rax, 168(%r10)
        sbbq	176(%rdi), %rcx
        movq	184(%r10), %r8
        movq	%rcx, 176(%r10)
        sbbq	184(%rdi), %r8
        movq	%r8, 184(%r10)
        sbbq	$0x00, %r9
        subq	$0x60, %r15
        # Add
        movq	(%r15), %rax
        addq	(%r10), %rax
        movq	8(%r15), %rcx
        movq	%rax, (%r15)
        adcq	8(%r10), %rcx
        movq	16(%r15), %r8
        movq	%rcx, 8(%r15)
        adcq	16(%r10), %r8
        movq	24(%r15), %rax
        movq	%r8, 16(%r15)
        adcq	24(%r10), %rax
        movq	32(%r15), %rcx
        movq	%rax, 24(%r15)
        adcq	32(%r10), %rcx
        movq	40(%r15), %r8
        movq	%rcx, 32(%r15)
        adcq	40(%r10), %r8
        movq	48(%r15), %rax
        movq	%r8, 40(%r15)
        adcq	48(%r10), %rax
        movq	56(%r15), %rcx
        movq	%rax, 48(%r15)
        adcq	56(%r10), %rcx
        movq	64(%r15), %r8
        movq	%rcx, 56(%r15)
        adcq	64(%r10), %r8
        movq	72(%r15), %rax
        movq	%r8, 64(%r15)
        adcq	72(%r10), %rax
        movq	80(%r15), %rcx
        movq	%rax, 72(%r15)
        adcq	80(%r10), %rcx
        movq	88(%r15), %r8
        movq	%rcx, 80(%r15)
        adcq	88(%r10), %r8
        movq	96(%r15), %rax
        movq	%r8, 88(%r15)
        adcq	96(%r10), %rax
        movq	104(%r15), %rcx
        movq	%rax, 96(%r15)
        adcq	104(%r10), %rcx
        movq	112(%r15), %r8
        movq	%rcx, 104(%r15)
        adcq	112(%r10), %r8
        movq	120(%r15), %rax
        movq	%r8, 112(%r15)
        adcq	120(%r10), %rax
        movq	128(%r15), %rcx
        movq	%rax, 120(%r15)
        adcq	128(%r10), %rcx
        movq	136(%r15), %r8
        movq	%rcx, 128(%r15)
        adcq	136(%r10), %r8
        movq	144(%r15), %rax
        movq	%r8, 136(%r15)
        adcq	144(%r10), %rax
        movq	152(%r15), %rcx
        movq	%rax, 144(%r15)
        adcq	152(%r10), %rcx
        movq	160(%r15), %r8
        movq	%rcx, 152(%r15)
        adcq	160(%r10), %r8
        movq	168(%r15), %rax
        movq	%r8, 160(%r15)
        adcq	168(%r10), %rax
        movq	176(%r15), %rcx
        movq	%rax, 168(%r15)
        adcq	176(%r10), %rcx
        movq	184(%r15), %r8
        movq	%rcx, 176(%r15)
        adcq	184(%r10), %r8
        movq	%r8, 184(%r15)
        adcq	$0x00, %r9
        movq	%r9, 288(%rdi)
        addq	$0x60, %r15
        # Add
        movq	(%r15), %rax
        addq	(%r11), %rax
        movq	8(%r15), %rcx
        movq	%rax, (%r15)
        adcq	8(%r11), %rcx
        movq	16(%r15), %r8
        movq	%rcx, 8(%r15)
        adcq	16(%r11), %r8
        movq	24(%r15), %rax
        movq	%r8, 16(%r15)
        adcq	24(%r11), %rax
        movq	32(%r15), %rcx
        movq	%rax, 24(%r15)
        adcq	32(%r11), %rcx
        movq	40(%r15), %r8
        movq	%rcx, 32(%r15)
        adcq	40(%r11), %r8
        movq	48(%r15), %rax
        movq	%r8, 40(%r15)
        adcq	48(%r11), %rax
        movq	56(%r15), %rcx
        movq	%rax, 48(%r15)
        adcq	56(%r11), %rcx
        movq	64(%r15), %r8
        movq	%rcx, 56(%r15)
        adcq	64(%r11), %r8
        movq	72(%r15), %rax
        movq	%r8, 64(%r15)
        adcq	72(%r11), %rax
        movq	80(%r15), %rcx
        movq	%rax, 72(%r15)
        adcq	80(%r11), %rcx
        movq	88(%r15), %r8
        movq	%rcx, 80(%r15)
        adcq	88(%r11), %r8
        movq	96(%r15), %rax
        movq	%r8, 88(%r15)
        adcq	96(%r11), %rax
        movq	%rax, 96(%r15)
        # Add to zero
        movq	104(%r11), %rax
        adcq	$0x00, %rax
        movq	112(%r11), %rcx
        movq	%rax, 104(%r15)
        adcq	$0x00, %rcx
        movq	120(%r11), %r8
        movq	%rcx, 112(%r15)
        adcq	$0x00, %r8
        movq	128(%r11), %rax
        movq	%r8, 120(%r15)
        adcq	$0x00, %rax
        movq	136(%r11), %rcx
        movq	%rax, 128(%r15)
        adcq	$0x00, %rcx
        movq	144(%r11), %r8
        movq	%rcx, 136(%r15)
        adcq	$0x00, %r8
        movq	152(%r11), %rax
        movq	%r8, 144(%r15)
        adcq	$0x00, %rax
        movq	160(%r11), %rcx
        movq	%rax, 152(%r15)
        adcq	$0x00, %rcx
        movq	168(%r11), %r8
        movq	%rcx, 160(%r15)
        adcq	$0x00, %r8
        movq	176(%r11), %rax
        movq	%r8, 168(%r15)
        adcq	$0x00, %rax
        movq	184(%r11), %rcx
        movq	%rax, 176(%r15)
        adcq	$0x00, %rcx
        movq	%rcx, 184(%r15)
        addq	$0x268, %rsp
        popq	%r15
        popq	%r14
        popq	%r13
        popq	%r12
        repz retq
#ifndef __APPLE__
.size	sp_3072_mul_24,.-sp_3072_mul_24
#endif /* __APPLE__ */
#ifdef HAVE_INTEL_AVX2
/* Multiply a and b into r. (r = a * b)
 *
 * r  A single precision integer.
 * a  A single precision integer.
 * b  A single precision integer.
 */
#ifndef __APPLE__
.text
.globl	sp_3072_mul_avx2_24
.type	sp_3072_mul_avx2_24,@function
.align	16
sp_3072_mul_avx2_24:
#else
.section	__TEXT,__text
.globl	_sp_3072_mul_avx2_24
.p2align	4
_sp_3072_mul_avx2_24:
#endif /* __APPLE__ */
        pushq	%r12
        pushq	%r13
        pushq	%r14
        pushq	%r15
        subq	$0x268, %rsp
        movq	%rdi, 576(%rsp)
        movq	%rsi, 584(%rsp)
        movq	%rdx, 592(%rsp)
        leaq	384(%rsp), %r10
        leaq	96(%rsi), %r12
        # Add
        movq	(%rsi), %rax
        xorq	%r13, %r13
        addq	(%r12), %rax
        movq	8(%rsi), %rcx
        movq	%rax, (%r10)
        adcq	8(%r12), %rcx
        movq	16(%rsi), %r8
        movq	%rcx, 8(%r10)
        adcq	16(%r12), %r8
        movq	24(%rsi), %rax
        movq	%r8, 16(%r10)
        adcq	24(%r12), %rax
        movq	32(%rsi), %rcx
        movq	%rax, 24(%r10)
        adcq	32(%r12), %rcx
        movq	40(%rsi), %r8
        movq	%rcx, 32(%r10)
        adcq	40(%r12), %r8
        movq	48(%rsi), %rax
        movq	%r8, 40(%r10)
        adcq	48(%r12), %rax
        movq	56(%rsi), %rcx
        movq	%rax, 48(%r10)
        adcq	56(%r12), %rcx
        movq	64(%rsi), %r8
        movq	%rcx, 56(%r10)
        adcq	64(%r12), %r8
        movq	72(%rsi), %rax
        movq	%r8, 64(%r10)
        adcq	72(%r12), %rax
        movq	80(%rsi), %rcx
        movq	%rax, 72(%r10)
        adcq	80(%r12), %rcx
        movq	88(%rsi), %r8
        movq	%rcx, 80(%r10)
        adcq	88(%r12), %r8
        movq	%r8, 88(%r10)
        adcq	$0x00, %r13
        movq	%r13, 600(%rsp)
        leaq	480(%rsp), %r11
        leaq	96(%rdx), %r12
        # Add
        movq	(%rdx), %rax
        xorq	%r14, %r14
        addq	(%r12), %rax
        movq	8(%rdx), %rcx
        movq	%rax, (%r11)
        adcq	8(%r12), %rcx
        movq	16(%rdx), %r8
        movq	%rcx, 8(%r11)
        adcq	16(%r12), %r8
        movq	24(%rdx), %rax
        movq	%r8, 16(%r11)
        adcq	24(%r12), %rax
        movq	32(%rdx), %rcx
        movq	%rax, 24(%r11)
        adcq	32(%r12), %rcx
        movq	40(%rdx), %r8
        movq	%rcx, 32(%r11)
        adcq	40(%r12), %r8
        movq	48(%rdx), %rax
        movq	%r8, 40(%r11)
        adcq	48(%r12), %rax
        movq	56(%rdx), %rcx
        movq	%rax, 48(%r11)
        adcq	56(%r12), %rcx
        movq	64(%rdx), %r8
        movq	%rcx, 56(%r11)
        adcq	64(%r12), %r8
        movq	72(%rdx), %rax
        movq	%r8, 64(%r11)
        adcq	72(%r12), %rax
        movq	80(%rdx), %rcx
        movq	%rax, 72(%r11)
        adcq	80(%r12), %rcx
        movq	88(%rdx), %r8
        movq	%rcx, 80(%r11)
        adcq	88(%r12), %r8
        movq	%r8, 88(%r11)
        adcq	$0x00, %r14
        movq	%r14, 608(%rsp)
        movq	%r11, %rdx
        movq	%r10, %rsi
        movq	%rsp, %rdi
#ifndef __APPLE__
        callq	sp_3072_mul_avx2_12@plt
#else
        callq	_sp_3072_mul_avx2_12
#endif /* __APPLE__ */
        movq	592(%rsp), %rdx
        movq	584(%rsp), %rsi
        leaq	192(%rsp), %rdi
        addq	$0x60, %rdx
        addq	$0x60, %rsi
#ifndef __APPLE__
        callq	sp_3072_mul_avx2_12@plt
#else
        callq	_sp_3072_mul_avx2_12
#endif /* __APPLE__ */
        movq	592(%rsp), %rdx
        movq	584(%rsp), %rsi
        movq	576(%rsp), %rdi
#ifndef __APPLE__
        callq	sp_3072_mul_avx2_12@plt
#else
        callq	_sp_3072_mul_avx2_12
#endif /* __APPLE__ */
#ifdef _WIN64
        movq	592(%rsp), %rdx
        movq	584(%rsp), %rsi
        movq	576(%rsp), %rdi
#endif /* _WIN64 */
        movq	600(%rsp), %r13
        movq	608(%rsp), %r14
        movq	576(%rsp), %r15
        movq	%r13, %r9
        leaq	384(%rsp), %r10
        leaq	480(%rsp), %r11
        andq	%r14, %r9
        negq	%r13
        negq	%r14
        addq	$0xc0, %r15
        movq	(%r10), %rax
        movq	(%r11), %rcx
        pextq	%r14, %rax, %rax
        pextq	%r13, %rcx, %rcx
        addq	%rcx, %rax
        movq	8(%r10), %rcx
        movq	8(%r11), %r8
        pextq	%r14, %rcx, %rcx
        pextq	%r13, %r8, %r8
        movq	%rax, (%r15)
        adcq	%r8, %rcx
        movq	16(%r10), %r8
        movq	16(%r11), %rax
        pextq	%r14, %r8, %r8
        pextq	%r13, %rax, %rax
        movq	%rcx, 8(%r15)
        adcq	%rax, %r8
        movq	24(%r10), %rax
        movq	24(%r11), %rcx
        pextq	%r14, %rax, %rax
        pextq	%r13, %rcx, %rcx
        movq	%r8, 16(%r15)
        adcq	%rcx, %rax
        movq	32(%r10), %rcx
        movq	32(%r11), %r8
        pextq	%r14, %rcx, %rcx
        pextq	%r13, %r8, %r8
        movq	%rax, 24(%r15)
        adcq	%r8, %rcx
        movq	40(%r10), %r8
        movq	40(%r11), %rax
        pextq	%r14, %r8, %r8
        pextq	%r13, %rax, %rax
        movq	%rcx, 32(%r15)
        adcq	%rax, %r8
        movq	48(%r10), %rax
        movq	48(%r11), %rcx
        pextq	%r14, %rax, %rax
        pextq	%r13, %rcx, %rcx
        movq	%r8, 40(%r15)
        adcq	%rcx, %rax
        movq	56(%r10), %rcx
        movq	56(%r11), %r8
        pextq	%r14, %rcx, %rcx
        pextq	%r13, %r8, %r8
        movq	%rax, 48(%r15)
        adcq	%r8, %rcx
        movq	64(%r10), %r8
        movq	64(%r11), %rax
        pextq	%r14, %r8, %r8
        pextq	%r13, %rax, %rax
        movq	%rcx, 56(%r15)
        adcq	%rax, %r8
        movq	72(%r10), %rax
        movq	72(%r11), %rcx
        pextq	%r14, %rax, %rax
        pextq	%r13, %rcx, %rcx
        movq	%r8, 64(%r15)
        adcq	%rcx, %rax
        movq	80(%r10), %rcx
        movq	80(%r11), %r8
        pextq	%r14, %rcx, %rcx
        pextq	%r13, %r8, %r8
        movq	%rax, 72(%r15)
        adcq	%r8, %rcx
        movq	88(%r10), %r8
        movq	88(%r11), %rax
        pextq	%r14, %r8, %r8
        pextq	%r13, %rax, %rax
        movq	%rcx, 80(%r15)
        adcq	%rax, %r8
        movq	%r8, 88(%r15)
        adcq	$0x00, %r9
        leaq	192(%rsp), %r11
        movq	%rsp, %r10
        movq	(%r10), %rax
        subq	(%r11), %rax
        movq	8(%r10), %rcx
        movq	%rax, (%r10)
        sbbq	8(%r11), %rcx
        movq	16(%r10), %r8
        movq	%rcx, 8(%r10)
        sbbq	16(%r11), %r8
        movq	24(%r10), %rax
        movq	%r8, 16(%r10)
        sbbq	24(%r11), %rax
        movq	32(%r10), %rcx
        movq	%rax, 24(%r10)
        sbbq	32(%r11), %rcx
        movq	40(%r10), %r8
        movq	%rcx, 32(%r10)
        sbbq	40(%r11), %r8
        movq	48(%r10), %rax
        movq	%r8, 40(%r10)
        sbbq	48(%r11), %rax
        movq	56(%r10), %rcx
        movq	%rax, 48(%r10)
        sbbq	56(%r11), %rcx
        movq	64(%r10), %r8
        movq	%rcx, 56(%r10)
        sbbq	64(%r11), %r8
        movq	72(%r10), %rax
        movq	%r8, 64(%r10)
        sbbq	72(%r11), %rax
        movq	80(%r10), %rcx
        movq	%rax, 72(%r10)
        sbbq	80(%r11), %rcx
        movq	88(%r10), %r8
        movq	%rcx, 80(%r10)
        sbbq	88(%r11), %r8
        movq	96(%r10), %rax
        movq	%r8, 88(%r10)
        sbbq	96(%r11), %rax
        movq	104(%r10), %rcx
        movq	%rax, 96(%r10)
        sbbq	104(%r11), %rcx
        movq	112(%r10), %r8
        movq	%rcx, 104(%r10)
        sbbq	112(%r11), %r8
        movq	120(%r10), %rax
        movq	%r8, 112(%r10)
        sbbq	120(%r11), %rax
        movq	128(%r10), %rcx
        movq	%rax, 120(%r10)
        sbbq	128(%r11), %rcx
        movq	136(%r10), %r8
        movq	%rcx, 128(%r10)
        sbbq	136(%r11), %r8
        movq	144(%r10), %rax
        movq	%r8, 136(%r10)
        sbbq	144(%r11), %rax
        movq	152(%r10), %rcx
        movq	%rax, 144(%r10)
        sbbq	152(%r11), %rcx
        movq	160(%r10), %r8
        movq	%rcx, 152(%r10)
        sbbq	160(%r11), %r8
        movq	168(%r10), %rax
        movq	%r8, 160(%r10)
        sbbq	168(%r11), %rax
        movq	176(%r10), %rcx
        movq	%rax, 168(%r10)
        sbbq	176(%r11), %rcx
        movq	184(%r10), %r8
        movq	%rcx, 176(%r10)
        sbbq	184(%r11), %r8
        movq	%r8, 184(%r10)
        sbbq	$0x00, %r9
        movq	(%r10), %rax
        subq	(%rdi), %rax
        movq	8(%r10), %rcx
        movq	%rax, (%r10)
        sbbq	8(%rdi), %rcx
        movq	16(%r10), %r8
        movq	%rcx, 8(%r10)
        sbbq	16(%rdi), %r8
        movq	24(%r10), %rax
        movq	%r8, 16(%r10)
        sbbq	24(%rdi), %rax
        movq	32(%r10), %rcx
        movq	%rax, 24(%r10)
        sbbq	32(%rdi), %rcx
        movq	40(%r10), %r8
        movq	%rcx, 32(%r10)
        sbbq	40(%rdi), %r8
        movq	48(%r10), %rax
        movq	%r8, 40(%r10)
        sbbq	48(%rdi), %rax
        movq	56(%r10), %rcx
        movq	%rax, 48(%r10)
        sbbq	56(%rdi), %rcx
        movq	64(%r10), %r8
        movq	%rcx, 56(%r10)
        sbbq	64(%rdi), %r8
        movq	72(%r10), %rax
        movq	%r8, 64(%r10)
        sbbq	72(%rdi), %rax
        movq	80(%r10), %rcx
        movq	%rax, 72(%r10)
        sbbq	80(%rdi), %rcx
        movq	88(%r10), %r8
        movq	%rcx, 80(%r10)
        sbbq	88(%rdi), %r8
        movq	96(%r10), %rax
        movq	%r8, 88(%r10)
        sbbq	96(%rdi), %rax
        movq	104(%r10), %rcx
        movq	%rax, 96(%r10)
        sbbq	104(%rdi), %rcx
        movq	112(%r10), %r8
        movq	%rcx, 104(%r10)
        sbbq	112(%rdi), %r8
        movq	120(%r10), %rax
        movq	%r8, 112(%r10)
        sbbq	120(%rdi), %rax
        movq	128(%r10), %rcx
        movq	%rax, 120(%r10)
        sbbq	128(%rdi), %rcx
        movq	136(%r10), %r8
        movq	%rcx, 128(%r10)
        sbbq	136(%rdi), %r8
        movq	144(%r10), %rax
        movq	%r8, 136(%r10)
        sbbq	144(%rdi), %rax
        movq	152(%r10), %rcx
        movq	%rax, 144(%r10)
        sbbq	152(%rdi), %rcx
        movq	160(%r10), %r8
        movq	%rcx, 152(%r10)
        sbbq	160(%rdi), %r8
        movq	168(%r10), %rax
        movq	%r8, 160(%r10)
        sbbq	168(%rdi), %rax
        movq	176(%r10), %rcx
        movq	%rax, 168(%r10)
        sbbq	176(%rdi), %rcx
        movq	184(%r10), %r8
        movq	%rcx, 176(%r10)
        sbbq	184(%rdi), %r8
        movq	%r8, 184(%r10)
        sbbq	$0x00, %r9
        subq	$0x60, %r15
        # Add
        movq	(%r15), %rax
        addq	(%r10), %rax
        movq	8(%r15), %rcx
        movq	%rax, (%r15)
        adcq	8(%r10), %rcx
        movq	16(%r15), %r8
        movq	%rcx, 8(%r15)
        adcq	16(%r10), %r8
        movq	24(%r15), %rax
        movq	%r8, 16(%r15)
        adcq	24(%r10), %rax
        movq	32(%r15), %rcx
        movq	%rax, 24(%r15)
        adcq	32(%r10), %rcx
        movq	40(%r15), %r8
        movq	%rcx, 32(%r15)
        adcq	40(%r10), %r8
        movq	48(%r15), %rax
        movq	%r8, 40(%r15)
        adcq	48(%r10), %rax
        movq	56(%r15), %rcx
        movq	%rax, 48(%r15)
        adcq	56(%r10), %rcx
        movq	64(%r15), %r8
        movq	%rcx, 56(%r15)
        adcq	64(%r10), %r8
        movq	72(%r15), %rax
        movq	%r8, 64(%r15)
        adcq	72(%r10), %rax
        movq	80(%r15), %rcx
        movq	%rax, 72(%r15)
        adcq	80(%r10), %rcx
        movq	88(%r15), %r8
        movq	%rcx, 80(%r15)
        adcq	88(%r10), %r8
        movq	96(%r15), %rax
        movq	%r8, 88(%r15)
        adcq	96(%r10), %rax
        movq	104(%r15), %rcx
        movq	%rax, 96(%r15)
        adcq	104(%r10), %rcx
        movq	112(%r15), %r8
        movq	%rcx, 104(%r15)
        adcq	112(%r10), %r8
        movq	120(%r15), %rax
        movq	%r8, 112(%r15)
        adcq	120(%r10), %rax
        movq	128(%r15), %rcx
        movq	%rax, 120(%r15)
        adcq	128(%r10), %rcx
        movq	136(%r15), %r8
        movq	%rcx, 128(%r15)
        adcq	136(%r10), %r8
        movq	144(%r15), %rax
        movq	%r8, 136(%r15)
        adcq	144(%r10), %rax
        movq	152(%r15), %rcx
        movq	%rax, 144(%r15)
        adcq	152(%r10), %rcx
        movq	160(%r15), %r8
        movq	%rcx, 152(%r15)
        adcq	160(%r10), %r8
        movq	168(%r15), %rax
        movq	%r8, 160(%r15)
        adcq	168(%r10), %rax
        movq	176(%r15), %rcx
        movq	%rax, 168(%r15)
        adcq	176(%r10), %rcx
        movq	184(%r15), %r8
        movq	%rcx, 176(%r15)
        adcq	184(%r10), %r8
        movq	%r8, 184(%r15)
        adcq	$0x00, %r9
        movq	%r9, 288(%rdi)
        addq	$0x60, %r15
        # Add
        movq	(%r15), %rax
        addq	(%r11), %rax
        movq	8(%r15), %rcx
        movq	%rax, (%r15)
        adcq	8(%r11), %rcx
        movq	16(%r15), %r8
        movq	%rcx, 8(%r15)
        adcq	16(%r11), %r8
        movq	24(%r15), %rax
        movq	%r8, 16(%r15)
        adcq	24(%r11), %rax
        movq	32(%r15), %rcx
        movq	%rax, 24(%r15)
        adcq	32(%r11), %rcx
        movq	40(%r15), %r8
        movq	%rcx, 32(%r15)
        adcq	40(%r11), %r8
        movq	48(%r15), %rax
        movq	%r8, 40(%r15)
        adcq	48(%r11), %rax
        movq	56(%r15), %rcx
        movq	%rax, 48(%r15)
        adcq	56(%r11), %rcx
        movq	64(%r15), %r8
        movq	%rcx, 56(%r15)
        adcq	64(%r11), %r8
        movq	72(%r15), %rax
        movq	%r8, 64(%r15)
        adcq	72(%r11), %rax
        movq	80(%r15), %rcx
        movq	%rax, 72(%r15)
        adcq	80(%r11), %rcx
        movq	88(%r15), %r8
        movq	%rcx, 80(%r15)
        adcq	88(%r11), %r8
        movq	96(%r15), %rax
        movq	%r8, 88(%r15)
        adcq	96(%r11), %rax
        movq	%rax, 96(%r15)
        # Add to zero
        movq	104(%r11), %rax
        adcq	$0x00, %rax
        movq	112(%r11), %rcx
        movq	%rax, 104(%r15)
        adcq	$0x00, %rcx
        movq	120(%r11), %r8
        movq	%rcx, 112(%r15)
        adcq	$0x00, %r8
        movq	128(%r11), %rax
        movq	%r8, 120(%r15)
        adcq	$0x00, %rax
        movq	136(%r11), %rcx
        movq	%rax, 128(%r15)
        adcq	$0x00, %rcx
        movq	144(%r11), %r8
        movq	%rcx, 136(%r15)
        adcq	$0x00, %r8
        movq	152(%r11), %rax
        movq	%r8, 144(%r15)
        adcq	$0x00, %rax
        movq	160(%r11), %rcx
        movq	%rax, 152(%r15)
        adcq	$0x00, %rcx
        movq	168(%r11), %r8
        movq	%rcx, 160(%r15)
        adcq	$0x00, %r8
        movq	176(%r11), %rax
        movq	%r8, 168(%r15)
        adcq	$0x00, %rax
        movq	184(%r11), %rcx
        movq	%rax, 176(%r15)
        adcq	$0x00, %rcx
        movq	%rcx, 184(%r15)
        addq	$0x268, %rsp
        popq	%r15
        popq	%r14
        popq	%r13
        popq	%r12
        repz retq
#ifndef __APPLE__
.size	sp_3072_mul_avx2_24,.-sp_3072_mul_avx2_24
#endif /* __APPLE__ */
#endif /* HAVE_INTEL_AVX2 */
/* Sub b from a into a. (a -= b)
 *
 * a  A single precision integer and result.
 * b  A single precision integer.
 */
#ifndef __APPLE__
.text
.globl	sp_3072_sub_in_place_48
.type	sp_3072_sub_in_place_48,@function
.align	16
sp_3072_sub_in_place_48:
#else
.section	__TEXT,__text
.globl	_sp_3072_sub_in_place_48
.p2align	4
_sp_3072_sub_in_place_48:
#endif /* __APPLE__ */
        movq	(%rdi), %rdx
        subq	(%rsi), %rdx
        movq	8(%rdi), %rcx
        movq	%rdx, (%rdi)
        sbbq	8(%rsi), %rcx
        movq	16(%rdi), %rdx
        movq	%rcx, 8(%rdi)
        sbbq	16(%rsi), %rdx
        movq	24(%rdi), %rcx
        movq	%rdx, 16(%rdi)
        sbbq	24(%rsi), %rcx
        movq	32(%rdi), %rdx
        movq	%rcx, 24(%rdi)
        sbbq	32(%rsi), %rdx
        movq	40(%rdi), %rcx
        movq	%rdx, 32(%rdi)
        sbbq	40(%rsi), %rcx
        movq	48(%rdi), %rdx
        movq	%rcx, 40(%rdi)
        sbbq	48(%rsi), %rdx
        movq	56(%rdi), %rcx
        movq	%rdx, 48(%rdi)
        sbbq	56(%rsi), %rcx
        movq	64(%rdi), %rdx
        movq	%rcx, 56(%rdi)
        sbbq	64(%rsi), %rdx
        movq	72(%rdi), %rcx
        movq	%rdx, 64(%rdi)
        sbbq	72(%rsi), %rcx
        movq	80(%rdi), %rdx
        movq	%rcx, 72(%rdi)
        sbbq	80(%rsi), %rdx
        movq	88(%rdi), %rcx
        movq	%rdx, 80(%rdi)
        sbbq	88(%rsi), %rcx
        movq	96(%rdi), %rdx
        movq	%rcx, 88(%rdi)
        sbbq	96(%rsi), %rdx
        movq	104(%rdi), %rcx
        movq	%rdx, 96(%rdi)
        sbbq	104(%rsi), %rcx
        movq	112(%rdi), %rdx
        movq	%rcx, 104(%rdi)
        sbbq	112(%rsi), %rdx
        movq	120(%rdi), %rcx
        movq	%rdx, 112(%rdi)
        sbbq	120(%rsi), %rcx
        movq	128(%rdi), %rdx
        movq	%rcx, 120(%rdi)
        sbbq	128(%rsi), %rdx
        movq	136(%rdi), %rcx
        movq	%rdx, 128(%rdi)
        sbbq	136(%rsi), %rcx
        movq	144(%rdi), %rdx
        movq	%rcx, 136(%rdi)
        sbbq	144(%rsi), %rdx
        movq	152(%rdi), %rcx
        movq	%rdx, 144(%rdi)
        sbbq	152(%rsi), %rcx
        movq	160(%rdi), %rdx
        movq	%rcx, 152(%rdi)
        sbbq	160(%rsi), %rdx
        movq	168(%rdi), %rcx
        movq	%rdx, 160(%rdi)
        sbbq	168(%rsi), %rcx
        movq	176(%rdi), %rdx
        movq	%rcx, 168(%rdi)
        sbbq	176(%rsi), %rdx
        movq	184(%rdi), %rcx
        movq	%rdx, 176(%rdi)
        sbbq	184(%rsi), %rcx
        movq	192(%rdi), %rdx
        movq	%rcx, 184(%rdi)
        sbbq	192(%rsi), %rdx
        movq	200(%rdi), %rcx
        movq	%rdx, 192(%rdi)
        sbbq	200(%rsi), %rcx
        movq	208(%rdi), %rdx
        movq	%rcx, 200(%rdi)
        sbbq	208(%rsi), %rdx
        movq	216(%rdi), %rcx
        movq	%rdx, 208(%rdi)
        sbbq	216(%rsi), %rcx
        movq	224(%rdi), %rdx
        movq	%rcx, 216(%rdi)
        sbbq	224(%rsi), %rdx
        movq	232(%rdi), %rcx
        movq	%rdx, 224(%rdi)
        sbbq	232(%rsi), %rcx
        movq	240(%rdi), %rdx
        movq	%rcx, 232(%rdi)
        sbbq	240(%rsi), %rdx
        movq	248(%rdi), %rcx
        movq	%rdx, 240(%rdi)
        sbbq	248(%rsi), %rcx
        movq	256(%rdi), %rdx
        movq	%rcx, 248(%rdi)
        sbbq	256(%rsi), %rdx
        movq	264(%rdi), %rcx
        movq	%rdx, 256(%rdi)
        sbbq	264(%rsi), %rcx
        movq	272(%rdi), %rdx
        movq	%rcx, 264(%rdi)
        sbbq	272(%rsi), %rdx
        movq	280(%rdi), %rcx
        movq	%rdx, 272(%rdi)
        sbbq	280(%rsi), %rcx
        movq	288(%rdi), %rdx
        movq	%rcx, 280(%rdi)
        sbbq	288(%rsi), %rdx
        movq	296(%rdi), %rcx
        movq	%rdx, 288(%rdi)
        sbbq	296(%rsi), %rcx
        movq	304(%rdi), %rdx
        movq	%rcx, 296(%rdi)
        sbbq	304(%rsi), %rdx
        movq	312(%rdi), %rcx
        movq	%rdx, 304(%rdi)
        sbbq	312(%rsi), %rcx
        movq	320(%rdi), %rdx
        movq	%rcx, 312(%rdi)
        sbbq	320(%rsi), %rdx
        movq	328(%rdi), %rcx
        movq	%rdx, 320(%rdi)
        sbbq	328(%rsi), %rcx
        movq	336(%rdi), %rdx
        movq	%rcx, 328(%rdi)
        sbbq	336(%rsi), %rdx
        movq	344(%rdi), %rcx
        movq	%rdx, 336(%rdi)
        sbbq	344(%rsi), %rcx
        movq	352(%rdi), %rdx
        movq	%rcx, 344(%rdi)
        sbbq	352(%rsi), %rdx
        movq	360(%rdi), %rcx
        movq	%rdx, 352(%rdi)
        sbbq	360(%rsi), %rcx
        movq	368(%rdi), %rdx
        movq	%rcx, 360(%rdi)
        sbbq	368(%rsi), %rdx
        movq	376(%rdi), %rcx
        movq	%rdx, 368(%rdi)
        sbbq	376(%rsi), %rcx
        movq	%rcx, 376(%rdi)
        sbbq	%rax, %rax
        repz retq
#ifndef __APPLE__
.size	sp_3072_sub_in_place_48,.-sp_3072_sub_in_place_48
#endif /* __APPLE__ */
/* Add b to a into r. (r = a + b)
 *
 * r  A single precision integer.
 * a  A single precision integer.
 * b  A single precision integer.
 */
#ifndef __APPLE__
.text
.globl	sp_3072_add_48
.type	sp_3072_add_48,@function
.align	16
sp_3072_add_48:
#else
.section	__TEXT,__text
.globl	_sp_3072_add_48
.p2align	4
_sp_3072_add_48:
#endif /* __APPLE__ */
        # Add
        movq	(%rsi), %rcx
        xorq	%rax, %rax
        addq	(%rdx), %rcx
        movq	8(%rsi), %r8
        movq	%rcx, (%rdi)
        adcq	8(%rdx), %r8
        movq	16(%rsi), %rcx
        movq	%r8, 8(%rdi)
        adcq	16(%rdx), %rcx
        movq	24(%rsi), %r8
        movq	%rcx, 16(%rdi)
        adcq	24(%rdx), %r8
        movq	32(%rsi), %rcx
        movq	%r8, 24(%rdi)
        adcq	32(%rdx), %rcx
        movq	40(%rsi), %r8
        movq	%rcx, 32(%rdi)
        adcq	40(%rdx), %r8
        movq	48(%rsi), %rcx
        movq	%r8, 40(%rdi)
        adcq	48(%rdx), %rcx
        movq	56(%rsi), %r8
        movq	%rcx, 48(%rdi)
        adcq	56(%rdx), %r8
        movq	64(%rsi), %rcx
        movq	%r8, 56(%rdi)
        adcq	64(%rdx), %rcx
        movq	72(%rsi), %r8
        movq	%rcx, 64(%rdi)
        adcq	72(%rdx), %r8
        movq	80(%rsi), %rcx
        movq	%r8, 72(%rdi)
        adcq	80(%rdx), %rcx
        movq	88(%rsi), %r8
        movq	%rcx, 80(%rdi)
        adcq	88(%rdx), %r8
        movq	96(%rsi), %rcx
        movq	%r8, 88(%rdi)
        adcq	96(%rdx), %rcx
        movq	104(%rsi), %r8
        movq	%rcx, 96(%rdi)
        adcq	104(%rdx), %r8
        movq	112(%rsi), %rcx
        movq	%r8, 104(%rdi)
        adcq	112(%rdx), %rcx
        movq	120(%rsi), %r8
        movq	%rcx, 112(%rdi)
        adcq	120(%rdx), %r8
        movq	128(%rsi), %rcx
        movq	%r8, 120(%rdi)
        adcq	128(%rdx), %rcx
        movq	136(%rsi), %r8
        movq	%rcx, 128(%rdi)
        adcq	136(%rdx), %r8
        movq	144(%rsi), %rcx
        movq	%r8, 136(%rdi)
        adcq	144(%rdx), %rcx
        movq	152(%rsi), %r8
        movq	%rcx, 144(%rdi)
        adcq	152(%rdx), %r8
        movq	160(%rsi), %rcx
        movq	%r8, 152(%rdi)
        adcq	160(%rdx), %rcx
        movq	168(%rsi), %r8
        movq	%rcx, 160(%rdi)
        adcq	168(%rdx), %r8
        movq	176(%rsi), %rcx
        movq	%r8, 168(%rdi)
        adcq	176(%rdx), %rcx
        movq	184(%rsi), %r8
        movq	%rcx, 176(%rdi)
        adcq	184(%rdx), %r8
        movq	192(%rsi), %rcx
        movq	%r8, 184(%rdi)
        adcq	192(%rdx), %rcx
        movq	200(%rsi), %r8
        movq	%rcx, 192(%rdi)
        adcq	200(%rdx), %r8
        movq	208(%rsi), %rcx
        movq	%r8, 200(%rdi)
        adcq	208(%rdx), %rcx
        movq	216(%rsi), %r8
        movq	%rcx, 208(%rdi)
        adcq	216(%rdx), %r8
        movq	224(%rsi), %rcx
        movq	%r8, 216(%rdi)
        adcq	224(%rdx), %rcx
        movq	232(%rsi), %r8
        movq	%rcx, 224(%rdi)
        adcq	232(%rdx), %r8
        movq	240(%rsi), %rcx
        movq	%r8, 232(%rdi)
        adcq	240(%rdx), %rcx
        movq	248(%rsi), %r8
        movq	%rcx, 240(%rdi)
        adcq	248(%rdx), %r8
        movq	256(%rsi), %rcx
        movq	%r8, 248(%rdi)
        adcq	256(%rdx), %rcx
        movq	264(%rsi), %r8
        movq	%rcx, 256(%rdi)
        adcq	264(%rdx), %r8
        movq	272(%rsi), %rcx
        movq	%r8, 264(%rdi)
        adcq	272(%rdx), %rcx
        movq	280(%rsi), %r8
        movq	%rcx, 272(%rdi)
        adcq	280(%rdx), %r8
        movq	288(%rsi), %rcx
        movq	%r8, 280(%rdi)
        adcq	288(%rdx), %rcx
        movq	296(%rsi), %r8
        movq	%rcx, 288(%rdi)
        adcq	296(%rdx), %r8
        movq	304(%rsi), %rcx
        movq	%r8, 296(%rdi)
        adcq	304(%rdx), %rcx
        movq	312(%rsi), %r8
        movq	%rcx, 304(%rdi)
        adcq	312(%rdx), %r8
        movq	320(%rsi), %rcx
        movq	%r8, 312(%rdi)
        adcq	320(%rdx), %rcx
        movq	328(%rsi), %r8
        movq	%rcx, 320(%rdi)
        adcq	328(%rdx), %r8
        movq	336(%rsi), %rcx
        movq	%r8, 328(%rdi)
        adcq	336(%rdx), %rcx
        movq	344(%rsi), %r8
        movq	%rcx, 336(%rdi)
        adcq	344(%rdx), %r8
        movq	352(%rsi), %rcx
        movq	%r8, 344(%rdi)
        adcq	352(%rdx), %rcx
        movq	360(%rsi), %r8
        movq	%rcx, 352(%rdi)
        adcq	360(%rdx), %r8
        movq	368(%rsi), %rcx
        movq	%r8, 360(%rdi)
        adcq	368(%rdx), %rcx
        movq	376(%rsi), %r8
        movq	%rcx, 368(%rdi)
        adcq	376(%rdx), %r8
        movq	%r8, 376(%rdi)
        adcq	$0x00, %rax
        repz retq
#ifndef __APPLE__
.size	sp_3072_add_48,.-sp_3072_add_48
#endif /* __APPLE__ */
/* Multiply a and b into r. (r = a * b)
 *
 * r  A single precision integer.
 * a  A single precision integer.
 * b  A single precision integer.
 */
#ifndef __APPLE__
.text
.globl	sp_3072_mul_48
.type	sp_3072_mul_48,@function
.align	16
sp_3072_mul_48:
#else
.section	__TEXT,__text
.globl	_sp_3072_mul_48
.p2align	4
_sp_3072_mul_48:
#endif /* __APPLE__ */
        pushq	%r12
        pushq	%r13
        pushq	%r14
        pushq	%r15
        subq	$0x4a8, %rsp
        movq	%rdi, 1152(%rsp)
        movq	%rsi, 1160(%rsp)
        movq	%rdx, 1168(%rsp)
        leaq	768(%rsp), %r10
        leaq	192(%rsi), %r12
        # Add
        movq	(%rsi), %rax
        xorq	%r13, %r13
        addq	(%r12), %rax
        movq	8(%rsi), %rcx
        movq	%rax, (%r10)
        adcq	8(%r12), %rcx
        movq	16(%rsi), %r8
        movq	%rcx, 8(%r10)
        adcq	16(%r12), %r8
        movq	24(%rsi), %rax
        movq	%r8, 16(%r10)
        adcq	24(%r12), %rax
        movq	32(%rsi), %rcx
        movq	%rax, 24(%r10)
        adcq	32(%r12), %rcx
        movq	40(%rsi), %r8
        movq	%rcx, 32(%r10)
        adcq	40(%r12), %r8
        movq	48(%rsi), %rax
        movq	%r8, 40(%r10)
        adcq	48(%r12), %rax
        movq	56(%rsi), %rcx
        movq	%rax, 48(%r10)
        adcq	56(%r12), %rcx
        movq	64(%rsi), %r8
        movq	%rcx, 56(%r10)
        adcq	64(%r12), %r8
        movq	72(%rsi), %rax
        movq	%r8, 64(%r10)
        adcq	72(%r12), %rax
        movq	80(%rsi), %rcx
        movq	%rax, 72(%r10)
        adcq	80(%r12), %rcx
        movq	88(%rsi), %r8
        movq	%rcx, 80(%r10)
        adcq	88(%r12), %r8
        movq	96(%rsi), %rax
        movq	%r8, 88(%r10)
        adcq	96(%r12), %rax
        movq	104(%rsi), %rcx
        movq	%rax, 96(%r10)
        adcq	104(%r12), %rcx
        movq	112(%rsi), %r8
        movq	%rcx, 104(%r10)
        adcq	112(%r12), %r8
        movq	120(%rsi), %rax
        movq	%r8, 112(%r10)
        adcq	120(%r12), %rax
        movq	128(%rsi), %rcx
        movq	%rax, 120(%r10)
        adcq	128(%r12), %rcx
        movq	136(%rsi), %r8
        movq	%rcx, 128(%r10)
        adcq	136(%r12), %r8
        movq	144(%rsi), %rax
        movq	%r8, 136(%r10)
        adcq	144(%r12), %rax
        movq	152(%rsi), %rcx
        movq	%rax, 144(%r10)
        adcq	152(%r12), %rcx
        movq	160(%rsi), %r8
        movq	%rcx, 152(%r10)
        adcq	160(%r12), %r8
        movq	168(%rsi), %rax
        movq	%r8, 160(%r10)
        adcq	168(%r12), %rax
        movq	176(%rsi), %rcx
        movq	%rax, 168(%r10)
        adcq	176(%r12), %rcx
        movq	184(%rsi), %r8
        movq	%rcx, 176(%r10)
        adcq	184(%r12), %r8
        movq	%r8, 184(%r10)
        adcq	$0x00, %r13
        movq	%r13, 1176(%rsp)
        leaq	960(%rsp), %r11
        leaq	192(%rdx), %r12
        # Add
        movq	(%rdx), %rax
        xorq	%r14, %r14
        addq	(%r12), %rax
        movq	8(%rdx), %rcx
        movq	%rax, (%r11)
        adcq	8(%r12), %rcx
        movq	16(%rdx), %r8
        movq	%rcx, 8(%r11)
        adcq	16(%r12), %r8
        movq	24(%rdx), %rax
        movq	%r8, 16(%r11)
        adcq	24(%r12), %rax
        movq	32(%rdx), %rcx
        movq	%rax, 24(%r11)
        adcq	32(%r12), %rcx
        movq	40(%rdx), %r8
        movq	%rcx, 32(%r11)
        adcq	40(%r12), %r8
        movq	48(%rdx), %rax
        movq	%r8, 40(%r11)
        adcq	48(%r12), %rax
        movq	56(%rdx), %rcx
        movq	%rax, 48(%r11)
        adcq	56(%r12), %rcx
        movq	64(%rdx), %r8
        movq	%rcx, 56(%r11)
        adcq	64(%r12), %r8
        movq	72(%rdx), %rax
        movq	%r8, 64(%r11)
        adcq	72(%r12), %rax
        movq	80(%rdx), %rcx
        movq	%rax, 72(%r11)
        adcq	80(%r12), %rcx
        movq	88(%rdx), %r8
        movq	%rcx, 80(%r11)
        adcq	88(%r12), %r8
        movq	96(%rdx), %rax
        movq	%r8, 88(%r11)
        adcq	96(%r12), %rax
        movq	104(%rdx), %rcx
        movq	%rax, 96(%r11)
        adcq	104(%r12), %rcx
        movq	112(%rdx), %r8
        movq	%rcx, 104(%r11)
        adcq	112(%r12), %r8
        movq	120(%rdx), %rax
        movq	%r8, 112(%r11)
        adcq	120(%r12), %rax
        movq	128(%rdx), %rcx
        movq	%rax, 120(%r11)
        adcq	128(%r12), %rcx
        movq	136(%rdx), %r8
        movq	%rcx, 128(%r11)
        adcq	136(%r12), %r8
        movq	144(%rdx), %rax
        movq	%r8, 136(%r11)
        adcq	144(%r12), %rax
        movq	152(%rdx), %rcx
        movq	%rax, 144(%r11)
        adcq	152(%r12), %rcx
        movq	160(%rdx), %r8
        movq	%rcx, 152(%r11)
        adcq	160(%r12), %r8
        movq	168(%rdx), %rax
        movq	%r8, 160(%r11)
        adcq	168(%r12), %rax
        movq	176(%rdx), %rcx
        movq	%rax, 168(%r11)
        adcq	176(%r12), %rcx
        movq	184(%rdx), %r8
        movq	%rcx, 176(%r11)
        adcq	184(%r12), %r8
        movq	%r8, 184(%r11)
        adcq	$0x00, %r14
        movq	%r14, 1184(%rsp)
        movq	%r11, %rdx
        movq	%r10, %rsi
        movq	%rsp, %rdi
#ifndef __APPLE__
        callq	sp_3072_mul_24@plt
#else
        callq	_sp_3072_mul_24
#endif /* __APPLE__ */
        movq	1168(%rsp), %rdx
        movq	1160(%rsp), %rsi
        leaq	384(%rsp), %rdi
        addq	$0xc0, %rdx
        addq	$0xc0, %rsi
#ifndef __APPLE__
        callq	sp_3072_mul_24@plt
#else
        callq	_sp_3072_mul_24
#endif /* __APPLE__ */
        movq	1168(%rsp), %rdx
        movq	1160(%rsp), %rsi
        movq	1152(%rsp), %rdi
#ifndef __APPLE__
        callq	sp_3072_mul_24@plt
#else
        callq	_sp_3072_mul_24
#endif /* __APPLE__ */
#ifdef _WIN64
        movq	1168(%rsp), %rdx
        movq	1160(%rsp), %rsi
        movq	1152(%rsp), %rdi
#endif /* _WIN64 */
        movq	1176(%rsp), %r13
        movq	1184(%rsp), %r14
        movq	1152(%rsp), %r15
        movq	%r13, %r9
        leaq	768(%rsp), %r10
        leaq	960(%rsp), %r11
        andq	%r14, %r9
        negq	%r13
        negq	%r14
        addq	$0x180, %r15
        movq	(%r10), %rax
        movq	(%r11), %rcx
        andq	%r14, %rax
        andq	%r13, %rcx
        movq	%rax, (%r10)
        movq	%rcx, (%r11)
        movq	8(%r10), %rax
        movq	8(%r11), %rcx
        andq	%r14, %rax
        andq	%r13, %rcx
        movq	%rax, 8(%r10)
        movq	%rcx, 8(%r11)
        movq	16(%r10), %rax
        movq	16(%r11), %rcx
        andq	%r14, %rax
        andq	%r13, %rcx
        movq	%rax, 16(%r10)
        movq	%rcx, 16(%r11)
        movq	24(%r10), %rax
        movq	24(%r11), %rcx
        andq	%r14, %rax
        andq	%r13, %rcx
        movq	%rax, 24(%r10)
        movq	%rcx, 24(%r11)
        movq	32(%r10), %rax
        movq	32(%r11), %rcx
        andq	%r14, %rax
        andq	%r13, %rcx
        movq	%rax, 32(%r10)
        movq	%rcx, 32(%r11)
        movq	40(%r10), %rax
        movq	40(%r11), %rcx
        andq	%r14, %rax
        andq	%r13, %rcx
        movq	%rax, 40(%r10)
        movq	%rcx, 40(%r11)
        movq	48(%r10), %rax
        movq	48(%r11), %rcx
        andq	%r14, %rax
        andq	%r13, %rcx
        movq	%rax, 48(%r10)
        movq	%rcx, 48(%r11)
        movq	56(%r10), %rax
        movq	56(%r11), %rcx
        andq	%r14, %rax
        andq	%r13, %rcx
        movq	%rax, 56(%r10)
        movq	%rcx, 56(%r11)
        movq	64(%r10), %rax
        movq	64(%r11), %rcx
        andq	%r14, %rax
        andq	%r13, %rcx
        movq	%rax, 64(%r10)
        movq	%rcx, 64(%r11)
        movq	72(%r10), %rax
        movq	72(%r11), %rcx
        andq	%r14, %rax
        andq	%r13, %rcx
        movq	%rax, 72(%r10)
        movq	%rcx, 72(%r11)
        movq	80(%r10), %rax
        movq	80(%r11), %rcx
        andq	%r14, %rax
        andq	%r13, %rcx
        movq	%rax, 80(%r10)
        movq	%rcx, 80(%r11)
        movq	88(%r10), %rax
        movq	88(%r11), %rcx
        andq	%r14, %rax
        andq	%r13, %rcx
        movq	%rax, 88(%r10)
        movq	%rcx, 88(%r11)
        movq	96(%r10), %rax
        movq	96(%r11), %rcx
        andq	%r14, %rax
        andq	%r13, %rcx
        movq	%rax, 96(%r10)
        movq	%rcx, 96(%r11)
        movq	104(%r10), %rax
        movq	104(%r11), %rcx
        andq	%r14, %rax
        andq	%r13, %rcx
        movq	%rax, 104(%r10)
        movq	%rcx, 104(%r11)
        movq	112(%r10), %rax
        movq	112(%r11), %rcx
        andq	%r14, %rax
        andq	%r13, %rcx
        movq	%rax, 112(%r10)
        movq	%rcx, 112(%r11)
        movq	120(%r10), %rax
        movq	120(%r11), %rcx
        andq	%r14, %rax
        andq	%r13, %rcx
        movq	%rax, 120(%r10)
        movq	%rcx, 120(%r11)
        movq	128(%r10), %rax
        movq	128(%r11), %rcx
        andq	%r14, %rax
        andq	%r13, %rcx
        movq	%rax, 128(%r10)
        movq	%rcx, 128(%r11)
        movq	136(%r10), %rax
        movq	136(%r11), %rcx
        andq	%r14, %rax
        andq	%r13, %rcx
        movq	%rax, 136(%r10)
        movq	%rcx, 136(%r11)
        movq	144(%r10), %rax
        movq	144(%r11), %rcx
        andq	%r14, %rax
        andq	%r13, %rcx
        movq	%rax, 144(%r10)
        movq	%rcx, 144(%r11)
        movq	152(%r10), %rax
        movq	152(%r11), %rcx
        andq	%r14, %rax
        andq	%r13, %rcx
        movq	%rax, 152(%r10)
        movq	%rcx, 152(%r11)
        movq	160(%r10), %rax
        movq	160(%r11), %rcx
        andq	%r14, %rax
        andq	%r13, %rcx
        movq	%rax, 160(%r10)
        movq	%rcx, 160(%r11)
        movq	168(%r10), %rax
        movq	168(%r11), %rcx
        andq	%r14, %rax
        andq	%r13, %rcx
        movq	%rax, 168(%r10)
        movq	%rcx, 168(%r11)
        movq	176(%r10), %rax
        movq	176(%r11), %rcx
        andq	%r14, %rax
        andq	%r13, %rcx
        movq	%rax, 176(%r10)
        movq	%rcx, 176(%r11)
        movq	184(%r10), %rax
        movq	184(%r11), %rcx
        andq	%r14, %rax
        andq	%r13, %rcx
        movq	%rax, 184(%r10)
        movq	%rcx, 184(%r11)
        movq	(%r10), %rax
        addq	(%r11), %rax
        movq	8(%r10), %rcx
        movq	%rax, (%r15)
        adcq	8(%r11), %rcx
        movq	16(%r10), %r8
        movq	%rcx, 8(%r15)
        adcq	16(%r11), %r8
        movq	24(%r10), %rax
        movq	%r8, 16(%r15)
        adcq	24(%r11), %rax
        movq	32(%r10), %rcx
        movq	%rax, 24(%r15)
        adcq	32(%r11), %rcx
        movq	40(%r10), %r8
        movq	%rcx, 32(%r15)
        adcq	40(%r11), %r8
        movq	48(%r10), %rax
        movq	%r8, 40(%r15)
        adcq	48(%r11), %rax
        movq	56(%r10), %rcx
        movq	%rax, 48(%r15)
        adcq	56(%r11), %rcx
        movq	64(%r10), %r8
        movq	%rcx, 56(%r15)
        adcq	64(%r11), %r8
        movq	72(%r10), %rax
        movq	%r8, 64(%r15)
        adcq	72(%r11), %rax
        movq	80(%r10), %rcx
        movq	%rax, 72(%r15)
        adcq	80(%r11), %rcx
        movq	88(%r10), %r8
        movq	%rcx, 80(%r15)
        adcq	88(%r11), %r8
        movq	96(%r10), %rax
        movq	%r8, 88(%r15)
        adcq	96(%r11), %rax
        movq	104(%r10), %rcx
        movq	%rax, 96(%r15)
        adcq	104(%r11), %rcx
        movq	112(%r10), %r8
        movq	%rcx, 104(%r15)
        adcq	112(%r11), %r8
        movq	120(%r10), %rax
        movq	%r8, 112(%r15)
        adcq	120(%r11), %rax
        movq	128(%r10), %rcx
        movq	%rax, 120(%r15)
        adcq	128(%r11), %rcx
        movq	136(%r10), %r8
        movq	%rcx, 128(%r15)
        adcq	136(%r11), %r8
        movq	144(%r10), %rax
        movq	%r8, 136(%r15)
        adcq	144(%r11), %rax
        movq	152(%r10), %rcx
        movq	%rax, 144(%r15)
        adcq	152(%r11), %rcx
        movq	160(%r10), %r8
        movq	%rcx, 152(%r15)
        adcq	160(%r11), %r8
        movq	168(%r10), %rax
        movq	%r8, 160(%r15)
        adcq	168(%r11), %rax
        movq	176(%r10), %rcx
        movq	%rax, 168(%r15)
        adcq	176(%r11), %rcx
        movq	184(%r10), %r8
        movq	%rcx, 176(%r15)
        adcq	184(%r11), %r8
        movq	%r8, 184(%r15)
        adcq	$0x00, %r9
        leaq	384(%rsp), %r11
        movq	%rsp, %r10
        movq	(%r10), %rax
        subq	(%r11), %rax
        movq	8(%r10), %rcx
        movq	%rax, (%r10)
        sbbq	8(%r11), %rcx
        movq	16(%r10), %r8
        movq	%rcx, 8(%r10)
        sbbq	16(%r11), %r8
        movq	24(%r10), %rax
        movq	%r8, 16(%r10)
        sbbq	24(%r11), %rax
        movq	32(%r10), %rcx
        movq	%rax, 24(%r10)
        sbbq	32(%r11), %rcx
        movq	40(%r10), %r8
        movq	%rcx, 32(%r10)
        sbbq	40(%r11), %r8
        movq	48(%r10), %rax
        movq	%r8, 40(%r10)
        sbbq	48(%r11), %rax
        movq	56(%r10), %rcx
        movq	%rax, 48(%r10)
        sbbq	56(%r11), %rcx
        movq	64(%r10), %r8
        movq	%rcx, 56(%r10)
        sbbq	64(%r11), %r8
        movq	72(%r10), %rax
        movq	%r8, 64(%r10)
        sbbq	72(%r11), %rax
        movq	80(%r10), %rcx
        movq	%rax, 72(%r10)
        sbbq	80(%r11), %rcx
        movq	88(%r10), %r8
        movq	%rcx, 80(%r10)
        sbbq	88(%r11), %r8
        movq	96(%r10), %rax
        movq	%r8, 88(%r10)
        sbbq	96(%r11), %rax
        movq	104(%r10), %rcx
        movq	%rax, 96(%r10)
        sbbq	104(%r11), %rcx
        movq	112(%r10), %r8
        movq	%rcx, 104(%r10)
        sbbq	112(%r11), %r8
        movq	120(%r10), %rax
        movq	%r8, 112(%r10)
        sbbq	120(%r11), %rax
        movq	128(%r10), %rcx
        movq	%rax, 120(%r10)
        sbbq	128(%r11), %rcx
        movq	136(%r10), %r8
        movq	%rcx, 128(%r10)
        sbbq	136(%r11), %r8
        movq	144(%r10), %rax
        movq	%r8, 136(%r10)
        sbbq	144(%r11), %rax
        movq	152(%r10), %rcx
        movq	%rax, 144(%r10)
        sbbq	152(%r11), %rcx
        movq	160(%r10), %r8
        movq	%rcx, 152(%r10)
        sbbq	160(%r11), %r8
        movq	168(%r10), %rax
        movq	%r8, 160(%r10)
        sbbq	168(%r11), %rax
        movq	176(%r10), %rcx
        movq	%rax, 168(%r10)
        sbbq	176(%r11), %rcx
        movq	184(%r10), %r8
        movq	%rcx, 176(%r10)
        sbbq	184(%r11), %r8
        movq	192(%r10), %rax
        movq	%r8, 184(%r10)
        sbbq	192(%r11), %rax
        movq	200(%r10), %rcx
        movq	%rax, 192(%r10)
        sbbq	200(%r11), %rcx
        movq	208(%r10), %r8
        movq	%rcx, 200(%r10)
        sbbq	208(%r11), %r8
        movq	216(%r10), %rax
        movq	%r8, 208(%r10)
        sbbq	216(%r11), %rax
        movq	224(%r10), %rcx
        movq	%rax, 216(%r10)
        sbbq	224(%r11), %rcx
        movq	232(%r10), %r8
        movq	%rcx, 224(%r10)
        sbbq	232(%r11), %r8
        movq	240(%r10), %rax
        movq	%r8, 232(%r10)
        sbbq	240(%r11), %rax
        movq	248(%r10), %rcx
        movq	%rax, 240(%r10)
        sbbq	248(%r11), %rcx
        movq	256(%r10), %r8
        movq	%rcx, 248(%r10)
        sbbq	256(%r11), %r8
        movq	264(%r10), %rax
        movq	%r8, 256(%r10)
        sbbq	264(%r11), %rax
        movq	272(%r10), %rcx
        movq	%rax, 264(%r10)
        sbbq	272(%r11), %rcx
        movq	280(%r10), %r8
        movq	%rcx, 272(%r10)
        sbbq	280(%r11), %r8
        movq	288(%r10), %rax
        movq	%r8, 280(%r10)
        sbbq	288(%r11), %rax
        movq	296(%r10), %rcx
        movq	%rax, 288(%r10)
        sbbq	296(%r11), %rcx
        movq	304(%r10), %r8
        movq	%rcx, 296(%r10)
        sbbq	304(%r11), %r8
        movq	312(%r10), %rax
        movq	%r8, 304(%r10)
        sbbq	312(%r11), %rax
        movq	320(%r10), %rcx
        movq	%rax, 312(%r10)
        sbbq	320(%r11), %rcx
        movq	328(%r10), %r8
        movq	%rcx, 320(%r10)
        sbbq	328(%r11), %r8
        movq	336(%r10), %rax
        movq	%r8, 328(%r10)
        sbbq	336(%r11), %rax
        movq	344(%r10), %rcx
        movq	%rax, 336(%r10)
        sbbq	344(%r11), %rcx
        movq	352(%r10), %r8
        movq	%rcx, 344(%r10)
        sbbq	352(%r11), %r8
        movq	360(%r10), %rax
        movq	%r8, 352(%r10)
        sbbq	360(%r11), %rax
        movq	368(%r10), %rcx
        movq	%rax, 360(%r10)
        sbbq	368(%r11), %rcx
        movq	376(%r10), %r8
        movq	%rcx, 368(%r10)
        sbbq	376(%r11), %r8
        movq	%r8, 376(%r10)
        sbbq	$0x00, %r9
        movq	(%r10), %rax
        subq	(%rdi), %rax
        movq	8(%r10), %rcx
        movq	%rax, (%r10)
        sbbq	8(%rdi), %rcx
        movq	16(%r10), %r8
        movq	%rcx, 8(%r10)
        sbbq	16(%rdi), %r8
        movq	24(%r10), %rax
        movq	%r8, 16(%r10)
        sbbq	24(%rdi), %rax
        movq	32(%r10), %rcx
        movq	%rax, 24(%r10)
        sbbq	32(%rdi), %rcx
        movq	40(%r10), %r8
        movq	%rcx, 32(%r10)
        sbbq	40(%rdi), %r8
        movq	48(%r10), %rax
        movq	%r8, 40(%r10)
        sbbq	48(%rdi), %rax
        movq	56(%r10), %rcx
        movq	%rax, 48(%r10)
        sbbq	56(%rdi), %rcx
        movq	64(%r10), %r8
        movq	%rcx, 56(%r10)
        sbbq	64(%rdi), %r8
        movq	72(%r10), %rax
        movq	%r8, 64(%r10)
        sbbq	72(%rdi), %rax
        movq	80(%r10), %rcx
        movq	%rax, 72(%r10)
        sbbq	80(%rdi), %rcx
        movq	88(%r10), %r8
        movq	%rcx, 80(%r10)
        sbbq	88(%rdi), %r8
        movq	96(%r10), %rax
        movq	%r8, 88(%r10)
        sbbq	96(%rdi), %rax
        movq	104(%r10), %rcx
        movq	%rax, 96(%r10)
        sbbq	104(%rdi), %rcx
        movq	112(%r10), %r8
        movq	%rcx, 104(%r10)
        sbbq	112(%rdi), %r8
        movq	120(%r10), %rax
        movq	%r8, 112(%r10)
        sbbq	120(%rdi), %rax
        movq	128(%r10), %rcx
        movq	%rax, 120(%r10)
        sbbq	128(%rdi), %rcx
        movq	136(%r10), %r8
        movq	%rcx, 128(%r10)
        sbbq	136(%rdi), %r8
        movq	144(%r10), %rax
        movq	%r8, 136(%r10)
        sbbq	144(%rdi), %rax
        movq	152(%r10), %rcx
        movq	%rax, 144(%r10)
        sbbq	152(%rdi), %rcx
        movq	160(%r10), %r8
        movq	%rcx, 152(%r10)
        sbbq	160(%rdi), %r8
        movq	168(%r10), %rax
        movq	%r8, 160(%r10)
        sbbq	168(%rdi), %rax
        movq	176(%r10), %rcx
        movq	%rax, 168(%r10)
        sbbq	176(%rdi), %rcx
        movq	184(%r10), %r8
        movq	%rcx, 176(%r10)
        sbbq	184(%rdi), %r8
        movq	192(%r10), %rax
        movq	%r8, 184(%r10)
        sbbq	192(%rdi), %rax
        movq	200(%r10), %rcx
        movq	%rax, 192(%r10)
        sbbq	200(%rdi), %rcx
        movq	208(%r10), %r8
        movq	%rcx, 200(%r10)
        sbbq	208(%rdi), %r8
        movq	216(%r10), %rax
        movq	%r8, 208(%r10)
        sbbq	216(%rdi), %rax
        movq	224(%r10), %rcx
        movq	%rax, 216(%r10)
        sbbq	224(%rdi), %rcx
        movq	232(%r10), %r8
        movq	%rcx, 224(%r10)
        sbbq	232(%rdi), %r8
        movq	240(%r10), %rax
        movq	%r8, 232(%r10)
        sbbq	240(%rdi), %rax
        movq	248(%r10), %rcx
        movq	%rax, 240(%r10)
        sbbq	248(%rdi), %rcx
        movq	256(%r10), %r8
        movq	%rcx, 248(%r10)
        sbbq	256(%rdi), %r8
        movq	264(%r10), %rax
        movq	%r8, 256(%r10)
        sbbq	264(%rdi), %rax
        movq	272(%r10), %rcx
        movq	%rax, 264(%r10)
        sbbq	272(%rdi), %rcx
        movq	280(%r10), %r8
        movq	%rcx, 272(%r10)
        sbbq	280(%rdi), %r8
        movq	288(%r10), %rax
        movq	%r8, 280(%r10)
        sbbq	288(%rdi), %rax
        movq	296(%r10), %rcx
        movq	%rax, 288(%r10)
        sbbq	296(%rdi), %rcx
        movq	304(%r10), %r8
        movq	%rcx, 296(%r10)
        sbbq	304(%rdi), %r8
        movq	312(%r10), %rax
        movq	%r8, 304(%r10)
        sbbq	312(%rdi), %rax
        movq	320(%r10), %rcx
        movq	%rax, 312(%r10)
        sbbq	320(%rdi), %rcx
        movq	328(%r10), %r8
        movq	%rcx, 320(%r10)
        sbbq	328(%rdi), %r8
        movq	336(%r10), %rax
        movq	%r8, 328(%r10)
        sbbq	336(%rdi), %rax
        movq	344(%r10), %rcx
        movq	%rax, 336(%r10)
        sbbq	344(%rdi), %rcx
        movq	352(%r10), %r8
        movq	%rcx, 344(%r10)
        sbbq	352(%rdi), %r8
        movq	360(%r10), %rax
        movq	%r8, 352(%r10)
        sbbq	360(%rdi), %rax
        movq	368(%r10), %rcx
        movq	%rax, 360(%r10)
        sbbq	368(%rdi), %rcx
        movq	376(%r10), %r8
        movq	%rcx, 368(%r10)
        sbbq	376(%rdi), %r8
        movq	%r8, 376(%r10)
        sbbq	$0x00, %r9
        subq	$0xc0, %r15
        # Add
        movq	(%r15), %rax
        addq	(%r10), %rax
        movq	8(%r15), %rcx
        movq	%rax, (%r15)
        adcq	8(%r10), %rcx
        movq	16(%r15), %r8
        movq	%rcx, 8(%r15)
        adcq	16(%r10), %r8
        movq	24(%r15), %rax
        movq	%r8, 16(%r15)
        adcq	24(%r10), %rax
        movq	32(%r15), %rcx
        movq	%rax, 24(%r15)
        adcq	32(%r10), %rcx
        movq	40(%r15), %r8
        movq	%rcx, 32(%r15)
        adcq	40(%r10), %r8
        movq	48(%r15), %rax
        movq	%r8, 40(%r15)
        adcq	48(%r10), %rax
        movq	56(%r15), %rcx
        movq	%rax, 48(%r15)
        adcq	56(%r10), %rcx
        movq	64(%r15), %r8
        movq	%rcx, 56(%r15)
        adcq	64(%r10), %r8
        movq	72(%r15), %rax
        movq	%r8, 64(%r15)
        adcq	72(%r10), %rax
        movq	80(%r15), %rcx
        movq	%rax, 72(%r15)
        adcq	80(%r10), %rcx
        movq	88(%r15), %r8
        movq	%rcx, 80(%r15)
        adcq	88(%r10), %r8
        movq	96(%r15), %rax
        movq	%r8, 88(%r15)
        adcq	96(%r10), %rax
        movq	104(%r15), %rcx
        movq	%rax, 96(%r15)
        adcq	104(%r10), %rcx
        movq	112(%r15), %r8
        movq	%rcx, 104(%r15)
        adcq	112(%r10), %r8
        movq	120(%r15), %rax
        movq	%r8, 112(%r15)
        adcq	120(%r10), %rax
        movq	128(%r15), %rcx
        movq	%rax, 120(%r15)
        adcq	128(%r10), %rcx
        movq	136(%r15), %r8
        movq	%rcx, 128(%r15)
        adcq	136(%r10), %r8
        movq	144(%r15), %rax
        movq	%r8, 136(%r15)
        adcq	144(%r10), %rax
        movq	152(%r15), %rcx
        movq	%rax, 144(%r15)
        adcq	152(%r10), %rcx
        movq	160(%r15), %r8
        movq	%rcx, 152(%r15)
        adcq	160(%r10), %r8
        movq	168(%r15), %rax
        movq	%r8, 160(%r15)
        adcq	168(%r10), %rax
        movq	176(%r15), %rcx
        movq	%rax, 168(%r15)
        adcq	176(%r10), %rcx
        movq	184(%r15), %r8
        movq	%rcx, 176(%r15)
        adcq	184(%r10), %r8
        movq	192(%r15), %rax
        movq	%r8, 184(%r15)
        adcq	192(%r10), %rax
        movq	200(%r15), %rcx
        movq	%rax, 192(%r15)
        adcq	200(%r10), %rcx
        movq	208(%r15), %r8
        movq	%rcx, 200(%r15)
        adcq	208(%r10), %r8
        movq	216(%r15), %rax
        movq	%r8, 208(%r15)
        adcq	216(%r10), %rax
        movq	224(%r15), %rcx
        movq	%rax, 216(%r15)
        adcq	224(%r10), %rcx
        movq	232(%r15), %r8
        movq	%rcx, 224(%r15)
        adcq	232(%r10), %r8
        movq	240(%r15), %rax
        movq	%r8, 232(%r15)
        adcq	240(%r10), %rax
        movq	248(%r15), %rcx
        movq	%rax, 240(%r15)
        adcq	248(%r10), %rcx
        movq	256(%r15), %r8
        movq	%rcx, 248(%r15)
        adcq	256(%r10), %r8
        movq	264(%r15), %rax
        movq	%r8, 256(%r15)
        adcq	264(%r10), %rax
        movq	272(%r15), %rcx
        movq	%rax, 264(%r15)
        adcq	272(%r10), %rcx
        movq	280(%r15), %r8
        movq	%rcx, 272(%r15)
        adcq	280(%r10), %r8
        movq	288(%r15), %rax
        movq	%r8, 280(%r15)
        adcq	288(%r10), %rax
        movq	296(%r15), %rcx
        movq	%rax, 288(%r15)
        adcq	296(%r10), %rcx
        movq	304(%r15), %r8
        movq	%rcx, 296(%r15)
        adcq	304(%r10), %r8
        movq	312(%r15), %rax
        movq	%r8, 304(%r15)
        adcq	312(%r10), %rax
        movq	320(%r15), %rcx
        movq	%rax, 312(%r15)
        adcq	320(%r10), %rcx
        movq	328(%r15), %r8
        movq	%rcx, 320(%r15)
        adcq	328(%r10), %r8
        movq	336(%r15), %rax
        movq	%r8, 328(%r15)
        adcq	336(%r10), %rax
        movq	344(%r15), %rcx
        movq	%rax, 336(%r15)
        adcq	344(%r10), %rcx
        movq	352(%r15), %r8
        movq	%rcx, 344(%r15)
        adcq	352(%r10), %r8
        movq	360(%r15), %rax
        movq	%r8, 352(%r15)
        adcq	360(%r10), %rax
        movq	368(%r15), %rcx
        movq	%rax, 360(%r15)
        adcq	368(%r10), %rcx
        movq	376(%r15), %r8
        movq	%rcx, 368(%r15)
        adcq	376(%r10), %r8
        movq	%r8, 376(%r15)
        adcq	$0x00, %r9
        movq	%r9, 576(%rdi)
        addq	$0xc0, %r15
        # Add
        movq	(%r15), %rax
        addq	(%r11), %rax
        movq	8(%r15), %rcx
        movq	%rax, (%r15)
        adcq	8(%r11), %rcx
        movq	16(%r15), %r8
        movq	%rcx, 8(%r15)
        adcq	16(%r11), %r8
        movq	24(%r15), %rax
        movq	%r8, 16(%r15)
        adcq	24(%r11), %rax
        movq	32(%r15), %rcx
        movq	%rax, 24(%r15)
        adcq	32(%r11), %rcx
        movq	40(%r15), %r8
        movq	%rcx, 32(%r15)
        adcq	40(%r11), %r8
        movq	48(%r15), %rax
        movq	%r8, 40(%r15)
        adcq	48(%r11), %rax
        movq	56(%r15), %rcx
        movq	%rax, 48(%r15)
        adcq	56(%r11), %rcx
        movq	64(%r15), %r8
        movq	%rcx, 56(%r15)
        adcq	64(%r11), %r8
        movq	72(%r15), %rax
        movq	%r8, 64(%r15)
        adcq	72(%r11), %rax
        movq	80(%r15), %rcx
        movq	%rax, 72(%r15)
        adcq	80(%r11), %rcx
        movq	88(%r15), %r8
        movq	%rcx, 80(%r15)
        adcq	88(%r11), %r8
        movq	96(%r15), %rax
        movq	%r8, 88(%r15)
        adcq	96(%r11), %rax
        movq	104(%r15), %rcx
        movq	%rax, 96(%r15)
        adcq	104(%r11), %rcx
        movq	112(%r15), %r8
        movq	%rcx, 104(%r15)
        adcq	112(%r11), %r8
        movq	120(%r15), %rax
        movq	%r8, 112(%r15)
        adcq	120(%r11), %rax
        movq	128(%r15), %rcx
        movq	%rax, 120(%r15)
        adcq	128(%r11), %rcx
        movq	136(%r15), %r8
        movq	%rcx, 128(%r15)
        adcq	136(%r11), %r8
        movq	144(%r15), %rax
        movq	%r8, 136(%r15)
        adcq	144(%r11), %rax
        movq	152(%r15), %rcx
        movq	%rax, 144(%r15)
        adcq	152(%r11), %rcx
        movq	160(%r15), %r8
        movq	%rcx, 152(%r15)
        adcq	160(%r11), %r8
        movq	168(%r15), %rax
        movq	%r8, 160(%r15)
        adcq	168(%r11), %rax
        movq	176(%r15), %rcx
        movq	%rax, 168(%r15)
        adcq	176(%r11), %rcx
        movq	184(%r15), %r8
        movq	%rcx, 176(%r15)
        adcq	184(%r11), %r8
        movq	192(%r15), %rax
        movq	%r8, 184(%r15)
        adcq	192(%r11), %rax
        movq	%rax, 192(%r15)
        # Add to zero
        movq	200(%r11), %rax
        adcq	$0x00, %rax
        movq	208(%r11), %rcx
        movq	%rax, 200(%r15)
        adcq	$0x00, %rcx
        movq	216(%r11), %r8
        movq	%rcx, 208(%r15)
        adcq	$0x00, %r8
        movq	224(%r11), %rax
        movq	%r8, 216(%r15)
        adcq	$0x00, %rax
        movq	232(%r11), %rcx
        movq	%rax, 224(%r15)
        adcq	$0x00, %rcx
        movq	240(%r11), %r8
        movq	%rcx, 232(%r15)
        adcq	$0x00, %r8
        movq	248(%r11), %rax
        movq	%r8, 240(%r15)
        adcq	$0x00, %rax
        movq	256(%r11), %rcx
        movq	%rax, 248(%r15)
        adcq	$0x00, %rcx
        movq	264(%r11), %r8
        movq	%rcx, 256(%r15)
        adcq	$0x00, %r8
        movq	272(%r11), %rax
        movq	%r8, 264(%r15)
        adcq	$0x00, %rax
        movq	280(%r11), %rcx
        movq	%rax, 272(%r15)
        adcq	$0x00, %rcx
        movq	288(%r11), %r8
        movq	%rcx, 280(%r15)
        adcq	$0x00, %r8
        movq	296(%r11), %rax
        movq	%r8, 288(%r15)
        adcq	$0x00, %rax
        movq	304(%r11), %rcx
        movq	%rax, 296(%r15)
        adcq	$0x00, %rcx
        movq	312(%r11), %r8
        movq	%rcx, 304(%r15)
        adcq	$0x00, %r8
        movq	320(%r11), %rax
        movq	%r8, 312(%r15)
        adcq	$0x00, %rax
        movq	328(%r11), %rcx
        movq	%rax, 320(%r15)
        adcq	$0x00, %rcx
        movq	336(%r11), %r8
        movq	%rcx, 328(%r15)
        adcq	$0x00, %r8
        movq	344(%r11), %rax
        movq	%r8, 336(%r15)
        adcq	$0x00, %rax
        movq	352(%r11), %rcx
        movq	%rax, 344(%r15)
        adcq	$0x00, %rcx
        movq	360(%r11), %r8
        movq	%rcx, 352(%r15)
        adcq	$0x00, %r8
        movq	368(%r11), %rax
        movq	%r8, 360(%r15)
        adcq	$0x00, %rax
        movq	376(%r11), %rcx
        movq	%rax, 368(%r15)
        adcq	$0x00, %rcx
        movq	%rcx, 376(%r15)
        addq	$0x4a8, %rsp
        popq	%r15
        popq	%r14
        popq	%r13
        popq	%r12
        repz retq
#ifndef __APPLE__
.size	sp_3072_mul_48,.-sp_3072_mul_48
#endif /* __APPLE__ */
#ifdef HAVE_INTEL_AVX2
/* Multiply a and b into r. (r = a * b)
 *
 * r  A single precision integer.
 * a  A single precision integer.
 * b  A single precision integer.
 */
#ifndef __APPLE__
.text
.globl	sp_3072_mul_avx2_48
.type	sp_3072_mul_avx2_48,@function
.align	16
sp_3072_mul_avx2_48:
#else
.section	__TEXT,__text
.globl	_sp_3072_mul_avx2_48
.p2align	4
_sp_3072_mul_avx2_48:
#endif /* __APPLE__ */
        pushq	%r12
        pushq	%r13
        pushq	%r14
        pushq	%r15
        subq	$0x4a8, %rsp
        movq	%rdi, 1152(%rsp)
        movq	%rsi, 1160(%rsp)
        movq	%rdx, 1168(%rsp)
        leaq	768(%rsp), %r10
        leaq	192(%rsi), %r12
        # Add
        movq	(%rsi), %rax
        xorq	%r13, %r13
        addq	(%r12), %rax
        movq	8(%rsi), %rcx
        movq	%rax, (%r10)
        adcq	8(%r12), %rcx
        movq	16(%rsi), %r8
        movq	%rcx, 8(%r10)
        adcq	16(%r12), %r8
        movq	24(%rsi), %rax
        movq	%r8, 16(%r10)
        adcq	24(%r12), %rax
        movq	32(%rsi), %rcx
        movq	%rax, 24(%r10)
        adcq	32(%r12), %rcx
        movq	40(%rsi), %r8
        movq	%rcx, 32(%r10)
        adcq	40(%r12), %r8
        movq	48(%rsi), %rax
        movq	%r8, 40(%r10)
        adcq	48(%r12), %rax
        movq	56(%rsi), %rcx
        movq	%rax, 48(%r10)
        adcq	56(%r12), %rcx
        movq	64(%rsi), %r8
        movq	%rcx, 56(%r10)
        adcq	64(%r12), %r8
        movq	72(%rsi), %rax
        movq	%r8, 64(%r10)
        adcq	72(%r12), %rax
        movq	80(%rsi), %rcx
        movq	%rax, 72(%r10)
        adcq	80(%r12), %rcx
        movq	88(%rsi), %r8
        movq	%rcx, 80(%r10)
        adcq	88(%r12), %r8
        movq	96(%rsi), %rax
        movq	%r8, 88(%r10)
        adcq	96(%r12), %rax
        movq	104(%rsi), %rcx
        movq	%rax, 96(%r10)
        adcq	104(%r12), %rcx
        movq	112(%rsi), %r8
        movq	%rcx, 104(%r10)
        adcq	112(%r12), %r8
        movq	120(%rsi), %rax
        movq	%r8, 112(%r10)
        adcq	120(%r12), %rax
        movq	128(%rsi), %rcx
        movq	%rax, 120(%r10)
        adcq	128(%r12), %rcx
        movq	136(%rsi), %r8
        movq	%rcx, 128(%r10)
        adcq	136(%r12), %r8
        movq	144(%rsi), %rax
        movq	%r8, 136(%r10)
        adcq	144(%r12), %rax
        movq	152(%rsi), %rcx
        movq	%rax, 144(%r10)
        adcq	152(%r12), %rcx
        movq	160(%rsi), %r8
        movq	%rcx, 152(%r10)
        adcq	160(%r12), %r8
        movq	168(%rsi), %rax
        movq	%r8, 160(%r10)
        adcq	168(%r12), %rax
        movq	176(%rsi), %rcx
        movq	%rax, 168(%r10)
        adcq	176(%r12), %rcx
        movq	184(%rsi), %r8
        movq	%rcx, 176(%r10)
        adcq	184(%r12), %r8
        movq	%r8, 184(%r10)
        adcq	$0x00, %r13
        movq	%r13, 1176(%rsp)
        leaq	960(%rsp), %r11
        leaq	192(%rdx), %r12
        # Add
        movq	(%rdx), %rax
        xorq	%r14, %r14
        addq	(%r12), %rax
        movq	8(%rdx), %rcx
        movq	%rax, (%r11)
        adcq	8(%r12), %rcx
        movq	16(%rdx), %r8
        movq	%rcx, 8(%r11)
        adcq	16(%r12), %r8
        movq	24(%rdx), %rax
        movq	%r8, 16(%r11)
        adcq	24(%r12), %rax
        movq	32(%rdx), %rcx
        movq	%rax, 24(%r11)
        adcq	32(%r12), %rcx
        movq	40(%rdx), %r8
        movq	%rcx, 32(%r11)
        adcq	40(%r12), %r8
        movq	48(%rdx), %rax
        movq	%r8, 40(%r11)
        adcq	48(%r12), %rax
        movq	56(%rdx), %rcx
        movq	%rax, 48(%r11)
        adcq	56(%r12), %rcx
        movq	64(%rdx), %r8
        movq	%rcx, 56(%r11)
        adcq	64(%r12), %r8
        movq	72(%rdx), %rax
        movq	%r8, 64(%r11)
        adcq	72(%r12), %rax
        movq	80(%rdx), %rcx
        movq	%rax, 72(%r11)
        adcq	80(%r12), %rcx
        movq	88(%rdx), %r8
        movq	%rcx, 80(%r11)
        adcq	88(%r12), %r8
        movq	96(%rdx), %rax
        movq	%r8, 88(%r11)
        adcq	96(%r12), %rax
        movq	104(%rdx), %rcx
        movq	%rax, 96(%r11)
        adcq	104(%r12), %rcx
        movq	112(%rdx), %r8
        movq	%rcx, 104(%r11)
        adcq	112(%r12), %r8
        movq	120(%rdx), %rax
        movq	%r8, 112(%r11)
        adcq	120(%r12), %rax
        movq	128(%rdx), %rcx
        movq	%rax, 120(%r11)
        adcq	128(%r12), %rcx
        movq	136(%rdx), %r8
        movq	%rcx, 128(%r11)
        adcq	136(%r12), %r8
        movq	144(%rdx), %rax
        movq	%r8, 136(%r11)
        adcq	144(%r12), %rax
        movq	152(%rdx), %rcx
        movq	%rax, 144(%r11)
        adcq	152(%r12), %rcx
        movq	160(%rdx), %r8
        movq	%rcx, 152(%r11)
        adcq	160(%r12), %r8
        movq	168(%rdx), %rax
        movq	%r8, 160(%r11)
        adcq	168(%r12), %rax
        movq	176(%rdx), %rcx
        movq	%rax, 168(%r11)
        adcq	176(%r12), %rcx
        movq	184(%rdx), %r8
        movq	%rcx, 176(%r11)
        adcq	184(%r12), %r8
        movq	%r8, 184(%r11)
        adcq	$0x00, %r14
        movq	%r14, 1184(%rsp)
        movq	%r11, %rdx
        movq	%r10, %rsi
        movq	%rsp, %rdi
#ifndef __APPLE__
        callq	sp_3072_mul_avx2_24@plt
#else
        callq	_sp_3072_mul_avx2_24
#endif /* __APPLE__ */
        movq	1168(%rsp), %rdx
        movq	1160(%rsp), %rsi
        leaq	384(%rsp), %rdi
        addq	$0xc0, %rdx
        addq	$0xc0, %rsi
#ifndef __APPLE__
        callq	sp_3072_mul_avx2_24@plt
#else
        callq	_sp_3072_mul_avx2_24
#endif /* __APPLE__ */
        movq	1168(%rsp), %rdx
        movq	1160(%rsp), %rsi
        movq	1152(%rsp), %rdi
#ifndef __APPLE__
        callq	sp_3072_mul_avx2_24@plt
#else
        callq	_sp_3072_mul_avx2_24
#endif /* __APPLE__ */
#ifdef _WIN64
        movq	1168(%rsp), %rdx
        movq	1160(%rsp), %rsi
        movq	1152(%rsp), %rdi
#endif /* _WIN64 */
        movq	1176(%rsp), %r13
        movq	1184(%rsp), %r14
        movq	1152(%rsp), %r15
        movq	%r13, %r9
        leaq	768(%rsp), %r10
        leaq	960(%rsp), %r11
        andq	%r14, %r9
        negq	%r13
        negq	%r14
        addq	$0x180, %r15
        movq	(%r10), %rax
        movq	(%r11), %rcx
        pextq	%r14, %rax, %rax
        pextq	%r13, %rcx, %rcx
        addq	%rcx, %rax
        movq	8(%r10), %rcx
        movq	8(%r11), %r8
        pextq	%r14, %rcx, %rcx
        pextq	%r13, %r8, %r8
        movq	%rax, (%r15)
        adcq	%r8, %rcx
        movq	16(%r10), %r8
        movq	16(%r11), %rax
        pextq	%r14, %r8, %r8
        pextq	%r13, %rax, %rax
        movq	%rcx, 8(%r15)
        adcq	%rax, %r8
        movq	24(%r10), %rax
        movq	24(%r11), %rcx
        pextq	%r14, %rax, %rax
        pextq	%r13, %rcx, %rcx
        movq	%r8, 16(%r15)
        adcq	%rcx, %rax
        movq	32(%r10), %rcx
        movq	32(%r11), %r8
        pextq	%r14, %rcx, %rcx
        pextq	%r13, %r8, %r8
        movq	%rax, 24(%r15)
        adcq	%r8, %rcx
        movq	40(%r10), %r8
        movq	40(%r11), %rax
        pextq	%r14, %r8, %r8
        pextq	%r13, %rax, %rax
        movq	%rcx, 32(%r15)
        adcq	%rax, %r8
        movq	48(%r10), %rax
        movq	48(%r11), %rcx
        pextq	%r14, %rax, %rax
        pextq	%r13, %rcx, %rcx
        movq	%r8, 40(%r15)
        adcq	%rcx, %rax
        movq	56(%r10), %rcx
        movq	56(%r11), %r8
        pextq	%r14, %rcx, %rcx
        pextq	%r13, %r8, %r8
        movq	%rax, 48(%r15)
        adcq	%r8, %rcx
        movq	64(%r10), %r8
        movq	64(%r11), %rax
        pextq	%r14, %r8, %r8
        pextq	%r13, %rax, %rax
        movq	%rcx, 56(%r15)
        adcq	%rax, %r8
        movq	72(%r10), %rax
        movq	72(%r11), %rcx
        pextq	%r14, %rax, %rax
        pextq	%r13, %rcx, %rcx
        movq	%r8, 64(%r15)
        adcq	%rcx, %rax
        movq	80(%r10), %rcx
        movq	80(%r11), %r8
        pextq	%r14, %rcx, %rcx
        pextq	%r13, %r8, %r8
        movq	%rax, 72(%r15)
        adcq	%r8, %rcx
        movq	88(%r10), %r8
        movq	88(%r11), %rax
        pextq	%r14, %r8, %r8
        pextq	%r13, %rax, %rax
        movq	%rcx, 80(%r15)
        adcq	%rax, %r8
        movq	96(%r10), %rax
        movq	96(%r11), %rcx
        pextq	%r14, %rax, %rax
        pextq	%r13, %rcx, %rcx
        movq	%r8, 88(%r15)
        adcq	%rcx, %rax
        movq	104(%r10), %rcx
        movq	104(%r11), %r8
        pextq	%r14, %rcx, %rcx
        pextq	%r13, %r8, %r8
        movq	%rax, 96(%r15)
        adcq	%r8, %rcx
        movq	112(%r10), %r8
        movq	112(%r11), %rax
        pextq	%r14, %r8, %r8
        pextq	%r13, %rax, %rax
        movq	%rcx, 104(%r15)
        adcq	%rax, %r8
        movq	120(%r10), %rax
        movq	120(%r11), %rcx
        pextq	%r14, %rax, %rax
        pextq	%r13, %rcx, %rcx
        movq	%r8, 112(%r15)
        adcq	%rcx, %rax
        movq	128(%r10), %rcx
        movq	128(%r11), %r8
        pextq	%r14, %rcx, %rcx
        pextq	%r13, %r8, %r8
        movq	%rax, 120(%r15)
        adcq	%r8, %rcx
        movq	136(%r10), %r8
        movq	136(%r11), %rax
        pextq	%r14, %r8, %r8
        pextq	%r13, %rax, %rax
        movq	%rcx, 128(%r15)
        adcq	%rax, %r8
        movq	144(%r10), %rax
        movq	144(%r11), %rcx
        pextq	%r14, %rax, %rax
        pextq	%r13, %rcx, %rcx
        movq	%r8, 136(%r15)
        adcq	%rcx, %rax
        movq	152(%r10), %rcx
        movq	152(%r11), %r8
        pextq	%r14, %rcx, %rcx
        pextq	%r13, %r8, %r8
        movq	%rax, 144(%r15)
        adcq	%r8, %rcx
        movq	160(%r10), %r8
        movq	160(%r11), %rax
        pextq	%r14, %r8, %r8
        pextq	%r13, %rax, %rax
        movq	%rcx, 152(%r15)
        adcq	%rax, %r8
        movq	168(%r10), %rax
        movq	168(%r11), %rcx
        pextq	%r14, %rax, %rax
        pextq	%r13, %rcx, %rcx
        movq	%r8, 160(%r15)
        adcq	%rcx, %rax
        movq	176(%r10), %rcx
        movq	176(%r11), %r8
        pextq	%r14, %rcx, %rcx
        pextq	%r13, %r8, %r8
        movq	%rax, 168(%r15)
        adcq	%r8, %rcx
        movq	184(%r10), %r8
        movq	184(%r11), %rax
        pextq	%r14, %r8, %r8
        pextq	%r13, %rax, %rax
        movq	%rcx, 176(%r15)
        adcq	%rax, %r8
        movq	%r8, 184(%r15)
        adcq	$0x00, %r9
        leaq	384(%rsp), %r11
        movq	%rsp, %r10
        movq	(%r10), %rax
        subq	(%r11), %rax
        movq	8(%r10), %rcx
        movq	%rax, (%r10)
        sbbq	8(%r11), %rcx
        movq	16(%r10), %r8
        movq	%rcx, 8(%r10)
        sbbq	16(%r11), %r8
        movq	24(%r10), %rax
        movq	%r8, 16(%r10)
        sbbq	24(%r11), %rax
        movq	32(%r10), %rcx
        movq	%rax, 24(%r10)
        sbbq	32(%r11), %rcx
        movq	40(%r10), %r8
        movq	%rcx, 32(%r10)
        sbbq	40(%r11), %r8
        movq	48(%r10), %rax
        movq	%r8, 40(%r10)
        sbbq	48(%r11), %rax
        movq	56(%r10), %rcx
        movq	%rax, 48(%r10)
        sbbq	56(%r11), %rcx
        movq	64(%r10), %r8
        movq	%rcx, 56(%r10)
        sbbq	64(%r11), %r8
        movq	72(%r10), %rax
        movq	%r8, 64(%r10)
        sbbq	72(%r11), %rax
        movq	80(%r10), %rcx
        movq	%rax, 72(%r10)
        sbbq	80(%r11), %rcx
        movq	88(%r10), %r8
        movq	%rcx, 80(%r10)
        sbbq	88(%r11), %r8
        movq	96(%r10), %rax
        movq	%r8, 88(%r10)
        sbbq	96(%r11), %rax
        movq	104(%r10), %rcx
        movq	%rax, 96(%r10)
        sbbq	104(%r11), %rcx
        movq	112(%r10), %r8
        movq	%rcx, 104(%r10)
        sbbq	112(%r11), %r8
        movq	120(%r10), %rax
        movq	%r8, 112(%r10)
        sbbq	120(%r11), %rax
        movq	128(%r10), %rcx
        movq	%rax, 120(%r10)
        sbbq	128(%r11), %rcx
        movq	136(%r10), %r8
        movq	%rcx, 128(%r10)
        sbbq	136(%r11), %r8
        movq	144(%r10), %rax
        movq	%r8, 136(%r10)
        sbbq	144(%r11), %rax
        movq	152(%r10), %rcx
        movq	%rax, 144(%r10)
        sbbq	152(%r11), %rcx
        movq	160(%r10), %r8
        movq	%rcx, 152(%r10)
        sbbq	160(%r11), %r8
        movq	168(%r10), %rax
        movq	%r8, 160(%r10)
        sbbq	168(%r11), %rax
        movq	176(%r10), %rcx
        movq	%rax, 168(%r10)
        sbbq	176(%r11), %rcx
        movq	184(%r10), %r8
        movq	%rcx, 176(%r10)
        sbbq	184(%r11), %r8
        movq	192(%r10), %rax
        movq	%r8, 184(%r10)
        sbbq	192(%r11), %rax
        movq	200(%r10), %rcx
        movq	%rax, 192(%r10)
        sbbq	200(%r11), %rcx
        movq	208(%r10), %r8
        movq	%rcx, 200(%r10)
        sbbq	208(%r11), %r8
        movq	216(%r10), %rax
        movq	%r8, 208(%r10)
        sbbq	216(%r11), %rax
        movq	224(%r10), %rcx
        movq	%rax, 216(%r10)
        sbbq	224(%r11), %rcx
        movq	232(%r10), %r8
        movq	%rcx, 224(%r10)
        sbbq	232(%r11), %r8
        movq	240(%r10), %rax
        movq	%r8, 232(%r10)
        sbbq	240(%r11), %rax
        movq	248(%r10), %rcx
        movq	%rax, 240(%r10)
        sbbq	248(%r11), %rcx
        movq	256(%r10), %r8
        movq	%rcx, 248(%r10)
        sbbq	256(%r11), %r8
        movq	264(%r10), %rax
        movq	%r8, 256(%r10)
        sbbq	264(%r11), %rax
        movq	272(%r10), %rcx
        movq	%rax, 264(%r10)
        sbbq	272(%r11), %rcx
        movq	280(%r10), %r8
        movq	%rcx, 272(%r10)
        sbbq	280(%r11), %r8
        movq	288(%r10), %rax
        movq	%r8, 280(%r10)
        sbbq	288(%r11), %rax
        movq	296(%r10), %rcx
        movq	%rax, 288(%r10)
        sbbq	296(%r11), %rcx
        movq	304(%r10), %r8
        movq	%rcx, 296(%r10)
        sbbq	304(%r11), %r8
        movq	312(%r10), %rax
        movq	%r8, 304(%r10)
        sbbq	312(%r11), %rax
        movq	320(%r10), %rcx
        movq	%rax, 312(%r10)
        sbbq	320(%r11), %rcx
        movq	328(%r10), %r8
        movq	%rcx, 320(%r10)
        sbbq	328(%r11), %r8
        movq	336(%r10), %rax
        movq	%r8, 328(%r10)
        sbbq	336(%r11), %rax
        movq	344(%r10), %rcx
        movq	%rax, 336(%r10)
        sbbq	344(%r11), %rcx
        movq	352(%r10), %r8
        movq	%rcx, 344(%r10)
        sbbq	352(%r11), %r8
        movq	360(%r10), %rax
        movq	%r8, 352(%r10)
        sbbq	360(%r11), %rax
        movq	368(%r10), %rcx
        movq	%rax, 360(%r10)
        sbbq	368(%r11), %rcx
        movq	376(%r10), %r8
        movq	%rcx, 368(%r10)
        sbbq	376(%r11), %r8
        movq	%r8, 376(%r10)
        sbbq	$0x00, %r9
        movq	(%r10), %rax
        subq	(%rdi), %rax
        movq	8(%r10), %rcx
        movq	%rax, (%r10)
        sbbq	8(%rdi), %rcx
        movq	16(%r10), %r8
        movq	%rcx, 8(%r10)
        sbbq	16(%rdi), %r8
        movq	24(%r10), %rax
        movq	%r8, 16(%r10)
        sbbq	24(%rdi), %rax
        movq	32(%r10), %rcx
        movq	%rax, 24(%r10)
        sbbq	32(%rdi), %rcx
        movq	40(%r10), %r8
        movq	%rcx, 32(%r10)
        sbbq	40(%rdi), %r8
        movq	48(%r10), %rax
        movq	%r8, 40(%r10)
        sbbq	48(%rdi), %rax
        movq	56(%r10), %rcx
        movq	%rax, 48(%r10)
        sbbq	56(%rdi), %rcx
        movq	64(%r10), %r8
        movq	%rcx, 56(%r10)
        sbbq	64(%rdi), %r8
        movq	72(%r10), %rax
        movq	%r8, 64(%r10)
        sbbq	72(%rdi), %rax
        movq	80(%r10), %rcx
        movq	%rax, 72(%r10)
        sbbq	80(%rdi), %rcx
        movq	88(%r10), %r8
        movq	%rcx, 80(%r10)
        sbbq	88(%rdi), %r8
        movq	96(%r10), %rax
        movq	%r8, 88(%r10)
        sbbq	96(%rdi), %rax
        movq	104(%r10), %rcx
        movq	%rax, 96(%r10)
        sbbq	104(%rdi), %rcx
        movq	112(%r10), %r8
        movq	%rcx, 104(%r10)
        sbbq	112(%rdi), %r8
        movq	120(%r10), %rax
        movq	%r8, 112(%r10)
        sbbq	120(%rdi), %rax
        movq	128(%r10), %rcx
        movq	%rax, 120(%r10)
        sbbq	128(%rdi), %rcx
        movq	136(%r10), %r8
        movq	%rcx, 128(%r10)
        sbbq	136(%rdi), %r8
        movq	144(%r10), %rax
        movq	%r8, 136(%r10)
        sbbq	144(%rdi), %rax
        movq	152(%r10), %rcx
        movq	%rax, 144(%r10)
        sbbq	152(%rdi), %rcx
        movq	160(%r10), %r8
        movq	%rcx, 152(%r10)
        sbbq	160(%rdi), %r8
        movq	168(%r10), %rax
        movq	%r8, 160(%r10)
        sbbq	168(%rdi), %rax
        movq	176(%r10), %rcx
        movq	%rax, 168(%r10)
        sbbq	176(%rdi), %rcx
        movq	184(%r10), %r8
        movq	%rcx, 176(%r10)
        sbbq	184(%rdi), %r8
        movq	192(%r10), %rax
        movq	%r8, 184(%r10)
        sbbq	192(%rdi), %rax
        movq	200(%r10), %rcx
        movq	%rax, 192(%r10)
        sbbq	200(%rdi), %rcx
        movq	208(%r10), %r8
        movq	%rcx, 200(%r10)
        sbbq	208(%rdi), %r8
        movq	216(%r10), %rax
        movq	%r8, 208(%r10)
        sbbq	216(%rdi), %rax
        movq	224(%r10), %rcx
        movq	%rax, 216(%r10)
        sbbq	224(%rdi), %rcx
        movq	232(%r10), %r8
        movq	%rcx, 224(%r10)
        sbbq	232(%rdi), %r8
        movq	240(%r10), %rax
        movq	%r8, 232(%r10)
        sbbq	240(%rdi), %rax
        movq	248(%r10), %rcx
        movq	%rax, 240(%r10)
        sbbq	248(%rdi), %rcx
        movq	256(%r10), %r8
        movq	%rcx, 248(%r10)
        sbbq	256(%rdi), %r8
        movq	264(%r10), %rax
        movq	%r8, 256(%r10)
        sbbq	264(%rdi), %rax
        movq	272(%r10), %rcx
        movq	%rax, 264(%r10)
        sbbq	272(%rdi), %rcx
        movq	280(%r10), %r8
        movq	%rcx, 272(%r10)
        sbbq	280(%rdi), %r8
        movq	288(%r10), %rax
        movq	%r8, 280(%r10)
        sbbq	288(%rdi), %rax
        movq	296(%r10), %rcx
        movq	%rax, 288(%r10)
        sbbq	296(%rdi), %rcx
        movq	304(%r10), %r8
        movq	%rcx, 296(%r10)
        sbbq	304(%rdi), %r8
        movq	312(%r10), %rax
        movq	%r8, 304(%r10)
        sbbq	312(%rdi), %rax
        movq	320(%r10), %rcx
        movq	%rax, 312(%r10)
        sbbq	320(%rdi), %rcx
        movq	328(%r10), %r8
        movq	%rcx, 320(%r10)
        sbbq	328(%rdi), %r8
        movq	336(%r10), %rax
        movq	%r8, 328(%r10)
        sbbq	336(%rdi), %rax
        movq	344(%r10), %rcx
        movq	%rax, 336(%r10)
        sbbq	344(%rdi), %rcx
        movq	352(%r10), %r8
        movq	%rcx, 344(%r10)
        sbbq	352(%rdi), %r8
        movq	360(%r10), %rax
        movq	%r8, 352(%r10)
        sbbq	360(%rdi), %rax
        movq	368(%r10), %rcx
        movq	%rax, 360(%r10)
        sbbq	368(%rdi), %rcx
        movq	376(%r10), %r8
        movq	%rcx, 368(%r10)
        sbbq	376(%rdi), %r8
        movq	%r8, 376(%r10)
        sbbq	$0x00, %r9
        subq	$0xc0, %r15
        # Add
        movq	(%r15), %rax
        addq	(%r10), %rax
        movq	8(%r15), %rcx
        movq	%rax, (%r15)
        adcq	8(%r10), %rcx
        movq	16(%r15), %r8
        movq	%rcx, 8(%r15)
        adcq	16(%r10), %r8
        movq	24(%r15), %rax
        movq	%r8, 16(%r15)
        adcq	24(%r10), %rax
        movq	32(%r15), %rcx
        movq	%rax, 24(%r15)
        adcq	32(%r10), %rcx
        movq	40(%r15), %r8
        movq	%rcx, 32(%r15)
        adcq	40(%r10), %r8
        movq	48(%r15), %rax
        movq	%r8, 40(%r15)
        adcq	48(%r10), %rax
        movq	56(%r15), %rcx
        movq	%rax, 48(%r15)
        adcq	56(%r10), %rcx
        movq	64(%r15), %r8
        movq	%rcx, 56(%r15)
        adcq	64(%r10), %r8
        movq	72(%r15), %rax
        movq	%r8, 64(%r15)
        adcq	72(%r10), %rax
        movq	80(%r15), %rcx
        movq	%rax, 72(%r15)
        adcq	80(%r10), %rcx
        movq	88(%r15), %r8
        movq	%rcx, 80(%r15)
        adcq	88(%r10), %r8
        movq	96(%r15), %rax
        movq	%r8, 88(%r15)
        adcq	96(%r10), %rax
        movq	104(%r15), %rcx
        movq	%rax, 96(%r15)
        adcq	104(%r10), %rcx
        movq	112(%r15), %r8
        movq	%rcx, 104(%r15)
        adcq	112(%r10), %r8
        movq	120(%r15), %rax
        movq	%r8, 112(%r15)
        adcq	120(%r10), %rax
        movq	128(%r15), %rcx
        movq	%rax, 120(%r15)
        adcq	128(%r10), %rcx
        movq	136(%r15), %r8
        movq	%rcx, 128(%r15)
        adcq	136(%r10), %r8
        movq	144(%r15), %rax
        movq	%r8, 136(%r15)
        adcq	144(%r10), %rax
        movq	152(%r15), %rcx
        movq	%rax, 144(%r15)
        adcq	152(%r10), %rcx
        movq	160(%r15), %r8
        movq	%rcx, 152(%r15)
        adcq	160(%r10), %r8
        movq	168(%r15), %rax
        movq	%r8, 160(%r15)
        adcq	168(%r10), %rax
        movq	176(%r15), %rcx
        movq	%rax, 168(%r15)
        adcq	176(%r10), %rcx
        movq	184(%r15), %r8
        movq	%rcx, 176(%r15)
        adcq	184(%r10), %r8
        movq	192(%r15), %rax
        movq	%r8, 184(%r15)
        adcq	192(%r10), %rax
        movq	200(%r15), %rcx
        movq	%rax, 192(%r15)
        adcq	200(%r10), %rcx
        movq	208(%r15), %r8
        movq	%rcx, 200(%r15)
        adcq	208(%r10), %r8
        movq	216(%r15), %rax
        movq	%r8, 208(%r15)
        adcq	216(%r10), %rax
        movq	224(%r15), %rcx
        movq	%rax, 216(%r15)
        adcq	224(%r10), %rcx
        movq	232(%r15), %r8
        movq	%rcx, 224(%r15)
        adcq	232(%r10), %r8
        movq	240(%r15), %rax
        movq	%r8, 232(%r15)
        adcq	240(%r10), %rax
        movq	248(%r15), %rcx
        movq	%rax, 240(%r15)
        adcq	248(%r10), %rcx
        movq	256(%r15), %r8
        movq	%rcx, 248(%r15)
        adcq	256(%r10), %r8
        movq	264(%r15), %rax
        movq	%r8, 256(%r15)
        adcq	264(%r10), %rax
        movq	272(%r15), %rcx
        movq	%rax, 264(%r15)
        adcq	272(%r10), %rcx
        movq	280(%r15), %r8
        movq	%rcx, 272(%r15)
        adcq	280(%r10), %r8
        movq	288(%r15), %rax
        movq	%r8, 280(%r15)
        adcq	288(%r10), %rax
        movq	296(%r15), %rcx
        movq	%rax, 288(%r15)
        adcq	296(%r10), %rcx
        movq	304(%r15), %r8
        movq	%rcx, 296(%r15)
        adcq	304(%r10), %r8
        movq	312(%r15), %rax
        movq	%r8, 304(%r15)
        adcq	312(%r10), %rax
        movq	320(%r15), %rcx
        movq	%rax, 312(%r15)
        adcq	320(%r10), %rcx
        movq	328(%r15), %r8
        movq	%rcx, 320(%r15)
        adcq	328(%r10), %r8
        movq	336(%r15), %rax
        movq	%r8, 328(%r15)
        adcq	336(%r10), %rax
        movq	344(%r15), %rcx
        movq	%rax, 336(%r15)
        adcq	344(%r10), %rcx
        movq	352(%r15), %r8
        movq	%rcx, 344(%r15)
        adcq	352(%r10), %r8
        movq	360(%r15), %rax
        movq	%r8, 352(%r15)
        adcq	360(%r10), %rax
        movq	368(%r15), %rcx
        movq	%rax, 360(%r15)
        adcq	368(%r10), %rcx
        movq	376(%r15), %r8
        movq	%rcx, 368(%r15)
        adcq	376(%r10), %r8
        movq	%r8, 376(%r15)
        adcq	$0x00, %r9
        movq	%r9, 576(%rdi)
        addq	$0xc0, %r15
        # Add
        movq	(%r15), %rax
        addq	(%r11), %rax
        movq	8(%r15), %rcx
        movq	%rax, (%r15)
        adcq	8(%r11), %rcx
        movq	16(%r15), %r8
        movq	%rcx, 8(%r15)
        adcq	16(%r11), %r8
        movq	24(%r15), %rax
        movq	%r8, 16(%r15)
        adcq	24(%r11), %rax
        movq	32(%r15), %rcx
        movq	%rax, 24(%r15)
        adcq	32(%r11), %rcx
        movq	40(%r15), %r8
        movq	%rcx, 32(%r15)
        adcq	40(%r11), %r8
        movq	48(%r15), %rax
        movq	%r8, 40(%r15)
        adcq	48(%r11), %rax
        movq	56(%r15), %rcx
        movq	%rax, 48(%r15)
        adcq	56(%r11), %rcx
        movq	64(%r15), %r8
        movq	%rcx, 56(%r15)
        adcq	64(%r11), %r8
        movq	72(%r15), %rax
        movq	%r8, 64(%r15)
        adcq	72(%r11), %rax
        movq	80(%r15), %rcx
        movq	%rax, 72(%r15)
        adcq	80(%r11), %rcx
        movq	88(%r15), %r8
        movq	%rcx, 80(%r15)
        adcq	88(%r11), %r8
        movq	96(%r15), %rax
        movq	%r8, 88(%r15)
        adcq	96(%r11), %rax
        movq	104(%r15), %rcx
        movq	%rax, 96(%r15)
        adcq	104(%r11), %rcx
        movq	112(%r15), %r8
        movq	%rcx, 104(%r15)
        adcq	112(%r11), %r8
        movq	120(%r15), %rax
        movq	%r8, 112(%r15)
        adcq	120(%r11), %rax
        movq	128(%r15), %rcx
        movq	%rax, 120(%r15)
        adcq	128(%r11), %rcx
        movq	136(%r15), %r8
        movq	%rcx, 128(%r15)
        adcq	136(%r11), %r8
        movq	144(%r15), %rax
        movq	%r8, 136(%r15)
        adcq	144(%r11), %rax
        movq	152(%r15), %rcx
        movq	%rax, 144(%r15)
        adcq	152(%r11), %rcx
        movq	160(%r15), %r8
        movq	%rcx, 152(%r15)
        adcq	160(%r11), %r8
        movq	168(%r15), %rax
        movq	%r8, 160(%r15)
        adcq	168(%r11), %rax
        movq	176(%r15), %rcx
        movq	%rax, 168(%r15)
        adcq	176(%r11), %rcx
        movq	184(%r15), %r8
        movq	%rcx, 176(%r15)
        adcq	184(%r11), %r8
        movq	192(%r15), %rax
        movq	%r8, 184(%r15)
        adcq	192(%r11), %rax
        movq	%rax, 192(%r15)
        # Add to zero
        movq	200(%r11), %rax
        adcq	$0x00, %rax
        movq	208(%r11), %rcx
        movq	%rax, 200(%r15)
        adcq	$0x00, %rcx
        movq	216(%r11), %r8
        movq	%rcx, 208(%r15)
        adcq	$0x00, %r8
        movq	224(%r11), %rax
        movq	%r8, 216(%r15)
        adcq	$0x00, %rax
        movq	232(%r11), %rcx
        movq	%rax, 224(%r15)
        adcq	$0x00, %rcx
        movq	240(%r11), %r8
        movq	%rcx, 232(%r15)
        adcq	$0x00, %r8
        movq	248(%r11), %rax
        movq	%r8, 240(%r15)
        adcq	$0x00, %rax
        movq	256(%r11), %rcx
        movq	%rax, 248(%r15)
        adcq	$0x00, %rcx
        movq	264(%r11), %r8
        movq	%rcx, 256(%r15)
        adcq	$0x00, %r8
        movq	272(%r11), %rax
        movq	%r8, 264(%r15)
        adcq	$0x00, %rax
        movq	280(%r11), %rcx
        movq	%rax, 272(%r15)
        adcq	$0x00, %rcx
        movq	288(%r11), %r8
        movq	%rcx, 280(%r15)
        adcq	$0x00, %r8
        movq	296(%r11), %rax
        movq	%r8, 288(%r15)
        adcq	$0x00, %rax
        movq	304(%r11), %rcx
        movq	%rax, 296(%r15)
        adcq	$0x00, %rcx
        movq	312(%r11), %r8
        movq	%rcx, 304(%r15)
        adcq	$0x00, %r8
        movq	320(%r11), %rax
        movq	%r8, 312(%r15)
        adcq	$0x00, %rax
        movq	328(%r11), %rcx
        movq	%rax, 320(%r15)
        adcq	$0x00, %rcx
        movq	336(%r11), %r8
        movq	%rcx, 328(%r15)
        adcq	$0x00, %r8
        movq	344(%r11), %rax
        movq	%r8, 336(%r15)
        adcq	$0x00, %rax
        movq	352(%r11), %rcx
        movq	%rax, 344(%r15)
        adcq	$0x00, %rcx
        movq	360(%r11), %r8
        movq	%rcx, 352(%r15)
        adcq	$0x00, %r8
        movq	368(%r11), %rax
        movq	%r8, 360(%r15)
        adcq	$0x00, %rax
        movq	376(%r11), %rcx
        movq	%rax, 368(%r15)
        adcq	$0x00, %rcx
        movq	%rcx, 376(%r15)
        addq	$0x4a8, %rsp
        popq	%r15
        popq	%r14
        popq	%r13
        popq	%r12
        repz retq
#ifndef __APPLE__
.size	sp_3072_mul_avx2_48,.-sp_3072_mul_avx2_48
#endif /* __APPLE__ */
#endif /* HAVE_INTEL_AVX2 */
/* Square a and put result in r. (r = a * a)
 *
 * r  A single precision integer.
 * a  A single precision integer.
 */
#ifndef __APPLE__
.text
.globl	sp_3072_sqr_12
.type	sp_3072_sqr_12,@function
.align	16
sp_3072_sqr_12:
#else
.section	__TEXT,__text
.globl	_sp_3072_sqr_12
.p2align	4
_sp_3072_sqr_12:
#endif /* __APPLE__ */
        pushq	%r12
        subq	$0x60, %rsp
        # A[0] * A[0]
        movq	(%rsi), %rax
        mulq	%rax
        xorq	%r9, %r9
        movq	%rax, (%rsp)
        movq	%rdx, %r8
        # A[0] * A[1]
        movq	8(%rsi), %rax
        mulq	(%rsi)
        xorq	%rcx, %rcx
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0x00, %rcx
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0x00, %rcx
        movq	%r8, 8(%rsp)
        # A[0] * A[2]
        movq	16(%rsi), %rax
        mulq	(%rsi)
        xorq	%r8, %r8
        addq	%rax, %r9
        adcq	%rdx, %rcx
        adcq	$0x00, %r8
        addq	%rax, %r9
        adcq	%rdx, %rcx
        adcq	$0x00, %r8
        # A[1] * A[1]
        movq	8(%rsi), %rax
        mulq	%rax
        addq	%rax, %r9
        adcq	%rdx, %rcx
        adcq	$0x00, %r8
        movq	%r9, 16(%rsp)
        # A[0] * A[3]
        movq	24(%rsi), %rax
        mulq	(%rsi)
        xorq	%r9, %r9
        addq	%rax, %rcx
        adcq	%rdx, %r8
        adcq	$0x00, %r9
        addq	%rax, %rcx
        adcq	%rdx, %r8
        adcq	$0x00, %r9
        # A[1] * A[2]
        movq	16(%rsi), %rax
        mulq	8(%rsi)
        addq	%rax, %rcx
        adcq	%rdx, %r8
        adcq	$0x00, %r9
        addq	%rax, %rcx
        adcq	%rdx, %r8
        adcq	$0x00, %r9
        movq	%rcx, 24(%rsp)
        # A[0] * A[4]
        movq	32(%rsi), %rax
        mulq	(%rsi)
        xorq	%rcx, %rcx
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0x00, %rcx
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0x00, %rcx
        # A[1] * A[3]
        movq	24(%rsi), %rax
        mulq	8(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0x00, %rcx
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0x00, %rcx
        # A[2] * A[2]
        movq	16(%rsi), %rax
        mulq	%rax
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0x00, %rcx
        movq	%r8, 32(%rsp)
        # A[0] * A[5]
        movq	40(%rsi), %rax
        mulq	(%rsi)
        xorq	%r8, %r8
        xorq	%r12, %r12
        movq	%rax, %r10
        movq	%rdx, %r11
        # A[1] * A[4]
        movq	32(%rsi), %rax
        mulq	8(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0x00, %r12
        # A[2] * A[3]
        movq	24(%rsi), %rax
        mulq	16(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0x00, %r12
        addq	%r10, %r10
        adcq	%r11, %r11
        adcq	%r12, %r12
        addq	%r10, %r9
        adcq	%r11, %rcx
        adcq	%r12, %r8
        movq	%r9, 40(%rsp)
        # A[0] * A[6]
        movq	48(%rsi), %rax
        mulq	(%rsi)
        xorq	%r9, %r9
        xorq	%r12, %r12
        movq	%rax, %r10
        movq	%rdx, %r11
        # A[1] * A[5]
        movq	40(%rsi), %rax
        mulq	8(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0x00, %r12
        # A[2] * A[4]
        movq	32(%rsi), %rax
        mulq	16(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0x00, %r12
        # A[3] * A[3]
        movq	24(%rsi), %rax
        mulq	%rax
        addq	%r10, %r10
        adcq	%r11, %r11
        adcq	%r12, %r12
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0x00, %r12
        addq	%r10, %rcx
        adcq	%r11, %r8
        adcq	%r12, %r9
        movq	%rcx, 48(%rsp)
        # A[0] * A[7]
        movq	56(%rsi), %rax
        mulq	(%rsi)
        xorq	%rcx, %rcx
        xorq	%r12, %r12
        movq	%rax, %r10
        movq	%rdx, %r11
        # A[1] * A[6]
        movq	48(%rsi), %rax
        mulq	8(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0x00, %r12
        # A[2] * A[5]
        movq	40(%rsi), %rax
        mulq	16(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0x00, %r12
        # A[3] * A[4]
        movq	32(%rsi), %rax
        mulq	24(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0x00, %r12
        addq	%r10, %r10
        adcq	%r11, %r11
        adcq	%r12, %r12
        addq	%r10, %r8
        adcq	%r11, %r9
        adcq	%r12, %rcx
        movq	%r8, 56(%rsp)
        # A[0] * A[8]
        movq	64(%rsi), %rax
        mulq	(%rsi)
        xorq	%r8, %r8
        xorq	%r12, %r12
        movq	%rax, %r10
        movq	%rdx, %r11
        # A[1] * A[7]
        movq	56(%rsi), %rax
        mulq	8(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0x00, %r12
        # A[2] * A[6]
        movq	48(%rsi), %rax
        mulq	16(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0x00, %r12
        # A[3] * A[5]
        movq	40(%rsi), %rax
        mulq	24(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0x00, %r12
        # A[4] * A[4]
        movq	32(%rsi), %rax
        mulq	%rax
        addq	%r10, %r10
        adcq	%r11, %r11
        adcq	%r12, %r12
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0x00, %r12
        addq	%r10, %r9
        adcq	%r11, %rcx
        adcq	%r12, %r8
        movq	%r9, 64(%rsp)
        # A[0] * A[9]
        movq	72(%rsi), %rax
        mulq	(%rsi)
        xorq	%r9, %r9
        xorq	%r12, %r12
        movq	%rax, %r10
        movq	%rdx, %r11
        # A[1] * A[8]
        movq	64(%rsi), %rax
        mulq	8(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0x00, %r12
        # A[2] * A[7]
        movq	56(%rsi), %rax
        mulq	16(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0x00, %r12
        # A[3] * A[6]
        movq	48(%rsi), %rax
        mulq	24(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0x00, %r12
        # A[4] * A[5]
        movq	40(%rsi), %rax
        mulq	32(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0x00, %r12
        addq	%r10, %r10
        adcq	%r11, %r11
        adcq	%r12, %r12
        addq	%r10, %rcx
        adcq	%r11, %r8
        adcq	%r12, %r9
        movq	%rcx, 72(%rsp)
        # A[0] * A[10]
        movq	80(%rsi), %rax
        mulq	(%rsi)
        xorq	%rcx, %rcx
        xorq	%r12, %r12
        movq	%rax, %r10
        movq	%rdx, %r11
        # A[1] * A[9]
        movq	72(%rsi), %rax
        mulq	8(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0x00, %r12
        # A[2] * A[8]
        movq	64(%rsi), %rax
        mulq	16(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0x00, %r12
        # A[3] * A[7]
        movq	56(%rsi), %rax
        mulq	24(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0x00, %r12
        # A[4] * A[6]
        movq	48(%rsi), %rax
        mulq	32(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0x00, %r12
        # A[5] * A[5]
        movq	40(%rsi), %rax
        mulq	%rax
        addq	%r10, %r10
        adcq	%r11, %r11
        adcq	%r12, %r12
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0x00, %r12
        addq	%r10, %r8
        adcq	%r11, %r9
        adcq	%r12, %rcx
        movq	%r8, 80(%rsp)
        # A[0] * A[11]
        movq	88(%rsi), %rax
        mulq	(%rsi)
        xorq	%r8, %r8
        xorq	%r12, %r12
        movq	%rax, %r10
        movq	%rdx, %r11
        # A[1] * A[10]
        movq	80(%rsi), %rax
        mulq	8(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0x00, %r12
        # A[2] * A[9]
        movq	72(%rsi), %rax
        mulq	16(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0x00, %r12
        # A[3] * A[8]
        movq	64(%rsi), %rax
        mulq	24(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0x00, %r12
        # A[4] * A[7]
        movq	56(%rsi), %rax
        mulq	32(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0x00, %r12
        # A[5] * A[6]
        movq	48(%rsi), %rax
        mulq	40(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0x00, %r12
        addq	%r10, %r10
        adcq	%r11, %r11
        adcq	%r12, %r12
        addq	%r10, %r9
        adcq	%r11, %rcx
        adcq	%r12, %r8
        movq	%r9, 88(%rsp)
        # A[1] * A[11]
        movq	88(%rsi), %rax
        mulq	8(%rsi)
        xorq	%r9, %r9
        xorq	%r12, %r12
        movq	%rax, %r10
        movq	%rdx, %r11
        # A[2] * A[10]
        movq	80(%rsi), %rax
        mulq	16(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0x00, %r12
        # A[3] * A[9]
        movq	72(%rsi), %rax
        mulq	24(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0x00, %r12
        # A[4] * A[8]
        movq	64(%rsi), %rax
        mulq	32(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0x00, %r12
        # A[5] * A[7]
        movq	56(%rsi), %rax
        mulq	40(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0x00, %r12
        # A[6] * A[6]
        movq	48(%rsi), %rax
        mulq	%rax
        addq	%r10, %r10
        adcq	%r11, %r11
        adcq	%r12, %r12
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0x00, %r12
        addq	%r10, %rcx
        adcq	%r11, %r8
        adcq	%r12, %r9
        movq	%rcx, 96(%rdi)
        # A[2] * A[11]
        movq	88(%rsi), %rax
        mulq	16(%rsi)
        xorq	%rcx, %rcx
        xorq	%r12, %r12
        movq	%rax, %r10
        movq	%rdx, %r11
        # A[3] * A[10]
        movq	80(%rsi), %rax
        mulq	24(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0x00, %r12
        # A[4] * A[9]
        movq	72(%rsi), %rax
        mulq	32(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0x00, %r12
        # A[5] * A[8]
        movq	64(%rsi), %rax
        mulq	40(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0x00, %r12
        # A[6] * A[7]
        movq	56(%rsi), %rax
        mulq	48(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0x00, %r12
        addq	%r10, %r10
        adcq	%r11, %r11
        adcq	%r12, %r12
        addq	%r10, %r8
        adcq	%r11, %r9
        adcq	%r12, %rcx
        movq	%r8, 104(%rdi)
        # A[3] * A[11]
        movq	88(%rsi), %rax
        mulq	24(%rsi)
        xorq	%r8, %r8
        xorq	%r12, %r12
        movq	%rax, %r10
        movq	%rdx, %r11
        # A[4] * A[10]
        movq	80(%rsi), %rax
        mulq	32(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0x00, %r12
        # A[5] * A[9]
        movq	72(%rsi), %rax
        mulq	40(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0x00, %r12
        # A[6] * A[8]
        movq	64(%rsi), %rax
        mulq	48(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0x00, %r12
        # A[7] * A[7]
        movq	56(%rsi), %rax
        mulq	%rax
        addq	%r10, %r10
        adcq	%r11, %r11
        adcq	%r12, %r12
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0x00, %r12
        addq	%r10, %r9
        adcq	%r11, %rcx
        adcq	%r12, %r8
        movq	%r9, 112(%rdi)
        # A[4] * A[11]
        movq	88(%rsi), %rax
        mulq	32(%rsi)
        xorq	%r9, %r9
        xorq	%r12, %r12
        movq	%rax, %r10
        movq	%rdx, %r11
        # A[5] * A[10]
        movq	80(%rsi), %rax
        mulq	40(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0x00, %r12
        # A[6] * A[9]
        movq	72(%rsi), %rax
        mulq	48(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0x00, %r12
        # A[7] * A[8]
        movq	64(%rsi), %rax
        mulq	56(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0x00, %r12
        addq	%r10, %r10
        adcq	%r11, %r11
        adcq	%r12, %r12
        addq	%r10, %rcx
        adcq	%r11, %r8
        adcq	%r12, %r9
        movq	%rcx, 120(%rdi)
        # A[5] * A[11]
        movq	88(%rsi), %rax
        mulq	40(%rsi)
        xorq	%rcx, %rcx
        xorq	%r12, %r12
        movq	%rax, %r10
        movq	%rdx, %r11
        # A[6] * A[10]
        movq	80(%rsi), %rax
        mulq	48(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0x00, %r12
        # A[7] * A[9]
        movq	72(%rsi), %rax
        mulq	56(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0x00, %r12
        # A[8] * A[8]
        movq	64(%rsi), %rax
        mulq	%rax
        addq	%r10, %r10
        adcq	%r11, %r11
        adcq	%r12, %r12
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0x00, %r12
        addq	%r10, %r8
        adcq	%r11, %r9
        adcq	%r12, %rcx
        movq	%r8, 128(%rdi)
        # A[6] * A[11]
        movq	88(%rsi), %rax
        mulq	48(%rsi)
        xorq	%r8, %r8
        xorq	%r12, %r12
        movq	%rax, %r10
        movq	%rdx, %r11
        # A[7] * A[10]
        movq	80(%rsi), %rax
        mulq	56(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0x00, %r12
        # A[8] * A[9]
        movq	72(%rsi), %rax
        mulq	64(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0x00, %r12
        addq	%r10, %r10
        adcq	%r11, %r11
        adcq	%r12, %r12
        addq	%r10, %r9
        adcq	%r11, %rcx
        adcq	%r12, %r8
        movq	%r9, 136(%rdi)
        # A[7] * A[11]
        movq	88(%rsi), %rax
        mulq	56(%rsi)
        xorq	%r9, %r9
        addq	%rax, %rcx
        adcq	%rdx, %r8
        adcq	$0x00, %r9
        addq	%rax, %rcx
        adcq	%rdx, %r8
        adcq	$0x00, %r9
        # A[8] * A[10]
        movq	80(%rsi), %rax
        mulq	64(%rsi)
        addq	%rax, %rcx
        adcq	%rdx, %r8
        adcq	$0x00, %r9
        addq	%rax, %rcx
        adcq	%rdx, %r8
        adcq	$0x00, %r9
        # A[9] * A[9]
        movq	72(%rsi), %rax
        mulq	%rax
        addq	%rax, %rcx
        adcq	%rdx, %r8
        adcq	$0x00, %r9
        movq	%rcx, 144(%rdi)
        # A[8] * A[11]
        movq	88(%rsi), %rax
        mulq	64(%rsi)
        xorq	%rcx, %rcx
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0x00, %rcx
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0x00, %rcx
        # A[9] * A[10]
        movq	80(%rsi), %rax
        mulq	72(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0x00, %rcx
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0x00, %rcx
        movq	%r8, 152(%rdi)
        # A[9] * A[11]
        movq	88(%rsi), %rax
        mulq	72(%rsi)
        xorq	%r8, %r8
        addq	%rax, %r9
        adcq	%rdx, %rcx
        adcq	$0x00, %r8
        addq	%rax, %r9
        adcq	%rdx, %rcx
        adcq	$0x00, %r8
        # A[10] * A[10]
        movq	80(%rsi), %rax
        mulq	%rax
        addq	%rax, %r9
        adcq	%rdx, %rcx
        adcq	$0x00, %r8
        movq	%r9, 160(%rdi)
        # A[10] * A[11]
        movq	88(%rsi), %rax
        mulq	80(%rsi)
        xorq	%r9, %r9
        addq	%rax, %rcx
        adcq	%rdx, %r8
        adcq	$0x00, %r9
        addq	%rax, %rcx
        adcq	%rdx, %r8
        adcq	$0x00, %r9
        movq	%rcx, 168(%rdi)
        # A[11] * A[11]
        movq	88(%rsi), %rax
        mulq	%rax
        addq	%rax, %r8
        adcq	%rdx, %r9
        movq	%r8, 176(%rdi)
        movq	%r9, 184(%rdi)
        movq	(%rsp), %rax
        movq	8(%rsp), %rdx
        movq	16(%rsp), %r10
        movq	24(%rsp), %r11
        movq	%rax, (%rdi)
        movq	%rdx, 8(%rdi)
        movq	%r10, 16(%rdi)
        movq	%r11, 24(%rdi)
        movq	32(%rsp), %rax
        movq	40(%rsp), %rdx
        movq	48(%rsp), %r10
        movq	56(%rsp), %r11
        movq	%rax, 32(%rdi)
        movq	%rdx, 40(%rdi)
        movq	%r10, 48(%rdi)
        movq	%r11, 56(%rdi)
        movq	64(%rsp), %rax
        movq	72(%rsp), %rdx
        movq	80(%rsp), %r10
        movq	88(%rsp), %r11
        movq	%rax, 64(%rdi)
        movq	%rdx, 72(%rdi)
        movq	%r10, 80(%rdi)
        movq	%r11, 88(%rdi)
        addq	$0x60, %rsp
        popq	%r12
        repz retq
#ifndef __APPLE__
.size	sp_3072_sqr_12,.-sp_3072_sqr_12
#endif /* __APPLE__ */
#ifdef HAVE_INTEL_AVX2
/* Square a and put result in r. (r = a * a)
 *
 * r  A single precision integer.
 * a  A single precision integer.
 */
#ifndef __APPLE__
.text
.globl	sp_3072_sqr_avx2_12
.type	sp_3072_sqr_avx2_12,@function
.align	16
sp_3072_sqr_avx2_12:
#else
.section	__TEXT,__text
.globl	_sp_3072_sqr_avx2_12
.p2align	4
_sp_3072_sqr_avx2_12:
#endif /* __APPLE__ */
        pushq	%rbp
        pushq	%r12
        pushq	%r13
        pushq	%r14
        pushq	%r15
        pushq	%rbx
        subq	$0x60, %rsp
        cmpq	%rdi, %rsi
        movq	%rsp, %rbp
        cmovne	%rdi, %rbp
        addq	$0x60, %rdi
        xorq	%r10, %r10
        # Diagonal 1
        # Zero into %r9
        # A[1] x A[0]
        movq	(%rsi), %rdx
        mulxq	8(%rsi), %r8, %r9
        movq	%r8, 8(%rbp)
        # Zero into %r8
        # A[2] x A[0]
        mulxq	16(%rsi), %rax, %r8
        adcxq	%rax, %r9
        adoxq	%r10, %r8
        movq	%r9, 16(%rbp)
        # Zero into %r9
        # A[3] x A[0]
        mulxq	24(%rsi), %rax, %r9
        adcxq	%rax, %r8
        adoxq	%r10, %r9
        movq	%r8, 24(%rbp)
        # Zero into %r8
        # A[4] x A[0]
        mulxq	32(%rsi), %rax, %r8
        adcxq	%rax, %r9
        adoxq	%r10, %r8
        movq	%r9, 32(%rbp)
        # Zero into %r9
        # A[5] x A[0]
        mulxq	40(%rsi), %rax, %r9
        adcxq	%rax, %r8
        adoxq	%r10, %r9
        movq	%r8, 40(%rbp)
        # No load %r12 - %r8
        # A[6] x A[0]
        mulxq	48(%rsi), %rax, %r12
        adcxq	%rax, %r9
        adoxq	%r10, %r12
        movq	%r9, 48(%rbp)
        # No load %r13 - %r9
        # A[7] x A[0]
        mulxq	56(%rsi), %rax, %r13
        adcxq	%rax, %r12
        adoxq	%r10, %r13
        # No store %r12 - %r8
        # No load %r14 - %r8
        # A[8] x A[0]
        mulxq	64(%rsi), %rax, %r14
        adcxq	%rax, %r13
        adoxq	%r10, %r14
        # No store %r13 - %r9
        # No load %r15 - %r9
        # A[9] x A[0]
        mulxq	72(%rsi), %rax, %r15
        adcxq	%rax, %r14
        adoxq	%r10, %r15
        # No store %r14 - %r8
        # No load %rbx - %r8
        # A[10] x A[0]
        mulxq	80(%rsi), %rax, %rbx
        adcxq	%rax, %r15
        adoxq	%r10, %rbx
        # No store %r15 - %r9
        # Zero into %r9
        # A[11] x A[0]
        mulxq	88(%rsi), %rax, %r9
        adcxq	%rax, %rbx
        adoxq	%r10, %r9
        # No store %rbx - %r8
        #  Carry
        adcxq	%r10, %r9
        movq	%r10, %r11
        adcxq	%r10, %r11
        adoxq	%r10, %r11
        movq	%r9, (%rdi)
        # Diagonal 2
        movq	24(%rbp), %r9
        movq	32(%rbp), %r8
        # A[2] x A[1]
        movq	8(%rsi), %rdx
        mulxq	16(%rsi), %rax, %rcx
        adcxq	%rax, %r9
        adoxq	%rcx, %r8
        movq	%r9, 24(%rbp)
        movq	40(%rbp), %r9
        # A[3] x A[1]
        mulxq	24(%rsi), %rax, %rcx
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        movq	%r8, 32(%rbp)
        movq	48(%rbp), %r8
        # A[4] x A[1]
        mulxq	32(%rsi), %rax, %rcx
        adcxq	%rax, %r9
        adoxq	%rcx, %r8
        movq	%r9, 40(%rbp)
        # No load %r12 - %r9
        # A[5] x A[1]
        mulxq	40(%rsi), %rax, %rcx
        adcxq	%rax, %r8
        adoxq	%rcx, %r12
        movq	%r8, 48(%rbp)
        # No load %r13 - %r8
        # A[6] x A[1]
        mulxq	48(%rsi), %rax, %rcx
        adcxq	%rax, %r12
        adoxq	%rcx, %r13
        # No store %r12 - %r9
        # No load %r14 - %r9
        # A[7] x A[1]
        mulxq	56(%rsi), %rax, %rcx
        adcxq	%rax, %r13
        adoxq	%rcx, %r14
        # No store %r13 - %r8
        # No load %r15 - %r8
        # A[8] x A[1]
        mulxq	64(%rsi), %rax, %rcx
        adcxq	%rax, %r14
        adoxq	%rcx, %r15
        # No store %r14 - %r9
        # No load %rbx - %r9
        # A[9] x A[1]
        mulxq	72(%rsi), %rax, %rcx
        adcxq	%rax, %r15
        adoxq	%rcx, %rbx
        # No store %r15 - %r8
        movq	(%rdi), %r8
        # A[10] x A[1]
        mulxq	80(%rsi), %rax, %rcx
        adcxq	%rax, %rbx
        adoxq	%rcx, %r8
        # No store %rbx - %r9
        # Zero into %r9
        # A[11] x A[1]
        mulxq	88(%rsi), %rax, %r9
        adcxq	%rax, %r8
        adoxq	%r10, %r9
        movq	%r8, (%rdi)
        # Zero into %r8
        # A[11] x A[2]
        movq	16(%rsi), %rdx
        mulxq	88(%rsi), %rax, %r8
        adcxq	%rax, %r9
        adoxq	%r10, %r8
        movq	%r9, 8(%rdi)
        #  Carry
        adcxq	%r11, %r8
        movq	%r10, %r11
        adcxq	%r10, %r11
        adoxq	%r10, %r11
        movq	%r8, 16(%rdi)
        # Diagonal 3
        movq	40(%rbp), %r8
        movq	48(%rbp), %r9
        # A[3] x A[2]
        mulxq	24(%rsi), %rax, %rcx
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        movq	%r8, 40(%rbp)
        # No load %r12 - %r8
        # A[4] x A[2]
        mulxq	32(%rsi), %rax, %rcx
        adcxq	%rax, %r9
        adoxq	%rcx, %r12
        movq	%r9, 48(%rbp)
        # No load %r13 - %r9
        # A[5] x A[2]
        mulxq	40(%rsi), %rax, %rcx
        adcxq	%rax, %r12
        adoxq	%rcx, %r13
        # No store %r12 - %r8
        # No load %r14 - %r8
        # A[6] x A[2]
        mulxq	48(%rsi), %rax, %rcx
        adcxq	%rax, %r13
        adoxq	%rcx, %r14
        # No store %r13 - %r9
        # No load %r15 - %r9
        # A[7] x A[2]
        mulxq	56(%rsi), %rax, %rcx
        adcxq	%rax, %r14
        adoxq	%rcx, %r15
        # No store %r14 - %r8
        # No load %rbx - %r8
        # A[8] x A[2]
        mulxq	64(%rsi), %rax, %rcx
        adcxq	%rax, %r15
        adoxq	%rcx, %rbx
        # No store %r15 - %r9
        movq	(%rdi), %r9
        # A[9] x A[2]
        mulxq	72(%rsi), %rax, %rcx
        adcxq	%rax, %rbx
        adoxq	%rcx, %r9
        # No store %rbx - %r8
        movq	8(%rdi), %r8
        # A[10] x A[2]
        mulxq	80(%rsi), %rax, %rcx
        adcxq	%rax, %r9
        adoxq	%rcx, %r8
        movq	%r9, (%rdi)
        movq	16(%rdi), %r9
        # A[10] x A[3]
        movq	24(%rsi), %rdx
        mulxq	80(%rsi), %rax, %rcx
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        movq	%r8, 8(%rdi)
        # Zero into %r8
        # A[10] x A[4]
        movq	32(%rsi), %rdx
        mulxq	80(%rsi), %rax, %r8
        adcxq	%rax, %r9
        adoxq	%r10, %r8
        movq	%r9, 16(%rdi)
        # Zero into %r9
        # A[10] x A[5]
        movq	40(%rsi), %rdx
        mulxq	80(%rsi), %rax, %r9
        adcxq	%rax, %r8
        adoxq	%r10, %r9
        movq	%r8, 24(%rdi)
        #  Carry
        adcxq	%r11, %r9
        movq	%r10, %r11
        adcxq	%r10, %r11
        adoxq	%r10, %r11
        movq	%r9, 32(%rdi)
        # Diagonal 4
        # No load %r13 - %r8
        # A[4] x A[3]
        movq	24(%rsi), %rdx
        mulxq	32(%rsi), %rax, %rcx
        adcxq	%rax, %r12
        adoxq	%rcx, %r13
        # No store %r12 - %r9
        # No load %r14 - %r9
        # A[5] x A[3]
        mulxq	40(%rsi), %rax, %rcx
        adcxq	%rax, %r13
        adoxq	%rcx, %r14
        # No store %r13 - %r8
        # No load %r15 - %r8
        # A[6] x A[3]
        mulxq	48(%rsi), %rax, %rcx
        adcxq	%rax, %r14
        adoxq	%rcx, %r15
        # No store %r14 - %r9
        # No load %rbx - %r9
        # A[7] x A[3]
        mulxq	56(%rsi), %rax, %rcx
        adcxq	%rax, %r15
        adoxq	%rcx, %rbx
        # No store %r15 - %r8
        movq	(%rdi), %r8
        # A[8] x A[3]
        mulxq	64(%rsi), %rax, %rcx
        adcxq	%rax, %rbx
        adoxq	%rcx, %r8
        # No store %rbx - %r9
        movq	8(%rdi), %r9
        # A[9] x A[3]
        mulxq	72(%rsi), %rax, %rcx
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        movq	%r8, (%rdi)
        movq	16(%rdi), %r8
        # A[9] x A[4]
        movq	32(%rsi), %rdx
        mulxq	72(%rsi), %rax, %rcx
        adcxq	%rax, %r9
        adoxq	%rcx, %r8
        movq	%r9, 8(%rdi)
        movq	24(%rdi), %r9
        # A[9] x A[5]
        movq	40(%rsi), %rdx
        mulxq	72(%rsi), %rax, %rcx
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        movq	%r8, 16(%rdi)
        movq	32(%rdi), %r8
        # A[9] x A[6]
        movq	48(%rsi), %rdx
        mulxq	72(%rsi), %rax, %rcx
        adcxq	%rax, %r9
        adoxq	%rcx, %r8
        movq	%r9, 24(%rdi)
        # Zero into %r9
        # A[9] x A[7]
        movq	56(%rsi), %rdx
        mulxq	72(%rsi), %rax, %r9
        adcxq	%rax, %r8
        adoxq	%r10, %r9
        movq	%r8, 32(%rdi)
        # Zero into %r8
        # A[9] x A[8]
        movq	64(%rsi), %rdx
        mulxq	72(%rsi), %rax, %r8
        adcxq	%rax, %r9
        adoxq	%r10, %r8
        movq	%r9, 40(%rdi)
        #  Carry
        adcxq	%r11, %r8
        movq	%r10, %r11
        adcxq	%r10, %r11
        adoxq	%r10, %r11
        movq	%r8, 48(%rdi)
        # Diagonal 5
        # No load %r15 - %r9
        # A[5] x A[4]
        movq	32(%rsi), %rdx
        mulxq	40(%rsi), %rax, %rcx
        adcxq	%rax, %r14
        adoxq	%rcx, %r15
        # No store %r14 - %r8
        # No load %rbx - %r8
        # A[6] x A[4]
        mulxq	48(%rsi), %rax, %rcx
        adcxq	%rax, %r15
        adoxq	%rcx, %rbx
        # No store %r15 - %r9
        movq	(%rdi), %r9
        # A[7] x A[4]
        mulxq	56(%rsi), %rax, %rcx
        adcxq	%rax, %rbx
        adoxq	%rcx, %r9
        # No store %rbx - %r8
        movq	8(%rdi), %r8
        # A[8] x A[4]
        mulxq	64(%rsi), %rax, %rcx
        adcxq	%rax, %r9
        adoxq	%rcx, %r8
        movq	%r9, (%rdi)
        movq	16(%rdi), %r9
        # A[8] x A[5]
        movq	40(%rsi), %rdx
        mulxq	64(%rsi), %rax, %rcx
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        movq	%r8, 8(%rdi)
        movq	24(%rdi), %r8
        # A[8] x A[6]
        movq	48(%rsi), %rdx
        mulxq	64(%rsi), %rax, %rcx
        adcxq	%rax, %r9
        adoxq	%rcx, %r8
        movq	%r9, 16(%rdi)
        movq	32(%rdi), %r9
        # A[8] x A[7]
        movq	56(%rsi), %rdx
        mulxq	64(%rsi), %rax, %rcx
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        movq	%r8, 24(%rdi)
        movq	40(%rdi), %r8
        # A[10] x A[6]
        movq	48(%rsi), %rdx
        mulxq	80(%rsi), %rax, %rcx
        adcxq	%rax, %r9
        adoxq	%rcx, %r8
        movq	%r9, 32(%rdi)
        movq	48(%rdi), %r9
        # A[10] x A[7]
        movq	56(%rsi), %rdx
        mulxq	80(%rsi), %rax, %rcx
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        movq	%r8, 40(%rdi)
        # Zero into %r8
        # A[10] x A[8]
        movq	64(%rsi), %rdx
        mulxq	80(%rsi), %rax, %r8
        adcxq	%rax, %r9
        adoxq	%r10, %r8
        movq	%r9, 48(%rdi)
        # Zero into %r9
        # A[10] x A[9]
        movq	72(%rsi), %rdx
        mulxq	80(%rsi), %rax, %r9
        adcxq	%rax, %r8
        adoxq	%r10, %r9
        movq	%r8, 56(%rdi)
        #  Carry
        adcxq	%r11, %r9
        movq	%r10, %r11
        adcxq	%r10, %r11
        adoxq	%r10, %r11
        movq	%r9, 64(%rdi)
        # Diagonal 6
        movq	(%rdi), %r8
        # A[6] x A[5]
        movq	40(%rsi), %rdx
        mulxq	48(%rsi), %rax, %rcx
        adcxq	%rax, %rbx
        adoxq	%rcx, %r8
        # No store %rbx - %r9
        movq	8(%rdi), %r9
        # A[7] x A[5]
        mulxq	56(%rsi), %rax, %rcx
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        movq	%r8, (%rdi)
        movq	16(%rdi), %r8
        # A[7] x A[6]
        movq	48(%rsi), %rdx
        mulxq	56(%rsi), %rax, %rcx
        adcxq	%rax, %r9
        adoxq	%rcx, %r8
        movq	%r9, 8(%rdi)
        movq	24(%rdi), %r9
        # A[11] x A[3]
        movq	24(%rsi), %rdx
        mulxq	88(%rsi), %rax, %rcx
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        movq	%r8, 16(%rdi)
        movq	32(%rdi), %r8
        # A[11] x A[4]
        movq	32(%rsi), %rdx
        mulxq	88(%rsi), %rax, %rcx
        adcxq	%rax, %r9
        adoxq	%rcx, %r8
        movq	%r9, 24(%rdi)
        movq	40(%rdi), %r9
        # A[11] x A[5]
        movq	40(%rsi), %rdx
        mulxq	88(%rsi), %rax, %rcx
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        movq	%r8, 32(%rdi)
        movq	48(%rdi), %r8
        # A[11] x A[6]
        movq	48(%rsi), %rdx
        mulxq	88(%rsi), %rax, %rcx
        adcxq	%rax, %r9
        adoxq	%rcx, %r8
        movq	%r9, 40(%rdi)
        movq	56(%rdi), %r9
        # A[11] x A[7]
        movq	56(%rsi), %rdx
        mulxq	88(%rsi), %rax, %rcx
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        movq	%r8, 48(%rdi)
        movq	64(%rdi), %r8
        # A[11] x A[8]
        movq	64(%rsi), %rdx
        mulxq	88(%rsi), %rax, %rcx
        adcxq	%rax, %r9
        adoxq	%rcx, %r8
        movq	%r9, 56(%rdi)
        # Zero into %r9
        # A[11] x A[9]
        movq	72(%rsi), %rdx
        mulxq	88(%rsi), %rax, %r9
        adcxq	%rax, %r8
        adoxq	%r10, %r9
        movq	%r8, 64(%rdi)
        # Zero into %r8
        # A[11] x A[10]
        movq	80(%rsi), %rdx
        mulxq	88(%rsi), %rax, %r8
        adcxq	%rax, %r9
        adoxq	%r10, %r8
        movq	%r9, 72(%rdi)
        #  Carry
        adcxq	%r11, %r8
        movq	%r10, %r11
        adcxq	%r10, %r11
        adoxq	%r10, %r11
        movq	%r8, 80(%rdi)
        movq	%r11, 88(%rdi)
        # Double and Add in A[i] x A[i]
        movq	8(%rbp), %r9
        # A[0] x A[0]
        movq	(%rsi), %rdx
        mulxq	%rdx, %rax, %rcx
        movq	%rax, (%rbp)
        adoxq	%r9, %r9
        adcxq	%rcx, %r9
        movq	%r9, 8(%rbp)
        movq	16(%rbp), %r8
        movq	24(%rbp), %r9
        # A[1] x A[1]
        movq	8(%rsi), %rdx
        mulxq	%rdx, %rax, %rcx
        adoxq	%r8, %r8
        adoxq	%r9, %r9
        adcxq	%rax, %r8
        adcxq	%rcx, %r9
        movq	%r8, 16(%rbp)
        movq	%r9, 24(%rbp)
        movq	32(%rbp), %r8
        movq	40(%rbp), %r9
        # A[2] x A[2]
        movq	16(%rsi), %rdx
        mulxq	%rdx, %rax, %rcx
        adoxq	%r8, %r8
        adoxq	%r9, %r9
        adcxq	%rax, %r8
        adcxq	%rcx, %r9
        movq	%r8, 32(%rbp)
        movq	%r9, 40(%rbp)
        movq	48(%rbp), %r8
        # A[3] x A[3]
        movq	24(%rsi), %rdx
        mulxq	%rdx, %rax, %rcx
        adoxq	%r8, %r8
        adoxq	%r12, %r12
        adcxq	%rax, %r8
        adcxq	%rcx, %r12
        movq	%r8, 48(%rbp)
        # A[4] x A[4]
        movq	32(%rsi), %rdx
        mulxq	%rdx, %rax, %rcx
        adoxq	%r13, %r13
        adoxq	%r14, %r14
        adcxq	%rax, %r13
        adcxq	%rcx, %r14
        # A[5] x A[5]
        movq	40(%rsi), %rdx
        mulxq	%rdx, %rax, %rcx
        adoxq	%r15, %r15
        adoxq	%rbx, %rbx
        adcxq	%rax, %r15
        adcxq	%rcx, %rbx
        movq	(%rdi), %r8
        movq	8(%rdi), %r9
        # A[6] x A[6]
        movq	48(%rsi), %rdx
        mulxq	%rdx, %rax, %rcx
        adoxq	%r8, %r8
        adoxq	%r9, %r9
        adcxq	%rax, %r8
        adcxq	%rcx, %r9
        movq	%r8, (%rdi)
        movq	%r9, 8(%rdi)
        movq	16(%rdi), %r8
        movq	24(%rdi), %r9
        # A[7] x A[7]
        movq	56(%rsi), %rdx
        mulxq	%rdx, %rax, %rcx
        adoxq	%r8, %r8
        adoxq	%r9, %r9
        adcxq	%rax, %r8
        adcxq	%rcx, %r9
        movq	%r8, 16(%rdi)
        movq	%r9, 24(%rdi)
        movq	32(%rdi), %r8
        movq	40(%rdi), %r9
        # A[8] x A[8]
        movq	64(%rsi), %rdx
        mulxq	%rdx, %rax, %rcx
        adoxq	%r8, %r8
        adoxq	%r9, %r9
        adcxq	%rax, %r8
        adcxq	%rcx, %r9
        movq	%r8, 32(%rdi)
        movq	%r9, 40(%rdi)
        movq	48(%rdi), %r8
        movq	56(%rdi), %r9
        # A[9] x A[9]
        movq	72(%rsi), %rdx
        mulxq	%rdx, %rax, %rcx
        adoxq	%r8, %r8
        adoxq	%r9, %r9
        adcxq	%rax, %r8
        adcxq	%rcx, %r9
        movq	%r8, 48(%rdi)
        movq	%r9, 56(%rdi)
        movq	64(%rdi), %r8
        movq	72(%rdi), %r9
        # A[10] x A[10]
        movq	80(%rsi), %rdx
        mulxq	%rdx, %rax, %rcx
        adoxq	%r8, %r8
        adoxq	%r9, %r9
        adcxq	%rax, %r8
        adcxq	%rcx, %r9
        movq	%r8, 64(%rdi)
        movq	%r9, 72(%rdi)
        movq	80(%rdi), %r8
        movq	88(%rdi), %r9
        # A[11] x A[11]
        movq	88(%rsi), %rdx
        mulxq	%rdx, %rax, %rcx
        adoxq	%r8, %r8
        adoxq	%r9, %r9
        adcxq	%rax, %r8
        adcxq	%rcx, %r9
        movq	%r8, 80(%rdi)
        movq	%r9, 88(%rdi)
        movq	%r12, -40(%rdi)
        movq	%r13, -32(%rdi)
        movq	%r14, -24(%rdi)
        movq	%r15, -16(%rdi)
        movq	%rbx, -8(%rdi)
        subq	$0x60, %rdi
        cmpq	%rdi, %rsi
        jne	L_end_3072_sqr_avx2_12
        vmovdqu	(%rbp), %xmm0
        vmovups	%xmm0, (%rdi)
        vmovdqu	16(%rbp), %xmm0
        vmovups	%xmm0, 16(%rdi)
        vmovdqu	32(%rbp), %xmm0
        vmovups	%xmm0, 32(%rdi)
        movq	48(%rbp), %rax
        movq	%rax, 48(%rdi)
L_end_3072_sqr_avx2_12:
        addq	$0x60, %rsp
        popq	%rbx
        popq	%r15
        popq	%r14
        popq	%r13
        popq	%r12
        popq	%rbp
        repz retq
#ifndef __APPLE__
.size	sp_3072_sqr_avx2_12,.-sp_3072_sqr_avx2_12
#endif /* __APPLE__ */
#endif /* HAVE_INTEL_AVX2 */
/* Square a and put result in r. (r = a * a)
 *
 * Karatsuba: ah^2, al^2, (al - ah)^2
 *
 * r  A single precision integer.
 * a  A single precision integer.
 */
#ifndef __APPLE__
.text
.globl	sp_3072_sqr_24
.type	sp_3072_sqr_24,@function
.align	16
sp_3072_sqr_24:
#else
.section	__TEXT,__text
.globl	_sp_3072_sqr_24
.p2align	4
_sp_3072_sqr_24:
#endif /* __APPLE__ */
        subq	$0xd0, %rsp
        movq	%rdi, 192(%rsp)
        movq	%rsi, 200(%rsp)
        movq	$0x00, %rcx
        movq	%rsp, %r8
        leaq	96(%rsi), %r9
        movq	(%rsi), %rdx
        subq	(%r9), %rdx
        movq	8(%rsi), %rax
        movq	%rdx, (%r8)
        sbbq	8(%r9), %rax
        movq	16(%rsi), %rdx
        movq	%rax, 8(%r8)
        sbbq	16(%r9), %rdx
        movq	24(%rsi), %rax
        movq	%rdx, 16(%r8)
        sbbq	24(%r9), %rax
        movq	32(%rsi), %rdx
        movq	%rax, 24(%r8)
        sbbq	32(%r9), %rdx
        movq	40(%rsi), %rax
        movq	%rdx, 32(%r8)
        sbbq	40(%r9), %rax
        movq	48(%rsi), %rdx
        movq	%rax, 40(%r8)
        sbbq	48(%r9), %rdx
        movq	56(%rsi), %rax
        movq	%rdx, 48(%r8)
        sbbq	56(%r9), %rax
        movq	64(%rsi), %rdx
        movq	%rax, 56(%r8)
        sbbq	64(%r9), %rdx
        movq	72(%rsi), %rax
        movq	%rdx, 64(%r8)
        sbbq	72(%r9), %rax
        movq	80(%rsi), %rdx
        movq	%rax, 72(%r8)
        sbbq	80(%r9), %rdx
        movq	88(%rsi), %rax
        movq	%rdx, 80(%r8)
        sbbq	88(%r9), %rax
        movq	%rax, 88(%r8)
        sbbq	$0x00, %rcx
        # Cond Negate
        movq	(%r8), %rdx
        movq	%rcx, %r9
        xorq	%rcx, %rdx
        negq	%r9
        subq	%rcx, %rdx
        movq	8(%r8), %rax
        sbbq	$0x00, %r9
        movq	%rdx, (%r8)
        xorq	%rcx, %rax
        addq	%r9, %rax
        movq	16(%r8), %rdx
        setc	%r9b
        movq	%rax, 8(%r8)
        xorq	%rcx, %rdx
        addq	%r9, %rdx
        movq	24(%r8), %rax
        setc	%r9b
        movq	%rdx, 16(%r8)
        xorq	%rcx, %rax
        addq	%r9, %rax
        movq	32(%r8), %rdx
        setc	%r9b
        movq	%rax, 24(%r8)
        xorq	%rcx, %rdx
        addq	%r9, %rdx
        movq	40(%r8), %rax
        setc	%r9b
        movq	%rdx, 32(%r8)
        xorq	%rcx, %rax
        addq	%r9, %rax
        movq	48(%r8), %rdx
        setc	%r9b
        movq	%rax, 40(%r8)
        xorq	%rcx, %rdx
        addq	%r9, %rdx
        movq	56(%r8), %rax
        setc	%r9b
        movq	%rdx, 48(%r8)
        xorq	%rcx, %rax
        addq	%r9, %rax
        movq	64(%r8), %rdx
        setc	%r9b
        movq	%rax, 56(%r8)
        xorq	%rcx, %rdx
        addq	%r9, %rdx
        movq	72(%r8), %rax
        setc	%r9b
        movq	%rdx, 64(%r8)
        xorq	%rcx, %rax
        addq	%r9, %rax
        movq	80(%r8), %rdx
        setc	%r9b
        movq	%rax, 72(%r8)
        xorq	%rcx, %rdx
        addq	%r9, %rdx
        movq	88(%r8), %rax
        setc	%r9b
        movq	%rdx, 80(%r8)
        xorq	%rcx, %rax
        addq	%r9, %rax
        movq	%rax, 88(%r8)
        movq	%r8, %rsi
        movq	%rsp, %rdi
#ifndef __APPLE__
        callq	sp_3072_sqr_12@plt
#else
        callq	_sp_3072_sqr_12
#endif /* __APPLE__ */
        movq	200(%rsp), %rsi
        movq	192(%rsp), %rdi
        addq	$0x60, %rsi
        addq	$0xc0, %rdi
#ifndef __APPLE__
        callq	sp_3072_sqr_12@plt
#else
        callq	_sp_3072_sqr_12
#endif /* __APPLE__ */
        movq	200(%rsp), %rsi
        movq	192(%rsp), %rdi
#ifndef __APPLE__
        callq	sp_3072_sqr_12@plt
#else
        callq	_sp_3072_sqr_12
#endif /* __APPLE__ */
#ifdef _WIN64
        movq	200(%rsp), %rsi
        movq	192(%rsp), %rdi
#endif /* _WIN64 */
        movq	192(%rsp), %rsi
        leaq	96(%rsp), %r8
        addq	$0x120, %rsi
        movq	$0x00, %rcx
        movq	-96(%r8), %rax
        subq	-96(%rsi), %rax
        movq	-88(%r8), %rdx
        movq	%rax, -96(%r8)
        sbbq	-88(%rsi), %rdx
        movq	-80(%r8), %rax
        movq	%rdx, -88(%r8)
        sbbq	-80(%rsi), %rax
        movq	-72(%r8), %rdx
        movq	%rax, -80(%r8)
        sbbq	-72(%rsi), %rdx
        movq	-64(%r8), %rax
        movq	%rdx, -72(%r8)
        sbbq	-64(%rsi), %rax
        movq	-56(%r8), %rdx
        movq	%rax, -64(%r8)
        sbbq	-56(%rsi), %rdx
        movq	-48(%r8), %rax
        movq	%rdx, -56(%r8)
        sbbq	-48(%rsi), %rax
        movq	-40(%r8), %rdx
        movq	%rax, -48(%r8)
        sbbq	-40(%rsi), %rdx
        movq	-32(%r8), %rax
        movq	%rdx, -40(%r8)
        sbbq	-32(%rsi), %rax
        movq	-24(%r8), %rdx
        movq	%rax, -32(%r8)
        sbbq	-24(%rsi), %rdx
        movq	-16(%r8), %rax
        movq	%rdx, -24(%r8)
        sbbq	-16(%rsi), %rax
        movq	-8(%r8), %rdx
        movq	%rax, -16(%r8)
        sbbq	-8(%rsi), %rdx
        movq	(%r8), %rax
        movq	%rdx, -8(%r8)
        sbbq	(%rsi), %rax
        movq	8(%r8), %rdx
        movq	%rax, (%r8)
        sbbq	8(%rsi), %rdx
        movq	16(%r8), %rax
        movq	%rdx, 8(%r8)
        sbbq	16(%rsi), %rax
        movq	24(%r8), %rdx
        movq	%rax, 16(%r8)
        sbbq	24(%rsi), %rdx
        movq	32(%r8), %rax
        movq	%rdx, 24(%r8)
        sbbq	32(%rsi), %rax
        movq	40(%r8), %rdx
        movq	%rax, 32(%r8)
        sbbq	40(%rsi), %rdx
        movq	48(%r8), %rax
        movq	%rdx, 40(%r8)
        sbbq	48(%rsi), %rax
        movq	56(%r8), %rdx
        movq	%rax, 48(%r8)
        sbbq	56(%rsi), %rdx
        movq	64(%r8), %rax
        movq	%rdx, 56(%r8)
        sbbq	64(%rsi), %rax
        movq	72(%r8), %rdx
        movq	%rax, 64(%r8)
        sbbq	72(%rsi), %rdx
        movq	80(%r8), %rax
        movq	%rdx, 72(%r8)
        sbbq	80(%rsi), %rax
        movq	88(%r8), %rdx
        movq	%rax, 80(%r8)
        sbbq	88(%rsi), %rdx
        movq	%rdx, 88(%r8)
        sbbq	$0x00, %rcx
        subq	$0xc0, %rsi
        movq	-96(%r8), %rax
        subq	-96(%rsi), %rax
        movq	-88(%r8), %rdx
        movq	%rax, -96(%r8)
        sbbq	-88(%rsi), %rdx
        movq	-80(%r8), %rax
        movq	%rdx, -88(%r8)
        sbbq	-80(%rsi), %rax
        movq	-72(%r8), %rdx
        movq	%rax, -80(%r8)
        sbbq	-72(%rsi), %rdx
        movq	-64(%r8), %rax
        movq	%rdx, -72(%r8)
        sbbq	-64(%rsi), %rax
        movq	-56(%r8), %rdx
        movq	%rax, -64(%r8)
        sbbq	-56(%rsi), %rdx
        movq	-48(%r8), %rax
        movq	%rdx, -56(%r8)
        sbbq	-48(%rsi), %rax
        movq	-40(%r8), %rdx
        movq	%rax, -48(%r8)
        sbbq	-40(%rsi), %rdx
        movq	-32(%r8), %rax
        movq	%rdx, -40(%r8)
        sbbq	-32(%rsi), %rax
        movq	-24(%r8), %rdx
        movq	%rax, -32(%r8)
        sbbq	-24(%rsi), %rdx
        movq	-16(%r8), %rax
        movq	%rdx, -24(%r8)
        sbbq	-16(%rsi), %rax
        movq	-8(%r8), %rdx
        movq	%rax, -16(%r8)
        sbbq	-8(%rsi), %rdx
        movq	(%r8), %rax
        movq	%rdx, -8(%r8)
        sbbq	(%rsi), %rax
        movq	8(%r8), %rdx
        movq	%rax, (%r8)
        sbbq	8(%rsi), %rdx
        movq	16(%r8), %rax
        movq	%rdx, 8(%r8)
        sbbq	16(%rsi), %rax
        movq	24(%r8), %rdx
        movq	%rax, 16(%r8)
        sbbq	24(%rsi), %rdx
        movq	32(%r8), %rax
        movq	%rdx, 24(%r8)
        sbbq	32(%rsi), %rax
        movq	40(%r8), %rdx
        movq	%rax, 32(%r8)
        sbbq	40(%rsi), %rdx
        movq	48(%r8), %rax
        movq	%rdx, 40(%r8)
        sbbq	48(%rsi), %rax
        movq	56(%r8), %rdx
        movq	%rax, 48(%r8)
        sbbq	56(%rsi), %rdx
        movq	64(%r8), %rax
        movq	%rdx, 56(%r8)
        sbbq	64(%rsi), %rax
        movq	72(%r8), %rdx
        movq	%rax, 64(%r8)
        sbbq	72(%rsi), %rdx
        movq	80(%r8), %rax
        movq	%rdx, 72(%r8)
        sbbq	80(%rsi), %rax
        movq	88(%r8), %rdx
        movq	%rax, 80(%r8)
        sbbq	88(%rsi), %rdx
        movq	%rdx, 88(%r8)
        sbbq	$0x00, %rcx
        movq	192(%rsp), %rdi
        negq	%rcx
        addq	$0xc0, %rdi
        movq	-96(%rdi), %rax
        subq	-96(%r8), %rax
        movq	-88(%rdi), %rdx
        movq	%rax, -96(%rdi)
        sbbq	-88(%r8), %rdx
        movq	-80(%rdi), %rax
        movq	%rdx, -88(%rdi)
        sbbq	-80(%r8), %rax
        movq	-72(%rdi), %rdx
        movq	%rax, -80(%rdi)
        sbbq	-72(%r8), %rdx
        movq	-64(%rdi), %rax
        movq	%rdx, -72(%rdi)
        sbbq	-64(%r8), %rax
        movq	-56(%rdi), %rdx
        movq	%rax, -64(%rdi)
        sbbq	-56(%r8), %rdx
        movq	-48(%rdi), %rax
        movq	%rdx, -56(%rdi)
        sbbq	-48(%r8), %rax
        movq	-40(%rdi), %rdx
        movq	%rax, -48(%rdi)
        sbbq	-40(%r8), %rdx
        movq	-32(%rdi), %rax
        movq	%rdx, -40(%rdi)
        sbbq	-32(%r8), %rax
        movq	-24(%rdi), %rdx
        movq	%rax, -32(%rdi)
        sbbq	-24(%r8), %rdx
        movq	-16(%rdi), %rax
        movq	%rdx, -24(%rdi)
        sbbq	-16(%r8), %rax
        movq	-8(%rdi), %rdx
        movq	%rax, -16(%rdi)
        sbbq	-8(%r8), %rdx
        movq	(%rdi), %rax
        movq	%rdx, -8(%rdi)
        sbbq	(%r8), %rax
        movq	8(%rdi), %rdx
        movq	%rax, (%rdi)
        sbbq	8(%r8), %rdx
        movq	16(%rdi), %rax
        movq	%rdx, 8(%rdi)
        sbbq	16(%r8), %rax
        movq	24(%rdi), %rdx
        movq	%rax, 16(%rdi)
        sbbq	24(%r8), %rdx
        movq	32(%rdi), %rax
        movq	%rdx, 24(%rdi)
        sbbq	32(%r8), %rax
        movq	40(%rdi), %rdx
        movq	%rax, 32(%rdi)
        sbbq	40(%r8), %rdx
        movq	48(%rdi), %rax
        movq	%rdx, 40(%rdi)
        sbbq	48(%r8), %rax
        movq	56(%rdi), %rdx
        movq	%rax, 48(%rdi)
        sbbq	56(%r8), %rdx
        movq	64(%rdi), %rax
        movq	%rdx, 56(%rdi)
        sbbq	64(%r8), %rax
        movq	72(%rdi), %rdx
        movq	%rax, 64(%rdi)
        sbbq	72(%r8), %rdx
        movq	80(%rdi), %rax
        movq	%rdx, 72(%rdi)
        sbbq	80(%r8), %rax
        movq	88(%rdi), %rdx
        movq	%rax, 80(%rdi)
        sbbq	88(%r8), %rdx
        movq	%rdx, 88(%rdi)
        sbbq	$0x00, %rcx
        movq	192(%rsp), %rdi
        addq	$0x120, %rdi
        # Add in word
        movq	(%rdi), %rax
        addq	%rcx, %rax
        movq	8(%rdi), %rdx
        movq	%rax, (%rdi)
        adcq	$0x00, %rdx
        movq	16(%rdi), %rax
        movq	%rdx, 8(%rdi)
        adcq	$0x00, %rax
        movq	24(%rdi), %rdx
        movq	%rax, 16(%rdi)
        adcq	$0x00, %rdx
        movq	32(%rdi), %rax
        movq	%rdx, 24(%rdi)
        adcq	$0x00, %rax
        movq	40(%rdi), %rdx
        movq	%rax, 32(%rdi)
        adcq	$0x00, %rdx
        movq	48(%rdi), %rax
        movq	%rdx, 40(%rdi)
        adcq	$0x00, %rax
        movq	56(%rdi), %rdx
        movq	%rax, 48(%rdi)
        adcq	$0x00, %rdx
        movq	64(%rdi), %rax
        movq	%rdx, 56(%rdi)
        adcq	$0x00, %rax
        movq	72(%rdi), %rdx
        movq	%rax, 64(%rdi)
        adcq	$0x00, %rdx
        movq	80(%rdi), %rax
        movq	%rdx, 72(%rdi)
        adcq	$0x00, %rax
        movq	88(%rdi), %rdx
        movq	%rax, 80(%rdi)
        adcq	$0x00, %rdx
        movq	%rdx, 88(%rdi)
        movq	200(%rsp), %rsi
        movq	192(%rsp), %rdi
        addq	$0xd0, %rsp
        repz retq
#ifndef __APPLE__
.size	sp_3072_sqr_24,.-sp_3072_sqr_24
#endif /* __APPLE__ */
#ifdef HAVE_INTEL_AVX2
/* Square a and put result in r. (r = a * a)
 *
 * Karatsuba: ah^2, al^2, (al - ah)^2
 *
 * r  A single precision integer.
 * a  A single precision integer.
 */
#ifndef __APPLE__
.text
.globl	sp_3072_sqr_avx2_24
.type	sp_3072_sqr_avx2_24,@function
.align	16
sp_3072_sqr_avx2_24:
#else
.section	__TEXT,__text
.globl	_sp_3072_sqr_avx2_24
.p2align	4
_sp_3072_sqr_avx2_24:
#endif /* __APPLE__ */
        subq	$0xd0, %rsp
        movq	%rdi, 192(%rsp)
        movq	%rsi, 200(%rsp)
        movq	$0x00, %rcx
        movq	%rsp, %r8
        leaq	96(%rsi), %r9
        movq	(%rsi), %rdx
        subq	(%r9), %rdx
        movq	8(%rsi), %rax
        movq	%rdx, (%r8)
        sbbq	8(%r9), %rax
        movq	16(%rsi), %rdx
        movq	%rax, 8(%r8)
        sbbq	16(%r9), %rdx
        movq	24(%rsi), %rax
        movq	%rdx, 16(%r8)
        sbbq	24(%r9), %rax
        movq	32(%rsi), %rdx
        movq	%rax, 24(%r8)
        sbbq	32(%r9), %rdx
        movq	40(%rsi), %rax
        movq	%rdx, 32(%r8)
        sbbq	40(%r9), %rax
        movq	48(%rsi), %rdx
        movq	%rax, 40(%r8)
        sbbq	48(%r9), %rdx
        movq	56(%rsi), %rax
        movq	%rdx, 48(%r8)
        sbbq	56(%r9), %rax
        movq	64(%rsi), %rdx
        movq	%rax, 56(%r8)
        sbbq	64(%r9), %rdx
        movq	72(%rsi), %rax
        movq	%rdx, 64(%r8)
        sbbq	72(%r9), %rax
        movq	80(%rsi), %rdx
        movq	%rax, 72(%r8)
        sbbq	80(%r9), %rdx
        movq	88(%rsi), %rax
        movq	%rdx, 80(%r8)
        sbbq	88(%r9), %rax
        movq	%rax, 88(%r8)
        sbbq	$0x00, %rcx
        # Cond Negate
        movq	(%r8), %rdx
        movq	%rcx, %r9
        xorq	%rcx, %rdx
        negq	%r9
        subq	%rcx, %rdx
        movq	8(%r8), %rax
        sbbq	$0x00, %r9
        movq	%rdx, (%r8)
        xorq	%rcx, %rax
        addq	%r9, %rax
        movq	16(%r8), %rdx
        setc	%r9b
        movq	%rax, 8(%r8)
        xorq	%rcx, %rdx
        addq	%r9, %rdx
        movq	24(%r8), %rax
        setc	%r9b
        movq	%rdx, 16(%r8)
        xorq	%rcx, %rax
        addq	%r9, %rax
        movq	32(%r8), %rdx
        setc	%r9b
        movq	%rax, 24(%r8)
        xorq	%rcx, %rdx
        addq	%r9, %rdx
        movq	40(%r8), %rax
        setc	%r9b
        movq	%rdx, 32(%r8)
        xorq	%rcx, %rax
        addq	%r9, %rax
        movq	48(%r8), %rdx
        setc	%r9b
        movq	%rax, 40(%r8)
        xorq	%rcx, %rdx
        addq	%r9, %rdx
        movq	56(%r8), %rax
        setc	%r9b
        movq	%rdx, 48(%r8)
        xorq	%rcx, %rax
        addq	%r9, %rax
        movq	64(%r8), %rdx
        setc	%r9b
        movq	%rax, 56(%r8)
        xorq	%rcx, %rdx
        addq	%r9, %rdx
        movq	72(%r8), %rax
        setc	%r9b
        movq	%rdx, 64(%r8)
        xorq	%rcx, %rax
        addq	%r9, %rax
        movq	80(%r8), %rdx
        setc	%r9b
        movq	%rax, 72(%r8)
        xorq	%rcx, %rdx
        addq	%r9, %rdx
        movq	88(%r8), %rax
        setc	%r9b
        movq	%rdx, 80(%r8)
        xorq	%rcx, %rax
        addq	%r9, %rax
        movq	%rax, 88(%r8)
        movq	%r8, %rsi
        movq	%rsp, %rdi
#ifndef __APPLE__
        callq	sp_3072_sqr_avx2_12@plt
#else
        callq	_sp_3072_sqr_avx2_12
#endif /* __APPLE__ */
        movq	200(%rsp), %rsi
        movq	192(%rsp), %rdi
        addq	$0x60, %rsi
        addq	$0xc0, %rdi
#ifndef __APPLE__
        callq	sp_3072_sqr_avx2_12@plt
#else
        callq	_sp_3072_sqr_avx2_12
#endif /* __APPLE__ */
        movq	200(%rsp), %rsi
        movq	192(%rsp), %rdi
#ifndef __APPLE__
        callq	sp_3072_sqr_avx2_12@plt
#else
        callq	_sp_3072_sqr_avx2_12
#endif /* __APPLE__ */
#ifdef _WIN64
        movq	200(%rsp), %rsi
        movq	192(%rsp), %rdi
#endif /* _WIN64 */
        movq	192(%rsp), %rsi
        leaq	96(%rsp), %r8
        addq	$0x120, %rsi
        movq	$0x00, %rcx
        movq	-96(%r8), %rax
        subq	-96(%rsi), %rax
        movq	-88(%r8), %rdx
        movq	%rax, -96(%r8)
        sbbq	-88(%rsi), %rdx
        movq	-80(%r8), %rax
        movq	%rdx, -88(%r8)
        sbbq	-80(%rsi), %rax
        movq	-72(%r8), %rdx
        movq	%rax, -80(%r8)
        sbbq	-72(%rsi), %rdx
        movq	-64(%r8), %rax
        movq	%rdx, -72(%r8)
        sbbq	-64(%rsi), %rax
        movq	-56(%r8), %rdx
        movq	%rax, -64(%r8)
        sbbq	-56(%rsi), %rdx
        movq	-48(%r8), %rax
        movq	%rdx, -56(%r8)
        sbbq	-48(%rsi), %rax
        movq	-40(%r8), %rdx
        movq	%rax, -48(%r8)
        sbbq	-40(%rsi), %rdx
        movq	-32(%r8), %rax
        movq	%rdx, -40(%r8)
        sbbq	-32(%rsi), %rax
        movq	-24(%r8), %rdx
        movq	%rax, -32(%r8)
        sbbq	-24(%rsi), %rdx
        movq	-16(%r8), %rax
        movq	%rdx, -24(%r8)
        sbbq	-16(%rsi), %rax
        movq	-8(%r8), %rdx
        movq	%rax, -16(%r8)
        sbbq	-8(%rsi), %rdx
        movq	(%r8), %rax
        movq	%rdx, -8(%r8)
        sbbq	(%rsi), %rax
        movq	8(%r8), %rdx
        movq	%rax, (%r8)
        sbbq	8(%rsi), %rdx
        movq	16(%r8), %rax
        movq	%rdx, 8(%r8)
        sbbq	16(%rsi), %rax
        movq	24(%r8), %rdx
        movq	%rax, 16(%r8)
        sbbq	24(%rsi), %rdx
        movq	32(%r8), %rax
        movq	%rdx, 24(%r8)
        sbbq	32(%rsi), %rax
        movq	40(%r8), %rdx
        movq	%rax, 32(%r8)
        sbbq	40(%rsi), %rdx
        movq	48(%r8), %rax
        movq	%rdx, 40(%r8)
        sbbq	48(%rsi), %rax
        movq	56(%r8), %rdx
        movq	%rax, 48(%r8)
        sbbq	56(%rsi), %rdx
        movq	64(%r8), %rax
        movq	%rdx, 56(%r8)
        sbbq	64(%rsi), %rax
        movq	72(%r8), %rdx
        movq	%rax, 64(%r8)
        sbbq	72(%rsi), %rdx
        movq	80(%r8), %rax
        movq	%rdx, 72(%r8)
        sbbq	80(%rsi), %rax
        movq	88(%r8), %rdx
        movq	%rax, 80(%r8)
        sbbq	88(%rsi), %rdx
        movq	%rdx, 88(%r8)
        sbbq	$0x00, %rcx
        subq	$0xc0, %rsi
        movq	-96(%r8), %rax
        subq	-96(%rsi), %rax
        movq	-88(%r8), %rdx
        movq	%rax, -96(%r8)
        sbbq	-88(%rsi), %rdx
        movq	-80(%r8), %rax
        movq	%rdx, -88(%r8)
        sbbq	-80(%rsi), %rax
        movq	-72(%r8), %rdx
        movq	%rax, -80(%r8)
        sbbq	-72(%rsi), %rdx
        movq	-64(%r8), %rax
        movq	%rdx, -72(%r8)
        sbbq	-64(%rsi), %rax
        movq	-56(%r8), %rdx
        movq	%rax, -64(%r8)
        sbbq	-56(%rsi), %rdx
        movq	-48(%r8), %rax
        movq	%rdx, -56(%r8)
        sbbq	-48(%rsi), %rax
        movq	-40(%r8), %rdx
        movq	%rax, -48(%r8)
        sbbq	-40(%rsi), %rdx
        movq	-32(%r8), %rax
        movq	%rdx, -40(%r8)
        sbbq	-32(%rsi), %rax
        movq	-24(%r8), %rdx
        movq	%rax, -32(%r8)
        sbbq	-24(%rsi), %rdx
        movq	-16(%r8), %rax
        movq	%rdx, -24(%r8)
        sbbq	-16(%rsi), %rax
        movq	-8(%r8), %rdx
        movq	%rax, -16(%r8)
        sbbq	-8(%rsi), %rdx
        movq	(%r8), %rax
        movq	%rdx, -8(%r8)
        sbbq	(%rsi), %rax
        movq	8(%r8), %rdx
        movq	%rax, (%r8)
        sbbq	8(%rsi), %rdx
        movq	16(%r8), %rax
        movq	%rdx, 8(%r8)
        sbbq	16(%rsi), %rax
        movq	24(%r8), %rdx
        movq	%rax, 16(%r8)
        sbbq	24(%rsi), %rdx
        movq	32(%r8), %rax
        movq	%rdx, 24(%r8)
        sbbq	32(%rsi), %rax
        movq	40(%r8), %rdx
        movq	%rax, 32(%r8)
        sbbq	40(%rsi), %rdx
        movq	48(%r8), %rax
        movq	%rdx, 40(%r8)
        sbbq	48(%rsi), %rax
        movq	56(%r8), %rdx
        movq	%rax, 48(%r8)
        sbbq	56(%rsi), %rdx
        movq	64(%r8), %rax
        movq	%rdx, 56(%r8)
        sbbq	64(%rsi), %rax
        movq	72(%r8), %rdx
        movq	%rax, 64(%r8)
        sbbq	72(%rsi), %rdx
        movq	80(%r8), %rax
        movq	%rdx, 72(%r8)
        sbbq	80(%rsi), %rax
        movq	88(%r8), %rdx
        movq	%rax, 80(%r8)
        sbbq	88(%rsi), %rdx
        movq	%rdx, 88(%r8)
        sbbq	$0x00, %rcx
        movq	192(%rsp), %rdi
        negq	%rcx
        addq	$0xc0, %rdi
        movq	-96(%rdi), %rax
        subq	-96(%r8), %rax
        movq	-88(%rdi), %rdx
        movq	%rax, -96(%rdi)
        sbbq	-88(%r8), %rdx
        movq	-80(%rdi), %rax
        movq	%rdx, -88(%rdi)
        sbbq	-80(%r8), %rax
        movq	-72(%rdi), %rdx
        movq	%rax, -80(%rdi)
        sbbq	-72(%r8), %rdx
        movq	-64(%rdi), %rax
        movq	%rdx, -72(%rdi)
        sbbq	-64(%r8), %rax
        movq	-56(%rdi), %rdx
        movq	%rax, -64(%rdi)
        sbbq	-56(%r8), %rdx
        movq	-48(%rdi), %rax
        movq	%rdx, -56(%rdi)
        sbbq	-48(%r8), %rax
        movq	-40(%rdi), %rdx
        movq	%rax, -48(%rdi)
        sbbq	-40(%r8), %rdx
        movq	-32(%rdi), %rax
        movq	%rdx, -40(%rdi)
        sbbq	-32(%r8), %rax
        movq	-24(%rdi), %rdx
        movq	%rax, -32(%rdi)
        sbbq	-24(%r8), %rdx
        movq	-16(%rdi), %rax
        movq	%rdx, -24(%rdi)
        sbbq	-16(%r8), %rax
        movq	-8(%rdi), %rdx
        movq	%rax, -16(%rdi)
        sbbq	-8(%r8), %rdx
        movq	(%rdi), %rax
        movq	%rdx, -8(%rdi)
        sbbq	(%r8), %rax
        movq	8(%rdi), %rdx
        movq	%rax, (%rdi)
        sbbq	8(%r8), %rdx
        movq	16(%rdi), %rax
        movq	%rdx, 8(%rdi)
        sbbq	16(%r8), %rax
        movq	24(%rdi), %rdx
        movq	%rax, 16(%rdi)
        sbbq	24(%r8), %rdx
        movq	32(%rdi), %rax
        movq	%rdx, 24(%rdi)
        sbbq	32(%r8), %rax
        movq	40(%rdi), %rdx
        movq	%rax, 32(%rdi)
        sbbq	40(%r8), %rdx
        movq	48(%rdi), %rax
        movq	%rdx, 40(%rdi)
        sbbq	48(%r8), %rax
        movq	56(%rdi), %rdx
        movq	%rax, 48(%rdi)
        sbbq	56(%r8), %rdx
        movq	64(%rdi), %rax
        movq	%rdx, 56(%rdi)
        sbbq	64(%r8), %rax
        movq	72(%rdi), %rdx
        movq	%rax, 64(%rdi)
        sbbq	72(%r8), %rdx
        movq	80(%rdi), %rax
        movq	%rdx, 72(%rdi)
        sbbq	80(%r8), %rax
        movq	88(%rdi), %rdx
        movq	%rax, 80(%rdi)
        sbbq	88(%r8), %rdx
        movq	%rdx, 88(%rdi)
        sbbq	$0x00, %rcx
        movq	192(%rsp), %rdi
        addq	$0x120, %rdi
        # Add in word
        movq	(%rdi), %rax
        addq	%rcx, %rax
        movq	8(%rdi), %rdx
        movq	%rax, (%rdi)
        adcq	$0x00, %rdx
        movq	16(%rdi), %rax
        movq	%rdx, 8(%rdi)
        adcq	$0x00, %rax
        movq	24(%rdi), %rdx
        movq	%rax, 16(%rdi)
        adcq	$0x00, %rdx
        movq	32(%rdi), %rax
        movq	%rdx, 24(%rdi)
        adcq	$0x00, %rax
        movq	40(%rdi), %rdx
        movq	%rax, 32(%rdi)
        adcq	$0x00, %rdx
        movq	48(%rdi), %rax
        movq	%rdx, 40(%rdi)
        adcq	$0x00, %rax
        movq	56(%rdi), %rdx
        movq	%rax, 48(%rdi)
        adcq	$0x00, %rdx
        movq	64(%rdi), %rax
        movq	%rdx, 56(%rdi)
        adcq	$0x00, %rax
        movq	72(%rdi), %rdx
        movq	%rax, 64(%rdi)
        adcq	$0x00, %rdx
        movq	80(%rdi), %rax
        movq	%rdx, 72(%rdi)
        adcq	$0x00, %rax
        movq	88(%rdi), %rdx
        movq	%rax, 80(%rdi)
        adcq	$0x00, %rdx
        movq	%rdx, 88(%rdi)
        movq	200(%rsp), %rsi
        movq	192(%rsp), %rdi
        addq	$0xd0, %rsp
        repz retq
#ifndef __APPLE__
.size	sp_3072_sqr_avx2_24,.-sp_3072_sqr_avx2_24
#endif /* __APPLE__ */
#endif /* HAVE_INTEL_AVX2 */
/* Square a and put result in r. (r = a * a)
 *
 * Karatsuba: ah^2, al^2, (al - ah)^2
 *
 * r  A single precision integer.
 * a  A single precision integer.
 */
#ifndef __APPLE__
.text
.globl	sp_3072_sqr_48
.type	sp_3072_sqr_48,@function
.align	16
sp_3072_sqr_48:
#else
.section	__TEXT,__text
.globl	_sp_3072_sqr_48
.p2align	4
_sp_3072_sqr_48:
#endif /* __APPLE__ */
        subq	$0x190, %rsp
        movq	%rdi, 384(%rsp)
        movq	%rsi, 392(%rsp)
        movq	$0x00, %rcx
        movq	%rsp, %r8
        leaq	192(%rsi), %r9
        movq	(%rsi), %rdx
        subq	(%r9), %rdx
        movq	8(%rsi), %rax
        movq	%rdx, (%r8)
        sbbq	8(%r9), %rax
        movq	16(%rsi), %rdx
        movq	%rax, 8(%r8)
        sbbq	16(%r9), %rdx
        movq	24(%rsi), %rax
        movq	%rdx, 16(%r8)
        sbbq	24(%r9), %rax
        movq	32(%rsi), %rdx
        movq	%rax, 24(%r8)
        sbbq	32(%r9), %rdx
        movq	40(%rsi), %rax
        movq	%rdx, 32(%r8)
        sbbq	40(%r9), %rax
        movq	48(%rsi), %rdx
        movq	%rax, 40(%r8)
        sbbq	48(%r9), %rdx
        movq	56(%rsi), %rax
        movq	%rdx, 48(%r8)
        sbbq	56(%r9), %rax
        movq	64(%rsi), %rdx
        movq	%rax, 56(%r8)
        sbbq	64(%r9), %rdx
        movq	72(%rsi), %rax
        movq	%rdx, 64(%r8)
        sbbq	72(%r9), %rax
        movq	80(%rsi), %rdx
        movq	%rax, 72(%r8)
        sbbq	80(%r9), %rdx
        movq	88(%rsi), %rax
        movq	%rdx, 80(%r8)
        sbbq	88(%r9), %rax
        movq	96(%rsi), %rdx
        movq	%rax, 88(%r8)
        sbbq	96(%r9), %rdx
        movq	104(%rsi), %rax
        movq	%rdx, 96(%r8)
        sbbq	104(%r9), %rax
        movq	112(%rsi), %rdx
        movq	%rax, 104(%r8)
        sbbq	112(%r9), %rdx
        movq	120(%rsi), %rax
        movq	%rdx, 112(%r8)
        sbbq	120(%r9), %rax
        movq	128(%rsi), %rdx
        movq	%rax, 120(%r8)
        sbbq	128(%r9), %rdx
        movq	136(%rsi), %rax
        movq	%rdx, 128(%r8)
        sbbq	136(%r9), %rax
        movq	144(%rsi), %rdx
        movq	%rax, 136(%r8)
        sbbq	144(%r9), %rdx
        movq	152(%rsi), %rax
        movq	%rdx, 144(%r8)
        sbbq	152(%r9), %rax
        movq	160(%rsi), %rdx
        movq	%rax, 152(%r8)
        sbbq	160(%r9), %rdx
        movq	168(%rsi), %rax
        movq	%rdx, 160(%r8)
        sbbq	168(%r9), %rax
        movq	176(%rsi), %rdx
        movq	%rax, 168(%r8)
        sbbq	176(%r9), %rdx
        movq	184(%rsi), %rax
        movq	%rdx, 176(%r8)
        sbbq	184(%r9), %rax
        movq	%rax, 184(%r8)
        sbbq	$0x00, %rcx
        # Cond Negate
        movq	(%r8), %rdx
        movq	%rcx, %r9
        xorq	%rcx, %rdx
        negq	%r9
        subq	%rcx, %rdx
        movq	8(%r8), %rax
        sbbq	$0x00, %r9
        movq	%rdx, (%r8)
        xorq	%rcx, %rax
        addq	%r9, %rax
        movq	16(%r8), %rdx
        setc	%r9b
        movq	%rax, 8(%r8)
        xorq	%rcx, %rdx
        addq	%r9, %rdx
        movq	24(%r8), %rax
        setc	%r9b
        movq	%rdx, 16(%r8)
        xorq	%rcx, %rax
        addq	%r9, %rax
        movq	32(%r8), %rdx
        setc	%r9b
        movq	%rax, 24(%r8)
        xorq	%rcx, %rdx
        addq	%r9, %rdx
        movq	40(%r8), %rax
        setc	%r9b
        movq	%rdx, 32(%r8)
        xorq	%rcx, %rax
        addq	%r9, %rax
        movq	48(%r8), %rdx
        setc	%r9b
        movq	%rax, 40(%r8)
        xorq	%rcx, %rdx
        addq	%r9, %rdx
        movq	56(%r8), %rax
        setc	%r9b
        movq	%rdx, 48(%r8)
        xorq	%rcx, %rax
        addq	%r9, %rax
        movq	64(%r8), %rdx
        setc	%r9b
        movq	%rax, 56(%r8)
        xorq	%rcx, %rdx
        addq	%r9, %rdx
        movq	72(%r8), %rax
        setc	%r9b
        movq	%rdx, 64(%r8)
        xorq	%rcx, %rax
        addq	%r9, %rax
        movq	80(%r8), %rdx
        setc	%r9b
        movq	%rax, 72(%r8)
        xorq	%rcx, %rdx
        addq	%r9, %rdx
        movq	88(%r8), %rax
        setc	%r9b
        movq	%rdx, 80(%r8)
        xorq	%rcx, %rax
        addq	%r9, %rax
        movq	96(%r8), %rdx
        setc	%r9b
        movq	%rax, 88(%r8)
        xorq	%rcx, %rdx
        addq	%r9, %rdx
        movq	104(%r8), %rax
        setc	%r9b
        movq	%rdx, 96(%r8)
        xorq	%rcx, %rax
        addq	%r9, %rax
        movq	112(%r8), %rdx
        setc	%r9b
        movq	%rax, 104(%r8)
        xorq	%rcx, %rdx
        addq	%r9, %rdx
        movq	120(%r8), %rax
        setc	%r9b
        movq	%rdx, 112(%r8)
        xorq	%rcx, %rax
        addq	%r9, %rax
        movq	128(%r8), %rdx
        setc	%r9b
        movq	%rax, 120(%r8)
        xorq	%rcx, %rdx
        addq	%r9, %rdx
        movq	136(%r8), %rax
        setc	%r9b
        movq	%rdx, 128(%r8)
        xorq	%rcx, %rax
        addq	%r9, %rax
        movq	144(%r8), %rdx
        setc	%r9b
        movq	%rax, 136(%r8)
        xorq	%rcx, %rdx
        addq	%r9, %rdx
        movq	152(%r8), %rax
        setc	%r9b
        movq	%rdx, 144(%r8)
        xorq	%rcx, %rax
        addq	%r9, %rax
        movq	160(%r8), %rdx
        setc	%r9b
        movq	%rax, 152(%r8)
        xorq	%rcx, %rdx
        addq	%r9, %rdx
        movq	168(%r8), %rax
        setc	%r9b
        movq	%rdx, 160(%r8)
        xorq	%rcx, %rax
        addq	%r9, %rax
        movq	176(%r8), %rdx
        setc	%r9b
        movq	%rax, 168(%r8)
        xorq	%rcx, %rdx
        addq	%r9, %rdx
        movq	184(%r8), %rax
        setc	%r9b
        movq	%rdx, 176(%r8)
        xorq	%rcx, %rax
        addq	%r9, %rax
        movq	%rax, 184(%r8)
        movq	%r8, %rsi
        movq	%rsp, %rdi
#ifndef __APPLE__
        callq	sp_3072_sqr_24@plt
#else
        callq	_sp_3072_sqr_24
#endif /* __APPLE__ */
        movq	392(%rsp), %rsi
        movq	384(%rsp), %rdi
        addq	$0xc0, %rsi
        addq	$0x180, %rdi
#ifndef __APPLE__
        callq	sp_3072_sqr_24@plt
#else
        callq	_sp_3072_sqr_24
#endif /* __APPLE__ */
        movq	392(%rsp), %rsi
        movq	384(%rsp), %rdi
#ifndef __APPLE__
        callq	sp_3072_sqr_24@plt
#else
        callq	_sp_3072_sqr_24
#endif /* __APPLE__ */
#ifdef _WIN64
        movq	392(%rsp), %rsi
        movq	384(%rsp), %rdi
#endif /* _WIN64 */
        movq	384(%rsp), %rsi
        leaq	192(%rsp), %r8
        addq	$0x240, %rsi
        movq	$0x00, %rcx
        movq	-192(%r8), %rax
        subq	-192(%rsi), %rax
        movq	-184(%r8), %rdx
        movq	%rax, -192(%r8)
        sbbq	-184(%rsi), %rdx
        movq	-176(%r8), %rax
        movq	%rdx, -184(%r8)
        sbbq	-176(%rsi), %rax
        movq	-168(%r8), %rdx
        movq	%rax, -176(%r8)
        sbbq	-168(%rsi), %rdx
        movq	-160(%r8), %rax
        movq	%rdx, -168(%r8)
        sbbq	-160(%rsi), %rax
        movq	-152(%r8), %rdx
        movq	%rax, -160(%r8)
        sbbq	-152(%rsi), %rdx
        movq	-144(%r8), %rax
        movq	%rdx, -152(%r8)
        sbbq	-144(%rsi), %rax
        movq	-136(%r8), %rdx
        movq	%rax, -144(%r8)
        sbbq	-136(%rsi), %rdx
        movq	-128(%r8), %rax
        movq	%rdx, -136(%r8)
        sbbq	-128(%rsi), %rax
        movq	-120(%r8), %rdx
        movq	%rax, -128(%r8)
        sbbq	-120(%rsi), %rdx
        movq	-112(%r8), %rax
        movq	%rdx, -120(%r8)
        sbbq	-112(%rsi), %rax
        movq	-104(%r8), %rdx
        movq	%rax, -112(%r8)
        sbbq	-104(%rsi), %rdx
        movq	-96(%r8), %rax
        movq	%rdx, -104(%r8)
        sbbq	-96(%rsi), %rax
        movq	-88(%r8), %rdx
        movq	%rax, -96(%r8)
        sbbq	-88(%rsi), %rdx
        movq	-80(%r8), %rax
        movq	%rdx, -88(%r8)
        sbbq	-80(%rsi), %rax
        movq	-72(%r8), %rdx
        movq	%rax, -80(%r8)
        sbbq	-72(%rsi), %rdx
        movq	-64(%r8), %rax
        movq	%rdx, -72(%r8)
        sbbq	-64(%rsi), %rax
        movq	-56(%r8), %rdx
        movq	%rax, -64(%r8)
        sbbq	-56(%rsi), %rdx
        movq	-48(%r8), %rax
        movq	%rdx, -56(%r8)
        sbbq	-48(%rsi), %rax
        movq	-40(%r8), %rdx
        movq	%rax, -48(%r8)
        sbbq	-40(%rsi), %rdx
        movq	-32(%r8), %rax
        movq	%rdx, -40(%r8)
        sbbq	-32(%rsi), %rax
        movq	-24(%r8), %rdx
        movq	%rax, -32(%r8)
        sbbq	-24(%rsi), %rdx
        movq	-16(%r8), %rax
        movq	%rdx, -24(%r8)
        sbbq	-16(%rsi), %rax
        movq	-8(%r8), %rdx
        movq	%rax, -16(%r8)
        sbbq	-8(%rsi), %rdx
        movq	(%r8), %rax
        movq	%rdx, -8(%r8)
        sbbq	(%rsi), %rax
        movq	8(%r8), %rdx
        movq	%rax, (%r8)
        sbbq	8(%rsi), %rdx
        movq	16(%r8), %rax
        movq	%rdx, 8(%r8)
        sbbq	16(%rsi), %rax
        movq	24(%r8), %rdx
        movq	%rax, 16(%r8)
        sbbq	24(%rsi), %rdx
        movq	32(%r8), %rax
        movq	%rdx, 24(%r8)
        sbbq	32(%rsi), %rax
        movq	40(%r8), %rdx
        movq	%rax, 32(%r8)
        sbbq	40(%rsi), %rdx
        movq	48(%r8), %rax
        movq	%rdx, 40(%r8)
        sbbq	48(%rsi), %rax
        movq	56(%r8), %rdx
        movq	%rax, 48(%r8)
        sbbq	56(%rsi), %rdx
        movq	64(%r8), %rax
        movq	%rdx, 56(%r8)
        sbbq	64(%rsi), %rax
        movq	72(%r8), %rdx
        movq	%rax, 64(%r8)
        sbbq	72(%rsi), %rdx
        movq	80(%r8), %rax
        movq	%rdx, 72(%r8)
        sbbq	80(%rsi), %rax
        movq	88(%r8), %rdx
        movq	%rax, 80(%r8)
        sbbq	88(%rsi), %rdx
        movq	96(%r8), %rax
        movq	%rdx, 88(%r8)
        sbbq	96(%rsi), %rax
        movq	104(%r8), %rdx
        movq	%rax, 96(%r8)
        sbbq	104(%rsi), %rdx
        movq	112(%r8), %rax
        movq	%rdx, 104(%r8)
        sbbq	112(%rsi), %rax
        movq	120(%r8), %rdx
        movq	%rax, 112(%r8)
        sbbq	120(%rsi), %rdx
        movq	128(%r8), %rax
        movq	%rdx, 120(%r8)
        sbbq	128(%rsi), %rax
        movq	136(%r8), %rdx
        movq	%rax, 128(%r8)
        sbbq	136(%rsi), %rdx
        movq	144(%r8), %rax
        movq	%rdx, 136(%r8)
        sbbq	144(%rsi), %rax
        movq	152(%r8), %rdx
        movq	%rax, 144(%r8)
        sbbq	152(%rsi), %rdx
        movq	160(%r8), %rax
        movq	%rdx, 152(%r8)
        sbbq	160(%rsi), %rax
        movq	168(%r8), %rdx
        movq	%rax, 160(%r8)
        sbbq	168(%rsi), %rdx
        movq	176(%r8), %rax
        movq	%rdx, 168(%r8)
        sbbq	176(%rsi), %rax
        movq	184(%r8), %rdx
        movq	%rax, 176(%r8)
        sbbq	184(%rsi), %rdx
        movq	%rdx, 184(%r8)
        sbbq	$0x00, %rcx
        subq	$0x180, %rsi
        movq	-192(%r8), %rax
        subq	-192(%rsi), %rax
        movq	-184(%r8), %rdx
        movq	%rax, -192(%r8)
        sbbq	-184(%rsi), %rdx
        movq	-176(%r8), %rax
        movq	%rdx, -184(%r8)
        sbbq	-176(%rsi), %rax
        movq	-168(%r8), %rdx
        movq	%rax, -176(%r8)
        sbbq	-168(%rsi), %rdx
        movq	-160(%r8), %rax
        movq	%rdx, -168(%r8)
        sbbq	-160(%rsi), %rax
        movq	-152(%r8), %rdx
        movq	%rax, -160(%r8)
        sbbq	-152(%rsi), %rdx
        movq	-144(%r8), %rax
        movq	%rdx, -152(%r8)
        sbbq	-144(%rsi), %rax
        movq	-136(%r8), %rdx
        movq	%rax, -144(%r8)
        sbbq	-136(%rsi), %rdx
        movq	-128(%r8), %rax
        movq	%rdx, -136(%r8)
        sbbq	-128(%rsi), %rax
        movq	-120(%r8), %rdx
        movq	%rax, -128(%r8)
        sbbq	-120(%rsi), %rdx
        movq	-112(%r8), %rax
        movq	%rdx, -120(%r8)
        sbbq	-112(%rsi), %rax
        movq	-104(%r8), %rdx
        movq	%rax, -112(%r8)
        sbbq	-104(%rsi), %rdx
        movq	-96(%r8), %rax
        movq	%rdx, -104(%r8)
        sbbq	-96(%rsi), %rax
        movq	-88(%r8), %rdx
        movq	%rax, -96(%r8)
        sbbq	-88(%rsi), %rdx
        movq	-80(%r8), %rax
        movq	%rdx, -88(%r8)
        sbbq	-80(%rsi), %rax
        movq	-72(%r8), %rdx
        movq	%rax, -80(%r8)
        sbbq	-72(%rsi), %rdx
        movq	-64(%r8), %rax
        movq	%rdx, -72(%r8)
        sbbq	-64(%rsi), %rax
        movq	-56(%r8), %rdx
        movq	%rax, -64(%r8)
        sbbq	-56(%rsi), %rdx
        movq	-48(%r8), %rax
        movq	%rdx, -56(%r8)
        sbbq	-48(%rsi), %rax
        movq	-40(%r8), %rdx
        movq	%rax, -48(%r8)
        sbbq	-40(%rsi), %rdx
        movq	-32(%r8), %rax
        movq	%rdx, -40(%r8)
        sbbq	-32(%rsi), %rax
        movq	-24(%r8), %rdx
        movq	%rax, -32(%r8)
        sbbq	-24(%rsi), %rdx
        movq	-16(%r8), %rax
        movq	%rdx, -24(%r8)
        sbbq	-16(%rsi), %rax
        movq	-8(%r8), %rdx
        movq	%rax, -16(%r8)
        sbbq	-8(%rsi), %rdx
        movq	(%r8), %rax
        movq	%rdx, -8(%r8)
        sbbq	(%rsi), %rax
        movq	8(%r8), %rdx
        movq	%rax, (%r8)
        sbbq	8(%rsi), %rdx
        movq	16(%r8), %rax
        movq	%rdx, 8(%r8)
        sbbq	16(%rsi), %rax
        movq	24(%r8), %rdx
        movq	%rax, 16(%r8)
        sbbq	24(%rsi), %rdx
        movq	32(%r8), %rax
        movq	%rdx, 24(%r8)
        sbbq	32(%rsi), %rax
        movq	40(%r8), %rdx
        movq	%rax, 32(%r8)
        sbbq	40(%rsi), %rdx
        movq	48(%r8), %rax
        movq	%rdx, 40(%r8)
        sbbq	48(%rsi), %rax
        movq	56(%r8), %rdx
        movq	%rax, 48(%r8)
        sbbq	56(%rsi), %rdx
        movq	64(%r8), %rax
        movq	%rdx, 56(%r8)
        sbbq	64(%rsi), %rax
        movq	72(%r8), %rdx
        movq	%rax, 64(%r8)
        sbbq	72(%rsi), %rdx
        movq	80(%r8), %rax
        movq	%rdx, 72(%r8)
        sbbq	80(%rsi), %rax
        movq	88(%r8), %rdx
        movq	%rax, 80(%r8)
        sbbq	88(%rsi), %rdx
        movq	96(%r8), %rax
        movq	%rdx, 88(%r8)
        sbbq	96(%rsi), %rax
        movq	104(%r8), %rdx
        movq	%rax, 96(%r8)
        sbbq	104(%rsi), %rdx
        movq	112(%r8), %rax
        movq	%rdx, 104(%r8)
        sbbq	112(%rsi), %rax
        movq	120(%r8), %rdx
        movq	%rax, 112(%r8)
        sbbq	120(%rsi), %rdx
        movq	128(%r8), %rax
        movq	%rdx, 120(%r8)
        sbbq	128(%rsi), %rax
        movq	136(%r8), %rdx
        movq	%rax, 128(%r8)
        sbbq	136(%rsi), %rdx
        movq	144(%r8), %rax
        movq	%rdx, 136(%r8)
        sbbq	144(%rsi), %rax
        movq	152(%r8), %rdx
        movq	%rax, 144(%r8)
        sbbq	152(%rsi), %rdx
        movq	160(%r8), %rax
        movq	%rdx, 152(%r8)
        sbbq	160(%rsi), %rax
        movq	168(%r8), %rdx
        movq	%rax, 160(%r8)
        sbbq	168(%rsi), %rdx
        movq	176(%r8), %rax
        movq	%rdx, 168(%r8)
        sbbq	176(%rsi), %rax
        movq	184(%r8), %rdx
        movq	%rax, 176(%r8)
        sbbq	184(%rsi), %rdx
        movq	%rdx, 184(%r8)
        sbbq	$0x00, %rcx
        movq	384(%rsp), %rdi
        negq	%rcx
        addq	$0x180, %rdi
        movq	-192(%rdi), %rax
        subq	-192(%r8), %rax
        movq	-184(%rdi), %rdx
        movq	%rax, -192(%rdi)
        sbbq	-184(%r8), %rdx
        movq	-176(%rdi), %rax
        movq	%rdx, -184(%rdi)
        sbbq	-176(%r8), %rax
        movq	-168(%rdi), %rdx
        movq	%rax, -176(%rdi)
        sbbq	-168(%r8), %rdx
        movq	-160(%rdi), %rax
        movq	%rdx, -168(%rdi)
        sbbq	-160(%r8), %rax
        movq	-152(%rdi), %rdx
        movq	%rax, -160(%rdi)
        sbbq	-152(%r8), %rdx
        movq	-144(%rdi), %rax
        movq	%rdx, -152(%rdi)
        sbbq	-144(%r8), %rax
        movq	-136(%rdi), %rdx
        movq	%rax, -144(%rdi)
        sbbq	-136(%r8), %rdx
        movq	-128(%rdi), %rax
        movq	%rdx, -136(%rdi)
        sbbq	-128(%r8), %rax
        movq	-120(%rdi), %rdx
        movq	%rax, -128(%rdi)
        sbbq	-120(%r8), %rdx
        movq	-112(%rdi), %rax
        movq	%rdx, -120(%rdi)
        sbbq	-112(%r8), %rax
        movq	-104(%rdi), %rdx
        movq	%rax, -112(%rdi)
        sbbq	-104(%r8), %rdx
        movq	-96(%rdi), %rax
        movq	%rdx, -104(%rdi)
        sbbq	-96(%r8), %rax
        movq	-88(%rdi), %rdx
        movq	%rax, -96(%rdi)
        sbbq	-88(%r8), %rdx
        movq	-80(%rdi), %rax
        movq	%rdx, -88(%rdi)
        sbbq	-80(%r8), %rax
        movq	-72(%rdi), %rdx
        movq	%rax, -80(%rdi)
        sbbq	-72(%r8), %rdx
        movq	-64(%rdi), %rax
        movq	%rdx, -72(%rdi)
        sbbq	-64(%r8), %rax
        movq	-56(%rdi), %rdx
        movq	%rax, -64(%rdi)
        sbbq	-56(%r8), %rdx
        movq	-48(%rdi), %rax
        movq	%rdx, -56(%rdi)
        sbbq	-48(%r8), %rax
        movq	-40(%rdi), %rdx
        movq	%rax, -48(%rdi)
        sbbq	-40(%r8), %rdx
        movq	-32(%rdi), %rax
        movq	%rdx, -40(%rdi)
        sbbq	-32(%r8), %rax
        movq	-24(%rdi), %rdx
        movq	%rax, -32(%rdi)
        sbbq	-24(%r8), %rdx
        movq	-16(%rdi), %rax
        movq	%rdx, -24(%rdi)
        sbbq	-16(%r8), %rax
        movq	-8(%rdi), %rdx
        movq	%rax, -16(%rdi)
        sbbq	-8(%r8), %rdx
        movq	(%rdi), %rax
        movq	%rdx, -8(%rdi)
        sbbq	(%r8), %rax
        movq	8(%rdi), %rdx
        movq	%rax, (%rdi)
        sbbq	8(%r8), %rdx
        movq	16(%rdi), %rax
        movq	%rdx, 8(%rdi)
        sbbq	16(%r8), %rax
        movq	24(%rdi), %rdx
        movq	%rax, 16(%rdi)
        sbbq	24(%r8), %rdx
        movq	32(%rdi), %rax
        movq	%rdx, 24(%rdi)
        sbbq	32(%r8), %rax
        movq	40(%rdi), %rdx
        movq	%rax, 32(%rdi)
        sbbq	40(%r8), %rdx
        movq	48(%rdi), %rax
        movq	%rdx, 40(%rdi)
        sbbq	48(%r8), %rax
        movq	56(%rdi), %rdx
        movq	%rax, 48(%rdi)
        sbbq	56(%r8), %rdx
        movq	64(%rdi), %rax
        movq	%rdx, 56(%rdi)
        sbbq	64(%r8), %rax
        movq	72(%rdi), %rdx
        movq	%rax, 64(%rdi)
        sbbq	72(%r8), %rdx
        movq	80(%rdi), %rax
        movq	%rdx, 72(%rdi)
        sbbq	80(%r8), %rax
        movq	88(%rdi), %rdx
        movq	%rax, 80(%rdi)
        sbbq	88(%r8), %rdx
        movq	96(%rdi), %rax
        movq	%rdx, 88(%rdi)
        sbbq	96(%r8), %rax
        movq	104(%rdi), %rdx
        movq	%rax, 96(%rdi)
        sbbq	104(%r8), %rdx
        movq	112(%rdi), %rax
        movq	%rdx, 104(%rdi)
        sbbq	112(%r8), %rax
        movq	120(%rdi), %rdx
        movq	%rax, 112(%rdi)
        sbbq	120(%r8), %rdx
        movq	128(%rdi), %rax
        movq	%rdx, 120(%rdi)
        sbbq	128(%r8), %rax
        movq	136(%rdi), %rdx
        movq	%rax, 128(%rdi)
        sbbq	136(%r8), %rdx
        movq	144(%rdi), %rax
        movq	%rdx, 136(%rdi)
        sbbq	144(%r8), %rax
        movq	152(%rdi), %rdx
        movq	%rax, 144(%rdi)
        sbbq	152(%r8), %rdx
        movq	160(%rdi), %rax
        movq	%rdx, 152(%rdi)
        sbbq	160(%r8), %rax
        movq	168(%rdi), %rdx
        movq	%rax, 160(%rdi)
        sbbq	168(%r8), %rdx
        movq	176(%rdi), %rax
        movq	%rdx, 168(%rdi)
        sbbq	176(%r8), %rax
        movq	184(%rdi), %rdx
        movq	%rax, 176(%rdi)
        sbbq	184(%r8), %rdx
        movq	%rdx, 184(%rdi)
        sbbq	$0x00, %rcx
        movq	384(%rsp), %rdi
        addq	$0x240, %rdi
        # Add in word
        movq	(%rdi), %rax
        addq	%rcx, %rax
        movq	8(%rdi), %rdx
        movq	%rax, (%rdi)
        adcq	$0x00, %rdx
        movq	16(%rdi), %rax
        movq	%rdx, 8(%rdi)
        adcq	$0x00, %rax
        movq	24(%rdi), %rdx
        movq	%rax, 16(%rdi)
        adcq	$0x00, %rdx
        movq	32(%rdi), %rax
        movq	%rdx, 24(%rdi)
        adcq	$0x00, %rax
        movq	40(%rdi), %rdx
        movq	%rax, 32(%rdi)
        adcq	$0x00, %rdx
        movq	48(%rdi), %rax
        movq	%rdx, 40(%rdi)
        adcq	$0x00, %rax
        movq	56(%rdi), %rdx
        movq	%rax, 48(%rdi)
        adcq	$0x00, %rdx
        movq	64(%rdi), %rax
        movq	%rdx, 56(%rdi)
        adcq	$0x00, %rax
        movq	72(%rdi), %rdx
        movq	%rax, 64(%rdi)
        adcq	$0x00, %rdx
        movq	80(%rdi), %rax
        movq	%rdx, 72(%rdi)
        adcq	$0x00, %rax
        movq	88(%rdi), %rdx
        movq	%rax, 80(%rdi)
        adcq	$0x00, %rdx
        movq	96(%rdi), %rax
        movq	%rdx, 88(%rdi)
        adcq	$0x00, %rax
        movq	104(%rdi), %rdx
        movq	%rax, 96(%rdi)
        adcq	$0x00, %rdx
        movq	112(%rdi), %rax
        movq	%rdx, 104(%rdi)
        adcq	$0x00, %rax
        movq	120(%rdi), %rdx
        movq	%rax, 112(%rdi)
        adcq	$0x00, %rdx
        movq	128(%rdi), %rax
        movq	%rdx, 120(%rdi)
        adcq	$0x00, %rax
        movq	136(%rdi), %rdx
        movq	%rax, 128(%rdi)
        adcq	$0x00, %rdx
        movq	144(%rdi), %rax
        movq	%rdx, 136(%rdi)
        adcq	$0x00, %rax
        movq	152(%rdi), %rdx
        movq	%rax, 144(%rdi)
        adcq	$0x00, %rdx
        movq	160(%rdi), %rax
        movq	%rdx, 152(%rdi)
        adcq	$0x00, %rax
        movq	168(%rdi), %rdx
        movq	%rax, 160(%rdi)
        adcq	$0x00, %rdx
        movq	176(%rdi), %rax
        movq	%rdx, 168(%rdi)
        adcq	$0x00, %rax
        movq	184(%rdi), %rdx
        movq	%rax, 176(%rdi)
        adcq	$0x00, %rdx
        movq	%rdx, 184(%rdi)
        movq	392(%rsp), %rsi
        movq	384(%rsp), %rdi
        addq	$0x190, %rsp
        repz retq
#ifndef __APPLE__
.size	sp_3072_sqr_48,.-sp_3072_sqr_48
#endif /* __APPLE__ */
#ifdef HAVE_INTEL_AVX2
/* Square a and put result in r. (r = a * a)
 *
 * Karatsuba: ah^2, al^2, (al - ah)^2
 *
 * r  A single precision integer.
 * a  A single precision integer.
 */
#ifndef __APPLE__
.text
.globl	sp_3072_sqr_avx2_48
.type	sp_3072_sqr_avx2_48,@function
.align	16
sp_3072_sqr_avx2_48:
#else
.section	__TEXT,__text
.globl	_sp_3072_sqr_avx2_48
.p2align	4
_sp_3072_sqr_avx2_48:
#endif /* __APPLE__ */
        subq	$0x190, %rsp
        movq	%rdi, 384(%rsp)
        movq	%rsi, 392(%rsp)
        movq	$0x00, %rcx
        movq	%rsp, %r8
        leaq	192(%rsi), %r9
        movq	(%rsi), %rdx
        subq	(%r9), %rdx
        movq	8(%rsi), %rax
        movq	%rdx, (%r8)
        sbbq	8(%r9), %rax
        movq	16(%rsi), %rdx
        movq	%rax, 8(%r8)
        sbbq	16(%r9), %rdx
        movq	24(%rsi), %rax
        movq	%rdx, 16(%r8)
        sbbq	24(%r9), %rax
        movq	32(%rsi), %rdx
        movq	%rax, 24(%r8)
        sbbq	32(%r9), %rdx
        movq	40(%rsi), %rax
        movq	%rdx, 32(%r8)
        sbbq	40(%r9), %rax
        movq	48(%rsi), %rdx
        movq	%rax, 40(%r8)
        sbbq	48(%r9), %rdx
        movq	56(%rsi), %rax
        movq	%rdx, 48(%r8)
        sbbq	56(%r9), %rax
        movq	64(%rsi), %rdx
        movq	%rax, 56(%r8)
        sbbq	64(%r9), %rdx
        movq	72(%rsi), %rax
        movq	%rdx, 64(%r8)
        sbbq	72(%r9), %rax
        movq	80(%rsi), %rdx
        movq	%rax, 72(%r8)
        sbbq	80(%r9), %rdx
        movq	88(%rsi), %rax
        movq	%rdx, 80(%r8)
        sbbq	88(%r9), %rax
        movq	96(%rsi), %rdx
        movq	%rax, 88(%r8)
        sbbq	96(%r9), %rdx
        movq	104(%rsi), %rax
        movq	%rdx, 96(%r8)
        sbbq	104(%r9), %rax
        movq	112(%rsi), %rdx
        movq	%rax, 104(%r8)
        sbbq	112(%r9), %rdx
        movq	120(%rsi), %rax
        movq	%rdx, 112(%r8)
        sbbq	120(%r9), %rax
        movq	128(%rsi), %rdx
        movq	%rax, 120(%r8)
        sbbq	128(%r9), %rdx
        movq	136(%rsi), %rax
        movq	%rdx, 128(%r8)
        sbbq	136(%r9), %rax
        movq	144(%rsi), %rdx
        movq	%rax, 136(%r8)
        sbbq	144(%r9), %rdx
        movq	152(%rsi), %rax
        movq	%rdx, 144(%r8)
        sbbq	152(%r9), %rax
        movq	160(%rsi), %rdx
        movq	%rax, 152(%r8)
        sbbq	160(%r9), %rdx
        movq	168(%rsi), %rax
        movq	%rdx, 160(%r8)
        sbbq	168(%r9), %rax
        movq	176(%rsi), %rdx
        movq	%rax, 168(%r8)
        sbbq	176(%r9), %rdx
        movq	184(%rsi), %rax
        movq	%rdx, 176(%r8)
        sbbq	184(%r9), %rax
        movq	%rax, 184(%r8)
        sbbq	$0x00, %rcx
        # Cond Negate
        movq	(%r8), %rdx
        movq	%rcx, %r9
        xorq	%rcx, %rdx
        negq	%r9
        subq	%rcx, %rdx
        movq	8(%r8), %rax
        sbbq	$0x00, %r9
        movq	%rdx, (%r8)
        xorq	%rcx, %rax
        addq	%r9, %rax
        movq	16(%r8), %rdx
        setc	%r9b
        movq	%rax, 8(%r8)
        xorq	%rcx, %rdx
        addq	%r9, %rdx
        movq	24(%r8), %rax
        setc	%r9b
        movq	%rdx, 16(%r8)
        xorq	%rcx, %rax
        addq	%r9, %rax
        movq	32(%r8), %rdx
        setc	%r9b
        movq	%rax, 24(%r8)
        xorq	%rcx, %rdx
        addq	%r9, %rdx
        movq	40(%r8), %rax
        setc	%r9b
        movq	%rdx, 32(%r8)
        xorq	%rcx, %rax
        addq	%r9, %rax
        movq	48(%r8), %rdx
        setc	%r9b
        movq	%rax, 40(%r8)
        xorq	%rcx, %rdx
        addq	%r9, %rdx
        movq	56(%r8), %rax
        setc	%r9b
        movq	%rdx, 48(%r8)
        xorq	%rcx, %rax
        addq	%r9, %rax
        movq	64(%r8), %rdx
        setc	%r9b
        movq	%rax, 56(%r8)
        xorq	%rcx, %rdx
        addq	%r9, %rdx
        movq	72(%r8), %rax
        setc	%r9b
        movq	%rdx, 64(%r8)
        xorq	%rcx, %rax
        addq	%r9, %rax
        movq	80(%r8), %rdx
        setc	%r9b
        movq	%rax, 72(%r8)
        xorq	%rcx, %rdx
        addq	%r9, %rdx
        movq	88(%r8), %rax
        setc	%r9b
        movq	%rdx, 80(%r8)
        xorq	%rcx, %rax
        addq	%r9, %rax
        movq	96(%r8), %rdx
        setc	%r9b
        movq	%rax, 88(%r8)
        xorq	%rcx, %rdx
        addq	%r9, %rdx
        movq	104(%r8), %rax
        setc	%r9b
        movq	%rdx, 96(%r8)
        xorq	%rcx, %rax
        addq	%r9, %rax
        movq	112(%r8), %rdx
        setc	%r9b
        movq	%rax, 104(%r8)
        xorq	%rcx, %rdx
        addq	%r9, %rdx
        movq	120(%r8), %rax
        setc	%r9b
        movq	%rdx, 112(%r8)
        xorq	%rcx, %rax
        addq	%r9, %rax
        movq	128(%r8), %rdx
        setc	%r9b
        movq	%rax, 120(%r8)
        xorq	%rcx, %rdx
        addq	%r9, %rdx
        movq	136(%r8), %rax
        setc	%r9b
        movq	%rdx, 128(%r8)
        xorq	%rcx, %rax
        addq	%r9, %rax
        movq	144(%r8), %rdx
        setc	%r9b
        movq	%rax, 136(%r8)
        xorq	%rcx, %rdx
        addq	%r9, %rdx
        movq	152(%r8), %rax
        setc	%r9b
        movq	%rdx, 144(%r8)
        xorq	%rcx, %rax
        addq	%r9, %rax
        movq	160(%r8), %rdx
        setc	%r9b
        movq	%rax, 152(%r8)
        xorq	%rcx, %rdx
        addq	%r9, %rdx
        movq	168(%r8), %rax
        setc	%r9b
        movq	%rdx, 160(%r8)
        xorq	%rcx, %rax
        addq	%r9, %rax
        movq	176(%r8), %rdx
        setc	%r9b
        movq	%rax, 168(%r8)
        xorq	%rcx, %rdx
        addq	%r9, %rdx
        movq	184(%r8), %rax
        setc	%r9b
        movq	%rdx, 176(%r8)
        xorq	%rcx, %rax
        addq	%r9, %rax
        movq	%rax, 184(%r8)
        movq	%r8, %rsi
        movq	%rsp, %rdi
#ifndef __APPLE__
        callq	sp_3072_sqr_avx2_24@plt
#else
        callq	_sp_3072_sqr_avx2_24
#endif /* __APPLE__ */
        movq	392(%rsp), %rsi
        movq	384(%rsp), %rdi
        addq	$0xc0, %rsi
        addq	$0x180, %rdi
#ifndef __APPLE__
        callq	sp_3072_sqr_avx2_24@plt
#else
        callq	_sp_3072_sqr_avx2_24
#endif /* __APPLE__ */
        movq	392(%rsp), %rsi
        movq	384(%rsp), %rdi
#ifndef __APPLE__
        callq	sp_3072_sqr_avx2_24@plt
#else
        callq	_sp_3072_sqr_avx2_24
#endif /* __APPLE__ */
#ifdef _WIN64
        movq	392(%rsp), %rsi
        movq	384(%rsp), %rdi
#endif /* _WIN64 */
        movq	384(%rsp), %rsi
        leaq	192(%rsp), %r8
        addq	$0x240, %rsi
        movq	$0x00, %rcx
        movq	-192(%r8), %rax
        subq	-192(%rsi), %rax
        movq	-184(%r8), %rdx
        movq	%rax, -192(%r8)
        sbbq	-184(%rsi), %rdx
        movq	-176(%r8), %rax
        movq	%rdx, -184(%r8)
        sbbq	-176(%rsi), %rax
        movq	-168(%r8), %rdx
        movq	%rax, -176(%r8)
        sbbq	-168(%rsi), %rdx
        movq	-160(%r8), %rax
        movq	%rdx, -168(%r8)
        sbbq	-160(%rsi), %rax
        movq	-152(%r8), %rdx
        movq	%rax, -160(%r8)
        sbbq	-152(%rsi), %rdx
        movq	-144(%r8), %rax
        movq	%rdx, -152(%r8)
        sbbq	-144(%rsi), %rax
        movq	-136(%r8), %rdx
        movq	%rax, -144(%r8)
        sbbq	-136(%rsi), %rdx
        movq	-128(%r8), %rax
        movq	%rdx, -136(%r8)
        sbbq	-128(%rsi), %rax
        movq	-120(%r8), %rdx
        movq	%rax, -128(%r8)
        sbbq	-120(%rsi), %rdx
        movq	-112(%r8), %rax
        movq	%rdx, -120(%r8)
        sbbq	-112(%rsi), %rax
        movq	-104(%r8), %rdx
        movq	%rax, -112(%r8)
        sbbq	-104(%rsi), %rdx
        movq	-96(%r8), %rax
        movq	%rdx, -104(%r8)
        sbbq	-96(%rsi), %rax
        movq	-88(%r8), %rdx
        movq	%rax, -96(%r8)
        sbbq	-88(%rsi), %rdx
        movq	-80(%r8), %rax
        movq	%rdx, -88(%r8)
        sbbq	-80(%rsi), %rax
        movq	-72(%r8), %rdx
        movq	%rax, -80(%r8)
        sbbq	-72(%rsi), %rdx
        movq	-64(%r8), %rax
        movq	%rdx, -72(%r8)
        sbbq	-64(%rsi), %rax
        movq	-56(%r8), %rdx
        movq	%rax, -64(%r8)
        sbbq	-56(%rsi), %rdx
        movq	-48(%r8), %rax
        movq	%rdx, -56(%r8)
        sbbq	-48(%rsi), %rax
        movq	-40(%r8), %rdx
        movq	%rax, -48(%r8)
        sbbq	-40(%rsi), %rdx
        movq	-32(%r8), %rax
        movq	%rdx, -40(%r8)
        sbbq	-32(%rsi), %rax
        movq	-24(%r8), %rdx
        movq	%rax, -32(%r8)
        sbbq	-24(%rsi), %rdx
        movq	-16(%r8), %rax
        movq	%rdx, -24(%r8)
        sbbq	-16(%rsi), %rax
        movq	-8(%r8), %rdx
        movq	%rax, -16(%r8)
        sbbq	-8(%rsi), %rdx
        movq	(%r8), %rax
        movq	%rdx, -8(%r8)
        sbbq	(%rsi), %rax
        movq	8(%r8), %rdx
        movq	%rax, (%r8)
        sbbq	8(%rsi), %rdx
        movq	16(%r8), %rax
        movq	%rdx, 8(%r8)
        sbbq	16(%rsi), %rax
        movq	24(%r8), %rdx
        movq	%rax, 16(%r8)
        sbbq	24(%rsi), %rdx
        movq	32(%r8), %rax
        movq	%rdx, 24(%r8)
        sbbq	32(%rsi), %rax
        movq	40(%r8), %rdx
        movq	%rax, 32(%r8)
        sbbq	40(%rsi), %rdx
        movq	48(%r8), %rax
        movq	%rdx, 40(%r8)
        sbbq	48(%rsi), %rax
        movq	56(%r8), %rdx
        movq	%rax, 48(%r8)
        sbbq	56(%rsi), %rdx
        movq	64(%r8), %rax
        movq	%rdx, 56(%r8)
        sbbq	64(%rsi), %rax
        movq	72(%r8), %rdx
        movq	%rax, 64(%r8)
        sbbq	72(%rsi), %rdx
        movq	80(%r8), %rax
        movq	%rdx, 72(%r8)
        sbbq	80(%rsi), %rax
        movq	88(%r8), %rdx
        movq	%rax, 80(%r8)
        sbbq	88(%rsi), %rdx
        movq	96(%r8), %rax
        movq	%rdx, 88(%r8)
        sbbq	96(%rsi), %rax
        movq	104(%r8), %rdx
        movq	%rax, 96(%r8)
        sbbq	104(%rsi), %rdx
        movq	112(%r8), %rax
        movq	%rdx, 104(%r8)
        sbbq	112(%rsi), %rax
        movq	120(%r8), %rdx
        movq	%rax, 112(%r8)
        sbbq	120(%rsi), %rdx
        movq	128(%r8), %rax
        movq	%rdx, 120(%r8)
        sbbq	128(%rsi), %rax
        movq	136(%r8), %rdx
        movq	%rax, 128(%r8)
        sbbq	136(%rsi), %rdx
        movq	144(%r8), %rax
        movq	%rdx, 136(%r8)
        sbbq	144(%rsi), %rax
        movq	152(%r8), %rdx
        movq	%rax, 144(%r8)
        sbbq	152(%rsi), %rdx
        movq	160(%r8), %rax
        movq	%rdx, 152(%r8)
        sbbq	160(%rsi), %rax
        movq	168(%r8), %rdx
        movq	%rax, 160(%r8)
        sbbq	168(%rsi), %rdx
        movq	176(%r8), %rax
        movq	%rdx, 168(%r8)
        sbbq	176(%rsi), %rax
        movq	184(%r8), %rdx
        movq	%rax, 176(%r8)
        sbbq	184(%rsi), %rdx
        movq	%rdx, 184(%r8)
        sbbq	$0x00, %rcx
        subq	$0x180, %rsi
        movq	-192(%r8), %rax
        subq	-192(%rsi), %rax
        movq	-184(%r8), %rdx
        movq	%rax, -192(%r8)
        sbbq	-184(%rsi), %rdx
        movq	-176(%r8), %rax
        movq	%rdx, -184(%r8)
        sbbq	-176(%rsi), %rax
        movq	-168(%r8), %rdx
        movq	%rax, -176(%r8)
        sbbq	-168(%rsi), %rdx
        movq	-160(%r8), %rax
        movq	%rdx, -168(%r8)
        sbbq	-160(%rsi), %rax
        movq	-152(%r8), %rdx
        movq	%rax, -160(%r8)
        sbbq	-152(%rsi), %rdx
        movq	-144(%r8), %rax
        movq	%rdx, -152(%r8)
        sbbq	-144(%rsi), %rax
        movq	-136(%r8), %rdx
        movq	%rax, -144(%r8)
        sbbq	-136(%rsi), %rdx
        movq	-128(%r8), %rax
        movq	%rdx, -136(%r8)
        sbbq	-128(%rsi), %rax
        movq	-120(%r8), %rdx
        movq	%rax, -128(%r8)
        sbbq	-120(%rsi), %rdx
        movq	-112(%r8), %rax
        movq	%rdx, -120(%r8)
        sbbq	-112(%rsi), %rax
        movq	-104(%r8), %rdx
        movq	%rax, -112(%r8)
        sbbq	-104(%rsi), %rdx
        movq	-96(%r8), %rax
        movq	%rdx, -104(%r8)
        sbbq	-96(%rsi), %rax
        movq	-88(%r8), %rdx
        movq	%rax, -96(%r8)
        sbbq	-88(%rsi), %rdx
        movq	-80(%r8), %rax
        movq	%rdx, -88(%r8)
        sbbq	-80(%rsi), %rax
        movq	-72(%r8), %rdx
        movq	%rax, -80(%r8)
        sbbq	-72(%rsi), %rdx
        movq	-64(%r8), %rax
        movq	%rdx, -72(%r8)
        sbbq	-64(%rsi), %rax
        movq	-56(%r8), %rdx
        movq	%rax, -64(%r8)
        sbbq	-56(%rsi), %rdx
        movq	-48(%r8), %rax
        movq	%rdx, -56(%r8)
        sbbq	-48(%rsi), %rax
        movq	-40(%r8), %rdx
        movq	%rax, -48(%r8)
        sbbq	-40(%rsi), %rdx
        movq	-32(%r8), %rax
        movq	%rdx, -40(%r8)
        sbbq	-32(%rsi), %rax
        movq	-24(%r8), %rdx
        movq	%rax, -32(%r8)
        sbbq	-24(%rsi), %rdx
        movq	-16(%r8), %rax
        movq	%rdx, -24(%r8)
        sbbq	-16(%rsi), %rax
        movq	-8(%r8), %rdx
        movq	%rax, -16(%r8)
        sbbq	-8(%rsi), %rdx
        movq	(%r8), %rax
        movq	%rdx, -8(%r8)
        sbbq	(%rsi), %rax
        movq	8(%r8), %rdx
        movq	%rax, (%r8)
        sbbq	8(%rsi), %rdx
        movq	16(%r8), %rax
        movq	%rdx, 8(%r8)
        sbbq	16(%rsi), %rax
        movq	24(%r8), %rdx
        movq	%rax, 16(%r8)
        sbbq	24(%rsi), %rdx
        movq	32(%r8), %rax
        movq	%rdx, 24(%r8)
        sbbq	32(%rsi), %rax
        movq	40(%r8), %rdx
        movq	%rax, 32(%r8)
        sbbq	40(%rsi), %rdx
        movq	48(%r8), %rax
        movq	%rdx, 40(%r8)
        sbbq	48(%rsi), %rax
        movq	56(%r8), %rdx
        movq	%rax, 48(%r8)
        sbbq	56(%rsi), %rdx
        movq	64(%r8), %rax
        movq	%rdx, 56(%r8)
        sbbq	64(%rsi), %rax
        movq	72(%r8), %rdx
        movq	%rax, 64(%r8)
        sbbq	72(%rsi), %rdx
        movq	80(%r8), %rax
        movq	%rdx, 72(%r8)
        sbbq	80(%rsi), %rax
        movq	88(%r8), %rdx
        movq	%rax, 80(%r8)
        sbbq	88(%rsi), %rdx
        movq	96(%r8), %rax
        movq	%rdx, 88(%r8)
        sbbq	96(%rsi), %rax
        movq	104(%r8), %rdx
        movq	%rax, 96(%r8)
        sbbq	104(%rsi), %rdx
        movq	112(%r8), %rax
        movq	%rdx, 104(%r8)
        sbbq	112(%rsi), %rax
        movq	120(%r8), %rdx
        movq	%rax, 112(%r8)
        sbbq	120(%rsi), %rdx
        movq	128(%r8), %rax
        movq	%rdx, 120(%r8)
        sbbq	128(%rsi), %rax
        movq	136(%r8), %rdx
        movq	%rax, 128(%r8)
        sbbq	136(%rsi), %rdx
        movq	144(%r8), %rax
        movq	%rdx, 136(%r8)
        sbbq	144(%rsi), %rax
        movq	152(%r8), %rdx
        movq	%rax, 144(%r8)
        sbbq	152(%rsi), %rdx
        movq	160(%r8), %rax
        movq	%rdx, 152(%r8)
        sbbq	160(%rsi), %rax
        movq	168(%r8), %rdx
        movq	%rax, 160(%r8)
        sbbq	168(%rsi), %rdx
        movq	176(%r8), %rax
        movq	%rdx, 168(%r8)
        sbbq	176(%rsi), %rax
        movq	184(%r8), %rdx
        movq	%rax, 176(%r8)
        sbbq	184(%rsi), %rdx
        movq	%rdx, 184(%r8)
        sbbq	$0x00, %rcx
        movq	384(%rsp), %rdi
        negq	%rcx
        addq	$0x180, %rdi
        movq	-192(%rdi), %rax
        subq	-192(%r8), %rax
        movq	-184(%rdi), %rdx
        movq	%rax, -192(%rdi)
        sbbq	-184(%r8), %rdx
        movq	-176(%rdi), %rax
        movq	%rdx, -184(%rdi)
        sbbq	-176(%r8), %rax
        movq	-168(%rdi), %rdx
        movq	%rax, -176(%rdi)
        sbbq	-168(%r8), %rdx
        movq	-160(%rdi), %rax
        movq	%rdx, -168(%rdi)
        sbbq	-160(%r8), %rax
        movq	-152(%rdi), %rdx
        movq	%rax, -160(%rdi)
        sbbq	-152(%r8), %rdx
        movq	-144(%rdi), %rax
        movq	%rdx, -152(%rdi)
        sbbq	-144(%r8), %rax
        movq	-136(%rdi), %rdx
        movq	%rax, -144(%rdi)
        sbbq	-136(%r8), %rdx
        movq	-128(%rdi), %rax
        movq	%rdx, -136(%rdi)
        sbbq	-128(%r8), %rax
        movq	-120(%rdi), %rdx
        movq	%rax, -128(%rdi)
        sbbq	-120(%r8), %rdx
        movq	-112(%rdi), %rax
        movq	%rdx, -120(%rdi)
        sbbq	-112(%r8), %rax
        movq	-104(%rdi), %rdx
        movq	%rax, -112(%rdi)
        sbbq	-104(%r8), %rdx
        movq	-96(%rdi), %rax
        movq	%rdx, -104(%rdi)
        sbbq	-96(%r8), %rax
        movq	-88(%rdi), %rdx
        movq	%rax, -96(%rdi)
        sbbq	-88(%r8), %rdx
        movq	-80(%rdi), %rax
        movq	%rdx, -88(%rdi)
        sbbq	-80(%r8), %rax
        movq	-72(%rdi), %rdx
        movq	%rax, -80(%rdi)
        sbbq	-72(%r8), %rdx
        movq	-64(%rdi), %rax
        movq	%rdx, -72(%rdi)
        sbbq	-64(%r8), %rax
        movq	-56(%rdi), %rdx
        movq	%rax, -64(%rdi)
        sbbq	-56(%r8), %rdx
        movq	-48(%rdi), %rax
        movq	%rdx, -56(%rdi)
        sbbq	-48(%r8), %rax
        movq	-40(%rdi), %rdx
        movq	%rax, -48(%rdi)
        sbbq	-40(%r8), %rdx
        movq	-32(%rdi), %rax
        movq	%rdx, -40(%rdi)
        sbbq	-32(%r8), %rax
        movq	-24(%rdi), %rdx
        movq	%rax, -32(%rdi)
        sbbq	-24(%r8), %rdx
        movq	-16(%rdi), %rax
        movq	%rdx, -24(%rdi)
        sbbq	-16(%r8), %rax
        movq	-8(%rdi), %rdx
        movq	%rax, -16(%rdi)
        sbbq	-8(%r8), %rdx
        movq	(%rdi), %rax
        movq	%rdx, -8(%rdi)
        sbbq	(%r8), %rax
        movq	8(%rdi), %rdx
        movq	%rax, (%rdi)
        sbbq	8(%r8), %rdx
        movq	16(%rdi), %rax
        movq	%rdx, 8(%rdi)
        sbbq	16(%r8), %rax
        movq	24(%rdi), %rdx
        movq	%rax, 16(%rdi)
        sbbq	24(%r8), %rdx
        movq	32(%rdi), %rax
        movq	%rdx, 24(%rdi)
        sbbq	32(%r8), %rax
        movq	40(%rdi), %rdx
        movq	%rax, 32(%rdi)
        sbbq	40(%r8), %rdx
        movq	48(%rdi), %rax
        movq	%rdx, 40(%rdi)
        sbbq	48(%r8), %rax
        movq	56(%rdi), %rdx
        movq	%rax, 48(%rdi)
        sbbq	56(%r8), %rdx
        movq	64(%rdi), %rax
        movq	%rdx, 56(%rdi)
        sbbq	64(%r8), %rax
        movq	72(%rdi), %rdx
        movq	%rax, 64(%rdi)
        sbbq	72(%r8), %rdx
        movq	80(%rdi), %rax
        movq	%rdx, 72(%rdi)
        sbbq	80(%r8), %rax
        movq	88(%rdi), %rdx
        movq	%rax, 80(%rdi)
        sbbq	88(%r8), %rdx
        movq	96(%rdi), %rax
        movq	%rdx, 88(%rdi)
        sbbq	96(%r8), %rax
        movq	104(%rdi), %rdx
        movq	%rax, 96(%rdi)
        sbbq	104(%r8), %rdx
        movq	112(%rdi), %rax
        movq	%rdx, 104(%rdi)
        sbbq	112(%r8), %rax
        movq	120(%rdi), %rdx
        movq	%rax, 112(%rdi)
        sbbq	120(%r8), %rdx
        movq	128(%rdi), %rax
        movq	%rdx, 120(%rdi)
        sbbq	128(%r8), %rax
        movq	136(%rdi), %rdx
        movq	%rax, 128(%rdi)
        sbbq	136(%r8), %rdx
        movq	144(%rdi), %rax
        movq	%rdx, 136(%rdi)
        sbbq	144(%r8), %rax
        movq	152(%rdi), %rdx
        movq	%rax, 144(%rdi)
        sbbq	152(%r8), %rdx
        movq	160(%rdi), %rax
        movq	%rdx, 152(%rdi)
        sbbq	160(%r8), %rax
        movq	168(%rdi), %rdx
        movq	%rax, 160(%rdi)
        sbbq	168(%r8), %rdx
        movq	176(%rdi), %rax
        movq	%rdx, 168(%rdi)
        sbbq	176(%r8), %rax
        movq	184(%rdi), %rdx
        movq	%rax, 176(%rdi)
        sbbq	184(%r8), %rdx
        movq	%rdx, 184(%rdi)
        sbbq	$0x00, %rcx
        movq	384(%rsp), %rdi
        addq	$0x240, %rdi
        # Add in word
        movq	(%rdi), %rax
        addq	%rcx, %rax
        movq	8(%rdi), %rdx
        movq	%rax, (%rdi)
        adcq	$0x00, %rdx
        movq	16(%rdi), %rax
        movq	%rdx, 8(%rdi)
        adcq	$0x00, %rax
        movq	24(%rdi), %rdx
        movq	%rax, 16(%rdi)
        adcq	$0x00, %rdx
        movq	32(%rdi), %rax
        movq	%rdx, 24(%rdi)
        adcq	$0x00, %rax
        movq	40(%rdi), %rdx
        movq	%rax, 32(%rdi)
        adcq	$0x00, %rdx
        movq	48(%rdi), %rax
        movq	%rdx, 40(%rdi)
        adcq	$0x00, %rax
        movq	56(%rdi), %rdx
        movq	%rax, 48(%rdi)
        adcq	$0x00, %rdx
        movq	64(%rdi), %rax
        movq	%rdx, 56(%rdi)
        adcq	$0x00, %rax
        movq	72(%rdi), %rdx
        movq	%rax, 64(%rdi)
        adcq	$0x00, %rdx
        movq	80(%rdi), %rax
        movq	%rdx, 72(%rdi)
        adcq	$0x00, %rax
        movq	88(%rdi), %rdx
        movq	%rax, 80(%rdi)
        adcq	$0x00, %rdx
        movq	96(%rdi), %rax
        movq	%rdx, 88(%rdi)
        adcq	$0x00, %rax
        movq	104(%rdi), %rdx
        movq	%rax, 96(%rdi)
        adcq	$0x00, %rdx
        movq	112(%rdi), %rax
        movq	%rdx, 104(%rdi)
        adcq	$0x00, %rax
        movq	120(%rdi), %rdx
        movq	%rax, 112(%rdi)
        adcq	$0x00, %rdx
        movq	128(%rdi), %rax
        movq	%rdx, 120(%rdi)
        adcq	$0x00, %rax
        movq	136(%rdi), %rdx
        movq	%rax, 128(%rdi)
        adcq	$0x00, %rdx
        movq	144(%rdi), %rax
        movq	%rdx, 136(%rdi)
        adcq	$0x00, %rax
        movq	152(%rdi), %rdx
        movq	%rax, 144(%rdi)
        adcq	$0x00, %rdx
        movq	160(%rdi), %rax
        movq	%rdx, 152(%rdi)
        adcq	$0x00, %rax
        movq	168(%rdi), %rdx
        movq	%rax, 160(%rdi)
        adcq	$0x00, %rdx
        movq	176(%rdi), %rax
        movq	%rdx, 168(%rdi)
        adcq	$0x00, %rax
        movq	184(%rdi), %rdx
        movq	%rax, 176(%rdi)
        adcq	$0x00, %rdx
        movq	%rdx, 184(%rdi)
        movq	392(%rsp), %rsi
        movq	384(%rsp), %rdi
        addq	$0x190, %rsp
        repz retq
#ifndef __APPLE__
.size	sp_3072_sqr_avx2_48,.-sp_3072_sqr_avx2_48
#endif /* __APPLE__ */
#endif /* HAVE_INTEL_AVX2 */
/* Mul a by digit b into r. (r = a * b)
 *
 * r  A single precision integer.
 * a  A single precision integer.
 * b  A single precision digit.
 */
#ifndef __APPLE__
.text
.globl	sp_3072_mul_d_48
.type	sp_3072_mul_d_48,@function
.align	16
sp_3072_mul_d_48:
#else
.section	__TEXT,__text
.globl	_sp_3072_mul_d_48
.p2align	4
_sp_3072_mul_d_48:
#endif /* __APPLE__ */
        movq	%rdx, %rcx
        # A[0] * B
        movq	%rcx, %rax
        xorq	%r10, %r10
        mulq	(%rsi)
        movq	%rax, %r8
        movq	%rdx, %r9
        movq	%r8, (%rdi)
        # A[1] * B
        movq	%rcx, %rax
        xorq	%r8, %r8
        mulq	8(%rsi)
        addq	%rax, %r9
        movq	%r9, 8(%rdi)
        adcq	%rdx, %r10
        adcq	$0x00, %r8
        # A[2] * B
        movq	%rcx, %rax
        xorq	%r9, %r9
        mulq	16(%rsi)
        addq	%rax, %r10
        movq	%r10, 16(%rdi)
        adcq	%rdx, %r8
        adcq	$0x00, %r9
        # A[3] * B
        movq	%rcx, %rax
        xorq	%r10, %r10
        mulq	24(%rsi)
        addq	%rax, %r8
        movq	%r8, 24(%rdi)
        adcq	%rdx, %r9
        adcq	$0x00, %r10
        # A[4] * B
        movq	%rcx, %rax
        xorq	%r8, %r8
        mulq	32(%rsi)
        addq	%rax, %r9
        movq	%r9, 32(%rdi)
        adcq	%rdx, %r10
        adcq	$0x00, %r8
        # A[5] * B
        movq	%rcx, %rax
        xorq	%r9, %r9
        mulq	40(%rsi)
        addq	%rax, %r10
        movq	%r10, 40(%rdi)
        adcq	%rdx, %r8
        adcq	$0x00, %r9
        # A[6] * B
        movq	%rcx, %rax
        xorq	%r10, %r10
        mulq	48(%rsi)
        addq	%rax, %r8
        movq	%r8, 48(%rdi)
        adcq	%rdx, %r9
        adcq	$0x00, %r10
        # A[7] * B
        movq	%rcx, %rax
        xorq	%r8, %r8
        mulq	56(%rsi)
        addq	%rax, %r9
        movq	%r9, 56(%rdi)
        adcq	%rdx, %r10
        adcq	$0x00, %r8
        # A[8] * B
        movq	%rcx, %rax
        xorq	%r9, %r9
        mulq	64(%rsi)
        addq	%rax, %r10
        movq	%r10, 64(%rdi)
        adcq	%rdx, %r8
        adcq	$0x00, %r9
        # A[9] * B
        movq	%rcx, %rax
        xorq	%r10, %r10
        mulq	72(%rsi)
        addq	%rax, %r8
        movq	%r8, 72(%rdi)
        adcq	%rdx, %r9
        adcq	$0x00, %r10
        # A[10] * B
        movq	%rcx, %rax
        xorq	%r8, %r8
        mulq	80(%rsi)
        addq	%rax, %r9
        movq	%r9, 80(%rdi)
        adcq	%rdx, %r10
        adcq	$0x00, %r8
        # A[11] * B
        movq	%rcx, %rax
        xorq	%r9, %r9
        mulq	88(%rsi)
        addq	%rax, %r10
        movq	%r10, 88(%rdi)
        adcq	%rdx, %r8
        adcq	$0x00, %r9
        # A[12] * B
        movq	%rcx, %rax
        xorq	%r10, %r10
        mulq	96(%rsi)
        addq	%rax, %r8
        movq	%r8, 96(%rdi)
        adcq	%rdx, %r9
        adcq	$0x00, %r10
        # A[13] * B
        movq	%rcx, %rax
        xorq	%r8, %r8
        mulq	104(%rsi)
        addq	%rax, %r9
        movq	%r9, 104(%rdi)
        adcq	%rdx, %r10
        adcq	$0x00, %r8
        # A[14] * B
        movq	%rcx, %rax
        xorq	%r9, %r9
        mulq	112(%rsi)
        addq	%rax, %r10
        movq	%r10, 112(%rdi)
        adcq	%rdx, %r8
        adcq	$0x00, %r9
        # A[15] * B
        movq	%rcx, %rax
        xorq	%r10, %r10
        mulq	120(%rsi)
        addq	%rax, %r8
        movq	%r8, 120(%rdi)
        adcq	%rdx, %r9
        adcq	$0x00, %r10
        # A[16] * B
        movq	%rcx, %rax
        xorq	%r8, %r8
        mulq	128(%rsi)
        addq	%rax, %r9
        movq	%r9, 128(%rdi)
        adcq	%rdx, %r10
        adcq	$0x00, %r8
        # A[17] * B
        movq	%rcx, %rax
        xorq	%r9, %r9
        mulq	136(%rsi)
        addq	%rax, %r10
        movq	%r10, 136(%rdi)
        adcq	%rdx, %r8
        adcq	$0x00, %r9
        # A[18] * B
        movq	%rcx, %rax
        xorq	%r10, %r10
        mulq	144(%rsi)
        addq	%rax, %r8
        movq	%r8, 144(%rdi)
        adcq	%rdx, %r9
        adcq	$0x00, %r10
        # A[19] * B
        movq	%rcx, %rax
        xorq	%r8, %r8
        mulq	152(%rsi)
        addq	%rax, %r9
        movq	%r9, 152(%rdi)
        adcq	%rdx, %r10
        adcq	$0x00, %r8
        # A[20] * B
        movq	%rcx, %rax
        xorq	%r9, %r9
        mulq	160(%rsi)
        addq	%rax, %r10
        movq	%r10, 160(%rdi)
        adcq	%rdx, %r8
        adcq	$0x00, %r9
        # A[21] * B
        movq	%rcx, %rax
        xorq	%r10, %r10
        mulq	168(%rsi)
        addq	%rax, %r8
        movq	%r8, 168(%rdi)
        adcq	%rdx, %r9
        adcq	$0x00, %r10
        # A[22] * B
        movq	%rcx, %rax
        xorq	%r8, %r8
        mulq	176(%rsi)
        addq	%rax, %r9
        movq	%r9, 176(%rdi)
        adcq	%rdx, %r10
        adcq	$0x00, %r8
        # A[23] * B
        movq	%rcx, %rax
        xorq	%r9, %r9
        mulq	184(%rsi)
        addq	%rax, %r10
        movq	%r10, 184(%rdi)
        adcq	%rdx, %r8
        adcq	$0x00, %r9
        # A[24] * B
        movq	%rcx, %rax
        xorq	%r10, %r10
        mulq	192(%rsi)
        addq	%rax, %r8
        movq	%r8, 192(%rdi)
        adcq	%rdx, %r9
        adcq	$0x00, %r10
        # A[25] * B
        movq	%rcx, %rax
        xorq	%r8, %r8
        mulq	200(%rsi)
        addq	%rax, %r9
        movq	%r9, 200(%rdi)
        adcq	%rdx, %r10
        adcq	$0x00, %r8
        # A[26] * B
        movq	%rcx, %rax
        xorq	%r9, %r9
        mulq	208(%rsi)
        addq	%rax, %r10
        movq	%r10, 208(%rdi)
        adcq	%rdx, %r8
        adcq	$0x00, %r9
        # A[27] * B
        movq	%rcx, %rax
        xorq	%r10, %r10
        mulq	216(%rsi)
        addq	%rax, %r8
        movq	%r8, 216(%rdi)
        adcq	%rdx, %r9
        adcq	$0x00, %r10
        # A[28] * B
        movq	%rcx, %rax
        xorq	%r8, %r8
        mulq	224(%rsi)
        addq	%rax, %r9
        movq	%r9, 224(%rdi)
        adcq	%rdx, %r10
        adcq	$0x00, %r8
        # A[29] * B
        movq	%rcx, %rax
        xorq	%r9, %r9
        mulq	232(%rsi)
        addq	%rax, %r10
        movq	%r10, 232(%rdi)
        adcq	%rdx, %r8
        adcq	$0x00, %r9
        # A[30] * B
        movq	%rcx, %rax
        xorq	%r10, %r10
        mulq	240(%rsi)
        addq	%rax, %r8
        movq	%r8, 240(%rdi)
        adcq	%rdx, %r9
        adcq	$0x00, %r10
        # A[31] * B
        movq	%rcx, %rax
        xorq	%r8, %r8
        mulq	248(%rsi)
        addq	%rax, %r9
        movq	%r9, 248(%rdi)
        adcq	%rdx, %r10
        adcq	$0x00, %r8
        # A[32] * B
        movq	%rcx, %rax
        xorq	%r9, %r9
        mulq	256(%rsi)
        addq	%rax, %r10
        movq	%r10, 256(%rdi)
        adcq	%rdx, %r8
        adcq	$0x00, %r9
        # A[33] * B
        movq	%rcx, %rax
        xorq	%r10, %r10
        mulq	264(%rsi)
        addq	%rax, %r8
        movq	%r8, 264(%rdi)
        adcq	%rdx, %r9
        adcq	$0x00, %r10
        # A[34] * B
        movq	%rcx, %rax
        xorq	%r8, %r8
        mulq	272(%rsi)
        addq	%rax, %r9
        movq	%r9, 272(%rdi)
        adcq	%rdx, %r10
        adcq	$0x00, %r8
        # A[35] * B
        movq	%rcx, %rax
        xorq	%r9, %r9
        mulq	280(%rsi)
        addq	%rax, %r10
        movq	%r10, 280(%rdi)
        adcq	%rdx, %r8
        adcq	$0x00, %r9
        # A[36] * B
        movq	%rcx, %rax
        xorq	%r10, %r10
        mulq	288(%rsi)
        addq	%rax, %r8
        movq	%r8, 288(%rdi)
        adcq	%rdx, %r9
        adcq	$0x00, %r10
        # A[37] * B
        movq	%rcx, %rax
        xorq	%r8, %r8
        mulq	296(%rsi)
        addq	%rax, %r9
        movq	%r9, 296(%rdi)
        adcq	%rdx, %r10
        adcq	$0x00, %r8
        # A[38] * B
        movq	%rcx, %rax
        xorq	%r9, %r9
        mulq	304(%rsi)
        addq	%rax, %r10
        movq	%r10, 304(%rdi)
        adcq	%rdx, %r8
        adcq	$0x00, %r9
        # A[39] * B
        movq	%rcx, %rax
        xorq	%r10, %r10
        mulq	312(%rsi)
        addq	%rax, %r8
        movq	%r8, 312(%rdi)
        adcq	%rdx, %r9
        adcq	$0x00, %r10
        # A[40] * B
        movq	%rcx, %rax
        xorq	%r8, %r8
        mulq	320(%rsi)
        addq	%rax, %r9
        movq	%r9, 320(%rdi)
        adcq	%rdx, %r10
        adcq	$0x00, %r8
        # A[41] * B
        movq	%rcx, %rax
        xorq	%r9, %r9
        mulq	328(%rsi)
        addq	%rax, %r10
        movq	%r10, 328(%rdi)
        adcq	%rdx, %r8
        adcq	$0x00, %r9
        # A[42] * B
        movq	%rcx, %rax
        xorq	%r10, %r10
        mulq	336(%rsi)
        addq	%rax, %r8
        movq	%r8, 336(%rdi)
        adcq	%rdx, %r9
        adcq	$0x00, %r10
        # A[43] * B
        movq	%rcx, %rax
        xorq	%r8, %r8
        mulq	344(%rsi)
        addq	%rax, %r9
        movq	%r9, 344(%rdi)
        adcq	%rdx, %r10
        adcq	$0x00, %r8
        # A[44] * B
        movq	%rcx, %rax
        xorq	%r9, %r9
        mulq	352(%rsi)
        addq	%rax, %r10
        movq	%r10, 352(%rdi)
        adcq	%rdx, %r8
        adcq	$0x00, %r9
        # A[45] * B
        movq	%rcx, %rax
        xorq	%r10, %r10
        mulq	360(%rsi)
        addq	%rax, %r8
        movq	%r8, 360(%rdi)
        adcq	%rdx, %r9
        adcq	$0x00, %r10
        # A[46] * B
        movq	%rcx, %rax
        xorq	%r8, %r8
        mulq	368(%rsi)
        addq	%rax, %r9
        movq	%r9, 368(%rdi)
        adcq	%rdx, %r10
        adcq	$0x00, %r8
        # A[47] * B
        movq	%rcx, %rax
        mulq	376(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        movq	%r10, 376(%rdi)
        movq	%r8, 384(%rdi)
        repz retq
#ifndef __APPLE__
.size	sp_3072_mul_d_48,.-sp_3072_mul_d_48
#endif /* __APPLE__ */
/* Conditionally subtract b from a using the mask m.
 * m is -1 to subtract and 0 when not copying.
 *
 * r  A single precision number representing condition subtract result.
 * a  A single precision number to subtract from.
 * b  A single precision number to subtract.
 * m  Mask value to apply.
 */
#ifndef __APPLE__
.text
.globl	sp_3072_cond_sub_24
.type	sp_3072_cond_sub_24,@function
.align	16
sp_3072_cond_sub_24:
#else
.section	__TEXT,__text
.globl	_sp_3072_cond_sub_24
.p2align	4
_sp_3072_cond_sub_24:
#endif /* __APPLE__ */
        subq	$0xc0, %rsp
        movq	(%rdx), %r8
        movq	8(%rdx), %r9
        andq	%rcx, %r8
        andq	%rcx, %r9
        movq	%r8, (%rsp)
        movq	%r9, 8(%rsp)
        movq	16(%rdx), %r8
        movq	24(%rdx), %r9
        andq	%rcx, %r8
        andq	%rcx, %r9
        movq	%r8, 16(%rsp)
        movq	%r9, 24(%rsp)
        movq	32(%rdx), %r8
        movq	40(%rdx), %r9
        andq	%rcx, %r8
        andq	%rcx, %r9
        movq	%r8, 32(%rsp)
        movq	%r9, 40(%rsp)
        movq	48(%rdx), %r8
        movq	56(%rdx), %r9
        andq	%rcx, %r8
        andq	%rcx, %r9
        movq	%r8, 48(%rsp)
        movq	%r9, 56(%rsp)
        movq	64(%rdx), %r8
        movq	72(%rdx), %r9
        andq	%rcx, %r8
        andq	%rcx, %r9
        movq	%r8, 64(%rsp)
        movq	%r9, 72(%rsp)
        movq	80(%rdx), %r8
        movq	88(%rdx), %r9
        andq	%rcx, %r8
        andq	%rcx, %r9
        movq	%r8, 80(%rsp)
        movq	%r9, 88(%rsp)
        movq	96(%rdx), %r8
        movq	104(%rdx), %r9
        andq	%rcx, %r8
        andq	%rcx, %r9
        movq	%r8, 96(%rsp)
        movq	%r9, 104(%rsp)
        movq	112(%rdx), %r8
        movq	120(%rdx), %r9
        andq	%rcx, %r8
        andq	%rcx, %r9
        movq	%r8, 112(%rsp)
        movq	%r9, 120(%rsp)
        movq	128(%rdx), %r8
        movq	136(%rdx), %r9
        andq	%rcx, %r8
        andq	%rcx, %r9
        movq	%r8, 128(%rsp)
        movq	%r9, 136(%rsp)
        movq	144(%rdx), %r8
        movq	152(%rdx), %r9
        andq	%rcx, %r8
        andq	%rcx, %r9
        movq	%r8, 144(%rsp)
        movq	%r9, 152(%rsp)
        movq	160(%rdx), %r8
        movq	168(%rdx), %r9
        andq	%rcx, %r8
        andq	%rcx, %r9
        movq	%r8, 160(%rsp)
        movq	%r9, 168(%rsp)
        movq	176(%rdx), %r8
        movq	184(%rdx), %r9
        andq	%rcx, %r8
        andq	%rcx, %r9
        movq	%r8, 176(%rsp)
        movq	%r9, 184(%rsp)
        movq	(%rsi), %r8
        movq	(%rsp), %rdx
        subq	%rdx, %r8
        movq	8(%rsi), %r9
        movq	8(%rsp), %rdx
        sbbq	%rdx, %r9
        movq	%r8, (%rdi)
        movq	16(%rsi), %r8
        movq	16(%rsp), %rdx
        sbbq	%rdx, %r8
        movq	%r9, 8(%rdi)
        movq	24(%rsi), %r9
        movq	24(%rsp), %rdx
        sbbq	%rdx, %r9
        movq	%r8, 16(%rdi)
        movq	32(%rsi), %r8
        movq	32(%rsp), %rdx
        sbbq	%rdx, %r8
        movq	%r9, 24(%rdi)
        movq	40(%rsi), %r9
        movq	40(%rsp), %rdx
        sbbq	%rdx, %r9
        movq	%r8, 32(%rdi)
        movq	48(%rsi), %r8
        movq	48(%rsp), %rdx
        sbbq	%rdx, %r8
        movq	%r9, 40(%rdi)
        movq	56(%rsi), %r9
        movq	56(%rsp), %rdx
        sbbq	%rdx, %r9
        movq	%r8, 48(%rdi)
        movq	64(%rsi), %r8
        movq	64(%rsp), %rdx
        sbbq	%rdx, %r8
        movq	%r9, 56(%rdi)
        movq	72(%rsi), %r9
        movq	72(%rsp), %rdx
        sbbq	%rdx, %r9
        movq	%r8, 64(%rdi)
        movq	80(%rsi), %r8
        movq	80(%rsp), %rdx
        sbbq	%rdx, %r8
        movq	%r9, 72(%rdi)
        movq	88(%rsi), %r9
        movq	88(%rsp), %rdx
        sbbq	%rdx, %r9
        movq	%r8, 80(%rdi)
        movq	96(%rsi), %r8
        movq	96(%rsp), %rdx
        sbbq	%rdx, %r8
        movq	%r9, 88(%rdi)
        movq	104(%rsi), %r9
        movq	104(%rsp), %rdx
        sbbq	%rdx, %r9
        movq	%r8, 96(%rdi)
        movq	112(%rsi), %r8
        movq	112(%rsp), %rdx
        sbbq	%rdx, %r8
        movq	%r9, 104(%rdi)
        movq	120(%rsi), %r9
        movq	120(%rsp), %rdx
        sbbq	%rdx, %r9
        movq	%r8, 112(%rdi)
        movq	128(%rsi), %r8
        movq	128(%rsp), %rdx
        sbbq	%rdx, %r8
        movq	%r9, 120(%rdi)
        movq	136(%rsi), %r9
        movq	136(%rsp), %rdx
        sbbq	%rdx, %r9
        movq	%r8, 128(%rdi)
        movq	144(%rsi), %r8
        movq	144(%rsp), %rdx
        sbbq	%rdx, %r8
        movq	%r9, 136(%rdi)
        movq	152(%rsi), %r9
        movq	152(%rsp), %rdx
        sbbq	%rdx, %r9
        movq	%r8, 144(%rdi)
        movq	160(%rsi), %r8
        movq	160(%rsp), %rdx
        sbbq	%rdx, %r8
        movq	%r9, 152(%rdi)
        movq	168(%rsi), %r9
        movq	168(%rsp), %rdx
        sbbq	%rdx, %r9
        movq	%r8, 160(%rdi)
        movq	176(%rsi), %r8
        movq	176(%rsp), %rdx
        sbbq	%rdx, %r8
        movq	%r9, 168(%rdi)
        movq	184(%rsi), %r9
        movq	184(%rsp), %rdx
        sbbq	%rdx, %r9
        movq	%r8, 176(%rdi)
        movq	%r9, 184(%rdi)
        sbbq	%rax, %rax
        addq	$0xc0, %rsp
        repz retq
#ifndef __APPLE__
.size	sp_3072_cond_sub_24,.-sp_3072_cond_sub_24
#endif /* __APPLE__ */
/* Reduce the number back to 3072 bits using Montgomery reduction.
 *
 * a   A single precision number to reduce in place.
 * m   The single precision number representing the modulus.
 * mp  The digit representing the negative inverse of m mod 2^n.
 */
#ifndef __APPLE__
.text
.globl	sp_3072_mont_reduce_24
.type	sp_3072_mont_reduce_24,@function
.align	16
sp_3072_mont_reduce_24:
#else
.section	__TEXT,__text
.globl	_sp_3072_mont_reduce_24
.p2align	4
_sp_3072_mont_reduce_24:
#endif /* __APPLE__ */
        pushq	%r12
        pushq	%r13
        pushq	%r14
        pushq	%r15
        movq	%rdx, %rcx
        xorq	%r15, %r15
        # i = 24
        movq	$24, %r8
        movq	(%rdi), %r13
        movq	8(%rdi), %r14
L_3072_mont_reduce_24_loop:
        # mu = a[i] * mp
        movq	%r13, %r11
        imulq	%rcx, %r11
        # a[i+0] += m[0] * mu
        movq	%r11, %rax
        xorq	%r10, %r10
        mulq	(%rsi)
        addq	%rax, %r13
        adcq	%rdx, %r10
        # a[i+1] += m[1] * mu
        movq	%r11, %rax
        xorq	%r9, %r9
        mulq	8(%rsi)
        movq	%r14, %r13
        addq	%rax, %r13
        adcq	%rdx, %r9
        addq	%r10, %r13
        adcq	$0x00, %r9
        # a[i+2] += m[2] * mu
        movq	%r11, %rax
        xorq	%r10, %r10
        mulq	16(%rsi)
        movq	16(%rdi), %r14
        addq	%rax, %r14
        adcq	%rdx, %r10
        addq	%r9, %r14
        adcq	$0x00, %r10
        # a[i+3] += m[3] * mu
        movq	%r11, %rax
        xorq	%r9, %r9
        mulq	24(%rsi)
        movq	24(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r9
        addq	%r10, %r12
        movq	%r12, 24(%rdi)
        adcq	$0x00, %r9
        # a[i+4] += m[4] * mu
        movq	%r11, %rax
        xorq	%r10, %r10
        mulq	32(%rsi)
        movq	32(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r10
        addq	%r9, %r12
        movq	%r12, 32(%rdi)
        adcq	$0x00, %r10
        # a[i+5] += m[5] * mu
        movq	%r11, %rax
        xorq	%r9, %r9
        mulq	40(%rsi)
        movq	40(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r9
        addq	%r10, %r12
        movq	%r12, 40(%rdi)
        adcq	$0x00, %r9
        # a[i+6] += m[6] * mu
        movq	%r11, %rax
        xorq	%r10, %r10
        mulq	48(%rsi)
        movq	48(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r10
        addq	%r9, %r12
        movq	%r12, 48(%rdi)
        adcq	$0x00, %r10
        # a[i+7] += m[7] * mu
        movq	%r11, %rax
        xorq	%r9, %r9
        mulq	56(%rsi)
        movq	56(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r9
        addq	%r10, %r12
        movq	%r12, 56(%rdi)
        adcq	$0x00, %r9
        # a[i+8] += m[8] * mu
        movq	%r11, %rax
        xorq	%r10, %r10
        mulq	64(%rsi)
        movq	64(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r10
        addq	%r9, %r12
        movq	%r12, 64(%rdi)
        adcq	$0x00, %r10
        # a[i+9] += m[9] * mu
        movq	%r11, %rax
        xorq	%r9, %r9
        mulq	72(%rsi)
        movq	72(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r9
        addq	%r10, %r12
        movq	%r12, 72(%rdi)
        adcq	$0x00, %r9
        # a[i+10] += m[10] * mu
        movq	%r11, %rax
        xorq	%r10, %r10
        mulq	80(%rsi)
        movq	80(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r10
        addq	%r9, %r12
        movq	%r12, 80(%rdi)
        adcq	$0x00, %r10
        # a[i+11] += m[11] * mu
        movq	%r11, %rax
        xorq	%r9, %r9
        mulq	88(%rsi)
        movq	88(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r9
        addq	%r10, %r12
        movq	%r12, 88(%rdi)
        adcq	$0x00, %r9
        # a[i+12] += m[12] * mu
        movq	%r11, %rax
        xorq	%r10, %r10
        mulq	96(%rsi)
        movq	96(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r10
        addq	%r9, %r12
        movq	%r12, 96(%rdi)
        adcq	$0x00, %r10
        # a[i+13] += m[13] * mu
        movq	%r11, %rax
        xorq	%r9, %r9
        mulq	104(%rsi)
        movq	104(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r9
        addq	%r10, %r12
        movq	%r12, 104(%rdi)
        adcq	$0x00, %r9
        # a[i+14] += m[14] * mu
        movq	%r11, %rax
        xorq	%r10, %r10
        mulq	112(%rsi)
        movq	112(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r10
        addq	%r9, %r12
        movq	%r12, 112(%rdi)
        adcq	$0x00, %r10
        # a[i+15] += m[15] * mu
        movq	%r11, %rax
        xorq	%r9, %r9
        mulq	120(%rsi)
        movq	120(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r9
        addq	%r10, %r12
        movq	%r12, 120(%rdi)
        adcq	$0x00, %r9
        # a[i+16] += m[16] * mu
        movq	%r11, %rax
        xorq	%r10, %r10
        mulq	128(%rsi)
        movq	128(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r10
        addq	%r9, %r12
        movq	%r12, 128(%rdi)
        adcq	$0x00, %r10
        # a[i+17] += m[17] * mu
        movq	%r11, %rax
        xorq	%r9, %r9
        mulq	136(%rsi)
        movq	136(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r9
        addq	%r10, %r12
        movq	%r12, 136(%rdi)
        adcq	$0x00, %r9
        # a[i+18] += m[18] * mu
        movq	%r11, %rax
        xorq	%r10, %r10
        mulq	144(%rsi)
        movq	144(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r10
        addq	%r9, %r12
        movq	%r12, 144(%rdi)
        adcq	$0x00, %r10
        # a[i+19] += m[19] * mu
        movq	%r11, %rax
        xorq	%r9, %r9
        mulq	152(%rsi)
        movq	152(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r9
        addq	%r10, %r12
        movq	%r12, 152(%rdi)
        adcq	$0x00, %r9
        # a[i+20] += m[20] * mu
        movq	%r11, %rax
        xorq	%r10, %r10
        mulq	160(%rsi)
        movq	160(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r10
        addq	%r9, %r12
        movq	%r12, 160(%rdi)
        adcq	$0x00, %r10
        # a[i+21] += m[21] * mu
        movq	%r11, %rax
        xorq	%r9, %r9
        mulq	168(%rsi)
        movq	168(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r9
        addq	%r10, %r12
        movq	%r12, 168(%rdi)
        adcq	$0x00, %r9
        # a[i+22] += m[22] * mu
        movq	%r11, %rax
        xorq	%r10, %r10
        mulq	176(%rsi)
        movq	176(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r10
        addq	%r9, %r12
        movq	%r12, 176(%rdi)
        adcq	$0x00, %r10
        # a[i+23] += m[23] * mu
        movq	%r11, %rax
        mulq	184(%rsi)
        movq	184(%rdi), %r12
        addq	%rax, %r10
        adcq	%r15, %rdx
        movq	$0x00, %r15
        adcq	$0x00, %r15
        addq	%r10, %r12
        movq	%r12, 184(%rdi)
        adcq	%rdx, 192(%rdi)
        adcq	$0x00, %r15
        # i -= 1
        addq	$8, %rdi
        decq	%r8
        jnz	L_3072_mont_reduce_24_loop
        movq	%r13, (%rdi)
        movq	%r14, 8(%rdi)
        negq	%r15
#ifdef _WIN64
        movq	%rsi, %rdx
        movq	%r15, %rcx
#else
        movq	%r15, %rcx
        movq	%rsi, %rdx
#endif /* _WIN64 */
        movq	%rdi, %rsi
        movq	%rdi, %rdi
        subq	$0xc0, %rdi
#ifndef __APPLE__
        callq	sp_3072_cond_sub_24@plt
#else
        callq	_sp_3072_cond_sub_24
#endif /* __APPLE__ */
        popq	%r15
        popq	%r14
        popq	%r13
        popq	%r12
        repz retq
#ifndef __APPLE__
.size	sp_3072_mont_reduce_24,.-sp_3072_mont_reduce_24
#endif /* __APPLE__ */
#ifdef HAVE_INTEL_AVX2
/* Conditionally subtract b from a using the mask m.
 * m is -1 to subtract and 0 when not copying.
 *
 * r  A single precision number representing condition subtract result.
 * a  A single precision number to subtract from.
 * b  A single precision number to subtract.
 * m  Mask value to apply.
 */
#ifndef __APPLE__
.text
.globl	sp_3072_cond_sub_avx2_24
.type	sp_3072_cond_sub_avx2_24,@function
.align	16
sp_3072_cond_sub_avx2_24:
#else
.section	__TEXT,__text
.globl	_sp_3072_cond_sub_avx2_24
.p2align	4
_sp_3072_cond_sub_avx2_24:
#endif /* __APPLE__ */
        movq	(%rdx), %r10
        movq	(%rsi), %r8
        pextq	%rcx, %r10, %r10
        subq	%r10, %r8
        movq	8(%rdx), %r10
        movq	8(%rsi), %r9
        pextq	%rcx, %r10, %r10
        movq	%r8, (%rdi)
        sbbq	%r10, %r9
        movq	16(%rdx), %r8
        movq	16(%rsi), %r10
        pextq	%rcx, %r8, %r8
        movq	%r9, 8(%rdi)
        sbbq	%r8, %r10
        movq	24(%rdx), %r9
        movq	24(%rsi), %r8
        pextq	%rcx, %r9, %r9
        movq	%r10, 16(%rdi)
        sbbq	%r9, %r8
        movq	32(%rdx), %r10
        movq	32(%rsi), %r9
        pextq	%rcx, %r10, %r10
        movq	%r8, 24(%rdi)
        sbbq	%r10, %r9
        movq	40(%rdx), %r8
        movq	40(%rsi), %r10
        pextq	%rcx, %r8, %r8
        movq	%r9, 32(%rdi)
        sbbq	%r8, %r10
        movq	48(%rdx), %r9
        movq	48(%rsi), %r8
        pextq	%rcx, %r9, %r9
        movq	%r10, 40(%rdi)
        sbbq	%r9, %r8
        movq	56(%rdx), %r10
        movq	56(%rsi), %r9
        pextq	%rcx, %r10, %r10
        movq	%r8, 48(%rdi)
        sbbq	%r10, %r9
        movq	64(%rdx), %r8
        movq	64(%rsi), %r10
        pextq	%rcx, %r8, %r8
        movq	%r9, 56(%rdi)
        sbbq	%r8, %r10
        movq	72(%rdx), %r9
        movq	72(%rsi), %r8
        pextq	%rcx, %r9, %r9
        movq	%r10, 64(%rdi)
        sbbq	%r9, %r8
        movq	80(%rdx), %r10
        movq	80(%rsi), %r9
        pextq	%rcx, %r10, %r10
        movq	%r8, 72(%rdi)
        sbbq	%r10, %r9
        movq	88(%rdx), %r8
        movq	88(%rsi), %r10
        pextq	%rcx, %r8, %r8
        movq	%r9, 80(%rdi)
        sbbq	%r8, %r10
        movq	96(%rdx), %r9
        movq	96(%rsi), %r8
        pextq	%rcx, %r9, %r9
        movq	%r10, 88(%rdi)
        sbbq	%r9, %r8
        movq	104(%rdx), %r10
        movq	104(%rsi), %r9
        pextq	%rcx, %r10, %r10
        movq	%r8, 96(%rdi)
        sbbq	%r10, %r9
        movq	112(%rdx), %r8
        movq	112(%rsi), %r10
        pextq	%rcx, %r8, %r8
        movq	%r9, 104(%rdi)
        sbbq	%r8, %r10
        movq	120(%rdx), %r9
        movq	120(%rsi), %r8
        pextq	%rcx, %r9, %r9
        movq	%r10, 112(%rdi)
        sbbq	%r9, %r8
        movq	128(%rdx), %r10
        movq	128(%rsi), %r9
        pextq	%rcx, %r10, %r10
        movq	%r8, 120(%rdi)
        sbbq	%r10, %r9
        movq	136(%rdx), %r8
        movq	136(%rsi), %r10
        pextq	%rcx, %r8, %r8
        movq	%r9, 128(%rdi)
        sbbq	%r8, %r10
        movq	144(%rdx), %r9
        movq	144(%rsi), %r8
        pextq	%rcx, %r9, %r9
        movq	%r10, 136(%rdi)
        sbbq	%r9, %r8
        movq	152(%rdx), %r10
        movq	152(%rsi), %r9
        pextq	%rcx, %r10, %r10
        movq	%r8, 144(%rdi)
        sbbq	%r10, %r9
        movq	160(%rdx), %r8
        movq	160(%rsi), %r10
        pextq	%rcx, %r8, %r8
        movq	%r9, 152(%rdi)
        sbbq	%r8, %r10
        movq	168(%rdx), %r9
        movq	168(%rsi), %r8
        pextq	%rcx, %r9, %r9
        movq	%r10, 160(%rdi)
        sbbq	%r9, %r8
        movq	176(%rdx), %r10
        movq	176(%rsi), %r9
        pextq	%rcx, %r10, %r10
        movq	%r8, 168(%rdi)
        sbbq	%r10, %r9
        movq	184(%rdx), %r8
        movq	184(%rsi), %r10
        pextq	%rcx, %r8, %r8
        movq	%r9, 176(%rdi)
        sbbq	%r8, %r10
        movq	%r10, 184(%rdi)
        sbbq	%rax, %rax
        repz retq
#ifndef __APPLE__
.size	sp_3072_cond_sub_avx2_24,.-sp_3072_cond_sub_avx2_24
#endif /* __APPLE__ */
#endif /* HAVE_INTEL_AVX2 */
/* Mul a by digit b into r. (r = a * b)
 *
 * r  A single precision integer.
 * a  A single precision integer.
 * b  A single precision digit.
 */
#ifndef __APPLE__
.text
.globl	sp_3072_mul_d_24
.type	sp_3072_mul_d_24,@function
.align	16
sp_3072_mul_d_24:
#else
.section	__TEXT,__text
.globl	_sp_3072_mul_d_24
.p2align	4
_sp_3072_mul_d_24:
#endif /* __APPLE__ */
        movq	%rdx, %rcx
        # A[0] * B
        movq	%rcx, %rax
        xorq	%r10, %r10
        mulq	(%rsi)
        movq	%rax, %r8
        movq	%rdx, %r9
        movq	%r8, (%rdi)
        # A[1] * B
        movq	%rcx, %rax
        xorq	%r8, %r8
        mulq	8(%rsi)
        addq	%rax, %r9
        movq	%r9, 8(%rdi)
        adcq	%rdx, %r10
        adcq	$0x00, %r8
        # A[2] * B
        movq	%rcx, %rax
        xorq	%r9, %r9
        mulq	16(%rsi)
        addq	%rax, %r10
        movq	%r10, 16(%rdi)
        adcq	%rdx, %r8
        adcq	$0x00, %r9
        # A[3] * B
        movq	%rcx, %rax
        xorq	%r10, %r10
        mulq	24(%rsi)
        addq	%rax, %r8
        movq	%r8, 24(%rdi)
        adcq	%rdx, %r9
        adcq	$0x00, %r10
        # A[4] * B
        movq	%rcx, %rax
        xorq	%r8, %r8
        mulq	32(%rsi)
        addq	%rax, %r9
        movq	%r9, 32(%rdi)
        adcq	%rdx, %r10
        adcq	$0x00, %r8
        # A[5] * B
        movq	%rcx, %rax
        xorq	%r9, %r9
        mulq	40(%rsi)
        addq	%rax, %r10
        movq	%r10, 40(%rdi)
        adcq	%rdx, %r8
        adcq	$0x00, %r9
        # A[6] * B
        movq	%rcx, %rax
        xorq	%r10, %r10
        mulq	48(%rsi)
        addq	%rax, %r8
        movq	%r8, 48(%rdi)
        adcq	%rdx, %r9
        adcq	$0x00, %r10
        # A[7] * B
        movq	%rcx, %rax
        xorq	%r8, %r8
        mulq	56(%rsi)
        addq	%rax, %r9
        movq	%r9, 56(%rdi)
        adcq	%rdx, %r10
        adcq	$0x00, %r8
        # A[8] * B
        movq	%rcx, %rax
        xorq	%r9, %r9
        mulq	64(%rsi)
        addq	%rax, %r10
        movq	%r10, 64(%rdi)
        adcq	%rdx, %r8
        adcq	$0x00, %r9
        # A[9] * B
        movq	%rcx, %rax
        xorq	%r10, %r10
        mulq	72(%rsi)
        addq	%rax, %r8
        movq	%r8, 72(%rdi)
        adcq	%rdx, %r9
        adcq	$0x00, %r10
        # A[10] * B
        movq	%rcx, %rax
        xorq	%r8, %r8
        mulq	80(%rsi)
        addq	%rax, %r9
        movq	%r9, 80(%rdi)
        adcq	%rdx, %r10
        adcq	$0x00, %r8
        # A[11] * B
        movq	%rcx, %rax
        xorq	%r9, %r9
        mulq	88(%rsi)
        addq	%rax, %r10
        movq	%r10, 88(%rdi)
        adcq	%rdx, %r8
        adcq	$0x00, %r9
        # A[12] * B
        movq	%rcx, %rax
        xorq	%r10, %r10
        mulq	96(%rsi)
        addq	%rax, %r8
        movq	%r8, 96(%rdi)
        adcq	%rdx, %r9
        adcq	$0x00, %r10
        # A[13] * B
        movq	%rcx, %rax
        xorq	%r8, %r8
        mulq	104(%rsi)
        addq	%rax, %r9
        movq	%r9, 104(%rdi)
        adcq	%rdx, %r10
        adcq	$0x00, %r8
        # A[14] * B
        movq	%rcx, %rax
        xorq	%r9, %r9
        mulq	112(%rsi)
        addq	%rax, %r10
        movq	%r10, 112(%rdi)
        adcq	%rdx, %r8
        adcq	$0x00, %r9
        # A[15] * B
        movq	%rcx, %rax
        xorq	%r10, %r10
        mulq	120(%rsi)
        addq	%rax, %r8
        movq	%r8, 120(%rdi)
        adcq	%rdx, %r9
        adcq	$0x00, %r10
        # A[16] * B
        movq	%rcx, %rax
        xorq	%r8, %r8
        mulq	128(%rsi)
        addq	%rax, %r9
        movq	%r9, 128(%rdi)
        adcq	%rdx, %r10
        adcq	$0x00, %r8
        # A[17] * B
        movq	%rcx, %rax
        xorq	%r9, %r9
        mulq	136(%rsi)
        addq	%rax, %r10
        movq	%r10, 136(%rdi)
        adcq	%rdx, %r8
        adcq	$0x00, %r9
        # A[18] * B
        movq	%rcx, %rax
        xorq	%r10, %r10
        mulq	144(%rsi)
        addq	%rax, %r8
        movq	%r8, 144(%rdi)
        adcq	%rdx, %r9
        adcq	$0x00, %r10
        # A[19] * B
        movq	%rcx, %rax
        xorq	%r8, %r8
        mulq	152(%rsi)
        addq	%rax, %r9
        movq	%r9, 152(%rdi)
        adcq	%rdx, %r10
        adcq	$0x00, %r8
        # A[20] * B
        movq	%rcx, %rax
        xorq	%r9, %r9
        mulq	160(%rsi)
        addq	%rax, %r10
        movq	%r10, 160(%rdi)
        adcq	%rdx, %r8
        adcq	$0x00, %r9
        # A[21] * B
        movq	%rcx, %rax
        xorq	%r10, %r10
        mulq	168(%rsi)
        addq	%rax, %r8
        movq	%r8, 168(%rdi)
        adcq	%rdx, %r9
        adcq	$0x00, %r10
        # A[22] * B
        movq	%rcx, %rax
        xorq	%r8, %r8
        mulq	176(%rsi)
        addq	%rax, %r9
        movq	%r9, 176(%rdi)
        adcq	%rdx, %r10
        adcq	$0x00, %r8
        # A[23] * B
        movq	%rcx, %rax
        mulq	184(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        movq	%r10, 184(%rdi)
        movq	%r8, 192(%rdi)
        repz retq
#ifndef __APPLE__
.size	sp_3072_mul_d_24,.-sp_3072_mul_d_24
#endif /* __APPLE__ */
#ifdef HAVE_INTEL_AVX2
/* Mul a by digit b into r. (r = a * b)
 *
 * r  A single precision integer.
 * a  A single precision integer.
 * b  A single precision digit.
 */
#ifndef __APPLE__
.text
.globl	sp_3072_mul_d_avx2_24
.type	sp_3072_mul_d_avx2_24,@function
.align	16
sp_3072_mul_d_avx2_24:
#else
.section	__TEXT,__text
.globl	_sp_3072_mul_d_avx2_24
.p2align	4
_sp_3072_mul_d_avx2_24:
#endif /* __APPLE__ */
        movq	%rdx, %rax
        # A[0] * B
        movq	%rax, %rdx
        xorq	%r11, %r11
        mulxq	(%rsi), %r9, %r10
        movq	%r9, (%rdi)
        # A[1] * B
        mulxq	8(%rsi), %rcx, %r8
        movq	%r11, %r9
        adcxq	%rcx, %r10
        adoxq	%r8, %r9
        movq	%r10, 8(%rdi)
        # A[2] * B
        mulxq	16(%rsi), %rcx, %r8
        movq	%r11, %r10
        adcxq	%rcx, %r9
        adoxq	%r8, %r10
        movq	%r9, 16(%rdi)
        # A[3] * B
        mulxq	24(%rsi), %rcx, %r8
        movq	%r11, %r9
        adcxq	%rcx, %r10
        adoxq	%r8, %r9
        movq	%r10, 24(%rdi)
        # A[4] * B
        mulxq	32(%rsi), %rcx, %r8
        movq	%r11, %r10
        adcxq	%rcx, %r9
        adoxq	%r8, %r10
        movq	%r9, 32(%rdi)
        # A[5] * B
        mulxq	40(%rsi), %rcx, %r8
        movq	%r11, %r9
        adcxq	%rcx, %r10
        adoxq	%r8, %r9
        movq	%r10, 40(%rdi)
        # A[6] * B
        mulxq	48(%rsi), %rcx, %r8
        movq	%r11, %r10
        adcxq	%rcx, %r9
        adoxq	%r8, %r10
        movq	%r9, 48(%rdi)
        # A[7] * B
        mulxq	56(%rsi), %rcx, %r8
        movq	%r11, %r9
        adcxq	%rcx, %r10
        adoxq	%r8, %r9
        movq	%r10, 56(%rdi)
        # A[8] * B
        mulxq	64(%rsi), %rcx, %r8
        movq	%r11, %r10
        adcxq	%rcx, %r9
        adoxq	%r8, %r10
        movq	%r9, 64(%rdi)
        # A[9] * B
        mulxq	72(%rsi), %rcx, %r8
        movq	%r11, %r9
        adcxq	%rcx, %r10
        adoxq	%r8, %r9
        movq	%r10, 72(%rdi)
        # A[10] * B
        mulxq	80(%rsi), %rcx, %r8
        movq	%r11, %r10
        adcxq	%rcx, %r9
        adoxq	%r8, %r10
        movq	%r9, 80(%rdi)
        # A[11] * B
        mulxq	88(%rsi), %rcx, %r8
        movq	%r11, %r9
        adcxq	%rcx, %r10
        adoxq	%r8, %r9
        movq	%r10, 88(%rdi)
        # A[12] * B
        mulxq	96(%rsi), %rcx, %r8
        movq	%r11, %r10
        adcxq	%rcx, %r9
        adoxq	%r8, %r10
        movq	%r9, 96(%rdi)
        # A[13] * B
        mulxq	104(%rsi), %rcx, %r8
        movq	%r11, %r9
        adcxq	%rcx, %r10
        adoxq	%r8, %r9
        movq	%r10, 104(%rdi)
        # A[14] * B
        mulxq	112(%rsi), %rcx, %r8
        movq	%r11, %r10
        adcxq	%rcx, %r9
        adoxq	%r8, %r10
        movq	%r9, 112(%rdi)
        # A[15] * B
        mulxq	120(%rsi), %rcx, %r8
        movq	%r11, %r9
        adcxq	%rcx, %r10
        adoxq	%r8, %r9
        movq	%r10, 120(%rdi)
        # A[16] * B
        mulxq	128(%rsi), %rcx, %r8
        movq	%r11, %r10
        adcxq	%rcx, %r9
        adoxq	%r8, %r10
        movq	%r9, 128(%rdi)
        # A[17] * B
        mulxq	136(%rsi), %rcx, %r8
        movq	%r11, %r9
        adcxq	%rcx, %r10
        adoxq	%r8, %r9
        movq	%r10, 136(%rdi)
        # A[18] * B
        mulxq	144(%rsi), %rcx, %r8
        movq	%r11, %r10
        adcxq	%rcx, %r9
        adoxq	%r8, %r10
        movq	%r9, 144(%rdi)
        # A[19] * B
        mulxq	152(%rsi), %rcx, %r8
        movq	%r11, %r9
        adcxq	%rcx, %r10
        adoxq	%r8, %r9
        movq	%r10, 152(%rdi)
        # A[20] * B
        mulxq	160(%rsi), %rcx, %r8
        movq	%r11, %r10
        adcxq	%rcx, %r9
        adoxq	%r8, %r10
        movq	%r9, 160(%rdi)
        # A[21] * B
        mulxq	168(%rsi), %rcx, %r8
        movq	%r11, %r9
        adcxq	%rcx, %r10
        adoxq	%r8, %r9
        movq	%r10, 168(%rdi)
        # A[22] * B
        mulxq	176(%rsi), %rcx, %r8
        movq	%r11, %r10
        adcxq	%rcx, %r9
        adoxq	%r8, %r10
        movq	%r9, 176(%rdi)
        # A[23] * B
        mulxq	184(%rsi), %rcx, %r8
        movq	%r11, %r9
        adcxq	%rcx, %r10
        adoxq	%r8, %r9
        adcxq	%r11, %r9
        movq	%r10, 184(%rdi)
        movq	%r9, 192(%rdi)
        repz retq
#ifndef __APPLE__
.size	sp_3072_mul_d_avx2_24,.-sp_3072_mul_d_avx2_24
#endif /* __APPLE__ */
#endif /* HAVE_INTEL_AVX2 */
#ifdef _WIN64
/* Divide the double width number (d1|d0) by the dividend. (d1|d0 / div)
 *
 * d1   The high order half of the number to divide.
 * d0   The low order half of the number to divide.
 * div  The dividend.
 * returns the result of the division.
 */
#ifndef __APPLE__
.text
.globl	div_3072_word_asm_24
.type	div_3072_word_asm_24,@function
.align	16
div_3072_word_asm_24:
#else
.section	__TEXT,__text
.globl	_div_3072_word_asm_24
.p2align	4
_div_3072_word_asm_24:
#endif /* __APPLE__ */
        movq	%rdx, %rcx
        movq	%rsi, %rax
        movq	%rdi, %rdx
        divq	%rcx
        repz retq
#ifndef __APPLE__
.size	div_3072_word_asm_24,.-div_3072_word_asm_24
#endif /* __APPLE__ */
#endif /* _WIN64 */
/* Compare a with b in constant time.
 *
 * a  A single precision integer.
 * b  A single precision integer.
 * return -ve, 0 or +ve if a is less than, equal to or greater than b
 * respectively.
 */
#ifndef __APPLE__
.text
.globl	sp_3072_cmp_24
.type	sp_3072_cmp_24,@function
.align	16
sp_3072_cmp_24:
#else
.section	__TEXT,__text
.globl	_sp_3072_cmp_24
.p2align	4
_sp_3072_cmp_24:
#endif /* __APPLE__ */
        xorq	%rcx, %rcx
        movq	$-1, %rdx
        movq	$-1, %rax
        movq	$0x01, %r8
        movq	184(%rdi), %r9
        movq	184(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	176(%rdi), %r9
        movq	176(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	168(%rdi), %r9
        movq	168(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	160(%rdi), %r9
        movq	160(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	152(%rdi), %r9
        movq	152(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	144(%rdi), %r9
        movq	144(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	136(%rdi), %r9
        movq	136(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	128(%rdi), %r9
        movq	128(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	120(%rdi), %r9
        movq	120(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	112(%rdi), %r9
        movq	112(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	104(%rdi), %r9
        movq	104(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	96(%rdi), %r9
        movq	96(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	88(%rdi), %r9
        movq	88(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	80(%rdi), %r9
        movq	80(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	72(%rdi), %r9
        movq	72(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	64(%rdi), %r9
        movq	64(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	56(%rdi), %r9
        movq	56(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	48(%rdi), %r9
        movq	48(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	40(%rdi), %r9
        movq	40(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	32(%rdi), %r9
        movq	32(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	24(%rdi), %r9
        movq	24(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	16(%rdi), %r9
        movq	16(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	8(%rdi), %r9
        movq	8(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	(%rdi), %r9
        movq	(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        xorq	%rdx, %rax
        repz retq
#ifndef __APPLE__
.size	sp_3072_cmp_24,.-sp_3072_cmp_24
#endif /* __APPLE__ */
#ifndef WC_NO_CACHE_RESISTANT
#ifndef __APPLE__
.text
.globl	sp_3072_get_from_table_24
.type	sp_3072_get_from_table_24,@function
.align	16
sp_3072_get_from_table_24:
#else
.section	__TEXT,__text
.globl	_sp_3072_get_from_table_24
.p2align	4
_sp_3072_get_from_table_24:
#endif /* __APPLE__ */
        movq	$0x01, %rax
        movd	%rdx, %xmm10
        movd	%rax, %xmm11
        pxor	%xmm13, %xmm13
        pshufd	$0x00, %xmm11, %xmm11
        pshufd	$0x00, %xmm10, %xmm10
        # START: 0-7
        pxor	%xmm13, %xmm13
        pxor	%xmm4, %xmm4
        pxor	%xmm5, %xmm5
        pxor	%xmm6, %xmm6
        pxor	%xmm7, %xmm7
        # ENTRY: 0
        movq	(%rsi), %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 1
        movq	8(%rsi), %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 2
        movq	16(%rsi), %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 3
        movq	24(%rsi), %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 4
        movq	32(%rsi), %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 5
        movq	40(%rsi), %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 6
        movq	48(%rsi), %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 7
        movq	56(%rsi), %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 8
        movq	64(%rsi), %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 9
        movq	72(%rsi), %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 10
        movq	80(%rsi), %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 11
        movq	88(%rsi), %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 12
        movq	96(%rsi), %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 13
        movq	104(%rsi), %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 14
        movq	112(%rsi), %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 15
        movq	120(%rsi), %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 16
        movq	128(%rsi), %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 17
        movq	136(%rsi), %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 18
        movq	144(%rsi), %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 19
        movq	152(%rsi), %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 20
        movq	160(%rsi), %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 21
        movq	168(%rsi), %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 22
        movq	176(%rsi), %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 23
        movq	184(%rsi), %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 24
        movq	192(%rsi), %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 25
        movq	200(%rsi), %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 26
        movq	208(%rsi), %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 27
        movq	216(%rsi), %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 28
        movq	224(%rsi), %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 29
        movq	232(%rsi), %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 30
        movq	240(%rsi), %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 31
        movq	248(%rsi), %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        movdqu	%xmm4, (%rdi)
        movdqu	%xmm5, 16(%rdi)
        movdqu	%xmm6, 32(%rdi)
        movdqu	%xmm7, 48(%rdi)
        addq	$0x40, %rdi
        # END: 0-7
        # START: 8-15
        pxor	%xmm13, %xmm13
        pxor	%xmm4, %xmm4
        pxor	%xmm5, %xmm5
        pxor	%xmm6, %xmm6
        pxor	%xmm7, %xmm7
        # ENTRY: 0
        movq	(%rsi), %rcx
        addq	$0x40, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 1
        movq	8(%rsi), %rcx
        addq	$0x40, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 2
        movq	16(%rsi), %rcx
        addq	$0x40, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 3
        movq	24(%rsi), %rcx
        addq	$0x40, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 4
        movq	32(%rsi), %rcx
        addq	$0x40, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 5
        movq	40(%rsi), %rcx
        addq	$0x40, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 6
        movq	48(%rsi), %rcx
        addq	$0x40, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 7
        movq	56(%rsi), %rcx
        addq	$0x40, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 8
        movq	64(%rsi), %rcx
        addq	$0x40, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 9
        movq	72(%rsi), %rcx
        addq	$0x40, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 10
        movq	80(%rsi), %rcx
        addq	$0x40, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 11
        movq	88(%rsi), %rcx
        addq	$0x40, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 12
        movq	96(%rsi), %rcx
        addq	$0x40, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 13
        movq	104(%rsi), %rcx
        addq	$0x40, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 14
        movq	112(%rsi), %rcx
        addq	$0x40, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 15
        movq	120(%rsi), %rcx
        addq	$0x40, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 16
        movq	128(%rsi), %rcx
        addq	$0x40, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 17
        movq	136(%rsi), %rcx
        addq	$0x40, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 18
        movq	144(%rsi), %rcx
        addq	$0x40, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 19
        movq	152(%rsi), %rcx
        addq	$0x40, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 20
        movq	160(%rsi), %rcx
        addq	$0x40, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 21
        movq	168(%rsi), %rcx
        addq	$0x40, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 22
        movq	176(%rsi), %rcx
        addq	$0x40, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 23
        movq	184(%rsi), %rcx
        addq	$0x40, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 24
        movq	192(%rsi), %rcx
        addq	$0x40, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 25
        movq	200(%rsi), %rcx
        addq	$0x40, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 26
        movq	208(%rsi), %rcx
        addq	$0x40, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 27
        movq	216(%rsi), %rcx
        addq	$0x40, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 28
        movq	224(%rsi), %rcx
        addq	$0x40, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 29
        movq	232(%rsi), %rcx
        addq	$0x40, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 30
        movq	240(%rsi), %rcx
        addq	$0x40, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 31
        movq	248(%rsi), %rcx
        addq	$0x40, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        movdqu	%xmm4, (%rdi)
        movdqu	%xmm5, 16(%rdi)
        movdqu	%xmm6, 32(%rdi)
        movdqu	%xmm7, 48(%rdi)
        addq	$0x40, %rdi
        # END: 8-15
        # START: 16-23
        pxor	%xmm13, %xmm13
        pxor	%xmm4, %xmm4
        pxor	%xmm5, %xmm5
        pxor	%xmm6, %xmm6
        pxor	%xmm7, %xmm7
        # ENTRY: 0
        movq	(%rsi), %rcx
        addq	$0x80, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 1
        movq	8(%rsi), %rcx
        addq	$0x80, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 2
        movq	16(%rsi), %rcx
        addq	$0x80, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 3
        movq	24(%rsi), %rcx
        addq	$0x80, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 4
        movq	32(%rsi), %rcx
        addq	$0x80, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 5
        movq	40(%rsi), %rcx
        addq	$0x80, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 6
        movq	48(%rsi), %rcx
        addq	$0x80, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 7
        movq	56(%rsi), %rcx
        addq	$0x80, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 8
        movq	64(%rsi), %rcx
        addq	$0x80, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 9
        movq	72(%rsi), %rcx
        addq	$0x80, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 10
        movq	80(%rsi), %rcx
        addq	$0x80, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 11
        movq	88(%rsi), %rcx
        addq	$0x80, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 12
        movq	96(%rsi), %rcx
        addq	$0x80, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 13
        movq	104(%rsi), %rcx
        addq	$0x80, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 14
        movq	112(%rsi), %rcx
        addq	$0x80, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 15
        movq	120(%rsi), %rcx
        addq	$0x80, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 16
        movq	128(%rsi), %rcx
        addq	$0x80, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 17
        movq	136(%rsi), %rcx
        addq	$0x80, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 18
        movq	144(%rsi), %rcx
        addq	$0x80, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 19
        movq	152(%rsi), %rcx
        addq	$0x80, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 20
        movq	160(%rsi), %rcx
        addq	$0x80, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 21
        movq	168(%rsi), %rcx
        addq	$0x80, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 22
        movq	176(%rsi), %rcx
        addq	$0x80, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 23
        movq	184(%rsi), %rcx
        addq	$0x80, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 24
        movq	192(%rsi), %rcx
        addq	$0x80, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 25
        movq	200(%rsi), %rcx
        addq	$0x80, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 26
        movq	208(%rsi), %rcx
        addq	$0x80, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 27
        movq	216(%rsi), %rcx
        addq	$0x80, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 28
        movq	224(%rsi), %rcx
        addq	$0x80, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 29
        movq	232(%rsi), %rcx
        addq	$0x80, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 30
        movq	240(%rsi), %rcx
        addq	$0x80, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        # ENTRY: 31
        movq	248(%rsi), %rcx
        addq	$0x80, %rcx
        movdqu	%xmm13, %xmm12
        pcmpeqd	%xmm10, %xmm12
        movdqu	(%rcx), %xmm0
        movdqu	16(%rcx), %xmm1
        movdqu	32(%rcx), %xmm2
        movdqu	48(%rcx), %xmm3
        pand	%xmm12, %xmm0
        pand	%xmm12, %xmm1
        pand	%xmm12, %xmm2
        pand	%xmm12, %xmm3
        por	%xmm0, %xmm4
        por	%xmm1, %xmm5
        por	%xmm2, %xmm6
        por	%xmm3, %xmm7
        paddd	%xmm11, %xmm13
        movdqu	%xmm4, (%rdi)
        movdqu	%xmm5, 16(%rdi)
        movdqu	%xmm6, 32(%rdi)
        movdqu	%xmm7, 48(%rdi)
        # END: 16-23
        repz retq
#ifndef __APPLE__
.size	sp_3072_get_from_table_24,.-sp_3072_get_from_table_24
#endif /* __APPLE__ */
#endif /* !WC_NO_CACHE_RESISTANT */
#ifdef HAVE_INTEL_AVX2
/* Reduce the number back to 3072 bits using Montgomery reduction.
 *
 * a   A single precision number to reduce in place.
 * m   The single precision number representing the modulus.
 * mp  The digit representing the negative inverse of m mod 2^n.
 */
#ifndef __APPLE__
.text
.globl	sp_3072_mont_reduce_avx2_24
.type	sp_3072_mont_reduce_avx2_24,@function
.align	16
sp_3072_mont_reduce_avx2_24:
#else
.section	__TEXT,__text
.globl	_sp_3072_mont_reduce_avx2_24
.p2align	4
_sp_3072_mont_reduce_avx2_24:
#endif /* __APPLE__ */
        pushq	%r12
        pushq	%r13
        pushq	%r14
        pushq	%r15
        pushq	%rbx
        pushq	%rbp
        movq	%rdx, %r8
        xorq	%rbp, %rbp
        # i = 24
        movq	$24, %r9
        movq	(%rdi), %r12
        movq	8(%rdi), %r13
        movq	16(%rdi), %r14
        movq	24(%rdi), %r15
        addq	$0x60, %rdi
        xorq	%rbp, %rbp
L_3072_mont_reduce_avx2_24_loop:
        # mu = a[i] * mp
        movq	%r12, %rdx
        movq	%r12, %r10
        imulq	%r8, %rdx
        xorq	%rbx, %rbx
        # a[i+0] += m[0] * mu
        mulxq	(%rsi), %rax, %rcx
        movq	%r13, %r12
        adcxq	%rax, %r10
        adoxq	%rcx, %r12
        # a[i+1] += m[1] * mu
        mulxq	8(%rsi), %rax, %rcx
        movq	%r14, %r13
        adcxq	%rax, %r12
        adoxq	%rcx, %r13
        # a[i+2] += m[2] * mu
        mulxq	16(%rsi), %rax, %rcx
        movq	%r15, %r14
        adcxq	%rax, %r13
        adoxq	%rcx, %r14
        # a[i+3] += m[3] * mu
        mulxq	24(%rsi), %rax, %rcx
        movq	-64(%rdi), %r15
        adcxq	%rax, %r14
        adoxq	%rcx, %r15
        # a[i+4] += m[4] * mu
        mulxq	32(%rsi), %rax, %rcx
        movq	-56(%rdi), %r11
        adcxq	%rax, %r15
        adoxq	%rcx, %r11
        # a[i+5] += m[5] * mu
        mulxq	40(%rsi), %rax, %rcx
        movq	-48(%rdi), %r10
        adcxq	%rax, %r11
        adoxq	%rcx, %r10
        movq	%r11, -56(%rdi)
        # a[i+6] += m[6] * mu
        mulxq	48(%rsi), %rax, %rcx
        movq	-40(%rdi), %r11
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        movq	%r10, -48(%rdi)
        # a[i+7] += m[7] * mu
        mulxq	56(%rsi), %rax, %rcx
        movq	-32(%rdi), %r10
        adcxq	%rax, %r11
        adoxq	%rcx, %r10
        movq	%r11, -40(%rdi)
        # a[i+8] += m[8] * mu
        mulxq	64(%rsi), %rax, %rcx
        movq	-24(%rdi), %r11
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        movq	%r10, -32(%rdi)
        # a[i+9] += m[9] * mu
        mulxq	72(%rsi), %rax, %rcx
        movq	-16(%rdi), %r10
        adcxq	%rax, %r11
        adoxq	%rcx, %r10
        movq	%r11, -24(%rdi)
        # a[i+10] += m[10] * mu
        mulxq	80(%rsi), %rax, %rcx
        movq	-8(%rdi), %r11
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        movq	%r10, -16(%rdi)
        # a[i+11] += m[11] * mu
        mulxq	88(%rsi), %rax, %rcx
        movq	(%rdi), %r10
        adcxq	%rax, %r11
        adoxq	%rcx, %r10
        movq	%r11, -8(%rdi)
        # a[i+12] += m[12] * mu
        mulxq	96(%rsi), %rax, %rcx
        movq	8(%rdi), %r11
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        movq	%r10, (%rdi)
        # a[i+13] += m[13] * mu
        mulxq	104(%rsi), %rax, %rcx
        movq	16(%rdi), %r10
        adcxq	%rax, %r11
        adoxq	%rcx, %r10
        movq	%r11, 8(%rdi)
        # a[i+14] += m[14] * mu
        mulxq	112(%rsi), %rax, %rcx
        movq	24(%rdi), %r11
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        movq	%r10, 16(%rdi)
        # a[i+15] += m[15] * mu
        mulxq	120(%rsi), %rax, %rcx
        movq	32(%rdi), %r10
        adcxq	%rax, %r11
        adoxq	%rcx, %r10
        movq	%r11, 24(%rdi)
        # a[i+16] += m[16] * mu
        mulxq	128(%rsi), %rax, %rcx
        movq	40(%rdi), %r11
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        movq	%r10, 32(%rdi)
        # a[i+17] += m[17] * mu
        mulxq	136(%rsi), %rax, %rcx
        movq	48(%rdi), %r10
        adcxq	%rax, %r11
        adoxq	%rcx, %r10
        movq	%r11, 40(%rdi)
        # a[i+18] += m[18] * mu
        mulxq	144(%rsi), %rax, %rcx
        movq	56(%rdi), %r11
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        movq	%r10, 48(%rdi)
        # a[i+19] += m[19] * mu
        mulxq	152(%rsi), %rax, %rcx
        movq	64(%rdi), %r10
        adcxq	%rax, %r11
        adoxq	%rcx, %r10
        movq	%r11, 56(%rdi)
        # a[i+20] += m[20] * mu
        mulxq	160(%rsi), %rax, %rcx
        movq	72(%rdi), %r11
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        movq	%r10, 64(%rdi)
        # a[i+21] += m[21] * mu
        mulxq	168(%rsi), %rax, %rcx
        movq	80(%rdi), %r10
        adcxq	%rax, %r11
        adoxq	%rcx, %r10
        movq	%r11, 72(%rdi)
        # a[i+22] += m[22] * mu
        mulxq	176(%rsi), %rax, %rcx
        movq	88(%rdi), %r11
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        movq	%r10, 80(%rdi)
        # a[i+23] += m[23] * mu
        mulxq	184(%rsi), %rax, %rcx
        movq	96(%rdi), %r10
        adcxq	%rax, %r11
        adoxq	%rcx, %r10
        movq	%r11, 88(%rdi)
        adcxq	%rbp, %r10
        movq	%rbx, %rbp
        movq	%r10, 96(%rdi)
        adoxq	%rbx, %rbp
        adcxq	%rbx, %rbp
        # a += 1
        addq	$8, %rdi
        # i -= 1
        subq	$0x01, %r9
        jnz	L_3072_mont_reduce_avx2_24_loop
        subq	$0x60, %rdi
        negq	%rbp
        movq	%rdi, %r8
        subq	$0xc0, %rdi
        movq	(%rsi), %rcx
        movq	%r12, %rdx
        pextq	%rbp, %rcx, %rcx
        subq	%rcx, %rdx
        movq	8(%rsi), %rcx
        movq	%r13, %rax
        pextq	%rbp, %rcx, %rcx
        movq	%rdx, (%rdi)
        sbbq	%rcx, %rax
        movq	16(%rsi), %rdx
        movq	%r14, %rcx
        pextq	%rbp, %rdx, %rdx
        movq	%rax, 8(%rdi)
        sbbq	%rdx, %rcx
        movq	24(%rsi), %rax
        movq	%r15, %rdx
        pextq	%rbp, %rax, %rax
        movq	%rcx, 16(%rdi)
        sbbq	%rax, %rdx
        movq	32(%rsi), %rcx
        movq	32(%r8), %rax
        pextq	%rbp, %rcx, %rcx
        movq	%rdx, 24(%rdi)
        sbbq	%rcx, %rax
        movq	40(%rsi), %rdx
        movq	40(%r8), %rcx
        pextq	%rbp, %rdx, %rdx
        movq	%rax, 32(%rdi)
        sbbq	%rdx, %rcx
        movq	48(%rsi), %rax
        movq	48(%r8), %rdx
        pextq	%rbp, %rax, %rax
        movq	%rcx, 40(%rdi)
        sbbq	%rax, %rdx
        movq	56(%rsi), %rcx
        movq	56(%r8), %rax
        pextq	%rbp, %rcx, %rcx
        movq	%rdx, 48(%rdi)
        sbbq	%rcx, %rax
        movq	64(%rsi), %rdx
        movq	64(%r8), %rcx
        pextq	%rbp, %rdx, %rdx
        movq	%rax, 56(%rdi)
        sbbq	%rdx, %rcx
        movq	72(%rsi), %rax
        movq	72(%r8), %rdx
        pextq	%rbp, %rax, %rax
        movq	%rcx, 64(%rdi)
        sbbq	%rax, %rdx
        movq	80(%rsi), %rcx
        movq	80(%r8), %rax
        pextq	%rbp, %rcx, %rcx
        movq	%rdx, 72(%rdi)
        sbbq	%rcx, %rax
        movq	88(%rsi), %rdx
        movq	88(%r8), %rcx
        pextq	%rbp, %rdx, %rdx
        movq	%rax, 80(%rdi)
        sbbq	%rdx, %rcx
        movq	96(%rsi), %rax
        movq	96(%r8), %rdx
        pextq	%rbp, %rax, %rax
        movq	%rcx, 88(%rdi)
        sbbq	%rax, %rdx
        movq	104(%rsi), %rcx
        movq	104(%r8), %rax
        pextq	%rbp, %rcx, %rcx
        movq	%rdx, 96(%rdi)
        sbbq	%rcx, %rax
        movq	112(%rsi), %rdx
        movq	112(%r8), %rcx
        pextq	%rbp, %rdx, %rdx
        movq	%rax, 104(%rdi)
        sbbq	%rdx, %rcx
        movq	120(%rsi), %rax
        movq	120(%r8), %rdx
        pextq	%rbp, %rax, %rax
        movq	%rcx, 112(%rdi)
        sbbq	%rax, %rdx
        movq	128(%rsi), %rcx
        movq	128(%r8), %rax
        pextq	%rbp, %rcx, %rcx
        movq	%rdx, 120(%rdi)
        sbbq	%rcx, %rax
        movq	136(%rsi), %rdx
        movq	136(%r8), %rcx
        pextq	%rbp, %rdx, %rdx
        movq	%rax, 128(%rdi)
        sbbq	%rdx, %rcx
        movq	144(%rsi), %rax
        movq	144(%r8), %rdx
        pextq	%rbp, %rax, %rax
        movq	%rcx, 136(%rdi)
        sbbq	%rax, %rdx
        movq	152(%rsi), %rcx
        movq	152(%r8), %rax
        pextq	%rbp, %rcx, %rcx
        movq	%rdx, 144(%rdi)
        sbbq	%rcx, %rax
        movq	160(%rsi), %rdx
        movq	160(%r8), %rcx
        pextq	%rbp, %rdx, %rdx
        movq	%rax, 152(%rdi)
        sbbq	%rdx, %rcx
        movq	168(%rsi), %rax
        movq	168(%r8), %rdx
        pextq	%rbp, %rax, %rax
        movq	%rcx, 160(%rdi)
        sbbq	%rax, %rdx
        movq	176(%rsi), %rcx
        movq	176(%r8), %rax
        pextq	%rbp, %rcx, %rcx
        movq	%rdx, 168(%rdi)
        sbbq	%rcx, %rax
        movq	184(%rsi), %rdx
        movq	184(%r8), %rcx
        pextq	%rbp, %rdx, %rdx
        movq	%rax, 176(%rdi)
        sbbq	%rdx, %rcx
        movq	%rcx, 184(%rdi)
        popq	%rbp
        popq	%rbx
        popq	%r15
        popq	%r14
        popq	%r13
        popq	%r12
        repz retq
#ifndef __APPLE__
.size	sp_3072_mont_reduce_avx2_24,.-sp_3072_mont_reduce_avx2_24
#endif /* __APPLE__ */
#endif /* HAVE_INTEL_AVX2 */
#ifndef WC_NO_CACHE_RESISTANT
#ifndef __APPLE__
.text
.globl	sp_3072_get_from_table_avx2_24
.type	sp_3072_get_from_table_avx2_24,@function
.align	16
sp_3072_get_from_table_avx2_24:
#else
.section	__TEXT,__text
.globl	_sp_3072_get_from_table_avx2_24
.p2align	4
_sp_3072_get_from_table_avx2_24:
#endif /* __APPLE__ */
        movq	$0x01, %rax
        movd	%rdx, %xmm10
        movd	%rax, %xmm11
        vpxor	%ymm13, %ymm13, %ymm13
        vpermd	%ymm10, %ymm13, %ymm10
        vpermd	%ymm11, %ymm13, %ymm11
        # START: 0-15
        vpxor	%ymm13, %ymm13, %ymm13
        vpxor	%ymm4, %ymm4, %ymm4
        vpxor	%ymm5, %ymm5, %ymm5
        vpxor	%ymm6, %ymm6, %ymm6
        vpxor	%ymm7, %ymm7, %ymm7
        # ENTRY: 0
        movq	(%rsi), %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vmovdqu	64(%rcx), %ymm2
        vmovdqu	96(%rcx), %ymm3
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpand	%ymm12, %ymm2, %ymm2
        vpand	%ymm12, %ymm3, %ymm3
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpor	%ymm2, %ymm6, %ymm6
        vpor	%ymm3, %ymm7, %ymm7
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 1
        movq	8(%rsi), %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vmovdqu	64(%rcx), %ymm2
        vmovdqu	96(%rcx), %ymm3
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpand	%ymm12, %ymm2, %ymm2
        vpand	%ymm12, %ymm3, %ymm3
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpor	%ymm2, %ymm6, %ymm6
        vpor	%ymm3, %ymm7, %ymm7
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 2
        movq	16(%rsi), %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vmovdqu	64(%rcx), %ymm2
        vmovdqu	96(%rcx), %ymm3
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpand	%ymm12, %ymm2, %ymm2
        vpand	%ymm12, %ymm3, %ymm3
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpor	%ymm2, %ymm6, %ymm6
        vpor	%ymm3, %ymm7, %ymm7
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 3
        movq	24(%rsi), %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vmovdqu	64(%rcx), %ymm2
        vmovdqu	96(%rcx), %ymm3
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpand	%ymm12, %ymm2, %ymm2
        vpand	%ymm12, %ymm3, %ymm3
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpor	%ymm2, %ymm6, %ymm6
        vpor	%ymm3, %ymm7, %ymm7
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 4
        movq	32(%rsi), %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vmovdqu	64(%rcx), %ymm2
        vmovdqu	96(%rcx), %ymm3
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpand	%ymm12, %ymm2, %ymm2
        vpand	%ymm12, %ymm3, %ymm3
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpor	%ymm2, %ymm6, %ymm6
        vpor	%ymm3, %ymm7, %ymm7
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 5
        movq	40(%rsi), %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vmovdqu	64(%rcx), %ymm2
        vmovdqu	96(%rcx), %ymm3
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpand	%ymm12, %ymm2, %ymm2
        vpand	%ymm12, %ymm3, %ymm3
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpor	%ymm2, %ymm6, %ymm6
        vpor	%ymm3, %ymm7, %ymm7
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 6
        movq	48(%rsi), %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vmovdqu	64(%rcx), %ymm2
        vmovdqu	96(%rcx), %ymm3
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpand	%ymm12, %ymm2, %ymm2
        vpand	%ymm12, %ymm3, %ymm3
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpor	%ymm2, %ymm6, %ymm6
        vpor	%ymm3, %ymm7, %ymm7
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 7
        movq	56(%rsi), %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vmovdqu	64(%rcx), %ymm2
        vmovdqu	96(%rcx), %ymm3
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpand	%ymm12, %ymm2, %ymm2
        vpand	%ymm12, %ymm3, %ymm3
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpor	%ymm2, %ymm6, %ymm6
        vpor	%ymm3, %ymm7, %ymm7
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 8
        movq	64(%rsi), %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vmovdqu	64(%rcx), %ymm2
        vmovdqu	96(%rcx), %ymm3
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpand	%ymm12, %ymm2, %ymm2
        vpand	%ymm12, %ymm3, %ymm3
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpor	%ymm2, %ymm6, %ymm6
        vpor	%ymm3, %ymm7, %ymm7
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 9
        movq	72(%rsi), %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vmovdqu	64(%rcx), %ymm2
        vmovdqu	96(%rcx), %ymm3
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpand	%ymm12, %ymm2, %ymm2
        vpand	%ymm12, %ymm3, %ymm3
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpor	%ymm2, %ymm6, %ymm6
        vpor	%ymm3, %ymm7, %ymm7
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 10
        movq	80(%rsi), %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vmovdqu	64(%rcx), %ymm2
        vmovdqu	96(%rcx), %ymm3
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpand	%ymm12, %ymm2, %ymm2
        vpand	%ymm12, %ymm3, %ymm3
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpor	%ymm2, %ymm6, %ymm6
        vpor	%ymm3, %ymm7, %ymm7
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 11
        movq	88(%rsi), %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vmovdqu	64(%rcx), %ymm2
        vmovdqu	96(%rcx), %ymm3
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpand	%ymm12, %ymm2, %ymm2
        vpand	%ymm12, %ymm3, %ymm3
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpor	%ymm2, %ymm6, %ymm6
        vpor	%ymm3, %ymm7, %ymm7
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 12
        movq	96(%rsi), %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vmovdqu	64(%rcx), %ymm2
        vmovdqu	96(%rcx), %ymm3
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpand	%ymm12, %ymm2, %ymm2
        vpand	%ymm12, %ymm3, %ymm3
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpor	%ymm2, %ymm6, %ymm6
        vpor	%ymm3, %ymm7, %ymm7
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 13
        movq	104(%rsi), %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vmovdqu	64(%rcx), %ymm2
        vmovdqu	96(%rcx), %ymm3
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpand	%ymm12, %ymm2, %ymm2
        vpand	%ymm12, %ymm3, %ymm3
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpor	%ymm2, %ymm6, %ymm6
        vpor	%ymm3, %ymm7, %ymm7
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 14
        movq	112(%rsi), %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vmovdqu	64(%rcx), %ymm2
        vmovdqu	96(%rcx), %ymm3
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpand	%ymm12, %ymm2, %ymm2
        vpand	%ymm12, %ymm3, %ymm3
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpor	%ymm2, %ymm6, %ymm6
        vpor	%ymm3, %ymm7, %ymm7
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 15
        movq	120(%rsi), %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vmovdqu	64(%rcx), %ymm2
        vmovdqu	96(%rcx), %ymm3
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpand	%ymm12, %ymm2, %ymm2
        vpand	%ymm12, %ymm3, %ymm3
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpor	%ymm2, %ymm6, %ymm6
        vpor	%ymm3, %ymm7, %ymm7
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 16
        movq	128(%rsi), %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vmovdqu	64(%rcx), %ymm2
        vmovdqu	96(%rcx), %ymm3
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpand	%ymm12, %ymm2, %ymm2
        vpand	%ymm12, %ymm3, %ymm3
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpor	%ymm2, %ymm6, %ymm6
        vpor	%ymm3, %ymm7, %ymm7
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 17
        movq	136(%rsi), %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vmovdqu	64(%rcx), %ymm2
        vmovdqu	96(%rcx), %ymm3
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpand	%ymm12, %ymm2, %ymm2
        vpand	%ymm12, %ymm3, %ymm3
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpor	%ymm2, %ymm6, %ymm6
        vpor	%ymm3, %ymm7, %ymm7
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 18
        movq	144(%rsi), %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vmovdqu	64(%rcx), %ymm2
        vmovdqu	96(%rcx), %ymm3
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpand	%ymm12, %ymm2, %ymm2
        vpand	%ymm12, %ymm3, %ymm3
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpor	%ymm2, %ymm6, %ymm6
        vpor	%ymm3, %ymm7, %ymm7
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 19
        movq	152(%rsi), %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vmovdqu	64(%rcx), %ymm2
        vmovdqu	96(%rcx), %ymm3
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpand	%ymm12, %ymm2, %ymm2
        vpand	%ymm12, %ymm3, %ymm3
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpor	%ymm2, %ymm6, %ymm6
        vpor	%ymm3, %ymm7, %ymm7
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 20
        movq	160(%rsi), %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vmovdqu	64(%rcx), %ymm2
        vmovdqu	96(%rcx), %ymm3
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpand	%ymm12, %ymm2, %ymm2
        vpand	%ymm12, %ymm3, %ymm3
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpor	%ymm2, %ymm6, %ymm6
        vpor	%ymm3, %ymm7, %ymm7
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 21
        movq	168(%rsi), %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vmovdqu	64(%rcx), %ymm2
        vmovdqu	96(%rcx), %ymm3
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpand	%ymm12, %ymm2, %ymm2
        vpand	%ymm12, %ymm3, %ymm3
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpor	%ymm2, %ymm6, %ymm6
        vpor	%ymm3, %ymm7, %ymm7
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 22
        movq	176(%rsi), %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vmovdqu	64(%rcx), %ymm2
        vmovdqu	96(%rcx), %ymm3
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpand	%ymm12, %ymm2, %ymm2
        vpand	%ymm12, %ymm3, %ymm3
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpor	%ymm2, %ymm6, %ymm6
        vpor	%ymm3, %ymm7, %ymm7
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 23
        movq	184(%rsi), %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vmovdqu	64(%rcx), %ymm2
        vmovdqu	96(%rcx), %ymm3
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpand	%ymm12, %ymm2, %ymm2
        vpand	%ymm12, %ymm3, %ymm3
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpor	%ymm2, %ymm6, %ymm6
        vpor	%ymm3, %ymm7, %ymm7
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 24
        movq	192(%rsi), %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vmovdqu	64(%rcx), %ymm2
        vmovdqu	96(%rcx), %ymm3
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpand	%ymm12, %ymm2, %ymm2
        vpand	%ymm12, %ymm3, %ymm3
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpor	%ymm2, %ymm6, %ymm6
        vpor	%ymm3, %ymm7, %ymm7
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 25
        movq	200(%rsi), %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vmovdqu	64(%rcx), %ymm2
        vmovdqu	96(%rcx), %ymm3
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpand	%ymm12, %ymm2, %ymm2
        vpand	%ymm12, %ymm3, %ymm3
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpor	%ymm2, %ymm6, %ymm6
        vpor	%ymm3, %ymm7, %ymm7
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 26
        movq	208(%rsi), %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vmovdqu	64(%rcx), %ymm2
        vmovdqu	96(%rcx), %ymm3
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpand	%ymm12, %ymm2, %ymm2
        vpand	%ymm12, %ymm3, %ymm3
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpor	%ymm2, %ymm6, %ymm6
        vpor	%ymm3, %ymm7, %ymm7
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 27
        movq	216(%rsi), %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vmovdqu	64(%rcx), %ymm2
        vmovdqu	96(%rcx), %ymm3
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpand	%ymm12, %ymm2, %ymm2
        vpand	%ymm12, %ymm3, %ymm3
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpor	%ymm2, %ymm6, %ymm6
        vpor	%ymm3, %ymm7, %ymm7
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 28
        movq	224(%rsi), %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vmovdqu	64(%rcx), %ymm2
        vmovdqu	96(%rcx), %ymm3
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpand	%ymm12, %ymm2, %ymm2
        vpand	%ymm12, %ymm3, %ymm3
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpor	%ymm2, %ymm6, %ymm6
        vpor	%ymm3, %ymm7, %ymm7
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 29
        movq	232(%rsi), %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vmovdqu	64(%rcx), %ymm2
        vmovdqu	96(%rcx), %ymm3
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpand	%ymm12, %ymm2, %ymm2
        vpand	%ymm12, %ymm3, %ymm3
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpor	%ymm2, %ymm6, %ymm6
        vpor	%ymm3, %ymm7, %ymm7
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 30
        movq	240(%rsi), %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vmovdqu	64(%rcx), %ymm2
        vmovdqu	96(%rcx), %ymm3
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpand	%ymm12, %ymm2, %ymm2
        vpand	%ymm12, %ymm3, %ymm3
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpor	%ymm2, %ymm6, %ymm6
        vpor	%ymm3, %ymm7, %ymm7
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 31
        movq	248(%rsi), %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vmovdqu	64(%rcx), %ymm2
        vmovdqu	96(%rcx), %ymm3
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpand	%ymm12, %ymm2, %ymm2
        vpand	%ymm12, %ymm3, %ymm3
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpor	%ymm2, %ymm6, %ymm6
        vpor	%ymm3, %ymm7, %ymm7
        vpaddd	%ymm11, %ymm13, %ymm13
        vmovdqu	%ymm4, (%rdi)
        vmovdqu	%ymm5, 32(%rdi)
        vmovdqu	%ymm6, 64(%rdi)
        vmovdqu	%ymm7, 96(%rdi)
        addq	$0x80, %rdi
        # END: 0-15
        # START: 16-23
        vpxor	%ymm13, %ymm13, %ymm13
        vpxor	%ymm4, %ymm4, %ymm4
        vpxor	%ymm5, %ymm5, %ymm5
        # ENTRY: 0
        movq	(%rsi), %rcx
        addq	$0x80, %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 1
        movq	8(%rsi), %rcx
        addq	$0x80, %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 2
        movq	16(%rsi), %rcx
        addq	$0x80, %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 3
        movq	24(%rsi), %rcx
        addq	$0x80, %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 4
        movq	32(%rsi), %rcx
        addq	$0x80, %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 5
        movq	40(%rsi), %rcx
        addq	$0x80, %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 6
        movq	48(%rsi), %rcx
        addq	$0x80, %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 7
        movq	56(%rsi), %rcx
        addq	$0x80, %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 8
        movq	64(%rsi), %rcx
        addq	$0x80, %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 9
        movq	72(%rsi), %rcx
        addq	$0x80, %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 10
        movq	80(%rsi), %rcx
        addq	$0x80, %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 11
        movq	88(%rsi), %rcx
        addq	$0x80, %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 12
        movq	96(%rsi), %rcx
        addq	$0x80, %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 13
        movq	104(%rsi), %rcx
        addq	$0x80, %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 14
        movq	112(%rsi), %rcx
        addq	$0x80, %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 15
        movq	120(%rsi), %rcx
        addq	$0x80, %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 16
        movq	128(%rsi), %rcx
        addq	$0x80, %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 17
        movq	136(%rsi), %rcx
        addq	$0x80, %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 18
        movq	144(%rsi), %rcx
        addq	$0x80, %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 19
        movq	152(%rsi), %rcx
        addq	$0x80, %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 20
        movq	160(%rsi), %rcx
        addq	$0x80, %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 21
        movq	168(%rsi), %rcx
        addq	$0x80, %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 22
        movq	176(%rsi), %rcx
        addq	$0x80, %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 23
        movq	184(%rsi), %rcx
        addq	$0x80, %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 24
        movq	192(%rsi), %rcx
        addq	$0x80, %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 25
        movq	200(%rsi), %rcx
        addq	$0x80, %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 26
        movq	208(%rsi), %rcx
        addq	$0x80, %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 27
        movq	216(%rsi), %rcx
        addq	$0x80, %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 28
        movq	224(%rsi), %rcx
        addq	$0x80, %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 29
        movq	232(%rsi), %rcx
        addq	$0x80, %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 30
        movq	240(%rsi), %rcx
        addq	$0x80, %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpaddd	%ymm11, %ymm13, %ymm13
        # ENTRY: 31
        movq	248(%rsi), %rcx
        addq	$0x80, %rcx
        vpcmpeqd	%ymm10, %ymm13, %ymm12
        vmovdqu	(%rcx), %ymm0
        vmovdqu	32(%rcx), %ymm1
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vpaddd	%ymm11, %ymm13, %ymm13
        vmovdqu	%ymm4, (%rdi)
        vmovdqu	%ymm5, 32(%rdi)
        # END: 16-23
        repz retq
#ifndef __APPLE__
.size	sp_3072_get_from_table_avx2_24,.-sp_3072_get_from_table_avx2_24
#endif /* __APPLE__ */
#endif /* !WC_NO_CACHE_RESISTANT */
/* Conditionally subtract b from a using the mask m.
 * m is -1 to subtract and 0 when not copying.
 *
 * r  A single precision number representing condition subtract result.
 * a  A single precision number to subtract from.
 * b  A single precision number to subtract.
 * m  Mask value to apply.
 */
#ifndef __APPLE__
.text
.globl	sp_3072_cond_sub_48
.type	sp_3072_cond_sub_48,@function
.align	16
sp_3072_cond_sub_48:
#else
.section	__TEXT,__text
.globl	_sp_3072_cond_sub_48
.p2align	4
_sp_3072_cond_sub_48:
#endif /* __APPLE__ */
        subq	$0x180, %rsp
        movq	(%rdx), %r8
        movq	8(%rdx), %r9
        andq	%rcx, %r8
        andq	%rcx, %r9
        movq	%r8, (%rsp)
        movq	%r9, 8(%rsp)
        movq	16(%rdx), %r8
        movq	24(%rdx), %r9
        andq	%rcx, %r8
        andq	%rcx, %r9
        movq	%r8, 16(%rsp)
        movq	%r9, 24(%rsp)
        movq	32(%rdx), %r8
        movq	40(%rdx), %r9
        andq	%rcx, %r8
        andq	%rcx, %r9
        movq	%r8, 32(%rsp)
        movq	%r9, 40(%rsp)
        movq	48(%rdx), %r8
        movq	56(%rdx), %r9
        andq	%rcx, %r8
        andq	%rcx, %r9
        movq	%r8, 48(%rsp)
        movq	%r9, 56(%rsp)
        movq	64(%rdx), %r8
        movq	72(%rdx), %r9
        andq	%rcx, %r8
        andq	%rcx, %r9
        movq	%r8, 64(%rsp)
        movq	%r9, 72(%rsp)
        movq	80(%rdx), %r8
        movq	88(%rdx), %r9
        andq	%rcx, %r8
        andq	%rcx, %r9
        movq	%r8, 80(%rsp)
        movq	%r9, 88(%rsp)
        movq	96(%rdx), %r8
        movq	104(%rdx), %r9
        andq	%rcx, %r8
        andq	%rcx, %r9
        movq	%r8, 96(%rsp)
        movq	%r9, 104(%rsp)
        movq	112(%rdx), %r8
        movq	120(%rdx), %r9
        andq	%rcx, %r8
        andq	%rcx, %r9
        movq	%r8, 112(%rsp)
        movq	%r9, 120(%rsp)
        movq	128(%rdx), %r8
        movq	136(%rdx), %r9
        andq	%rcx, %r8
        andq	%rcx, %r9
        movq	%r8, 128(%rsp)
        movq	%r9, 136(%rsp)
        movq	144(%rdx), %r8
        movq	152(%rdx), %r9
        andq	%rcx, %r8
        andq	%rcx, %r9
        movq	%r8, 144(%rsp)
        movq	%r9, 152(%rsp)
        movq	160(%rdx), %r8
        movq	168(%rdx), %r9
        andq	%rcx, %r8
        andq	%rcx, %r9
        movq	%r8, 160(%rsp)
        movq	%r9, 168(%rsp)
        movq	176(%rdx), %r8
        movq	184(%rdx), %r9
        andq	%rcx, %r8
        andq	%rcx, %r9
        movq	%r8, 176(%rsp)
        movq	%r9, 184(%rsp)
        movq	192(%rdx), %r8
        movq	200(%rdx), %r9
        andq	%rcx, %r8
        andq	%rcx, %r9
        movq	%r8, 192(%rsp)
        movq	%r9, 200(%rsp)
        movq	208(%rdx), %r8
        movq	216(%rdx), %r9
        andq	%rcx, %r8
        andq	%rcx, %r9
        movq	%r8, 208(%rsp)
        movq	%r9, 216(%rsp)
        movq	224(%rdx), %r8
        movq	232(%rdx), %r9
        andq	%rcx, %r8
        andq	%rcx, %r9
        movq	%r8, 224(%rsp)
        movq	%r9, 232(%rsp)
        movq	240(%rdx), %r8
        movq	248(%rdx), %r9
        andq	%rcx, %r8
        andq	%rcx, %r9
        movq	%r8, 240(%rsp)
        movq	%r9, 248(%rsp)
        movq	256(%rdx), %r8
        movq	264(%rdx), %r9
        andq	%rcx, %r8
        andq	%rcx, %r9
        movq	%r8, 256(%rsp)
        movq	%r9, 264(%rsp)
        movq	272(%rdx), %r8
        movq	280(%rdx), %r9
        andq	%rcx, %r8
        andq	%rcx, %r9
        movq	%r8, 272(%rsp)
        movq	%r9, 280(%rsp)
        movq	288(%rdx), %r8
        movq	296(%rdx), %r9
        andq	%rcx, %r8
        andq	%rcx, %r9
        movq	%r8, 288(%rsp)
        movq	%r9, 296(%rsp)
        movq	304(%rdx), %r8
        movq	312(%rdx), %r9
        andq	%rcx, %r8
        andq	%rcx, %r9
        movq	%r8, 304(%rsp)
        movq	%r9, 312(%rsp)
        movq	320(%rdx), %r8
        movq	328(%rdx), %r9
        andq	%rcx, %r8
        andq	%rcx, %r9
        movq	%r8, 320(%rsp)
        movq	%r9, 328(%rsp)
        movq	336(%rdx), %r8
        movq	344(%rdx), %r9
        andq	%rcx, %r8
        andq	%rcx, %r9
        movq	%r8, 336(%rsp)
        movq	%r9, 344(%rsp)
        movq	352(%rdx), %r8
        movq	360(%rdx), %r9
        andq	%rcx, %r8
        andq	%rcx, %r9
        movq	%r8, 352(%rsp)
        movq	%r9, 360(%rsp)
        movq	368(%rdx), %r8
        movq	376(%rdx), %r9
        andq	%rcx, %r8
        andq	%rcx, %r9
        movq	%r8, 368(%rsp)
        movq	%r9, 376(%rsp)
        movq	(%rsi), %r8
        movq	(%rsp), %rdx
        subq	%rdx, %r8
        movq	8(%rsi), %r9
        movq	8(%rsp), %rdx
        sbbq	%rdx, %r9
        movq	%r8, (%rdi)
        movq	16(%rsi), %r8
        movq	16(%rsp), %rdx
        sbbq	%rdx, %r8
        movq	%r9, 8(%rdi)
        movq	24(%rsi), %r9
        movq	24(%rsp), %rdx
        sbbq	%rdx, %r9
        movq	%r8, 16(%rdi)
        movq	32(%rsi), %r8
        movq	32(%rsp), %rdx
        sbbq	%rdx, %r8
        movq	%r9, 24(%rdi)
        movq	40(%rsi), %r9
        movq	40(%rsp), %rdx
        sbbq	%rdx, %r9
        movq	%r8, 32(%rdi)
        movq	48(%rsi), %r8
        movq	48(%rsp), %rdx
        sbbq	%rdx, %r8
        movq	%r9, 40(%rdi)
        movq	56(%rsi), %r9
        movq	56(%rsp), %rdx
        sbbq	%rdx, %r9
        movq	%r8, 48(%rdi)
        movq	64(%rsi), %r8
        movq	64(%rsp), %rdx
        sbbq	%rdx, %r8
        movq	%r9, 56(%rdi)
        movq	72(%rsi), %r9
        movq	72(%rsp), %rdx
        sbbq	%rdx, %r9
        movq	%r8, 64(%rdi)
        movq	80(%rsi), %r8
        movq	80(%rsp), %rdx
        sbbq	%rdx, %r8
        movq	%r9, 72(%rdi)
        movq	88(%rsi), %r9
        movq	88(%rsp), %rdx
        sbbq	%rdx, %r9
        movq	%r8, 80(%rdi)
        movq	96(%rsi), %r8
        movq	96(%rsp), %rdx
        sbbq	%rdx, %r8
        movq	%r9, 88(%rdi)
        movq	104(%rsi), %r9
        movq	104(%rsp), %rdx
        sbbq	%rdx, %r9
        movq	%r8, 96(%rdi)
        movq	112(%rsi), %r8
        movq	112(%rsp), %rdx
        sbbq	%rdx, %r8
        movq	%r9, 104(%rdi)
        movq	120(%rsi), %r9
        movq	120(%rsp), %rdx
        sbbq	%rdx, %r9
        movq	%r8, 112(%rdi)
        movq	128(%rsi), %r8
        movq	128(%rsp), %rdx
        sbbq	%rdx, %r8
        movq	%r9, 120(%rdi)
        movq	136(%rsi), %r9
        movq	136(%rsp), %rdx
        sbbq	%rdx, %r9
        movq	%r8, 128(%rdi)
        movq	144(%rsi), %r8
        movq	144(%rsp), %rdx
        sbbq	%rdx, %r8
        movq	%r9, 136(%rdi)
        movq	152(%rsi), %r9
        movq	152(%rsp), %rdx
        sbbq	%rdx, %r9
        movq	%r8, 144(%rdi)
        movq	160(%rsi), %r8
        movq	160(%rsp), %rdx
        sbbq	%rdx, %r8
        movq	%r9, 152(%rdi)
        movq	168(%rsi), %r9
        movq	168(%rsp), %rdx
        sbbq	%rdx, %r9
        movq	%r8, 160(%rdi)
        movq	176(%rsi), %r8
        movq	176(%rsp), %rdx
        sbbq	%rdx, %r8
        movq	%r9, 168(%rdi)
        movq	184(%rsi), %r9
        movq	184(%rsp), %rdx
        sbbq	%rdx, %r9
        movq	%r8, 176(%rdi)
        movq	192(%rsi), %r8
        movq	192(%rsp), %rdx
        sbbq	%rdx, %r8
        movq	%r9, 184(%rdi)
        movq	200(%rsi), %r9
        movq	200(%rsp), %rdx
        sbbq	%rdx, %r9
        movq	%r8, 192(%rdi)
        movq	208(%rsi), %r8
        movq	208(%rsp), %rdx
        sbbq	%rdx, %r8
        movq	%r9, 200(%rdi)
        movq	216(%rsi), %r9
        movq	216(%rsp), %rdx
        sbbq	%rdx, %r9
        movq	%r8, 208(%rdi)
        movq	224(%rsi), %r8
        movq	224(%rsp), %rdx
        sbbq	%rdx, %r8
        movq	%r9, 216(%rdi)
        movq	232(%rsi), %r9
        movq	232(%rsp), %rdx
        sbbq	%rdx, %r9
        movq	%r8, 224(%rdi)
        movq	240(%rsi), %r8
        movq	240(%rsp), %rdx
        sbbq	%rdx, %r8
        movq	%r9, 232(%rdi)
        movq	248(%rsi), %r9
        movq	248(%rsp), %rdx
        sbbq	%rdx, %r9
        movq	%r8, 240(%rdi)
        movq	256(%rsi), %r8
        movq	256(%rsp), %rdx
        sbbq	%rdx, %r8
        movq	%r9, 248(%rdi)
        movq	264(%rsi), %r9
        movq	264(%rsp), %rdx
        sbbq	%rdx, %r9
        movq	%r8, 256(%rdi)
        movq	272(%rsi), %r8
        movq	272(%rsp), %rdx
        sbbq	%rdx, %r8
        movq	%r9, 264(%rdi)
        movq	280(%rsi), %r9
        movq	280(%rsp), %rdx
        sbbq	%rdx, %r9
        movq	%r8, 272(%rdi)
        movq	288(%rsi), %r8
        movq	288(%rsp), %rdx
        sbbq	%rdx, %r8
        movq	%r9, 280(%rdi)
        movq	296(%rsi), %r9
        movq	296(%rsp), %rdx
        sbbq	%rdx, %r9
        movq	%r8, 288(%rdi)
        movq	304(%rsi), %r8
        movq	304(%rsp), %rdx
        sbbq	%rdx, %r8
        movq	%r9, 296(%rdi)
        movq	312(%rsi), %r9
        movq	312(%rsp), %rdx
        sbbq	%rdx, %r9
        movq	%r8, 304(%rdi)
        movq	320(%rsi), %r8
        movq	320(%rsp), %rdx
        sbbq	%rdx, %r8
        movq	%r9, 312(%rdi)
        movq	328(%rsi), %r9
        movq	328(%rsp), %rdx
        sbbq	%rdx, %r9
        movq	%r8, 320(%rdi)
        movq	336(%rsi), %r8
        movq	336(%rsp), %rdx
        sbbq	%rdx, %r8
        movq	%r9, 328(%rdi)
        movq	344(%rsi), %r9
        movq	344(%rsp), %rdx
        sbbq	%rdx, %r9
        movq	%r8, 336(%rdi)
        movq	352(%rsi), %r8
        movq	352(%rsp), %rdx
        sbbq	%rdx, %r8
        movq	%r9, 344(%rdi)
        movq	360(%rsi), %r9
        movq	360(%rsp), %rdx
        sbbq	%rdx, %r9
        movq	%r8, 352(%rdi)
        movq	368(%rsi), %r8
        movq	368(%rsp), %rdx
        sbbq	%rdx, %r8
        movq	%r9, 360(%rdi)
        movq	376(%rsi), %r9
        movq	376(%rsp), %rdx
        sbbq	%rdx, %r9
        movq	%r8, 368(%rdi)
        movq	%r9, 376(%rdi)
        sbbq	%rax, %rax
        addq	$0x180, %rsp
        repz retq
#ifndef __APPLE__
.size	sp_3072_cond_sub_48,.-sp_3072_cond_sub_48
#endif /* __APPLE__ */
/* Reduce the number back to 3072 bits using Montgomery reduction.
 *
 * a   A single precision number to reduce in place.
 * m   The single precision number representing the modulus.
 * mp  The digit representing the negative inverse of m mod 2^n.
 */
#ifndef __APPLE__
.text
.globl	sp_3072_mont_reduce_48
.type	sp_3072_mont_reduce_48,@function
.align	16
sp_3072_mont_reduce_48:
#else
.section	__TEXT,__text
.globl	_sp_3072_mont_reduce_48
.p2align	4
_sp_3072_mont_reduce_48:
#endif /* __APPLE__ */
        pushq	%r12
        pushq	%r13
        pushq	%r14
        pushq	%r15
        movq	%rdx, %rcx
        xorq	%r15, %r15
        # i = 48
        movq	$48, %r8
        movq	(%rdi), %r13
        movq	8(%rdi), %r14
L_3072_mont_reduce_48_loop:
        # mu = a[i] * mp
        movq	%r13, %r11
        imulq	%rcx, %r11
        # a[i+0] += m[0] * mu
        movq	%r11, %rax
        xorq	%r10, %r10
        mulq	(%rsi)
        addq	%rax, %r13
        adcq	%rdx, %r10
        # a[i+1] += m[1] * mu
        movq	%r11, %rax
        xorq	%r9, %r9
        mulq	8(%rsi)
        movq	%r14, %r13
        addq	%rax, %r13
        adcq	%rdx, %r9
        addq	%r10, %r13
        adcq	$0x00, %r9
        # a[i+2] += m[2] * mu
        movq	%r11, %rax
        xorq	%r10, %r10
        mulq	16(%rsi)
        movq	16(%rdi), %r14
        addq	%rax, %r14
        adcq	%rdx, %r10
        addq	%r9, %r14
        adcq	$0x00, %r10
        # a[i+3] += m[3] * mu
        movq	%r11, %rax
        xorq	%r9, %r9
        mulq	24(%rsi)
        movq	24(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r9
        addq	%r10, %r12
        movq	%r12, 24(%rdi)
        adcq	$0x00, %r9
        # a[i+4] += m[4] * mu
        movq	%r11, %rax
        xorq	%r10, %r10
        mulq	32(%rsi)
        movq	32(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r10
        addq	%r9, %r12
        movq	%r12, 32(%rdi)
        adcq	$0x00, %r10
        # a[i+5] += m[5] * mu
        movq	%r11, %rax
        xorq	%r9, %r9
        mulq	40(%rsi)
        movq	40(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r9
        addq	%r10, %r12
        movq	%r12, 40(%rdi)
        adcq	$0x00, %r9
        # a[i+6] += m[6] * mu
        movq	%r11, %rax
        xorq	%r10, %r10
        mulq	48(%rsi)
        movq	48(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r10
        addq	%r9, %r12
        movq	%r12, 48(%rdi)
        adcq	$0x00, %r10
        # a[i+7] += m[7] * mu
        movq	%r11, %rax
        xorq	%r9, %r9
        mulq	56(%rsi)
        movq	56(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r9
        addq	%r10, %r12
        movq	%r12, 56(%rdi)
        adcq	$0x00, %r9
        # a[i+8] += m[8] * mu
        movq	%r11, %rax
        xorq	%r10, %r10
        mulq	64(%rsi)
        movq	64(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r10
        addq	%r9, %r12
        movq	%r12, 64(%rdi)
        adcq	$0x00, %r10
        # a[i+9] += m[9] * mu
        movq	%r11, %rax
        xorq	%r9, %r9
        mulq	72(%rsi)
        movq	72(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r9
        addq	%r10, %r12
        movq	%r12, 72(%rdi)
        adcq	$0x00, %r9
        # a[i+10] += m[10] * mu
        movq	%r11, %rax
        xorq	%r10, %r10
        mulq	80(%rsi)
        movq	80(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r10
        addq	%r9, %r12
        movq	%r12, 80(%rdi)
        adcq	$0x00, %r10
        # a[i+11] += m[11] * mu
        movq	%r11, %rax
        xorq	%r9, %r9
        mulq	88(%rsi)
        movq	88(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r9
        addq	%r10, %r12
        movq	%r12, 88(%rdi)
        adcq	$0x00, %r9
        # a[i+12] += m[12] * mu
        movq	%r11, %rax
        xorq	%r10, %r10
        mulq	96(%rsi)
        movq	96(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r10
        addq	%r9, %r12
        movq	%r12, 96(%rdi)
        adcq	$0x00, %r10
        # a[i+13] += m[13] * mu
        movq	%r11, %rax
        xorq	%r9, %r9
        mulq	104(%rsi)
        movq	104(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r9
        addq	%r10, %r12
        movq	%r12, 104(%rdi)
        adcq	$0x00, %r9
        # a[i+14] += m[14] * mu
        movq	%r11, %rax
        xorq	%r10, %r10
        mulq	112(%rsi)
        movq	112(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r10
        addq	%r9, %r12
        movq	%r12, 112(%rdi)
        adcq	$0x00, %r10
        # a[i+15] += m[15] * mu
        movq	%r11, %rax
        xorq	%r9, %r9
        mulq	120(%rsi)
        movq	120(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r9
        addq	%r10, %r12
        movq	%r12, 120(%rdi)
        adcq	$0x00, %r9
        # a[i+16] += m[16] * mu
        movq	%r11, %rax
        xorq	%r10, %r10
        mulq	128(%rsi)
        movq	128(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r10
        addq	%r9, %r12
        movq	%r12, 128(%rdi)
        adcq	$0x00, %r10
        # a[i+17] += m[17] * mu
        movq	%r11, %rax
        xorq	%r9, %r9
        mulq	136(%rsi)
        movq	136(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r9
        addq	%r10, %r12
        movq	%r12, 136(%rdi)
        adcq	$0x00, %r9
        # a[i+18] += m[18] * mu
        movq	%r11, %rax
        xorq	%r10, %r10
        mulq	144(%rsi)
        movq	144(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r10
        addq	%r9, %r12
        movq	%r12, 144(%rdi)
        adcq	$0x00, %r10
        # a[i+19] += m[19] * mu
        movq	%r11, %rax
        xorq	%r9, %r9
        mulq	152(%rsi)
        movq	152(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r9
        addq	%r10, %r12
        movq	%r12, 152(%rdi)
        adcq	$0x00, %r9
        # a[i+20] += m[20] * mu
        movq	%r11, %rax
        xorq	%r10, %r10
        mulq	160(%rsi)
        movq	160(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r10
        addq	%r9, %r12
        movq	%r12, 160(%rdi)
        adcq	$0x00, %r10
        # a[i+21] += m[21] * mu
        movq	%r11, %rax
        xorq	%r9, %r9
        mulq	168(%rsi)
        movq	168(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r9
        addq	%r10, %r12
        movq	%r12, 168(%rdi)
        adcq	$0x00, %r9
        # a[i+22] += m[22] * mu
        movq	%r11, %rax
        xorq	%r10, %r10
        mulq	176(%rsi)
        movq	176(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r10
        addq	%r9, %r12
        movq	%r12, 176(%rdi)
        adcq	$0x00, %r10
        # a[i+23] += m[23] * mu
        movq	%r11, %rax
        xorq	%r9, %r9
        mulq	184(%rsi)
        movq	184(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r9
        addq	%r10, %r12
        movq	%r12, 184(%rdi)
        adcq	$0x00, %r9
        # a[i+24] += m[24] * mu
        movq	%r11, %rax
        xorq	%r10, %r10
        mulq	192(%rsi)
        movq	192(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r10
        addq	%r9, %r12
        movq	%r12, 192(%rdi)
        adcq	$0x00, %r10
        # a[i+25] += m[25] * mu
        movq	%r11, %rax
        xorq	%r9, %r9
        mulq	200(%rsi)
        movq	200(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r9
        addq	%r10, %r12
        movq	%r12, 200(%rdi)
        adcq	$0x00, %r9
        # a[i+26] += m[26] * mu
        movq	%r11, %rax
        xorq	%r10, %r10
        mulq	208(%rsi)
        movq	208(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r10
        addq	%r9, %r12
        movq	%r12, 208(%rdi)
        adcq	$0x00, %r10
        # a[i+27] += m[27] * mu
        movq	%r11, %rax
        xorq	%r9, %r9
        mulq	216(%rsi)
        movq	216(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r9
        addq	%r10, %r12
        movq	%r12, 216(%rdi)
        adcq	$0x00, %r9
        # a[i+28] += m[28] * mu
        movq	%r11, %rax
        xorq	%r10, %r10
        mulq	224(%rsi)
        movq	224(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r10
        addq	%r9, %r12
        movq	%r12, 224(%rdi)
        adcq	$0x00, %r10
        # a[i+29] += m[29] * mu
        movq	%r11, %rax
        xorq	%r9, %r9
        mulq	232(%rsi)
        movq	232(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r9
        addq	%r10, %r12
        movq	%r12, 232(%rdi)
        adcq	$0x00, %r9
        # a[i+30] += m[30] * mu
        movq	%r11, %rax
        xorq	%r10, %r10
        mulq	240(%rsi)
        movq	240(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r10
        addq	%r9, %r12
        movq	%r12, 240(%rdi)
        adcq	$0x00, %r10
        # a[i+31] += m[31] * mu
        movq	%r11, %rax
        xorq	%r9, %r9
        mulq	248(%rsi)
        movq	248(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r9
        addq	%r10, %r12
        movq	%r12, 248(%rdi)
        adcq	$0x00, %r9
        # a[i+32] += m[32] * mu
        movq	%r11, %rax
        xorq	%r10, %r10
        mulq	256(%rsi)
        movq	256(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r10
        addq	%r9, %r12
        movq	%r12, 256(%rdi)
        adcq	$0x00, %r10
        # a[i+33] += m[33] * mu
        movq	%r11, %rax
        xorq	%r9, %r9
        mulq	264(%rsi)
        movq	264(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r9
        addq	%r10, %r12
        movq	%r12, 264(%rdi)
        adcq	$0x00, %r9
        # a[i+34] += m[34] * mu
        movq	%r11, %rax
        xorq	%r10, %r10
        mulq	272(%rsi)
        movq	272(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r10
        addq	%r9, %r12
        movq	%r12, 272(%rdi)
        adcq	$0x00, %r10
        # a[i+35] += m[35] * mu
        movq	%r11, %rax
        xorq	%r9, %r9
        mulq	280(%rsi)
        movq	280(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r9
        addq	%r10, %r12
        movq	%r12, 280(%rdi)
        adcq	$0x00, %r9
        # a[i+36] += m[36] * mu
        movq	%r11, %rax
        xorq	%r10, %r10
        mulq	288(%rsi)
        movq	288(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r10
        addq	%r9, %r12
        movq	%r12, 288(%rdi)
        adcq	$0x00, %r10
        # a[i+37] += m[37] * mu
        movq	%r11, %rax
        xorq	%r9, %r9
        mulq	296(%rsi)
        movq	296(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r9
        addq	%r10, %r12
        movq	%r12, 296(%rdi)
        adcq	$0x00, %r9
        # a[i+38] += m[38] * mu
        movq	%r11, %rax
        xorq	%r10, %r10
        mulq	304(%rsi)
        movq	304(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r10
        addq	%r9, %r12
        movq	%r12, 304(%rdi)
        adcq	$0x00, %r10
        # a[i+39] += m[39] * mu
        movq	%r11, %rax
        xorq	%r9, %r9
        mulq	312(%rsi)
        movq	312(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r9
        addq	%r10, %r12
        movq	%r12, 312(%rdi)
        adcq	$0x00, %r9
        # a[i+40] += m[40] * mu
        movq	%r11, %rax
        xorq	%r10, %r10
        mulq	320(%rsi)
        movq	320(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r10
        addq	%r9, %r12
        movq	%r12, 320(%rdi)
        adcq	$0x00, %r10
        # a[i+41] += m[41] * mu
        movq	%r11, %rax
        xorq	%r9, %r9
        mulq	328(%rsi)
        movq	328(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r9
        addq	%r10, %r12
        movq	%r12, 328(%rdi)
        adcq	$0x00, %r9
        # a[i+42] += m[42] * mu
        movq	%r11, %rax
        xorq	%r10, %r10
        mulq	336(%rsi)
        movq	336(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r10
        addq	%r9, %r12
        movq	%r12, 336(%rdi)
        adcq	$0x00, %r10
        # a[i+43] += m[43] * mu
        movq	%r11, %rax
        xorq	%r9, %r9
        mulq	344(%rsi)
        movq	344(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r9
        addq	%r10, %r12
        movq	%r12, 344(%rdi)
        adcq	$0x00, %r9
        # a[i+44] += m[44] * mu
        movq	%r11, %rax
        xorq	%r10, %r10
        mulq	352(%rsi)
        movq	352(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r10
        addq	%r9, %r12
        movq	%r12, 352(%rdi)
        adcq	$0x00, %r10
        # a[i+45] += m[45] * mu
        movq	%r11, %rax
        xorq	%r9, %r9
        mulq	360(%rsi)
        movq	360(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r9
        addq	%r10, %r12
        movq	%r12, 360(%rdi)
        adcq	$0x00, %r9
        # a[i+46] += m[46] * mu
        movq	%r11, %rax
        xorq	%r10, %r10
        mulq	368(%rsi)
        movq	368(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r10
        addq	%r9, %r12
        movq	%r12, 368(%rdi)
        adcq	$0x00, %r10
        # a[i+47] += m[47] * mu
        movq	%r11, %rax
        mulq	376(%rsi)
        movq	376(%rdi), %r12
        addq	%rax, %r10
        adcq	%r15, %rdx
        movq	$0x00, %r15
        adcq	$0x00, %r15
        addq	%r10, %r12
        movq	%r12, 376(%rdi)
        adcq	%rdx, 384(%rdi)
        adcq	$0x00, %r15
        # i -= 1
        addq	$8, %rdi
        decq	%r8
        jnz	L_3072_mont_reduce_48_loop
        movq	%r13, (%rdi)
        movq	%r14, 8(%rdi)
        negq	%r15
#ifdef _WIN64
        movq	%rsi, %rdx
        movq	%r15, %rcx
#else
        movq	%r15, %rcx
        movq	%rsi, %rdx
#endif /* _WIN64 */
        movq	%rdi, %rsi
        movq	%rdi, %rdi
        subq	$0x180, %rdi
#ifndef __APPLE__
        callq	sp_3072_cond_sub_48@plt
#else
        callq	_sp_3072_cond_sub_48
#endif /* __APPLE__ */
        popq	%r15
        popq	%r14
        popq	%r13
        popq	%r12
        repz retq
#ifndef __APPLE__
.size	sp_3072_mont_reduce_48,.-sp_3072_mont_reduce_48
#endif /* __APPLE__ */
/* Sub b from a into r. (r = a - b)
 *
 * r  A single precision integer.
 * a  A single precision integer.
 * b  A single precision integer.
 */
#ifndef __APPLE__
.text
.globl	sp_3072_sub_48
.type	sp_3072_sub_48,@function
.align	16
sp_3072_sub_48:
#else
.section	__TEXT,__text
.globl	_sp_3072_sub_48
.p2align	4
_sp_3072_sub_48:
#endif /* __APPLE__ */
        movq	(%rsi), %rcx
        subq	(%rdx), %rcx
        movq	8(%rsi), %r8
        movq	%rcx, (%rdi)
        sbbq	8(%rdx), %r8
        movq	16(%rsi), %rcx
        movq	%r8, 8(%rdi)
        sbbq	16(%rdx), %rcx
        movq	24(%rsi), %r8
        movq	%rcx, 16(%rdi)
        sbbq	24(%rdx), %r8
        movq	32(%rsi), %rcx
        movq	%r8, 24(%rdi)
        sbbq	32(%rdx), %rcx
        movq	40(%rsi), %r8
        movq	%rcx, 32(%rdi)
        sbbq	40(%rdx), %r8
        movq	48(%rsi), %rcx
        movq	%r8, 40(%rdi)
        sbbq	48(%rdx), %rcx
        movq	56(%rsi), %r8
        movq	%rcx, 48(%rdi)
        sbbq	56(%rdx), %r8
        movq	64(%rsi), %rcx
        movq	%r8, 56(%rdi)
        sbbq	64(%rdx), %rcx
        movq	72(%rsi), %r8
        movq	%rcx, 64(%rdi)
        sbbq	72(%rdx), %r8
        movq	80(%rsi), %rcx
        movq	%r8, 72(%rdi)
        sbbq	80(%rdx), %rcx
        movq	88(%rsi), %r8
        movq	%rcx, 80(%rdi)
        sbbq	88(%rdx), %r8
        movq	96(%rsi), %rcx
        movq	%r8, 88(%rdi)
        sbbq	96(%rdx), %rcx
        movq	104(%rsi), %r8
        movq	%rcx, 96(%rdi)
        sbbq	104(%rdx), %r8
        movq	112(%rsi), %rcx
        movq	%r8, 104(%rdi)
        sbbq	112(%rdx), %rcx
        movq	120(%rsi), %r8
        movq	%rcx, 112(%rdi)
        sbbq	120(%rdx), %r8
        movq	128(%rsi), %rcx
        movq	%r8, 120(%rdi)
        sbbq	128(%rdx), %rcx
        movq	136(%rsi), %r8
        movq	%rcx, 128(%rdi)
        sbbq	136(%rdx), %r8
        movq	144(%rsi), %rcx
        movq	%r8, 136(%rdi)
        sbbq	144(%rdx), %rcx
        movq	152(%rsi), %r8
        movq	%rcx, 144(%rdi)
        sbbq	152(%rdx), %r8
        movq	160(%rsi), %rcx
        movq	%r8, 152(%rdi)
        sbbq	160(%rdx), %rcx
        movq	168(%rsi), %r8
        movq	%rcx, 160(%rdi)
        sbbq	168(%rdx), %r8
        movq	176(%rsi), %rcx
        movq	%r8, 168(%rdi)
        sbbq	176(%rdx), %rcx
        movq	184(%rsi), %r8
        movq	%rcx, 176(%rdi)
        sbbq	184(%rdx), %r8
        movq	192(%rsi), %rcx
        movq	%r8, 184(%rdi)
        sbbq	192(%rdx), %rcx
        movq	200(%rsi), %r8
        movq	%rcx, 192(%rdi)
        sbbq	200(%rdx), %r8
        movq	208(%rsi), %rcx
        movq	%r8, 200(%rdi)
        sbbq	208(%rdx), %rcx
        movq	216(%rsi), %r8
        movq	%rcx, 208(%rdi)
        sbbq	216(%rdx), %r8
        movq	224(%rsi), %rcx
        movq	%r8, 216(%rdi)
        sbbq	224(%rdx), %rcx
        movq	232(%rsi), %r8
        movq	%rcx, 224(%rdi)
        sbbq	232(%rdx), %r8
        movq	240(%rsi), %rcx
        movq	%r8, 232(%rdi)
        sbbq	240(%rdx), %rcx
        movq	248(%rsi), %r8
        movq	%rcx, 240(%rdi)
        sbbq	248(%rdx), %r8
        movq	256(%rsi), %rcx
        movq	%r8, 248(%rdi)
        sbbq	256(%rdx), %rcx
        movq	264(%rsi), %r8
        movq	%rcx, 256(%rdi)
        sbbq	264(%rdx), %r8
        movq	272(%rsi), %rcx
        movq	%r8, 264(%rdi)
        sbbq	272(%rdx), %rcx
        movq	280(%rsi), %r8
        movq	%rcx, 272(%rdi)
        sbbq	280(%rdx), %r8
        movq	288(%rsi), %rcx
        movq	%r8, 280(%rdi)
        sbbq	288(%rdx), %rcx
        movq	296(%rsi), %r8
        movq	%rcx, 288(%rdi)
        sbbq	296(%rdx), %r8
        movq	304(%rsi), %rcx
        movq	%r8, 296(%rdi)
        sbbq	304(%rdx), %rcx
        movq	312(%rsi), %r8
        movq	%rcx, 304(%rdi)
        sbbq	312(%rdx), %r8
        movq	320(%rsi), %rcx
        movq	%r8, 312(%rdi)
        sbbq	320(%rdx), %rcx
        movq	328(%rsi), %r8
        movq	%rcx, 320(%rdi)
        sbbq	328(%rdx), %r8
        movq	336(%rsi), %rcx
        movq	%r8, 328(%rdi)
        sbbq	336(%rdx), %rcx
        movq	344(%rsi), %r8
        movq	%rcx, 336(%rdi)
        sbbq	344(%rdx), %r8
        movq	352(%rsi), %rcx
        movq	%r8, 344(%rdi)
        sbbq	352(%rdx), %rcx
        movq	360(%rsi), %r8
        movq	%rcx, 352(%rdi)
        sbbq	360(%rdx), %r8
        movq	368(%rsi), %rcx
        movq	%r8, 360(%rdi)
        sbbq	368(%rdx), %rcx
        movq	376(%rsi), %r8
        movq	%rcx, 368(%rdi)
        sbbq	376(%rdx), %r8
        movq	%r8, 376(%rdi)
        sbbq	%rax, %rax
        repz retq
#ifndef __APPLE__
.size	sp_3072_sub_48,.-sp_3072_sub_48
#endif /* __APPLE__ */
#ifdef HAVE_INTEL_AVX2
/* Mul a by digit b into r. (r = a * b)
 *
 * r  A single precision integer.
 * a  A single precision integer.
 * b  A single precision digit.
 */
#ifndef __APPLE__
.text
.globl	sp_3072_mul_d_avx2_48
.type	sp_3072_mul_d_avx2_48,@function
.align	16
sp_3072_mul_d_avx2_48:
#else
.section	__TEXT,__text
.globl	_sp_3072_mul_d_avx2_48
.p2align	4
_sp_3072_mul_d_avx2_48:
#endif /* __APPLE__ */
        movq	%rdx, %rax
        # A[0] * B
        movq	%rax, %rdx
        xorq	%r11, %r11
        mulxq	(%rsi), %r9, %r10
        movq	%r9, (%rdi)
        # A[1] * B
        mulxq	8(%rsi), %rcx, %r8
        movq	%r11, %r9
        adcxq	%rcx, %r10
        adoxq	%r8, %r9
        movq	%r10, 8(%rdi)
        # A[2] * B
        mulxq	16(%rsi), %rcx, %r8
        movq	%r11, %r10
        adcxq	%rcx, %r9
        adoxq	%r8, %r10
        movq	%r9, 16(%rdi)
        # A[3] * B
        mulxq	24(%rsi), %rcx, %r8
        movq	%r11, %r9
        adcxq	%rcx, %r10
        adoxq	%r8, %r9
        movq	%r10, 24(%rdi)
        # A[4] * B
        mulxq	32(%rsi), %rcx, %r8
        movq	%r11, %r10
        adcxq	%rcx, %r9
        adoxq	%r8, %r10
        movq	%r9, 32(%rdi)
        # A[5] * B
        mulxq	40(%rsi), %rcx, %r8
        movq	%r11, %r9
        adcxq	%rcx, %r10
        adoxq	%r8, %r9
        movq	%r10, 40(%rdi)
        # A[6] * B
        mulxq	48(%rsi), %rcx, %r8
        movq	%r11, %r10
        adcxq	%rcx, %r9
        adoxq	%r8, %r10
        movq	%r9, 48(%rdi)
        # A[7] * B
        mulxq	56(%rsi), %rcx, %r8
        movq	%r11, %r9
        adcxq	%rcx, %r10
        adoxq	%r8, %r9
        movq	%r10, 56(%rdi)
        # A[8] * B
        mulxq	64(%rsi), %rcx, %r8
        movq	%r11, %r10
        adcxq	%rcx, %r9
        adoxq	%r8, %r10
        movq	%r9, 64(%rdi)
        # A[9] * B
        mulxq	72(%rsi), %rcx, %r8
        movq	%r11, %r9
        adcxq	%rcx, %r10
        adoxq	%r8, %r9
        movq	%r10, 72(%rdi)
        # A[10] * B
        mulxq	80(%rsi), %rcx, %r8
        movq	%r11, %r10
        adcxq	%rcx, %r9
        adoxq	%r8, %r10
        movq	%r9, 80(%rdi)
        # A[11] * B
        mulxq	88(%rsi), %rcx, %r8
        movq	%r11, %r9
        adcxq	%rcx, %r10
        adoxq	%r8, %r9
        movq	%r10, 88(%rdi)
        # A[12] * B
        mulxq	96(%rsi), %rcx, %r8
        movq	%r11, %r10
        adcxq	%rcx, %r9
        adoxq	%r8, %r10
        movq	%r9, 96(%rdi)
        # A[13] * B
        mulxq	104(%rsi), %rcx, %r8
        movq	%r11, %r9
        adcxq	%rcx, %r10
        adoxq	%r8, %r9
        movq	%r10, 104(%rdi)
        # A[14] * B
        mulxq	112(%rsi), %rcx, %r8
        movq	%r11, %r10
        adcxq	%rcx, %r9
        adoxq	%r8, %r10
        movq	%r9, 112(%rdi)
        # A[15] * B
        mulxq	120(%rsi), %rcx, %r8
        movq	%r11, %r9
        adcxq	%rcx, %r10
        adoxq	%r8, %r9
        movq	%r10, 120(%rdi)
        # A[16] * B
        mulxq	128(%rsi), %rcx, %r8
        movq	%r11, %r10
        adcxq	%rcx, %r9
        adoxq	%r8, %r10
        movq	%r9, 128(%rdi)
        # A[17] * B
        mulxq	136(%rsi), %rcx, %r8
        movq	%r11, %r9
        adcxq	%rcx, %r10
        adoxq	%r8, %r9
        movq	%r10, 136(%rdi)
        # A[18] * B
        mulxq	144(%rsi), %rcx, %r8
        movq	%r11, %r10
        adcxq	%rcx, %r9
        adoxq	%r8, %r10
        movq	%r9, 144(%rdi)
        # A[19] * B
        mulxq	152(%rsi), %rcx, %r8
        movq	%r11, %r9
        adcxq	%rcx, %r10
        adoxq	%r8, %r9
        movq	%r10, 152(%rdi)
        # A[20] * B
        mulxq	160(%rsi), %rcx, %r8
        movq	%r11, %r10
        adcxq	%rcx, %r9
        adoxq	%r8, %r10
        movq	%r9, 160(%rdi)
        # A[21] * B
        mulxq	168(%rsi), %rcx, %r8
        movq	%r11, %r9
        adcxq	%rcx, %r10
        adoxq	%r8, %r9
        movq	%r10, 168(%rdi)
        # A[22] * B
        mulxq	176(%rsi), %rcx, %r8
        movq	%r11, %r10
        adcxq	%rcx, %r9
        adoxq	%r8, %r10
        movq	%r9, 176(%rdi)
        # A[23] * B
        mulxq	184(%rsi), %rcx, %r8
        movq	%r11, %r9
        adcxq	%rcx, %r10
        adoxq	%r8, %r9
        movq	%r10, 184(%rdi)
        # A[24] * B
        mulxq	192(%rsi), %rcx, %r8
        movq	%r11, %r10
        adcxq	%rcx, %r9
        adoxq	%r8, %r10
        movq	%r9, 192(%rdi)
        # A[25] * B
        mulxq	200(%rsi), %rcx, %r8
        movq	%r11, %r9
        adcxq	%rcx, %r10
        adoxq	%r8, %r9
        movq	%r10, 200(%rdi)
        # A[26] * B
        mulxq	208(%rsi), %rcx, %r8
        movq	%r11, %r10
        adcxq	%rcx, %r9
        adoxq	%r8, %r10
        movq	%r9, 208(%rdi)
        # A[27] * B
        mulxq	216(%rsi), %rcx, %r8
        movq	%r11, %r9
        adcxq	%rcx, %r10
        adoxq	%r8, %r9
        movq	%r10, 216(%rdi)
        # A[28] * B
        mulxq	224(%rsi), %rcx, %r8
        movq	%r11, %r10
        adcxq	%rcx, %r9
        adoxq	%r8, %r10
        movq	%r9, 224(%rdi)
        # A[29] * B
        mulxq	232(%rsi), %rcx, %r8
        movq	%r11, %r9
        adcxq	%rcx, %r10
        adoxq	%r8, %r9
        movq	%r10, 232(%rdi)
        # A[30] * B
        mulxq	240(%rsi), %rcx, %r8
        movq	%r11, %r10
        adcxq	%rcx, %r9
        adoxq	%r8, %r10
        movq	%r9, 240(%rdi)
        # A[31] * B
        mulxq	248(%rsi), %rcx, %r8
        movq	%r11, %r9
        adcxq	%rcx, %r10
        adoxq	%r8, %r9
        movq	%r10, 248(%rdi)
        # A[32] * B
        mulxq	256(%rsi), %rcx, %r8
        movq	%r11, %r10
        adcxq	%rcx, %r9
        adoxq	%r8, %r10
        movq	%r9, 256(%rdi)
        # A[33] * B
        mulxq	264(%rsi), %rcx, %r8
        movq	%r11, %r9
        adcxq	%rcx, %r10
        adoxq	%r8, %r9
        movq	%r10, 264(%rdi)
        # A[34] * B
        mulxq	272(%rsi), %rcx, %r8
        movq	%r11, %r10
        adcxq	%rcx, %r9
        adoxq	%r8, %r10
        movq	%r9, 272(%rdi)
        # A[35] * B
        mulxq	280(%rsi), %rcx, %r8
        movq	%r11, %r9
        adcxq	%rcx, %r10
        adoxq	%r8, %r9
        movq	%r10, 280(%rdi)
        # A[36] * B
        mulxq	288(%rsi), %rcx, %r8
        movq	%r11, %r10
        adcxq	%rcx, %r9
        adoxq	%r8, %r10
        movq	%r9, 288(%rdi)
        # A[37] * B
        mulxq	296(%rsi), %rcx, %r8
        movq	%r11, %r9
        adcxq	%rcx, %r10
        adoxq	%r8, %r9
        movq	%r10, 296(%rdi)
        # A[38] * B
        mulxq	304(%rsi), %rcx, %r8
        movq	%r11, %r10
        adcxq	%rcx, %r9
        adoxq	%r8, %r10
        movq	%r9, 304(%rdi)
        # A[39] * B
        mulxq	312(%rsi), %rcx, %r8
        movq	%r11, %r9
        adcxq	%rcx, %r10
        adoxq	%r8, %r9
        movq	%r10, 312(%rdi)
        # A[40] * B
        mulxq	320(%rsi), %rcx, %r8
        movq	%r11, %r10
        adcxq	%rcx, %r9
        adoxq	%r8, %r10
        movq	%r9, 320(%rdi)
        # A[41] * B
        mulxq	328(%rsi), %rcx, %r8
        movq	%r11, %r9
        adcxq	%rcx, %r10
        adoxq	%r8, %r9
        movq	%r10, 328(%rdi)
        # A[42] * B
        mulxq	336(%rsi), %rcx, %r8
        movq	%r11, %r10
        adcxq	%rcx, %r9
        adoxq	%r8, %r10
        movq	%r9, 336(%rdi)
        # A[43] * B
        mulxq	344(%rsi), %rcx, %r8
        movq	%r11, %r9
        adcxq	%rcx, %r10
        adoxq	%r8, %r9
        movq	%r10, 344(%rdi)
        # A[44] * B
        mulxq	352(%rsi), %rcx, %r8
        movq	%r11, %r10
        adcxq	%rcx, %r9
        adoxq	%r8, %r10
        movq	%r9, 352(%rdi)
        # A[45] * B
        mulxq	360(%rsi), %rcx, %r8
        movq	%r11, %r9
        adcxq	%rcx, %r10
        adoxq	%r8, %r9
        movq	%r10, 360(%rdi)
        # A[46] * B
        mulxq	368(%rsi), %rcx, %r8
        movq	%r11, %r10
        adcxq	%rcx, %r9
        adoxq	%r8, %r10
        movq	%r9, 368(%rdi)
        # A[47] * B
        mulxq	376(%rsi), %rcx, %r8
        movq	%r11, %r9
        adcxq	%rcx, %r10
        adoxq	%r8, %r9
        adcxq	%r11, %r9
        movq	%r10, 376(%rdi)
        movq	%r9, 384(%rdi)
        repz retq
#ifndef __APPLE__
.size	sp_3072_mul_d_avx2_48,.-sp_3072_mul_d_avx2_48
#endif /* __APPLE__ */
#endif /* HAVE_INTEL_AVX2 */
#ifdef _WIN64
/* Divide the double width number (d1|d0) by the dividend. (d1|d0 / div)
 *
 * d1   The high order half of the number to divide.
 * d0   The low order half of the number to divide.
 * div  The dividend.
 * returns the result of the division.
 */
#ifndef __APPLE__
.text
.globl	div_3072_word_asm_48
.type	div_3072_word_asm_48,@function
.align	16
div_3072_word_asm_48:
#else
.section	__TEXT,__text
.globl	_div_3072_word_asm_48
.p2align	4
_div_3072_word_asm_48:
#endif /* __APPLE__ */
        movq	%rdx, %rcx
        movq	%rsi, %rax
        movq	%rdi, %rdx
        divq	%rcx
        repz retq
#ifndef __APPLE__
.size	div_3072_word_asm_48,.-div_3072_word_asm_48
#endif /* __APPLE__ */
#endif /* _WIN64 */
#ifdef HAVE_INTEL_AVX2
/* Conditionally subtract b from a using the mask m.
 * m is -1 to subtract and 0 when not copying.
 *
 * r  A single precision number representing condition subtract result.
 * a  A single precision number to subtract from.
 * b  A single precision number to subtract.
 * m  Mask value to apply.
 */
#ifndef __APPLE__
.text
.globl	sp_3072_cond_sub_avx2_48
.type	sp_3072_cond_sub_avx2_48,@function
.align	16
sp_3072_cond_sub_avx2_48:
#else
.section	__TEXT,__text
.globl	_sp_3072_cond_sub_avx2_48
.p2align	4
_sp_3072_cond_sub_avx2_48:
#endif /* __APPLE__ */
        movq	(%rdx), %r10
        movq	(%rsi), %r8
        pextq	%rcx, %r10, %r10
        subq	%r10, %r8
        movq	8(%rdx), %r10
        movq	8(%rsi), %r9
        pextq	%rcx, %r10, %r10
        movq	%r8, (%rdi)
        sbbq	%r10, %r9
        movq	16(%rdx), %r8
        movq	16(%rsi), %r10
        pextq	%rcx, %r8, %r8
        movq	%r9, 8(%rdi)
        sbbq	%r8, %r10
        movq	24(%rdx), %r9
        movq	24(%rsi), %r8
        pextq	%rcx, %r9, %r9
        movq	%r10, 16(%rdi)
        sbbq	%r9, %r8
        movq	32(%rdx), %r10
        movq	32(%rsi), %r9
        pextq	%rcx, %r10, %r10
        movq	%r8, 24(%rdi)
        sbbq	%r10, %r9
        movq	40(%rdx), %r8
        movq	40(%rsi), %r10
        pextq	%rcx, %r8, %r8
        movq	%r9, 32(%rdi)
        sbbq	%r8, %r10
        movq	48(%rdx), %r9
        movq	48(%rsi), %r8
        pextq	%rcx, %r9, %r9
        movq	%r10, 40(%rdi)
        sbbq	%r9, %r8
        movq	56(%rdx), %r10
        movq	56(%rsi), %r9
        pextq	%rcx, %r10, %r10
        movq	%r8, 48(%rdi)
        sbbq	%r10, %r9
        movq	64(%rdx), %r8
        movq	64(%rsi), %r10
        pextq	%rcx, %r8, %r8
        movq	%r9, 56(%rdi)
        sbbq	%r8, %r10
        movq	72(%rdx), %r9
        movq	72(%rsi), %r8
        pextq	%rcx, %r9, %r9
        movq	%r10, 64(%rdi)
        sbbq	%r9, %r8
        movq	80(%rdx), %r10
        movq	80(%rsi), %r9
        pextq	%rcx, %r10, %r10
        movq	%r8, 72(%rdi)
        sbbq	%r10, %r9
        movq	88(%rdx), %r8
        movq	88(%rsi), %r10
        pextq	%rcx, %r8, %r8
        movq	%r9, 80(%rdi)
        sbbq	%r8, %r10
        movq	96(%rdx), %r9
        movq	96(%rsi), %r8
        pextq	%rcx, %r9, %r9
        movq	%r10, 88(%rdi)
        sbbq	%r9, %r8
        movq	104(%rdx), %r10
        movq	104(%rsi), %r9
        pextq	%rcx, %r10, %r10
        movq	%r8, 96(%rdi)
        sbbq	%r10, %r9
        movq	112(%rdx), %r8
        movq	112(%rsi), %r10
        pextq	%rcx, %r8, %r8
        movq	%r9, 104(%rdi)
        sbbq	%r8, %r10
        movq	120(%rdx), %r9
        movq	120(%rsi), %r8
        pextq	%rcx, %r9, %r9
        movq	%r10, 112(%rdi)
        sbbq	%r9, %r8
        movq	128(%rdx), %r10
        movq	128(%rsi), %r9
        pextq	%rcx, %r10, %r10
        movq	%r8, 120(%rdi)
        sbbq	%r10, %r9
        movq	136(%rdx), %r8
        movq	136(%rsi), %r10
        pextq	%rcx, %r8, %r8
        movq	%r9, 128(%rdi)
        sbbq	%r8, %r10
        movq	144(%rdx), %r9
        movq	144(%rsi), %r8
        pextq	%rcx, %r9, %r9
        movq	%r10, 136(%rdi)
        sbbq	%r9, %r8
        movq	152(%rdx), %r10
        movq	152(%rsi), %r9
        pextq	%rcx, %r10, %r10
        movq	%r8, 144(%rdi)
        sbbq	%r10, %r9
        movq	160(%rdx), %r8
        movq	160(%rsi), %r10
        pextq	%rcx, %r8, %r8
        movq	%r9, 152(%rdi)
        sbbq	%r8, %r10
        movq	168(%rdx), %r9
        movq	168(%rsi), %r8
        pextq	%rcx, %r9, %r9
        movq	%r10, 160(%rdi)
        sbbq	%r9, %r8
        movq	176(%rdx), %r10
        movq	176(%rsi), %r9
        pextq	%rcx, %r10, %r10
        movq	%r8, 168(%rdi)
        sbbq	%r10, %r9
        movq	184(%rdx), %r8
        movq	184(%rsi), %r10
        pextq	%rcx, %r8, %r8
        movq	%r9, 176(%rdi)
        sbbq	%r8, %r10
        movq	192(%rdx), %r9
        movq	192(%rsi), %r8
        pextq	%rcx, %r9, %r9
        movq	%r10, 184(%rdi)
        sbbq	%r9, %r8
        movq	200(%rdx), %r10
        movq	200(%rsi), %r9
        pextq	%rcx, %r10, %r10
        movq	%r8, 192(%rdi)
        sbbq	%r10, %r9
        movq	208(%rdx), %r8
        movq	208(%rsi), %r10
        pextq	%rcx, %r8, %r8
        movq	%r9, 200(%rdi)
        sbbq	%r8, %r10
        movq	216(%rdx), %r9
        movq	216(%rsi), %r8
        pextq	%rcx, %r9, %r9
        movq	%r10, 208(%rdi)
        sbbq	%r9, %r8
        movq	224(%rdx), %r10
        movq	224(%rsi), %r9
        pextq	%rcx, %r10, %r10
        movq	%r8, 216(%rdi)
        sbbq	%r10, %r9
        movq	232(%rdx), %r8
        movq	232(%rsi), %r10
        pextq	%rcx, %r8, %r8
        movq	%r9, 224(%rdi)
        sbbq	%r8, %r10
        movq	240(%rdx), %r9
        movq	240(%rsi), %r8
        pextq	%rcx, %r9, %r9
        movq	%r10, 232(%rdi)
        sbbq	%r9, %r8
        movq	248(%rdx), %r10
        movq	248(%rsi), %r9
        pextq	%rcx, %r10, %r10
        movq	%r8, 240(%rdi)
        sbbq	%r10, %r9
        movq	256(%rdx), %r8
        movq	256(%rsi), %r10
        pextq	%rcx, %r8, %r8
        movq	%r9, 248(%rdi)
        sbbq	%r8, %r10
        movq	264(%rdx), %r9
        movq	264(%rsi), %r8
        pextq	%